.TH XDBX 1 "10 February 1989" "X Version 11"
.SH NAME
xdbx \- X window interface to the dbx debugger.
.SH SYNOPSIS
.B xdbx
[ \fI-toolkitoption ... \fP] [\fI-dbxoption ... \fP] [\fIobjfile\fP 
[ \fIcorefile\fP ]]
.SH DESCRIPTION
\fIXdbx\fP is a graphical interface to the \fIdbx\fP debugger under the
X Window System.  It provides visual feedback and mouse input for the
user to examine program execution, set and remove breakpoints, examine
variables and data structures, and browse source files and functions.
.LP
\fIXdbx\fP supports both Berkeley dbx and Sun dbx.  Sun dbx is an
extended and debugged version of Berkeley dbx.
.LP
\fIXdbx\fP allows initial dbx commands stored in the file
\fI.dbxinit\fP to be executed immediately after the symbolic
information is read.  If \fI.dbxinit\fP does not exist in the current
directory, the user's home directory is searched (\fI~/.dbxinit\fP).
.LP
\fIObjfile\fP is an object file produced by a compiler with the
appropriate option (\fB\-g\fP) specified to produce symbol table
information for dbx.  For Sun dbx, if no \fIobjfile\fP is specified,
the \fBdebug\fP command can be used later to specify the program to be
debugged.
.LP
If a file named \fIcore\fP exists in the current directory or a
\fIcorefile\fP is specified, \fIxdbx\fP can be used to examine the
state of the program when the core dump occurred.
.LP
The name of the debugger invoked by \fIxdbx\fP is, by default, dbx, but
it can be overridden with the environment variable DEBUGGER.
.SH OPTIONS
\fIXdbx\fP accepts all of the standard X Toolkit command line options 
(see \fIX\fP(1)), and all the dbx options (see \fIdbx\fP(1)).  
.SH SUBWINDOWS
\fIXdbx\fP consists of the following subwindows:
.IP "Title Bar" 20
Display the current version of \fIxdbx\fP (optional).
.IP "File Window"
Display the full pathname of the file displayed in the source window,
and the line number of the caret.
.IP "Source Window"
Display the contents of a source file.
.IP "Message Window"
Display the execution status and error messages of \fIxdbx\fP .
.IP "Command Window"
Provide a list of the common dbx commands which are invoked by simply
clicking the LEFT mouse button.
.IP "Dialog Window"
Provide a typing interface to dbx.
.LP
The relative sizes of the source window, command window, and the dialog
window can be adjusted by dragging the grip (a small square near the
right edge of a horizontal border) with the LEFT mouse button down.
.SH SELECTION
To select some text, click the LEFT mouse button at the starting position, 
then click the RIGHT mouse button at the ending position.  The selected text 
is highlighted in reverse-video.  It can be pasted into the dialog window
by clicking the MIDDLE mouse button or unselected by the LEFT mouse button.
.LP
Double clicking the LEFT mouse button with the SHIFT key down selects a
C expression or function name.  (The default double click behavior in
the Athena text widget selects a string delimited by white space.)
Also, clicking the LEFT mouse button in the source window places the
caret at that line, and updates the line label accordingly.
.SH SCROLLBAR
Pressing the LEFT mouse button scrolls the text forward, whereas
pressing the RIGHT mouse button scrolls the text backward.  The amount
of scrolling depends on the distance of the pointer button away from
the top of the scrollbar.  If the button is pressed at the top of the
scrollbar, only one line of text is scrolled.  If the button is pressed
at the bottom of the scrollbar, one screenful of text is scrolled.
.LP
Pressing the MIDDLE mouse button changes the thumb position of the
scrollbar.  Dragging the MIDDLE mouse button down moves the thumb along
and changes the text displayed.
.SH COMMAND BUTTONS
.SS "Execution Commands"
.IP "\fBrun\fP" 12
Begin program execution.
.IP "\fBcont\fP"
Continue execution from where it stopped.
.IP "\fBstep\fP"
Execute one source line, stepping into a function if the source line
contains a function call.
.IP "\fBnext\fP"
Execute one source line, without stepping into any function call.
.IP "\fBreturn\fP"
(For Berkeley dbx only) Continue execution until the selected procedure
returns; the current procedure is used if none is selected.

.LP
.SS "Breakpoint Commands"
.IP "\fBstop at\fP" 10
Stop program execution at the line selected.  To set a breakpoint in
the program, place the caret on the source line and click the \fBstop
at\fP button.  A stop sign will appear next to the source line.
.IP "\fBstop in\fP"
Stop program execution in the function selected.  To set a breakpoint
in a function, select the function name and click the \fBstop in\fP
button.  A stop sign will be placed near the first executable line of
the function.
.IP "\fBdelete\fP"
Remove the breakpoint on the source line selected.  The stop sign will
disappear.
.IP "\fBstatus\fP"
Show the current breakpoints and traces.

.LP
.SS "Stack Commands"
.IP "\fBwhere\fP" 10
Show a stack trace of the functions called.
.IP "\fBup\fP"
Move up one level on the stack.
.IP "\fBdown\fP"
Move down one level on the stack.

.LP
.SS "Data Display Commands"
.IP "\fBprint\fP" 10
Print the value of a selected expression.
.IP "\fBprint *\fP"
Print the value of the object the selected expression is pointing to.
.IP "\fBdisplay\fP"
(For Sun dbx only) Display the value of a selected expression in the
display window, updating its value every time execution stops.
.IP "\fBundisplay\fP"
(For Sun dbx only) Stop displaying the value of the selected expression
in the display window.  If the selected expression is a constant, it
refers to the display number associated with an expression in the
display window.
.IP "\fBdump\fP"
Print the names and values of local variables and parameters in the
current or selected function.

.LP
.SS "Miscellaneous Commands"
.IP "\fBfunc\fP"
Display a selected function on the source window, and change the scope
for variable name resolution to the selected function.  The file scope
is changed to the file containing the function.
.IP "\fBfile\fP"
If \fBfileMenu\fP is set to True in the resource database (see below),
it pops up a directory browser that allows the user to move up and down
in the directory tree, to select a text file to be displayed, or (in
Sun dbx) to select an executable file to debug.  Directory entries are
marked with a trailing slash (`/') and executables with a trailing
asterisk (`*').  Filenames beginning with a dot (`.') or ending with a
tilde (`~') are not listed in the menu.  If \fBfileMenu\fP is False, it
displays a selected file on the source window, and changes the scope
for variable name resolution to the selected file.  The default value
of \fBfileMenu\fP is True.
.IP "\fBsearch\fP"
Pops up a search panel which allows both forward and reverse search of
text strings in the source file.
.IP "\fBquit\fP"
Exit \fIxdbx\fP.

.LP
.SS "Displaying C Data Structures"
(For Sun dbx only) \fIXdbx\fP provides graphical display of C pointers
and structures.  Pressing the RIGHT mouse button on the \fBprint\fP
(or \fBprint *\fP) command button displays the value of the selected
expression (or the value the selected expression is pointing to) in a
popup.  If the value is a pointer or a structure containing pointers,
the user can examine the value of the object that pointer is pointing
to by simply double clicking the pointer value.  This will create
another popup that displays the object the pointer points to.  
.LP
This is especially useful for displaying data structures such as linked
lists where the user can display the entire linked list by simply
double clicking the next field of each cell, without having to type in
the fully qualified name for each cell.  Clicking the label of the
popup pops down itself and all of its descendants.
.SH X DEFAULTS
To change the default values of widget resources used in \fIxdbx\fP,
you need to reference the widgets by name or by class.  The widget
classes used in \fIxdbx\fP are \fBLabel\fP, \fBText\fP, \fBCommand\fP,
\fBBox\fP, and \fBScrollbar\fP.  The names of the widgets are:
.IP \fBvpane\fP 22
A vpaned widget containing all the subwindows.
.IP \fBtitleBar\fP
A label widget displaying the \fIxdbx\fP title.
.IP \fBfileLabel\fP
A label widget displaying the name of the source file.
.IP \fBlineLabel\fP
A label widget displaying the line number of caret in the source window.
.IP \fBsourceWindow\fP
A text widget displaying the source file.
.IP \fBcommandWindow\fP
A box widget containing the command buttons.
.IP \fBdialogWindow\fP
A text widget acting as a terminal interface to dbx.
.IP \fBfileMenu\fP
A list widget used as a file menu.
.LP

In addition to the standard X resources, \fIxdbx\fP uses the following
application-specific resources for user customization.  The value in
parentheses is the default value.
.IP \fBshellWidth\fP 20
Width of \fIxdbx\fP window. (550)
.IP \fBlineLabelWidth\fP
Width of line label. (70)
.IP \fBsourceHeight\fP
Height of source window. (320)
.IP \fBleftMargin\fP
Size of left margin of source window. (35)
.IP \fBdialogHeight\fP
Height of dialog window. (200)
.IP \fBmessageHeight\fP
Height of message window. (30)
.IP \fBbuttonWidth\fP
Width of a command button. (60)
.IP \fBbuttonHeight\fP
Height of a command button. (20)
.IP \fBcommandHSpace\fP
Horizontal spacing among the command buttons. (14)
.IP \fBcommandVSpace\fP
Vertical spacing among the command buttons. (10)
.IP \fBdisplayHeight\fP
Height of the display window. (100)
.IP \fBdataDpyMinHeight\fP
Minimum height of the data display window. (20)
.IP \fBdataDpyMinWidth\fP
Minimum width of the data display window. (0)
.IP \fBdataDpyMaxHeight\fP
Maximum height of the data display window. (300)
.IP \fBdataDpyMaxWidth\fP
Maximum width of the data display window. (400)
.IP \fBdataDpyLeftMargin\fP
Size of left margin of the data display window. (10)
.IP \fBcolumnSpacing\fP
Spacing between columns in the file menu. (10)
.IP \fBfilesPerColumn\fP
Number of files per column in the file menu. (10)
.IP \fBbell\fP
If True, the bell is on. (True)
.IP \fBtitleBar\fP
If True, the title bar will be displayed. (False)
.IP \fBfileMenu\fP
If False, the file command button will not create a file menu. (True)
.IP \fBstopForeground\fP
Foreground color of the stop sign. (Red)
.IP \fBarrowForeground\fP
Foreground color of the arrow sign. (Blue)
.IP \fBupdownForeground\fP
Foreground color of the updown sign. (Blue)
.IP \fBsourceTranslTable\fP
Translation table for the sourceWindow text widget. (nil)
.IP \fBsbarTranslTable\fP
Translation table for the sourceWindow scrollbar widget. (nil)
.IP \fBdialogTranslTable\fP
Translation table for the dialogWindow text widget. (nil)
.LP

.SH FILES
.nf
a.out 		default object file
core 		default core file
\&.dbxinit 		local initial commands file
~/.dbxinit 	user's initial commands file
.SH SEE ALSO
X(1), dbx(1), dbxtool(1)
.SH LIMITATIONS
\fIXdbx\fP is developed primarily for C program debugging.  Other languages are 
not fully supported.
.SH BUGS
\fIXdbx\fP exercises some bugs in the X11R3 Athena list widget.  Creating a file
menu could cause segmentation violation.
.LP
The \fBfile\fP button command does not unhighlight the button border.
.LP
.SH COPYRIGHT
Copyright 1989 The University of Texas at Austin
.SH AUTHOR
Po Cheung, The University of Texas at Austin
