use strict;
use warnings;

package Task::MapMetro::Maps;

our $VERSION = '0.1300'; # VERSION

1;

# ABSTRACT: Map::Metro maps in a bundle

__END__

=pod

=encoding utf-8

=head1 NAME

Task::MapMetro::Maps - Map::Metro maps in a bundle

=head1 VERSION

version 0.1300

=head1 SYNOPSIS

    $ cpanm Task::MapMetro::Maps

=head1 TASK CONTENTS

=head2 Map::Metro

=head3 L<Map::Metro> 0.2201

=head2 Available maps

=head3 L<Map::Metro::Plugin::Map::Amsterdam>

=head3 L<Map::Metro::Plugin::Map::Athens>

=head3 L<Map::Metro::Plugin::Map::Barcelona>

=head3 L<Map::Metro::Plugin::Map::Berlin>

=head3 L<Map::Metro::Plugin::Map::Bilbao>

=head3 L<Map::Metro::Plugin::Map::Brescia>

=head3 L<Map::Metro::Plugin::Map::Brussels>

=head3 L<Map::Metro::Plugin::Map::Budapest>

=head3 L<Map::Metro::Plugin::Map::Copenhagen>

=head3 L<Map::Metro::Plugin::Map::Gothenburg>

=head3 L<Map::Metro::Plugin::Map::Helsinki>

=head3 L<Map::Metro::Plugin::Map::Lille>

=head3 L<Map::Metro::Plugin::Map::Madrid>

=head3 L<Map::Metro::Plugin::Map::Oslo>

=head3 L<Map::Metro::Plugin::Map::Stockholm>

=head1 SEE ALSO

L<Map::Metro>

L<Task::MapMetro::Dev>

=head1 AUTHOR

Erik Carlsson E<lt>info@code301.comE<gt>

=head1 COPYRIGHT

Copyright 2015 - Erik Carlsson

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
