use strict;
use warnings;
use Dist::Iller::Standard;

# PODNAME: Dist::Iller::Doctype

class Dist::Iller::Doctype using Moose {

    our $VERSION = '0.1202'; # VERSION

    has type => (
        is => 'ro',
        isa => Enum([qw/dist weaver/]),
    );
    has headers => (
        is => 'ro',
        isa => ArrayRef,
        traits => ['Array'],
        lazy => 1,
        builder => 1,
        handles => {
            all_headers => 'elements',
        }
    );

    method _build_headers {
        return [qw/name author license copyright_holder copyright_year/] if $self->type eq 'dist';
        return [];
    }
    method namespace {
        return 'Dist::Zilla' if $self->type eq 'dist';
        return 'Pod::Weaver' if $self->type eq 'weaver';
    }

    method dist {
        return Dist::Iller::Doctype->new(type => 'dist');
    }
    method weaver {
        return Dist::Iller::Doctype->new(type => 'weaver');
    }
    method is_weaver {
        return $self->type eq 'weaver' ? 1 : 0;
    }
    method is_dist {
        return $self->type eq 'dist' ? 1 : 0;
    }
}

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Iller::Doctype

=head1 VERSION

Version 0.1202, released 2015-11-27.

=head1 SOURCE

L<https://github.com/Csson/p5-Dist-Iller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Dist-Iller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
