/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.riff;

import com.drew.imaging.riff.RiffHandler;
import com.drew.imaging.riff.RiffProcessingException;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import java.io.IOException;

public class RiffReader {
    public void processRiff(@NotNull SequentialReader reader, @NotNull RiffHandler handler) throws RiffProcessingException, IOException {
        int fileSize;
        reader.setMotorolaByteOrder(false);
        String fileFourCC = reader.getString(4);
        if (!fileFourCC.equals("RIFF")) {
            throw new RiffProcessingException("Invalid RIFF header: " + fileFourCC);
        }
        int sizeLeft = fileSize = reader.getInt32();
        String identifier = reader.getString(4);
        sizeLeft -= 4;
        if (!handler.shouldAcceptRiffIdentifier(identifier)) {
            return;
        }
        while (sizeLeft != 0) {
            String chunkFourCC = reader.getString(4);
            int chunkSize = reader.getInt32();
            if (chunkSize < 0 || (sizeLeft -= 8) < chunkSize) {
                throw new RiffProcessingException("Invalid RIFF chunk size");
            }
            if (handler.shouldAcceptChunk(chunkFourCC)) {
                handler.processChunk(chunkFourCC, reader.getBytes(chunkSize));
            } else {
                reader.skip(chunkSize);
            }
            sizeLeft -= chunkSize;
            if (chunkSize % 2 != 1) continue;
            reader.getInt8();
            --sizeLeft;
        }
    }
}

