/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.h264;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.AbstractBox;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import com.googlecode.mp4parser.h264.model.PictureParameterSet;
import com.googlecode.mp4parser.h264.model.SeqParameterSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AvcConfigurationBox
extends AbstractBox {
    public static final String TYPE = "avcC";
    private int configurationVersion;
    private int avcProfileIndicaation;
    private int profileCompatibility;
    private int avcLevelIndication;
    private int lengthSizeMinusOne;
    List<byte[]> sequenceParameterSets = new ArrayList<byte[]>();
    List<byte[]> pictureParameterSets = new ArrayList<byte[]>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;

    public AvcConfigurationBox() {
        super(TYPE);
    }

    public int getConfigurationVersion() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.configurationVersion;
    }

    public int getAvcProfileIndicaation() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.avcProfileIndicaation;
    }

    public int getProfileCompatibility() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.profileCompatibility;
    }

    public int getAvcLevelIndication() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.avcLevelIndication;
    }

    public int getLengthSizeMinusOne() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.lengthSizeMinusOne;
    }

    public List<byte[]> getSequenceParameterSets() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return Collections.unmodifiableList(this.sequenceParameterSets);
    }

    public List<byte[]> getPictureParameterSets() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return Collections.unmodifiableList(this.pictureParameterSets);
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigurationVersion(int n) {
        void configurationVersion;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.configurationVersion = configurationVersion;
    }

    /*
     * WARNING - void declaration
     */
    public void setAvcProfileIndicaation(int n) {
        void avcProfileIndicaation;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.avcProfileIndicaation = avcProfileIndicaation;
    }

    /*
     * WARNING - void declaration
     */
    public void setProfileCompatibility(int n) {
        void profileCompatibility;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.profileCompatibility = profileCompatibility;
    }

    /*
     * WARNING - void declaration
     */
    public void setAvcLevelIndication(int n) {
        void avcLevelIndication;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.avcLevelIndication = avcLevelIndication;
    }

    /*
     * WARNING - void declaration
     */
    public void setLengthSizeMinusOne(int n) {
        void lengthSizeMinusOne;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.lengthSizeMinusOne = lengthSizeMinusOne;
    }

    /*
     * WARNING - void declaration
     */
    public void setSequenceParameterSets(List<byte[]> list) {
        void sequenceParameterSets;
        List<byte[]> list2 = list;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_12, (Object)this, (Object)this, list2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.sequenceParameterSets = sequenceParameterSets;
    }

    /*
     * WARNING - void declaration
     */
    public void setPictureParameterSets(List<byte[]> list) {
        void pictureParameterSets;
        List<byte[]> list2 = list;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_13, (Object)this, (Object)this, list2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.pictureParameterSets = pictureParameterSets;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.configurationVersion = IsoTypeReader.readUInt8(content);
        this.avcProfileIndicaation = IsoTypeReader.readUInt8(content);
        this.profileCompatibility = IsoTypeReader.readUInt8(content);
        this.avcLevelIndication = IsoTypeReader.readUInt8(content);
        int temp = IsoTypeReader.readUInt8(content);
        this.lengthSizeMinusOne = temp & 3;
        long numberOfSeuqenceParameterSets = IsoTypeReader.readUInt8(content) & 0x1F;
        int i = 0;
        while ((long)i < numberOfSeuqenceParameterSets) {
            int sequenceParameterSetLength = IsoTypeReader.readUInt16(content);
            byte[] sequenceParameterSetNALUnit = new byte[sequenceParameterSetLength];
            content.get(sequenceParameterSetNALUnit);
            this.sequenceParameterSets.add(sequenceParameterSetNALUnit);
            ++i;
        }
        long numberOfPictureParameterSets = IsoTypeReader.readUInt8(content);
        int i2 = 0;
        while ((long)i2 < numberOfPictureParameterSets) {
            int pictureParameterSetLength = IsoTypeReader.readUInt16(content);
            byte[] pictureParameterSetNALUnit = new byte[pictureParameterSetLength];
            content.get(pictureParameterSetNALUnit);
            this.pictureParameterSets.add(pictureParameterSetNALUnit);
            ++i2;
        }
    }

    @Override
    public long getContentSize() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_14, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        long size = 5L;
        ++size;
        for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            size += 2L;
            size += (long)sequenceParameterSetNALUnit.length;
        }
        ++size;
        for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
            size += 2L;
            size += (long)pictureParameterSetNALUnit.length;
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getContent(ByteBuffer byteBuffer) throws IOException {
        void bb;
        ByteBuffer byteBuffer2 = byteBuffer;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_15, (Object)this, (Object)this, byteBuffer2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        IsoTypeWriter.writeUInt8((ByteBuffer)bb, this.configurationVersion);
        IsoTypeWriter.writeUInt8((ByteBuffer)bb, this.avcProfileIndicaation);
        IsoTypeWriter.writeUInt8((ByteBuffer)bb, this.profileCompatibility);
        IsoTypeWriter.writeUInt8((ByteBuffer)bb, this.avcLevelIndication);
        IsoTypeWriter.writeUInt8((ByteBuffer)bb, this.lengthSizeMinusOne | 0xFC);
        IsoTypeWriter.writeUInt8((ByteBuffer)bb, this.pictureParameterSets.size() & 0x1F | 0xE0);
        for (byte[] sequenceParameterSetNALUnit : this.sequenceParameterSets) {
            IsoTypeWriter.writeUInt16((ByteBuffer)bb, sequenceParameterSetNALUnit.length);
            bb.put(sequenceParameterSetNALUnit);
        }
        IsoTypeWriter.writeUInt8((ByteBuffer)bb, this.pictureParameterSets.size());
        for (byte[] pictureParameterSetNALUnit : this.pictureParameterSets) {
            IsoTypeWriter.writeUInt16((ByteBuffer)bb, pictureParameterSetNALUnit.length);
            bb.put(pictureParameterSetNALUnit);
        }
    }

    public String[] getPPS() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_16, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        ArrayList<String> l = new ArrayList<String>();
        for (byte[] pictureParameterSet : this.pictureParameterSets) {
            String details = "not parsable";
            try {
                details = PictureParameterSet.read(pictureParameterSet).toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            l.add(details);
        }
        return l.toArray(new String[l.size()]);
    }

    public String[] getSPS() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_17, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        ArrayList<String> l = new ArrayList<String>();
        for (byte[] sequenceParameterSet : this.sequenceParameterSets) {
            String detail = "not parsable";
            try {
                detail = SeqParameterSet.read(new ByteArrayInputStream(sequenceParameterSet)).toString();
            }
            catch (IOException iOException) {
            }
            l.add(detail);
        }
        return l.toArray(new String[l.size()]);
    }

    static {
        AvcConfigurationBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AvcConfigurationBox.java", AvcConfigurationBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigurationVersion", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "int"), 51);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAvcProfileIndicaation", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "int"), 55);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAvcLevelIndication", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "int", "avcLevelIndication", "", "void"), 91);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLengthSizeMinusOne", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "int", "lengthSizeMinusOne", "", "void"), 95);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSequenceParameterSets", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "java.util.List", "sequenceParameterSets", "", "void"), 99);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPictureParameterSets", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "java.util.List", "pictureParameterSets", "", "void"), 103);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContentSize", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "long"), 135);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContent", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "java.nio.ByteBuffer", "bb", "java.io.IOException", "void"), 153);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPPS", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "[Ljava.lang.String;"), 173);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSPS", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "[Ljava.lang.String;"), 189);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProfileCompatibility", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "int"), 59);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAvcLevelIndication", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "int"), 63);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLengthSizeMinusOne", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "int"), 67);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSequenceParameterSets", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "java.util.List"), 71);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPictureParameterSets", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "", "", "", "java.util.List"), 75);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConfigurationVersion", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "int", "configurationVersion", "", "void"), 79);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAvcProfileIndicaation", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "int", "avcProfileIndicaation", "", "void"), 83);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProfileCompatibility", "com.coremedia.iso.boxes.h264.AvcConfigurationBox", "int", "profileCompatibility", "", "void"), 87);
    }
}

