#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More;

plan tests => 2;

BEGIN {
    use Locked::Storage;
    my ($ls, $lr, $ur) = (undef, -1, -1);
    $ls = Locked::Storage->new(1);
    $lr = $ls->lockall();
    ok( $lr == 0, "mlockall() call" );
SKIP: {
        skip("lockall() failed, skipping unlockall", 1) if ($lr);
        $ur = $ls->unlockall();
        ok( $ur == 0, "munlockall() call" );
    }
}
