import javax.swing.event.InternalFrameListener;
import org.perl.inline.java.*;

public class      PerlInternalFrameListener
       extends    InlineJavaPerlCaller
       implements InternalFrameListener
{
    String sender;
    String callbacks;

    public PerlInternalFrameListener(String sender, String callbacks)
        throws InlineJavaException
    {
        this.sender    = sender;
        this.callbacks = callbacks;
    }

    public void internalFrameOpened(javax.swing.event.InternalFrameEvent event)  {
        try {
            CallPerl(
                "Java::Swing::InternalFrameListener",
                "_InternalFrameListener",
                new Object[] {sender, callbacks, "internalFrameOpened", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void internalFrameClosing(javax.swing.event.InternalFrameEvent event)  {
        try {
            CallPerl(
                "Java::Swing::InternalFrameListener",
                "_InternalFrameListener",
                new Object[] {sender, callbacks, "internalFrameClosing", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void internalFrameClosed(javax.swing.event.InternalFrameEvent event)  {
        try {
            CallPerl(
                "Java::Swing::InternalFrameListener",
                "_InternalFrameListener",
                new Object[] {sender, callbacks, "internalFrameClosed", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void internalFrameIconified(javax.swing.event.InternalFrameEvent event)  {
        try {
            CallPerl(
                "Java::Swing::InternalFrameListener",
                "_InternalFrameListener",
                new Object[] {sender, callbacks, "internalFrameIconified", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent event)  {
        try {
            CallPerl(
                "Java::Swing::InternalFrameListener",
                "_InternalFrameListener",
                new Object[] {sender, callbacks, "internalFrameDeiconified", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void internalFrameActivated(javax.swing.event.InternalFrameEvent event)  {
        try {
            CallPerl(
                "Java::Swing::InternalFrameListener",
                "_InternalFrameListener",
                new Object[] {sender, callbacks, "internalFrameActivated", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
    public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent event)  {
        try {
            CallPerl(
                "Java::Swing::InternalFrameListener",
                "_InternalFrameListener",
                new Object[] {sender, callbacks, "internalFrameDeactivated", event}
            );
        }
        catch (InlineJavaPerlException ijpe) {
            System.err.println("couldn't call perl ijpe: " + ijpe);
        }
        catch (InlineJavaException ije) {
            System.err.println("couldn't call perl ije: " + ije);
        }
    }
}
