use strict;
use warnings;

use SQL::Steno;

use Test::More tests => 1;



# Fake DBI
my $sth = bless {
   Active => 1,
   NAME => ["a\nz", 'x,y', 'b"c']
}, 'DBI::st';

my @rows;

sub DBI::st::execute {
    @rows = ([1..3],[4..6]);
}

sub DBI::st::fetchrow_array {
     @rows ? @{shift @rows} : ();
}



sub test($$;$$) {
    $sth->execute;
    open my $fh, '>', \my $str;
    my $ofh = select $fh;
    eval { no strict 'refs'; &{"SQL::Steno::render_$_[0]"}( $sth, $_[2], $_[3] ) };
    close $fh;
    select $ofh;
    is $str, $_[1], $_[0];
}

test tabular => <<\OUT;
a\nz
 |x,y
 | |b"c
-|-|-|
1|2|3|
4|5|6|
OUT