use strict;
use warnings;

use SQL::Steno;
$SQL::Steno::prompt = '';

use Test::More tests => 1;



# Fake DBI
$SQL::Steno::dbh = bless {}, 'DBI::db';

sub DBI::db::prepare {
    bless {
       Active => 1,
       NAME => [qw(Id User Host db Command Time State Info Progress)],
       row => $_[1] =~ /^show/ ? [1, qw(me 1.2.3.4:1234 shelldb Query), 0, undef, $_[1], '0.000'] : 0 # only prepare if query is show
    }, 'DBI::st';
}

my @rows;
sub DBI::st::execute {
    $DBI::rows = $_[0]{row} && 2 and
	@rows = ([0, 'Sleep'], $_[0]{row});
}

sub DBI::st::fetchrow_array {
     @rows ? @{shift @rows} : ();
}



my $ofh = select;
close STDOUT;
open STDOUT, '>', \my $str;
open STDIN, '<&DATA';
SQL::Steno::shell;
close STDOUT;
select $ofh;

$str =~ s/(\nprepare: )[\d.]+(s   execute: )[\d.]+/${1}0.000${2}0.000/g;


is $str, <<\OUT;
let's test
set @num=123;
prepare: 0.000s   execute: 0.000s   rows: 0
set @str="foo bar";
prepare: 0.000s   execute: 0.000s   rows: 0
set @epoch=cast("1970-01-01 00:00" as datetime);
prepare: 0.000s   execute: 0.000s   rows: 0
&st     var,value   set @var = cast("value" as time)
select @a:=date(now()-interval 1 day)`@a`, @z:=date(now())-interval 1 second`@z`;
prepare: 0.000s   execute: 0.000s   rows: 0
prepare: 0.000s   execute: 0.000s   rows: 2
Id
 |User
 |  |Host        |db     |Command
 |  |            |       |     |Time
 |  |            |       |     | |State
 |  |            |       |     | |  |Info            |Progress
-|--|------------|-------|-----|-|--|----------------|-----|
1|me|1.2.3.4:1234|shelldb|Query|0|\@|show processlist|0.000|
prepare: 0.000s   execute: 0.000s   rows: 2
- Id:       1
  User:     me
  Host:     "1.2.3.4:1234"
  db:       shelldb
  Command:  Query
  Time:     0
  State:    ~
  Info:     show processlist
  Progress: 0.000
prepare: 0.000s   execute: 0.000s   rows: 2
Id,User,Host,db,Command,Time,State,Info,Progress
1,me,1.2.3.4:1234,shelldb,Query,0,,show full processlist,0.000
select a,b,c from tbl where 
a>5;
prepare: 0.000s   execute: 0.000s   rows: 0
select x,y,z
 from tbl
 where x<9;
prepare: 0.000s   execute: 0.000s   rows: 0
OUT



__DATA__
&{ print "let's test\n"; '&s num,' || 'perverse concatenation' }123
&ss(str,foo bar)
&sdt epoch,1970-01-01 00:00
?&st
&sy
&ps
&-
&ps
&.csv()&psf

{ 'just a nop' }a,b,c;tbl;\
a>5

\\/match me/x,y,z
;tbl
;x<9\\
