Gnome::Gtk3::AboutDialog
========================

Display information about an application

![](images/aboutdialog.png)

Description
===========

The **Gnome::Gtk3::AboutDialog** offers a simple way to display information about a program like its logo, name, copyright, website and license. It is also possible to give credits to the authors, documenters, translators and artists who have worked on the program. An about dialog is typically opened when the user selects the `About` option from the `Help` menu. All parts of the dialog are optional.

About dialogs often contain links and email addresses. **Gnome::Gtk3::AboutDialog** displays these as clickable links. By default, it calls gtk_show_uri() when a user clicks one. The behavior can be overridden with the `activate-link` signal.

To specify a person with an email address, use a string like "Edgar Allan Poe <edgar@poe.com>". To specify a website with a title, use a string like "GTK+ team http://www.gtk.org".

To make constructing a **Gnome::Gtk3::AboutDialog** as convenient as possible, you can use the function `gtk_show_about_dialog()` which constructs and shows a dialog and keeps it around so that it can be shown again.

Note that GTK+ sets a default title of `_("About %s")` on the dialog window (where \%s is replaced by the name of the application, but in order to ensure proper translation of the title, applications should set the title property explicitly when constructing a **Gnome::Gtk3::AboutDialog**.

It is also possible to show a **Gnome::Gtk3::AboutDialog** like any other **Gnome::Gtk3::Dialog**, e.g. `using gtk_dialog_run()`. In this case, you might need to know that the “Close” button returns the `GTK_RESPONSE_CANCEL` response id.

Synopsis
========

Declaration
-----------

    unit class Gnome::Gtk3::AboutDialog;
    also is Gnome::Gtk3::Dialog;

Uml Diagram
-----------

![](plantuml/AboutDialog.svg)

Inheriting this class
---------------------

Inheriting is done in a special way in that it needs a call from new() to get the native object created by the class you are inheriting from.

    use Gnome::Gtk3::AboutDialog;

    unit class MyGuiClass;
    also is Gnome::Gtk3::AboutDialog;

    submethod new ( |c ) {
      # let the Gnome::Gtk3::AboutDialog class process the options
      self.bless( :GtkAboutDialog, |c);
    }

    submethod BUILD ( ... ) {
      ...
    }

Example
=======

    my Gnome::Gtk3::AboutDialog $about .= new;

    $about.set-program-name('My-First-GTK-Program');

    # Show the dialog.The status can be tested for which button was pressed
    my Int $return-status = $about.gtk-dialog-run;

    # When dialog buttons are pressed control returns here.
    # Hide the dialog again.
    $about.gtk-widget-hide;

Types
=====

enum GtkLicense
---------------

The type of license for an application. This enumeration can be expanded at later date.

  * GTK_LICENSE_UNKNOWN: No license specified

  * GTK_LICENSE_CUSTOM: A license text is going to be specified by the developer

  * GTK_LICENSE_GPL_2_0: The GNU General Public License, version 2.0 or later

  * GTK_LICENSE_GPL_3_0: The GNU General Public License, version 3.0 or later

  * GTK_LICENSE_LGPL_2_1: The GNU Lesser General Public License, version 2.1 or later

  * GTK_LICENSE_LGPL_3_0: The GNU Lesser General Public License, version 3.0 or later

  * GTK_LICENSE_BSD: The BSD standard license

  * GTK_LICENSE_MIT_X11: The MIT/X11 standard license

  * GTK_LICENSE_ARTISTIC: The Artistic License, version 2.0

  * GTK_LICENSE_GPL_2_0_ONLY: The GNU General Public License, version 2.0 only. Since 3.12.

  * GTK_LICENSE_GPL_3_0_ONLY: The GNU General Public License, version 3.0 only. Since 3.12.

  * GTK_LICENSE_LGPL_2_1_ONLY: The GNU Lesser General Public License, version 2.1 only. Since 3.12.

  * GTK_LICENSE_LGPL_3_0_ONLY: The GNU Lesser General Public License, version 3.0 only. Since 3.12.

  * GTK_LICENSE_AGPL_3_0: The GNU Affero General Public License, version 3.0 or later. Since: 3.22.

  * GTK_LICENSE_AGPL_3_0_ONLY: The GNU Affero General Public License, version 3.0 only. Since: 3.22.27.

Methods
=======

new
---

### default, no options

Creates a new **Gnome::Gtk3::AboutDialog**.

    multi method new ( )

### :native-object

Create an object using a native object from elsewhere. See also **Gnome::N::TopLevelSupportClass**.

    multi method new ( N-GObject :$native-object! )

### :build-id

Create an object using a native object from a builder. See also **Gnome::GObject::Object**.

    multi method new ( Str :$build-id! )

[[gtk_] about_dialog_] get_program_name
---------------------------------------

Returns the program name displayed in the about dialog.

Returns: The program name. The string is owned by the about dialog and must not be modified.

    method gtk_about_dialog_get_program_name ( --> Str )

[[gtk_] about_dialog_] set_program_name
---------------------------------------

Sets the name to display in the about dialog. If this is not set, it defaults to `g_get_application_name()`.

    method gtk_about_dialog_set_program_name ( Str $name )

  * Str $name; the program name

[[gtk_] about_dialog_] get_version
----------------------------------

Returns the version string.

Returns: The version string. The string is owned by the about dialog and must not be modified.

    method gtk_about_dialog_get_version ( --> Str  )

[[gtk_] about_dialog_] set_version
----------------------------------

Sets the version string to display in the about dialog.

    method gtk_about_dialog_set_version ( Str $version )

  * Str $version; (allow-none): the version string

[[gtk_] about_dialog_] get_copyright
------------------------------------

Returns the copyright string.

Returns: The copyright string. The string is owned by the about dialog and must not be modified.

    method gtk_about_dialog_get_copyright ( --> Str  )

[[gtk_] about_dialog_] set_copyright
------------------------------------

Sets the copyright string to display in the about dialog. This should be a short string of one or two lines.

    method gtk_about_dialog_set_copyright ( Str $copyright )

  * Str $copyright; (allow-none): the copyright string

[[gtk_] about_dialog_] get_comments
-----------------------------------

Returns the comments string.

Returns: The comments. The string is owned by the about dialog and must not be modified.

    method gtk_about_dialog_get_comments ( --> Str  )

[[gtk_] about_dialog_] set_comments
-----------------------------------

Sets the comments string to display in the about dialog. This should be a short string of one or two lines.

    method gtk_about_dialog_set_comments ( Str $comments )

  * Str $comments; (allow-none): a comments string

[[gtk_] about_dialog_] get_license
----------------------------------

Returns the license information.

Returns: The license information. The string is owned by the about dialog and must not be modified.

    method gtk_about_dialog_get_license ( --> Str )

[[gtk_] about_dialog_] set_license
----------------------------------

Sets the license information to be displayed in the secondary license dialog. If *license* is `Any`, the license button is hidden.

    method gtk_about_dialog_set_license ( Str $license )

  * Str $license; (allow-none): the license information or `Any`

[[gtk_] about_dialog_] set_license_type
---------------------------------------

Sets the license of the application showing the this about dialog dialog from a list of known licenses.

This function overrides the license set using `gtk_about_dialog_set_license()`.

    method gtk_about_dialog_set_license_type ( GtkLicense $license_type )

  * GtkLicense $license_type; the type of license

[[gtk_] about_dialog_] get_license_type
---------------------------------------

Retrieves the license set using `gtk_about_dialog_set_license_type()`

Returns: a *Gnome::Gtk3::License* value

    method gtk_about_dialog_get_license_type ( --> GtkLicense  )

[[gtk_] about_dialog_] get_wrap_license
---------------------------------------

Returns whether the license text in this about dialog is automatically wrapped.

Returns: `1` if the license text is wrapped

    method gtk_about_dialog_get_wrap_license ( --> Int  )

[[gtk_] about_dialog_] set_wrap_license
---------------------------------------

Sets whether the license text in this about dialog is automatically wrapped.

    method gtk_about_dialog_set_wrap_license ( Int $wrap_license )

  * Int $wrap_license; whether to wrap the license

[[gtk_] about_dialog_] get_website
----------------------------------

Returns the website URL.

Returns: The website URL. The string is owned by the about dialog and must not be modified.

    method gtk_about_dialog_get_website ( --> Str  )

[[gtk_] about_dialog_] set_website
----------------------------------

Sets the URL to use for the website link.

    method gtk_about_dialog_set_website ( Str $website )

  * Str $website; a URL string starting with "http://"

[[gtk_] about_dialog_] get_website_label
----------------------------------------

Returns the label used for the website link.

Returns: The label used for the website link. The string is owned by the about dialog and must not be modified.

    method gtk_about_dialog_get_website_label ( --> Str  )

[[gtk_] about_dialog_] set_website_label
----------------------------------------

Sets the label to be used for the website link.

    method gtk_about_dialog_set_website_label ( Str $website_label )

  * Str $website_label; the label used for the website link

[[gtk_] about_dialog_] get_authors
----------------------------------

Returns the string which are displayed in the authors tab of the secondary credits dialog.

Returns: An array containing the authors.

    method gtk_about_dialog_get_authors ( --> Array )

[[gtk_] about_dialog_] set_authors
----------------------------------

Sets the strings which are displayed in the authors tab of the secondary credits dialog.

    method gtk_about_dialog_set_authors ( *@authors )

  * @authors; a list of string arguments

### Example

    my Gnome::Gtk3::AboutDialog $a .= new;
    $a.set-authors( 'mt++', 'pietje puk');

[[gtk_] about_dialog_] get_documenters
--------------------------------------

Returns the string which are displayed in the documenters tab of the secondary credits dialog.

Returns: An array containing the documenters

    method gtk_about_dialog_get_documenters ( --> Array )

[[gtk_] about_dialog_] set_documenters
--------------------------------------

Sets the strings which are displayed in the documenters tab of the secondary credits dialog.

    method gtk_about_dialog_set_documenters ( *@documenters )

  * @documenters; an list of string arguments

[[gtk_] about_dialog_] get_artists
----------------------------------

Returns the string which are displayed in the artists tab of the secondary credits dialog.

Returns: A string array containing the artists.

    method gtk_about_dialog_get_artists ( --> Array )

[[gtk_] about_dialog_] set_artists
----------------------------------

Sets the strings which are displayed in the artists tab of the secondary credits dialog.

    method gtk_about_dialog_set_artists ( *@artists )

  * @artists; A list of string arguments

[[gtk_] about_dialog_] get_translator_credits
---------------------------------------------

Returns the translator credits string which is displayed in the translators tab of the secondary credits dialog.

Returns: The translator credits string. The string is owned by the about dialog and must not be modified.

    method gtk_about_dialog_get_translator_credits ( --> Str  )

[[gtk_] about_dialog_] set_translator_credits
---------------------------------------------

Sets the translator credits string which is displayed in the translators tab of the secondary credits dialog.

The intended use for this string is to display the translator of the language which is currently used in the user interface. Using `gettext()`, a simple way to achieve that is to mark the string for translation:

    $about-dialog.set-translator-credits("translator-credits");

It is a good idea to use the customary msgid “translator-credits” for this purpose, since translators will already know the purpose of that msgid, and since *Gnome::Gtk3::AboutDialog* will detect if “translator-credits” is untranslated and hide the tab.

    method gtk_about_dialog_set_translator_credits ( Str $translator_credits )

  * Str $translator_credits; (allow-none): the translator credits

[[gtk_] about_dialog_] get_logo
-------------------------------

Returns the pixbuf displayed as logo in the about dialog.

Returns: the pixbuf displayed as logo. The pixbuf is owned by the about dialog. If you want to keep a reference to it, you have to call `g_object_ref()` on it.

    method gtk_about_dialog_get_logo ( --> N-GObject  )

[[gtk_] about_dialog_] set_logo
-------------------------------

Sets the pixbuf to be displayed as logo in the about dialog. If it is undefined, the default window icon set with `gtk_window_set_default_icon()` will be used.

    method gtk_about_dialog_set_logo ( N-GObject $logo )

  * N-GObject $logo; a *Gnome::Gdk3::Pixbuf*, or undefined

[[gtk_] about_dialog_] get_logo_icon_name
-----------------------------------------

Returns the icon name displayed as logo in the about dialog.

Returns: the icon name displayed as logo.

    method gtk_about_dialog_get_logo_icon_name ( --> Str )

[[gtk_] about_dialog_] set_logo_icon_name
-----------------------------------------

Sets the pixbuf to be displayed as logo in the about dialog. If it is undefined, the default window icon set with `gtk_window_set_default_icon()` will be used.

    method gtk_about_dialog_set_logo_icon_name ( Str $icon_name )

  * Str $icon_name; an icon name, or undefined

[[gtk_] about_dialog_] add_credit_section
-----------------------------------------

Creates a new section in the Credits page.

    method gtk_about_dialog_add_credit_section (
      Str $section_name, *@people
    )

  * Str $section_name; The name of the section

  * @people; A list of people who belong to that section

Properties
==========

An example of using a string type property of a **Gnome::Gtk3::Label** object. This is just showing how to set/read a property, not that it is the best way to do it. This is because a) The class initialization often provides some options to set some of the properties and b) the classes provide many methods to modify just those properties. In the case below one can use **new(:label('my text label'))** or **gtk_label_set_text('my text label')**.

    my Gnome::Gtk3::Label $label .= new;
    my Gnome::GObject::Value $gv .= new(:init(G_TYPE_STRING));
    $label.g-object-get-property( 'label', $gv);
    $gv.g-value-set-string('my text label');

### Program name

The name of the program. If this is not set, it defaults to `g_get_application_name()`.

The **Gnome::GObject::Value** type of property *program-name* is `G_TYPE_STRING`.

### Program version

The version of the program.

The **Gnome::GObject::Value** type of property *version* is `G_TYPE_STRING`.

### Copyright string

Copyright information for the program.

The **Gnome::GObject::Value** type of property *copyright* is `G_TYPE_STRING`.

### Comments string

Comments about the program. This string is displayed in a label in the main dialog, thus it should be a short explanation of the main purpose of the program, not a detailed list of features.

The **Gnome::GObject::Value** type of property *comments* is `G_TYPE_STRING`.

### License

The license of the program. This string is displayed in a text view in a secondary dialog, therefore it is fine to use a long multi-paragraph text. Note that the text is only wrapped in the text view if the "wrap-license" property is set to `1`; otherwise the text itself must contain the intended linebreaks. When setting this property to a non-`Any` value, the sig *license-type* property is set to `GTK_LICENSE_CUSTOM` as a side effect.

The **Gnome::GObject::Value** type of property *license* is `G_TYPE_STRING`.

### License Type

The license of the program, as a value of the `GtkLicense` enumeration. The *Gnome::Gtk3::AboutDialog* will automatically fill out a standard disclaimer and link the user to the appropriate online resource for the license text.

If `GTK_LICENSE_UNKNOWN` is used, the link used will be the same specified in the sig *website* property.

If `GTK_LICENSE_CUSTOM` is used, the current contents of the sig *license* property are used.

For any other *Gnome::Gtk3::License* value, the contents of the sig *license* property are also set by this property as a side effect.

Widget type: GTK_TYPE_LICENSE

The **Gnome::GObject::Value** type of property *license-type* is `G_TYPE_ENUM`.

### Website URL

The URL for the link to the website of the program. This should be a string starting with "http://.

The **Gnome::GObject::Value** type of property *website* is `G_TYPE_STRING`.

### Website label

The label for the link to the website of the program.

The **Gnome::GObject::Value** type of property *website-label* is `G_TYPE_STRING`.

### Translator credits

Credits to the translators. This string should be marked as translatable. The string may contain email addresses and URLs, which will be displayed as links, see the introduction for more details.

The **Gnome::GObject::Value** type of property *translator-credits* is `G_TYPE_STRING`.

### Logo Icon Name

A named icon to use as the logo for the about box. This property overrides the sig *logo* property.

The **Gnome::GObject::Value** type of property *logo-icon-name* is `G_TYPE_STRING`.

### Wrap license

Whether to wrap the text in the license dialog.

The **Gnome::GObject::Value** type of property *wrap-license* is `G_TYPE_BOOLEAN`.

Signals
=======

There are two ways to connect to a signal. The first option you have is to use `register-signal()` from **Gnome::GObject::Object**. The second option is to use `g_signal_connect_object()` directly from **Gnome::GObject::Signal**.

First method
------------

The positional arguments of the signal handler are all obligatory as well as their types. The named attributes `:$widget` and user data are optional.

    # handler method
    method mouse-event ( N-GdkEvent $event, :$widget ) { ... }

    # connect a signal on window object
    my Gnome::Gtk3::Window $w .= new( ... );
    $w.register-signal( self, 'mouse-event', 'button-press-event');

Second method
-------------

    my Gnome::Gtk3::Window $w .= new( ... );
    my Callable $handler = sub (
      N-GObject $native, N-GdkEvent $event, OpaquePointer $data
    ) {
      ...
    }

    $w.connect-object( 'button-press-event', $handler);

Also here, the types of positional arguments in the signal handler are important. This is because both methods `register-signal()` and `g_signal_connect_object()` are using the signatures of the handler routines to setup the native call interface.

Supported signals
-----------------

activate-link
-------------

The signal which gets emitted to activate a URI. Applications may connect to it to override the default behaviour, which is to call `gtk_show_uri()`.

Returns: `1` if the link has been activated.

    method handler (
      Str $uri,
      Gnome::GObject::Object :$widget,
      *%user-options
      --> Int
    );

  * $widget; The object on which the signal was emitted.

  * $uri; the URI that is activated.

