# Topicmap

## Description

Package to manipulate topic map information. It is read from a file encoded in
XTM or Semi-xml 

## Introduction

Topic maps are described by a number of documents. See ...

## Differences from XTM 1.* to 2.0

* The namespace URI has changed.
* The version attribute has been added to the topicMap element.
* The parameters element has been replaced by scope .
* The roleSpec element has been replaced by type.
* The member element has been replaced by role.
* A single topic reference is now required as the child of role.
* The baseName element has been replaced by name.
* The instanceOf element has been replaced by type everywhere except inside
  topic.
* The type element is now allowed inside name.
* The variantName and subjectIdentity elements have been removed.
* The variant element can no longer be nested.
* The type element is now required inside occurrence, association, and role .
* The mergeMap element no longer supports added scope.
* The id attribute has been removed from all elements except topic, and the
  reifies attribute has been added on some elements.
* The itemIdentity, subjectLocator, and subjectIdentifier elements have been
  added.
* The subjectIndicatorRef element has been removed.
* XTM no longer uses XLink and XML Base.
* The mergeMap element must now come before all topic and association elements.
* The datatype attribute has been added to resourceData, which also now supports
  embedded markup.
* The reifier attribute has been added, replacing the implicit reification
  syntax in
* XTM 1.0 using the subjectIndicatorRef element.
* The baseNameString element has been replaced by the value element.


## Ideas and Todo

### Program stm2tm
This is a program to read XTM 2.0 or Semi-xml formatted files and check them.
The functions to implement are;

* [x] Read from xml as XTM 2.0
* [x] Read from sxml simulating xtm 2.0
* [ ] Read when namespaces are used when embedded in another document.
* [ ] Speeding up processing large topic maps, also speedup semi-xml.
* [x] Exporting result to xml
* [ ] Search through information

Below is a list from the DTD entries from one of the documents described above
and is used to show the decoding progression.

*     Element topicMap                  does TMap::TopicMap
* [x]   itemIdentity
* [x]   mergeMap
* [x]   topic
* [x]   association
*     Attributes topicMap
* [x]   version, '2.0'
* [ ]   xmlns, 'http://www.topicmaps.org/xtm/'
* [x]   reifier

*     Element topic                     does TMap::Topic
* [x]   itemIdentity
* [x]   subjectLocator
* [x]   subjectIdentifier
* [x]   instanceOf
* [x]   name
* [x]   occurrence
*     Attributes topic
* [x]   id

*     Element itemIdentity              in role TMap::TopicMapConstruct
*     Atributes itemIdentity
* [x]   href

* [x] Element subjectLocator            in role TMap::Topic
* [x] Attrbutes subjectLocator
* [x]   href

* [x] Element subjectIdentifier         in role TMap::Topic
* [x] Attributes subjectIdentifier
* [x]   href

*     Element name                      does TMap::TopicName
* [x]   itemIdentity
* [x]   type
* [x]   scope
* [x]   value
* [x]   variant
*     Attributes name
* [x]   reifier

* [x] Element value

*     Element variant
* [x]   itemIdentity
* [x]   scope
* [x]   resourceRef
* [x]   resourceData
*     Attributes variant
* [x]   reifier

*     Element scope                     in TMap::TopicName
* [x]   topicRef

*     Element instanceOf                in TMap::Topic
* [x]   topicRef

*     Element type                      in TMap::TopicName/Variant
* [x]   topicRef

*     Element occurrence
* [x]   itemIdentity
* [x]   type
* [x]   scope
* [x]   resourceRef
* [x]   resourceData
*     Attribute occurrence
* [x]   reifier

*     Element resourceData              in TMap::Topic
*     Attributes resourceData
* [x]   datatype

*     Element resourceRef               in TMap::Topic
*     Attributes resourceRef
* [x]   href

*     Element association
* [x]   itemIdentity
* [x]   type
* [x]   scope
* [x]   role
*     Attributes association
* [x]   reifier

*     Element role
* [x]   itemIdentity
* [x]   type
* [x]   topicRef
*     Attributes role
* [x]   reifier

*     Element topicRef                  in TMap::TopicMapConstruct/Topic
*     Attributes topicRef
* [x]   href

*     Element mergeMap
*     Attributes mergeMap
* [x]   href


## Bugs

* [x] Exporting result to xml needs conversion of references to exported doc

## Changes

* 0.2.0 All of XTM elements implemented
* 0.1.0 Start thinking. Always do that before coding.

## Aurhor

Marcel.Timmerman

## License

Released under [Artistic License 2.0](http://www.perlfoundation.org/artistic_license_2_0).


