# Structural specification Fig 19
#
use v6;
use OWL::Assertion;
use OWL::Individual;
use OWL::ClassExpression;

package OWL {

  class ClassAssertion is OWL::Assertion {

    has OWL::ClassExpression $.class-expression;
    has OWL::Individual $.individual;

    #---------------------------------------------------------------------------
    #
    method set ( OWL::IRI $class, OWL::IRI $individual ) {
      $!class-expression .= new(:iri($class));
      $!individual .= new(:iri($individual));

      self.set-type('class-assertion');
    }
  }
}
