use v6.c;
use BSON::Document;

package XCard {

  class VCard {
    #--------------------------------------------------------------------------
    my $vcard4-grammar = grammar {

      token VCard {
        <begin-vcard>
        <card-version>
        <content-line>+
        <end-vcard>
      }

      token begin-vcard { 'BEGIN:VCARD' \n }
      token card-version { 'VERSION:' $<version>=(4.0) \n }
      token end-vcard { 'END:VCARD' \n }

      token content-line {
        <group>
        <name>
        <param>
        <value>
        \n
      }

      token group { (<iana-token> '.')? }
      token name {
        "SOURCE" | "KIND" | "FN" | "N" | "NICKNAME" | "PHOTO" | "BDAY" |
        "ANNIVERSARY" | "GENDER" | "ADR" | "TEL" | "EMAIL" | "IMPP" | "LANG" |
        "TZ" | "GEO" | "TITLE" | "ROLE" | "LOGO" | "ORG" | "MEMBER" |
        "RELATED" | "CATEGORIES" | "NOTE" | "PRODID" | "REV" | "SOUND" |
        "UID" | "CLIENTPIDMAP" | "URL" | "KEY" | "FBURL" | "CALADRURI" |
        "CALURI" | "XML" | <iana-token> | <x-name>
      }

      token iana-token { <[A..Za..z0..9-]>+ }
      token x-name { 'x-' <iana-token> }

      token param { (
            ';' (
            <language-param>
          )*
        )*
      }

#TODO Grammar for language tags
      token language-param { 'LANGUAGE' '=' <alpha>2**3 }
    }

    #--------------------------------------------------------------------------
    my $vcard4-actions = class {

    }

    #--------------------------------------------------------------------------
    method read-vcard ( Str $filename ) {

      my $actions = $vcard4-actions.new;
      my $grammar = $vcard4-grammar.new;

      my BSON::Document $vcard;

#TODO unfold lines first

      my Match $m = $grammar.parse(
        $filename.IO.slurp(),
        :$actions,
        :rule<VCard>
      );

      if ?$m {
say $m<card-version><version>.perl;
        $vcard .= new: (
          version => $m<card-version><version>.Str,
        );
      }

      return $vcard;
    }
  }
}
