use v6.c;

my $base    = 'lib';

sub EXPORT
{
    # Q: How do I examine parameters from "use FindBin::libs <...>"?
}

module FindBin::libs:ver<0.1.0>:auth<CPAN:lembark>
{
}

=begin pod

=encoding utf8

=head1 NAME

FindBin - Simple replacement of Perl5's FindBin for Perl6.

=head1 SYNOPSIS

    use FindBin;   

    my $dir_from    = $Bin;
    my $script_base = $Script;

=head1 DESCRIPTION

This module exports $Script and $Bin. If perl6 is running in 
interactive mode, with '-e', '-', or input redirected from stdin
then $Script is 'interactive', '-e', or '-' and $Bin is the 
current working directory from $*CWD.

=head2 Notes

    One difference between and the original FindBin is that "RealBin" 
    is not (yet) available, what you get is *$CWD.

=head1 SEE ALSO

Perl variables $*PROGRAM, $*PROGRAM-NAME:

    https://docs.perl6.org/language/variables#index-entry-%24%2APROGRAM

Class which implements the dirname, basename, and absolute methods 
use to determine the absolute path of $Bin.

    https://docs.perl6.org/type/IO::Path
    
=head1 AUTHOR

Steven Lembark <lembark@wrkhors.com>

=head1 COPYRIGHT AND LICENSE

Copyright 2018 lembark

This library is free software; you can redistribute it and/or modify 
it under the Artistic License 2.0.

=end pod
