#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.03';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the tables below are generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::ColorInfo',
    'Image::ExifTool::Canon::ColorInfoD30',
    'Image::ExifTool::Canon::FileInfo',
    'Image::ExifTool::Canon::FocalLength',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::Canon::WhiteBalance',
    'Image::ExifTool::CanonCustom::Functions',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonRaw::ExposureInfo',
    'Image::ExifTool::CanonRaw::FlashInfo',
    'Image::ExifTool::CanonRaw::ImageFormat',
    'Image::ExifTool::CanonRaw::ImageInfo',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::SensorInfo',
    'Image::ExifTool::CanonRaw::TimeStamp',
    'Image::ExifTool::Casio::Main',
    'Image::ExifTool::Casio::Type2',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Jpeg2000::CaptureResolution',
    'Image::ExifTool::Jpeg2000::DisplayResolution',
    'Image::ExifTool::Jpeg2000::ImageHeader',
    'Image::ExifTool::Jpeg2000::Main',
    'Image::ExifTool::Kodak::Borders',
    'Image::ExifTool::Kodak::Main',
    'Image::ExifTool::Kodak::SpecialEffects',
    'Image::ExifTool::Kodak::Type2',
    'Image::ExifTool::Kodak::Type3',
    'Image::ExifTool::Kodak::Type4',
    'Image::ExifTool::Kodak::Type5',
    'Image::ExifTool::Kodak::Unknown',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalanceD100',
    'Image::ExifTool::Nikon::ColorBalanceD2H',
    'Image::ExifTool::Nikon::ColorBalanceD70',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::MakerNotesB',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::CameraSettings',
    'Image::ExifTool::Olympus::Equipment',
    'Image::ExifTool::Olympus::FocusInfo',
    'Image::ExifTool::Olympus::ImageProcessing',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Olympus::Subdir3',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Ricoh::Main',
    'Image::ExifTool::Ricoh::Subdir',
    'Image::ExifTool::Ricoh::TextMakerNote',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
    'Image::ExifTool::compositeTags',
    'Image::ExifTool::extraTags',
);

my %tagLookup = (
    'actionadvised' => { 34 => 0x2a },
    'addoriginaldecisiondata' => { 13 => 0x11 },
    'adjustmentmode' => { 77 => 0x15 },
    'advisory' => { 80 => 'Advisory' },
    'aebbracketvalue' => { 8 => 0x11 },
    'aebsequence' => { 10 => 0x7, 11 => 0x9, 12 => 0x9, 13 => 0x8 },
    'afareas' => { 62 => 0x304 },
    'afassist' => { 10 => 0x5, 11 => 0x5 },
    'afassistbeam' => { 13 => 0x4 },
    'afmode' => { 77 => 0x5 },
    'afpoint' => { 0 => 0x13, 58 => 0x88 },
    'afpointactivationarea' => { 12 => 0x11 },
    'afpointillumination' => { 12 => 0xa },
    'afpointregistration' => { 11 => 0x7 },
    'afpointselection' => { 12 => 0xb },
    'afpointselectionmethod' => { 13 => 0xc },
    'afpointspotmetering' => { 12 => 0xd },
    'afpointsused' => { 6 => 0x16 },
    'aiservotrackingsensitivity' => { 12 => 0x14 },
    'aliaslayermetadata' => { 24 => 0xc660 },
    'alphachannelsnames' => { 71 => 0x3ee },
    'analogbalance' => { 24 => 0xc627 },
    'annotations' => { 24 => 0xc44f },
    'antialiasstrength' => { 24 => 0xc632 },
    'aperture' => { 46 => 0x1e, 81 => 'Aperture' },
    'aperturevalue' => { 24 => 0x9202, 80 => 'ApertureValue' },
    'applicationnotes' => { 24 => 0x2bc },
    'applicationrecordversion' => { 34 => 0x0 },
    'armidentifier' => { 35 => 0x78 },
    'armversion' => { 35 => 0x7a },
    'artist' => { 24 => 0x13b, 80 => 'Artist' },
    'asshotneutral' => { 24 => 0xc628 },
    'asshotwhitexy' => { 24 => 0xc629 },
    'assistbuttonfunction' => { 11 => 0xd },
    'association' => { 44 => 'asoc' },
    'atob0' => { 31 => 'A2B0' },
    'atob1' => { 31 => 'A2B1' },
    'atob2' => { 31 => 'A2B2' },
    'audio' => { 68 => 0x20 },
    'audioduration' => { 34 => 0x99 },
    'audiooutcue' => { 34 => 0x9a },
    'audiosamplingrate' => { 34 => 0x97 },
    'audiosamplingresolution' => { 34 => 0x98 },
    'audiotype' => { 34 => 0x96 },
    'author' => { 80 => 'Author' },
    'authorsposition' => { 80 => 'AuthorsPosition' },
    'autobracket' => { 77 => 0x19 },
    'autobracketing' => { 25 => 0x1100 },
    'autoexposurebracketing' => { 8 => 0x10 },
    'autofocus' => { 64 => 0x209 },
    'autorotate' => { 8 => 0x1b },
    'auxiliarylens' => { 58 => 0x82 },
    'avvalue' => { 14 => 0x2 },
    'backgroundcolorindicator' => { 24 => 0x84e8 },
    'backgroundcolorvalue' => { 24 => 0x84ea },
    'badfaxlines' => { 24 => 0x146 },
    'baseiso' => { 18 => 0x101c },
    'baselineexposure' => { 24 => 0xc62a },
    'baselinenoise' => { 24 => 0xc62b },
    'baselinesharpness' => { 24 => 0xc62c },
    'baseurl' => { 80 => 'BaseURL' },
    'batterylevel' => { 24 => 0x828f },
    'bayergreensplit' => { 24 => 0xc62d },
    'bestqualityscale' => { 24 => 0xc65c },
    'bestshotmode' => { 23 => 0x3007 },
    'binaryfilter' => { 44 => 'bfil' },
    'bitspercomponent' => { 37 => 0x87, 43 => 0xa, 44 => 'bpcc' },
    'bitsperextendedrunlength' => { 24 => 0x84e5 },
    'bitsperrunlength' => { 24 => 0x84e4 },
    'bitspersample' => { 24 => 0x102, 80 => 'BitsPerSample' },
    'blacklevel' => { 24 => 0xc61a, 66 => 0x1012 },
    'blackleveldeltah' => { 24 => 0xc61b },
    'blackleveldeltav' => { 24 => 0xc61c },
    'blacklevelrepeatdim' => { 24 => 0xc619 },
    'blackpoint' => { 69 => 0x200 },
    'bluebalance' => { 55 => 0x1, 56 => 0x1, 57 => 0x1, 66 => 0x1018 },
    'bluebalanceauto' => { 9 => 0x1 },
    'bluebalanceb&w' => { 9 => 0xf },
    'bluebalancecloudy' => { 9 => 0x5 },
    'bluebalancecustom' => { 9 => 0xd },
    'bluebalancedaylight' => { 9 => 0x3 },
    'bluebalanceflash' => { 9 => 0xb },
    'bluebalancefluorescent' => { 9 => 0x9 },
    'bluebalanceshade' => { 9 => 0x11 },
    'bluebalancetungsten' => { 9 => 0x7 },
    'bluehue' => { 80 => 'BlueHue' },
    'bluematrixcolumn' => { 31 => 'bXYZ' },
    'bluesaturation' => { 80 => 'BlueSaturation' },
    'bluetrc' => { 31 => 'bTRC' },
    'blurwarning' => { 25 => 0x1300 },
    'borderid' => { 45 => 0x2 },
    'borderlocation' => { 45 => 0x3 },
    'bordername' => { 45 => 0x1 },
    'bordersversion' => { 45 => 0x0 },
    'bordertype' => { 45 => 0x4 },
    'bracket' => { 66 => 0x1006 },
    'bracketstep' => { 53 => 0xe },
    'brightness' => { 24 => 0xfe53, 53 => 0x2c, 80 => 'Brightness' },
    'brightnessvalue' => { 24 => 0x9203, 80 => 'BrightnessValue' },
    'btoa0' => { 31 => 'B2A0' },
    'btoa1' => { 31 => 'B2A1' },
    'btoa2' => { 31 => 'B2A2' },
    'bulbduration' => { 8 => 0x18 },
    'burstmode' => { 46 => 0xa },
    'burstmode2?' => { 46 => 0x18 },
    'bwfilter' => { 53 => 0x2a },
    'by-line' => { 34 => 0x50 },
    'by-linetitle' => { 34 => 0x55 },
    'calibrationdatetime' => { 31 => 'calt' },
    'calibrationilluminant1' => { 24 => 0xc65a },
    'calibrationilluminant2' => { 24 => 0xc65b },
    'cameracalibration1' => { 24 => 0xc623 },
    'cameracalibration2' => { 24 => 0xc624 },
    'cameraid' => { 66 => 0x209, 76 => 0x209 },
    'cameraiso' => { 0 => 0x10 },
    'cameraobject' => { 18 => 0x2807 },
    'cameraowner' => { 24 => 0xc353 },
    'camerasettings' => { 66 => 0x2020 },
    'camerasettingsversion' => { 62 => 0x0 },
    'cameraspecification' => { 18 => 0x3004 },
    'canoncamerasettings' => { 5 => 0x1, 18 => 0x102d },
    'canoncolorinfo' => { 5 => 0xa0 },
    'canoncolorinfo1' => { 18 => 0x32 },
    'canoncolorinfo2' => { 18 => 0x102c },
    'canoncolorinfod30' => { 5 => 0xa },
    'canoncustomfunctions' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctions10d' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctions1d' => { 5 => 0x90 },
    'canoncustomfunctions20d' => { 5 => 0xf, 18 => 0x1033 },
    'canonexposuremode' => { 0 => 0x14 },
    'canonfiledescription' => { 18 => 0x805 },
    'canonfileinfo' => { 5 => 0x93 },
    'canonfilelength' => { 5 => 0xe },
    'canonfirmwareversion' => { 5 => 0x7, 18 => 0x80b },
    'canonflashmode' => { 0 => 0x4 },
    'canonfocallength' => { 5 => 0x2, 18 => 0x1029 },
    'canonimageheight' => { 6 => 0x3 },
    'canonimageheightasshot' => { 6 => 0x5 },
    'canonimagesize' => { 0 => 0xa },
    'canonimagetype' => { 5 => 0x6, 18 => 0x815 },
    'canonimagewidth' => { 6 => 0x2 },
    'canonimagewidthasshot' => { 6 => 0x4 },
    'canonpictureinfo' => { 5 => 0x12, 18 => 0x1038 },
    'canonrawmakemodel' => { 18 => 0x80a },
    'canonshotinfo' => { 5 => 0x4, 18 => 0x102a },
    'caption-abstract' => { 34 => 0x78 },
    'captionwriter' => { 80 => 'CaptionWriter' },
    'captureconditionspar' => { 24 => 0xc352 },
    'capturedevicefid' => { 24 => 0xc357 },
    'captureresolution' => { 44 => 'resc' },
    'capturexresolution' => { 41 => 0x4 },
    'capturexresolutionunit' => { 41 => 0x9 },
    'captureyresolution' => { 41 => 0x0 },
    'captureyresolutionunit' => { 41 => 0x8 },
    'casioimagesize' => { 23 => 0x9 },
    'casiopreviewlength' => { 23 => 0x3 },
    'casiopreviewstart' => { 23 => 0x4 },
    'category' => { 34 => 0xf, 80 => 'Category' },
    'ccdisosensitivity' => { 23 => 0x3014 },
    'ccdsensitivity' => { 22 => 0x14, 59 => 0x6 },
    'celllength' => { 24 => 0x109 },
    'cellwidth' => { 24 => 0x108 },
    'certificate' => { 80 => 'Certificate' },
    'cfalayout' => { 24 => 0xc617 },
    'cfapattern' => { 24 => 0xa302, 80 => 'CFAPattern' },
    'cfapattern2' => { 24 => 0x828e },
    'cfapatterncolumns' => { 80 => 'CFAPatternColumns' },
    'cfapatternrows' => { 80 => 'CFAPatternRows' },
    'cfapatternvalues' => { 80 => 'CFAPatternValues' },
    'cfaplanecolor' => { 24 => 0xc616 },
    'cfarepeatpatterndim' => { 24 => 0x828d },
    'chartarget' => { 31 => 'targ' },
    'chromablurradius' => { 24 => 0xc631 },
    'chromaticaberrationb' => { 80 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 80 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 31 => 'chad' },
    'chromaticity' => { 31 => 'chrm' },
    'chromaticitychannel1' => { 28 => 0xc },
    'chromaticitychannel2' => { 28 => 0x14 },
    'chromaticitychannel3' => { 28 => 0x1c },
    'chromaticitychannel4' => { 28 => 0x24 },
    'chromaticitychannels' => { 28 => 0x8 },
    'chromaticitycolorant' => { 28 => 0xa },
    'city' => { 34 => 0x5a, 80 => 'City' },
    'cleanfaxdata' => { 24 => 0x147 },
    'clippath' => { 24 => 0x157 },
    'cmmflags' => { 30 => 0x2c },
    'codedcharacterset' => { 35 => 0x5a },
    'codestreamheader' => { 44 => 'jpch' },
    'codestreamregistration' => { 44 => 'creg' },
    'codingmethods' => { 24 => 0x193 },
    'coloradjustment' => { 77 => 0x14 },
    'coloradjustmentmode' => { 76 => 0x210 },
    'colorant1coordinates' => { 29 => 0x2c },
    'colorant1name' => { 29 => 0xc },
    'colorant2coordinates' => { 29 => 0x52 },
    'colorant2name' => { 29 => 0x32 },
    'colorant3coordinates' => { 29 => 0x78 },
    'colorant3name' => { 29 => 0x58 },
    'colorantcount' => { 29 => 0x8 },
    'colorantorder' => { 31 => 'clro' },
    'coloranttable' => { 31 => 'clrt' },
    'colorbalance1' => { 58 => 0xc },
    'colorbalanceblue' => { 53 => 0x1e },
    'colorbalanced100' => { 58 => 0x97 },
    'colorbalanced2h' => { 58 => 0x97 },
    'colorbalanced70' => { 58 => 0x97 },
    'colorbalancegreen' => { 53 => 0x1d },
    'colorbalancered' => { 53 => 0x1c },
    'colorbalanceunknown' => { 58 => 0x97 },
    'colorbitdepth' => { 17 => 0x5 },
    'colorbw' => { 17 => 0x6 },
    'colorcalibrationmatrix' => { 37 => 0x46 },
    'colorcharacterization' => { 24 => 0x84ed },
    'colorcontrol' => { 66 => 0x102b },
    'coloreffect' => { 68 => 0x28 },
    'colorfilter' => { 53 => 0x29 },
    'colorgroup' => { 44 => 'cgrp' },
    'colorhue' => { 58 => 0x8d },
    'colormap' => { 24 => 0x140 },
    'colormatrix' => { 2 => 0xa, 66 => 0x1011 },
    'colormatrix1' => { 24 => 0xc621 },
    'colormatrix2' => { 24 => 0xc622 },
    'colormode' => { 23 => 0x3015, 46 => 0x66, 53 => 0x28, 54 => 0x101, 58 => 0x3, 59 => 0x4, 66 => 0x101 },
    'colornoisereduction' => { 80 => 'ColorNoiseReduction' },
    'colorpalette' => { 37 => 0x55 },
    'colorrepresentation' => { 37 => 0x3c },
    'colorresponseunit' => { 24 => 0x12c },
    'colorsequence' => { 24 => 0x84e1, 37 => 0x41 },
    'colorspace' => { 18 => 0x10b4, 24 => 0xa001, 62 => 0x507, 77 => 0xb, 80 => 'ColorSpace' },
    'colorspacedata' => { 30 => 0x10 },
    'colorspecification' => { 44 => 'colr' },
    'colortable' => { 24 => 0x84e6 },
    'colortemperature' => { 1 => 0x9, 2 => 0x9, 5 => 0xae, 18 => 0x10ae },
    'colortone' => { 0 => 0x2a },
    'comment' => { 82 => 'Comment' },
    'componentbitdepth' => { 17 => 0x4 },
    'componentdefinition' => { 44 => 'cdef' },
    'componentmapping' => { 44 => 'cmap' },
    'componentsconfiguration' => { 24 => 0x9101, 80 => 'ComponentsConfiguration' },
    'componentversion' => { 18 => 0x80c },
    'compositinglayerheader' => { 44 => 'jplh' },
    'composition' => { 44 => 'comp' },
    'compositionoptions' => { 44 => 'copt' },
    'compressedbitsperpixel' => { 24 => 0x9102, 80 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 54 => 0x40, 66 => 0x40 },
    'compression' => { 24 => 0x103, 43 => 0xb, 46 => 0x9, 61 => 0x103, 80 => 'Compression' },
    'compressionfactor' => { 62 => 0x50d },
    'compressionratio' => { 66 => 0x1034 },
    'conditionalfec' => { 81 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 39 => 0xa },
    'consecutivebadfaxlines' => { 24 => 0x148 },
    'contact' => { 34 => 0x76 },
    'contentlocationcode' => { 34 => 0x1a },
    'contentlocationname' => { 34 => 0x1b },
    'contiguouscodestream' => { 44 => 'jp2c' },
    'continuousautofocus' => { 62 => 0x301 },
    'continuousdrive' => { 0 => 0x5 },
    'contrast' => { 0 => 0xd, 22 => 0xc, 23 => 0x20, 24 => [0xa408,0xfe54], 25 => 0x1004, 53 => 0x20, 66 => 0x1029, 68 => 0x2c, 69 => 0x20, 77 => 0xd, 80 => 'Contrast' },
    'contrastsetting' => { 62 => 0x505 },
    'contributor' => { 80 => 'Contributor' },
    'converter' => { 24 => 0xfe4d, 59 => 0xb },
    'copyright' => { 24 => 0x8298, 31 => 'cprt', 80 => 'Copyright' },
    'copyrightnotice' => { 34 => 0x74 },
    'coringfilter' => { 66 => 0x102d },
    'country' => { 80 => 'Country' },
    'country-primarylocationcode' => { 34 => 0x64 },
    'country-primarylocationname' => { 34 => 0x65 },
    'countrycode' => { 80 => 'CountryCode' },
    'coverage' => { 80 => 'Coverage' },
    'crdinfo' => { 31 => 'crdi' },
    'createdate' => { 24 => 0x9004, 80 => 'CreateDate' },
    'creationdate' => { 80 => 'CreationDate' },
    'creator' => { 80 => 'Creator' },
    'creatorcontactinfo' => { 80 => 'CreatorContactInfo' },
    'creatorcontactinfociadrcity' => { 80 => 'CreatorContactInfoCiAdrCity' },
    'creatorcontactinfociadrctry' => { 80 => 'CreatorContactInfoCiAdrCtry' },
    'creatorcontactinfociadrextadr' => { 80 => 'CreatorContactInfoCiAdrExtadr' },
    'creatorcontactinfociadrpcode' => { 80 => 'CreatorContactInfoCiAdrPcode' },
    'creatorcontactinfociadrregion' => { 80 => 'CreatorContactInfoCiAdrRegion' },
    'creatorcontactinfociemailwork' => { 80 => 'CreatorContactInfoCiEmailWork' },
    'creatorcontactinfocitelwork' => { 80 => 'CreatorContactInfoCiTelWork' },
    'creatorcontactinfociurlwork' => { 80 => 'CreatorContactInfoCiUrlWork' },
    'creatortool' => { 80 => 'CreatorTool' },
    'credit' => { 34 => 0x6e, 80 => 'Credit' },
    'cross-reference' => { 44 => 'cref' },
    'customrendered' => { 24 => 0xa401, 80 => 'CustomRendered' },
    'customsaturation' => { 62 => 0x503 },
    'datacompressionmethod' => { 37 => 0x6e },
    'datadump' => { 58 => 0x10, 66 => 0xf00, 68 => 0x21, 76 => 0xf00 },
    'datareference' => { 44 => 'dtbl' },
    'datatype' => { 24 => 0x80e4 },
    'date' => { 46 => 0x10, 49 => 0xc, 69 => 0x6, 80 => 'Date' },
    'datecreated' => { 34 => 0x37, 80 => 'DateCreated' },
    'datesent' => { 35 => 0x46 },
    'datetime' => { 80 => 'DateTime' },
    'datetimecreated' => { 81 => 'DateTimeCreated' },
    'datetimedigitized' => { 80 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 21 => 0x0, 24 => 0x9003, 80 => 'DateTimeOriginal', 81 => 'DateTimeOriginal' },
    'datetimestamp' => { 46 => 0x64 },
    'dealeridnumber' => { 24 => 0xc356 },
    'decode' => { 24 => 0x1b1 },
    'decodertable' => { 18 => 0x1835 },
    'decposition' => { 53 => 0x32 },
    'defaultcroporigin' => { 24 => 0xc61f },
    'defaultcropsize' => { 24 => 0xc620 },
    'defaultimagecolor' => { 24 => 0x1b2 },
    'defaultscale' => { 24 => 0xc61e },
    'derivedfrom' => { 80 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 80 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 80 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 80 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 80 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 80 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 80 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 80 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 80 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 80 => 'DerivedFromVersionID' },
    'description' => { 80 => 'Description' },
    'desiredreproductions' => { 44 => 'drep' },
    'destination' => { 35 => 0x5 },
    'deviceattributes' => { 30 => 0x38 },
    'devicemanufacturer' => { 30 => 0x30 },
    'devicemfgdesc' => { 31 => 'dmnd' },
    'devicemodel' => { 30 => 0x34 },
    'devicemodeldesc' => { 31 => 'dmdd' },
    'devicesettingdescription' => { 24 => 0xa40b, 80 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 80 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 80 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 80 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 31 => 'devs' },
    'digitalcreationdate' => { 34 => 0x3e },
    'digitalcreationtime' => { 34 => 0x3f },
    'digitaleffectsname' => { 47 => 0x1 },
    'digitaleffectstype' => { 47 => 0x2 },
    'digitaleffectsversion' => { 47 => 0x0 },
    'digitalsignature' => { 44 => 'chck' },
    'digitalzoom' => { 0 => 0xc, 22 => 0xa, 53 => 0xc, 58 => 0x86, 59 => 0xa, 66 => 0x204, 69 => 0x1e, 76 => 0x204 },
    'digitalzoomfactor' => { 46 => 0x68, 51 => 0x22 },
    'digitalzoomon' => { 76 => 0x21b },
    'digitalzoomratio' => { 24 => 0xa404, 80 => 'DigitalZoomRatio' },
    'directory' => { 82 => 'Directory' },
    'displayresolution' => { 44 => 'resd' },
    'displayxresolution' => { 42 => 0x4 },
    'displayxresolutionunit' => { 42 => 0x9 },
    'displayyresolution' => { 42 => 0x0 },
    'displayyresolutionunit' => { 42 => 0x8 },
    'distance1?' => { 46 => 0x28 },
    'distance2?' => { 46 => 0x2c },
    'distance3?' => { 46 => 0x30 },
    'distance4?' => { 46 => 0x34 },
    'dngbackwardversion' => { 24 => 0xc613 },
    'dngcameraserialnumber' => { 24 => 0xc62f },
    'dnglensinfo' => { 24 => 0xc630 },
    'dngprivatedata' => { 24 => 0xc634 },
    'dngversion' => { 24 => 0xc612 },
    'documentid' => { 80 => 'DocumentID' },
    'documentname' => { 24 => 0x10d },
    'dotrange' => { 24 => 0x150 },
    'drivemode' => { 53 => 0x6, 77 => 0x3, 81 => 'DriveMode' },
    'easymode' => { 0 => 0xb },
    'editorialupdate' => { 34 => 0x8 },
    'editstatus' => { 34 => 0x7 },
    'edittagarray' => { 24 => 0xc366 },
    'endpoints' => { 37 => 0x7d },
    'enhancement' => { 23 => 0x3016 },
    'envelopenumber' => { 24 => 0xc358, 35 => 0x28 },
    'envelopepriority' => { 35 => 0x3c },
    'enveloperecordversion' => { 35 => 0x0 },
    'epsonimageheight' => { 66 => 0x20c },
    'epsonimagewidth' => { 66 => 0x20b },
    'epsonsoftware' => { 66 => 0x20d },
    'equipment' => { 66 => 0x2010 },
    'equipmentversion' => { 63 => 0x0 },
    'error' => { 82 => 'Error' },
    'ettlii' => { 13 => 0xd },
    'excursiontolerance' => { 37 => 0x82 },
    'exifdata' => { 82 => 'ExifData' },
    'exifimageheight' => { 80 => 'PixelYDimension' },
    'exifimagelength' => { 24 => 0xa003 },
    'exifimagewidth' => { 24 => 0xa002, 80 => 'PixelXDimension' },
    'exifinformation' => { 18 => 0x300b },
    'exifoffset' => { 24 => 0x8769 },
    'exiftoolversion' => { 82 => 'ExifToolVersion' },
    'exifversion' => { 24 => 0x9000, 80 => 'ExifVersion' },
    'expirationdate' => { 34 => 0x25 },
    'expirationtime' => { 34 => 0x26 },
    'exposure' => { 24 => 0xfe51, 80 => 'Exposure' },
    'exposurebias' => { 46 => 0x24 },
    'exposurebracketvalue' => { 58 => 0x19 },
    'exposurecompensation' => { 8 => 0x6, 14 => 0x0, 24 => 0x9204, 53 => 0xd, 77 => 0xc, 80 => 'ExposureBiasValue' },
    'exposureindex' => { 24 => [0x9215,0xa215], 80 => 'ExposureIndex' },
    'exposureinfo' => { 18 => 0x1818 },
    'exposurelevelincrements' => { 10 => 0x4, 11 => 0x6, 12 => 0x6, 13 => 0x5 },
    'exposuremode' => { 24 => 0xa402, 53 => 0x1, 62 => 0x200, 77 => 0x8, 80 => 'ExposureMode' },
    'exposureprogram' => { 24 => 0x8822, 80 => 'ExposureProgram' },
    'exposuretime' => { 8 => 0x16, 24 => 0x829a, 80 => 'ExposureTime' },
    'exposurewarning' => { 25 => 0x1302 },
    'extenderserialnumber' => { 63 => 0x302 },
    'extrasamples' => { 24 => 0x152 },
    'faxprofile' => { 24 => 0x192 },
    'faxrecvparams' => { 24 => 0x885c },
    'faxrecvtime' => { 24 => 0x885e },
    'faxsubaddress' => { 24 => 0x885d },
    'fileformat' => { 16 => 0x0, 35 => 0x14 },
    'filename' => { 82 => 'FileName' },
    'filenumber' => { 3 => 0x1, 5 => 0x8, 18 => 0x1817 },
    'filenumbermemory' => { 53 => 0x1a },
    'filesize' => { 82 => 'FileSize' },
    'filesource' => { 24 => 0xa300, 80 => 'FileSource' },
    'filesystemversion' => { 58 => 0x1 },
    'filetype' => { 44 => 'ftyp', 82 => 'FileType' },
    'fileversion' => { 35 => 0x16 },
    'fillflashautoreduction' => { 10 => 0xa, 11 => 0xe, 12 => 0xe },
    'fillorder' => { 24 => 0x10a },
    'filmcategory' => { 24 => 0xc35a },
    'filmgencode' => { 24 => 0xc35b },
    'filmproductcode' => { 24 => 0xc350 },
    'filmsize' => { 24 => 0xc35d },
    'filter' => { 23 => 0x3017 },
    'finderdisplayduringexposure' => { 12 => 0x1 },
    'firmware' => { 77 => 0x17 },
    'firmwareversion' => { 66 => 0x207, 68 => 0x2 },
    'firmwareversion2' => { 63 => 0x100 },
    'fixtureidentifier' => { 34 => 0x16 },
    'flash' => { 24 => 0x9209, 80 => 'Flash' },
    'flashactivity' => { 0 => 0x1c },
    'flashbias' => { 66 => 0x1023, 68 => 0x24 },
    'flashbits' => { 0 => 0x1d },
    'flashdistance' => { 23 => 0x2034 },
    'flashenergy' => { 24 => [0x920b,0xa20b], 80 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 58 => 0x18 },
    'flashexposurecomp' => { 8 => 0xf, 53 => 0x23, 58 => 0x12 },
    'flashfired' => { 46 => 0x5d, 53 => 0x14, 80 => 'FlashFired' },
    'flashfiring' => { 13 => 0x6 },
    'flashfunction' => { 80 => 'FlashFunction' },
    'flashguidenumber' => { 15 => 0x0 },
    'flashinfo' => { 18 => 0x1813 },
    'flashintensity' => { 22 => 0x5 },
    'flashmode' => { 22 => 0x4, 46 => 0x5c, 51 => 0x27, 53 => 0x2, 58 => 0x87, 66 => 0x1004, 76 => 0x225, 80 => 'FlashMode' },
    'flashon' => { 81 => 'FlashOn' },
    'flashpixversion' => { 24 => 0xa000, 80 => 'FlashpixVersion' },
    'flashredeyemode' => { 80 => 'FlashRedEyeMode' },
    'flashreturn' => { 80 => 'FlashReturn' },
    'flashserialnumber' => { 63 => 0x1003 },
    'flashsetting' => { 58 => 0x8 },
    'flashstrength' => { 25 => 0x1011 },
    'flashsyncspeedav' => { 10 => 0x6, 11 => 0x3, 13 => 0x2 },
    'flashthreshold' => { 15 => 0x1 },
    'flashtype' => { 58 => 0x9, 81 => 'FlashType' },
    'flickerreduce' => { 76 => 0x218 },
    'fnumber' => { 8 => 0x15, 24 => 0x829d, 80 => 'FNumber' },
    'focallength' => { 4 => 0x1, 23 => 0x1d, 24 => 0x920a, 53 => 0x12, 69 => 0x1d, 80 => 'FocalLength' },
    'focallength35efl' => { 81 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 24 => 0xa405, 80 => 'FocalLengthIn35mmFilm' },
    'focalplaneresolutionunit' => { 24 => [0x9210,0xa210], 80 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 24 => [0x920e,0xa20e], 80 => 'FocalPlaneXResolution' },
    'focalplanexsize' => { 4 => 0x2 },
    'focalplaneyresolution' => { 24 => [0x920f,0xa20f], 80 => 'FocalPlaneYResolution' },
    'focalplaneysize' => { 4 => 0x3 },
    'focalunits' => { 0 => 0x19 },
    'focus' => { 59 => 0x8 },
    'focusarea' => { 53 => 0x31 },
    'focuscontinuous' => { 0 => 0x20 },
    'focusdistance' => { 53 => 0x13, 64 => 0x305, 66 => 0x100c },
    'focusdistancelower' => { 8 => 0x14 },
    'focusdistanceupper' => { 8 => 0x13 },
    'focusinfo' => { 66 => 0x2050 },
    'focusinfoversion' => { 64 => 0x0 },
    'focusingscreen' => { 12 => 0x0 },
    'focusmode' => { 0 => 0x7, 22 => 0x3, 23 => [0x3003,0xd], 25 => 0x1021, 46 => 0x38, 53 => 0x30, 58 => 0x7, 66 => 0x100b, 68 => 0x7, 69 => 0xd },
    'focussetting' => { 77 => 0x6 },
    'focustype' => { 0 => 0x12 },
    'focuswarning' => { 25 => 0x1301 },
    'foldername' => { 53 => 0x27 },
    'format' => { 80 => 'Format' },
    'fragmentlist' => { 44 => 'flst' },
    'fragmenttable' => { 44 => 'ftbl' },
    'framenumber' => { 24 => 0xc359, 69 => 0x29 },
    'free' => { 44 => 'free' },
    'freebytecounts' => { 24 => 0x121 },
    'freebytes' => { 18 => 0x1 },
    'freeoffsets' => { 24 => 0x120 },
    'fujiflashmode' => { 25 => 0x1010 },
    'gaincontrol' => { 24 => 0xa407, 80 => 'GainControl' },
    'gammacompensatedvalue' => { 37 => 0x91 },
    'gamut' => { 31 => 'gamt' },
    'gdalmetadata' => { 24 => 0xa480 },
    'gdalnodata' => { 24 => 0xa481 },
    'geogangularunits' => { 27 => 0x806 },
    'geogangularunitsize' => { 27 => 0x807 },
    'geogazimuthunits' => { 27 => 0x80c },
    'geogcitation' => { 27 => 0x801 },
    'geogellipsoid' => { 27 => 0x808 },
    'geoggeodeticdatum' => { 27 => 0x802 },
    'geoginvflattening' => { 27 => 0x80b },
    'geoglinearunits' => { 27 => 0x804 },
    'geoglinearunitsize' => { 27 => 0x805 },
    'geogprimemeridian' => { 27 => 0x803 },
    'geogprimemeridianlong' => { 27 => 0x80d },
    'geographictype' => { 27 => 0x800 },
    'geogsemimajoraxis' => { 27 => 0x809 },
    'geogsemiminoraxis' => { 27 => 0x80a },
    'geotiffasciiparams' => { 24 => 0x87b1 },
    'geotiffdirectory' => { 24 => 0x87af },
    'geotiffdoubleparams' => { 24 => 0x87b0 },
    'geotiffversion' => { 27 => 0x1 },
    'globalparametersifd' => { 24 => 0x190 },
    'gpsaltitude' => { 26 => 0x6, 80 => 'GPSAltitude' },
    'gpsaltituderef' => { 26 => 0x5, 80 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 26 => 0x1c, 80 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 26 => 0x1d },
    'gpsdatetime' => { 81 => 'GPSDateTime' },
    'gpsdestbearing' => { 26 => 0x18, 80 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 26 => 0x17, 80 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 26 => 0x1a, 80 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 26 => 0x19, 80 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 26 => 0x14, 80 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 26 => 0x13 },
    'gpsdestlongitude' => { 26 => 0x16, 80 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 26 => 0x15 },
    'gpsdifferential' => { 26 => 0x1e, 80 => 'GPSDifferential' },
    'gpsdop' => { 26 => 0xb },
    'gpsimgdirection' => { 26 => 0x11, 80 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 26 => 0x10, 80 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 24 => 0x8825 },
    'gpslatitude' => { 26 => 0x2, 80 => 'GPSLatitude' },
    'gpslatituderef' => { 26 => 0x1 },
    'gpslongitude' => { 26 => 0x4, 80 => 'GPSLongitude' },
    'gpslongituderef' => { 26 => 0x3 },
    'gpsmapdatum' => { 26 => 0x12, 80 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 26 => 0xa },
    'gpsprocessingmethod' => { 26 => 0x1b, 80 => 'GPSProcessingMethod' },
    'gpssatellites' => { 26 => 0x8, 80 => 'GPSSatellites' },
    'gpsspeed' => { 26 => 0xd, 80 => 'GPSSpeed' },
    'gpsspeedref' => { 26 => 0xc, 80 => 'GPSSpeedRef' },
    'gpsstatus' => { 26 => 0x9, 80 => 'GPSStatus' },
    'gpstimestamp' => { 26 => 0x7, 80 => 'GPSTimeStamp' },
    'gpstrack' => { 26 => 0xf, 80 => 'GPSTrack' },
    'gpstrackref' => { 26 => 0xe, 80 => 'GPSTrackRef' },
    'gpsversionid' => { 26 => 0x0, 80 => 'GPSVersionID' },
    'graphicstechnologystandardoutput' => { 44 => 'gtso' },
    'grayresponsecurve' => { 24 => 0x123 },
    'grayresponseunit' => { 24 => 0x122 },
    'graytrc' => { 31 => 'kTRC' },
    'greenhue' => { 80 => 'GreenHue' },
    'greenmatrixcolumn' => { 31 => 'gXYZ' },
    'greensaturation' => { 80 => 'GreenSaturation' },
    'greentrc' => { 31 => 'gTRC' },
    'gtcitation' => { 27 => 0x402 },
    'gtmodeltype' => { 27 => 0x400 },
    'gtrastertype' => { 27 => 0x401 },
    'halftonehints' => { 24 => 0x141 },
    'hcusage' => { 24 => 0x84ee },
    'headline' => { 34 => 0x69, 80 => 'Headline' },
    'highlight' => { 77 => 0xf },
    'history' => { 80 => 'History' },
    'historyaction' => { 80 => 'HistoryAction' },
    'historyinstanceid' => { 80 => 'HistoryInstanceID' },
    'historyparameters' => { 80 => 'HistoryParameters' },
    'historysoftwareagent' => { 80 => 'HistorySoftwareAgent' },
    'historywhen' => { 80 => 'HistoryWhen' },
    'hostcomputer' => { 24 => 0x13c },
    'hueadjustment' => { 58 => 0x92 },
    'icc_profile' => { 24 => 0x8773 },
    'iccprofile' => { 37 => 0x42 },
    'identifier' => { 80 => 'Identifier' },
    'ifd0_offset' => { 60 => 0x1 },
    'imageadjustment' => { 58 => 0x80, 59 => 0x5 },
    'imageboundary' => { 58 => 0x16 },
    'imagecolorindicator' => { 24 => 0x84e7 },
    'imagecolorvalue' => { 24 => 0x84e9 },
    'imagedepth' => { 24 => 0x80e5 },
    'imagedescription' => { 18 => 0x2804, 24 => 0x10e, 80 => 'ImageDescription' },
    'imageformat' => { 18 => 0x1803 },
    'imageheader' => { 44 => 'ihdr' },
    'imageheight' => { 17 => 0x1, 24 => 0x101, 43 => 0x0, 80 => 'ImageLength', 82 => 'ImageHeight' },
    'imagehistory' => { 24 => [0x9213,0xa213] },
    'imageid' => { 24 => 0x800d },
    'imageinfo' => { 18 => 0x1810 },
    'imagelayer' => { 24 => 0x87ac },
    'imagenumber' => { 24 => [0x9211,0xa211] },
    'imageoptimization' => { 58 => 0xa9 },
    'imageorientation' => { 34 => 0x83 },
    'imageprintstatus' => { 24 => 0xc46e },
    'imageprocessing' => { 66 => 0x2040 },
    'imageprocessingversion' => { 65 => 0x0 },
    'imageprops' => { 18 => 0x300a },
    'imagequality' => { 68 => 0x1 },
    'imagequality2' => { 62 => 0x603 },
    'imagerotated' => { 51 => 0x2a },
    'imagerotationstatus' => { 24 => 0xc363 },
    'imagesize' => { 81 => 'ImageSize' },
    'imagesourcedata' => { 24 => 0x935c },
    'imagesourceek' => { 24 => 0xc351 },
    'imagestabilization' => { 54 => 0x18 },
    'imagestabilizer' => { 68 => 0x1a },
    'imagetype' => { 34 => 0x82 },
    'imageuniqueid' => { 24 => 0xa420, 80 => 'ImageUniqueID' },
    'imagewidth' => { 17 => 0x0, 24 => 0x100, 43 => 0x4, 80 => 'ImageWidth', 82 => 'ImageWidth' },
    'indexed' => { 24 => 0x15a },
    'inknames' => { 24 => 0x14d },
    'inkset' => { 24 => 0x14c },
    'instructions' => { 80 => 'Instructions' },
    'instructionset' => { 44 => 'inst' },
    'intellectualgenre' => { 80 => 'IntellectualGenre' },
    'intellectualproperty' => { 44 => 'jp2i' },
    'interchangecolorspace' => { 37 => 0x40 },
    'intergraphflagregisters' => { 24 => 0x847f },
    'intergraphmatrix' => { 24 => 0x8480 },
    'intergraphpacketdata' => { 24 => 0x8474 },
    'interlace' => { 24 => 0x8829 },
    'internalflash' => { 53 => 0x2b },
    'interopindex' => { 24 => 0x1 },
    'interopoffset' => { 24 => 0xa005 },
    'interopversion' => { 24 => 0x2 },
    'intervallength' => { 53 => 0x10 },
    'intervalmode' => { 53 => 0x26 },
    'intervalnumber' => { 53 => 0x11 },
    'iptc-naa' => { 24 => 0x83bb },
    'iptc-naa2' => { 24 => 0x8568 },
    'iptcapplication' => { 36 => 0x2 },
    'iptcbitspersample' => { 37 => 0x56 },
    'iptcdata' => { 71 => 0x404 },
    'iptcenvelope' => { 36 => 0x1 },
    'iptcimageheight' => { 37 => 0x1e },
    'iptcimagerotation' => { 37 => 0x66 },
    'iptcimagewidth' => { 37 => 0x14 },
    'iptcnewsphoto' => { 36 => 0x3 },
    'iptcobjectdata' => { 36 => 0x8 },
    'iptcpicturenumber' => { 37 => 0xa },
    'iptcpixelheight' => { 37 => 0x32 },
    'iptcpixelwidth' => { 37 => 0x28 },
    'iptcpostobjectdata' => { 36 => 0x9 },
    'iptcpreobjectdata' => { 36 => 0x7 },
    'iso' => { 8 => 0x2, 23 => 0x14, 24 => 0x8827, 58 => 0x2, 69 => 0x14, 80 => 'ISOSpeedRatings' },
    'isoexpansion' => { 13 => 0x7 },
    'isoselection' => { 58 => 0xf },
    'isosetting' => { 46 => 0x5e, 53 => 0x24, 58 => 0x13 },
    'isospeedexpansion' => { 12 => 0x3 },
    'isoused' => { 46 => 0x60, 51 => 0x1e },
    'it8header' => { 24 => 0x84e2 },
    'ixusafpoint' => { 8 => 0xe },
    'jobref' => { 80 => 'JobRef' },
    'jobrefid' => { 80 => 'JobRefId' },
    'jobrefname' => { 80 => 'JobRefName' },
    'jobrefurl' => { 80 => 'JobRefUrl' },
    'jp2header' => { 44 => 'jp2h' },
    'jp2signature' => { 44 => ['jP','jP  '] },
    'jpeg_quality' => { 71 => 0x406 },
    'jpegactables' => { 24 => 0x209 },
    'jpegdctables' => { 24 => 0x208 },
    'jpeglosslesspredictors' => { 24 => 0x205 },
    'jpegpointtransforms' => { 24 => 0x206 },
    'jpegproc' => { 24 => 0x200 },
    'jpegqtables' => { 24 => 0x207 },
    'jpegrestartinterval' => { 24 => 0x203 },
    'jpegtables' => { 24 => 0x15b },
    'jpgfromraw' => { 18 => 0x2007, 81 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 24 => 0x202 },
    'jpgfromrawstart' => { 24 => 0x201 },
    'keywords' => { 34 => 0x19, 80 => 'Keywords' },
    'kodakbordersifd' => { 24 => 0xc36f },
    'kodakeffectsifd' => { 24 => 0xc36e },
    'kodakexposure?' => { 46 => 0x20 },
    'kodakimageheight' => { 46 => 0xe },
    'kodakimagewidth' => { 46 => 0xc },
    'kodakmaker' => { 48 => 0x8 },
    'kodakmodel' => { 46 => 0x0, 48 => 0x28 },
    'label' => { 44 => 'lbl ' },
    'language' => { 80 => 'Language' },
    'languageidentifier' => { 34 => 0x87 },
    'lastfilenumber' => { 53 => 0x1b },
    'lasturl' => { 80 => 'LastURL' },
    'lcdpanels' => { 12 => 0x8 },
    'lens' => { 24 => 0xfdea, 58 => 0x84, 77 => 0xa, 80 => 'Lens', 81 => 'Lens' },
    'lens35efl' => { 81 => 'Lens35efl' },
    'lensafstopbutton' => { 10 => 0x9, 11 => 0x11, 12 => 0x13, 13 => 0x10 },
    'lensserialnumber' => { 63 => 0x202 },
    'lensspec' => { 81 => 'LensSpec' },
    'lenstype' => { 0 => 0x16, 58 => 0x83, 69 => 0x3f },
    'lightsource' => { 24 => 0x9208, 58 => 0x90, 80 => 'LightSource' },
    'lightsourcespecial' => { 76 => 0x21d },
    'linearizationtable' => { 24 => 0xc618 },
    'linearresponselimit' => { 24 => 0xc62e },
    'localizedcameramodel' => { 24 => 0xc615 },
    'location' => { 80 => 'Location' },
    'longexposurenoisereduction' => { 10 => 0x1, 13 => 0x1 },
    'longfocal' => { 0 => 0x17 },
    'lookuptable' => { 37 => 0x50 },
    'luminance' => { 31 => 'lumi' },
    'luminancesmoothing' => { 80 => 'LuminanceSmoothing' },
    'macro' => { 25 => 0x1020, 51 => 0x2b, 66 => 0x202, 76 => 0x202 },
    'macrofocus' => { 66 => 0x100e },
    'macromode' => { 0 => 0x1, 46 => 0xb, 53 => 0xb, 68 => 0x1c },
    'magnification' => { 24 => 0xc367 },
    'make' => { 19 => 0x0, 24 => 0x10f, 80 => 'Make' },
    'makeandmodel' => { 31 => 'mmod' },
    'makernote' => { 80 => 'MakerNote' },
    'makernotecanon' => { 24 => 0x927c },
    'makernotecasio' => { 24 => 0x927c },
    'makernotecasio2' => { 24 => 0x927c },
    'makernotecasioex-z3' => { 24 => 0x927c },
    'makernotefujifilm' => { 24 => 0x927c },
    'makernotekodak' => { 24 => 0x927c },
    'makernotekodak1' => { 24 => 0x927c },
    'makernotekodak2' => { 24 => 0x927c },
    'makernotekodak3' => { 24 => 0x927c },
    'makernotekodak4' => { 24 => 0x927c },
    'makernotekodak5' => { 24 => 0x927c },
    'makernotekodakunknown' => { 24 => 0x927c },
    'makernoteleica' => { 24 => 0x927c },
    'makernoteminolta' => { 24 => 0x927c },
    'makernotenikon' => { 24 => 0x927c },
    'makernotenikon2' => { 24 => 0x927c },
    'makernotenikon3' => { 24 => 0x927c },
    'makernoteoffset' => { 76 => 0xff },
    'makernoteolympus' => { 24 => 0x927c },
    'makernotepanasonic' => { 24 => 0x927c },
    'makernotepentax' => { 24 => 0x927c },
    'makernotericoh' => { 24 => 0x927c },
    'makernotericoh2' => { 24 => 0x927c },
    'makernotesafety' => { 24 => 0xc635 },
    'makernotesanyo' => { 24 => 0x927c },
    'makernotesigma' => { 24 => 0x927c },
    'makernotesony' => { 24 => 0x927c },
    'makernotetype' => { 73 => 0x1 },
    'makernoteunknown' => { 24 => 0x927c },
    'makernoteversion' => { 54 => 0x0, 66 => 0x0, 73 => 0x2 },
    'managedfrom' => { 80 => 'ManagedFrom' },
    'managedfromdocumentid' => { 80 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 80 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 80 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 80 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 80 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 80 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 80 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 80 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 80 => 'ManagedFromVersionID' },
    'manager' => { 80 => 'Manager' },
    'managervariant' => { 80 => 'ManagerVariant' },
    'manageto' => { 80 => 'ManageTo' },
    'manageui' => { 80 => 'ManageUI' },
    'manualfocusdistance' => { 58 => 0x85, 76 => 0x223 },
    'manualtv' => { 12 => 0x5 },
    'marked' => { 80 => 'Marked' },
    'matteing' => { 24 => 0x80e3 },
    'maxaperture' => { 53 => 0x17 },
    'maxapertureatmaxfocal' => { 63 => 0x206 },
    'maxaperturevalue' => { 24 => 0x9205, 80 => 'MaxApertureValue' },
    'maxfocallength' => { 63 => 0x208 },
    'maximumdensityrange' => { 37 => 0x8c },
    'maximumobjectsize' => { 40 => 0x5f },
    'maxsamplevalue' => { 24 => 0x119 },
    'maxsubfilesize' => { 40 => 0x14 },
    'measuredev' => { 18 => 0x1814 },
    'measuredinfo' => { 18 => 0x3003 },
    'measurement' => { 31 => 'meas' },
    'measurementbacking' => { 32 => 0xc },
    'measurementflare' => { 32 => 0x1c },
    'measurementgeometry' => { 32 => 0x18 },
    'measurementilluminant' => { 32 => 0x20 },
    'measurementobserver' => { 32 => 0x8 },
    'mediablackpoint' => { 31 => 'bkpt' },
    'mediadata' => { 44 => 'mdat' },
    'mediawhitepoint' => { 31 => 'wtpt' },
    'menubuttondisplayposition' => { 11 => 0xb, 13 => 0xa },
    'menubuttonreturn' => { 10 => 0xb },
    'metadatadate' => { 80 => 'MetadataDate' },
    'metadatanumber' => { 24 => 0xc365 },
    'meteringmode' => { 0 => 0x11, 24 => 0x9207, 46 => 0x1c, 53 => 0x7, 62 => 0x202, 69 => 0x17, 77 => 0x9, 80 => 'MeteringMode' },
    'minfocallength' => { 63 => 0x207 },
    'minoltaaperture' => { 53 => 0xa },
    'minoltacamerasettings' => { 54 => 0x3, 66 => 0x3 },
    'minoltacamerasettings2' => { 54 => 0xf00 },
    'minoltacamerasettingsold' => { 54 => 0x1, 66 => 0x1 },
    'minoltadate' => { 53 => 0x15 },
    'minoltaimagesize' => { 53 => 0x4 },
    'minoltaiso' => { 53 => 0x8 },
    'minoltamodel' => { 53 => 0x25 },
    'minoltaquality' => { 53 => 0x5, 54 => [0x102,0x103], 66 => [0x102,0x103] },
    'minoltashutterspeed' => { 53 => 0x9 },
    'minoltatime' => { 53 => 0x16 },
    'minsamplevalue' => { 24 => 0x118 },
    'mirrorlockup' => { 10 => 0x3, 11 => 0xc, 12 => 0xc, 13 => 0xb },
    'moddate' => { 80 => 'ModDate' },
    'model' => { 19 => 0x6, 24 => 0x110, 80 => 'Model' },
    'model2' => { 24 => 0x827d },
    'modelandversion' => { 24 => 0xc35c },
    'modeltiepoint' => { 24 => 0x8482 },
    'modeltransform' => { 24 => 0x85d8 },
    'modenumber' => { 24 => 0x195 },
    'modifiedsaturation' => { 62 => 0x504 },
    'modifydate' => { 24 => 0x132, 80 => 'ModifyDate' },
    'moirefilter' => { 24 => 0xfe58 },
    'mpeg7binary' => { 44 => 'mp7b' },
    'namedcolor' => { 31 => 'ncol' },
    'namedcolor2' => { 31 => 'ncl2' },
    'nativedisplayinfo' => { 31 => 'ndin' },
    'nativeresolutionunit' => { 24 => 0xc37a },
    'nativexresolution' => { 24 => 0xc36c },
    'nativeyresolution' => { 24 => 0xc36d },
    'nefcurve1' => { 58 => 0x8c },
    'nefcurve2' => { 58 => 0x96 },
    'nefthumbnailsize' => { 58 => 0x99 },
    'newsphotoversion' => { 37 => 0x0 },
    'nickname' => { 80 => 'Nickname' },
    'nikoncaptureoffsets' => { 58 => 0xe0e },
    'nikonpreview' => { 58 => 0x11 },
    'noise' => { 24 => [0x920d,0xa20d] },
    'noisefilter' => { 62 => 0x50a },
    'noisefilter2' => { 65 => 0x1010 },
    'noisereduction' => { 58 => 0x95, 68 => 0x2d },
    'nullrecord' => { 18 => 0x0 },
    'numberlist' => { 44 => 'nlst' },
    'numberofcomponents' => { 43 => 0x8 },
    'numberofinks' => { 24 => 0x14e },
    'numindexentries' => { 37 => 0x54 },
    'objectattributereference' => { 34 => 0x4 },
    'objectcycle' => { 34 => 0x4b },
    'objectdistance' => { 22 => 0x6, 23 => 0x2022 },
    'objectname' => { 34 => 0x5 },
    'objectpreviewdata' => { 34 => 0xca },
    'objectpreviewfileformat' => { 34 => 0xc8 },
    'objectpreviewfileversion' => { 34 => 0xc9 },
    'objectsizeannounced' => { 40 => 0x5a },
    'objecttypereference' => { 34 => 0x3 },
    'oceapplicationselector' => { 24 => 0xc428 },
    'oceidnumber' => { 24 => 0xc429 },
    'oceimagelogic' => { 24 => 0xc42a },
    'ocescanjobdesc' => { 24 => 0xc427 },
    'oecfcolumns' => { 80 => 'OECFColumns' },
    'oecfnames' => { 80 => 'OECFNames' },
    'oecfrows' => { 80 => 'OECFRows' },
    'oecfvalues' => { 80 => 'OECFValues' },
    'oldsubfiletype' => { 24 => 0xff },
    'olympusimageheight' => { 66 => 0x102f },
    'olympusimageheight2' => { 65 => 0x615 },
    'olympusimagewidth' => { 66 => 0x102e },
    'olympusimagewidth2' => { 65 => 0x614 },
    'opacity' => { 44 => 'opct' },
    'opiproxy' => { 24 => 0x15f },
    'opticalzoomon' => { 76 => 0x219 },
    'opto-electricconvfactor' => { 24 => 0x8828, 80 => 'OECF' },
    'orientation' => { 24 => 0x112, 80 => 'Orientation' },
    'originalfilename' => { 18 => 0x816, 50 => 0x20 },
    'originaltransmissionreference' => { 34 => 0x67 },
    'originatingprogram' => { 34 => 0x41 },
    'otherimagelength' => { 24 => 0x202 },
    'otherimagestart' => { 24 => 0x201 },
    'outputresponse' => { 31 => 'resp' },
    'owner' => { 80 => 'Owner' },
    'ownername' => { 5 => 0x9, 18 => 0x810, 24 => 0xfde8 },
    'pagename' => { 24 => 0x11d },
    'pagenumber' => { 24 => 0x129 },
    'palette' => { 44 => 'pclr' },
    'panoramamode' => { 46 => 0x3c },
    'pcscitation' => { 27 => 0xc01 },
    'pdfversion' => { 80 => 'PDFVersion' },
    'pentaximagesize' => { 69 => 0x9 },
    'pentaxmode' => { 69 => 0x1 },
    'photometricinterpretation' => { 24 => 0x106, 80 => 'PhotometricInterpretation' },
    'photoshopformat' => { 70 => 0x1 },
    'photoshopquality' => { 70 => 0x0 },
    'photoshopsettings' => { 24 => 0x8649 },
    'photoshopthumbnail' => { 71 => 0x40c },
    'pictinfo' => { 76 => 0x208 },
    'pictureinfo' => { 66 => 0x208 },
    'picturemode' => { 25 => 0x1031, 69 => 0xb },
    'pixelaspectratio' => { 17 => 0x2 },
    'pixelintensityrange' => { 24 => 0x84eb },
    'pixelscale' => { 24 => 0x830e },
    'planarconfiguration' => { 24 => 0x11c, 80 => 'PlanarConfiguration' },
    'postscript2crd0' => { 31 => 'psd0' },
    'postscript2crd1' => { 31 => 'psd1' },
    'postscript2crd2' => { 31 => 'psd2' },
    'postscript2csa' => { 31 => 'ps2s' },
    'predictor' => { 24 => 0x13d },
    'preview0' => { 31 => 'pre0' },
    'preview1' => { 31 => 'pre1' },
    'preview2' => { 31 => 'pre2' },
    'previewfocalplanexresolution' => { 7 => 0x6 },
    'previewfocalplaneyresolution' => { 7 => 0x8 },
    'previewifd_offset' => { 60 => 0x2 },
    'previewimage' => { 23 => 0x2000, 81 => 'PreviewImage', 82 => 'PreviewImage' },
    'previewimagedata' => { 54 => 0x81, 66 => 0x81 },
    'previewimageheight' => { 7 => 0x4 },
    'previewimageinfo' => { 5 => 0xb6 },
    'previewimagelength' => { 7 => 0x2, 24 => [0x117,0x202], 54 => 0x89, 61 => 0x202, 62 => 0x102, 66 => 0x89, 69 => 0x3 },
    'previewimagesize' => { 23 => 0x2, 69 => 0x2, 81 => 'PreviewImageSize' },
    'previewimagestart' => { 7 => 0x5, 24 => [0x111,0x201], 54 => 0x88, 61 => 0x201, 62 => 0x101, 66 => 0x88, 69 => 0x4 },
    'previewimagewidth' => { 7 => 0x3 },
    'primarychromaticities' => { 24 => 0x13f, 80 => 'PrimaryChromaticities' },
    'primaryplatform' => { 30 => 0x28 },
    'printim' => { 23 => 0xe00, 24 => 0xc4a5, 54 => 0xe00, 58 => 0xe00, 66 => 0xe00, 68 => 0xe00, 69 => 0xe00, 73 => 0xe00, 76 => 0xe00, 78 => 0xe00, 79 => 0xe00 },
    'printquality' => { 24 => 0xc46c },
    'processgeotiff' => { 81 => 'ProcessGeoTiff' },
    'producer' => { 80 => 'Producer' },
    'productid' => { 35 => 0x32 },
    'profile' => { 44 => 'prfl' },
    'profileclass' => { 30 => 0xc },
    'profilecmmtype' => { 30 => 0x4 },
    'profileconnectionspace' => { 30 => [0x14,0x44] },
    'profilecreator' => { 30 => 0x50 },
    'profiledatetime' => { 30 => 0x18 },
    'profiledescription' => { 31 => 'desc' },
    'profiledescriptionml' => { 31 => 'dscm' },
    'profilefilesignature' => { 30 => 0x24 },
    'profileheader' => { 31 => 'Header' },
    'profileid' => { 30 => 0x54 },
    'profilesequencedesc' => { 31 => 'pseq' },
    'profiletype' => { 24 => 0x191 },
    'profileversion' => { 30 => 0x8 },
    'programversion' => { 34 => 0x46 },
    'progressivescans' => { 70 => 0x2 },
    'projazimuthangle' => { 27 => 0xc16 },
    'projcentereasting' => { 27 => 0xc12 },
    'projcenterlat' => { 27 => 0xc11 },
    'projcenterlong' => { 27 => 0xc10 },
    'projcenternorthing' => { 27 => 0xc13 },
    'projcoordtrans' => { 27 => 0xc03 },
    'projectedcstype' => { 27 => 0xc00 },
    'projection' => { 27 => 0xc02 },
    'projfalseeasting' => { 27 => 0xc0a },
    'projfalsenorthing' => { 27 => 0xc0b },
    'projfalseorigineasting' => { 27 => 0xc0e },
    'projfalseoriginlat' => { 27 => 0xc0d },
    'projfalseoriginlong' => { 27 => 0xc0c },
    'projfalseoriginnorthing' => { 27 => 0xc0f },
    'projlinearunits' => { 27 => 0xc04 },
    'projlinearunitsize' => { 27 => 0xc05 },
    'projnatoriginlat' => { 27 => 0xc09 },
    'projnatoriginlong' => { 27 => 0xc08 },
    'projrectifiedgridangle' => { 27 => 0xc18 },
    'projscaleatcenter' => { 27 => 0xc15 },
    'projscaleatnatorigin' => { 27 => 0xc14 },
    'projstdparallel1' => { 27 => 0xc06 },
    'projstdparallel2' => { 27 => 0xc07 },
    'projstraightvertpolelong' => { 27 => 0xc17 },
    'province-state' => { 34 => 0x5f },
    'ps2crdvmsize' => { 31 => 'psvm' },
    'ps2renteringintent' => { 31 => 'ps2i' },
    'publisher' => { 80 => 'Publisher' },
    'quality' => { 0 => 0x3, 22 => 0x2, 23 => 0x3002, 25 => 0x1000, 58 => 0x4, 59 => 0x3, 66 => 0x201, 69 => 0x8, 77 => 0x16 },
    'qualitymode' => { 23 => 0x8 },
    'quantizationmethod' => { 37 => 0x78 },
    'quickshot' => { 76 => 0x213 },
    'rasterizedcaption' => { 34 => 0x7d },
    'rasterpadding' => { 24 => 0x84e3 },
    'rawandjpgrecording' => { 11 => 0x8 },
    'rawdata' => { 18 => 0x2005 },
    'rawfile' => { 24 => 0xfe4c },
    'rawfilename' => { 80 => 'RawFileName' },
    'rawimagesize' => { 69 => 0x39 },
    'readerrequirements' => { 44 => 'rreq' },
    'recordid' => { 18 => 0x1804 },
    'recordingmode' => { 22 => 0x1 },
    'recordmode' => { 23 => 0x3000 },
    'recordshutterrelease' => { 76 => 0x217 },
    'redbalance' => { 55 => 0x0, 56 => 0x0, 57 => 0x0, 66 => 0x1017 },
    'redbalanceauto' => { 9 => 0x0 },
    'redbalanceb&w' => { 9 => 0xe },
    'redbalancecloudy' => { 9 => 0x4 },
    'redbalancecustom' => { 9 => 0xc },
    'redbalancedaylight' => { 9 => 0x2 },
    'redbalanceflash' => { 9 => 0xa },
    'redbalancefluorescent' => { 9 => 0x8 },
    'redbalanceshade' => { 9 => 0x10 },
    'redbalancetungsten' => { 9 => 0x6 },
    'redeyereduction' => { 81 => 'RedEyeReduction' },
    'redhue' => { 80 => 'RedHue' },
    'redmatrixcolumn' => { 31 => 'rXYZ' },
    'redsaturation' => { 80 => 'RedSaturation' },
    'redtrc' => { 31 => 'rTRC' },
    'reductionmatrix1' => { 24 => 0xc625 },
    'reductionmatrix2' => { 24 => 0xc626 },
    'referenceblackwhite' => { 24 => 0x214, 80 => 'ReferenceBlackWhite' },
    'referencedate' => { 34 => 0x2f },
    'referencenumber' => { 34 => 0x32 },
    'referenceservice' => { 34 => 0x2d },
    'relatedimagefileformat' => { 24 => 0x1000 },
    'relatedimagelength' => { 24 => 0x1002 },
    'relatedimagewidth' => { 24 => 0x1001 },
    'relatedsoundfile' => { 24 => 0xa004, 80 => 'RelatedSoundFile' },
    'relation' => { 80 => 'Relation' },
    'releasedate' => { 34 => 0x1e },
    'releasesetting' => { 18 => 0x1016 },
    'releasetime' => { 34 => 0x23 },
    'renderingintent' => { 30 => 0x40 },
    'renditionclass' => { 80 => 'RenditionClass' },
    'renditionof' => { 80 => 'RenditionOf' },
    'renditionofdocumentid' => { 80 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 80 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 80 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 80 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 80 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 80 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 80 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 80 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 80 => 'RenditionOfVersionID' },
    'renditionparams' => { 80 => 'RenditionParams' },
    'resaved' => { 76 => 0x21e },
    'resolution' => { 44 => 'res ' },
    'resolutionmode' => { 77 => 0x4 },
    'resolutionunit' => { 24 => 0x128, 61 => 0x128, 80 => 'ResolutionUnit' },
    'revision' => { 75 => ['Rev','Rv'] },
    'ricohdatetime1' => { 74 => 0x4 },
    'ricohdatetime2' => { 74 => 0x5 },
    'ricohrr1subdir' => { 73 => 0x2001 },
    'ricohsubdir' => { 73 => 0x2001 },
    'rights' => { 80 => 'Rights' },
    'roidescription' => { 44 => 'roid' },
    'rollguidelements' => { 24 => 0xc364 },
    'romoperationmode' => { 18 => 0x80d },
    'rotation' => { 17 => 0x3 },
    'rowsperstrip' => { 24 => 0x116 },
    'safetyshiftinavortv' => { 11 => 0x10, 12 => 0x10, 13 => 0xf },
    'sampleformat' => { 24 => 0x153 },
    'samplesperpixel' => { 24 => 0x115, 80 => 'SamplesPerPixel' },
    'samplestructure' => { 37 => 0x5a },
    'sanyoquality' => { 76 => 0x201 },
    'sanyothumbnail' => { 76 => 0x100 },
    'saturation' => { 0 => 0xe, 22 => 0xd, 23 => 0x1f, 24 => [0xa409,0xfe55], 25 => 0x1003, 53 => 0x1f, 58 => [0x94,0xaa], 69 => 0x1f, 77 => 0x10, 80 => 'Saturation' },
    'saveid' => { 80 => 'SaveID' },
    'sba_rgbshifts' => { 24 => 0xc35e },
    'sbaexposurerecord' => { 24 => 0xc361 },
    'sbainputimagebitdepth' => { 24 => 0xc360 },
    'sbainputimagecolorspace' => { 24 => 0xc35f },
    'scalefactor35efl' => { 81 => 'ScaleFactor35efl' },
    'scanningdirection' => { 37 => 0x64 },
    'scene' => { 80 => 'Scene' },
    'scenecapturetype' => { 24 => 0xa406, 80 => 'SceneCaptureType' },
    'scenemode' => { 58 => 0x8f },
    'sceneselect' => { 76 => 0x21f },
    'scenetype' => { 24 => 0xa301, 80 => 'SceneType' },
    'screening' => { 31 => 'scrn' },
    'screeningdesc' => { 31 => 'scrd' },
    'securityclassification' => { 24 => [0x9212,0xa212] },
    'self-timer' => { 0 => 0x2 },
    'self-timer2' => { 8 => 0x1d },
    'selftimer' => { 23 => 0x3001, 76 => 0x214 },
    'selftimermode' => { 24 => 0x882b },
    'selftimertime' => { 18 => 0x1806 },
    'sensingmethod' => { 24 => [0x9217,0xa217], 80 => 'SensingMethod' },
    'sensorbottomborder' => { 20 => 0x8 },
    'sensorcleaning' => { 10 => 0xd },
    'sensorheight' => { 20 => 0x2 },
    'sensorinfo' => { 18 => 0x1031 },
    'sensorleftborder' => { 20 => 0x5 },
    'sensorrightborder' => { 20 => 0x7 },
    'sensortopborder' => { 20 => 0x6 },
    'sensorwidth' => { 20 => 0x1 },
    'sequence' => { 62 => 0x600 },
    'sequencenumber' => { 8 => 0x9, 46 => 0x1d },
    'sequenceshotinterval' => { 76 => 0x224 },
    'sequentialshot' => { 76 => 0x20e },
    'serialnumber' => { 5 => 0xc, 18 => 0x180b, 24 => [0xc354,0xfde9], 58 => 0xa0, 63 => 0x101, 66 => 0x101a, 68 => 0x25, 77 => 0x2, 80 => 'SerialNumber' },
    'serviceidentifier' => { 35 => 0x1e },
    'setbuttonfunction' => { 10 => 0xc, 11 => 0x1 },
    'setfunctionwhenshooting' => { 13 => 0x0 },
    'shadingcompensation' => { 62 => 0x50c },
    'shadingcompensation2' => { 65 => 0x1012 },
    'shadow' => { 77 => 0xe },
    'shadows' => { 24 => 0xfe52, 80 => 'Shadows' },
    'shadowscale' => { 24 => 0xc633 },
    'shadowtint' => { 80 => 'ShadowTint' },
    'sharpness' => { 0 => 0xf, 22 => 0xb, 23 => 0x21, 24 => [0xa40a,0xfe56], 25 => 0x1001, 46 => 0x6b, 53 => 0x21, 58 => 0x6, 69 => 0x21, 77 => 0x11, 80 => 'Sharpness' },
    'sharpnessfactor' => { 66 => [0x100f,0x102a] },
    'sharpnesssetting' => { 62 => 0x506 },
    'shootingmode' => { 58 => 0x89, 68 => 0x1f, 81 => 'ShootingMode' },
    'shootingrecord' => { 18 => 0x3002 },
    'shortfocal' => { 0 => 0x18 },
    'shutter-aelock' => { 10 => 0x2, 11 => 0x4, 13 => 0x3 },
    'shutteraelbutton' => { 12 => 0x4 },
    'shuttercount' => { 58 => 0xa7 },
    'shuttercurtainhack' => { 81 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 10 => 0x8, 11 => 0xf, 12 => 0xf, 13 => 0xe },
    'shuttermode' => { 46 => 0x1b },
    'shutterreleasemethod' => { 18 => 0x1010 },
    'shutterreleasenocfcard' => { 10 => 0xf, 11 => 0x2, 12 => 0x2 },
    'shutterreleasetiming' => { 18 => 0x1011 },
    'shutterspeed' => { 81 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 24 => 0x9201, 80 => 'ShutterSpeedValue' },
    'site' => { 24 => 0x84e0 },
    'sizemode' => { 40 => 0xa },
    'slowsync' => { 25 => 0x1030 },
    'smaxsamplevalue' => { 24 => 0x155 },
    'sminsamplevalue' => { 24 => 0x154 },
    'smoothingparameter1' => { 65 => 0x300 },
    'smoothingparameter2' => { 65 => 0x310 },
    'smoothingthreshold2' => { 65 => 0x610 },
    'smoothingthresholds' => { 65 => 0x600 },
    'smoothness' => { 24 => 0xfe57 },
    'software' => { 24 => 0x131, 77 => 0x18, 80 => 'Software' },
    'softwareversion' => { 76 => 0x207 },
    'source' => { 34 => 0x73, 80 => 'Source' },
    'sourceimagedirectory' => { 24 => 0xc418 },
    'sourceimagefilename' => { 24 => 0xc419 },
    'sourceimagevolumename' => { 24 => 0xc41a },
    'spatialfrequencyresponse' => { 24 => [0x920c,0xa20c], 80 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 80 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 80 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 80 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 80 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 34 => 0x28 },
    'specialmode' => { 66 => 0x200, 76 => 0x200 },
    'spectralsensitivity' => { 24 => 0x8824, 80 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 53 => 0x2d },
    'spotfocuspointy' => { 53 => 0x2e },
    'spotmode' => { 68 => 0xf },
    'state' => { 80 => 'State' },
    'stonits' => { 24 => 0x923f },
    'stripbytecounts' => { 24 => 0x117 },
    'stripoffsets' => { 24 => 0x111 },
    'striprowcounts' => { 24 => 0x22f },
    'sub-location' => { 34 => 0x5c },
    'subdir3' => { 66 => 0x2030 },
    'subdir3version' => { 67 => 0x0 },
    'subfile' => { 38 => 0xa },
    'subfiletype' => { 24 => 0xfe },
    'subifd' => { 24 => 0x14a },
    'subifd_offset' => { 60 => 0x3 },
    'subject' => { 80 => 'Subject' },
    'subjectarea' => { 80 => 'SubjectArea' },
    'subjectcode' => { 80 => 'SubjectCode' },
    'subjectdistance' => { 24 => 0x9206, 46 => 0x3e, 80 => 'SubjectDistance' },
    'subjectdistancerange' => { 24 => 0xa40c, 80 => 'SubjectDistanceRange' },
    'subjectlocation' => { 24 => [0x9214,0xa214], 80 => 'SubjectLocation' },
    'subjectprogram' => { 53 => 0x22 },
    'subjectreference' => { 34 => 0xc },
    'subsecdatetimeoriginal' => { 81 => 'SubSecDateTimeOriginal' },
    'subsectime' => { 24 => 0x9290 },
    'subsectimedigitized' => { 24 => 0x9292 },
    'subsectimeoriginal' => { 24 => 0x9291 },
    'superimposeddisplay' => { 10 => 0xe, 11 => 0xa, 13 => 0x9 },
    'supplementalcategories' => { 34 => 0x14, 80 => 'SupplementalCategories' },
    'supplementaltype' => { 37 => 0x37 },
    'switchtoregisteredafpoint' => { 12 => 0x12 },
    't4options' => { 24 => 0x124 },
    't6options' => { 24 => 0x125 },
    'targetcompressionratio' => { 16 => 0x1 },
    'targetdistancesetting' => { 18 => 0x1807 },
    'targetimagetype' => { 18 => 0x100a },
    'targetprinter' => { 24 => 0x151 },
    'technology' => { 31 => 'tech' },
    'thresholding' => { 24 => 0x107 },
    'thumbnailfilename' => { 18 => 0x817 },
    'thumbnailimage' => { 18 => 0x2008, 66 => 0x100, 81 => 'ThumbnailImage' },
    'thumbnaillength' => { 24 => 0x202 },
    'thumbnailoffset' => { 24 => 0x201 },
    'thumbnails' => { 80 => 'Thumbnails' },
    'thumbnailsformat' => { 80 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 80 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 80 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 80 => 'ThumbnailsWidth' },
    'tiff-epstandardid' => { 24 => [0x9216,0xa216] },
    'tilebytecounts' => { 24 => 0x145 },
    'tiledepth' => { 24 => 0x80e6 },
    'tilelength' => { 24 => 0x143 },
    'tileoffsets' => { 24 => 0x144 },
    'tilewidth' => { 24 => 0x142 },
    'time' => { 46 => 0x14, 49 => 0x10, 69 => 0x7 },
    'timecreated' => { 34 => 0x3c },
    'timesent' => { 35 => 0x50 },
    'timestamp' => { 18 => 0x180e },
    'timezone' => { 23 => 0x3006 },
    'timezonecode' => { 21 => 0x1 },
    'timezoneinfo' => { 21 => 0x2 },
    'timezoneoffset' => { 24 => 0x882a },
    'title' => { 80 => 'Title' },
    'tonecomp' => { 58 => 0x81 },
    'tonecurve' => { 69 => 0x402 },
    'tonecurves' => { 69 => 0x403 },
    'totalzoomfactor' => { 46 => 0x62, 51 => 0x20 },
    'transferfunction' => { 24 => 0x12d, 80 => 'TransferFunction' },
    'transferrange' => { 24 => 0x156 },
    'transmissionreference' => { 80 => 'TransmissionReference' },
    'transparencyindicator' => { 24 => 0x84ec },
    'tvvalue' => { 14 => 0x1 },
    'type' => { 80 => 'Type' },
    'ucrbg' => { 31 => 'bfd ' },
    'uniquecameramodel' => { 24 => 0xc614 },
    'uniqueobjectname' => { 35 => 0x64 },
    'urgency' => { 34 => 0xa, 80 => 'Urgency' },
    'url' => { 44 => 'url ', 71 => 0x40b },
    'usageterms' => { 80 => 'UsageTerms' },
    'useradjsba_rgbshifts' => { 24 => 0xc362 },
    'usercomment' => { 18 => 0x805, 24 => 0x9286, 80 => 'UserComment' },
    'userselectgrouptitle' => { 24 => 0xc355 },
    'usmlenselectronicmf' => { 12 => 0x7 },
    'uuid-geojp2' => { 44 => 'uuid' },
    'uuid-unknown' => { 44 => 'uuid' },
    'uuid-xmp' => { 44 => 'uuid' },
    'uuidinfo' => { 44 => 'uinf' },
    'uuidlist' => { 44 => 'ulst' },
    'validbits' => { 66 => 0x102c },
    'variousmodes2?' => { 46 => 0x3a },
    'variousmodes?' => { 46 => 0x26 },
    'variprogram' => { 58 => 0xab },
    'version' => { 25 => 0x0, 80 => 'Version' },
    'versionid' => { 80 => 'VersionID' },
    'versions' => { 80 => 'Versions' },
    'versionscomments' => { 80 => 'VersionsComments' },
    'versionsevent' => { 80 => 'VersionsEvent' },
    'versionseventaction' => { 80 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 80 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 80 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 80 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 80 => 'VersionsEventWhen' },
    'versionsmodifier' => { 80 => 'VersionsModifier' },
    'versionsmodifydate' => { 80 => 'VersionsModifyDate' },
    'versionsversion' => { 80 => 'VersionsVersion' },
    'versionyear' => { 24 => 0x194 },
    'verticalcitation' => { 27 => 0x1001 },
    'verticalcstype' => { 27 => 0x1000 },
    'verticaldatum' => { 27 => 0x1002 },
    'verticalunits' => { 27 => 0x1003 },
    'videocardgamma' => { 31 => 'vcgt' },
    'viewingconddesc' => { 31 => 'vued' },
    'viewingcondilluminant' => { 33 => 0x8 },
    'viewingcondilluminanttype' => { 33 => 0x20 },
    'viewingconditions' => { 31 => 'view' },
    'viewingcondsurround' => { 33 => 0x14 },
    'vignetteamount' => { 80 => 'VignetteAmount' },
    'vignettemidpoint' => { 80 => 'VignetteMidpoint' },
    'voicememo' => { 76 => 0x216 },
    'wangannotation' => { 24 => 0x80a4 },
    'warning' => { 82 => 'Warning' },
    'watermarktype' => { 45 => 0x8 },
    'webstatement' => { 80 => 'WebStatement' },
    'whitebalance' => { 8 => 0x7, 22 => 0x7, 23 => [0x19,0x2012], 24 => [0xa403,0xfe4e], 25 => 0x1002, 46 => 0x40, 51 => 0x1a, 53 => 0x3, 58 => 0x5, 59 => 0x7, 66 => 0x1015, 68 => 0x3, 69 => 0x19, 77 => 0x7, 80 => 'WhiteBalance' },
    'whitebalancebias' => { 23 => 0x2011, 68 => 0x23 },
    'whitebalancebracket' => { 62 => 0x502 },
    'whitebalancefinetune' => { 58 => 0xb },
    'whitebalancemode' => { 69 => 0x1a },
    'whitebalancetable' => { 5 => 0xa9, 18 => 0x10a9 },
    'whitebalancetemperature' => { 62 => 0x501 },
    'whitelevel' => { 24 => 0xc61d },
    'whitepoint' => { 24 => 0x13e, 69 => 0x201, 80 => 'WhitePoint' },
    'widefocuszone' => { 53 => 0x2f },
    'widerange' => { 76 => 0x20f },
    'writer-editor' => { 34 => 0x7a },
    'x3filllight' => { 77 => 0x12 },
    'xclippathunits' => { 24 => 0x158 },
    'xml' => { 44 => 'xml ' },
    'xpauthor' => { 24 => 0x9c9d },
    'xpcomment' => { 24 => 0x9c9c },
    'xpkeywords' => { 24 => 0x9c9e },
    'xposition' => { 24 => 0x11e },
    'xpsubject' => { 24 => 0x9c9f },
    'xptitle' => { 24 => 0x9c9b },
    'xresolution' => { 24 => 0x11a, 61 => 0x11a, 80 => 'XResolution' },
    'ycbcrcoefficients' => { 24 => 0x211, 80 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 24 => 0x213, 61 => 0x213 },
    'ycbcrsubsampling' => { 24 => 0x212, 80 => 'YCbCrSubSampling' },
    'yclippathunits' => { 24 => 0x159 },
    'yposition' => { 24 => 0x11f },
    'yresolution' => { 24 => 0x11b, 61 => 0x11b, 80 => 'YResolution' },
    'zoom' => { 66 => 0x100d },
    'zoomedresolution' => { 0 => 0x24 },
    'zoomedresolutionbase' => { 0 => 0x25 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool|Image::ExifTool>
L<Image::ExifTool::BuildTagLookup|Image::ExifTool::BuildTagLookup>

=cut
