package Net::SSLLabs::Suite;

use strict;
use warnings;
use Net::SSLLabs::Suite();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    return $self;
}

sub cipherStrength {
    my ($self) = @_;
    return $self->{cipherStrength};
}

sub name {
    my ($self) = @_;
    return $self->{name};
}

sub ecdhBits {
    my ($self) = @_;
    return $self->{ecdhBits};
}

sub ecdhStrength {
    my ($self) = @_;
    return $self->{ecdhStrength};
}

sub dhStrength {
    my ($self) = @_;
    return $self->{dhStrength};
}

sub dhYs {
    my ($self) = @_;
    return $self->{dhYs};
}

sub dhG {
    my ($self) = @_;
    return $self->{dhG};
}

sub dhP {
    my ($self) = @_;
    return $self->{dhP};
}

sub id {
    my ($self) = @_;
    return $self->{id};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Suite - Suite object

=head1 METHODS

=head2 new

a new I<Net::SSLLabs::Suite> object, accepts a JSON object as it's parameter.

=head2 id

suite RFC ID (e.g., 5)

=head2 name

suite name (e.g., TLS_RSA_WITH_RC4_128_SHA)

=head2 cipherStrength

suite strength (e.g., 128)

=head2 dhStrength

strength of DH params (e.g., 1024)

=head2 dhP

DH params, p component

=head2 dhG

DH params, g component

=head2 dhYs

DH params, Ys component

=head2 ecdhBits

ECDH bits

=head2 ecdhStrength

ECDH RSA-equivalent strength

=head2 q

0 if the suite is insecure, null otherwise

