package Net::SSLLabs::SimClient;

use strict;
use warnings;

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    return $self;
}

sub id {
    my ($self) = @_;
    return $self->{id};
}

sub name {
    my ($self) = @_;
    return $self->{name};
}

sub platform {
    my ($self) = @_;
    return $self->{platform};
}

sub version {
    my ($self) = @_;
    return $self->{version};
}

sub isReference {
    my ($self) = @_;
    return $self->{isReference} ? 1 : 0;
}

1;
__END__

=head1 NAME

Net::SSLLabs::SimClient - SimClient object

=head1 METHODS

=head2 new

a new I<Net::SSLLabs::SimClient> object, accepts a JSON object as it's parameter.

=head2 id

unique client ID (integer)

=head2 name

text.

=head2 platform

text.

=head2 version

text.

=head2 isReference

true if the browser is considered representative of modern browsers, false otherwise. This flag does not correlate to client's capabilities, but is used by SSL Labs to determine if a particular configuration is effective. For example, to track Forward Secrecy support, we mark several representative browsers as "modern" and then test to see if they succeed in negotiating a FS suite. Just as an illustration, modern browsers are currently Chrome, Firefox (not ESR versions), IE/Win7, and Safari.
