package Net::SSLLabs::ChainCert;

use strict;
use warnings;

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    return $self;
}

sub subject {
    my ($self) = @_;
    return $self->{subject};
}

sub label {
    my ($self) = @_;
    return $self->{label};
}

sub notBefore {
    my ($self) = @_;
    return $self->{notBefore};
}

sub notAfter {
    my ($self) = @_;
    return $self->{notAfter};
}

sub issuerSubject {
    my ($self) = @_;
    return $self->{issuerSubject};
}

sub issuerLabel {
    my ($self) = @_;
    return $self->{issuerLabel};
}

sub sigAlg {
    my ($self) = @_;
    return $self->{sigAlg};
}

sub issues {
    my ($self) = @_;
    return $self->{issues};
}

sub keyAlg {
    my ($self) = @_;
    return $self->{keyAlg};
}

sub keySize {
    my ($self) = @_;
    return $self->{keySize};
}

sub keyStrength {
    my ($self) = @_;
    return $self->{keyStrength};
}

sub revocationStatus {
    my ($self) = @_;
    return $self->{revocationStatus};
}

sub crlRevocationStatus {
    my ($self) = @_;
    return $self->{crlRevocationStatus};
}

sub ocspRevocationStatus {
    my ($self) = @_;
    return $self->{ocspRevocationStatus};
}

sub raw {
    my ($self) = @_;
    return $self->{raw};
}

1;
__END__

=head1 NAME

Net::SSLLabs::ChainCert - ChainCert object

=head1 METHODS

=head2 new

a new I<Net::SSLLabs::ChainCert> object, accepts a JSON object as it's parameter.

=head2 subject

certificate subject

=head2 label

certificate label (user-friendly name)

=head2 notBefore

=head2 notAfter

=head2 issuerSubject

issuer subject

=head2 issuerLabel

issuer label (user-friendly name)

=head2 sigAlg

=head2 issues

a number of flags the describe the problems with this certificate:

=over 2

=item bit 0 (1) - certificate not yet valid

=item bit 1 (2) - certificate expired

=item bit 2 (4) - weak key

=item bit 3 (8) - weak signature

=item bit 4 (16) - blacklisted

=back

=head2 keyAlg

key algorithm.

=head2 keySize

key size, in bits appopriate for the key algorithm.

=head2 keyStrength

key strength, in equivalent RSA bits.

=head2 revocationStatus

a number that describes the revocation status of the certificate:

=over 2

=item 0 - not checked

=item 1 - certificate revoked

=item 2 - certificate not revoked

=item 3 - revocation check error

=item 4 - no revocation information

=item 5 - internal error

=back

=head2 crlRevocationStatus

same as revocationStatus, but only for the CRL information (if any).

=head2 ocspRevocationStatus

same as revocationStatus, but only for the OCSP information (if any).

=head2 raw

PEM-encoded certificate data 

