#!perl

# Copyright (C) 2006-2007, The Perl Foundation.
# $Id: /mirror/trunk/languages/dotnet/t/conditional.t 22352 2007-10-21T14:55:36.857433Z paultcochrane  $

use strict;
use warnings;
use lib qw( lib ../lib ../../lib dotnet dotnet/t );

use DotNetTesting;

use Test::More tests => 4;

## Testing class for this file.t';
#
die unless compile_cs( "t.dll", <<'CSHARP');
namespace Testing
{
    public class Test
    {
        public int clip(int x)
        {
            if (x > 0)
				return 1;
			else if (x < 0)
				return -1;
			else
				return 0;
        }

		public int band_pass(int x)
		{
			if (x >= 5)
				return 0;
			else if (x <= 2)
				return 0;
			else
				return x;
		}

		public int is_42(int x)
		{
			if (x == 42)
				return 1;
			else
				return 0;
		}
    }
}
CSHARP

## Attempt to translate.
ok( translate( "t.dll", "t.pbc" ), 'translate' );

## Tests.
is( run_pir(<<'PIR'), <<'OUTPUT', 'clip' );
.sub main
	.local pmc obj
	load_bytecode "t.pbc"
	obj = new [ "Testing" ; "Test" ]
	$I0 = obj.clip(0)
	print $I0
	print "\n"
	$I0 = obj.clip(1)
	print $I0
	print "\n"
	$I0 = obj.clip(-1)
	print $I0
	print "\n"
	$I0 = obj.clip(-500)
	print $I0
	print "\n"
	$I0 = obj.clip(42)
	print $I0
	print "\n"
.end
PIR
0
1
-1
-1
1
OUTPUT

is( run_pir(<<'PIR'), <<'OUTPUT', 'band_pass' );
.sub main
	.local pmc obj
	load_bytecode "t.pbc"
	obj = new [ "Testing" ; "Test" ]
	$I0 = obj.band_pass(1)
	print $I0
	print "\n"
	$I0 = obj.band_pass(2)
	print $I0
	print "\n"
	$I0 = obj.band_pass(3)
	print $I0
	print "\n"
	$I0 = obj.band_pass(4)
	print $I0
	print "\n"
	$I0 = obj.band_pass(5)
	print $I0
	print "\n"
	$I0 = obj.band_pass(6)
	print $I0
	print "\n"
.end
PIR
0
0
3
4
0
0
OUTPUT

is( run_pir(<<'PIR'), <<'OUTPUT', 'is_42' );
.sub main
	.local pmc obj
	load_bytecode "t.pbc"
	obj = new [ "Testing" ; "Test" ]
	$I0 = obj.is_42(99)
	print $I0
	print "\n"
	$I0 = obj.is_42(-2)
	print $I0
	print "\n"
	$I0 = obj.is_42(42)
	print $I0
	print "\n"
	$I0 = obj.is_42(-42)
	print $I0
	print "\n"
.end
PIR
0
0
1
0
OUTPUT

## Clean up.
unlink qw(t.dll t.pbc);

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
