package HTML::Dojo::editions;
1;
__DATA__
__CPAN_EDITION__ ajax dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:0,flag:"",revision:Number("$Rev: 6258 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
return _6e?_6e.toLowerCase():dojo.locale;
};
dojo.hostenv.searchLocalePath=function(_6f,_70,_71){
_6f=dojo.hostenv.normalizeLocale(_6f);
var _72=_6f.split("-");
var _73=[];
for(var i=_72.length;i>0;i--){
_73.push(_72.slice(0,i).join("-"));
}
_73.push(false);
if(_70){
_73.reverse();
}
for(var j=_73.length-1;j>=0;j--){
var loc=_73[j]||"ROOT";
var _77=_71(loc);
if(_77){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_78){
_78=dojo.hostenv.normalizeLocale(_78);
dojo.hostenv.searchLocalePath(_78,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7b=djConfig.extraLocale||[];
for(var i=0;i<_7b.length;i++){
preload(_7b[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7d,_7e,_7f){
dojo.hostenv.preloadLocalizations();
var _80=[_7d,"nls",_7e].join(".");
var _81=dojo.hostenv.findModule(_80);
if(_81){
if(djConfig.localizationComplete&&_81._built){
return;
}
var _82=dojo.hostenv.normalizeLocale(_7f).replace("-","_");
var _83=_80+"."+_82;
if(dojo.hostenv.findModule(_83)){
return;
}
}
_81=dojo.hostenv.startPackage(_80);
var _84=dojo.hostenv.getModuleSymbols(_7d);
var _85=_84.concat("nls").join("/");
var _86;
dojo.hostenv.searchLocalePath(_7f,false,function(loc){
var _88=loc.replace("-","_");
var _89=_80+"."+_88;
var _8a=false;
if(!dojo.hostenv.findModule(_89)){
dojo.hostenv.startPackage(_89);
var _8b=[_85];
if(loc!="ROOT"){
_8b.push(loc);
}
_8b.push(_7e);
var _8c=_8b.join("/")+".js";
_8a=dojo.hostenv.loadPath(_8c,null,function(_8d){
var _8e=function(){
};
_8e.prototype=_86;
_81[_88]=new _8e();
for(var j in _8d){
_81[_88][j]=_8d[j];
}
});
}else{
_8a=true;
}
if(_8a&&_81[_88]){
_86=_81[_88];
}else{
_81[_88]=_86;
}
});
};
(function(){
var _90=djConfig.extraLocale;
if(_90){
if(!_90 instanceof Array){
_90=[_90];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_94){
req(m,b,_94);
if(_94){
return;
}
for(var i=0;i<_90.length;i++){
req(m,b,_90[i]);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _96=document.location.toString();
var _97=_96.split("?",2);
if(_97.length>1){
var _98=_97[1];
var _99=_98.split("&");
for(var x in _99){
var sp=_99[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _9d=document.getElementsByTagName("script");
var _9e=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_9d.length;i++){
var src=_9d[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_9e);
if(m){
var _a2=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_a2+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_a2;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_a2;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _aa=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_aa>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_aa+6,_aa+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _ac=window["document"];
var tdi=_ac["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b0=null;
var _b1=null;
try{
_b0=new XMLHttpRequest();
}
catch(e){
}
if(!_b0){
for(var i=0;i<3;++i){
var _b3=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b0=new ActiveXObject(_b3);
}
catch(e){
_b1=e;
}
if(_b0){
dojo.hostenv._XMLHTTP_PROGIDS=[_b3];
break;
}
}
}
if(!_b0){
return dojo.raise("XMLHTTP not available",_b1);
}
return _b0;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_b5,_b6){
if(!_b5){
this._blockAsync=true;
}
var _b7=this.getXmlhttpObject();
function isDocumentOk(_b8){
var _b9=_b8["status"];
return Boolean((!_b9)||((200<=_b9)&&(300>_b9))||(_b9==304));
}
if(_b5){
var _ba=this,_bb=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_b7.onreadystatechange=function(){
if(_bb){
gbl.clearTimeout(_bb);
_bb=null;
}
if(_ba._blockAsync||(xhr&&xhr._blockAsync)){
_bb=gbl.setTimeout(function(){
_b7.onreadystatechange.apply(this);
},10);
}else{
if(4==_b7.readyState){
if(isDocumentOk(_b7)){
_b5(_b7.responseText);
}
}
}
};
}
_b7.open("GET",uri,_b5?true:false);
try{
_b7.send(null);
if(_b5){
return null;
}
if(!isDocumentOk(_b7)){
var err=Error("Unable to load "+uri+" status:"+_b7.status);
err.status=_b7.status;
err.responseText=_b7.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_b6)&&(!_b5)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _b7.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_bf){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_bf);
}else{
try{
var _c0=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c0){
_c0=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_bf));
_c0.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_bf+"</div>");
}
catch(e2){
window.status=_bf;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_c2,_c3,fp,_c5){
var _c6=_c2["on"+_c3]||function(){
};
_c2["on"+_c3]=function(){
fp.apply(_c2,arguments);
_c6.apply(_c2,arguments);
};
return true;
}
function dj_load_init(e){
var _c8=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_c8!="domcontentloaded"&&_c8!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _c9=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_c9();
dojo.hostenv.modulesLoaded();
}else{
dojo.addOnLoad(_c9);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _cb=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_cb=_cb.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_cb=_cb.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_cb.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _cc=new dojo.xml.Parse();
if(_cb.length>0){
for(var x=0;x<_cb.length;x++){
var _ce=document.getElementById(_cb[x]);
if(!_ce){
continue;
}
var _cf=_cc.parseElement(_ce,null,true);
dojo.widget.getParser().createComponents(_cf);
}
}else{
if(djConfig.parseWidgets){
var _cf=_cc.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_cf);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_d4,_d5){
dj_currentContext=_d4;
dj_currentDocument=_d5;
};
dojo._fireCallback=function(_d6,_d7,_d8){
if((_d7)&&((typeof _d6=="string")||(_d6 instanceof String))){
_d6=_d7[_d6];
}
return (_d7?_d6.apply(_d7,_d8||[]):_d6());
};
dojo.withGlobal=function(_d9,_da,_db,_dc){
var _dd;
var _de=dj_currentContext;
var _df=dj_currentDocument;
try{
dojo.setContext(_d9,_d9.document);
_dd=dojo._fireCallback(_da,_db,_dc);
}
finally{
dojo.setContext(_de,_df);
}
return _dd;
};
dojo.withDoc=function(_e0,_e1,_e2,_e3){
var _e4;
var _e5=dj_currentDocument;
try{
dj_currentDocument=_e0;
_e4=dojo._fireCallback(_e1,_e2,_e3);
}
finally{
dj_currentDocument=_e5;
}
return _e4;
};
}
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _e6=false;
var _e7=false;
var _e8=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_e6=true;
}else{
if(typeof this["load"]=="function"){
_e7=true;
}else{
if(window.widget){
_e8=true;
}
}
}
var _e9=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_e9.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_e6)&&(!_e8)){
_e9.push("browser_debug.js");
}
var _ea=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_ea=djConfig["baseLoaderUri"];
}
for(var x=0;x<_e9.length;x++){
var _ec=_ea+"src/"+_e9[x];
if(_e6||_e7){
load(_ec);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_ec+"'></scr"+"ipt>");
}
catch(e){
var _ed=document.createElement("script");
_ed.src=_ec;
document.getElementsByTagName("head")[0].appendChild(_ed);
}
}
}
})();
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_f4,_f5){
var out="";
for(var i=0;i<_f4;i++){
out+=str;
if(_f5&&i<_f4-1){
out+=_f5;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_103,_104){
if(typeof _104!="function"){
dojo.raise("dojo.inherits: superclass argument ["+_104+"] must be a function (subclass: ["+_103+"']");
}
_103.prototype=new _104();
_103.prototype.constructor=_103;
_103.superclass=_104.prototype;
_103["super"]=_104.prototype;
};
dojo.lang._mixin=function(obj,_106){
var tobj={};
for(var x in _106){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_106[x])){
obj[x]=_106[x];
}
}
if(dojo.render.html.ie&&(typeof (_106["toString"])=="function")&&(_106["toString"]!=obj["toString"])&&(_106["toString"]!=tobj["toString"])){
obj.toString=_106.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_10a){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_10d,_10e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_10d.prototype,arguments[i]);
}
return _10d;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_111,_112,_113,_114){
if(!dojo.lang.isArrayLike(_111)&&dojo.lang.isArrayLike(_112)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_111;
_111=_112;
_112=temp;
}
var _116=dojo.lang.isString(_111);
if(_116){
_111=_111.split("");
}
if(_114){
var step=-1;
var i=_111.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_111.length;
}
if(_113){
while(i!=end){
if(_111[i]===_112){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_111[i]==_112){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_11a,_11b,_11c){
return dojo.lang.find(_11a,_11b,_11c,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_11d,_11e){
return dojo.lang.find(_11d,_11e)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
if(!it){
return false;
}
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction()&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_129){
var _12a=window,_12b=2;
if(!dojo.lang.isFunction(func)){
_12a=func;
func=_129;
_129=arguments[2];
_12b++;
}
if(dojo.lang.isString(func)){
func=_12a[func];
}
var args=[];
for(var i=_12b;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_12a,args);
},_129);
};
dojo.lang.clearTimeout=function(_12e){
dojo.global().clearTimeout(_12e);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_137,_138,_139){
with(dojo.parseObjPath(_137,_138,_139)){
return dojo.evalProp(prop,obj,_139);
}
};
dojo.lang.setObjPathValue=function(_13a,_13b,_13c,_13d){
if(arguments.length<4){
_13d=true;
}
with(dojo.parseObjPath(_13a,_13c,_13d)){
if(obj&&(_13d||(prop in obj))){
obj[prop]=_13b;
}
}
};
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_13f,_140,_141){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_13f){
this.mimetype=_13f;
}
if(_140){
this.transport=_140;
}
if(arguments.length>=4){
this.changeUrl=_141;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_144,_145){
},error:function(type,_147,_148,_149){
},timeout:function(type,_14b,_14c,_14d){
},handle:function(type,data,_150,_151){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_152){
if(_152["url"]){
_152.url=_152.url.toString();
}
if(_152["formNode"]){
_152.formNode=dojo.byId(_152.formNode);
}
if(!_152["method"]&&_152["formNode"]&&_152["formNode"].method){
_152.method=_152["formNode"].method;
}
if(!_152["handle"]&&_152["handler"]){
_152.handle=_152.handler;
}
if(!_152["load"]&&_152["loaded"]){
_152.load=_152.loaded;
}
if(!_152["changeUrl"]&&_152["changeURL"]){
_152.changeUrl=_152.changeURL;
}
_152.encoding=dojo.lang.firstValued(_152["encoding"],djConfig["bindEncoding"],"");
_152.sendTransport=dojo.lang.firstValued(_152["sendTransport"],djConfig["ioSendTransport"],false);
var _153=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_152[fn]&&_153(_152[fn])){
continue;
}
if(_152["handle"]&&_153(_152["handle"])){
_152[fn]=_152.handle;
}
}
dojo.lang.mixin(this,_152);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_15a){
if(!(_15a instanceof dojo.io.Request)){
try{
_15a=new dojo.io.Request(_15a);
}
catch(e){
dojo.debug(e);
}
}
var _15b="";
if(_15a["transport"]){
_15b=_15a["transport"];
if(!this[_15b]){
dojo.io.sendBindError(_15a,"No dojo.io.bind() transport with name '"+_15a["transport"]+"'.");
return _15a;
}
if(!this[_15b].canHandle(_15a)){
dojo.io.sendBindError(_15a,"dojo.io.bind() transport with name '"+_15a["transport"]+"' cannot handle this type of request.");
return _15a;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_15a))){
_15b=tmp;
break;
}
}
if(_15b==""){
dojo.io.sendBindError(_15a,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _15a;
}
}
this[_15b].bind(_15a);
_15a.bindSuccess=true;
return _15a;
};
dojo.io.sendBindError=function(_15e,_15f){
if((typeof _15e.error=="function"||typeof _15e.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _160=new dojo.io.Error(_15f);
setTimeout(function(){
_15e[(typeof _15e.error=="function")?"error":"handle"]("error",_160,null,_15e);
},50);
}else{
dojo.raise(_15f);
}
};
dojo.io.queueBind=function(_161){
if(!(_161 instanceof dojo.io.Request)){
try{
_161=new dojo.io.Request(_161);
}
catch(e){
dojo.debug(e);
}
}
var _162=_161.load;
_161.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_162.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _164=_161.error;
_161.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_164.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_161);
dojo.io._dispatchNextQueueBind();
return _161;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_167,last){
var enc=/utf/i.test(_167||"")?encodeURIComponent:dojo.string.encodeAscii;
var _16a=[];
var _16b=new Object();
for(var name in map){
var _16d=function(elt){
var val=enc(name)+"="+enc(elt);
_16a[(last==name)?"push":"unshift"](val);
};
if(!_16b[name]){
var _170=map[name];
if(dojo.lang.isArray(_170)){
dojo.lang.forEach(_170,_16d);
}else{
_16d(_170);
}
}
}
return _16a.join("&");
};
dojo.io.setIFrameSrc=function(_171,src,_173){
try{
var r=dojo.render.html;
if(!_173){
if(r.safari){
_171.location=src;
}else{
frames[_171.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_171.contentWindow.document;
}else{
if(r.safari){
idoc=_171.document;
}else{
idoc=_171.contentWindow;
}
}
if(!idoc){
_171.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.lang.array");
dojo.lang.has=function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
};
dojo.lang.isEmpty=function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _17a=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_17a++;
break;
}
}
return _17a==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
};
dojo.lang.map=function(arr,obj,_17e){
var _17f=dojo.lang.isString(arr);
if(_17f){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_17e)){
_17e=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_17e){
var _180=obj;
obj=_17e;
_17e=_180;
}
}
if(Array.map){
var _181=Array.map(arr,_17e,obj);
}else{
var _181=[];
for(var i=0;i<arr.length;++i){
_181.push(_17e.call(obj,arr[i]));
}
}
if(_17f){
return _181.join("");
}else{
return _181;
}
};
dojo.lang.reduce=function(arr,_184,obj,_186){
var _187=_184;
var ob=obj?obj:dj_global;
dojo.lang.map(arr,function(val){
_187=_186.call(ob,_187,val);
});
return _187;
};
dojo.lang.forEach=function(_18a,_18b,_18c){
if(dojo.lang.isString(_18a)){
_18a=_18a.split("");
}
if(Array.forEach){
Array.forEach(_18a,_18b,_18c);
}else{
if(!_18c){
_18c=dj_global;
}
for(var i=0,l=_18a.length;i<l;i++){
_18b.call(_18c,_18a[i],i,_18a);
}
}
};
dojo.lang._everyOrSome=function(_18f,arr,_191,_192){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_18f?"every":"some"](arr,_191,_192);
}else{
if(!_192){
_192=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _195=_191.call(_192,arr[i],i,arr);
if(_18f&&!_195){
return false;
}else{
if((!_18f)&&(_195)){
return true;
}
}
}
return Boolean(_18f);
}
};
dojo.lang.every=function(arr,_197,_198){
return this._everyOrSome(true,arr,_197,_198);
};
dojo.lang.some=function(arr,_19a,_19b){
return this._everyOrSome(false,arr,_19a,_19b);
};
dojo.lang.filter=function(arr,_19d,_19e){
var _19f=dojo.lang.isString(arr);
if(_19f){
arr=arr.split("");
}
var _1a0;
if(Array.filter){
_1a0=Array.filter(arr,_19d,_19e);
}else{
if(!_19e){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_19e=dj_global;
}
_1a0=[];
for(var i=0;i<arr.length;i++){
if(_19d.call(_19e,arr[i],i,arr)){
_1a0.push(arr[i]);
}
}
}
if(_19f){
return _1a0.join("");
}else{
return _1a0;
}
};
dojo.lang.unnest=function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
};
dojo.lang.toArray=function(_1a5,_1a6){
var _1a7=[];
for(var i=_1a6||0;i<_1a5.length;i++){
_1a7.push(_1a5[i]);
}
return _1a7;
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_1a9,_1aa){
var fcn=(dojo.lang.isString(_1aa)?_1a9[_1aa]:_1aa)||function(){
};
return function(){
return fcn.apply(_1a9,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_1ac,_1ad,_1ae){
var nso=(_1ad||dojo.lang.anon);
if((_1ae)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_1ac){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_1ac;
return ret;
};
dojo.lang.forward=function(_1b2){
return function(){
return this[_1b2].apply(this,arguments);
};
};
dojo.lang.curry=function(ns,func){
var _1b5=[];
ns=ns||dj_global;
if(dojo.lang.isString(func)){
func=ns[func];
}
for(var x=2;x<arguments.length;x++){
_1b5.push(arguments[x]);
}
var _1b7=(func["__preJoinArity"]||func.length)-_1b5.length;
function gather(_1b8,_1b9,_1ba){
var _1bb=_1ba;
var _1bc=_1b9.slice(0);
for(var x=0;x<_1b8.length;x++){
_1bc.push(_1b8[x]);
}
_1ba=_1ba-_1b8.length;
if(_1ba<=0){
var res=func.apply(ns,_1bc);
_1ba=_1bb;
return res;
}else{
return function(){
return gather(arguments,_1bc,_1ba);
};
}
}
return gather([],_1b5,_1b7);
};
dojo.lang.curryArguments=function(ns,func,args,_1c2){
var _1c3=[];
var x=_1c2||0;
for(x=_1c2;x<args.length;x++){
_1c3.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[ns,func].concat(_1c3));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1c9,_1ca){
if(!farr.length){
if(typeof _1ca=="function"){
_1ca();
}
return;
}
if((typeof _1c9=="undefined")&&(typeof cb=="number")){
_1c9=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1c9){
_1c9=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1c9,_1ca);
},_1c9);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_1cb,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _1cb.replace(/\%\{(\w+)\}/g,function(_1ce,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _1d1=str.split(" ");
for(var i=0;i<_1d1.length;i++){
_1d1[i]=_1d1[i].charAt(0).toUpperCase()+_1d1[i].substring(1);
}
return _1d1.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _1d6=escape(str);
var _1d7,re=/%u([0-9A-F]{4})/i;
while((_1d7=_1d6.match(re))){
var num=Number("0x"+_1d7[1]);
var _1da=escape("&#"+num+";");
ret+=_1d6.substring(0,_1d7.index)+_1da;
_1d6=_1d6.substring(_1d7.index+_1d7[0].length);
}
ret+=_1d6.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_1df){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_1df){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_1e8){
if(_1e8){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1ec,_1ed){
if(_1ed){
str=str.toLowerCase();
_1ec=_1ec.toLowerCase();
}
return str.indexOf(_1ec)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1f3){
if(_1f3=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1f3=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1f5){
var _1f6=[];
for(var i=0,_1f8=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1f5){
_1f6.push(str.substring(_1f8,i));
_1f8=i+1;
}
}
_1f6.push(str.substr(_1f8));
return _1f6;
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(E){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _1fa=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_1fa.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_1fc,_1fd){
var node=_1fc.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_1fd&&node&&node.tagName&&node.tagName.toLowerCase()!=_1fd.toLowerCase()){
node=dojo.dom.nextElement(node,_1fd);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_1ff,_200){
var node=_1ff.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_200&&node&&node.tagName&&node.tagName.toLowerCase()!=_200.toLowerCase()){
node=dojo.dom.prevElement(node,_200);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_203){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_203&&_203.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_203);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_205){
if(!node){
return null;
}
if(_205){
_205=_205.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_205&&_205.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_205);
}
return node;
};
dojo.dom.moveChildren=function(_206,_207,trim){
var _209=0;
if(trim){
while(_206.hasChildNodes()&&_206.firstChild.nodeType==dojo.dom.TEXT_NODE){
_206.removeChild(_206.firstChild);
}
while(_206.hasChildNodes()&&_206.lastChild.nodeType==dojo.dom.TEXT_NODE){
_206.removeChild(_206.lastChild);
}
}
while(_206.hasChildNodes()){
_207.appendChild(_206.firstChild);
_209++;
}
return _209;
};
dojo.dom.copyChildren=function(_20a,_20b,trim){
var _20d=_20a.cloneNode(true);
return this.moveChildren(_20d,_20b,trim);
};
dojo.dom.removeChildren=function(node){
var _20f=node.childNodes.length;
while(node.hasChildNodes()){
node.removeChild(node.firstChild);
}
return _20f;
};
dojo.dom.replaceChildren=function(node,_211){
dojo.dom.removeChildren(node);
node.appendChild(_211);
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_214,_215){
var _216=[];
var _217=(_214&&(_214 instanceof Function||typeof _214=="function"));
while(node){
if(!_217||_214(node)){
_216.push(node);
}
if(_215&&_216.length>0){
return _216[0];
}
node=node.parentNode;
}
if(_215){
return null;
}
return _216;
};
dojo.dom.getAncestorsByTag=function(node,tag,_21a){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_21a);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_21f,_220){
if(_220&&node){
node=node.parentNode;
}
while(node){
if(node==_21f){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _223=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _224=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_224.length;i++){
try{
doc=new ActiveXObject(_224[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_223.implementation)&&(_223.implementation.createDocument)){
doc=_223.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_227){
if(!_227){
_227="text/xml";
}
if(!dj_undef("DOMParser")){
var _228=new DOMParser();
return _228.parseFromString(str,_227);
}else{
if(!dj_undef("ActiveXObject")){
var _229=dojo.dom.createDocument();
if(_229){
_229.async=false;
_229.loadXML(str);
return _229;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _22a=dojo.doc();
if(_22a.createElement){
var tmp=_22a.createElement("xml");
tmp.innerHTML=str;
if(_22a.implementation&&_22a.implementation.createDocument){
var _22c=_22a.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_22c.importNode(tmp.childNodes.item(i),true);
}
return _22c;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_22f){
if(_22f.firstChild){
_22f.insertBefore(node,_22f.firstChild);
}else{
_22f.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_232){
if(_232!=true&&(node===ref||node.nextSibling===ref)){
return false;
}
var _233=ref.parentNode;
_233.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_236){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_236!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_236);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_23a){
if((!node)||(!ref)||(!_23a)){
return false;
}
switch(_23a.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_23c,_23d){
var _23e=_23c.childNodes;
if(!_23e.length){
_23c.appendChild(node);
return true;
}
var _23f=null;
for(var i=0;i<_23e.length;i++){
var _241=_23e.item(i)["getAttribute"]?parseInt(_23e.item(i).getAttribute("dojoinsertionindex")):-1;
if(_241<_23d){
_23f=_23e.item(i);
}
}
if(_23f){
return dojo.dom.insertAfter(node,_23f);
}else{
return dojo.dom.insertBefore(node,_23e.item(0));
}
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _244=dojo.doc();
dojo.dom.replaceChildren(node,_244.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _245="";
if(node==null){
return _245;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_245+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_245+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _245;
}
};
dojo.dom.hasParent=function(node){
return node&&node.parentNode&&dojo.dom.isNode(node.parentNode);
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_24b,_24c,_24d){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_24b,_24c,_24d);
}else{
var _24e=elem.ownerDocument;
var _24f=_24e.createNode(2,_24c,_24b);
_24f.nodeValue=_24d;
elem.setAttributeNode(_24f);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:window.location.href,initialHash:window.location.hash,moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _254=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_256){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_254.apply(this,[_256]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _257=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_259){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_257){
_257.apply(this,[_259]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_25c){
if(!dojo.render.html.opera){
var _25d=this._getUrlQuery(_25c.href);
if(_25d==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_25d==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_25d==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _25e=this.historyStack.pop();
if(!_25e){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_25e);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _265=url.split("?");
if(_265.length<2){
return null;
}else{
return _265[1];
}
},_loadIframeHistory:function(){
var url=dojo.hostenv.getBaseScriptUri()+"iframe_history.html?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
dojo.io.checkChildrenForFile=function(node){
var _268=false;
var _269=node.getElementsByTagName("input");
dojo.lang.forEach(_269,function(_26a){
if(_268){
return;
}
if(_26a.getAttribute("type")=="file"){
_268=true;
}
});
return _268;
};
dojo.io.formHasFile=function(_26b){
return dojo.io.checkChildrenForFile(_26b);
};
dojo.io.updateNode=function(node,_26d){
node=dojo.byId(node);
var args=_26d;
if(dojo.lang.isString(_26d)){
args={url:_26d};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
if(dojo["event"]){
try{
dojo.event.browser.clean(node.firstChild);
}
catch(e){
}
}
node.removeChild(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_274,_275,_276){
if((!_274)||(!_274.tagName)||(!_274.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_276){
_276=dojo.io.formFilter;
}
var enc=/utf/i.test(_275||"")?encodeURIComponent:dojo.string.encodeAscii;
var _278=[];
for(var i=0;i<_274.elements.length;i++){
var elm=_274.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_276(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_278.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_278.push(name+"="+enc(elm.value));
}
}else{
_278.push(name+"="+enc(elm.value));
}
}
}
var _27e=_274.getElementsByTagName("input");
for(var i=0;i<_27e.length;i++){
var _27f=_27e[i];
if(_27f.type.toLowerCase()=="image"&&_27f.form==_274&&_276(_27f)){
var name=enc(_27f.name);
_278.push(name+"="+enc(_27f.value));
_278.push(name+".x=0");
_278.push(name+".y=0");
}
}
return _278.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _285=form.getElementsByTagName("input");
for(var i=0;i<_285.length;i++){
var _286=_285[i];
if(_286.type.toLowerCase()=="image"&&_286.form==form){
this.connect(_286,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _28d=false;
if(node.disabled||!node.name){
_28d=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_28d=node==this.clickedButton;
}else{
_28d=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _28d;
},connect:function(_28e,_28f,_290){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_28e,_28f,this,_290);
}else{
var fcn=dojo.lang.hitch(this,_290);
_28e[_28f]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _293=this;
var _294={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_296,_297){
return url+"|"+_296+"|"+_297.toLowerCase();
}
function addToCache(url,_299,_29a,http){
_294[getCacheKey(url,_299,_29a)]=http;
}
function getFromCache(url,_29d,_29e){
return _294[getCacheKey(url,_29d,_29e)];
}
this.clearCache=function(){
_294={};
};
function doLoad(_29f,http,url,_2a2,_2a3){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_29f.method.toLowerCase()=="head"){
var _2a5=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _2a5;
};
var _2a6=_2a5.split(/[\r\n]+/g);
for(var i=0;i<_2a6.length;i++){
var pair=_2a6[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_29f.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_29f.mimetype=="text/json"||_29f.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_29f.mimetype=="application/xml")||(_29f.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_2a3){
addToCache(url,_2a2,_29f.method,http);
}
_29f[(typeof _29f.load=="function")?"load":"handle"]("load",ret,http,_29f);
}else{
var _2a9=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_29f[(typeof _29f.error=="function")?"error":"handle"]("error",_2a9,http,_29f);
}
}
function setHeaders(http,_2ab){
if(_2ab["headers"]){
for(var _2ac in _2ab["headers"]){
if(_2ac.toLowerCase()=="content-type"&&!_2ab["contentType"]){
_2ab["contentType"]=_2ab["headers"][_2ac];
}else{
http.setRequestHeader(_2ac,_2ab["headers"][_2ac]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_293._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _2b0=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_2b0,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _2b1=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_2b2){
return _2b1&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_2b2["mimetype"].toLowerCase()||""))&&!(_2b2["formNode"]&&dojo.io.formHasFile(_2b2["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_2b3){
if(!_2b3["url"]){
if(!_2b3["formNode"]&&(_2b3["backButton"]||_2b3["back"]||_2b3["changeUrl"]||_2b3["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_2b3);
return true;
}
}
var url=_2b3.url;
var _2b5="";
if(_2b3["formNode"]){
var ta=_2b3.formNode.getAttribute("action");
if((ta)&&(!_2b3["url"])){
url=ta;
}
var tp=_2b3.formNode.getAttribute("method");
if((tp)&&(!_2b3["method"])){
_2b3.method=tp;
}
_2b5+=dojo.io.encodeForm(_2b3.formNode,_2b3.encoding,_2b3["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_2b3["file"]){
_2b3.method="post";
}
if(!_2b3["method"]){
_2b3.method="get";
}
if(_2b3.method.toLowerCase()=="get"){
_2b3.multipart=false;
}else{
if(_2b3["file"]){
_2b3.multipart=true;
}else{
if(!_2b3["multipart"]){
_2b3.multipart=false;
}
}
}
if(_2b3["backButton"]||_2b3["back"]||_2b3["changeUrl"]){
dojo.undo.browser.addToHistory(_2b3);
}
var _2b8=_2b3["content"]||{};
if(_2b3.sendTransport){
_2b8["dojo.transport"]="xmlhttp";
}
do{
if(_2b3.postContent){
_2b5=_2b3.postContent;
break;
}
if(_2b8){
_2b5+=dojo.io.argsFromMap(_2b8,_2b3.encoding);
}
if(_2b3.method.toLowerCase()=="get"||!_2b3.multipart){
break;
}
var t=[];
if(_2b5.length){
var q=_2b5.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_2b3.file){
if(dojo.lang.isArray(_2b3.file)){
for(var i=0;i<_2b3.file.length;++i){
var o=_2b3.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_2b3.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_2b5=t.join("\r\n");
}
}while(false);
var _2be=_2b3["sync"]?false:true;
var _2bf=_2b3["preventCache"]||(this.preventCache==true&&_2b3["preventCache"]!=false);
var _2c0=_2b3["useCache"]==true||(this.useCache==true&&_2b3["useCache"]!=false);
if(!_2bf&&_2c0){
var _2c1=getFromCache(url,_2b5,_2b3.method);
if(_2c1){
doLoad(_2b3,_2c1,url,_2b5,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_2b3);
var _2c3=false;
if(_2be){
var _2c4=this.inFlight.push({"req":_2b3,"http":http,"url":url,"query":_2b5,"useCache":_2c0,"startTime":_2b3.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_293._blockAsync=true;
}
if(_2b3.method.toLowerCase()=="post"){
if(!_2b3.user){
http.open("POST",url,_2be);
}else{
http.open("POST",url,_2be,_2b3.user,_2b3.password);
}
setHeaders(http,_2b3);
http.setRequestHeader("Content-Type",_2b3.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_2b3.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_2b5);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b3,{status:404},url,_2b5,_2c0);
}
}else{
var _2c5=url;
if(_2b5!=""){
_2c5+=(_2c5.indexOf("?")>-1?"&":"?")+_2b5;
}
if(_2bf){
_2c5+=(dojo.string.endsWithAny(_2c5,"?","&")?"":(_2c5.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_2b3.user){
http.open(_2b3.method.toUpperCase(),_2c5,_2be);
}else{
http.open(_2b3.method.toUpperCase(),_2c5,_2be,_2b3.user,_2b3.password);
}
setHeaders(http,_2b3);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b3,{status:404},url,_2b5,_2c0);
}
}
if(!_2be){
doLoad(_2b3,http,url,_2b5,_2c0);
_293._blockAsync=false;
}
_2b3.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_2c7,days,path,_2ca,_2cb){
var _2cc=-1;
if(typeof days=="number"&&days>=0){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_2cc=d.toGMTString();
}
_2c7=escape(_2c7);
document.cookie=name+"="+_2c7+";"+(_2cc!=-1?" expires="+_2cc+";":"")+(path?"path="+path:"")+(_2ca?"; domain="+_2ca:"")+(_2cb?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _2d0=document.cookie.substring(idx+name.length+1);
var end=_2d0.indexOf(";");
if(end==-1){
end=_2d0.length;
}
_2d0=_2d0.substring(0,end);
_2d0=unescape(_2d0);
return _2d0;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_2d7,_2d8,_2d9){
if(arguments.length==5){
_2d9=_2d7;
_2d7=null;
_2d8=null;
}
var _2da=[],_2db,_2dc="";
if(!_2d9){
_2db=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_2db){
_2db={};
}
for(var prop in obj){
if(prop==null){
delete _2db[prop];
}else{
if(typeof obj[prop]=="string"||typeof obj[prop]=="number"){
_2db[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _2db){
_2da.push(escape(prop)+"="+escape(_2db[prop]));
}
_2dc=_2da.join("&");
}
dojo.io.cookie.setCookie(name,_2dc,days,path,_2d7,_2d8);
};
dojo.io.cookie.getObjectCookie=function(name){
var _2df=null,_2e0=dojo.io.cookie.getCookie(name);
if(_2e0){
_2df={};
var _2e1=_2e0.split("&");
for(var i=0;i<_2e1.length;i++){
var pair=_2e1[i].split("=");
var _2e4=pair[1];
if(isNaN(_2e4)){
_2e4=unescape(pair[1]);
}
_2df[unescape(pair[0])]=_2e4;
}
}
return _2df;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _2e5=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_2e5=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.provide("dojo.io.*");
dojo.provide("dojo.io");
dojo.deprecated("dojo.io","replaced by dojo.io.*","0.5");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_2e7){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _2ea=dl.nameAnonFunc(args[2],ao.adviceObj,_2e7);
ao.adviceFunc=_2ea;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _2ea=dl.nameAnonFunc(args[0],ao.srcObj,_2e7);
ao.srcFunc=_2ea;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _2ea=dl.nameAnonFunc(args[1],dj_global,_2e7);
ao.srcFunc=_2ea;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _2ea=dl.nameAnonFunc(args[3],dj_global,_2e7);
ao.adviceObj=dj_global;
ao.adviceFunc=_2ea;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _2ea=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_2e7);
ao.aroundFunc=_2ea;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _2ec={};
for(var x in ao){
_2ec[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_2ec.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_2ec));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _2f4;
if((arguments.length==1)&&(typeof a1=="object")){
_2f4=a1;
}else{
_2f4={srcObj:a1,srcFunc:a2};
}
_2f4.adviceFunc=function(){
var _2f5=[];
for(var x=0;x<arguments.length;x++){
_2f5.push(arguments[x]);
}
dojo.debug("("+_2f4.srcObj+")."+_2f4.srcFunc,":",_2f5.join(", "));
};
this.kwConnect(_2f4);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this._kwConnectImpl=function(_2fc,_2fd){
var fn=(_2fd)?"disconnect":"connect";
if(typeof _2fc["srcFunc"]=="function"){
_2fc.srcObj=_2fc["srcObj"]||dj_global;
var _2ff=dojo.lang.nameAnonFunc(_2fc.srcFunc,_2fc.srcObj,true);
_2fc.srcFunc=_2ff;
}
if(typeof _2fc["adviceFunc"]=="function"){
_2fc.adviceObj=_2fc["adviceObj"]||dj_global;
var _2ff=dojo.lang.nameAnonFunc(_2fc.adviceFunc,_2fc.adviceObj,true);
_2fc.adviceFunc=_2ff;
}
_2fc.srcObj=_2fc["srcObj"]||dj_global;
_2fc.adviceObj=_2fc["adviceObj"]||_2fc["targetObj"]||dj_global;
_2fc.adviceFunc=_2fc["adviceFunc"]||_2fc["targetFunc"];
return dojo.event[fn](_2fc);
};
this.kwConnect=function(_300){
return this._kwConnectImpl(_300,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
return mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
};
this.kwDisconnect=function(_303){
return this._kwConnectImpl(_303,true);
};
};
dojo.event.MethodInvocation=function(_304,obj,args){
this.jp_=_304;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_30c){
this.object=obj||dj_global;
this.methodname=_30c;
this.methodfunc=this.object[_30c];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_30e){
if(!obj){
obj=dj_global;
}
if(!obj[_30e]){
obj[_30e]=function(){
};
if(!obj[_30e]){
dojo.raise("Cannot set do-nothing method on that object "+_30e);
}
}else{
if((!dojo.lang.isFunction(obj[_30e]))&&(!dojo.lang.isAlien(obj[_30e]))){
return null;
}
}
var _30f=_30e+"$joinpoint";
var _310=_30e+"$joinpoint$method";
var _311=obj[_30f];
if(!_311){
var _312=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_312=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_30f,_310,_30e]);
}
}
var _313=obj[_30e].length;
obj[_310]=obj[_30e];
_311=obj[_30f]=new dojo.event.MethodJoinPoint(obj,_310);
obj[_30e]=function(){
var args=[];
if((_312)&&(!arguments.length)){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(_312)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _311.run.apply(_311,args);
};
obj[_30e].__preJoinArity=_313;
}
return _311;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _319=[];
for(var x=0;x<args.length;x++){
_319[x]=args[x];
}
var _31b=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _31d=marr[0]||dj_global;
var _31e=marr[1];
if(!_31d[_31e]){
dojo.raise("function \""+_31e+"\" does not exist on \""+_31d+"\"");
}
var _31f=marr[2]||dj_global;
var _320=marr[3];
var msg=marr[6];
var _322;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _31d[_31e].apply(_31d,to.args);
}};
to.args=_319;
var _324=parseInt(marr[4]);
var _325=((!isNaN(_324))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _328=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_31b(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_320){
_31f[_320].call(_31f,to);
}else{
if((_325)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_31d[_31e].call(_31d,to);
}else{
_31d[_31e].apply(_31d,args);
}
},_324);
}else{
if(msg){
_31d[_31e].call(_31d,to);
}else{
_31d[_31e].apply(_31d,args);
}
}
}
};
var _32b=function(){
if(this.squelch){
try{
return _31b.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _31b.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_32b);
}
var _32c;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_32c=mi.proceed();
}else{
if(this.methodfunc){
_32c=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_32b);
}
return (this.methodfunc)?_32c:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"]);
},addAdvice:function(_331,_332,_333,_334,_335,_336,once,_338,rate,_33a){
var arr=this.getArr(_335);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_331,_332,_333,_334,_338,rate,_33a];
if(once){
if(this.hasAdvice(_331,_332,_335,arr)>=0){
return;
}
}
if(_336=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_33d,_33e,_33f,arr){
if(!arr){
arr=this.getArr(_33f);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _33e=="object")?(new String(_33e)).toString():_33e;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_33d)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_345,_346,_347,once){
var arr=this.getArr(_347);
var ind=this.hasAdvice(_345,_346,_347,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_345,_346,_347,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_34b){
if(!this.topics[_34b]){
this.topics[_34b]=new this.TopicImpl(_34b);
}
return this.topics[_34b];
};
this.registerPublisher=function(_34c,obj,_34e){
var _34c=this.getTopic(_34c);
_34c.registerPublisher(obj,_34e);
};
this.subscribe=function(_34f,obj,_351){
var _34f=this.getTopic(_34f);
_34f.subscribe(obj,_351);
};
this.unsubscribe=function(_352,obj,_354){
var _352=this.getTopic(_352);
_352.unsubscribe(obj,_354);
};
this.destroy=function(_355){
this.getTopic(_355).destroy();
delete this.topics[_355];
};
this.publishApply=function(_356,args){
var _356=this.getTopic(_356);
_356.sendMessage.apply(_356,args);
};
this.publish=function(_358,_359){
var _358=this.getTopic(_358);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_358.sendMessage.apply(_358,args);
};
};
dojo.event.topic.TopicImpl=function(_35c){
this.topicName=_35c;
this.subscribe=function(_35d,_35e){
var tf=_35e||_35d;
var to=(!_35e)?dj_global:_35d;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_361,_362){
var tf=(!_362)?_361:_362;
var to=(!_362)?null:_361;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_365){
this._getJoinPoint().squelch=_365;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_366,_367){
dojo.event.connect(_366,_367,this,"sendMessage");
};
this.sendMessage=function(_368){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_36b){
var na;
var tna;
if(_36b){
tna=_36b.all||_36b.getElementsByTagName("*");
na=[_36b];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _36f={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _373=0;
this.normalizedEventName=function(_374){
switch(_374){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _374;
break;
default:
return _374.toLowerCase();
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_378){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_378.length;x++){
node.__clobberAttrs__.push(_378[x]);
}
};
this.removeListener=function(node,_37b,fp,_37d){
if(!_37d){
var _37d=false;
}
_37b=dojo.event.browser.normalizedEventName(_37b);
if((_37b=="onkey")||(_37b=="key")){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_37d);
}
_37b="onkeypress";
}
if(_37b.substr(0,2)=="on"){
_37b=_37b.substr(2);
}
if(node.removeEventListener){
node.removeEventListener(_37b,fp,_37d);
}
};
this.addListener=function(node,_37f,fp,_381,_382){
if(!node){
return;
}
if(!_381){
var _381=false;
}
_37f=dojo.event.browser.normalizedEventName(_37f);
if((_37f=="onkey")||(_37f=="key")){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_381,_382);
}
_37f="onkeypress";
}
if(_37f.substr(0,2)!="on"){
_37f="on"+_37f;
}
if(!_382){
var _383=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_381){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_383=fp;
}
if(node.addEventListener){
node.addEventListener(_37f.substr(2),_383,_381);
return _383;
}else{
if(typeof node[_37f]=="function"){
var _386=node[_37f];
node[_37f]=function(e){
_386(e);
return _383(e);
};
}else{
node[_37f]=_383;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_37f]);
}
return _383;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_389,_38a){
if(typeof _389!="function"){
dojo.raise("listener not a function: "+_389);
}
dojo.event.browser.currentEvent.currentTarget=_38a;
return _389.call(_38a,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_38d){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _38f=evt.keyCode;
if(_38f>=65&&_38f<=90&&evt.shiftKey==false){
_38f+=32;
}
if(_38f>=1&&_38f<=26&&evt.ctrlKey){
_38f+=96;
}
evt.key=String.fromCharCode(_38f);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _38f=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_38f+=32;
}
evt.key=String.fromCharCode(_38f);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
default:
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_38d?_38d:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _391=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_391.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_391.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.returnValue=false;
evt.cancelBubble=true;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.provide("dojo.event.*");
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_399){
if(_399){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_39a,_39b){
var rgb=null;
if(dojo.lang.isArray(_39a)){
rgb=_39a;
}else{
if(_39a instanceof dojo.gfx.color.Color){
rgb=_39a.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_39a).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_39b);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_39f){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_39f);
}
if(!_39f){
_39f=0;
}
_39f=Math.min(Math.max(-1,_39f),1);
_39f=((_39f+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_39f));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_3a4){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_3a4));
};
dojo.gfx.color.extractRGB=function(_3a5){
var hex="0123456789abcdef";
_3a5=_3a5.toLowerCase();
if(_3a5.indexOf("rgb")==0){
var _3a7=_3a5.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_3a7.splice(1,3);
return ret;
}else{
var _3a9=dojo.gfx.color.hex2rgb(_3a5);
if(_3a9){
return _3a9;
}else{
return dojo.gfx.color.named[_3a5]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _3ab="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_3ab+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_3ab.indexOf(rgb[i].charAt(0))*16+_3ab.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.lfx.Animation");
dojo.lfx.Line=function(_3b4,end){
this.start=_3b4;
this.end=end;
if(dojo.lang.isArray(_3b4)){
var diff=[];
dojo.lang.forEach(this.start,function(s,i){
diff[i]=this.end[i]-s;
},this);
this.getValue=function(n){
var res=[];
dojo.lang.forEach(this.start,function(s,i){
res[i]=(diff[i]*n)+s;
},this);
return res;
};
}else{
var diff=end-_3b4;
this.getValue=function(n){
return (diff*n)+this.start;
};
}
};
dojo.lfx.easeDefault=function(n){
if(dojo.render.html.khtml){
return (parseFloat("0.5")+((Math.sin((n+parseFloat("1.5"))*Math.PI))/2));
}else{
return (0.5+((Math.sin((n+1.5)*Math.PI))/2));
}
};
dojo.lfx.easeIn=function(n){
return Math.pow(n,3);
};
dojo.lfx.easeOut=function(n){
return (1-Math.pow(1-n,3));
};
dojo.lfx.easeInOut=function(n){
return ((3*Math.pow(n,2))-(2*Math.pow(n,3)));
};
dojo.lfx.IAnimation=function(){
};
dojo.lang.extend(dojo.lfx.IAnimation,{curve:null,duration:1000,easing:null,repeatCount:0,rate:25,handler:null,beforeBegin:null,onBegin:null,onAnimate:null,onEnd:null,onPlay:null,onPause:null,onStop:null,play:null,pause:null,stop:null,connect:function(evt,_3c3,_3c4){
if(!_3c4){
_3c4=_3c3;
_3c3=this;
}
_3c4=dojo.lang.hitch(_3c3,_3c4);
var _3c5=this[evt]||function(){
};
this[evt]=function(){
var ret=_3c5.apply(this,arguments);
_3c4.apply(this,arguments);
return ret;
};
return this;
},fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,(args||[]));
}
return this;
},repeat:function(_3c9){
this.repeatCount=_3c9;
return this;
},_active:false,_paused:false});
dojo.lfx.Animation=function(_3ca,_3cb,_3cc,_3cd,_3ce,rate){
dojo.lfx.IAnimation.call(this);
if(dojo.lang.isNumber(_3ca)||(!_3ca&&_3cb.getValue)){
rate=_3ce;
_3ce=_3cd;
_3cd=_3cc;
_3cc=_3cb;
_3cb=_3ca;
_3ca=null;
}else{
if(_3ca.getValue||dojo.lang.isArray(_3ca)){
rate=_3cd;
_3ce=_3cc;
_3cd=_3cb;
_3cc=_3ca;
_3cb=null;
_3ca=null;
}
}
if(dojo.lang.isArray(_3cc)){
this.curve=new dojo.lfx.Line(_3cc[0],_3cc[1]);
}else{
this.curve=_3cc;
}
if(_3cb!=null&&_3cb>0){
this.duration=_3cb;
}
if(_3ce){
this.repeatCount=_3ce;
}
if(rate){
this.rate=rate;
}
if(_3ca){
dojo.lang.forEach(["handler","beforeBegin","onBegin","onEnd","onPlay","onStop","onAnimate"],function(item){
if(_3ca[item]){
this.connect(item,_3ca[item]);
}
},this);
}
if(_3cd&&dojo.lang.isFunction(_3cd)){
this.easing=_3cd;
}
};
dojo.inherits(dojo.lfx.Animation,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Animation,{_startTime:null,_endTime:null,_timer:null,_percent:0,_startRepeatCount:0,play:function(_3d1,_3d2){
if(_3d2){
clearTimeout(this._timer);
this._active=false;
this._paused=false;
this._percent=0;
}else{
if(this._active&&!this._paused){
return this;
}
}
this.fire("handler",["beforeBegin"]);
this.fire("beforeBegin");
if(_3d1>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3d2);
}),_3d1);
return this;
}
this._startTime=new Date().valueOf();
if(this._paused){
this._startTime-=(this.duration*this._percent/100);
}
this._endTime=this._startTime+this.duration;
this._active=true;
this._paused=false;
var step=this._percent/100;
var _3d4=this.curve.getValue(step);
if(this._percent==0){
if(!this._startRepeatCount){
this._startRepeatCount=this.repeatCount;
}
this.fire("handler",["begin",_3d4]);
this.fire("onBegin",[_3d4]);
}
this.fire("handler",["play",_3d4]);
this.fire("onPlay",[_3d4]);
this._cycle();
return this;
},pause:function(){
clearTimeout(this._timer);
if(!this._active){
return this;
}
this._paused=true;
var _3d5=this.curve.getValue(this._percent/100);
this.fire("handler",["pause",_3d5]);
this.fire("onPause",[_3d5]);
return this;
},gotoPercent:function(pct,_3d7){
clearTimeout(this._timer);
this._active=true;
this._paused=true;
this._percent=pct;
if(_3d7){
this.play();
}
return this;
},stop:function(_3d8){
clearTimeout(this._timer);
var step=this._percent/100;
if(_3d8){
step=1;
}
var _3da=this.curve.getValue(step);
this.fire("handler",["stop",_3da]);
this.fire("onStop",[_3da]);
this._active=false;
this._paused=false;
return this;
},status:function(){
if(this._active){
return this._paused?"paused":"playing";
}else{
return "stopped";
}
return this;
},_cycle:function(){
clearTimeout(this._timer);
if(this._active){
var curr=new Date().valueOf();
var step=(curr-this._startTime)/(this._endTime-this._startTime);
if(step>=1){
step=1;
this._percent=100;
}else{
this._percent=step*100;
}
if((this.easing)&&(dojo.lang.isFunction(this.easing))){
step=this.easing(step);
}
var _3dd=this.curve.getValue(step);
this.fire("handler",["animate",_3dd]);
this.fire("onAnimate",[_3dd]);
if(step<1){
this._timer=setTimeout(dojo.lang.hitch(this,"_cycle"),this.rate);
}else{
this._active=false;
this.fire("handler",["end"]);
this.fire("onEnd");
if(this.repeatCount>0){
this.repeatCount--;
this.play(null,true);
}else{
if(this.repeatCount==-1){
this.play(null,true);
}else{
if(this._startRepeatCount){
this.repeatCount=this._startRepeatCount;
this._startRepeatCount=0;
}
}
}
}
}
return this;
}});
dojo.lfx.Combine=function(_3de){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._animsEnded=0;
var _3df=arguments;
if(_3df.length==1&&(dojo.lang.isArray(_3df[0])||dojo.lang.isArrayLike(_3df[0]))){
_3df=_3df[0];
}
dojo.lang.forEach(_3df,function(anim){
this._anims.push(anim);
anim.connect("onEnd",dojo.lang.hitch(this,"_onAnimsEnded"));
},this);
};
dojo.inherits(dojo.lfx.Combine,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Combine,{_animsEnded:0,play:function(_3e1,_3e2){
if(!this._anims.length){
return this;
}
this.fire("beforeBegin");
if(_3e1>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3e2);
}),_3e1);
return this;
}
if(_3e2||this._anims[0].percent==0){
this.fire("onBegin");
}
this.fire("onPlay");
this._animsCall("play",null,_3e2);
return this;
},pause:function(){
this.fire("onPause");
this._animsCall("pause");
return this;
},stop:function(_3e3){
this.fire("onStop");
this._animsCall("stop",_3e3);
return this;
},_onAnimsEnded:function(){
this._animsEnded++;
if(this._animsEnded>=this._anims.length){
this.fire("onEnd");
}
return this;
},_animsCall:function(_3e4){
var args=[];
if(arguments.length>1){
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
var _3e7=this;
dojo.lang.forEach(this._anims,function(anim){
anim[_3e4](args);
},_3e7);
return this;
}});
dojo.lfx.Chain=function(_3e9){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._currAnim=-1;
var _3ea=arguments;
if(_3ea.length==1&&(dojo.lang.isArray(_3ea[0])||dojo.lang.isArrayLike(_3ea[0]))){
_3ea=_3ea[0];
}
var _3eb=this;
dojo.lang.forEach(_3ea,function(anim,i,_3ee){
this._anims.push(anim);
if(i<_3ee.length-1){
anim.connect("onEnd",dojo.lang.hitch(this,"_playNext"));
}else{
anim.connect("onEnd",dojo.lang.hitch(this,function(){
this.fire("onEnd");
}));
}
},this);
};
dojo.inherits(dojo.lfx.Chain,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Chain,{_currAnim:-1,play:function(_3ef,_3f0){
if(!this._anims.length){
return this;
}
if(_3f0||!this._anims[this._currAnim]){
this._currAnim=0;
}
var _3f1=this._anims[this._currAnim];
this.fire("beforeBegin");
if(_3ef>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3f0);
}),_3ef);
return this;
}
if(_3f1){
if(this._currAnim==0){
this.fire("handler",["begin",this._currAnim]);
this.fire("onBegin",[this._currAnim]);
}
this.fire("onPlay",[this._currAnim]);
_3f1.play(null,_3f0);
}
return this;
},pause:function(){
if(this._anims[this._currAnim]){
this._anims[this._currAnim].pause();
this.fire("onPause",[this._currAnim]);
}
return this;
},playPause:function(){
if(this._anims.length==0){
return this;
}
if(this._currAnim==-1){
this._currAnim=0;
}
var _3f2=this._anims[this._currAnim];
if(_3f2){
if(!_3f2._active||_3f2._paused){
this.play();
}else{
this.pause();
}
}
return this;
},stop:function(){
var _3f3=this._anims[this._currAnim];
if(_3f3){
_3f3.stop();
this.fire("onStop",[this._currAnim]);
}
return _3f3;
},_playNext:function(){
if(this._currAnim==-1||this._anims.length==0){
return this;
}
this._currAnim++;
if(this._anims[this._currAnim]){
this._anims[this._currAnim].play(null,true);
}
return this;
}});
dojo.lfx.combine=function(_3f4){
var _3f5=arguments;
if(dojo.lang.isArray(arguments[0])){
_3f5=arguments[0];
}
if(_3f5.length==1){
return _3f5[0];
}
return new dojo.lfx.Combine(_3f5);
};
dojo.lfx.chain=function(_3f6){
var _3f7=arguments;
if(dojo.lang.isArray(arguments[0])){
_3f7=arguments[0];
}
if(_3f7.length==1){
return _3f7[0];
}
return new dojo.lfx.Chain(_3f7);
};
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_3f9,uri){
var loc=dojo.hostenv.getModulePrefix(_3f9);
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri()+loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _3fe=new dojo.uri.Uri(arguments[i].toString());
var _3ff=new dojo.uri.Uri(uri.toString());
if((_3fe.path=="")&&(_3fe.scheme==null)&&(_3fe.authority==null)&&(_3fe.query==null)){
if(_3fe.fragment!=null){
_3ff.fragment=_3fe.fragment;
}
_3fe=_3ff;
}else{
if(_3fe.scheme==null){
_3fe.scheme=_3ff.scheme;
if(_3fe.authority==null){
_3fe.authority=_3ff.authority;
if(_3fe.path.charAt(0)!="/"){
var path=_3ff.path.substring(0,_3ff.path.lastIndexOf("/")+1)+_3fe.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_3fe.path=segs.join("/");
}
}
}
}
uri="";
if(_3fe.scheme!=null){
uri+=_3fe.scheme+":";
}
if(_3fe.authority!=null){
uri+="//"+_3fe.authority;
}
uri+=_3fe.path;
if(_3fe.query!=null){
uri+="?"+_3fe.query;
}
if(_3fe.fragment!=null){
uri+="#"+_3fe.fragment;
}
}
this.uri=uri.toString();
var _403="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_403));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_403="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_403));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_40a){
return (new RegExp("(^|\\s+)"+_40a+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_40c){
_40c+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_40c);
};
dojo.html.addClass=function(node,_40e){
if(dojo.html.hasClass(node,_40e)){
return false;
}
_40e=(dojo.html.getClass(node)+" "+_40e).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_40e);
};
dojo.html.setClass=function(node,_410){
node=dojo.byId(node);
var cs=new String(_410);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_410);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_413,_414){
try{
if(!_414){
var _415=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_413+"(\\s+|$)"),"$1$2");
}else{
var _415=dojo.html.getClass(node).replace(_413,"");
}
dojo.html.setClass(node,_415);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_417,_418){
dojo.html.removeClass(node,_418);
dojo.html.addClass(node,_417);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_419,_41a,_41b,_41c,_41d){
_41d=false;
var _41e=dojo.doc();
_41a=dojo.byId(_41a)||_41e;
var _41f=_419.split(/\s+/g);
var _420=[];
if(_41c!=1&&_41c!=2){
_41c=0;
}
var _421=new RegExp("(\\s|^)(("+_41f.join(")|(")+"))(\\s|$)");
var _422=_41f.join(" ").length;
var _423=[];
if(!_41d&&_41e.evaluate){
var _424=".//"+(_41b||"*")+"[contains(";
if(_41c!=dojo.html.classMatchType.ContainsAny){
_424+="concat(' ',@class,' '), ' "+_41f.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_41c==2){
_424+=" and string-length(@class)="+_422+"]";
}else{
_424+="]";
}
}else{
_424+="concat(' ',@class,' '), ' "+_41f.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _425=_41e.evaluate(_424,_41a,null,XPathResult.ANY_TYPE,null);
var _426=_425.iterateNext();
while(_426){
try{
_423.push(_426);
_426=_425.iterateNext();
}
catch(e){
break;
}
}
return _423;
}else{
if(!_41b){
_41b="*";
}
_423=_41a.getElementsByTagName(_41b);
var node,i=0;
outer:
while(node=_423[i++]){
var _429=dojo.html.getClasses(node);
if(_429.length==0){
continue outer;
}
var _42a=0;
for(var j=0;j<_429.length;j++){
if(_421.test(_429[j])){
if(_41c==dojo.html.classMatchType.ContainsAny){
_420.push(node);
continue outer;
}else{
_42a++;
}
}else{
if(_41c==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_42a==_41f.length){
if((_41c==dojo.html.classMatchType.IsOnly)&&(_42a==_429.length)){
_420.push(node);
}else{
if(_41c==dojo.html.classMatchType.ContainsAll){
_420.push(node);
}
}
}
}
return _420;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_42c){
var arr=_42c.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_430){
return _430.replace(/([A-Z])/g,"-$1").toLowerCase();
};
dojo.html.getComputedStyle=function(node,_432,_433){
node=dojo.byId(node);
var _432=dojo.html.toSelectorCase(_432);
var _434=dojo.html.toCamelCase(_432);
if(!node||!node.style){
return _433;
}else{
if(document.defaultView&&dojo.html.isDescendantOf(node,node.ownerDocument)){
try{
var cs=document.defaultView.getComputedStyle(node,"");
if(cs){
return cs.getPropertyValue(_432);
}
}
catch(e){
if(node.style.getPropertyValue){
return node.style.getPropertyValue(_432);
}else{
return _433;
}
}
}else{
if(node.currentStyle){
return node.currentStyle[_434];
}
}
}
if(node.style.getPropertyValue){
return node.style.getPropertyValue(_432);
}else{
return _433;
}
};
dojo.html.getStyleProperty=function(node,_437){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_437)]:undefined);
};
dojo.html.getStyle=function(node,_439){
var _43a=dojo.html.getStyleProperty(node,_439);
return (_43a?_43a:dojo.html.getComputedStyle(node,_439));
};
dojo.html.setStyle=function(node,_43c,_43d){
node=dojo.byId(node);
if(node&&node.style){
var _43e=dojo.html.toCamelCase(_43c);
node.style[_43e]=_43d;
}
};
dojo.html.setStyleText=function(_43f,text){
try{
_43f.style.cssText=text;
}
catch(e){
_43f.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_441,_442){
if(!_442.style.cssText){
_441.setAttribute("style",_442.getAttribute("style"));
}else{
_441.style.cssText=_442.style.cssText;
}
dojo.html.addClass(_441,dojo.html.getClass(_442));
};
dojo.html.getUnitValue=function(node,_444,_445){
var s=dojo.html.getComputedStyle(node,_444);
if((!s)||((s=="auto")&&(_445))){
return {value:0,units:"px"};
}
var _447=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_447){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_447[1]),units:_447[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
dojo.html.getPixelValue=function(node,_449,_44a){
var _44b=dojo.html.getUnitValue(node,_449,_44a);
if(isNaN(_44b.value)){
return 0;
}
if((_44b.value)&&(_44b.units!="px")){
return NaN;
}
return _44b.value;
};
dojo.html.setPositivePixelValue=function(node,_44d,_44e){
if(isNaN(_44e)){
return false;
}
node.style[_44d]=Math.max(0,_44e)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_44f,_450,_451){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_451=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_451=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_44f+" { "+_450+" }";
return dojo.html.styleSheet.insertRule(rule,_451);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_44f,_450,_451);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_453){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_453){
_453=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_453);
}
}else{
if(document.styleSheets[0]){
if(!_453){
_453=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_453);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_456,_457){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _458=dojo.hostenv.getText(URI,false,_457);
if(_458===null){
return;
}
_458=dojo.html.fixPathsInCssText(_458,URI);
if(_456){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_458)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _45d=doc.getElementsByTagName("style");
for(var i=0;i<_45d.length;i++){
if(_45d[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _45e=dojo.html.insertCssText(_458);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_458,"nodeRef":_45e});
if(_45e&&djConfig.isDebug){
_45e.setAttribute("dbgHref",URI);
}
return _45e;
};
dojo.html.insertCssText=function(_45f,doc,URI){
if(!_45f){
return;
}
if(!doc){
doc=document;
}
if(URI){
_45f=dojo.html.fixPathsInCssText(_45f,URI);
}
var _462=doc.createElement("style");
_462.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_462);
}
if(_462.styleSheet){
_462.styleSheet.cssText=_45f;
}else{
var _464=doc.createTextNode(_45f);
_462.appendChild(_464);
}
return _462;
};
dojo.html.fixPathsInCssText=function(_465,URI){
function iefixPathsInCssText(){
var _467=/AlphaImageLoader\(src\=['"]([\t\s\w()\/.\\'"-:#=&?~]*)['"]/;
while(_468=_467.exec(_465)){
url=_468[1].replace(_46a,"$2");
if(!_46b.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_465.substring(0,_468.index)+"AlphaImageLoader(src='"+url+"'";
_465=_465.substr(_468.index+_468[0].length);
}
return str+_465;
}
if(!_465||!URI){
return;
}
var _468,str="",url="";
var _46d=/url\(\s*([\t\s\w()\/.\\'"-:#=&?]+)\s*\)/;
var _46b=/(file|https?|ftps?):\/\//;
var _46a=/^[\s]*(['"]?)([\w()\/.\\'"-:#=&?]*)\1[\s]*?$/;
if(dojo.render.html.ie55||dojo.render.html.ie60){
_465=iefixPathsInCssText();
}
while(_468=_46d.exec(_465)){
url=_468[1].replace(_46a,"$2");
if(!_46b.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_465.substring(0,_468.index)+"url("+url+")";
_465=_465.substr(_468.index+_468[0].length);
}
return str+_465;
};
dojo.html.setActiveStyleSheet=function(_46e){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_46e){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _47a={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _47a){
if(_47a[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_47d,_47e){
node=dojo.byId(node);
_47e(node,!_47d(node));
return _47d(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_483){
dojo.html[(_483?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_489){
dojo.html.setStyle(node,"display",((_489 instanceof String||typeof _489=="string")?_489:(_489?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_48d){
dojo.html.setStyle(node,"visibility",((_48d instanceof String||typeof _48d=="string")?_48d:(_48d?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_491,_492){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_492){
if(_491>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_491=0.999999;
}
}else{
if(_491<0){
_491=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_491*100+")";
}
}
node.style.filter="Alpha(Opacity="+_491*100+")";
}else{
if(h.moz){
node.style.opacity=_491;
node.style.MozOpacity=_491;
}else{
if(h.safari){
node.style.opacity=_491;
node.style.KhtmlOpacity=_491;
}else{
node.style.opacity=_491;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.color");
dojo.html.getBackgroundColor=function(node){
node=dojo.byId(node);
var _49d;
do{
_49d=dojo.html.getStyle(node,"background-color");
if(_49d.toLowerCase()=="rgba(0, 0, 0, 0)"){
_49d="transparent";
}
if(node==document.getElementsByTagName("body")[0]){
node=null;
break;
}
node=node.parentNode;
}while(node&&dojo.lang.inArray(["transparent",""],_49d));
if(_49d=="transparent"){
_49d=[255,255,255,0];
}else{
_49d=dojo.gfx.color.extractRGB(_49d);
}
return _49d;
};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _4a0=dojo.global();
var _4a1=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_4a1.documentElement.clientWidth;
h=_4a0.innerHeight;
}else{
if(!dojo.render.html.opera&&_4a0.innerWidth){
w=_4a0.innerWidth;
h=_4a0.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_4a1,"documentElement.clientWidth")){
var w2=_4a1.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_4a1.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _4a5=dojo.global();
var _4a6=dojo.doc();
var top=_4a5.pageYOffset||_4a6.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_4a5.pageXOffset||_4a6.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _4ab=dojo.doc();
var _4ac=dojo.byId(node);
type=type.toLowerCase();
while((_4ac)&&(_4ac.nodeName.toLowerCase()!=type)){
if(_4ac==(_4ab["body"]||_4ab["documentElement"])){
return null;
}
_4ac=_4ac.parentNode;
}
return _4ac;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _4b4={x:0,y:0};
if(e.pageX||e.pageY){
_4b4.x=e.pageX;
_4b4.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_4b4.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_4b4.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _4b4;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _4b9=dojo.doc().createElement("script");
_4b9.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_4b9);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_4bc,_4bd,args,_4bf,_4c0){
dojo.deprecated("dojo.html."+_4bc,"replaced by dojo.html."+_4bd+"("+(_4bf?"node, {"+_4bf+": "+_4bf+"}":"")+")"+(_4c0?"."+_4c0:""),"0.5");
var _4c1=[];
if(_4bf){
var _4c2={};
_4c2[_4bf]=args[1];
_4c1.push(args[0]);
_4c1.push(_4c2);
}else{
_4c1=args;
}
var ret=dojo.html[_4bd].apply(dojo.html,args);
if(_4c0){
return ret[_4c0];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _4c6=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_4c6+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _4c6;
};
dojo.html.setStyleAttributes=function(node,_4c9){
node=dojo.byId(node);
var _4ca=_4c9.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_4ca.length;i++){
var _4cc=_4ca[i].split(":");
var name=_4cc[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _4ce=_4cc[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_4ce);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_4ce});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_4ce});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_4ce});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_4ce});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_4ce;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_4d0,_4d1){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_4d1){
_4d1=bs.CONTENT_BOX;
}
var _4d4=2;
var _4d5;
switch(_4d1){
case bs.MARGIN_BOX:
_4d5=3;
break;
case bs.BORDER_BOX:
_4d5=2;
break;
case bs.PADDING_BOX:
default:
_4d5=1;
break;
case bs.CONTENT_BOX:
_4d5=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_4d4=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _4d9;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_4d9=db;
}else{
_4d9=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _4db=node;
do{
var n=_4db["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_4db["offsetTop"];
ret.y+=isNaN(m)?0:m;
_4db=_4db.offsetParent;
}while((_4db!=_4d9)&&(_4db!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_4d0){
var _4de=dojo.html.getScroll();
ret.y+=_4de.top;
ret.x+=_4de.left;
}
var _4df=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_4d4>_4d5){
for(var i=_4d5;i<_4d4;++i){
ret.y+=_4df[i](node,"top");
ret.x+=_4df[i](node,"left");
}
}else{
if(_4d4<_4d5){
for(var i=_4d5;i>_4d4;--i){
ret.y-=_4df[i-1](node,"top");
ret.x-=_4df[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_4e3,_4e4){
var _4e5=0;
for(var x=0;x<_4e3.length;x++){
_4e5+=dojo.html.getPixelValue(node,_4e3[x],_4e4);
}
return _4e5;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _4f2=dojo.html.getBorder(node);
return {width:pad.width+_4f2.width,height:pad.height+_4f2.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if((h.ie)||(h.opera)){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _4f7=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_4f7){
_4f7=dojo.html.getStyle(node,"box-sizing");
}
return (_4f7?_4f7:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _4fc=dojo.html.getBorder(node);
return {width:box.width-_4fc.width,height:box.height-_4fc.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _4fe=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_4fe.width,height:node.offsetHeight-_4fe.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _501=0;
var _502=0;
var isbb=dojo.html.isBorderBox(node);
var _504=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_501=args.width+_504.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_501);
}
if(typeof args.height!="undefined"){
_502=args.height+_504.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_502);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _507=dojo.html.getBorderBox(node);
var _508=dojo.html.getMargin(node);
return {width:_507.width+_508.width,height:_507.height+_508.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _50b=0;
var _50c=0;
var isbb=dojo.html.isBorderBox(node);
var _50e=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _50f=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_50b=args.width-_50e.width;
_50b-=_50f.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_50b);
}
if(typeof args.height!="undefined"){
_50c=args.height-_50e.height;
_50c-=_50f.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_50c);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_514,_515,_516){
if(_514 instanceof Array||typeof _514=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_514.length<4){
_514.push(0);
}
while(_514.length>4){
_514.pop();
}
var ret={left:_514[0],top:_514[1],width:_514[2],height:_514[3]};
}else{
if(!_514.nodeType&&!(_514 instanceof String||typeof _514=="string")&&("width" in _514||"height" in _514||"left" in _514||"x" in _514||"top" in _514||"y" in _514)){
var ret={left:_514.left||_514.x||0,top:_514.top||_514.y||0,width:_514.width||0,height:_514.height||0};
}else{
var node=dojo.byId(_514);
var pos=dojo.html.abs(node,_515,_516);
var _51a=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_51a.width,height:_51a.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_51c){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_51f){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_521){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_523){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_525){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_527){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_531){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_533){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.lfx.html");
dojo.lfx.html._byId=function(_534){
if(!_534){
return [];
}
if(dojo.lang.isArrayLike(_534)){
if(!_534.alreadyChecked){
var n=[];
dojo.lang.forEach(_534,function(node){
n.push(dojo.byId(node));
});
n.alreadyChecked=true;
return n;
}else{
return _534;
}
}else{
var n=[];
n.push(dojo.byId(_534));
n.alreadyChecked=true;
return n;
}
};
dojo.lfx.html.propertyAnimation=function(_537,_538,_539,_53a,_53b){
_537=dojo.lfx.html._byId(_537);
var _53c={"propertyMap":_538,"nodes":_537,"duration":_539,"easing":_53a||dojo.lfx.easeDefault};
var _53d=function(args){
if(args.nodes.length==1){
var pm=args.propertyMap;
if(!dojo.lang.isArray(args.propertyMap)){
var parr=[];
for(var _541 in pm){
pm[_541].property=_541;
parr.push(pm[_541]);
}
pm=args.propertyMap=parr;
}
dojo.lang.forEach(pm,function(prop){
if(dj_undef("start",prop)){
if(prop.property!="opacity"){
prop.start=parseInt(dojo.html.getComputedStyle(args.nodes[0],prop.property));
}else{
prop.start=dojo.html.getOpacity(args.nodes[0]);
}
}
});
}
};
var _543=function(_544){
var _545=[];
dojo.lang.forEach(_544,function(c){
_545.push(Math.round(c));
});
return _545;
};
var _547=function(n,_549){
n=dojo.byId(n);
if(!n||!n.style){
return;
}
for(var s in _549){
if(s=="opacity"){
dojo.html.setOpacity(n,_549[s]);
}else{
n.style[s]=_549[s];
}
}
};
var _54b=function(_54c){
this._properties=_54c;
this.diffs=new Array(_54c.length);
dojo.lang.forEach(_54c,function(prop,i){
if(dojo.lang.isFunction(prop.start)){
prop.start=prop.start(prop,i);
}
if(dojo.lang.isFunction(prop.end)){
prop.end=prop.end(prop,i);
}
if(dojo.lang.isArray(prop.start)){
this.diffs[i]=null;
}else{
if(prop.start instanceof dojo.gfx.color.Color){
prop.startRgb=prop.start.toRgb();
prop.endRgb=prop.end.toRgb();
}else{
this.diffs[i]=prop.end-prop.start;
}
}
},this);
this.getValue=function(n){
var ret={};
dojo.lang.forEach(this._properties,function(prop,i){
var _553=null;
if(dojo.lang.isArray(prop.start)){
}else{
if(prop.start instanceof dojo.gfx.color.Color){
_553=(prop.units||"rgb")+"(";
for(var j=0;j<prop.startRgb.length;j++){
_553+=Math.round(((prop.endRgb[j]-prop.startRgb[j])*n)+prop.startRgb[j])+(j<prop.startRgb.length-1?",":"");
}
_553+=")";
}else{
_553=((this.diffs[i])*n)+prop.start+(prop.property!="opacity"?prop.units||"px":"");
}
}
ret[dojo.html.toCamelCase(prop.property)]=_553;
},this);
return ret;
};
};
var anim=new dojo.lfx.Animation({beforeBegin:function(){
_53d(_53c);
anim.curve=new _54b(_53c.propertyMap);
},onAnimate:function(_556){
dojo.lang.forEach(_53c.nodes,function(node){
_547(node,_556);
});
}},_53c.duration,null,_53c.easing);
if(_53b){
for(var x in _53b){
if(dojo.lang.isFunction(_53b[x])){
anim.connect(x,anim,_53b[x]);
}
}
}
return anim;
};
dojo.lfx.html._makeFadeable=function(_559){
var _55a=function(node){
if(dojo.render.html.ie){
if((node.style.zoom.length==0)&&(dojo.html.getStyle(node,"zoom")=="normal")){
node.style.zoom="1";
}
if((node.style.width.length==0)&&(dojo.html.getStyle(node,"width")=="auto")){
node.style.width="auto";
}
}
};
if(dojo.lang.isArrayLike(_559)){
dojo.lang.forEach(_559,_55a);
}else{
_55a(_559);
}
};
dojo.lfx.html.fade=function(_55c,_55d,_55e,_55f,_560){
_55c=dojo.lfx.html._byId(_55c);
var _561={property:"opacity"};
if(!dj_undef("start",_55d)){
_561.start=_55d.start;
}else{
_561.start=function(){
return dojo.html.getOpacity(_55c[0]);
};
}
if(!dj_undef("end",_55d)){
_561.end=_55d.end;
}else{
dojo.raise("dojo.lfx.html.fade needs an end value");
}
var anim=dojo.lfx.propertyAnimation(_55c,[_561],_55e,_55f);
anim.connect("beforeBegin",function(){
dojo.lfx.html._makeFadeable(_55c);
});
if(_560){
anim.connect("onEnd",function(){
_560(_55c,anim);
});
}
return anim;
};
dojo.lfx.html.fadeIn=function(_563,_564,_565,_566){
return dojo.lfx.html.fade(_563,{end:1},_564,_565,_566);
};
dojo.lfx.html.fadeOut=function(_567,_568,_569,_56a){
return dojo.lfx.html.fade(_567,{end:0},_568,_569,_56a);
};
dojo.lfx.html.fadeShow=function(_56b,_56c,_56d,_56e){
_56b=dojo.lfx.html._byId(_56b);
dojo.lang.forEach(_56b,function(node){
dojo.html.setOpacity(node,0);
});
var anim=dojo.lfx.html.fadeIn(_56b,_56c,_56d,_56e);
anim.connect("beforeBegin",function(){
if(dojo.lang.isArrayLike(_56b)){
dojo.lang.forEach(_56b,dojo.html.show);
}else{
dojo.html.show(_56b);
}
});
return anim;
};
dojo.lfx.html.fadeHide=function(_571,_572,_573,_574){
var anim=dojo.lfx.html.fadeOut(_571,_572,_573,function(){
if(dojo.lang.isArrayLike(_571)){
dojo.lang.forEach(_571,dojo.html.hide);
}else{
dojo.html.hide(_571);
}
if(_574){
_574(_571,anim);
}
});
return anim;
};
dojo.lfx.html.wipeIn=function(_576,_577,_578,_579){
_576=dojo.lfx.html._byId(_576);
var _57a=[];
dojo.lang.forEach(_576,function(node){
var _57c={};
dojo.html.show(node);
var _57d=dojo.html.getBorderBox(node).height;
dojo.html.hide(node);
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:1,end:function(){
return _57d;
}}},_577,_578);
anim.connect("beforeBegin",function(){
_57c.overflow=node.style.overflow;
_57c.height=node.style.height;
with(node.style){
overflow="hidden";
_57d="1px";
}
dojo.html.show(node);
});
anim.connect("onEnd",function(){
with(node.style){
overflow=_57c.overflow;
_57d=_57c.height;
}
if(_579){
_579(node,anim);
}
});
_57a.push(anim);
});
return dojo.lfx.combine(_57a);
};
dojo.lfx.html.wipeOut=function(_57f,_580,_581,_582){
_57f=dojo.lfx.html._byId(_57f);
var _583=[];
dojo.lang.forEach(_57f,function(node){
var _585={};
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:function(){
return dojo.html.getContentBox(node).height;
},end:1}},_580,_581,{"beforeBegin":function(){
_585.overflow=node.style.overflow;
_585.height=node.style.height;
with(node.style){
overflow="hidden";
}
dojo.html.show(node);
},"onEnd":function(){
dojo.html.hide(node);
with(node.style){
overflow=_585.overflow;
height=_585.height;
}
if(_582){
_582(node,anim);
}
}});
_583.push(anim);
});
return dojo.lfx.combine(_583);
};
dojo.lfx.html.slideTo=function(_587,_588,_589,_58a,_58b){
_587=dojo.lfx.html._byId(_587);
var _58c=[];
var _58d=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_588)){
dojo.deprecated("dojo.lfx.html.slideTo(node, array)","use dojo.lfx.html.slideTo(node, {top: value, left: value});","0.5");
_588={top:_588[0],left:_588[1]};
}
dojo.lang.forEach(_587,function(node){
var top=null;
var left=null;
var init=(function(){
var _592=node;
return function(){
var pos=_58d(_592,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_58d(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_58d(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_592,true);
dojo.html.setStyleAttributes(_592,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:(_588.top||0)},"left":{start:left,end:(_588.left||0)}},_589,_58a,{"beforeBegin":init});
if(_58b){
anim.connect("onEnd",function(){
_58b(_587,anim);
});
}
_58c.push(anim);
});
return dojo.lfx.combine(_58c);
};
dojo.lfx.html.slideBy=function(_596,_597,_598,_599,_59a){
_596=dojo.lfx.html._byId(_596);
var _59b=[];
var _59c=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_597)){
dojo.deprecated("dojo.lfx.html.slideBy(node, array)","use dojo.lfx.html.slideBy(node, {top: value, left: value});","0.5");
_597={top:_597[0],left:_597[1]};
}
dojo.lang.forEach(_596,function(node){
var top=null;
var left=null;
var init=(function(){
var _5a1=node;
return function(){
var pos=_59c(_5a1,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_59c(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_59c(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_5a1,true);
dojo.html.setStyleAttributes(_5a1,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:top+(_597.top||0)},"left":{start:left,end:left+(_597.left||0)}},_598,_599).connect("beforeBegin",init);
if(_59a){
anim.connect("onEnd",function(){
_59a(_596,anim);
});
}
_59b.push(anim);
});
return dojo.lfx.combine(_59b);
};
dojo.lfx.html.explode=function(_5a5,_5a6,_5a7,_5a8,_5a9){
var h=dojo.html;
_5a5=dojo.byId(_5a5);
_5a6=dojo.byId(_5a6);
var _5ab=h.toCoordinateObject(_5a5,true);
var _5ac=document.createElement("div");
h.copyStyle(_5ac,_5a6);
if(_5a6.explodeClassName){
_5ac.className=_5a6.explodeClassName;
}
with(_5ac.style){
position="absolute";
display="none";
}
dojo.body().appendChild(_5ac);
with(_5a6.style){
visibility="hidden";
display="block";
}
var _5ad=h.toCoordinateObject(_5a6,true);
with(_5a6.style){
display="none";
visibility="visible";
}
var _5ae={opacity:{start:0.5,end:1}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_5ae[type]={start:_5ab[type],end:_5ad[type]};
});
var anim=new dojo.lfx.propertyAnimation(_5ac,_5ae,_5a7,_5a8,{"beforeBegin":function(){
h.setDisplay(_5ac,"block");
},"onEnd":function(){
h.setDisplay(_5a6,"block");
_5ac.parentNode.removeChild(_5ac);
}});
if(_5a9){
anim.connect("onEnd",function(){
_5a9(_5a6,anim);
});
}
return anim;
};
dojo.lfx.html.implode=function(_5b1,end,_5b3,_5b4,_5b5){
var h=dojo.html;
_5b1=dojo.byId(_5b1);
end=dojo.byId(end);
var _5b7=dojo.html.toCoordinateObject(_5b1,true);
var _5b8=dojo.html.toCoordinateObject(end,true);
var _5b9=document.createElement("div");
dojo.html.copyStyle(_5b9,_5b1);
if(_5b1.explodeClassName){
_5b9.className=_5b1.explodeClassName;
}
dojo.html.setOpacity(_5b9,0.3);
with(_5b9.style){
position="absolute";
display="none";
backgroundColor=h.getStyle(_5b1,"background-color").toLowerCase();
}
dojo.body().appendChild(_5b9);
var _5ba={opacity:{start:1,end:0.5}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_5ba[type]={start:_5b7[type],end:_5b8[type]};
});
var anim=new dojo.lfx.propertyAnimation(_5b9,_5ba,_5b3,_5b4,{"beforeBegin":function(){
dojo.html.hide(_5b1);
dojo.html.show(_5b9);
},"onEnd":function(){
_5b9.parentNode.removeChild(_5b9);
}});
if(_5b5){
anim.connect("onEnd",function(){
_5b5(_5b1,anim);
});
}
return anim;
};
dojo.lfx.html.highlight=function(_5bd,_5be,_5bf,_5c0,_5c1){
_5bd=dojo.lfx.html._byId(_5bd);
var _5c2=[];
dojo.lang.forEach(_5bd,function(node){
var _5c4=dojo.html.getBackgroundColor(node);
var bg=dojo.html.getStyle(node,"background-color").toLowerCase();
var _5c6=dojo.html.getStyle(node,"background-image");
var _5c7=(bg=="transparent"||bg=="rgba(0, 0, 0, 0)");
while(_5c4.length>3){
_5c4.pop();
}
var rgb=new dojo.gfx.color.Color(_5be);
var _5c9=new dojo.gfx.color.Color(_5c4);
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:rgb,end:_5c9}},_5bf,_5c0,{"beforeBegin":function(){
if(_5c6){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+rgb.toRgb().join(",")+")";
},"onEnd":function(){
if(_5c6){
node.style.backgroundImage=_5c6;
}
if(_5c7){
node.style.backgroundColor="transparent";
}
if(_5c1){
_5c1(node,anim);
}
}});
_5c2.push(anim);
});
return dojo.lfx.combine(_5c2);
};
dojo.lfx.html.unhighlight=function(_5cb,_5cc,_5cd,_5ce,_5cf){
_5cb=dojo.lfx.html._byId(_5cb);
var _5d0=[];
dojo.lang.forEach(_5cb,function(node){
var _5d2=new dojo.gfx.color.Color(dojo.html.getBackgroundColor(node));
var rgb=new dojo.gfx.color.Color(_5cc);
var _5d4=dojo.html.getStyle(node,"background-image");
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:_5d2,end:rgb}},_5cd,_5ce,{"beforeBegin":function(){
if(_5d4){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+_5d2.toRgb().join(",")+")";
},"onEnd":function(){
if(_5cf){
_5cf(node,anim);
}
}});
_5d0.push(anim);
});
return dojo.lfx.combine(_5d0);
};
dojo.lang.mixin(dojo.lfx,dojo.lfx.html);
dojo.provide("dojo.lfx.*");


__CPAN_EDITION__ ajax build.txt

Files baked into this package:

dojoGuardStart.js,
../src/bootstrap1.js,
../src/loader.js,
dojoGuardEnd.js,
../src/hostenv_browser.js,
../src/bootstrap2.js,
../src/string/common.js,
../src/string.js,
../src/lang/common.js,
../src/lang/extras.js,
../src/io/common.js,
../src/lang/array.js,
../src/lang/func.js,
../src/string/extras.js,
../src/dom.js,
../src/undo/browser.js,
../src/io/BrowserIO.js,
../src/io/cookie.js,
../src/io/__package__.js,
../src/io.js,
../src/event/common.js,
../src/event/topic.js,
../src/event/browser.js,
../src/event/__package__.js,
../src/gfx/color.js,
../src/lfx/Animation.js,
../src/uri/Uri.js,
../src/html/style.js,
../src/html/display.js,
../src/html/color.js,
../src/html/common.js,
../src/html/layout.js,
../src/lfx/html.js,
../src/lfx/__package__.js

		
__CPAN_EDITION__ browserio dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:0,flag:"",revision:Number("$Rev: 6258 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
return _6e?_6e.toLowerCase():dojo.locale;
};
dojo.hostenv.searchLocalePath=function(_6f,_70,_71){
_6f=dojo.hostenv.normalizeLocale(_6f);
var _72=_6f.split("-");
var _73=[];
for(var i=_72.length;i>0;i--){
_73.push(_72.slice(0,i).join("-"));
}
_73.push(false);
if(_70){
_73.reverse();
}
for(var j=_73.length-1;j>=0;j--){
var loc=_73[j]||"ROOT";
var _77=_71(loc);
if(_77){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_78){
_78=dojo.hostenv.normalizeLocale(_78);
dojo.hostenv.searchLocalePath(_78,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7b=djConfig.extraLocale||[];
for(var i=0;i<_7b.length;i++){
preload(_7b[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7d,_7e,_7f){
dojo.hostenv.preloadLocalizations();
var _80=[_7d,"nls",_7e].join(".");
var _81=dojo.hostenv.findModule(_80);
if(_81){
if(djConfig.localizationComplete&&_81._built){
return;
}
var _82=dojo.hostenv.normalizeLocale(_7f).replace("-","_");
var _83=_80+"."+_82;
if(dojo.hostenv.findModule(_83)){
return;
}
}
_81=dojo.hostenv.startPackage(_80);
var _84=dojo.hostenv.getModuleSymbols(_7d);
var _85=_84.concat("nls").join("/");
var _86;
dojo.hostenv.searchLocalePath(_7f,false,function(loc){
var _88=loc.replace("-","_");
var _89=_80+"."+_88;
var _8a=false;
if(!dojo.hostenv.findModule(_89)){
dojo.hostenv.startPackage(_89);
var _8b=[_85];
if(loc!="ROOT"){
_8b.push(loc);
}
_8b.push(_7e);
var _8c=_8b.join("/")+".js";
_8a=dojo.hostenv.loadPath(_8c,null,function(_8d){
var _8e=function(){
};
_8e.prototype=_86;
_81[_88]=new _8e();
for(var j in _8d){
_81[_88][j]=_8d[j];
}
});
}else{
_8a=true;
}
if(_8a&&_81[_88]){
_86=_81[_88];
}else{
_81[_88]=_86;
}
});
};
(function(){
var _90=djConfig.extraLocale;
if(_90){
if(!_90 instanceof Array){
_90=[_90];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_94){
req(m,b,_94);
if(_94){
return;
}
for(var i=0;i<_90.length;i++){
req(m,b,_90[i]);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _96=document.location.toString();
var _97=_96.split("?",2);
if(_97.length>1){
var _98=_97[1];
var _99=_98.split("&");
for(var x in _99){
var sp=_99[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _9d=document.getElementsByTagName("script");
var _9e=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_9d.length;i++){
var src=_9d[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_9e);
if(m){
var _a2=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_a2+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_a2;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_a2;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _aa=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_aa>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_aa+6,_aa+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _ac=window["document"];
var tdi=_ac["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b0=null;
var _b1=null;
try{
_b0=new XMLHttpRequest();
}
catch(e){
}
if(!_b0){
for(var i=0;i<3;++i){
var _b3=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b0=new ActiveXObject(_b3);
}
catch(e){
_b1=e;
}
if(_b0){
dojo.hostenv._XMLHTTP_PROGIDS=[_b3];
break;
}
}
}
if(!_b0){
return dojo.raise("XMLHTTP not available",_b1);
}
return _b0;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_b5,_b6){
if(!_b5){
this._blockAsync=true;
}
var _b7=this.getXmlhttpObject();
function isDocumentOk(_b8){
var _b9=_b8["status"];
return Boolean((!_b9)||((200<=_b9)&&(300>_b9))||(_b9==304));
}
if(_b5){
var _ba=this,_bb=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_b7.onreadystatechange=function(){
if(_bb){
gbl.clearTimeout(_bb);
_bb=null;
}
if(_ba._blockAsync||(xhr&&xhr._blockAsync)){
_bb=gbl.setTimeout(function(){
_b7.onreadystatechange.apply(this);
},10);
}else{
if(4==_b7.readyState){
if(isDocumentOk(_b7)){
_b5(_b7.responseText);
}
}
}
};
}
_b7.open("GET",uri,_b5?true:false);
try{
_b7.send(null);
if(_b5){
return null;
}
if(!isDocumentOk(_b7)){
var err=Error("Unable to load "+uri+" status:"+_b7.status);
err.status=_b7.status;
err.responseText=_b7.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_b6)&&(!_b5)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _b7.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_bf){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_bf);
}else{
try{
var _c0=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c0){
_c0=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_bf));
_c0.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_bf+"</div>");
}
catch(e2){
window.status=_bf;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_c2,_c3,fp,_c5){
var _c6=_c2["on"+_c3]||function(){
};
_c2["on"+_c3]=function(){
fp.apply(_c2,arguments);
_c6.apply(_c2,arguments);
};
return true;
}
function dj_load_init(e){
var _c8=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_c8!="domcontentloaded"&&_c8!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _c9=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_c9();
dojo.hostenv.modulesLoaded();
}else{
dojo.addOnLoad(_c9);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _cb=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_cb=_cb.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_cb=_cb.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_cb.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _cc=new dojo.xml.Parse();
if(_cb.length>0){
for(var x=0;x<_cb.length;x++){
var _ce=document.getElementById(_cb[x]);
if(!_ce){
continue;
}
var _cf=_cc.parseElement(_ce,null,true);
dojo.widget.getParser().createComponents(_cf);
}
}else{
if(djConfig.parseWidgets){
var _cf=_cc.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_cf);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_d4,_d5){
dj_currentContext=_d4;
dj_currentDocument=_d5;
};
dojo._fireCallback=function(_d6,_d7,_d8){
if((_d7)&&((typeof _d6=="string")||(_d6 instanceof String))){
_d6=_d7[_d6];
}
return (_d7?_d6.apply(_d7,_d8||[]):_d6());
};
dojo.withGlobal=function(_d9,_da,_db,_dc){
var _dd;
var _de=dj_currentContext;
var _df=dj_currentDocument;
try{
dojo.setContext(_d9,_d9.document);
_dd=dojo._fireCallback(_da,_db,_dc);
}
finally{
dojo.setContext(_de,_df);
}
return _dd;
};
dojo.withDoc=function(_e0,_e1,_e2,_e3){
var _e4;
var _e5=dj_currentDocument;
try{
dj_currentDocument=_e0;
_e4=dojo._fireCallback(_e1,_e2,_e3);
}
finally{
dj_currentDocument=_e5;
}
return _e4;
};
}
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _e6=false;
var _e7=false;
var _e8=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_e6=true;
}else{
if(typeof this["load"]=="function"){
_e7=true;
}else{
if(window.widget){
_e8=true;
}
}
}
var _e9=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_e9.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_e6)&&(!_e8)){
_e9.push("browser_debug.js");
}
var _ea=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_ea=djConfig["baseLoaderUri"];
}
for(var x=0;x<_e9.length;x++){
var _ec=_ea+"src/"+_e9[x];
if(_e6||_e7){
load(_ec);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_ec+"'></scr"+"ipt>");
}
catch(e){
var _ed=document.createElement("script");
_ed.src=_ec;
document.getElementsByTagName("head")[0].appendChild(_ed);
}
}
}
})();
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_f4,_f5){
var out="";
for(var i=0;i<_f4;i++){
out+=str;
if(_f5&&i<_f4-1){
out+=_f5;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_103,_104){
if(typeof _104!="function"){
dojo.raise("dojo.inherits: superclass argument ["+_104+"] must be a function (subclass: ["+_103+"']");
}
_103.prototype=new _104();
_103.prototype.constructor=_103;
_103.superclass=_104.prototype;
_103["super"]=_104.prototype;
};
dojo.lang._mixin=function(obj,_106){
var tobj={};
for(var x in _106){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_106[x])){
obj[x]=_106[x];
}
}
if(dojo.render.html.ie&&(typeof (_106["toString"])=="function")&&(_106["toString"]!=obj["toString"])&&(_106["toString"]!=tobj["toString"])){
obj.toString=_106.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_10a){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_10d,_10e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_10d.prototype,arguments[i]);
}
return _10d;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_111,_112,_113,_114){
if(!dojo.lang.isArrayLike(_111)&&dojo.lang.isArrayLike(_112)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_111;
_111=_112;
_112=temp;
}
var _116=dojo.lang.isString(_111);
if(_116){
_111=_111.split("");
}
if(_114){
var step=-1;
var i=_111.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_111.length;
}
if(_113){
while(i!=end){
if(_111[i]===_112){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_111[i]==_112){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_11a,_11b,_11c){
return dojo.lang.find(_11a,_11b,_11c,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_11d,_11e){
return dojo.lang.find(_11d,_11e)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
if(!it){
return false;
}
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction()&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_129){
var _12a=window,_12b=2;
if(!dojo.lang.isFunction(func)){
_12a=func;
func=_129;
_129=arguments[2];
_12b++;
}
if(dojo.lang.isString(func)){
func=_12a[func];
}
var args=[];
for(var i=_12b;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_12a,args);
},_129);
};
dojo.lang.clearTimeout=function(_12e){
dojo.global().clearTimeout(_12e);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_137,_138,_139){
with(dojo.parseObjPath(_137,_138,_139)){
return dojo.evalProp(prop,obj,_139);
}
};
dojo.lang.setObjPathValue=function(_13a,_13b,_13c,_13d){
if(arguments.length<4){
_13d=true;
}
with(dojo.parseObjPath(_13a,_13c,_13d)){
if(obj&&(_13d||(prop in obj))){
obj[prop]=_13b;
}
}
};
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_13f,_140,_141){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_13f){
this.mimetype=_13f;
}
if(_140){
this.transport=_140;
}
if(arguments.length>=4){
this.changeUrl=_141;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_144,_145){
},error:function(type,_147,_148,_149){
},timeout:function(type,_14b,_14c,_14d){
},handle:function(type,data,_150,_151){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_152){
if(_152["url"]){
_152.url=_152.url.toString();
}
if(_152["formNode"]){
_152.formNode=dojo.byId(_152.formNode);
}
if(!_152["method"]&&_152["formNode"]&&_152["formNode"].method){
_152.method=_152["formNode"].method;
}
if(!_152["handle"]&&_152["handler"]){
_152.handle=_152.handler;
}
if(!_152["load"]&&_152["loaded"]){
_152.load=_152.loaded;
}
if(!_152["changeUrl"]&&_152["changeURL"]){
_152.changeUrl=_152.changeURL;
}
_152.encoding=dojo.lang.firstValued(_152["encoding"],djConfig["bindEncoding"],"");
_152.sendTransport=dojo.lang.firstValued(_152["sendTransport"],djConfig["ioSendTransport"],false);
var _153=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_152[fn]&&_153(_152[fn])){
continue;
}
if(_152["handle"]&&_153(_152["handle"])){
_152[fn]=_152.handle;
}
}
dojo.lang.mixin(this,_152);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_15a){
if(!(_15a instanceof dojo.io.Request)){
try{
_15a=new dojo.io.Request(_15a);
}
catch(e){
dojo.debug(e);
}
}
var _15b="";
if(_15a["transport"]){
_15b=_15a["transport"];
if(!this[_15b]){
dojo.io.sendBindError(_15a,"No dojo.io.bind() transport with name '"+_15a["transport"]+"'.");
return _15a;
}
if(!this[_15b].canHandle(_15a)){
dojo.io.sendBindError(_15a,"dojo.io.bind() transport with name '"+_15a["transport"]+"' cannot handle this type of request.");
return _15a;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_15a))){
_15b=tmp;
break;
}
}
if(_15b==""){
dojo.io.sendBindError(_15a,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _15a;
}
}
this[_15b].bind(_15a);
_15a.bindSuccess=true;
return _15a;
};
dojo.io.sendBindError=function(_15e,_15f){
if((typeof _15e.error=="function"||typeof _15e.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _160=new dojo.io.Error(_15f);
setTimeout(function(){
_15e[(typeof _15e.error=="function")?"error":"handle"]("error",_160,null,_15e);
},50);
}else{
dojo.raise(_15f);
}
};
dojo.io.queueBind=function(_161){
if(!(_161 instanceof dojo.io.Request)){
try{
_161=new dojo.io.Request(_161);
}
catch(e){
dojo.debug(e);
}
}
var _162=_161.load;
_161.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_162.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _164=_161.error;
_161.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_164.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_161);
dojo.io._dispatchNextQueueBind();
return _161;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_167,last){
var enc=/utf/i.test(_167||"")?encodeURIComponent:dojo.string.encodeAscii;
var _16a=[];
var _16b=new Object();
for(var name in map){
var _16d=function(elt){
var val=enc(name)+"="+enc(elt);
_16a[(last==name)?"push":"unshift"](val);
};
if(!_16b[name]){
var _170=map[name];
if(dojo.lang.isArray(_170)){
dojo.lang.forEach(_170,_16d);
}else{
_16d(_170);
}
}
}
return _16a.join("&");
};
dojo.io.setIFrameSrc=function(_171,src,_173){
try{
var r=dojo.render.html;
if(!_173){
if(r.safari){
_171.location=src;
}else{
frames[_171.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_171.contentWindow.document;
}else{
if(r.safari){
idoc=_171.document;
}else{
idoc=_171.contentWindow;
}
}
if(!idoc){
_171.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.lang.array");
dojo.lang.has=function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
};
dojo.lang.isEmpty=function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _17a=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_17a++;
break;
}
}
return _17a==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
};
dojo.lang.map=function(arr,obj,_17e){
var _17f=dojo.lang.isString(arr);
if(_17f){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_17e)){
_17e=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_17e){
var _180=obj;
obj=_17e;
_17e=_180;
}
}
if(Array.map){
var _181=Array.map(arr,_17e,obj);
}else{
var _181=[];
for(var i=0;i<arr.length;++i){
_181.push(_17e.call(obj,arr[i]));
}
}
if(_17f){
return _181.join("");
}else{
return _181;
}
};
dojo.lang.reduce=function(arr,_184,obj,_186){
var _187=_184;
var ob=obj?obj:dj_global;
dojo.lang.map(arr,function(val){
_187=_186.call(ob,_187,val);
});
return _187;
};
dojo.lang.forEach=function(_18a,_18b,_18c){
if(dojo.lang.isString(_18a)){
_18a=_18a.split("");
}
if(Array.forEach){
Array.forEach(_18a,_18b,_18c);
}else{
if(!_18c){
_18c=dj_global;
}
for(var i=0,l=_18a.length;i<l;i++){
_18b.call(_18c,_18a[i],i,_18a);
}
}
};
dojo.lang._everyOrSome=function(_18f,arr,_191,_192){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_18f?"every":"some"](arr,_191,_192);
}else{
if(!_192){
_192=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _195=_191.call(_192,arr[i],i,arr);
if(_18f&&!_195){
return false;
}else{
if((!_18f)&&(_195)){
return true;
}
}
}
return Boolean(_18f);
}
};
dojo.lang.every=function(arr,_197,_198){
return this._everyOrSome(true,arr,_197,_198);
};
dojo.lang.some=function(arr,_19a,_19b){
return this._everyOrSome(false,arr,_19a,_19b);
};
dojo.lang.filter=function(arr,_19d,_19e){
var _19f=dojo.lang.isString(arr);
if(_19f){
arr=arr.split("");
}
var _1a0;
if(Array.filter){
_1a0=Array.filter(arr,_19d,_19e);
}else{
if(!_19e){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_19e=dj_global;
}
_1a0=[];
for(var i=0;i<arr.length;i++){
if(_19d.call(_19e,arr[i],i,arr)){
_1a0.push(arr[i]);
}
}
}
if(_19f){
return _1a0.join("");
}else{
return _1a0;
}
};
dojo.lang.unnest=function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
};
dojo.lang.toArray=function(_1a5,_1a6){
var _1a7=[];
for(var i=_1a6||0;i<_1a5.length;i++){
_1a7.push(_1a5[i]);
}
return _1a7;
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_1a9,_1aa){
var fcn=(dojo.lang.isString(_1aa)?_1a9[_1aa]:_1aa)||function(){
};
return function(){
return fcn.apply(_1a9,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_1ac,_1ad,_1ae){
var nso=(_1ad||dojo.lang.anon);
if((_1ae)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_1ac){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_1ac;
return ret;
};
dojo.lang.forward=function(_1b2){
return function(){
return this[_1b2].apply(this,arguments);
};
};
dojo.lang.curry=function(ns,func){
var _1b5=[];
ns=ns||dj_global;
if(dojo.lang.isString(func)){
func=ns[func];
}
for(var x=2;x<arguments.length;x++){
_1b5.push(arguments[x]);
}
var _1b7=(func["__preJoinArity"]||func.length)-_1b5.length;
function gather(_1b8,_1b9,_1ba){
var _1bb=_1ba;
var _1bc=_1b9.slice(0);
for(var x=0;x<_1b8.length;x++){
_1bc.push(_1b8[x]);
}
_1ba=_1ba-_1b8.length;
if(_1ba<=0){
var res=func.apply(ns,_1bc);
_1ba=_1bb;
return res;
}else{
return function(){
return gather(arguments,_1bc,_1ba);
};
}
}
return gather([],_1b5,_1b7);
};
dojo.lang.curryArguments=function(ns,func,args,_1c2){
var _1c3=[];
var x=_1c2||0;
for(x=_1c2;x<args.length;x++){
_1c3.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[ns,func].concat(_1c3));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1c9,_1ca){
if(!farr.length){
if(typeof _1ca=="function"){
_1ca();
}
return;
}
if((typeof _1c9=="undefined")&&(typeof cb=="number")){
_1c9=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1c9){
_1c9=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1c9,_1ca);
},_1c9);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_1cb,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _1cb.replace(/\%\{(\w+)\}/g,function(_1ce,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _1d1=str.split(" ");
for(var i=0;i<_1d1.length;i++){
_1d1[i]=_1d1[i].charAt(0).toUpperCase()+_1d1[i].substring(1);
}
return _1d1.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _1d6=escape(str);
var _1d7,re=/%u([0-9A-F]{4})/i;
while((_1d7=_1d6.match(re))){
var num=Number("0x"+_1d7[1]);
var _1da=escape("&#"+num+";");
ret+=_1d6.substring(0,_1d7.index)+_1da;
_1d6=_1d6.substring(_1d7.index+_1d7[0].length);
}
ret+=_1d6.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_1df){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_1df){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_1e8){
if(_1e8){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1ec,_1ed){
if(_1ed){
str=str.toLowerCase();
_1ec=_1ec.toLowerCase();
}
return str.indexOf(_1ec)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1f3){
if(_1f3=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1f3=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1f5){
var _1f6=[];
for(var i=0,_1f8=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1f5){
_1f6.push(str.substring(_1f8,i));
_1f8=i+1;
}
}
_1f6.push(str.substr(_1f8));
return _1f6;
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(E){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _1fa=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_1fa.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_1fc,_1fd){
var node=_1fc.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_1fd&&node&&node.tagName&&node.tagName.toLowerCase()!=_1fd.toLowerCase()){
node=dojo.dom.nextElement(node,_1fd);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_1ff,_200){
var node=_1ff.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_200&&node&&node.tagName&&node.tagName.toLowerCase()!=_200.toLowerCase()){
node=dojo.dom.prevElement(node,_200);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_203){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_203&&_203.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_203);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_205){
if(!node){
return null;
}
if(_205){
_205=_205.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_205&&_205.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_205);
}
return node;
};
dojo.dom.moveChildren=function(_206,_207,trim){
var _209=0;
if(trim){
while(_206.hasChildNodes()&&_206.firstChild.nodeType==dojo.dom.TEXT_NODE){
_206.removeChild(_206.firstChild);
}
while(_206.hasChildNodes()&&_206.lastChild.nodeType==dojo.dom.TEXT_NODE){
_206.removeChild(_206.lastChild);
}
}
while(_206.hasChildNodes()){
_207.appendChild(_206.firstChild);
_209++;
}
return _209;
};
dojo.dom.copyChildren=function(_20a,_20b,trim){
var _20d=_20a.cloneNode(true);
return this.moveChildren(_20d,_20b,trim);
};
dojo.dom.removeChildren=function(node){
var _20f=node.childNodes.length;
while(node.hasChildNodes()){
node.removeChild(node.firstChild);
}
return _20f;
};
dojo.dom.replaceChildren=function(node,_211){
dojo.dom.removeChildren(node);
node.appendChild(_211);
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_214,_215){
var _216=[];
var _217=(_214&&(_214 instanceof Function||typeof _214=="function"));
while(node){
if(!_217||_214(node)){
_216.push(node);
}
if(_215&&_216.length>0){
return _216[0];
}
node=node.parentNode;
}
if(_215){
return null;
}
return _216;
};
dojo.dom.getAncestorsByTag=function(node,tag,_21a){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_21a);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_21f,_220){
if(_220&&node){
node=node.parentNode;
}
while(node){
if(node==_21f){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _223=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _224=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_224.length;i++){
try{
doc=new ActiveXObject(_224[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_223.implementation)&&(_223.implementation.createDocument)){
doc=_223.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_227){
if(!_227){
_227="text/xml";
}
if(!dj_undef("DOMParser")){
var _228=new DOMParser();
return _228.parseFromString(str,_227);
}else{
if(!dj_undef("ActiveXObject")){
var _229=dojo.dom.createDocument();
if(_229){
_229.async=false;
_229.loadXML(str);
return _229;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _22a=dojo.doc();
if(_22a.createElement){
var tmp=_22a.createElement("xml");
tmp.innerHTML=str;
if(_22a.implementation&&_22a.implementation.createDocument){
var _22c=_22a.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_22c.importNode(tmp.childNodes.item(i),true);
}
return _22c;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_22f){
if(_22f.firstChild){
_22f.insertBefore(node,_22f.firstChild);
}else{
_22f.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_232){
if(_232!=true&&(node===ref||node.nextSibling===ref)){
return false;
}
var _233=ref.parentNode;
_233.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_236){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_236!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_236);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_23a){
if((!node)||(!ref)||(!_23a)){
return false;
}
switch(_23a.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_23c,_23d){
var _23e=_23c.childNodes;
if(!_23e.length){
_23c.appendChild(node);
return true;
}
var _23f=null;
for(var i=0;i<_23e.length;i++){
var _241=_23e.item(i)["getAttribute"]?parseInt(_23e.item(i).getAttribute("dojoinsertionindex")):-1;
if(_241<_23d){
_23f=_23e.item(i);
}
}
if(_23f){
return dojo.dom.insertAfter(node,_23f);
}else{
return dojo.dom.insertBefore(node,_23e.item(0));
}
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _244=dojo.doc();
dojo.dom.replaceChildren(node,_244.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _245="";
if(node==null){
return _245;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_245+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_245+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _245;
}
};
dojo.dom.hasParent=function(node){
return node&&node.parentNode&&dojo.dom.isNode(node.parentNode);
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_24b,_24c,_24d){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_24b,_24c,_24d);
}else{
var _24e=elem.ownerDocument;
var _24f=_24e.createNode(2,_24c,_24b);
_24f.nodeValue=_24d;
elem.setAttributeNode(_24f);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:window.location.href,initialHash:window.location.hash,moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _254=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_256){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_254.apply(this,[_256]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _257=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_259){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_257){
_257.apply(this,[_259]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_25c){
if(!dojo.render.html.opera){
var _25d=this._getUrlQuery(_25c.href);
if(_25d==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_25d==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_25d==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _25e=this.historyStack.pop();
if(!_25e){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_25e);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _265=url.split("?");
if(_265.length<2){
return null;
}else{
return _265[1];
}
},_loadIframeHistory:function(){
var url=dojo.hostenv.getBaseScriptUri()+"iframe_history.html?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
dojo.io.checkChildrenForFile=function(node){
var _268=false;
var _269=node.getElementsByTagName("input");
dojo.lang.forEach(_269,function(_26a){
if(_268){
return;
}
if(_26a.getAttribute("type")=="file"){
_268=true;
}
});
return _268;
};
dojo.io.formHasFile=function(_26b){
return dojo.io.checkChildrenForFile(_26b);
};
dojo.io.updateNode=function(node,_26d){
node=dojo.byId(node);
var args=_26d;
if(dojo.lang.isString(_26d)){
args={url:_26d};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
if(dojo["event"]){
try{
dojo.event.browser.clean(node.firstChild);
}
catch(e){
}
}
node.removeChild(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_274,_275,_276){
if((!_274)||(!_274.tagName)||(!_274.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_276){
_276=dojo.io.formFilter;
}
var enc=/utf/i.test(_275||"")?encodeURIComponent:dojo.string.encodeAscii;
var _278=[];
for(var i=0;i<_274.elements.length;i++){
var elm=_274.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_276(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_278.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_278.push(name+"="+enc(elm.value));
}
}else{
_278.push(name+"="+enc(elm.value));
}
}
}
var _27e=_274.getElementsByTagName("input");
for(var i=0;i<_27e.length;i++){
var _27f=_27e[i];
if(_27f.type.toLowerCase()=="image"&&_27f.form==_274&&_276(_27f)){
var name=enc(_27f.name);
_278.push(name+"="+enc(_27f.value));
_278.push(name+".x=0");
_278.push(name+".y=0");
}
}
return _278.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _285=form.getElementsByTagName("input");
for(var i=0;i<_285.length;i++){
var _286=_285[i];
if(_286.type.toLowerCase()=="image"&&_286.form==form){
this.connect(_286,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _28d=false;
if(node.disabled||!node.name){
_28d=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_28d=node==this.clickedButton;
}else{
_28d=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _28d;
},connect:function(_28e,_28f,_290){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_28e,_28f,this,_290);
}else{
var fcn=dojo.lang.hitch(this,_290);
_28e[_28f]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _293=this;
var _294={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_296,_297){
return url+"|"+_296+"|"+_297.toLowerCase();
}
function addToCache(url,_299,_29a,http){
_294[getCacheKey(url,_299,_29a)]=http;
}
function getFromCache(url,_29d,_29e){
return _294[getCacheKey(url,_29d,_29e)];
}
this.clearCache=function(){
_294={};
};
function doLoad(_29f,http,url,_2a2,_2a3){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_29f.method.toLowerCase()=="head"){
var _2a5=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _2a5;
};
var _2a6=_2a5.split(/[\r\n]+/g);
for(var i=0;i<_2a6.length;i++){
var pair=_2a6[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_29f.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_29f.mimetype=="text/json"||_29f.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_29f.mimetype=="application/xml")||(_29f.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_2a3){
addToCache(url,_2a2,_29f.method,http);
}
_29f[(typeof _29f.load=="function")?"load":"handle"]("load",ret,http,_29f);
}else{
var _2a9=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_29f[(typeof _29f.error=="function")?"error":"handle"]("error",_2a9,http,_29f);
}
}
function setHeaders(http,_2ab){
if(_2ab["headers"]){
for(var _2ac in _2ab["headers"]){
if(_2ac.toLowerCase()=="content-type"&&!_2ab["contentType"]){
_2ab["contentType"]=_2ab["headers"][_2ac];
}else{
http.setRequestHeader(_2ac,_2ab["headers"][_2ac]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_293._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _2b0=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_2b0,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _2b1=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_2b2){
return _2b1&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_2b2["mimetype"].toLowerCase()||""))&&!(_2b2["formNode"]&&dojo.io.formHasFile(_2b2["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_2b3){
if(!_2b3["url"]){
if(!_2b3["formNode"]&&(_2b3["backButton"]||_2b3["back"]||_2b3["changeUrl"]||_2b3["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_2b3);
return true;
}
}
var url=_2b3.url;
var _2b5="";
if(_2b3["formNode"]){
var ta=_2b3.formNode.getAttribute("action");
if((ta)&&(!_2b3["url"])){
url=ta;
}
var tp=_2b3.formNode.getAttribute("method");
if((tp)&&(!_2b3["method"])){
_2b3.method=tp;
}
_2b5+=dojo.io.encodeForm(_2b3.formNode,_2b3.encoding,_2b3["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_2b3["file"]){
_2b3.method="post";
}
if(!_2b3["method"]){
_2b3.method="get";
}
if(_2b3.method.toLowerCase()=="get"){
_2b3.multipart=false;
}else{
if(_2b3["file"]){
_2b3.multipart=true;
}else{
if(!_2b3["multipart"]){
_2b3.multipart=false;
}
}
}
if(_2b3["backButton"]||_2b3["back"]||_2b3["changeUrl"]){
dojo.undo.browser.addToHistory(_2b3);
}
var _2b8=_2b3["content"]||{};
if(_2b3.sendTransport){
_2b8["dojo.transport"]="xmlhttp";
}
do{
if(_2b3.postContent){
_2b5=_2b3.postContent;
break;
}
if(_2b8){
_2b5+=dojo.io.argsFromMap(_2b8,_2b3.encoding);
}
if(_2b3.method.toLowerCase()=="get"||!_2b3.multipart){
break;
}
var t=[];
if(_2b5.length){
var q=_2b5.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_2b3.file){
if(dojo.lang.isArray(_2b3.file)){
for(var i=0;i<_2b3.file.length;++i){
var o=_2b3.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_2b3.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_2b5=t.join("\r\n");
}
}while(false);
var _2be=_2b3["sync"]?false:true;
var _2bf=_2b3["preventCache"]||(this.preventCache==true&&_2b3["preventCache"]!=false);
var _2c0=_2b3["useCache"]==true||(this.useCache==true&&_2b3["useCache"]!=false);
if(!_2bf&&_2c0){
var _2c1=getFromCache(url,_2b5,_2b3.method);
if(_2c1){
doLoad(_2b3,_2c1,url,_2b5,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_2b3);
var _2c3=false;
if(_2be){
var _2c4=this.inFlight.push({"req":_2b3,"http":http,"url":url,"query":_2b5,"useCache":_2c0,"startTime":_2b3.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_293._blockAsync=true;
}
if(_2b3.method.toLowerCase()=="post"){
if(!_2b3.user){
http.open("POST",url,_2be);
}else{
http.open("POST",url,_2be,_2b3.user,_2b3.password);
}
setHeaders(http,_2b3);
http.setRequestHeader("Content-Type",_2b3.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_2b3.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_2b5);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b3,{status:404},url,_2b5,_2c0);
}
}else{
var _2c5=url;
if(_2b5!=""){
_2c5+=(_2c5.indexOf("?")>-1?"&":"?")+_2b5;
}
if(_2bf){
_2c5+=(dojo.string.endsWithAny(_2c5,"?","&")?"":(_2c5.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_2b3.user){
http.open(_2b3.method.toUpperCase(),_2c5,_2be);
}else{
http.open(_2b3.method.toUpperCase(),_2c5,_2be,_2b3.user,_2b3.password);
}
setHeaders(http,_2b3);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b3,{status:404},url,_2b5,_2c0);
}
}
if(!_2be){
doLoad(_2b3,http,url,_2b5,_2c0);
_293._blockAsync=false;
}
_2b3.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_2c7,days,path,_2ca,_2cb){
var _2cc=-1;
if(typeof days=="number"&&days>=0){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_2cc=d.toGMTString();
}
_2c7=escape(_2c7);
document.cookie=name+"="+_2c7+";"+(_2cc!=-1?" expires="+_2cc+";":"")+(path?"path="+path:"")+(_2ca?"; domain="+_2ca:"")+(_2cb?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _2d0=document.cookie.substring(idx+name.length+1);
var end=_2d0.indexOf(";");
if(end==-1){
end=_2d0.length;
}
_2d0=_2d0.substring(0,end);
_2d0=unescape(_2d0);
return _2d0;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_2d7,_2d8,_2d9){
if(arguments.length==5){
_2d9=_2d7;
_2d7=null;
_2d8=null;
}
var _2da=[],_2db,_2dc="";
if(!_2d9){
_2db=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_2db){
_2db={};
}
for(var prop in obj){
if(prop==null){
delete _2db[prop];
}else{
if(typeof obj[prop]=="string"||typeof obj[prop]=="number"){
_2db[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _2db){
_2da.push(escape(prop)+"="+escape(_2db[prop]));
}
_2dc=_2da.join("&");
}
dojo.io.cookie.setCookie(name,_2dc,days,path,_2d7,_2d8);
};
dojo.io.cookie.getObjectCookie=function(name){
var _2df=null,_2e0=dojo.io.cookie.getCookie(name);
if(_2e0){
_2df={};
var _2e1=_2e0.split("&");
for(var i=0;i<_2e1.length;i++){
var pair=_2e1[i].split("=");
var _2e4=pair[1];
if(isNaN(_2e4)){
_2e4=unescape(pair[1]);
}
_2df[unescape(pair[0])]=_2e4;
}
}
return _2df;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _2e5=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_2e5=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.provide("dojo.io.*");
dojo.provide("dojo.io");
dojo.deprecated("dojo.io","replaced by dojo.io.*","0.5");


__CPAN_EDITION__ browserio build.txt

Files baked into this package:

dojoGuardStart.js,
../src/bootstrap1.js,
../src/loader.js,
dojoGuardEnd.js,
../src/hostenv_browser.js,
../src/bootstrap2.js,
../src/string/common.js,
../src/string.js,
../src/lang/common.js,
../src/lang/extras.js,
../src/io/common.js,
../src/lang/array.js,
../src/lang/func.js,
../src/string/extras.js,
../src/dom.js,
../src/undo/browser.js,
../src/io/BrowserIO.js,
../src/io/cookie.js,
../src/io/__package__.js,
../src/io.js

		
__CPAN_EDITION__ core dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:0,flag:"",revision:Number("$Rev: 6258 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
return _6e?_6e.toLowerCase():dojo.locale;
};
dojo.hostenv.searchLocalePath=function(_6f,_70,_71){
_6f=dojo.hostenv.normalizeLocale(_6f);
var _72=_6f.split("-");
var _73=[];
for(var i=_72.length;i>0;i--){
_73.push(_72.slice(0,i).join("-"));
}
_73.push(false);
if(_70){
_73.reverse();
}
for(var j=_73.length-1;j>=0;j--){
var loc=_73[j]||"ROOT";
var _77=_71(loc);
if(_77){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_78){
_78=dojo.hostenv.normalizeLocale(_78);
dojo.hostenv.searchLocalePath(_78,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7b=djConfig.extraLocale||[];
for(var i=0;i<_7b.length;i++){
preload(_7b[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7d,_7e,_7f){
dojo.hostenv.preloadLocalizations();
var _80=[_7d,"nls",_7e].join(".");
var _81=dojo.hostenv.findModule(_80);
if(_81){
if(djConfig.localizationComplete&&_81._built){
return;
}
var _82=dojo.hostenv.normalizeLocale(_7f).replace("-","_");
var _83=_80+"."+_82;
if(dojo.hostenv.findModule(_83)){
return;
}
}
_81=dojo.hostenv.startPackage(_80);
var _84=dojo.hostenv.getModuleSymbols(_7d);
var _85=_84.concat("nls").join("/");
var _86;
dojo.hostenv.searchLocalePath(_7f,false,function(loc){
var _88=loc.replace("-","_");
var _89=_80+"."+_88;
var _8a=false;
if(!dojo.hostenv.findModule(_89)){
dojo.hostenv.startPackage(_89);
var _8b=[_85];
if(loc!="ROOT"){
_8b.push(loc);
}
_8b.push(_7e);
var _8c=_8b.join("/")+".js";
_8a=dojo.hostenv.loadPath(_8c,null,function(_8d){
var _8e=function(){
};
_8e.prototype=_86;
_81[_88]=new _8e();
for(var j in _8d){
_81[_88][j]=_8d[j];
}
});
}else{
_8a=true;
}
if(_8a&&_81[_88]){
_86=_81[_88];
}else{
_81[_88]=_86;
}
});
};
(function(){
var _90=djConfig.extraLocale;
if(_90){
if(!_90 instanceof Array){
_90=[_90];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_94){
req(m,b,_94);
if(_94){
return;
}
for(var i=0;i<_90.length;i++){
req(m,b,_90[i]);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _96=document.location.toString();
var _97=_96.split("?",2);
if(_97.length>1){
var _98=_97[1];
var _99=_98.split("&");
for(var x in _99){
var sp=_99[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _9d=document.getElementsByTagName("script");
var _9e=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_9d.length;i++){
var src=_9d[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_9e);
if(m){
var _a2=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_a2+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_a2;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_a2;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _aa=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_aa>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_aa+6,_aa+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _ac=window["document"];
var tdi=_ac["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b0=null;
var _b1=null;
try{
_b0=new XMLHttpRequest();
}
catch(e){
}
if(!_b0){
for(var i=0;i<3;++i){
var _b3=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b0=new ActiveXObject(_b3);
}
catch(e){
_b1=e;
}
if(_b0){
dojo.hostenv._XMLHTTP_PROGIDS=[_b3];
break;
}
}
}
if(!_b0){
return dojo.raise("XMLHTTP not available",_b1);
}
return _b0;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_b5,_b6){
if(!_b5){
this._blockAsync=true;
}
var _b7=this.getXmlhttpObject();
function isDocumentOk(_b8){
var _b9=_b8["status"];
return Boolean((!_b9)||((200<=_b9)&&(300>_b9))||(_b9==304));
}
if(_b5){
var _ba=this,_bb=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_b7.onreadystatechange=function(){
if(_bb){
gbl.clearTimeout(_bb);
_bb=null;
}
if(_ba._blockAsync||(xhr&&xhr._blockAsync)){
_bb=gbl.setTimeout(function(){
_b7.onreadystatechange.apply(this);
},10);
}else{
if(4==_b7.readyState){
if(isDocumentOk(_b7)){
_b5(_b7.responseText);
}
}
}
};
}
_b7.open("GET",uri,_b5?true:false);
try{
_b7.send(null);
if(_b5){
return null;
}
if(!isDocumentOk(_b7)){
var err=Error("Unable to load "+uri+" status:"+_b7.status);
err.status=_b7.status;
err.responseText=_b7.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_b6)&&(!_b5)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _b7.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_bf){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_bf);
}else{
try{
var _c0=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c0){
_c0=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_bf));
_c0.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_bf+"</div>");
}
catch(e2){
window.status=_bf;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_c2,_c3,fp,_c5){
var _c6=_c2["on"+_c3]||function(){
};
_c2["on"+_c3]=function(){
fp.apply(_c2,arguments);
_c6.apply(_c2,arguments);
};
return true;
}
function dj_load_init(e){
var _c8=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_c8!="domcontentloaded"&&_c8!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _c9=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_c9();
dojo.hostenv.modulesLoaded();
}else{
dojo.addOnLoad(_c9);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _cb=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_cb=_cb.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_cb=_cb.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_cb.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _cc=new dojo.xml.Parse();
if(_cb.length>0){
for(var x=0;x<_cb.length;x++){
var _ce=document.getElementById(_cb[x]);
if(!_ce){
continue;
}
var _cf=_cc.parseElement(_ce,null,true);
dojo.widget.getParser().createComponents(_cf);
}
}else{
if(djConfig.parseWidgets){
var _cf=_cc.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_cf);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_d4,_d5){
dj_currentContext=_d4;
dj_currentDocument=_d5;
};
dojo._fireCallback=function(_d6,_d7,_d8){
if((_d7)&&((typeof _d6=="string")||(_d6 instanceof String))){
_d6=_d7[_d6];
}
return (_d7?_d6.apply(_d7,_d8||[]):_d6());
};
dojo.withGlobal=function(_d9,_da,_db,_dc){
var _dd;
var _de=dj_currentContext;
var _df=dj_currentDocument;
try{
dojo.setContext(_d9,_d9.document);
_dd=dojo._fireCallback(_da,_db,_dc);
}
finally{
dojo.setContext(_de,_df);
}
return _dd;
};
dojo.withDoc=function(_e0,_e1,_e2,_e3){
var _e4;
var _e5=dj_currentDocument;
try{
dj_currentDocument=_e0;
_e4=dojo._fireCallback(_e1,_e2,_e3);
}
finally{
dj_currentDocument=_e5;
}
return _e4;
};
}
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _e6=false;
var _e7=false;
var _e8=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_e6=true;
}else{
if(typeof this["load"]=="function"){
_e7=true;
}else{
if(window.widget){
_e8=true;
}
}
}
var _e9=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_e9.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_e6)&&(!_e8)){
_e9.push("browser_debug.js");
}
var _ea=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_ea=djConfig["baseLoaderUri"];
}
for(var x=0;x<_e9.length;x++){
var _ec=_ea+"src/"+_e9[x];
if(_e6||_e7){
load(_ec);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_ec+"'></scr"+"ipt>");
}
catch(e){
var _ed=document.createElement("script");
_ed.src=_ec;
document.getElementsByTagName("head")[0].appendChild(_ed);
}
}
}
})();
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(typeof _ef!="function"){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
if(!it){
return false;
}
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction()&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.array");
dojo.lang.has=function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
};
dojo.lang.isEmpty=function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _117=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_117++;
break;
}
}
return _117==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
};
dojo.lang.map=function(arr,obj,_11b){
var _11c=dojo.lang.isString(arr);
if(_11c){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_11b)){
_11b=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_11b){
var _11d=obj;
obj=_11b;
_11b=_11d;
}
}
if(Array.map){
var _11e=Array.map(arr,_11b,obj);
}else{
var _11e=[];
for(var i=0;i<arr.length;++i){
_11e.push(_11b.call(obj,arr[i]));
}
}
if(_11c){
return _11e.join("");
}else{
return _11e;
}
};
dojo.lang.reduce=function(arr,_121,obj,_123){
var _124=_121;
var ob=obj?obj:dj_global;
dojo.lang.map(arr,function(val){
_124=_123.call(ob,_124,val);
});
return _124;
};
dojo.lang.forEach=function(_127,_128,_129){
if(dojo.lang.isString(_127)){
_127=_127.split("");
}
if(Array.forEach){
Array.forEach(_127,_128,_129);
}else{
if(!_129){
_129=dj_global;
}
for(var i=0,l=_127.length;i<l;i++){
_128.call(_129,_127[i],i,_127);
}
}
};
dojo.lang._everyOrSome=function(_12c,arr,_12e,_12f){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_12c?"every":"some"](arr,_12e,_12f);
}else{
if(!_12f){
_12f=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _132=_12e.call(_12f,arr[i],i,arr);
if(_12c&&!_132){
return false;
}else{
if((!_12c)&&(_132)){
return true;
}
}
}
return Boolean(_12c);
}
};
dojo.lang.every=function(arr,_134,_135){
return this._everyOrSome(true,arr,_134,_135);
};
dojo.lang.some=function(arr,_137,_138){
return this._everyOrSome(false,arr,_137,_138);
};
dojo.lang.filter=function(arr,_13a,_13b){
var _13c=dojo.lang.isString(arr);
if(_13c){
arr=arr.split("");
}
var _13d;
if(Array.filter){
_13d=Array.filter(arr,_13a,_13b);
}else{
if(!_13b){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_13b=dj_global;
}
_13d=[];
for(var i=0;i<arr.length;i++){
if(_13a.call(_13b,arr[i],i,arr)){
_13d.push(arr[i]);
}
}
}
if(_13c){
return _13d.join("");
}else{
return _13d;
}
};
dojo.lang.unnest=function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
};
dojo.lang.toArray=function(_142,_143){
var _144=[];
for(var i=_143||0;i<_142.length;i++){
_144.push(_142[i]);
}
return _144;
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_147){
var _148=window,_149=2;
if(!dojo.lang.isFunction(func)){
_148=func;
func=_147;
_147=arguments[2];
_149++;
}
if(dojo.lang.isString(func)){
func=_148[func];
}
var args=[];
for(var i=_149;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_148,args);
},_147);
};
dojo.lang.clearTimeout=function(_14c){
dojo.global().clearTimeout(_14c);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_155,_156,_157){
with(dojo.parseObjPath(_155,_156,_157)){
return dojo.evalProp(prop,obj,_157);
}
};
dojo.lang.setObjPathValue=function(_158,_159,_15a,_15b){
if(arguments.length<4){
_15b=true;
}
with(dojo.parseObjPath(_158,_15a,_15b)){
if(obj&&(_15b||(prop in obj))){
obj[prop]=_159;
}
}
};
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_15c,_15d,init,_15f){
if((dojo.lang.isFunction(_15f))||((!_15f)&&(!dojo.lang.isFunction(init)))){
var temp=_15f;
_15f=init;
init=temp;
}
var _161=[];
if(dojo.lang.isArray(_15d)){
_161=_15d;
_15d=_161.shift();
}
if(!init){
init=dojo.evalObjPath(_15c,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_15d?_15d.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _15d();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_161;
for(var i=0,l=_161.length;i<l;i++){
dojo.lang.extend(ctor,_161[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_15c;
if(dojo.lang.isArray(_15f)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_15f));
}else{
dojo.lang.extend(ctor,(_15f)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
dojo.lang.setObjPathValue(_15c,ctor,null,true);
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_16b,_16c,args){
var _16e,_16f=this.___proto;
this.___proto=_16b;
try{
_16e=_16b[_16c].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_16f;
}
return _16e;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_173,_174){
var fcn=(dojo.lang.isString(_174)?_173[_174]:_174)||function(){
};
return function(){
return fcn.apply(_173,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_176,_177,_178){
var nso=(_177||dojo.lang.anon);
if((_178)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_176){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_176;
return ret;
};
dojo.lang.forward=function(_17c){
return function(){
return this[_17c].apply(this,arguments);
};
};
dojo.lang.curry=function(ns,func){
var _17f=[];
ns=ns||dj_global;
if(dojo.lang.isString(func)){
func=ns[func];
}
for(var x=2;x<arguments.length;x++){
_17f.push(arguments[x]);
}
var _181=(func["__preJoinArity"]||func.length)-_17f.length;
function gather(_182,_183,_184){
var _185=_184;
var _186=_183.slice(0);
for(var x=0;x<_182.length;x++){
_186.push(_182[x]);
}
_184=_184-_182.length;
if(_184<=0){
var res=func.apply(ns,_186);
_184=_185;
return res;
}else{
return function(){
return gather(arguments,_186,_184);
};
}
}
return gather([],_17f,_181);
};
dojo.lang.curryArguments=function(ns,func,args,_18c){
var _18d=[];
var x=_18c||0;
for(x=_18c;x<args.length;x++){
_18d.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[ns,func].concat(_18d));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_193,_194){
if(!farr.length){
if(typeof _194=="function"){
_194();
}
return;
}
if((typeof _193=="undefined")&&(typeof cb=="number")){
_193=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_193){
_193=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_193,_194);
},_193);
};
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_196){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _199=dl.nameAnonFunc(args[2],ao.adviceObj,_196);
ao.adviceFunc=_199;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _199=dl.nameAnonFunc(args[0],ao.srcObj,_196);
ao.srcFunc=_199;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _199=dl.nameAnonFunc(args[1],dj_global,_196);
ao.srcFunc=_199;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _199=dl.nameAnonFunc(args[3],dj_global,_196);
ao.adviceObj=dj_global;
ao.adviceFunc=_199;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _199=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_196);
ao.aroundFunc=_199;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _19b={};
for(var x in ao){
_19b[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_19b.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_19b));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _1a3;
if((arguments.length==1)&&(typeof a1=="object")){
_1a3=a1;
}else{
_1a3={srcObj:a1,srcFunc:a2};
}
_1a3.adviceFunc=function(){
var _1a4=[];
for(var x=0;x<arguments.length;x++){
_1a4.push(arguments[x]);
}
dojo.debug("("+_1a3.srcObj+")."+_1a3.srcFunc,":",_1a4.join(", "));
};
this.kwConnect(_1a3);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this._kwConnectImpl=function(_1ab,_1ac){
var fn=(_1ac)?"disconnect":"connect";
if(typeof _1ab["srcFunc"]=="function"){
_1ab.srcObj=_1ab["srcObj"]||dj_global;
var _1ae=dojo.lang.nameAnonFunc(_1ab.srcFunc,_1ab.srcObj,true);
_1ab.srcFunc=_1ae;
}
if(typeof _1ab["adviceFunc"]=="function"){
_1ab.adviceObj=_1ab["adviceObj"]||dj_global;
var _1ae=dojo.lang.nameAnonFunc(_1ab.adviceFunc,_1ab.adviceObj,true);
_1ab.adviceFunc=_1ae;
}
_1ab.srcObj=_1ab["srcObj"]||dj_global;
_1ab.adviceObj=_1ab["adviceObj"]||_1ab["targetObj"]||dj_global;
_1ab.adviceFunc=_1ab["adviceFunc"]||_1ab["targetFunc"];
return dojo.event[fn](_1ab);
};
this.kwConnect=function(_1af){
return this._kwConnectImpl(_1af,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
return mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
};
this.kwDisconnect=function(_1b2){
return this._kwConnectImpl(_1b2,true);
};
};
dojo.event.MethodInvocation=function(_1b3,obj,args){
this.jp_=_1b3;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_1bb){
this.object=obj||dj_global;
this.methodname=_1bb;
this.methodfunc=this.object[_1bb];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_1bd){
if(!obj){
obj=dj_global;
}
if(!obj[_1bd]){
obj[_1bd]=function(){
};
if(!obj[_1bd]){
dojo.raise("Cannot set do-nothing method on that object "+_1bd);
}
}else{
if((!dojo.lang.isFunction(obj[_1bd]))&&(!dojo.lang.isAlien(obj[_1bd]))){
return null;
}
}
var _1be=_1bd+"$joinpoint";
var _1bf=_1bd+"$joinpoint$method";
var _1c0=obj[_1be];
if(!_1c0){
var _1c1=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_1c1=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_1be,_1bf,_1bd]);
}
}
var _1c2=obj[_1bd].length;
obj[_1bf]=obj[_1bd];
_1c0=obj[_1be]=new dojo.event.MethodJoinPoint(obj,_1bf);
obj[_1bd]=function(){
var args=[];
if((_1c1)&&(!arguments.length)){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(_1c1)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _1c0.run.apply(_1c0,args);
};
obj[_1bd].__preJoinArity=_1c2;
}
return _1c0;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _1c8=[];
for(var x=0;x<args.length;x++){
_1c8[x]=args[x];
}
var _1ca=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _1cc=marr[0]||dj_global;
var _1cd=marr[1];
if(!_1cc[_1cd]){
dojo.raise("function \""+_1cd+"\" does not exist on \""+_1cc+"\"");
}
var _1ce=marr[2]||dj_global;
var _1cf=marr[3];
var msg=marr[6];
var _1d1;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _1cc[_1cd].apply(_1cc,to.args);
}};
to.args=_1c8;
var _1d3=parseInt(marr[4]);
var _1d4=((!isNaN(_1d3))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _1d7=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_1ca(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_1cf){
_1ce[_1cf].call(_1ce,to);
}else{
if((_1d4)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_1cc[_1cd].call(_1cc,to);
}else{
_1cc[_1cd].apply(_1cc,args);
}
},_1d3);
}else{
if(msg){
_1cc[_1cd].call(_1cc,to);
}else{
_1cc[_1cd].apply(_1cc,args);
}
}
}
};
var _1da=function(){
if(this.squelch){
try{
return _1ca.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _1ca.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_1da);
}
var _1db;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_1db=mi.proceed();
}else{
if(this.methodfunc){
_1db=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_1da);
}
return (this.methodfunc)?_1db:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"]);
},addAdvice:function(_1e0,_1e1,_1e2,_1e3,_1e4,_1e5,once,_1e7,rate,_1e9){
var arr=this.getArr(_1e4);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_1e0,_1e1,_1e2,_1e3,_1e7,rate,_1e9];
if(once){
if(this.hasAdvice(_1e0,_1e1,_1e4,arr)>=0){
return;
}
}
if(_1e5=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_1ec,_1ed,_1ee,arr){
if(!arr){
arr=this.getArr(_1ee);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _1ed=="object")?(new String(_1ed)).toString():_1ed;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_1ec)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_1f4,_1f5,_1f6,once){
var arr=this.getArr(_1f6);
var ind=this.hasAdvice(_1f4,_1f5,_1f6,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_1f4,_1f5,_1f6,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_1fa){
if(!this.topics[_1fa]){
this.topics[_1fa]=new this.TopicImpl(_1fa);
}
return this.topics[_1fa];
};
this.registerPublisher=function(_1fb,obj,_1fd){
var _1fb=this.getTopic(_1fb);
_1fb.registerPublisher(obj,_1fd);
};
this.subscribe=function(_1fe,obj,_200){
var _1fe=this.getTopic(_1fe);
_1fe.subscribe(obj,_200);
};
this.unsubscribe=function(_201,obj,_203){
var _201=this.getTopic(_201);
_201.unsubscribe(obj,_203);
};
this.destroy=function(_204){
this.getTopic(_204).destroy();
delete this.topics[_204];
};
this.publishApply=function(_205,args){
var _205=this.getTopic(_205);
_205.sendMessage.apply(_205,args);
};
this.publish=function(_207,_208){
var _207=this.getTopic(_207);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_207.sendMessage.apply(_207,args);
};
};
dojo.event.topic.TopicImpl=function(_20b){
this.topicName=_20b;
this.subscribe=function(_20c,_20d){
var tf=_20d||_20c;
var to=(!_20d)?dj_global:_20c;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_210,_211){
var tf=(!_211)?_210:_211;
var to=(!_211)?null:_210;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_214){
this._getJoinPoint().squelch=_214;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_215,_216){
dojo.event.connect(_215,_216,this,"sendMessage");
};
this.sendMessage=function(_217){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_21a){
var na;
var tna;
if(_21a){
tna=_21a.all||_21a.getElementsByTagName("*");
na=[_21a];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _21e={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _222=0;
this.normalizedEventName=function(_223){
switch(_223){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _223;
break;
default:
return _223.toLowerCase();
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_227){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_227.length;x++){
node.__clobberAttrs__.push(_227[x]);
}
};
this.removeListener=function(node,_22a,fp,_22c){
if(!_22c){
var _22c=false;
}
_22a=dojo.event.browser.normalizedEventName(_22a);
if((_22a=="onkey")||(_22a=="key")){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_22c);
}
_22a="onkeypress";
}
if(_22a.substr(0,2)=="on"){
_22a=_22a.substr(2);
}
if(node.removeEventListener){
node.removeEventListener(_22a,fp,_22c);
}
};
this.addListener=function(node,_22e,fp,_230,_231){
if(!node){
return;
}
if(!_230){
var _230=false;
}
_22e=dojo.event.browser.normalizedEventName(_22e);
if((_22e=="onkey")||(_22e=="key")){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_230,_231);
}
_22e="onkeypress";
}
if(_22e.substr(0,2)!="on"){
_22e="on"+_22e;
}
if(!_231){
var _232=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_230){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_232=fp;
}
if(node.addEventListener){
node.addEventListener(_22e.substr(2),_232,_230);
return _232;
}else{
if(typeof node[_22e]=="function"){
var _235=node[_22e];
node[_22e]=function(e){
_235(e);
return _232(e);
};
}else{
node[_22e]=_232;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_22e]);
}
return _232;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_238,_239){
if(typeof _238!="function"){
dojo.raise("listener not a function: "+_238);
}
dojo.event.browser.currentEvent.currentTarget=_239;
return _238.call(_239,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_23c){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _23e=evt.keyCode;
if(_23e>=65&&_23e<=90&&evt.shiftKey==false){
_23e+=32;
}
if(_23e>=1&&_23e<=26&&evt.ctrlKey){
_23e+=96;
}
evt.key=String.fromCharCode(_23e);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _23e=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_23e+=32;
}
evt.key=String.fromCharCode(_23e);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
default:
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_23c?_23c:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _240=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_240.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_240.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.returnValue=false;
evt.cancelBubble=true;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.provide("dojo.event.*");
dojo.provide("dojo.event");
dojo.deprecated("dojo.event","replaced by dojo.event.*","0.5");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_248,_249){
var out="";
for(var i=0;i<_248;i++){
out+=str;
if(_249&&i<_248-1){
out+=_249;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_257,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _257.replace(/\%\{(\w+)\}/g,function(_25a,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _25d=str.split(" ");
for(var i=0;i<_25d.length;i++){
_25d[i]=_25d[i].charAt(0).toUpperCase()+_25d[i].substring(1);
}
return _25d.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _262=escape(str);
var _263,re=/%u([0-9A-F]{4})/i;
while((_263=_262.match(re))){
var num=Number("0x"+_263[1]);
var _266=escape("&#"+num+";");
ret+=_262.substring(0,_263.index)+_266;
_262=_262.substring(_263.index+_263[0].length);
}
ret+=_262.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_26b){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_26b){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_274){
if(_274){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_278,_279){
if(_279){
str=str.toLowerCase();
_278=_278.toLowerCase();
}
return str.indexOf(_278)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_27f){
if(_27f=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_27f=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_281){
var _282=[];
for(var i=0,_284=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_281){
_282.push(str.substring(_284,i));
_284=i+1;
}
}
_282.push(str.substr(_284));
return _282;
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_286,_287,_288){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_286){
this.mimetype=_286;
}
if(_287){
this.transport=_287;
}
if(arguments.length>=4){
this.changeUrl=_288;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_28b,_28c){
},error:function(type,_28e,_28f,_290){
},timeout:function(type,_292,_293,_294){
},handle:function(type,data,_297,_298){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_299){
if(_299["url"]){
_299.url=_299.url.toString();
}
if(_299["formNode"]){
_299.formNode=dojo.byId(_299.formNode);
}
if(!_299["method"]&&_299["formNode"]&&_299["formNode"].method){
_299.method=_299["formNode"].method;
}
if(!_299["handle"]&&_299["handler"]){
_299.handle=_299.handler;
}
if(!_299["load"]&&_299["loaded"]){
_299.load=_299.loaded;
}
if(!_299["changeUrl"]&&_299["changeURL"]){
_299.changeUrl=_299.changeURL;
}
_299.encoding=dojo.lang.firstValued(_299["encoding"],djConfig["bindEncoding"],"");
_299.sendTransport=dojo.lang.firstValued(_299["sendTransport"],djConfig["ioSendTransport"],false);
var _29a=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_299[fn]&&_29a(_299[fn])){
continue;
}
if(_299["handle"]&&_29a(_299["handle"])){
_299[fn]=_299.handle;
}
}
dojo.lang.mixin(this,_299);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_2a1){
if(!(_2a1 instanceof dojo.io.Request)){
try{
_2a1=new dojo.io.Request(_2a1);
}
catch(e){
dojo.debug(e);
}
}
var _2a2="";
if(_2a1["transport"]){
_2a2=_2a1["transport"];
if(!this[_2a2]){
dojo.io.sendBindError(_2a1,"No dojo.io.bind() transport with name '"+_2a1["transport"]+"'.");
return _2a1;
}
if(!this[_2a2].canHandle(_2a1)){
dojo.io.sendBindError(_2a1,"dojo.io.bind() transport with name '"+_2a1["transport"]+"' cannot handle this type of request.");
return _2a1;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_2a1))){
_2a2=tmp;
break;
}
}
if(_2a2==""){
dojo.io.sendBindError(_2a1,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _2a1;
}
}
this[_2a2].bind(_2a1);
_2a1.bindSuccess=true;
return _2a1;
};
dojo.io.sendBindError=function(_2a5,_2a6){
if((typeof _2a5.error=="function"||typeof _2a5.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _2a7=new dojo.io.Error(_2a6);
setTimeout(function(){
_2a5[(typeof _2a5.error=="function")?"error":"handle"]("error",_2a7,null,_2a5);
},50);
}else{
dojo.raise(_2a6);
}
};
dojo.io.queueBind=function(_2a8){
if(!(_2a8 instanceof dojo.io.Request)){
try{
_2a8=new dojo.io.Request(_2a8);
}
catch(e){
dojo.debug(e);
}
}
var _2a9=_2a8.load;
_2a8.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_2a9.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _2ab=_2a8.error;
_2a8.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_2ab.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_2a8);
dojo.io._dispatchNextQueueBind();
return _2a8;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_2ae,last){
var enc=/utf/i.test(_2ae||"")?encodeURIComponent:dojo.string.encodeAscii;
var _2b1=[];
var _2b2=new Object();
for(var name in map){
var _2b4=function(elt){
var val=enc(name)+"="+enc(elt);
_2b1[(last==name)?"push":"unshift"](val);
};
if(!_2b2[name]){
var _2b7=map[name];
if(dojo.lang.isArray(_2b7)){
dojo.lang.forEach(_2b7,_2b4);
}else{
_2b4(_2b7);
}
}
}
return _2b1.join("&");
};
dojo.io.setIFrameSrc=function(_2b8,src,_2ba){
try{
var r=dojo.render.html;
if(!_2ba){
if(r.safari){
_2b8.location=src;
}else{
frames[_2b8.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_2b8.contentWindow.document;
}else{
if(r.safari){
idoc=_2b8.document;
}else{
idoc=_2b8.contentWindow;
}
}
if(!idoc){
_2b8.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(E){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _2be=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_2be.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_2c0,_2c1){
var node=_2c0.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_2c1&&node&&node.tagName&&node.tagName.toLowerCase()!=_2c1.toLowerCase()){
node=dojo.dom.nextElement(node,_2c1);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_2c3,_2c4){
var node=_2c3.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_2c4&&node&&node.tagName&&node.tagName.toLowerCase()!=_2c4.toLowerCase()){
node=dojo.dom.prevElement(node,_2c4);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_2c7){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_2c7&&_2c7.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_2c7);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_2c9){
if(!node){
return null;
}
if(_2c9){
_2c9=_2c9.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_2c9&&_2c9.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_2c9);
}
return node;
};
dojo.dom.moveChildren=function(_2ca,_2cb,trim){
var _2cd=0;
if(trim){
while(_2ca.hasChildNodes()&&_2ca.firstChild.nodeType==dojo.dom.TEXT_NODE){
_2ca.removeChild(_2ca.firstChild);
}
while(_2ca.hasChildNodes()&&_2ca.lastChild.nodeType==dojo.dom.TEXT_NODE){
_2ca.removeChild(_2ca.lastChild);
}
}
while(_2ca.hasChildNodes()){
_2cb.appendChild(_2ca.firstChild);
_2cd++;
}
return _2cd;
};
dojo.dom.copyChildren=function(_2ce,_2cf,trim){
var _2d1=_2ce.cloneNode(true);
return this.moveChildren(_2d1,_2cf,trim);
};
dojo.dom.removeChildren=function(node){
var _2d3=node.childNodes.length;
while(node.hasChildNodes()){
node.removeChild(node.firstChild);
}
return _2d3;
};
dojo.dom.replaceChildren=function(node,_2d5){
dojo.dom.removeChildren(node);
node.appendChild(_2d5);
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_2d8,_2d9){
var _2da=[];
var _2db=(_2d8&&(_2d8 instanceof Function||typeof _2d8=="function"));
while(node){
if(!_2db||_2d8(node)){
_2da.push(node);
}
if(_2d9&&_2da.length>0){
return _2da[0];
}
node=node.parentNode;
}
if(_2d9){
return null;
}
return _2da;
};
dojo.dom.getAncestorsByTag=function(node,tag,_2de){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_2de);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_2e3,_2e4){
if(_2e4&&node){
node=node.parentNode;
}
while(node){
if(node==_2e3){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _2e7=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _2e8=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_2e8.length;i++){
try{
doc=new ActiveXObject(_2e8[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_2e7.implementation)&&(_2e7.implementation.createDocument)){
doc=_2e7.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_2eb){
if(!_2eb){
_2eb="text/xml";
}
if(!dj_undef("DOMParser")){
var _2ec=new DOMParser();
return _2ec.parseFromString(str,_2eb);
}else{
if(!dj_undef("ActiveXObject")){
var _2ed=dojo.dom.createDocument();
if(_2ed){
_2ed.async=false;
_2ed.loadXML(str);
return _2ed;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _2ee=dojo.doc();
if(_2ee.createElement){
var tmp=_2ee.createElement("xml");
tmp.innerHTML=str;
if(_2ee.implementation&&_2ee.implementation.createDocument){
var _2f0=_2ee.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_2f0.importNode(tmp.childNodes.item(i),true);
}
return _2f0;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_2f3){
if(_2f3.firstChild){
_2f3.insertBefore(node,_2f3.firstChild);
}else{
_2f3.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_2f6){
if(_2f6!=true&&(node===ref||node.nextSibling===ref)){
return false;
}
var _2f7=ref.parentNode;
_2f7.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_2fa){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_2fa!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_2fa);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_2fe){
if((!node)||(!ref)||(!_2fe)){
return false;
}
switch(_2fe.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_300,_301){
var _302=_300.childNodes;
if(!_302.length){
_300.appendChild(node);
return true;
}
var _303=null;
for(var i=0;i<_302.length;i++){
var _305=_302.item(i)["getAttribute"]?parseInt(_302.item(i).getAttribute("dojoinsertionindex")):-1;
if(_305<_301){
_303=_302.item(i);
}
}
if(_303){
return dojo.dom.insertAfter(node,_303);
}else{
return dojo.dom.insertBefore(node,_302.item(0));
}
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _308=dojo.doc();
dojo.dom.replaceChildren(node,_308.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _309="";
if(node==null){
return _309;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_309+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_309+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _309;
}
};
dojo.dom.hasParent=function(node){
return node&&node.parentNode&&dojo.dom.isNode(node.parentNode);
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_30f,_310,_311){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_30f,_310,_311);
}else{
var _312=elem.ownerDocument;
var _313=_312.createNode(2,_310,_30f);
_313.nodeValue=_311;
elem.setAttributeNode(_313);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:window.location.href,initialHash:window.location.hash,moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _318=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_31a){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_318.apply(this,[_31a]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _31b=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_31d){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_31b){
_31b.apply(this,[_31d]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_320){
if(!dojo.render.html.opera){
var _321=this._getUrlQuery(_320.href);
if(_321==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_321==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_321==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _322=this.historyStack.pop();
if(!_322){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_322);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _329=url.split("?");
if(_329.length<2){
return null;
}else{
return _329[1];
}
},_loadIframeHistory:function(){
var url=dojo.hostenv.getBaseScriptUri()+"iframe_history.html?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
dojo.io.checkChildrenForFile=function(node){
var _32c=false;
var _32d=node.getElementsByTagName("input");
dojo.lang.forEach(_32d,function(_32e){
if(_32c){
return;
}
if(_32e.getAttribute("type")=="file"){
_32c=true;
}
});
return _32c;
};
dojo.io.formHasFile=function(_32f){
return dojo.io.checkChildrenForFile(_32f);
};
dojo.io.updateNode=function(node,_331){
node=dojo.byId(node);
var args=_331;
if(dojo.lang.isString(_331)){
args={url:_331};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
if(dojo["event"]){
try{
dojo.event.browser.clean(node.firstChild);
}
catch(e){
}
}
node.removeChild(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_338,_339,_33a){
if((!_338)||(!_338.tagName)||(!_338.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_33a){
_33a=dojo.io.formFilter;
}
var enc=/utf/i.test(_339||"")?encodeURIComponent:dojo.string.encodeAscii;
var _33c=[];
for(var i=0;i<_338.elements.length;i++){
var elm=_338.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_33a(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_33c.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_33c.push(name+"="+enc(elm.value));
}
}else{
_33c.push(name+"="+enc(elm.value));
}
}
}
var _342=_338.getElementsByTagName("input");
for(var i=0;i<_342.length;i++){
var _343=_342[i];
if(_343.type.toLowerCase()=="image"&&_343.form==_338&&_33a(_343)){
var name=enc(_343.name);
_33c.push(name+"="+enc(_343.value));
_33c.push(name+".x=0");
_33c.push(name+".y=0");
}
}
return _33c.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _349=form.getElementsByTagName("input");
for(var i=0;i<_349.length;i++){
var _34a=_349[i];
if(_34a.type.toLowerCase()=="image"&&_34a.form==form){
this.connect(_34a,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _351=false;
if(node.disabled||!node.name){
_351=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_351=node==this.clickedButton;
}else{
_351=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _351;
},connect:function(_352,_353,_354){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_352,_353,this,_354);
}else{
var fcn=dojo.lang.hitch(this,_354);
_352[_353]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _357=this;
var _358={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_35a,_35b){
return url+"|"+_35a+"|"+_35b.toLowerCase();
}
function addToCache(url,_35d,_35e,http){
_358[getCacheKey(url,_35d,_35e)]=http;
}
function getFromCache(url,_361,_362){
return _358[getCacheKey(url,_361,_362)];
}
this.clearCache=function(){
_358={};
};
function doLoad(_363,http,url,_366,_367){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_363.method.toLowerCase()=="head"){
var _369=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _369;
};
var _36a=_369.split(/[\r\n]+/g);
for(var i=0;i<_36a.length;i++){
var pair=_36a[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_363.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_363.mimetype=="text/json"||_363.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_363.mimetype=="application/xml")||(_363.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_367){
addToCache(url,_366,_363.method,http);
}
_363[(typeof _363.load=="function")?"load":"handle"]("load",ret,http,_363);
}else{
var _36d=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_363[(typeof _363.error=="function")?"error":"handle"]("error",_36d,http,_363);
}
}
function setHeaders(http,_36f){
if(_36f["headers"]){
for(var _370 in _36f["headers"]){
if(_370.toLowerCase()=="content-type"&&!_36f["contentType"]){
_36f["contentType"]=_36f["headers"][_370];
}else{
http.setRequestHeader(_370,_36f["headers"][_370]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_357._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _374=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_374,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _375=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_376){
return _375&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_376["mimetype"].toLowerCase()||""))&&!(_376["formNode"]&&dojo.io.formHasFile(_376["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_377){
if(!_377["url"]){
if(!_377["formNode"]&&(_377["backButton"]||_377["back"]||_377["changeUrl"]||_377["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_377);
return true;
}
}
var url=_377.url;
var _379="";
if(_377["formNode"]){
var ta=_377.formNode.getAttribute("action");
if((ta)&&(!_377["url"])){
url=ta;
}
var tp=_377.formNode.getAttribute("method");
if((tp)&&(!_377["method"])){
_377.method=tp;
}
_379+=dojo.io.encodeForm(_377.formNode,_377.encoding,_377["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_377["file"]){
_377.method="post";
}
if(!_377["method"]){
_377.method="get";
}
if(_377.method.toLowerCase()=="get"){
_377.multipart=false;
}else{
if(_377["file"]){
_377.multipart=true;
}else{
if(!_377["multipart"]){
_377.multipart=false;
}
}
}
if(_377["backButton"]||_377["back"]||_377["changeUrl"]){
dojo.undo.browser.addToHistory(_377);
}
var _37c=_377["content"]||{};
if(_377.sendTransport){
_37c["dojo.transport"]="xmlhttp";
}
do{
if(_377.postContent){
_379=_377.postContent;
break;
}
if(_37c){
_379+=dojo.io.argsFromMap(_37c,_377.encoding);
}
if(_377.method.toLowerCase()=="get"||!_377.multipart){
break;
}
var t=[];
if(_379.length){
var q=_379.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_377.file){
if(dojo.lang.isArray(_377.file)){
for(var i=0;i<_377.file.length;++i){
var o=_377.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_377.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_379=t.join("\r\n");
}
}while(false);
var _382=_377["sync"]?false:true;
var _383=_377["preventCache"]||(this.preventCache==true&&_377["preventCache"]!=false);
var _384=_377["useCache"]==true||(this.useCache==true&&_377["useCache"]!=false);
if(!_383&&_384){
var _385=getFromCache(url,_379,_377.method);
if(_385){
doLoad(_377,_385,url,_379,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_377);
var _387=false;
if(_382){
var _388=this.inFlight.push({"req":_377,"http":http,"url":url,"query":_379,"useCache":_384,"startTime":_377.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_357._blockAsync=true;
}
if(_377.method.toLowerCase()=="post"){
if(!_377.user){
http.open("POST",url,_382);
}else{
http.open("POST",url,_382,_377.user,_377.password);
}
setHeaders(http,_377);
http.setRequestHeader("Content-Type",_377.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_377.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_379);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_377,{status:404},url,_379,_384);
}
}else{
var _389=url;
if(_379!=""){
_389+=(_389.indexOf("?")>-1?"&":"?")+_379;
}
if(_383){
_389+=(dojo.string.endsWithAny(_389,"?","&")?"":(_389.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_377.user){
http.open(_377.method.toUpperCase(),_389,_382);
}else{
http.open(_377.method.toUpperCase(),_389,_382,_377.user,_377.password);
}
setHeaders(http,_377);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_377,{status:404},url,_379,_384);
}
}
if(!_382){
doLoad(_377,http,url,_379,_384);
_357._blockAsync=false;
}
_377.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_38b,days,path,_38e,_38f){
var _390=-1;
if(typeof days=="number"&&days>=0){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_390=d.toGMTString();
}
_38b=escape(_38b);
document.cookie=name+"="+_38b+";"+(_390!=-1?" expires="+_390+";":"")+(path?"path="+path:"")+(_38e?"; domain="+_38e:"")+(_38f?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _394=document.cookie.substring(idx+name.length+1);
var end=_394.indexOf(";");
if(end==-1){
end=_394.length;
}
_394=_394.substring(0,end);
_394=unescape(_394);
return _394;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_39b,_39c,_39d){
if(arguments.length==5){
_39d=_39b;
_39b=null;
_39c=null;
}
var _39e=[],_39f,_3a0="";
if(!_39d){
_39f=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_39f){
_39f={};
}
for(var prop in obj){
if(prop==null){
delete _39f[prop];
}else{
if(typeof obj[prop]=="string"||typeof obj[prop]=="number"){
_39f[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _39f){
_39e.push(escape(prop)+"="+escape(_39f[prop]));
}
_3a0=_39e.join("&");
}
dojo.io.cookie.setCookie(name,_3a0,days,path,_39b,_39c);
};
dojo.io.cookie.getObjectCookie=function(name){
var _3a3=null,_3a4=dojo.io.cookie.getCookie(name);
if(_3a4){
_3a3={};
var _3a5=_3a4.split("&");
for(var i=0;i<_3a5.length;i++){
var pair=_3a5[i].split("=");
var _3a8=pair[1];
if(isNaN(_3a8)){
_3a8=unescape(pair[1]);
}
_3a3[unescape(pair[0])]=_3a8;
}
}
return _3a3;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _3a9=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_3a9=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.provide("dojo.io.*");
dojo.provide("dojo.io");
dojo.deprecated("dojo.io","replaced by dojo.io.*","0.5");
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_3aa){
this.pairs=[];
this.returnWrappers=_3aa||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_3ac,wrap,_3ae,_3af){
var type=(_3af)?"unshift":"push";
this.pairs[type]([name,_3ac,wrap,_3ae]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.json");
dojo.json={jsonRegistry:new dojo.AdapterRegistry(),register:function(name,_3b7,wrap,_3b9){
dojo.json.jsonRegistry.register(name,_3b7,wrap,_3b9);
},evalJson:function(json){
try{
return eval("("+json+")");
}
catch(e){
dojo.debug(e);
return json;
}
},serialize:function(o){
var _3bc=typeof (o);
if(_3bc=="undefined"){
return "undefined";
}else{
if((_3bc=="number")||(_3bc=="boolean")){
return o+"";
}else{
if(o===null){
return "null";
}
}
}
if(_3bc=="string"){
return dojo.string.escapeString(o);
}
var me=arguments.callee;
var _3be;
if(typeof (o.__json__)=="function"){
_3be=o.__json__();
if(o!==_3be){
return me(_3be);
}
}
if(typeof (o.json)=="function"){
_3be=o.json();
if(o!==_3be){
return me(_3be);
}
}
if(_3bc!="function"&&typeof (o.length)=="number"){
var res=[];
for(var i=0;i<o.length;i++){
var val=me(o[i]);
if(typeof (val)!="string"){
val="undefined";
}
res.push(val);
}
return "["+res.join(",")+"]";
}
try{
window.o=o;
_3be=dojo.json.jsonRegistry.match(o);
return me(_3be);
}
catch(e){
}
if(_3bc=="function"){
return null;
}
res=[];
for(var k in o){
var _3c3;
if(typeof (k)=="number"){
_3c3="\""+k+"\"";
}else{
if(typeof (k)=="string"){
_3c3=dojo.string.escapeString(k);
}else{
continue;
}
}
val=me(o[k]);
if(typeof (val)!="string"){
continue;
}
res.push(_3c3+":"+val);
}
return "{"+res.join(",")+"}";
}};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _3c6=dojo.global();
var _3c7=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_3c7.documentElement.clientWidth;
h=_3c6.innerHeight;
}else{
if(!dojo.render.html.opera&&_3c6.innerWidth){
w=_3c6.innerWidth;
h=_3c6.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_3c7,"documentElement.clientWidth")){
var w2=_3c7.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_3c7.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _3cb=dojo.global();
var _3cc=dojo.doc();
var top=_3cb.pageYOffset||_3cc.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_3cb.pageXOffset||_3cc.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _3d1=dojo.doc();
var _3d2=dojo.byId(node);
type=type.toLowerCase();
while((_3d2)&&(_3d2.nodeName.toLowerCase()!=type)){
if(_3d2==(_3d1["body"]||_3d1["documentElement"])){
return null;
}
_3d2=_3d2.parentNode;
}
return _3d2;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _3da={x:0,y:0};
if(e.pageX||e.pageY){
_3da.x=e.pageX;
_3da.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_3da.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_3da.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _3da;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _3df=dojo.doc().createElement("script");
_3df.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_3df);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_3e2,_3e3,args,_3e5,_3e6){
dojo.deprecated("dojo.html."+_3e2,"replaced by dojo.html."+_3e3+"("+(_3e5?"node, {"+_3e5+": "+_3e5+"}":"")+")"+(_3e6?"."+_3e6:""),"0.5");
var _3e7=[];
if(_3e5){
var _3e8={};
_3e8[_3e5]=args[1];
_3e7.push(args[0]);
_3e7.push(_3e8);
}else{
_3e7=args;
}
var ret=dojo.html[_3e3].apply(dojo.html,args);
if(_3e6){
return ret[_3e6];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_3eb,uri){
var loc=dojo.hostenv.getModulePrefix(_3eb);
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri()+loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _3f0=new dojo.uri.Uri(arguments[i].toString());
var _3f1=new dojo.uri.Uri(uri.toString());
if((_3f0.path=="")&&(_3f0.scheme==null)&&(_3f0.authority==null)&&(_3f0.query==null)){
if(_3f0.fragment!=null){
_3f1.fragment=_3f0.fragment;
}
_3f0=_3f1;
}else{
if(_3f0.scheme==null){
_3f0.scheme=_3f1.scheme;
if(_3f0.authority==null){
_3f0.authority=_3f1.authority;
if(_3f0.path.charAt(0)!="/"){
var path=_3f1.path.substring(0,_3f1.path.lastIndexOf("/")+1)+_3f0.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_3f0.path=segs.join("/");
}
}
}
}
uri="";
if(_3f0.scheme!=null){
uri+=_3f0.scheme+":";
}
if(_3f0.authority!=null){
uri+="//"+_3f0.authority;
}
uri+=_3f0.path;
if(_3f0.query!=null){
uri+="?"+_3f0.query;
}
if(_3f0.fragment!=null){
uri+="#"+_3f0.fragment;
}
}
this.uri=uri.toString();
var _3f5="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_3f5));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_3f5="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_3f5));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_3fc){
return (new RegExp("(^|\\s+)"+_3fc+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_3fe){
_3fe+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_3fe);
};
dojo.html.addClass=function(node,_400){
if(dojo.html.hasClass(node,_400)){
return false;
}
_400=(dojo.html.getClass(node)+" "+_400).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_400);
};
dojo.html.setClass=function(node,_402){
node=dojo.byId(node);
var cs=new String(_402);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_402);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_405,_406){
try{
if(!_406){
var _407=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_405+"(\\s+|$)"),"$1$2");
}else{
var _407=dojo.html.getClass(node).replace(_405,"");
}
dojo.html.setClass(node,_407);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_409,_40a){
dojo.html.removeClass(node,_40a);
dojo.html.addClass(node,_409);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_40b,_40c,_40d,_40e,_40f){
_40f=false;
var _410=dojo.doc();
_40c=dojo.byId(_40c)||_410;
var _411=_40b.split(/\s+/g);
var _412=[];
if(_40e!=1&&_40e!=2){
_40e=0;
}
var _413=new RegExp("(\\s|^)(("+_411.join(")|(")+"))(\\s|$)");
var _414=_411.join(" ").length;
var _415=[];
if(!_40f&&_410.evaluate){
var _416=".//"+(_40d||"*")+"[contains(";
if(_40e!=dojo.html.classMatchType.ContainsAny){
_416+="concat(' ',@class,' '), ' "+_411.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_40e==2){
_416+=" and string-length(@class)="+_414+"]";
}else{
_416+="]";
}
}else{
_416+="concat(' ',@class,' '), ' "+_411.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _417=_410.evaluate(_416,_40c,null,XPathResult.ANY_TYPE,null);
var _418=_417.iterateNext();
while(_418){
try{
_415.push(_418);
_418=_417.iterateNext();
}
catch(e){
break;
}
}
return _415;
}else{
if(!_40d){
_40d="*";
}
_415=_40c.getElementsByTagName(_40d);
var node,i=0;
outer:
while(node=_415[i++]){
var _41b=dojo.html.getClasses(node);
if(_41b.length==0){
continue outer;
}
var _41c=0;
for(var j=0;j<_41b.length;j++){
if(_413.test(_41b[j])){
if(_40e==dojo.html.classMatchType.ContainsAny){
_412.push(node);
continue outer;
}else{
_41c++;
}
}else{
if(_40e==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_41c==_411.length){
if((_40e==dojo.html.classMatchType.IsOnly)&&(_41c==_41b.length)){
_412.push(node);
}else{
if(_40e==dojo.html.classMatchType.ContainsAll){
_412.push(node);
}
}
}
}
return _412;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_41e){
var arr=_41e.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_422){
return _422.replace(/([A-Z])/g,"-$1").toLowerCase();
};
dojo.html.getComputedStyle=function(node,_424,_425){
node=dojo.byId(node);
var _424=dojo.html.toSelectorCase(_424);
var _426=dojo.html.toCamelCase(_424);
if(!node||!node.style){
return _425;
}else{
if(document.defaultView&&dojo.html.isDescendantOf(node,node.ownerDocument)){
try{
var cs=document.defaultView.getComputedStyle(node,"");
if(cs){
return cs.getPropertyValue(_424);
}
}
catch(e){
if(node.style.getPropertyValue){
return node.style.getPropertyValue(_424);
}else{
return _425;
}
}
}else{
if(node.currentStyle){
return node.currentStyle[_426];
}
}
}
if(node.style.getPropertyValue){
return node.style.getPropertyValue(_424);
}else{
return _425;
}
};
dojo.html.getStyleProperty=function(node,_429){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_429)]:undefined);
};
dojo.html.getStyle=function(node,_42b){
var _42c=dojo.html.getStyleProperty(node,_42b);
return (_42c?_42c:dojo.html.getComputedStyle(node,_42b));
};
dojo.html.setStyle=function(node,_42e,_42f){
node=dojo.byId(node);
if(node&&node.style){
var _430=dojo.html.toCamelCase(_42e);
node.style[_430]=_42f;
}
};
dojo.html.setStyleText=function(_431,text){
try{
_431.style.cssText=text;
}
catch(e){
_431.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_433,_434){
if(!_434.style.cssText){
_433.setAttribute("style",_434.getAttribute("style"));
}else{
_433.style.cssText=_434.style.cssText;
}
dojo.html.addClass(_433,dojo.html.getClass(_434));
};
dojo.html.getUnitValue=function(node,_436,_437){
var s=dojo.html.getComputedStyle(node,_436);
if((!s)||((s=="auto")&&(_437))){
return {value:0,units:"px"};
}
var _439=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_439){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_439[1]),units:_439[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
dojo.html.getPixelValue=function(node,_43b,_43c){
var _43d=dojo.html.getUnitValue(node,_43b,_43c);
if(isNaN(_43d.value)){
return 0;
}
if((_43d.value)&&(_43d.units!="px")){
return NaN;
}
return _43d.value;
};
dojo.html.setPositivePixelValue=function(node,_43f,_440){
if(isNaN(_440)){
return false;
}
node.style[_43f]=Math.max(0,_440)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_441,_442,_443){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_443=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_443=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_441+" { "+_442+" }";
return dojo.html.styleSheet.insertRule(rule,_443);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_441,_442,_443);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_445){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_445){
_445=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_445);
}
}else{
if(document.styleSheets[0]){
if(!_445){
_445=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_445);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_448,_449){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _44a=dojo.hostenv.getText(URI,false,_449);
if(_44a===null){
return;
}
_44a=dojo.html.fixPathsInCssText(_44a,URI);
if(_448){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_44a)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _44f=doc.getElementsByTagName("style");
for(var i=0;i<_44f.length;i++){
if(_44f[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _450=dojo.html.insertCssText(_44a);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_44a,"nodeRef":_450});
if(_450&&djConfig.isDebug){
_450.setAttribute("dbgHref",URI);
}
return _450;
};
dojo.html.insertCssText=function(_451,doc,URI){
if(!_451){
return;
}
if(!doc){
doc=document;
}
if(URI){
_451=dojo.html.fixPathsInCssText(_451,URI);
}
var _454=doc.createElement("style");
_454.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_454);
}
if(_454.styleSheet){
_454.styleSheet.cssText=_451;
}else{
var _456=doc.createTextNode(_451);
_454.appendChild(_456);
}
return _454;
};
dojo.html.fixPathsInCssText=function(_457,URI){
function iefixPathsInCssText(){
var _459=/AlphaImageLoader\(src\=['"]([\t\s\w()\/.\\'"-:#=&?~]*)['"]/;
while(_45a=_459.exec(_457)){
url=_45a[1].replace(_45c,"$2");
if(!_45d.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_457.substring(0,_45a.index)+"AlphaImageLoader(src='"+url+"'";
_457=_457.substr(_45a.index+_45a[0].length);
}
return str+_457;
}
if(!_457||!URI){
return;
}
var _45a,str="",url="";
var _45f=/url\(\s*([\t\s\w()\/.\\'"-:#=&?]+)\s*\)/;
var _45d=/(file|https?|ftps?):\/\//;
var _45c=/^[\s]*(['"]?)([\w()\/.\\'"-:#=&?]*)\1[\s]*?$/;
if(dojo.render.html.ie55||dojo.render.html.ie60){
_457=iefixPathsInCssText();
}
while(_45a=_45f.exec(_457)){
url=_45a[1].replace(_45c,"$2");
if(!_45d.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_457.substring(0,_45a.index)+"url("+url+")";
_457=_457.substr(_45a.index+_45a[0].length);
}
return str+_457;
};
dojo.html.setActiveStyleSheet=function(_460){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_460){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _46c={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _46c){
if(_46c[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.provide("dojo.html.*");
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_46f,_470){
node=dojo.byId(node);
_470(node,!_46f(node));
return _46f(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_475){
dojo.html[(_475?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_47b){
dojo.html.setStyle(node,"display",((_47b instanceof String||typeof _47b=="string")?_47b:(_47b?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_47f){
dojo.html.setStyle(node,"visibility",((_47f instanceof String||typeof _47f=="string")?_47f:(_47f?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_483,_484){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_484){
if(_483>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_483=0.999999;
}
}else{
if(_483<0){
_483=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_483*100+")";
}
}
node.style.filter="Alpha(Opacity="+_483*100+")";
}else{
if(h.moz){
node.style.opacity=_483;
node.style.MozOpacity=_483;
}else{
if(h.safari){
node.style.opacity=_483;
node.style.KhtmlOpacity=_483;
}else{
node.style.opacity=_483;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _490=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_490+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _490;
};
dojo.html.setStyleAttributes=function(node,_493){
node=dojo.byId(node);
var _494=_493.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_494.length;i++){
var _496=_494[i].split(":");
var name=_496[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _498=_496[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_498);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_498});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_498});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_498});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_498});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_498;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_49a,_49b){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_49b){
_49b=bs.CONTENT_BOX;
}
var _49e=2;
var _49f;
switch(_49b){
case bs.MARGIN_BOX:
_49f=3;
break;
case bs.BORDER_BOX:
_49f=2;
break;
case bs.PADDING_BOX:
default:
_49f=1;
break;
case bs.CONTENT_BOX:
_49f=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_49e=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _4a3;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_4a3=db;
}else{
_4a3=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _4a5=node;
do{
var n=_4a5["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_4a5["offsetTop"];
ret.y+=isNaN(m)?0:m;
_4a5=_4a5.offsetParent;
}while((_4a5!=_4a3)&&(_4a5!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_49a){
var _4a8=dojo.html.getScroll();
ret.y+=_4a8.top;
ret.x+=_4a8.left;
}
var _4a9=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_49e>_49f){
for(var i=_49f;i<_49e;++i){
ret.y+=_4a9[i](node,"top");
ret.x+=_4a9[i](node,"left");
}
}else{
if(_49e<_49f){
for(var i=_49f;i>_49e;--i){
ret.y-=_4a9[i-1](node,"top");
ret.x-=_4a9[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_4ad,_4ae){
var _4af=0;
for(var x=0;x<_4ad.length;x++){
_4af+=dojo.html.getPixelValue(node,_4ad[x],_4ae);
}
return _4af;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _4bc=dojo.html.getBorder(node);
return {width:pad.width+_4bc.width,height:pad.height+_4bc.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if((h.ie)||(h.opera)){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _4c1=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_4c1){
_4c1=dojo.html.getStyle(node,"box-sizing");
}
return (_4c1?_4c1:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _4c6=dojo.html.getBorder(node);
return {width:box.width-_4c6.width,height:box.height-_4c6.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _4c8=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_4c8.width,height:node.offsetHeight-_4c8.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _4cb=0;
var _4cc=0;
var isbb=dojo.html.isBorderBox(node);
var _4ce=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_4cb=args.width+_4ce.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_4cb);
}
if(typeof args.height!="undefined"){
_4cc=args.height+_4ce.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_4cc);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _4d1=dojo.html.getBorderBox(node);
var _4d2=dojo.html.getMargin(node);
return {width:_4d1.width+_4d2.width,height:_4d1.height+_4d2.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _4d5=0;
var _4d6=0;
var isbb=dojo.html.isBorderBox(node);
var _4d8=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _4d9=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_4d5=args.width-_4d8.width;
_4d5-=_4d9.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_4d5);
}
if(typeof args.height!="undefined"){
_4d6=args.height-_4d8.height;
_4d6-=_4d9.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_4d6);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_4de,_4df,_4e0){
if(_4de instanceof Array||typeof _4de=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_4de.length<4){
_4de.push(0);
}
while(_4de.length>4){
_4de.pop();
}
var ret={left:_4de[0],top:_4de[1],width:_4de[2],height:_4de[3]};
}else{
if(!_4de.nodeType&&!(_4de instanceof String||typeof _4de=="string")&&("width" in _4de||"height" in _4de||"left" in _4de||"x" in _4de||"top" in _4de||"y" in _4de)){
var ret={left:_4de.left||_4de.x||0,top:_4de.top||_4de.y||0,width:_4de.width||0,height:_4de.height||0};
}else{
var node=dojo.byId(_4de);
var pos=dojo.html.abs(node,_4df,_4e0);
var _4e4=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_4e4.width,height:_4e4.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_4e6){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_4e9){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_4eb){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_4ed){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_4ef){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_4f1){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_4fb){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_4fd){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.html.util");
dojo.html.getElementWindow=function(_4fe){
return dojo.html.getDocumentWindow(_4fe.ownerDocument);
};
dojo.html.getDocumentWindow=function(doc){
if(dojo.render.html.safari&&!doc._parentWindow){
var fix=function(win){
win.document._parentWindow=win;
for(var i=0;i<win.frames.length;i++){
fix(win.frames[i]);
}
};
fix(window.top);
}
if(dojo.render.html.ie&&window!==document.parentWindow&&!doc._parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc._parentWindow||doc.parentWindow||doc.defaultView;
};
dojo.html.gravity=function(node,e){
node=dojo.byId(node);
var _506=dojo.html.getCursorPosition(e);
with(dojo.html){
var _507=getAbsolutePosition(node,true);
var bb=getBorderBox(node);
var _509=_507.x+(bb.width/2);
var _50a=_507.y+(bb.height/2);
}
with(dojo.html.gravity){
return ((_506.x<_509?WEST:EAST)|(_506.y<_50a?NORTH:SOUTH));
}
};
dojo.html.gravity.NORTH=1;
dojo.html.gravity.SOUTH=1<<1;
dojo.html.gravity.EAST=1<<2;
dojo.html.gravity.WEST=1<<3;
dojo.html.overElement=function(_50b,e){
_50b=dojo.byId(_50b);
var _50d=dojo.html.getCursorPosition(e);
var bb=dojo.html.getBorderBox(_50b);
var _50f=dojo.html.getAbsolutePosition(_50b,true,dojo.html.boxSizing.BORDER_BOX);
var top=_50f.y;
var _511=top+bb.height;
var left=_50f.x;
var _513=left+bb.width;
return (_50d.x>=left&&_50d.x<=_513&&_50d.y>=top&&_50d.y<=_511);
};
dojo.html.renderedTextContent=function(node){
node=dojo.byId(node);
var _515="";
if(node==null){
return _515;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
var _517="unknown";
try{
_517=dojo.html.getStyle(node.childNodes[i],"display");
}
catch(E){
}
switch(_517){
case "block":
case "list-item":
case "run-in":
case "table":
case "table-row-group":
case "table-header-group":
case "table-footer-group":
case "table-row":
case "table-column-group":
case "table-column":
case "table-cell":
case "table-caption":
_515+="\n";
_515+=dojo.html.renderedTextContent(node.childNodes[i]);
_515+="\n";
break;
case "none":
break;
default:
if(node.childNodes[i].tagName&&node.childNodes[i].tagName.toLowerCase()=="br"){
_515+="\n";
}else{
_515+=dojo.html.renderedTextContent(node.childNodes[i]);
}
break;
}
break;
case 3:
case 2:
case 4:
var text=node.childNodes[i].nodeValue;
var _519="unknown";
try{
_519=dojo.html.getStyle(node,"text-transform");
}
catch(E){
}
switch(_519){
case "capitalize":
var _51a=text.split(" ");
for(var i=0;i<_51a.length;i++){
_51a[i]=_51a[i].charAt(0).toUpperCase()+_51a[i].substring(1);
}
text=_51a.join(" ");
break;
case "uppercase":
text=text.toUpperCase();
break;
case "lowercase":
text=text.toLowerCase();
break;
default:
break;
}
switch(_519){
case "nowrap":
break;
case "pre-wrap":
break;
case "pre-line":
break;
case "pre":
break;
default:
text=text.replace(/\s+/," ");
if(/\s$/.test(_515)){
text.replace(/^\s/,"");
}
break;
}
_515+=text;
break;
default:
break;
}
}
return _515;
};
dojo.html.createNodesFromText=function(txt,trim){
if(trim){
txt=txt.replace(/^\s+|\s+$/g,"");
}
var tn=dojo.doc().createElement("div");
tn.style.visibility="hidden";
dojo.body().appendChild(tn);
var _51e="none";
if((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody><tr>"+txt+"</tr></tbody></table>";
_51e="cell";
}else{
if((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody>"+txt+"</tbody></table>";
_51e="row";
}else{
if((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table>"+txt+"</table>";
_51e="section";
}
}
}
tn.innerHTML=txt;
if(tn["normalize"]){
tn.normalize();
}
var _51f=null;
switch(_51e){
case "cell":
_51f=tn.getElementsByTagName("tr")[0];
break;
case "row":
_51f=tn.getElementsByTagName("tbody")[0];
break;
case "section":
_51f=tn.getElementsByTagName("table")[0];
break;
default:
_51f=tn;
break;
}
var _520=[];
for(var x=0;x<_51f.childNodes.length;x++){
_520.push(_51f.childNodes[x].cloneNode(true));
}
tn.style.display="none";
dojo.body().removeChild(tn);
return _520;
};
dojo.html.placeOnScreen=function(node,_523,_524,_525,_526,_527,_528){
if(_523 instanceof Array||typeof _523=="array"){
_528=_527;
_527=_526;
_526=_525;
_525=_524;
_524=_523[1];
_523=_523[0];
}
if(_527 instanceof String||typeof _527=="string"){
_527=_527.split(",");
}
if(!isNaN(_525)){
_525=[Number(_525),Number(_525)];
}else{
if(!(_525 instanceof Array||typeof _525=="array")){
_525=[0,0];
}
}
var _529=dojo.html.getScroll().offset;
var view=dojo.html.getViewport();
node=dojo.byId(node);
var _52b=node.style.display;
node.style.display="";
var bb=dojo.html.getBorderBox(node);
var w=bb.width;
var h=bb.height;
node.style.display=_52b;
if(!(_527 instanceof Array||typeof _527=="array")){
_527=["TL"];
}
var _52f,_530,_531=Infinity,_532;
for(var _533=0;_533<_527.length;++_533){
var _534=_527[_533];
var _535=true;
var tryX=_523-(_534.charAt(1)=="L"?0:w)+_525[0]*(_534.charAt(1)=="L"?1:-1);
var tryY=_524-(_534.charAt(0)=="T"?0:h)+_525[1]*(_534.charAt(0)=="T"?1:-1);
if(_526){
tryX-=_529.x;
tryY-=_529.y;
}
if(tryX<0){
tryX=0;
_535=false;
}
if(tryY<0){
tryY=0;
_535=false;
}
var x=tryX+w;
if(x>view.width){
x=view.width-w;
_535=false;
}else{
x=tryX;
}
x=Math.max(_525[0],x)+_529.x;
var y=tryY+h;
if(y>view.height){
y=view.height-h;
_535=false;
}else{
y=tryY;
}
y=Math.max(_525[1],y)+_529.y;
if(_535){
_52f=x;
_530=y;
_531=0;
_532=_534;
break;
}else{
var dist=Math.pow(x-tryX-_529.x,2)+Math.pow(y-tryY-_529.y,2);
if(_531>dist){
_531=dist;
_52f=x;
_530=y;
_532=_534;
}
}
}
if(!_528){
node.style.left=_52f+"px";
node.style.top=_530+"px";
}
return {left:_52f,top:_530,x:_52f,y:_530,dist:_531,corner:_532};
};
dojo.html.placeOnScreenPoint=function(node,_53c,_53d,_53e,_53f){
dojo.deprecated("dojo.html.placeOnScreenPoint","use dojo.html.placeOnScreen() instead","0.5");
return dojo.html.placeOnScreen(node,_53c,_53d,_53e,_53f,["TL","TR","BL","BR"]);
};
dojo.html.placeOnScreenAroundElement=function(node,_541,_542,_543,_544,_545){
var best,_547=Infinity;
_541=dojo.byId(_541);
var _548=_541.style.display;
_541.style.display="";
var mb=dojo.html.getElementBox(_541,_543);
var _54a=mb.width;
var _54b=mb.height;
var _54c=dojo.html.getAbsolutePosition(_541,true,_543);
_541.style.display=_548;
for(var _54d in _544){
var pos,_54f,_550;
var _551=_544[_54d];
_54f=_54c.x+(_54d.charAt(1)=="L"?0:_54a);
_550=_54c.y+(_54d.charAt(0)=="T"?0:_54b);
pos=dojo.html.placeOnScreen(node,_54f,_550,_542,true,_551,true);
if(pos.dist==0){
best=pos;
break;
}else{
if(_547>pos.dist){
_547=pos.dist;
best=pos;
}
}
}
if(!_545){
node.style.left=best.left+"px";
node.style.top=best.top+"px";
}
return best;
};
dojo.html.scrollIntoView=function(node){
if(!node){
return;
}
if(dojo.render.html.ie){
if(dojo.html.getBorderBox(node.parentNode).height<node.parentNode.scrollHeight){
node.scrollIntoView(false);
}
}else{
if(dojo.render.html.mozilla){
node.scrollIntoView(false);
}else{
var _553=node.parentNode;
var _554=_553.scrollTop+dojo.html.getBorderBox(_553).height;
var _555=node.offsetTop+dojo.html.getMarginBox(node).height;
if(_554<_555){
_553.scrollTop+=(_555-_554);
}else{
if(_553.scrollTop>node.offsetTop){
_553.scrollTop-=(_553.scrollTop-node.offsetTop);
}
}
}
}
};


__CPAN_EDITION__ core build.txt

Files baked into this package:

dojoGuardStart.js,
../src/bootstrap1.js,
../src/loader.js,
dojoGuardEnd.js,
../src/hostenv_browser.js,
../src/bootstrap2.js,
../src/lang/common.js,
../src/lang/array.js,
../src/lang/extras.js,
../src/lang/declare.js,
../src/lang/func.js,
../src/event/common.js,
../src/event/topic.js,
../src/event/browser.js,
../src/event/__package__.js,
../src/event.js,
../src/string/common.js,
../src/string/extras.js,
../src/string.js,
../src/io/common.js,
../src/dom.js,
../src/undo/browser.js,
../src/io/BrowserIO.js,
../src/io/cookie.js,
../src/io/__package__.js,
../src/io.js,
../src/AdapterRegistry.js,
../src/json.js,
../src/html/common.js,
../src/uri/Uri.js,
../src/html/style.js,
../src/html/__package__.js,
../src/html/display.js,
../src/html/layout.js,
../src/html/util.js

		
__CPAN_EDITION__ dashboard dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:0,flag:"",revision:Number("$Rev: 6258 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
return _6e?_6e.toLowerCase():dojo.locale;
};
dojo.hostenv.searchLocalePath=function(_6f,_70,_71){
_6f=dojo.hostenv.normalizeLocale(_6f);
var _72=_6f.split("-");
var _73=[];
for(var i=_72.length;i>0;i--){
_73.push(_72.slice(0,i).join("-"));
}
_73.push(false);
if(_70){
_73.reverse();
}
for(var j=_73.length-1;j>=0;j--){
var loc=_73[j]||"ROOT";
var _77=_71(loc);
if(_77){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_78){
_78=dojo.hostenv.normalizeLocale(_78);
dojo.hostenv.searchLocalePath(_78,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7b=djConfig.extraLocale||[];
for(var i=0;i<_7b.length;i++){
preload(_7b[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7d,_7e,_7f){
dojo.hostenv.preloadLocalizations();
var _80=[_7d,"nls",_7e].join(".");
var _81=dojo.hostenv.findModule(_80);
if(_81){
if(djConfig.localizationComplete&&_81._built){
return;
}
var _82=dojo.hostenv.normalizeLocale(_7f).replace("-","_");
var _83=_80+"."+_82;
if(dojo.hostenv.findModule(_83)){
return;
}
}
_81=dojo.hostenv.startPackage(_80);
var _84=dojo.hostenv.getModuleSymbols(_7d);
var _85=_84.concat("nls").join("/");
var _86;
dojo.hostenv.searchLocalePath(_7f,false,function(loc){
var _88=loc.replace("-","_");
var _89=_80+"."+_88;
var _8a=false;
if(!dojo.hostenv.findModule(_89)){
dojo.hostenv.startPackage(_89);
var _8b=[_85];
if(loc!="ROOT"){
_8b.push(loc);
}
_8b.push(_7e);
var _8c=_8b.join("/")+".js";
_8a=dojo.hostenv.loadPath(_8c,null,function(_8d){
var _8e=function(){
};
_8e.prototype=_86;
_81[_88]=new _8e();
for(var j in _8d){
_81[_88][j]=_8d[j];
}
});
}else{
_8a=true;
}
if(_8a&&_81[_88]){
_86=_81[_88];
}else{
_81[_88]=_86;
}
});
};
(function(){
var _90=djConfig.extraLocale;
if(_90){
if(!_90 instanceof Array){
_90=[_90];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_94){
req(m,b,_94);
if(_94){
return;
}
for(var i=0;i<_90.length;i++){
req(m,b,_90[i]);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _96=document.location.toString();
var _97=_96.split("?",2);
if(_97.length>1){
var _98=_97[1];
var _99=_98.split("&");
for(var x in _99){
var sp=_99[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _9d=document.getElementsByTagName("script");
var _9e=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_9d.length;i++){
var src=_9d[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_9e);
if(m){
var _a2=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_a2+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_a2;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_a2;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _aa=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_aa>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_aa+6,_aa+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _ac=window["document"];
var tdi=_ac["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b0=null;
var _b1=null;
try{
_b0=new XMLHttpRequest();
}
catch(e){
}
if(!_b0){
for(var i=0;i<3;++i){
var _b3=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b0=new ActiveXObject(_b3);
}
catch(e){
_b1=e;
}
if(_b0){
dojo.hostenv._XMLHTTP_PROGIDS=[_b3];
break;
}
}
}
if(!_b0){
return dojo.raise("XMLHTTP not available",_b1);
}
return _b0;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_b5,_b6){
if(!_b5){
this._blockAsync=true;
}
var _b7=this.getXmlhttpObject();
function isDocumentOk(_b8){
var _b9=_b8["status"];
return Boolean((!_b9)||((200<=_b9)&&(300>_b9))||(_b9==304));
}
if(_b5){
var _ba=this,_bb=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_b7.onreadystatechange=function(){
if(_bb){
gbl.clearTimeout(_bb);
_bb=null;
}
if(_ba._blockAsync||(xhr&&xhr._blockAsync)){
_bb=gbl.setTimeout(function(){
_b7.onreadystatechange.apply(this);
},10);
}else{
if(4==_b7.readyState){
if(isDocumentOk(_b7)){
_b5(_b7.responseText);
}
}
}
};
}
_b7.open("GET",uri,_b5?true:false);
try{
_b7.send(null);
if(_b5){
return null;
}
if(!isDocumentOk(_b7)){
var err=Error("Unable to load "+uri+" status:"+_b7.status);
err.status=_b7.status;
err.responseText=_b7.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_b6)&&(!_b5)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _b7.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_bf){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_bf);
}else{
try{
var _c0=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c0){
_c0=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_bf));
_c0.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_bf+"</div>");
}
catch(e2){
window.status=_bf;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_c2,_c3,fp,_c5){
var _c6=_c2["on"+_c3]||function(){
};
_c2["on"+_c3]=function(){
fp.apply(_c2,arguments);
_c6.apply(_c2,arguments);
};
return true;
}
function dj_load_init(e){
var _c8=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_c8!="domcontentloaded"&&_c8!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _c9=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_c9();
dojo.hostenv.modulesLoaded();
}else{
dojo.addOnLoad(_c9);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _cb=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_cb=_cb.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_cb=_cb.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_cb.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _cc=new dojo.xml.Parse();
if(_cb.length>0){
for(var x=0;x<_cb.length;x++){
var _ce=document.getElementById(_cb[x]);
if(!_ce){
continue;
}
var _cf=_cc.parseElement(_ce,null,true);
dojo.widget.getParser().createComponents(_cf);
}
}else{
if(djConfig.parseWidgets){
var _cf=_cc.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_cf);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_d4,_d5){
dj_currentContext=_d4;
dj_currentDocument=_d5;
};
dojo._fireCallback=function(_d6,_d7,_d8){
if((_d7)&&((typeof _d6=="string")||(_d6 instanceof String))){
_d6=_d7[_d6];
}
return (_d7?_d6.apply(_d7,_d8||[]):_d6());
};
dojo.withGlobal=function(_d9,_da,_db,_dc){
var _dd;
var _de=dj_currentContext;
var _df=dj_currentDocument;
try{
dojo.setContext(_d9,_d9.document);
_dd=dojo._fireCallback(_da,_db,_dc);
}
finally{
dojo.setContext(_de,_df);
}
return _dd;
};
dojo.withDoc=function(_e0,_e1,_e2,_e3){
var _e4;
var _e5=dj_currentDocument;
try{
dj_currentDocument=_e0;
_e4=dojo._fireCallback(_e1,_e2,_e3);
}
finally{
dj_currentDocument=_e5;
}
return _e4;
};
}
dojo.render.name=dojo.hostenv.name_="dashboard";
dojo.hostenv.println=function(_e6){
return alert(_e6);
};
dojo.hostenv.getXmlhttpObject=function(_e7){
if(widget.system&&_e7){
if((_e7.contentType&&_e7.contentType.indexOf("text/")!=0)||(_e7.headers&&_e7.headers["content-type"]&&_e7.headers["content-type"].indexOf("text/")!=0)){
var _e8=new dojo.hostenv.CurlRequest;
_e8._save=true;
return _e8;
}else{
if(_e7.method&&_e7.method.toUpperCase()=="HEAD"){
return new dojo.hostenv.CurlRequest;
}else{
if(_e7.headers&&_e7.header.referer){
return new dojo.hostenv.CurlRequest;
}
}
}
}
return new XMLHttpRequest;
};
dojo.hostenv.CurlRequest=function(){
this.onreadystatechange=null;
this.readyState=0;
this.responseText="";
this.responseXML=null;
this.status=0;
this.statusText="";
this._method="";
this._url="";
this._async=true;
this._referrer="";
this._headers=[];
this._save=false;
this._responseHeader="";
this._responseHeaders={};
this._fileName="";
this._username="";
this._password="";
};
dojo.hostenv.CurlRequest.prototype.open=function(_e9,url,_eb,_ec,_ed){
this._method=_e9;
this._url=url;
if(_eb){
this._async=_eb;
}
if(_ec){
this._username=_ec;
}
if(_ed){
this._password=_ed;
}
};
dojo.hostenv.CurlRequest.prototype.setRequestHeader=function(_ee,_ef){
switch(_ee){
case "Referer":
this._referrer=_ef;
break;
case "content-type":
break;
default:
this._headers.push(_ee+"="+_ef);
break;
}
};
dojo.hostenv.CurlRequest.prototype.getAllResponseHeaders=function(){
return this._responseHeader;
};
dojo.hostenv.CurlRequest.prototype.getResponseHeader=function(_f0){
return this._responseHeaders[_f0];
};
dojo.hostenv.CurlRequest.prototype.send=function(_f1){
this.readyState=1;
if(this.onreadystatechange){
this.onreadystatechange.call(this);
}
var _f2={sS:""};
if(this._referrer){
_f2.e=this._referrer;
}
if(this._headers.length){
_f2.H=this._headers.join("&");
}
if(this._username){
if(this._password){
_f2.u=this._username+":"+this._password;
}else{
_f2.u=this._username;
}
}
if(_f1){
_f2.d=this.content;
if(this._method!="POST"){
_f2.G="";
}
}
if(this._method=="HEAD"){
_f2.I="";
}else{
if(this._save){
_f2.I="";
}else{
_f2.i="";
}
}
var _f3=widget.system(dojo.hostenv.CurlRequest._formatCall(_f2,this._url),null);
this.readyState=2;
if(this.onreadystatechange){
this.onreadystatechange.call(this);
}
if(_f3.errorString){
this.responseText=_f3.errorString;
this.status=0;
}else{
if(this._save){
this._responseHeader=_f3.outputString;
}else{
var _f4=_f3.outputString.replace(/\r/g,"").split("\n\n",2);
this._responseHeader=_f4[0];
this.responseText=_f4[1];
}
_f4=this._responseHeader.split("\n");
this.statusText=_f4.shift();
this.status=this.statusText.split(" ")[1];
for(var i=0,_f6;_f6=_f4[i];i++){
var _f7=_f6.split(": ",2);
this._responseHeaders[_f7[0]]=_f7[1];
}
if(this._save){
widget.system("/bin/mkdir cache",null);
this._fileName=this._url.split("/").pop().replace(/\W/g,"");
this._fileName+="."+this._responseHeaders["Content-Type"].replace(/[\r\n]/g,"").split("/").pop();
delete _f2.I;
_f2.o="cache/"+this._fileName;
_f3=widget.system(dojo.hostenv.CurlRequest._formatCall(_f2,this._url),null);
if(!_f3.errorString){
this.responseText="cache/"+this._fileName;
}
}else{
if(this._method=="HEAD"){
this.responseText=this._responseHeader;
}
}
}
this.readyState=4;
if(this.onreadystatechange){
this.onreadystatechange.call(this);
}
};
dojo.hostenv.CurlRequest._formatCall=function(_f8,url){
var _fa=["/usr/bin/curl"];
for(var key in _f8){
if(_f8[key]!=""){
_fa.push("-"+key+" '"+_f8[key].replace(/'/g,"'")+"'");
}else{
_fa.push("-"+key);
}
}
_fa.push("'"+url.replace(/'/g,"'")+"'");
return _fa.join(" ");
};
dojo.hostenv.exit=function(){
if(widget.system){
widget.system("/bin/rm -rf cache/*",null);
}
};
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _fc=false;
var _fd=false;
var _fe=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_fc=true;
}else{
if(typeof this["load"]=="function"){
_fd=true;
}else{
if(window.widget){
_fe=true;
}
}
}
var _ff=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_ff.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_fc)&&(!_fe)){
_ff.push("browser_debug.js");
}
var _100=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_100=djConfig["baseLoaderUri"];
}
for(var x=0;x<_ff.length;x++){
var _102=_100+"src/"+_ff[x];
if(_fc||_fd){
load(_102);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_102+"'></scr"+"ipt>");
}
catch(e){
var _103=document.createElement("script");
_103.src=_102;
document.getElementsByTagName("head")[0].appendChild(_103);
}
}
}
})();
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_104,_105){
if(typeof _105!="function"){
dojo.raise("dojo.inherits: superclass argument ["+_105+"] must be a function (subclass: ["+_104+"']");
}
_104.prototype=new _105();
_104.prototype.constructor=_104;
_104.superclass=_105.prototype;
_104["super"]=_105.prototype;
};
dojo.lang._mixin=function(obj,_107){
var tobj={};
for(var x in _107){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_107[x])){
obj[x]=_107[x];
}
}
if(dojo.render.html.ie&&(typeof (_107["toString"])=="function")&&(_107["toString"]!=obj["toString"])&&(_107["toString"]!=tobj["toString"])){
obj.toString=_107.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_10b){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_10e,_10f){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_10e.prototype,arguments[i]);
}
return _10e;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_112,_113,_114,_115){
if(!dojo.lang.isArrayLike(_112)&&dojo.lang.isArrayLike(_113)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_112;
_112=_113;
_113=temp;
}
var _117=dojo.lang.isString(_112);
if(_117){
_112=_112.split("");
}
if(_115){
var step=-1;
var i=_112.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_112.length;
}
if(_114){
while(i!=end){
if(_112[i]===_113){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_112[i]==_113){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_11b,_11c,_11d){
return dojo.lang.find(_11b,_11c,_11d,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_11e,_11f){
return dojo.lang.find(_11e,_11f)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
if(!it){
return false;
}
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction()&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang");
dojo.deprecated("dojo.lang","replaced by dojo.lang.common","0.5");
dojo.provide("dojo.lang.array");
dojo.lang.has=function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
};
dojo.lang.isEmpty=function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _12d=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_12d++;
break;
}
}
return _12d==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
};
dojo.lang.map=function(arr,obj,_131){
var _132=dojo.lang.isString(arr);
if(_132){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_131)){
_131=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_131){
var _133=obj;
obj=_131;
_131=_133;
}
}
if(Array.map){
var _134=Array.map(arr,_131,obj);
}else{
var _134=[];
for(var i=0;i<arr.length;++i){
_134.push(_131.call(obj,arr[i]));
}
}
if(_132){
return _134.join("");
}else{
return _134;
}
};
dojo.lang.reduce=function(arr,_137,obj,_139){
var _13a=_137;
var ob=obj?obj:dj_global;
dojo.lang.map(arr,function(val){
_13a=_139.call(ob,_13a,val);
});
return _13a;
};
dojo.lang.forEach=function(_13d,_13e,_13f){
if(dojo.lang.isString(_13d)){
_13d=_13d.split("");
}
if(Array.forEach){
Array.forEach(_13d,_13e,_13f);
}else{
if(!_13f){
_13f=dj_global;
}
for(var i=0,l=_13d.length;i<l;i++){
_13e.call(_13f,_13d[i],i,_13d);
}
}
};
dojo.lang._everyOrSome=function(_142,arr,_144,_145){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_142?"every":"some"](arr,_144,_145);
}else{
if(!_145){
_145=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _148=_144.call(_145,arr[i],i,arr);
if(_142&&!_148){
return false;
}else{
if((!_142)&&(_148)){
return true;
}
}
}
return Boolean(_142);
}
};
dojo.lang.every=function(arr,_14a,_14b){
return this._everyOrSome(true,arr,_14a,_14b);
};
dojo.lang.some=function(arr,_14d,_14e){
return this._everyOrSome(false,arr,_14d,_14e);
};
dojo.lang.filter=function(arr,_150,_151){
var _152=dojo.lang.isString(arr);
if(_152){
arr=arr.split("");
}
var _153;
if(Array.filter){
_153=Array.filter(arr,_150,_151);
}else{
if(!_151){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_151=dj_global;
}
_153=[];
for(var i=0;i<arr.length;i++){
if(_150.call(_151,arr[i],i,arr)){
_153.push(arr[i]);
}
}
}
if(_152){
return _153.join("");
}else{
return _153;
}
};
dojo.lang.unnest=function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
};
dojo.lang.toArray=function(_158,_159){
var _15a=[];
for(var i=_159||0;i<_158.length;i++){
_15a.push(_158[i]);
}
return _15a;
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_15d){
var _15e=window,_15f=2;
if(!dojo.lang.isFunction(func)){
_15e=func;
func=_15d;
_15d=arguments[2];
_15f++;
}
if(dojo.lang.isString(func)){
func=_15e[func];
}
var args=[];
for(var i=_15f;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_15e,args);
},_15d);
};
dojo.lang.clearTimeout=function(_162){
dojo.global().clearTimeout(_162);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_16b,_16c,_16d){
with(dojo.parseObjPath(_16b,_16c,_16d)){
return dojo.evalProp(prop,obj,_16d);
}
};
dojo.lang.setObjPathValue=function(_16e,_16f,_170,_171){
if(arguments.length<4){
_171=true;
}
with(dojo.parseObjPath(_16e,_170,_171)){
if(obj&&(_171||(prop in obj))){
obj[prop]=_16f;
}
}
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_172,_173){
var fcn=(dojo.lang.isString(_173)?_172[_173]:_173)||function(){
};
return function(){
return fcn.apply(_172,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_175,_176,_177){
var nso=(_176||dojo.lang.anon);
if((_177)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_175){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_175;
return ret;
};
dojo.lang.forward=function(_17b){
return function(){
return this[_17b].apply(this,arguments);
};
};
dojo.lang.curry=function(ns,func){
var _17e=[];
ns=ns||dj_global;
if(dojo.lang.isString(func)){
func=ns[func];
}
for(var x=2;x<arguments.length;x++){
_17e.push(arguments[x]);
}
var _180=(func["__preJoinArity"]||func.length)-_17e.length;
function gather(_181,_182,_183){
var _184=_183;
var _185=_182.slice(0);
for(var x=0;x<_181.length;x++){
_185.push(_181[x]);
}
_183=_183-_181.length;
if(_183<=0){
var res=func.apply(ns,_185);
_183=_184;
return res;
}else{
return function(){
return gather(arguments,_185,_183);
};
}
}
return gather([],_17e,_180);
};
dojo.lang.curryArguments=function(ns,func,args,_18b){
var _18c=[];
var x=_18b||0;
for(x=_18b;x<args.length;x++){
_18c.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[ns,func].concat(_18c));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_192,_193){
if(!farr.length){
if(typeof _193=="function"){
_193();
}
return;
}
if((typeof _192=="undefined")&&(typeof cb=="number")){
_192=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_192){
_192=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_192,_193);
},_192);
};
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_195){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _198=dl.nameAnonFunc(args[2],ao.adviceObj,_195);
ao.adviceFunc=_198;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _198=dl.nameAnonFunc(args[0],ao.srcObj,_195);
ao.srcFunc=_198;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _198=dl.nameAnonFunc(args[1],dj_global,_195);
ao.srcFunc=_198;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _198=dl.nameAnonFunc(args[3],dj_global,_195);
ao.adviceObj=dj_global;
ao.adviceFunc=_198;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _198=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_195);
ao.aroundFunc=_198;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _19a={};
for(var x in ao){
_19a[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_19a.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_19a));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _1a2;
if((arguments.length==1)&&(typeof a1=="object")){
_1a2=a1;
}else{
_1a2={srcObj:a1,srcFunc:a2};
}
_1a2.adviceFunc=function(){
var _1a3=[];
for(var x=0;x<arguments.length;x++){
_1a3.push(arguments[x]);
}
dojo.debug("("+_1a2.srcObj+")."+_1a2.srcFunc,":",_1a3.join(", "));
};
this.kwConnect(_1a2);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this._kwConnectImpl=function(_1aa,_1ab){
var fn=(_1ab)?"disconnect":"connect";
if(typeof _1aa["srcFunc"]=="function"){
_1aa.srcObj=_1aa["srcObj"]||dj_global;
var _1ad=dojo.lang.nameAnonFunc(_1aa.srcFunc,_1aa.srcObj,true);
_1aa.srcFunc=_1ad;
}
if(typeof _1aa["adviceFunc"]=="function"){
_1aa.adviceObj=_1aa["adviceObj"]||dj_global;
var _1ad=dojo.lang.nameAnonFunc(_1aa.adviceFunc,_1aa.adviceObj,true);
_1aa.adviceFunc=_1ad;
}
_1aa.srcObj=_1aa["srcObj"]||dj_global;
_1aa.adviceObj=_1aa["adviceObj"]||_1aa["targetObj"]||dj_global;
_1aa.adviceFunc=_1aa["adviceFunc"]||_1aa["targetFunc"];
return dojo.event[fn](_1aa);
};
this.kwConnect=function(_1ae){
return this._kwConnectImpl(_1ae,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
return mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
};
this.kwDisconnect=function(_1b1){
return this._kwConnectImpl(_1b1,true);
};
};
dojo.event.MethodInvocation=function(_1b2,obj,args){
this.jp_=_1b2;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_1ba){
this.object=obj||dj_global;
this.methodname=_1ba;
this.methodfunc=this.object[_1ba];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_1bc){
if(!obj){
obj=dj_global;
}
if(!obj[_1bc]){
obj[_1bc]=function(){
};
if(!obj[_1bc]){
dojo.raise("Cannot set do-nothing method on that object "+_1bc);
}
}else{
if((!dojo.lang.isFunction(obj[_1bc]))&&(!dojo.lang.isAlien(obj[_1bc]))){
return null;
}
}
var _1bd=_1bc+"$joinpoint";
var _1be=_1bc+"$joinpoint$method";
var _1bf=obj[_1bd];
if(!_1bf){
var _1c0=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_1c0=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_1bd,_1be,_1bc]);
}
}
var _1c1=obj[_1bc].length;
obj[_1be]=obj[_1bc];
_1bf=obj[_1bd]=new dojo.event.MethodJoinPoint(obj,_1be);
obj[_1bc]=function(){
var args=[];
if((_1c0)&&(!arguments.length)){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(_1c0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _1bf.run.apply(_1bf,args);
};
obj[_1bc].__preJoinArity=_1c1;
}
return _1bf;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _1c7=[];
for(var x=0;x<args.length;x++){
_1c7[x]=args[x];
}
var _1c9=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _1cb=marr[0]||dj_global;
var _1cc=marr[1];
if(!_1cb[_1cc]){
dojo.raise("function \""+_1cc+"\" does not exist on \""+_1cb+"\"");
}
var _1cd=marr[2]||dj_global;
var _1ce=marr[3];
var msg=marr[6];
var _1d0;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _1cb[_1cc].apply(_1cb,to.args);
}};
to.args=_1c7;
var _1d2=parseInt(marr[4]);
var _1d3=((!isNaN(_1d2))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _1d6=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_1c9(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_1ce){
_1cd[_1ce].call(_1cd,to);
}else{
if((_1d3)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_1cb[_1cc].call(_1cb,to);
}else{
_1cb[_1cc].apply(_1cb,args);
}
},_1d2);
}else{
if(msg){
_1cb[_1cc].call(_1cb,to);
}else{
_1cb[_1cc].apply(_1cb,args);
}
}
}
};
var _1d9=function(){
if(this.squelch){
try{
return _1c9.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _1c9.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_1d9);
}
var _1da;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_1da=mi.proceed();
}else{
if(this.methodfunc){
_1da=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_1d9);
}
return (this.methodfunc)?_1da:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"]);
},addAdvice:function(_1df,_1e0,_1e1,_1e2,_1e3,_1e4,once,_1e6,rate,_1e8){
var arr=this.getArr(_1e3);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_1df,_1e0,_1e1,_1e2,_1e6,rate,_1e8];
if(once){
if(this.hasAdvice(_1df,_1e0,_1e3,arr)>=0){
return;
}
}
if(_1e4=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_1eb,_1ec,_1ed,arr){
if(!arr){
arr=this.getArr(_1ed);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _1ec=="object")?(new String(_1ec)).toString():_1ec;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_1eb)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_1f3,_1f4,_1f5,once){
var arr=this.getArr(_1f5);
var ind=this.hasAdvice(_1f3,_1f4,_1f5,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_1f3,_1f4,_1f5,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_1f9){
if(!this.topics[_1f9]){
this.topics[_1f9]=new this.TopicImpl(_1f9);
}
return this.topics[_1f9];
};
this.registerPublisher=function(_1fa,obj,_1fc){
var _1fa=this.getTopic(_1fa);
_1fa.registerPublisher(obj,_1fc);
};
this.subscribe=function(_1fd,obj,_1ff){
var _1fd=this.getTopic(_1fd);
_1fd.subscribe(obj,_1ff);
};
this.unsubscribe=function(_200,obj,_202){
var _200=this.getTopic(_200);
_200.unsubscribe(obj,_202);
};
this.destroy=function(_203){
this.getTopic(_203).destroy();
delete this.topics[_203];
};
this.publishApply=function(_204,args){
var _204=this.getTopic(_204);
_204.sendMessage.apply(_204,args);
};
this.publish=function(_206,_207){
var _206=this.getTopic(_206);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_206.sendMessage.apply(_206,args);
};
};
dojo.event.topic.TopicImpl=function(_20a){
this.topicName=_20a;
this.subscribe=function(_20b,_20c){
var tf=_20c||_20b;
var to=(!_20c)?dj_global:_20b;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_20f,_210){
var tf=(!_210)?_20f:_210;
var to=(!_210)?null:_20f;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_213){
this._getJoinPoint().squelch=_213;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_214,_215){
dojo.event.connect(_214,_215,this,"sendMessage");
};
this.sendMessage=function(_216){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_219){
var na;
var tna;
if(_219){
tna=_219.all||_219.getElementsByTagName("*");
na=[_219];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _21d={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _221=0;
this.normalizedEventName=function(_222){
switch(_222){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _222;
break;
default:
return _222.toLowerCase();
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_226){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_226.length;x++){
node.__clobberAttrs__.push(_226[x]);
}
};
this.removeListener=function(node,_229,fp,_22b){
if(!_22b){
var _22b=false;
}
_229=dojo.event.browser.normalizedEventName(_229);
if((_229=="onkey")||(_229=="key")){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_22b);
}
_229="onkeypress";
}
if(_229.substr(0,2)=="on"){
_229=_229.substr(2);
}
if(node.removeEventListener){
node.removeEventListener(_229,fp,_22b);
}
};
this.addListener=function(node,_22d,fp,_22f,_230){
if(!node){
return;
}
if(!_22f){
var _22f=false;
}
_22d=dojo.event.browser.normalizedEventName(_22d);
if((_22d=="onkey")||(_22d=="key")){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_22f,_230);
}
_22d="onkeypress";
}
if(_22d.substr(0,2)!="on"){
_22d="on"+_22d;
}
if(!_230){
var _231=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_22f){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_231=fp;
}
if(node.addEventListener){
node.addEventListener(_22d.substr(2),_231,_22f);
return _231;
}else{
if(typeof node[_22d]=="function"){
var _234=node[_22d];
node[_22d]=function(e){
_234(e);
return _231(e);
};
}else{
node[_22d]=_231;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_22d]);
}
return _231;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_237,_238){
if(typeof _237!="function"){
dojo.raise("listener not a function: "+_237);
}
dojo.event.browser.currentEvent.currentTarget=_238;
return _237.call(_238,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_23b){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _23d=evt.keyCode;
if(_23d>=65&&_23d<=90&&evt.shiftKey==false){
_23d+=32;
}
if(_23d>=1&&_23d<=26&&evt.ctrlKey){
_23d+=96;
}
evt.key=String.fromCharCode(_23d);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _23d=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_23d+=32;
}
evt.key=String.fromCharCode(_23d);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
default:
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_23b?_23b:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _23f=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_23f.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_23f.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.returnValue=false;
evt.cancelBubble=true;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.provide("dojo.event.*");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_247,_248){
var out="";
for(var i=0;i<_247;i++){
out+=str;
if(_248&&i<_247-1){
out+=_248;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_257,_258,_259){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_257){
this.mimetype=_257;
}
if(_258){
this.transport=_258;
}
if(arguments.length>=4){
this.changeUrl=_259;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_25c,_25d){
},error:function(type,_25f,_260,_261){
},timeout:function(type,_263,_264,_265){
},handle:function(type,data,_268,_269){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_26a){
if(_26a["url"]){
_26a.url=_26a.url.toString();
}
if(_26a["formNode"]){
_26a.formNode=dojo.byId(_26a.formNode);
}
if(!_26a["method"]&&_26a["formNode"]&&_26a["formNode"].method){
_26a.method=_26a["formNode"].method;
}
if(!_26a["handle"]&&_26a["handler"]){
_26a.handle=_26a.handler;
}
if(!_26a["load"]&&_26a["loaded"]){
_26a.load=_26a.loaded;
}
if(!_26a["changeUrl"]&&_26a["changeURL"]){
_26a.changeUrl=_26a.changeURL;
}
_26a.encoding=dojo.lang.firstValued(_26a["encoding"],djConfig["bindEncoding"],"");
_26a.sendTransport=dojo.lang.firstValued(_26a["sendTransport"],djConfig["ioSendTransport"],false);
var _26b=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_26a[fn]&&_26b(_26a[fn])){
continue;
}
if(_26a["handle"]&&_26b(_26a["handle"])){
_26a[fn]=_26a.handle;
}
}
dojo.lang.mixin(this,_26a);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_272){
if(!(_272 instanceof dojo.io.Request)){
try{
_272=new dojo.io.Request(_272);
}
catch(e){
dojo.debug(e);
}
}
var _273="";
if(_272["transport"]){
_273=_272["transport"];
if(!this[_273]){
dojo.io.sendBindError(_272,"No dojo.io.bind() transport with name '"+_272["transport"]+"'.");
return _272;
}
if(!this[_273].canHandle(_272)){
dojo.io.sendBindError(_272,"dojo.io.bind() transport with name '"+_272["transport"]+"' cannot handle this type of request.");
return _272;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_272))){
_273=tmp;
break;
}
}
if(_273==""){
dojo.io.sendBindError(_272,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _272;
}
}
this[_273].bind(_272);
_272.bindSuccess=true;
return _272;
};
dojo.io.sendBindError=function(_276,_277){
if((typeof _276.error=="function"||typeof _276.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _278=new dojo.io.Error(_277);
setTimeout(function(){
_276[(typeof _276.error=="function")?"error":"handle"]("error",_278,null,_276);
},50);
}else{
dojo.raise(_277);
}
};
dojo.io.queueBind=function(_279){
if(!(_279 instanceof dojo.io.Request)){
try{
_279=new dojo.io.Request(_279);
}
catch(e){
dojo.debug(e);
}
}
var _27a=_279.load;
_279.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_27a.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _27c=_279.error;
_279.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_27c.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_279);
dojo.io._dispatchNextQueueBind();
return _279;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_27f,last){
var enc=/utf/i.test(_27f||"")?encodeURIComponent:dojo.string.encodeAscii;
var _282=[];
var _283=new Object();
for(var name in map){
var _285=function(elt){
var val=enc(name)+"="+enc(elt);
_282[(last==name)?"push":"unshift"](val);
};
if(!_283[name]){
var _288=map[name];
if(dojo.lang.isArray(_288)){
dojo.lang.forEach(_288,_285);
}else{
_285(_288);
}
}
}
return _282.join("&");
};
dojo.io.setIFrameSrc=function(_289,src,_28b){
try{
var r=dojo.render.html;
if(!_28b){
if(r.safari){
_289.location=src;
}else{
frames[_289.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_289.contentWindow.document;
}else{
if(r.safari){
idoc=_289.document;
}else{
idoc=_289.contentWindow;
}
}
if(!idoc){
_289.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_28e,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _28e.replace(/\%\{(\w+)\}/g,function(_291,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _294=str.split(" ");
for(var i=0;i<_294.length;i++){
_294[i]=_294[i].charAt(0).toUpperCase()+_294[i].substring(1);
}
return _294.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _299=escape(str);
var _29a,re=/%u([0-9A-F]{4})/i;
while((_29a=_299.match(re))){
var num=Number("0x"+_29a[1]);
var _29d=escape("&#"+num+";");
ret+=_299.substring(0,_29a.index)+_29d;
_299=_299.substring(_29a.index+_29a[0].length);
}
ret+=_299.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_2a2){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_2a2){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_2ab){
if(_2ab){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_2af,_2b0){
if(_2b0){
str=str.toLowerCase();
_2af=_2af.toLowerCase();
}
return str.indexOf(_2af)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_2b6){
if(_2b6=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_2b6=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_2b8){
var _2b9=[];
for(var i=0,_2bb=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_2b8){
_2b9.push(str.substring(_2bb,i));
_2bb=i+1;
}
}
_2b9.push(str.substr(_2bb));
return _2b9;
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(E){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _2bd=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_2bd.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_2bf,_2c0){
var node=_2bf.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_2c0&&node&&node.tagName&&node.tagName.toLowerCase()!=_2c0.toLowerCase()){
node=dojo.dom.nextElement(node,_2c0);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_2c2,_2c3){
var node=_2c2.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_2c3&&node&&node.tagName&&node.tagName.toLowerCase()!=_2c3.toLowerCase()){
node=dojo.dom.prevElement(node,_2c3);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_2c6){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_2c6&&_2c6.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_2c6);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_2c8){
if(!node){
return null;
}
if(_2c8){
_2c8=_2c8.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_2c8&&_2c8.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_2c8);
}
return node;
};
dojo.dom.moveChildren=function(_2c9,_2ca,trim){
var _2cc=0;
if(trim){
while(_2c9.hasChildNodes()&&_2c9.firstChild.nodeType==dojo.dom.TEXT_NODE){
_2c9.removeChild(_2c9.firstChild);
}
while(_2c9.hasChildNodes()&&_2c9.lastChild.nodeType==dojo.dom.TEXT_NODE){
_2c9.removeChild(_2c9.lastChild);
}
}
while(_2c9.hasChildNodes()){
_2ca.appendChild(_2c9.firstChild);
_2cc++;
}
return _2cc;
};
dojo.dom.copyChildren=function(_2cd,_2ce,trim){
var _2d0=_2cd.cloneNode(true);
return this.moveChildren(_2d0,_2ce,trim);
};
dojo.dom.removeChildren=function(node){
var _2d2=node.childNodes.length;
while(node.hasChildNodes()){
node.removeChild(node.firstChild);
}
return _2d2;
};
dojo.dom.replaceChildren=function(node,_2d4){
dojo.dom.removeChildren(node);
node.appendChild(_2d4);
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_2d7,_2d8){
var _2d9=[];
var _2da=(_2d7&&(_2d7 instanceof Function||typeof _2d7=="function"));
while(node){
if(!_2da||_2d7(node)){
_2d9.push(node);
}
if(_2d8&&_2d9.length>0){
return _2d9[0];
}
node=node.parentNode;
}
if(_2d8){
return null;
}
return _2d9;
};
dojo.dom.getAncestorsByTag=function(node,tag,_2dd){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_2dd);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_2e2,_2e3){
if(_2e3&&node){
node=node.parentNode;
}
while(node){
if(node==_2e2){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _2e6=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _2e7=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_2e7.length;i++){
try{
doc=new ActiveXObject(_2e7[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_2e6.implementation)&&(_2e6.implementation.createDocument)){
doc=_2e6.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_2ea){
if(!_2ea){
_2ea="text/xml";
}
if(!dj_undef("DOMParser")){
var _2eb=new DOMParser();
return _2eb.parseFromString(str,_2ea);
}else{
if(!dj_undef("ActiveXObject")){
var _2ec=dojo.dom.createDocument();
if(_2ec){
_2ec.async=false;
_2ec.loadXML(str);
return _2ec;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _2ed=dojo.doc();
if(_2ed.createElement){
var tmp=_2ed.createElement("xml");
tmp.innerHTML=str;
if(_2ed.implementation&&_2ed.implementation.createDocument){
var _2ef=_2ed.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_2ef.importNode(tmp.childNodes.item(i),true);
}
return _2ef;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_2f2){
if(_2f2.firstChild){
_2f2.insertBefore(node,_2f2.firstChild);
}else{
_2f2.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_2f5){
if(_2f5!=true&&(node===ref||node.nextSibling===ref)){
return false;
}
var _2f6=ref.parentNode;
_2f6.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_2f9){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_2f9!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_2f9);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_2fd){
if((!node)||(!ref)||(!_2fd)){
return false;
}
switch(_2fd.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_2ff,_300){
var _301=_2ff.childNodes;
if(!_301.length){
_2ff.appendChild(node);
return true;
}
var _302=null;
for(var i=0;i<_301.length;i++){
var _304=_301.item(i)["getAttribute"]?parseInt(_301.item(i).getAttribute("dojoinsertionindex")):-1;
if(_304<_300){
_302=_301.item(i);
}
}
if(_302){
return dojo.dom.insertAfter(node,_302);
}else{
return dojo.dom.insertBefore(node,_301.item(0));
}
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _307=dojo.doc();
dojo.dom.replaceChildren(node,_307.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _308="";
if(node==null){
return _308;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_308+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_308+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _308;
}
};
dojo.dom.hasParent=function(node){
return node&&node.parentNode&&dojo.dom.isNode(node.parentNode);
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_30e,_30f,_310){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_30e,_30f,_310);
}else{
var _311=elem.ownerDocument;
var _312=_311.createNode(2,_30f,_30e);
_312.nodeValue=_310;
elem.setAttributeNode(_312);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:window.location.href,initialHash:window.location.hash,moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _317=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_319){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_317.apply(this,[_319]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _31a=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_31c){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_31a){
_31a.apply(this,[_31c]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_31f){
if(!dojo.render.html.opera){
var _320=this._getUrlQuery(_31f.href);
if(_320==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_320==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_320==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _321=this.historyStack.pop();
if(!_321){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_321);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _328=url.split("?");
if(_328.length<2){
return null;
}else{
return _328[1];
}
},_loadIframeHistory:function(){
var url=dojo.hostenv.getBaseScriptUri()+"iframe_history.html?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
dojo.io.checkChildrenForFile=function(node){
var _32b=false;
var _32c=node.getElementsByTagName("input");
dojo.lang.forEach(_32c,function(_32d){
if(_32b){
return;
}
if(_32d.getAttribute("type")=="file"){
_32b=true;
}
});
return _32b;
};
dojo.io.formHasFile=function(_32e){
return dojo.io.checkChildrenForFile(_32e);
};
dojo.io.updateNode=function(node,_330){
node=dojo.byId(node);
var args=_330;
if(dojo.lang.isString(_330)){
args={url:_330};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
if(dojo["event"]){
try{
dojo.event.browser.clean(node.firstChild);
}
catch(e){
}
}
node.removeChild(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_337,_338,_339){
if((!_337)||(!_337.tagName)||(!_337.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_339){
_339=dojo.io.formFilter;
}
var enc=/utf/i.test(_338||"")?encodeURIComponent:dojo.string.encodeAscii;
var _33b=[];
for(var i=0;i<_337.elements.length;i++){
var elm=_337.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_339(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_33b.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_33b.push(name+"="+enc(elm.value));
}
}else{
_33b.push(name+"="+enc(elm.value));
}
}
}
var _341=_337.getElementsByTagName("input");
for(var i=0;i<_341.length;i++){
var _342=_341[i];
if(_342.type.toLowerCase()=="image"&&_342.form==_337&&_339(_342)){
var name=enc(_342.name);
_33b.push(name+"="+enc(_342.value));
_33b.push(name+".x=0");
_33b.push(name+".y=0");
}
}
return _33b.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _348=form.getElementsByTagName("input");
for(var i=0;i<_348.length;i++){
var _349=_348[i];
if(_349.type.toLowerCase()=="image"&&_349.form==form){
this.connect(_349,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _350=false;
if(node.disabled||!node.name){
_350=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_350=node==this.clickedButton;
}else{
_350=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _350;
},connect:function(_351,_352,_353){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_351,_352,this,_353);
}else{
var fcn=dojo.lang.hitch(this,_353);
_351[_352]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _356=this;
var _357={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_359,_35a){
return url+"|"+_359+"|"+_35a.toLowerCase();
}
function addToCache(url,_35c,_35d,http){
_357[getCacheKey(url,_35c,_35d)]=http;
}
function getFromCache(url,_360,_361){
return _357[getCacheKey(url,_360,_361)];
}
this.clearCache=function(){
_357={};
};
function doLoad(_362,http,url,_365,_366){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_362.method.toLowerCase()=="head"){
var _368=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _368;
};
var _369=_368.split(/[\r\n]+/g);
for(var i=0;i<_369.length;i++){
var pair=_369[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_362.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_362.mimetype=="text/json"||_362.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_362.mimetype=="application/xml")||(_362.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_366){
addToCache(url,_365,_362.method,http);
}
_362[(typeof _362.load=="function")?"load":"handle"]("load",ret,http,_362);
}else{
var _36c=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_362[(typeof _362.error=="function")?"error":"handle"]("error",_36c,http,_362);
}
}
function setHeaders(http,_36e){
if(_36e["headers"]){
for(var _36f in _36e["headers"]){
if(_36f.toLowerCase()=="content-type"&&!_36e["contentType"]){
_36e["contentType"]=_36e["headers"][_36f];
}else{
http.setRequestHeader(_36f,_36e["headers"][_36f]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_356._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _373=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_373,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _374=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_375){
return _374&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_375["mimetype"].toLowerCase()||""))&&!(_375["formNode"]&&dojo.io.formHasFile(_375["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_376){
if(!_376["url"]){
if(!_376["formNode"]&&(_376["backButton"]||_376["back"]||_376["changeUrl"]||_376["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_376);
return true;
}
}
var url=_376.url;
var _378="";
if(_376["formNode"]){
var ta=_376.formNode.getAttribute("action");
if((ta)&&(!_376["url"])){
url=ta;
}
var tp=_376.formNode.getAttribute("method");
if((tp)&&(!_376["method"])){
_376.method=tp;
}
_378+=dojo.io.encodeForm(_376.formNode,_376.encoding,_376["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_376["file"]){
_376.method="post";
}
if(!_376["method"]){
_376.method="get";
}
if(_376.method.toLowerCase()=="get"){
_376.multipart=false;
}else{
if(_376["file"]){
_376.multipart=true;
}else{
if(!_376["multipart"]){
_376.multipart=false;
}
}
}
if(_376["backButton"]||_376["back"]||_376["changeUrl"]){
dojo.undo.browser.addToHistory(_376);
}
var _37b=_376["content"]||{};
if(_376.sendTransport){
_37b["dojo.transport"]="xmlhttp";
}
do{
if(_376.postContent){
_378=_376.postContent;
break;
}
if(_37b){
_378+=dojo.io.argsFromMap(_37b,_376.encoding);
}
if(_376.method.toLowerCase()=="get"||!_376.multipart){
break;
}
var t=[];
if(_378.length){
var q=_378.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_376.file){
if(dojo.lang.isArray(_376.file)){
for(var i=0;i<_376.file.length;++i){
var o=_376.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_376.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_378=t.join("\r\n");
}
}while(false);
var _381=_376["sync"]?false:true;
var _382=_376["preventCache"]||(this.preventCache==true&&_376["preventCache"]!=false);
var _383=_376["useCache"]==true||(this.useCache==true&&_376["useCache"]!=false);
if(!_382&&_383){
var _384=getFromCache(url,_378,_376.method);
if(_384){
doLoad(_376,_384,url,_378,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_376);
var _386=false;
if(_381){
var _387=this.inFlight.push({"req":_376,"http":http,"url":url,"query":_378,"useCache":_383,"startTime":_376.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_356._blockAsync=true;
}
if(_376.method.toLowerCase()=="post"){
if(!_376.user){
http.open("POST",url,_381);
}else{
http.open("POST",url,_381,_376.user,_376.password);
}
setHeaders(http,_376);
http.setRequestHeader("Content-Type",_376.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_376.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_378);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_376,{status:404},url,_378,_383);
}
}else{
var _388=url;
if(_378!=""){
_388+=(_388.indexOf("?")>-1?"&":"?")+_378;
}
if(_382){
_388+=(dojo.string.endsWithAny(_388,"?","&")?"":(_388.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_376.user){
http.open(_376.method.toUpperCase(),_388,_381);
}else{
http.open(_376.method.toUpperCase(),_388,_381,_376.user,_376.password);
}
setHeaders(http,_376);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_376,{status:404},url,_378,_383);
}
}
if(!_381){
doLoad(_376,http,url,_378,_383);
_356._blockAsync=false;
}
_376.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_38a,days,path,_38d,_38e){
var _38f=-1;
if(typeof days=="number"&&days>=0){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_38f=d.toGMTString();
}
_38a=escape(_38a);
document.cookie=name+"="+_38a+";"+(_38f!=-1?" expires="+_38f+";":"")+(path?"path="+path:"")+(_38d?"; domain="+_38d:"")+(_38e?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _393=document.cookie.substring(idx+name.length+1);
var end=_393.indexOf(";");
if(end==-1){
end=_393.length;
}
_393=_393.substring(0,end);
_393=unescape(_393);
return _393;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_39a,_39b,_39c){
if(arguments.length==5){
_39c=_39a;
_39a=null;
_39b=null;
}
var _39d=[],_39e,_39f="";
if(!_39c){
_39e=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_39e){
_39e={};
}
for(var prop in obj){
if(prop==null){
delete _39e[prop];
}else{
if(typeof obj[prop]=="string"||typeof obj[prop]=="number"){
_39e[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _39e){
_39d.push(escape(prop)+"="+escape(_39e[prop]));
}
_39f=_39d.join("&");
}
dojo.io.cookie.setCookie(name,_39f,days,path,_39a,_39b);
};
dojo.io.cookie.getObjectCookie=function(name){
var _3a2=null,_3a3=dojo.io.cookie.getCookie(name);
if(_3a3){
_3a2={};
var _3a4=_3a3.split("&");
for(var i=0;i<_3a4.length;i++){
var pair=_3a4[i].split("=");
var _3a7=pair[1];
if(isNaN(_3a7)){
_3a7=unescape(pair[1]);
}
_3a2[unescape(pair[0])]=_3a7;
}
}
return _3a2;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _3a8=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_3a8=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.provide("dojo.io.*");
dojo.provide("dojo.lang.type");
dojo.lang.whatAmI=function(_3a9){
dojo.deprecated("dojo.lang.whatAmI","use dojo.lang.getType instead","0.5");
return dojo.lang.getType(_3a9);
};
dojo.lang.whatAmI.custom={};
dojo.lang.getType=function(_3aa){
try{
if(dojo.lang.isArray(_3aa)){
return "array";
}
if(dojo.lang.isFunction(_3aa)){
return "function";
}
if(dojo.lang.isString(_3aa)){
return "string";
}
if(dojo.lang.isNumber(_3aa)){
return "number";
}
if(dojo.lang.isBoolean(_3aa)){
return "boolean";
}
if(dojo.lang.isAlien(_3aa)){
return "alien";
}
if(dojo.lang.isUndefined(_3aa)){
return "undefined";
}
for(var name in dojo.lang.whatAmI.custom){
if(dojo.lang.whatAmI.custom[name](_3aa)){
return name;
}
}
if(dojo.lang.isObject(_3aa)){
return "object";
}
}
catch(e){
}
return "unknown";
};
dojo.lang.isNumeric=function(_3ac){
return (!isNaN(_3ac)&&isFinite(_3ac)&&(_3ac!=null)&&!dojo.lang.isBoolean(_3ac)&&!dojo.lang.isArray(_3ac)&&!/^\s*$/.test(_3ac));
};
dojo.lang.isBuiltIn=function(_3ad){
return (dojo.lang.isArray(_3ad)||dojo.lang.isFunction(_3ad)||dojo.lang.isString(_3ad)||dojo.lang.isNumber(_3ad)||dojo.lang.isBoolean(_3ad)||(_3ad==null)||(_3ad instanceof Error)||(typeof _3ad=="error"));
};
dojo.lang.isPureObject=function(_3ae){
return ((_3ae!=null)&&dojo.lang.isObject(_3ae)&&_3ae.constructor==Object);
};
dojo.lang.isOfType=function(_3af,type,_3b1){
var _3b2=false;
if(_3b1){
_3b2=_3b1["optional"];
}
if(_3b2&&((_3af===null)||dojo.lang.isUndefined(_3af))){
return true;
}
if(dojo.lang.isArray(type)){
var _3b3=type;
for(var i in _3b3){
var _3b5=_3b3[i];
if(dojo.lang.isOfType(_3af,_3b5)){
return true;
}
}
return false;
}else{
if(dojo.lang.isString(type)){
type=type.toLowerCase();
}
switch(type){
case Array:
case "array":
return dojo.lang.isArray(_3af);
case Function:
case "function":
return dojo.lang.isFunction(_3af);
case String:
case "string":
return dojo.lang.isString(_3af);
case Number:
case "number":
return dojo.lang.isNumber(_3af);
case "numeric":
return dojo.lang.isNumeric(_3af);
case Boolean:
case "boolean":
return dojo.lang.isBoolean(_3af);
case Object:
case "object":
return dojo.lang.isObject(_3af);
case "pureobject":
return dojo.lang.isPureObject(_3af);
case "builtin":
return dojo.lang.isBuiltIn(_3af);
case "alien":
return dojo.lang.isAlien(_3af);
case "undefined":
return dojo.lang.isUndefined(_3af);
case null:
case "null":
return (_3af===null);
case "optional":
dojo.deprecated("dojo.lang.isOfType(value, [type, \"optional\"])","use dojo.lang.isOfType(value, type, {optional: true} ) instead","0.5");
return ((_3af===null)||dojo.lang.isUndefined(_3af));
default:
if(dojo.lang.isFunction(type)){
return (_3af instanceof type);
}else{
dojo.raise("dojo.lang.isOfType() was passed an invalid type");
}
}
}
dojo.raise("If we get here, it means a bug was introduced above.");
};
dojo.lang.getObject=function(str){
var _3b7=str.split("."),i=0,obj=dj_global;
do{
obj=obj[_3b7[i++]];
}while(i<_3b7.length&&obj);
return (obj!=dj_global)?obj:null;
};
dojo.lang.doesObjectExist=function(str){
var _3bb=str.split("."),i=0,obj=dj_global;
do{
obj=obj[_3bb[i++]];
}while(i<_3bb.length&&obj);
return (obj&&obj!=dj_global);
};
dojo.provide("dojo.lang.assert");
dojo.lang.assert=function(_3be,_3bf){
if(!_3be){
var _3c0="An assert statement failed.\n"+"The method dojo.lang.assert() was called with a 'false' value.\n";
if(_3bf){
_3c0+="Here's the assert message:\n"+_3bf+"\n";
}
throw new Error(_3c0);
}
};
dojo.lang.assertType=function(_3c1,type,_3c3){
if(dojo.lang.isString(_3c3)){
dojo.deprecated("dojo.lang.assertType(value, type, \"message\")","use dojo.lang.assertType(value, type) instead","0.5");
}
if(!dojo.lang.isOfType(_3c1,type,_3c3)){
if(!dojo.lang.assertType._errorMessage){
dojo.lang.assertType._errorMessage="Type mismatch: dojo.lang.assertType() failed.";
}
dojo.lang.assert(false,dojo.lang.assertType._errorMessage);
}
};
dojo.lang.assertValidKeywords=function(_3c4,_3c5,_3c6){
var key;
if(!_3c6){
if(!dojo.lang.assertValidKeywords._errorMessage){
dojo.lang.assertValidKeywords._errorMessage="In dojo.lang.assertValidKeywords(), found invalid keyword:";
}
_3c6=dojo.lang.assertValidKeywords._errorMessage;
}
if(dojo.lang.isArray(_3c5)){
for(key in _3c4){
if(!dojo.lang.inArray(_3c5,key)){
dojo.lang.assert(false,_3c6+" "+key);
}
}
}else{
for(key in _3c4){
if(!(key in _3c5)){
dojo.lang.assert(false,_3c6+" "+key);
}
}
}
};
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_3c8){
this.pairs=[];
this.returnWrappers=_3c8||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_3ca,wrap,_3cc,_3cd){
var type=(_3cd)?"unshift":"push";
this.pairs[type]([name,_3ca,wrap,_3cc]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.lang.repr");
dojo.lang.reprRegistry=new dojo.AdapterRegistry();
dojo.lang.registerRepr=function(name,_3d5,wrap,_3d7){
dojo.lang.reprRegistry.register(name,_3d5,wrap,_3d7);
};
dojo.lang.repr=function(obj){
if(typeof (obj)=="undefined"){
return "undefined";
}else{
if(obj===null){
return "null";
}
}
try{
if(typeof (obj["__repr__"])=="function"){
return obj["__repr__"]();
}else{
if((typeof (obj["repr"])=="function")&&(obj.repr!=arguments.callee)){
return obj["repr"]();
}
}
return dojo.lang.reprRegistry.match(obj);
}
catch(e){
if(typeof (obj.NAME)=="string"&&(obj.toString==Function.prototype.toString||obj.toString==Object.prototype.toString)){
return obj.NAME;
}
}
if(typeof (obj)=="function"){
obj=(obj+"").replace(/^\s+/,"");
var idx=obj.indexOf("{");
if(idx!=-1){
obj=obj.substr(0,idx)+"{...}";
}
}
return obj+"";
};
dojo.lang.reprArrayLike=function(arr){
try{
var na=dojo.lang.map(arr,dojo.lang.repr);
return "["+na.join(", ")+"]";
}
catch(e){
}
};
(function(){
var m=dojo.lang;
m.registerRepr("arrayLike",m.isArrayLike,m.reprArrayLike);
m.registerRepr("string",m.isString,m.reprString);
m.registerRepr("numbers",m.isNumber,m.reprNumber);
m.registerRepr("boolean",m.isBoolean,m.reprNumber);
})();
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_3dd,_3de,init,_3e0){
if((dojo.lang.isFunction(_3e0))||((!_3e0)&&(!dojo.lang.isFunction(init)))){
var temp=_3e0;
_3e0=init;
init=temp;
}
var _3e2=[];
if(dojo.lang.isArray(_3de)){
_3e2=_3de;
_3de=_3e2.shift();
}
if(!init){
init=dojo.evalObjPath(_3dd,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_3de?_3de.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _3de();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_3e2;
for(var i=0,l=_3e2.length;i<l;i++){
dojo.lang.extend(ctor,_3e2[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_3dd;
if(dojo.lang.isArray(_3e0)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_3e0));
}else{
dojo.lang.extend(ctor,(_3e0)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
dojo.lang.setObjPathValue(_3dd,ctor,null,true);
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_3ec,_3ed,args){
var _3ef,_3f0=this.___proto;
this.___proto=_3ec;
try{
_3ef=_3ec[_3ed].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_3f0;
}
return _3ef;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.lang.*");
dojo.provide("dojo.storage");
dojo.storage.StorageProvider={};
dojo.declare("dojo.storage",null,{SUCCESS:"success",FAILED:"failed",PENDING:"pending",SIZE_NOT_AVAILABLE:"Size not available",SIZE_NO_LIMIT:"No size limit","namespace":"dojoStorage",onHideSettingsUI:null,initialize:function(){
dojo.unimplemented("dojo.storage.initialize");
},isAvailable:function(){
dojo.unimplemented("dojo.storage.isAvailable");
},put:function(key,_3f5,_3f6){
dojo.unimplemented("dojo.storage.put");
},get:function(key){
dojo.unimplemented("dojo.storage.get");
},hasKey:function(key){
return (this.get(key)!=null);
},clear:function(){
dojo.unimplemented("dojo.storage.clear");
},remove:function(key){
dojo.unimplemented("dojo.storage.remove");
},isPermanent:function(){
dojo.unimplemented("dojo.storage.isPermanent");
},getMaximumSize:function(){
dojo.unimplemented("dojo.storage.getMaximumSize");
},hasSettingsUI:function(){
return false;
},showSettingsUI:function(){
dojo.unimplemented("dojo.storage.showSettingsUI");
},hideSettingsUI:function(){
dojo.unimplemented("dojo.storage.hideSettingsUI");
},getType:function(){
dojo.unimplemented("dojo.storage.getType");
},isValidKey:function(_3fa){
if((_3fa==null)||(typeof _3fa=="undefined")){
return false;
}
return /^[0-9A-Za-z_]*$/.test(_3fa);
}});
dojo.storage.manager=new function(){
this.currentProvider=null;
this.available=false;
this.initialized=false;
this.providers=[];
this["namespace"]="dojo.storage";
this.initialize=function(){
this.autodetect();
};
this.register=function(name,_3fc){
this.providers[this.providers.length]=_3fc;
this.providers[name]=_3fc;
};
this.setProvider=function(_3fd){
};
this.autodetect=function(){
if(this.initialized==true){
return;
}
var _3fe=null;
for(var i=0;i<this.providers.length;i++){
_3fe=this.providers[i];
if(_3fe.isAvailable()){
break;
}
}
if(_3fe==null){
this.initialized=true;
this.available=false;
this.currentProvider=null;
dojo.raise("No storage provider found for this platform");
}
this.currentProvider=_3fe;
for(var i in _3fe){
dojo.storage[i]=_3fe[i];
}
dojo.storage.manager=this;
dojo.storage.initialize();
this.initialized=true;
this.available=true;
};
this.isAvailable=function(){
return this.available;
};
this.isInitialized=function(){
if(dojo.flash.ready==false){
return false;
}else{
return this.initialized;
}
};
this.supportsProvider=function(_400){
try{
var _401=eval("new "+_400+"()");
var _402=_401.isAvailable();
if(_402==null||typeof _402=="undefined"){
return false;
}
return _402;
}
catch(exception){
dojo.debug("exception="+exception);
return false;
}
};
this.getProvider=function(){
return this.currentProvider;
};
this.loaded=function(){
};
};
dojo.provide("dojo.json");
dojo.json={jsonRegistry:new dojo.AdapterRegistry(),register:function(name,_404,wrap,_406){
dojo.json.jsonRegistry.register(name,_404,wrap,_406);
},evalJson:function(json){
try{
return eval("("+json+")");
}
catch(e){
dojo.debug(e);
return json;
}
},serialize:function(o){
var _409=typeof (o);
if(_409=="undefined"){
return "undefined";
}else{
if((_409=="number")||(_409=="boolean")){
return o+"";
}else{
if(o===null){
return "null";
}
}
}
if(_409=="string"){
return dojo.string.escapeString(o);
}
var me=arguments.callee;
var _40b;
if(typeof (o.__json__)=="function"){
_40b=o.__json__();
if(o!==_40b){
return me(_40b);
}
}
if(typeof (o.json)=="function"){
_40b=o.json();
if(o!==_40b){
return me(_40b);
}
}
if(_409!="function"&&typeof (o.length)=="number"){
var res=[];
for(var i=0;i<o.length;i++){
var val=me(o[i]);
if(typeof (val)!="string"){
val="undefined";
}
res.push(val);
}
return "["+res.join(",")+"]";
}
try{
window.o=o;
_40b=dojo.json.jsonRegistry.match(o);
return me(_40b);
}
catch(e){
}
if(_409=="function"){
return null;
}
res=[];
for(var k in o){
var _410;
if(typeof (k)=="number"){
_410="\""+k+"\"";
}else{
if(typeof (k)=="string"){
_410=dojo.string.escapeString(k);
}else{
continue;
}
}
val=me(o[k]);
if(typeof (val)!="string"){
continue;
}
res.push(_410+":"+val);
}
return "{"+res.join(",")+"}";
}};
dojo.provide("dojo.storage.dashboard");
dojo.storage.dashboard.StorageProvider=function(){
this.initialized=false;
};
dojo.inherits(dojo.storage.dashboard.StorageProvider,dojo.storage.StorageProvider);
dojo.lang.extend(dojo.storage.dashboard.StorageProvider,{storageOnLoad:function(){
this.initialized=true;
},set:function(key,_412,ns){
if(ns&&widget.system){
widget.system("/bin/mkdir "+ns);
var _414=widget.system("/bin/echo "+_412+" >"+ns+"/"+key);
if(_414.errorString){
return false;
}
return true;
}
return widget.setPreferenceForKey(dojo.json.serialize(_412),key);
},get:function(key,ns){
if(ns&&widget.system){
var _417=widget.system("/bin/cat "+ns+"/"+key);
if(_417.errorString){
return "";
}
return _417.outputString;
}
return dojo.json.evalJson(widget.preferenceForKey(key));
}});
dojo.storage.setProvider(new dojo.storage.dashboard.StorageProvider());
dojo.provide("dojo.storage.*");


__CPAN_EDITION__ dashboard build.txt

Files baked into this package:

dojoGuardStart.js,
../src/bootstrap1.js,
../src/loader.js,
dojoGuardEnd.js,
../src/hostenv_browser.js,
../src/hostenv_dashboard.js,
../src/bootstrap2.js,
../src/lang/common.js,
../src/lang.js,
../src/lang/array.js,
../src/lang/extras.js,
../src/lang/func.js,
../src/event/common.js,
../src/event/topic.js,
../src/event/browser.js,
../src/event/__package__.js,
../src/string/common.js,
../src/string.js,
../src/io/common.js,
../src/string/extras.js,
../src/dom.js,
../src/undo/browser.js,
../src/io/BrowserIO.js,
../src/io/cookie.js,
../src/io/__package__.js,
../src/lang/type.js,
../src/lang/assert.js,
../src/AdapterRegistry.js,
../src/lang/repr.js,
../src/lang/declare.js,
../src/lang/__package__.js,
../src/storage.js,
../src/json.js,
../src/storage/dashboard.js,
../src/storage/__package__.js

		
__CPAN_EDITION__ editor dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:0,flag:"",revision:Number("$Rev: 6258 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
return _6e?_6e.toLowerCase():dojo.locale;
};
dojo.hostenv.searchLocalePath=function(_6f,_70,_71){
_6f=dojo.hostenv.normalizeLocale(_6f);
var _72=_6f.split("-");
var _73=[];
for(var i=_72.length;i>0;i--){
_73.push(_72.slice(0,i).join("-"));
}
_73.push(false);
if(_70){
_73.reverse();
}
for(var j=_73.length-1;j>=0;j--){
var loc=_73[j]||"ROOT";
var _77=_71(loc);
if(_77){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_78){
_78=dojo.hostenv.normalizeLocale(_78);
dojo.hostenv.searchLocalePath(_78,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7b=djConfig.extraLocale||[];
for(var i=0;i<_7b.length;i++){
preload(_7b[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7d,_7e,_7f){
dojo.hostenv.preloadLocalizations();
var _80=[_7d,"nls",_7e].join(".");
var _81=dojo.hostenv.findModule(_80);
if(_81){
if(djConfig.localizationComplete&&_81._built){
return;
}
var _82=dojo.hostenv.normalizeLocale(_7f).replace("-","_");
var _83=_80+"."+_82;
if(dojo.hostenv.findModule(_83)){
return;
}
}
_81=dojo.hostenv.startPackage(_80);
var _84=dojo.hostenv.getModuleSymbols(_7d);
var _85=_84.concat("nls").join("/");
var _86;
dojo.hostenv.searchLocalePath(_7f,false,function(loc){
var _88=loc.replace("-","_");
var _89=_80+"."+_88;
var _8a=false;
if(!dojo.hostenv.findModule(_89)){
dojo.hostenv.startPackage(_89);
var _8b=[_85];
if(loc!="ROOT"){
_8b.push(loc);
}
_8b.push(_7e);
var _8c=_8b.join("/")+".js";
_8a=dojo.hostenv.loadPath(_8c,null,function(_8d){
var _8e=function(){
};
_8e.prototype=_86;
_81[_88]=new _8e();
for(var j in _8d){
_81[_88][j]=_8d[j];
}
});
}else{
_8a=true;
}
if(_8a&&_81[_88]){
_86=_81[_88];
}else{
_81[_88]=_86;
}
});
};
(function(){
var _90=djConfig.extraLocale;
if(_90){
if(!_90 instanceof Array){
_90=[_90];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_94){
req(m,b,_94);
if(_94){
return;
}
for(var i=0;i<_90.length;i++){
req(m,b,_90[i]);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _96=document.location.toString();
var _97=_96.split("?",2);
if(_97.length>1){
var _98=_97[1];
var _99=_98.split("&");
for(var x in _99){
var sp=_99[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _9d=document.getElementsByTagName("script");
var _9e=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_9d.length;i++){
var src=_9d[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_9e);
if(m){
var _a2=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_a2+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_a2;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_a2;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _aa=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_aa>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_aa+6,_aa+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _ac=window["document"];
var tdi=_ac["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b0=null;
var _b1=null;
try{
_b0=new XMLHttpRequest();
}
catch(e){
}
if(!_b0){
for(var i=0;i<3;++i){
var _b3=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b0=new ActiveXObject(_b3);
}
catch(e){
_b1=e;
}
if(_b0){
dojo.hostenv._XMLHTTP_PROGIDS=[_b3];
break;
}
}
}
if(!_b0){
return dojo.raise("XMLHTTP not available",_b1);
}
return _b0;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_b5,_b6){
if(!_b5){
this._blockAsync=true;
}
var _b7=this.getXmlhttpObject();
function isDocumentOk(_b8){
var _b9=_b8["status"];
return Boolean((!_b9)||((200<=_b9)&&(300>_b9))||(_b9==304));
}
if(_b5){
var _ba=this,_bb=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_b7.onreadystatechange=function(){
if(_bb){
gbl.clearTimeout(_bb);
_bb=null;
}
if(_ba._blockAsync||(xhr&&xhr._blockAsync)){
_bb=gbl.setTimeout(function(){
_b7.onreadystatechange.apply(this);
},10);
}else{
if(4==_b7.readyState){
if(isDocumentOk(_b7)){
_b5(_b7.responseText);
}
}
}
};
}
_b7.open("GET",uri,_b5?true:false);
try{
_b7.send(null);
if(_b5){
return null;
}
if(!isDocumentOk(_b7)){
var err=Error("Unable to load "+uri+" status:"+_b7.status);
err.status=_b7.status;
err.responseText=_b7.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_b6)&&(!_b5)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _b7.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_bf){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_bf);
}else{
try{
var _c0=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c0){
_c0=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_bf));
_c0.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_bf+"</div>");
}
catch(e2){
window.status=_bf;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_c2,_c3,fp,_c5){
var _c6=_c2["on"+_c3]||function(){
};
_c2["on"+_c3]=function(){
fp.apply(_c2,arguments);
_c6.apply(_c2,arguments);
};
return true;
}
function dj_load_init(e){
var _c8=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_c8!="domcontentloaded"&&_c8!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _c9=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_c9();
dojo.hostenv.modulesLoaded();
}else{
dojo.addOnLoad(_c9);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _cb=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_cb=_cb.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_cb=_cb.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_cb.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _cc=new dojo.xml.Parse();
if(_cb.length>0){
for(var x=0;x<_cb.length;x++){
var _ce=document.getElementById(_cb[x]);
if(!_ce){
continue;
}
var _cf=_cc.parseElement(_ce,null,true);
dojo.widget.getParser().createComponents(_cf);
}
}else{
if(djConfig.parseWidgets){
var _cf=_cc.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_cf);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_d4,_d5){
dj_currentContext=_d4;
dj_currentDocument=_d5;
};
dojo._fireCallback=function(_d6,_d7,_d8){
if((_d7)&&((typeof _d6=="string")||(_d6 instanceof String))){
_d6=_d7[_d6];
}
return (_d7?_d6.apply(_d7,_d8||[]):_d6());
};
dojo.withGlobal=function(_d9,_da,_db,_dc){
var _dd;
var _de=dj_currentContext;
var _df=dj_currentDocument;
try{
dojo.setContext(_d9,_d9.document);
_dd=dojo._fireCallback(_da,_db,_dc);
}
finally{
dojo.setContext(_de,_df);
}
return _dd;
};
dojo.withDoc=function(_e0,_e1,_e2,_e3){
var _e4;
var _e5=dj_currentDocument;
try{
dj_currentDocument=_e0;
_e4=dojo._fireCallback(_e1,_e2,_e3);
}
finally{
dj_currentDocument=_e5;
}
return _e4;
};
}
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _e6=false;
var _e7=false;
var _e8=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_e6=true;
}else{
if(typeof this["load"]=="function"){
_e7=true;
}else{
if(window.widget){
_e8=true;
}
}
}
var _e9=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_e9.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_e6)&&(!_e8)){
_e9.push("browser_debug.js");
}
var _ea=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_ea=djConfig["baseLoaderUri"];
}
for(var x=0;x<_e9.length;x++){
var _ec=_ea+"src/"+_e9[x];
if(_e6||_e7){
load(_ec);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_ec+"'></scr"+"ipt>");
}
catch(e){
var _ed=document.createElement("script");
_ed.src=_ec;
document.getElementsByTagName("head")[0].appendChild(_ed);
}
}
}
})();
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(E){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _ef=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_ef.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_f1,_f2){
var _f3=_f1.firstChild;
while(_f3&&_f3.nodeType!=dojo.dom.ELEMENT_NODE){
_f3=_f3.nextSibling;
}
if(_f2&&_f3&&_f3.tagName&&_f3.tagName.toLowerCase()!=_f2.toLowerCase()){
_f3=dojo.dom.nextElement(_f3,_f2);
}
return _f3;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_f4,_f5){
var _f6=_f4.lastChild;
while(_f6&&_f6.nodeType!=dojo.dom.ELEMENT_NODE){
_f6=_f6.previousSibling;
}
if(_f5&&_f6&&_f6.tagName&&_f6.tagName.toLowerCase()!=_f5.toLowerCase()){
_f6=dojo.dom.prevElement(_f6,_f5);
}
return _f6;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(_f7,_f8){
if(!_f7){
return null;
}
do{
_f7=_f7.nextSibling;
}while(_f7&&_f7.nodeType!=dojo.dom.ELEMENT_NODE);
if(_f7&&_f8&&_f8.toLowerCase()!=_f7.tagName.toLowerCase()){
return dojo.dom.nextElement(_f7,_f8);
}
return _f7;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(_f9,_fa){
if(!_f9){
return null;
}
if(_fa){
_fa=_fa.toLowerCase();
}
do{
_f9=_f9.previousSibling;
}while(_f9&&_f9.nodeType!=dojo.dom.ELEMENT_NODE);
if(_f9&&_fa&&_fa.toLowerCase()!=_f9.tagName.toLowerCase()){
return dojo.dom.prevElement(_f9,_fa);
}
return _f9;
};
dojo.dom.moveChildren=function(_fb,_fc,_fd){
var _fe=0;
if(_fd){
while(_fb.hasChildNodes()&&_fb.firstChild.nodeType==dojo.dom.TEXT_NODE){
_fb.removeChild(_fb.firstChild);
}
while(_fb.hasChildNodes()&&_fb.lastChild.nodeType==dojo.dom.TEXT_NODE){
_fb.removeChild(_fb.lastChild);
}
}
while(_fb.hasChildNodes()){
_fc.appendChild(_fb.firstChild);
_fe++;
}
return _fe;
};
dojo.dom.copyChildren=function(_ff,_100,trim){
var _102=_ff.cloneNode(true);
return this.moveChildren(_102,_100,trim);
};
dojo.dom.removeChildren=function(node){
var _104=node.childNodes.length;
while(node.hasChildNodes()){
node.removeChild(node.firstChild);
}
return _104;
};
dojo.dom.replaceChildren=function(node,_106){
dojo.dom.removeChildren(node);
node.appendChild(_106);
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_109,_10a){
var _10b=[];
var _10c=(_109&&(_109 instanceof Function||typeof _109=="function"));
while(node){
if(!_10c||_109(node)){
_10b.push(node);
}
if(_10a&&_10b.length>0){
return _10b[0];
}
node=node.parentNode;
}
if(_10a){
return null;
}
return _10b;
};
dojo.dom.getAncestorsByTag=function(node,tag,_10f){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_10f);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_114,_115){
if(_115&&node){
node=node.parentNode;
}
while(node){
if(node==_114){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _118=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _119=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_119.length;i++){
try{
doc=new ActiveXObject(_119[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_118.implementation)&&(_118.implementation.createDocument)){
doc=_118.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_11c){
if(!_11c){
_11c="text/xml";
}
if(!dj_undef("DOMParser")){
var _11d=new DOMParser();
return _11d.parseFromString(str,_11c);
}else{
if(!dj_undef("ActiveXObject")){
var _11e=dojo.dom.createDocument();
if(_11e){
_11e.async=false;
_11e.loadXML(str);
return _11e;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _11f=dojo.doc();
if(_11f.createElement){
var tmp=_11f.createElement("xml");
tmp.innerHTML=str;
if(_11f.implementation&&_11f.implementation.createDocument){
var _121=_11f.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_121.importNode(tmp.childNodes.item(i),true);
}
return _121;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_124){
if(_124.firstChild){
_124.insertBefore(node,_124.firstChild);
}else{
_124.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_127){
if(_127!=true&&(node===ref||node.nextSibling===ref)){
return false;
}
var _128=ref.parentNode;
_128.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_12b){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_12b!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_12b);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_12f){
if((!node)||(!ref)||(!_12f)){
return false;
}
switch(_12f.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_131,_132){
var _133=_131.childNodes;
if(!_133.length){
_131.appendChild(node);
return true;
}
var _134=null;
for(var i=0;i<_133.length;i++){
var _136=_133.item(i)["getAttribute"]?parseInt(_133.item(i).getAttribute("dojoinsertionindex")):-1;
if(_136<_132){
_134=_133.item(i);
}
}
if(_134){
return dojo.dom.insertAfter(node,_134);
}else{
return dojo.dom.insertBefore(node,_133.item(0));
}
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _139=dojo.doc();
dojo.dom.replaceChildren(node,_139.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _13a="";
if(node==null){
return _13a;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_13a+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_13a+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _13a;
}
};
dojo.dom.hasParent=function(node){
return node&&node.parentNode&&dojo.dom.isNode(node.parentNode);
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_140,_141,_142){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_140,_141,_142);
}else{
var _143=elem.ownerDocument;
var _144=_143.createNode(2,_141,_140);
_144.nodeValue=_142;
elem.setAttributeNode(_144);
}
};
dojo.provide("dojo.xml.Parse");
dojo.xml.Parse=function(){
function getTagName(node){
return ((node)&&(node.tagName)?node.tagName.toLowerCase():"");
}
function getDojoTagName(node){
var _147=getTagName(node);
if(!_147){
return "";
}
if((dojo.widget)&&(dojo.widget.tags[_147])){
return _147;
}
var p=_147.indexOf(":");
if(p>=0){
return _147;
}
if(_147.substr(0,5)=="dojo:"){
return _147;
}
if(dojo.render.html.capable&&dojo.render.html.ie&&node.scopeName!="HTML"){
return node.scopeName.toLowerCase()+":"+_147;
}
if(_147.substr(0,4)=="dojo"){
return "dojo:"+_147.substring(4);
}
var djt=node.getAttribute("dojoType")||node.getAttribute("dojotype");
if(djt){
if(djt.indexOf(":")<0){
djt="dojo:"+djt;
}
return djt.toLowerCase();
}
djt=node.getAttributeNS&&node.getAttributeNS(dojo.dom.dojoml,"type");
if(djt){
return "dojo:"+djt.toLowerCase();
}
try{
djt=node.getAttribute("dojo:type");
}
catch(e){
}
if(djt){
return "dojo:"+djt.toLowerCase();
}
if((!dj_global["djConfig"])||(djConfig["ignoreClassNames"])){
var _14a=node.className||node.getAttribute("class");
if((_14a)&&(_14a.indexOf)&&(_14a.indexOf("dojo-")!=-1)){
var _14b=_14a.split(" ");
for(var x=0,c=_14b.length;x<c;x++){
if(_14b[x].slice(0,5)=="dojo-"){
return "dojo:"+_14b[x].substr(5).toLowerCase();
}
}
}
}
return "";
}
this.parseElement=function(node,_14f,_150,_151){
var _152={};
var _153=getTagName(node);
if((_153)&&(_153.indexOf("/")==0)){
return null;
}
var _154=true;
if(_150){
var _155=getDojoTagName(node);
_153=_155||_153;
_154=Boolean(_155);
}
if(node&&node.getAttribute&&node.getAttribute("parseWidgets")&&node.getAttribute("parseWidgets")=="false"){
return {};
}
_152[_153]=[];
var pos=_153.indexOf(":");
if(pos>0){
var ns=_153.substring(0,pos);
_152["ns"]=ns;
if((dojo.ns)&&(!dojo.ns.allow(ns))){
_154=false;
}
}
if(_154){
var _158=this.parseAttributes(node);
for(var attr in _158){
if((!_152[_153][attr])||(typeof _152[_153][attr]!="array")){
_152[_153][attr]=[];
}
_152[_153][attr].push(_158[attr]);
}
_152[_153].nodeRef=node;
_152.tagName=_153;
_152.index=_151||0;
}
var _15a=0;
for(var i=0;i<node.childNodes.length;i++){
var tcn=node.childNodes.item(i);
switch(tcn.nodeType){
case dojo.dom.ELEMENT_NODE:
_15a++;
var ctn=getDojoTagName(tcn)||getTagName(tcn);
if(!_152[ctn]){
_152[ctn]=[];
}
_152[ctn].push(this.parseElement(tcn,true,_150,_15a));
if((tcn.childNodes.length==1)&&(tcn.childNodes.item(0).nodeType==dojo.dom.TEXT_NODE)){
_152[ctn][_152[ctn].length-1].value=tcn.childNodes.item(0).nodeValue;
}
break;
case dojo.dom.TEXT_NODE:
if(node.childNodes.length==1){
_152[_153].push({value:node.childNodes.item(0).nodeValue});
}
break;
default:
break;
}
}
return _152;
};
this.parseAttributes=function(node){
var _15f={};
var atts=node.attributes;
var _161,i=0;
while((_161=atts[i++])){
if((dojo.render.html.capable)&&(dojo.render.html.ie)){
if(!_161){
continue;
}
if((typeof _161=="object")&&(typeof _161.nodeValue=="undefined")||(_161.nodeValue==null)||(_161.nodeValue=="")){
continue;
}
}
var nn=_161.nodeName.split(":");
nn=(nn.length==2)?nn[1]:_161.nodeName;
_15f[nn]={value:_161.nodeValue};
}
return _15f;
};
};
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_164,_165){
if(typeof _165!="function"){
dojo.raise("dojo.inherits: superclass argument ["+_165+"] must be a function (subclass: ["+_164+"']");
}
_164.prototype=new _165();
_164.prototype.constructor=_164;
_164.superclass=_165.prototype;
_164["super"]=_165.prototype;
};
dojo.lang._mixin=function(obj,_167){
var tobj={};
for(var x in _167){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_167[x])){
obj[x]=_167[x];
}
}
if(dojo.render.html.ie&&(typeof (_167["toString"])=="function")&&(_167["toString"]!=obj["toString"])&&(_167["toString"]!=tobj["toString"])){
obj.toString=_167.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_16b){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_16e,_16f){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_16e.prototype,arguments[i]);
}
return _16e;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_172,_173,_174,_175){
if(!dojo.lang.isArrayLike(_172)&&dojo.lang.isArrayLike(_173)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_172;
_172=_173;
_173=temp;
}
var _177=dojo.lang.isString(_172);
if(_177){
_172=_172.split("");
}
if(_175){
var step=-1;
var i=_172.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_172.length;
}
if(_174){
while(i!=end){
if(_172[i]===_173){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_172[i]==_173){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_17b,_17c,_17d){
return dojo.lang.find(_17b,_17c,_17d,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_17e,_17f){
return dojo.lang.find(_17e,_17f)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
if(!it){
return false;
}
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction()&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_189,_18a){
var fcn=(dojo.lang.isString(_18a)?_189[_18a]:_18a)||function(){
};
return function(){
return fcn.apply(_189,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_18c,_18d,_18e){
var nso=(_18d||dojo.lang.anon);
if((_18e)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_18c){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_18c;
return ret;
};
dojo.lang.forward=function(_192){
return function(){
return this[_192].apply(this,arguments);
};
};
dojo.lang.curry=function(ns,func){
var _195=[];
ns=ns||dj_global;
if(dojo.lang.isString(func)){
func=ns[func];
}
for(var x=2;x<arguments.length;x++){
_195.push(arguments[x]);
}
var _197=(func["__preJoinArity"]||func.length)-_195.length;
function gather(_198,_199,_19a){
var _19b=_19a;
var _19c=_199.slice(0);
for(var x=0;x<_198.length;x++){
_19c.push(_198[x]);
}
_19a=_19a-_198.length;
if(_19a<=0){
var res=func.apply(ns,_19c);
_19a=_19b;
return res;
}else{
return function(){
return gather(arguments,_19c,_19a);
};
}
}
return gather([],_195,_197);
};
dojo.lang.curryArguments=function(ns,func,args,_1a2){
var _1a3=[];
var x=_1a2||0;
for(x=_1a2;x<args.length;x++){
_1a3.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[ns,func].concat(_1a3));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1a9,_1aa){
if(!farr.length){
if(typeof _1aa=="function"){
_1aa();
}
return;
}
if((typeof _1a9=="undefined")&&(typeof cb=="number")){
_1a9=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1a9){
_1a9=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1a9,_1aa);
},_1a9);
};
dojo.provide("dojo.lang.array");
dojo.lang.has=function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
};
dojo.lang.isEmpty=function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _1af=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_1af++;
break;
}
}
return _1af==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
};
dojo.lang.map=function(arr,obj,_1b3){
var _1b4=dojo.lang.isString(arr);
if(_1b4){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_1b3)){
_1b3=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_1b3){
var _1b5=obj;
obj=_1b3;
_1b3=_1b5;
}
}
if(Array.map){
var _1b6=Array.map(arr,_1b3,obj);
}else{
var _1b6=[];
for(var i=0;i<arr.length;++i){
_1b6.push(_1b3.call(obj,arr[i]));
}
}
if(_1b4){
return _1b6.join("");
}else{
return _1b6;
}
};
dojo.lang.reduce=function(arr,_1b9,obj,_1bb){
var _1bc=_1b9;
var ob=obj?obj:dj_global;
dojo.lang.map(arr,function(val){
_1bc=_1bb.call(ob,_1bc,val);
});
return _1bc;
};
dojo.lang.forEach=function(_1bf,_1c0,_1c1){
if(dojo.lang.isString(_1bf)){
_1bf=_1bf.split("");
}
if(Array.forEach){
Array.forEach(_1bf,_1c0,_1c1);
}else{
if(!_1c1){
_1c1=dj_global;
}
for(var i=0,l=_1bf.length;i<l;i++){
_1c0.call(_1c1,_1bf[i],i,_1bf);
}
}
};
dojo.lang._everyOrSome=function(_1c4,arr,_1c6,_1c7){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_1c4?"every":"some"](arr,_1c6,_1c7);
}else{
if(!_1c7){
_1c7=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _1ca=_1c6.call(_1c7,arr[i],i,arr);
if(_1c4&&!_1ca){
return false;
}else{
if((!_1c4)&&(_1ca)){
return true;
}
}
}
return Boolean(_1c4);
}
};
dojo.lang.every=function(arr,_1cc,_1cd){
return this._everyOrSome(true,arr,_1cc,_1cd);
};
dojo.lang.some=function(arr,_1cf,_1d0){
return this._everyOrSome(false,arr,_1cf,_1d0);
};
dojo.lang.filter=function(arr,_1d2,_1d3){
var _1d4=dojo.lang.isString(arr);
if(_1d4){
arr=arr.split("");
}
var _1d5;
if(Array.filter){
_1d5=Array.filter(arr,_1d2,_1d3);
}else{
if(!_1d3){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_1d3=dj_global;
}
_1d5=[];
for(var i=0;i<arr.length;i++){
if(_1d2.call(_1d3,arr[i],i,arr)){
_1d5.push(arr[i]);
}
}
}
if(_1d4){
return _1d5.join("");
}else{
return _1d5;
}
};
dojo.lang.unnest=function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
};
dojo.lang.toArray=function(_1da,_1db){
var _1dc=[];
for(var i=_1db||0;i<_1da.length;i++){
_1dc.push(_1da[i]);
}
return _1dc;
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_1df){
var _1e0=window,_1e1=2;
if(!dojo.lang.isFunction(func)){
_1e0=func;
func=_1df;
_1df=arguments[2];
_1e1++;
}
if(dojo.lang.isString(func)){
func=_1e0[func];
}
var args=[];
for(var i=_1e1;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_1e0,args);
},_1df);
};
dojo.lang.clearTimeout=function(_1e4){
dojo.global().clearTimeout(_1e4);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_1ed,_1ee,_1ef){
with(dojo.parseObjPath(_1ed,_1ee,_1ef)){
return dojo.evalProp(prop,obj,_1ef);
}
};
dojo.lang.setObjPathValue=function(_1f0,_1f1,_1f2,_1f3){
if(arguments.length<4){
_1f3=true;
}
with(dojo.parseObjPath(_1f0,_1f2,_1f3)){
if(obj&&(_1f3||(prop in obj))){
obj[prop]=_1f1;
}
}
};
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_1f4,_1f5,init,_1f7){
if((dojo.lang.isFunction(_1f7))||((!_1f7)&&(!dojo.lang.isFunction(init)))){
var temp=_1f7;
_1f7=init;
init=temp;
}
var _1f9=[];
if(dojo.lang.isArray(_1f5)){
_1f9=_1f5;
_1f5=_1f9.shift();
}
if(!init){
init=dojo.evalObjPath(_1f4,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_1f5?_1f5.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _1f5();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_1f9;
for(var i=0,l=_1f9.length;i<l;i++){
dojo.lang.extend(ctor,_1f9[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_1f4;
if(dojo.lang.isArray(_1f7)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_1f7));
}else{
dojo.lang.extend(ctor,(_1f7)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
dojo.lang.setObjPathValue(_1f4,ctor,null,true);
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_203,_204,args){
var _206,_207=this.___proto;
this.___proto=_203;
try{
_206=_203[_204].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_207;
}
return _206;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.ns");
dojo.ns={namespaces:{},failed:{},loading:{},loaded:{},register:function(name,_20c,_20d,_20e){
if(!_20e||!this.namespaces[name]){
this.namespaces[name]=new dojo.ns.Ns(name,_20c,_20d);
}
},allow:function(name){
if(this.failed[name]){
return false;
}
if((djConfig.excludeNamespace)&&(dojo.lang.inArray(djConfig.excludeNamespace,name))){
return false;
}
return ((name==this.dojo)||(!djConfig.includeNamespace)||(dojo.lang.inArray(djConfig.includeNamespace,name)));
},get:function(name){
return this.namespaces[name];
},require:function(name){
var ns=this.namespaces[name];
if((ns)&&(this.loaded[name])){
return ns;
}
if(!this.allow(name)){
return false;
}
if(this.loading[name]){
dojo.debug("dojo.namespace.require: re-entrant request to load namespace \""+name+"\" must fail.");
return false;
}
var req=dojo.require;
this.loading[name]=true;
try{
if(name=="dojo"){
req("dojo.namespaces.dojo");
}else{
if(!dojo.hostenv.moduleHasPrefix(name)){
dojo.registerModulePath(name,"../"+name);
}
req([name,"manifest"].join("."),false,true);
}
if(!this.namespaces[name]){
this.failed[name]=true;
}
}
finally{
this.loading[name]=false;
}
return this.namespaces[name];
}};
dojo.ns.Ns=function(name,_215,_216){
this.name=name;
this.module=_215;
this.resolver=_216;
this._loaded=[];
this._failed=[];
};
dojo.ns.Ns.prototype.resolve=function(name,_218,_219){
if(!this.resolver||djConfig["skipAutoRequire"]){
return false;
}
var _21a=this.resolver(name,_218);
if((_21a)&&(!this._loaded[_21a])&&(!this._failed[_21a])){
var req=dojo.require;
req(_21a,false,true);
if(dojo.hostenv.findModule(_21a,false)){
this._loaded[_21a]=true;
}else{
if(!_219){
dojo.raise("dojo.ns.Ns.resolve: module '"+_21a+"' not found after loading via namespace '"+this.name+"'");
}
this._failed[_21a]=true;
}
}
return Boolean(this._loaded[_21a]);
};
dojo.registerNamespace=function(name,_21d,_21e){
dojo.ns.register.apply(dojo.ns,arguments);
};
dojo.registerNamespaceResolver=function(name,_220){
var n=dojo.ns.namespaces[name];
if(n){
n.resolver=_220;
}
};
dojo.registerNamespaceManifest=function(_222,path,name,_225,_226){
dojo.registerModulePath(name,path);
dojo.registerNamespace(name,_225,_226);
};
dojo.registerNamespace("dojo","dojo.widget");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_228){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _22b=dl.nameAnonFunc(args[2],ao.adviceObj,_228);
ao.adviceFunc=_22b;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _22b=dl.nameAnonFunc(args[0],ao.srcObj,_228);
ao.srcFunc=_22b;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _22b=dl.nameAnonFunc(args[1],dj_global,_228);
ao.srcFunc=_22b;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _22b=dl.nameAnonFunc(args[3],dj_global,_228);
ao.adviceObj=dj_global;
ao.adviceFunc=_22b;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _22b=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_228);
ao.aroundFunc=_22b;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _22d={};
for(var x in ao){
_22d[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_22d.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_22d));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _235;
if((arguments.length==1)&&(typeof a1=="object")){
_235=a1;
}else{
_235={srcObj:a1,srcFunc:a2};
}
_235.adviceFunc=function(){
var _236=[];
for(var x=0;x<arguments.length;x++){
_236.push(arguments[x]);
}
dojo.debug("("+_235.srcObj+")."+_235.srcFunc,":",_236.join(", "));
};
this.kwConnect(_235);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this._kwConnectImpl=function(_23d,_23e){
var fn=(_23e)?"disconnect":"connect";
if(typeof _23d["srcFunc"]=="function"){
_23d.srcObj=_23d["srcObj"]||dj_global;
var _240=dojo.lang.nameAnonFunc(_23d.srcFunc,_23d.srcObj,true);
_23d.srcFunc=_240;
}
if(typeof _23d["adviceFunc"]=="function"){
_23d.adviceObj=_23d["adviceObj"]||dj_global;
var _240=dojo.lang.nameAnonFunc(_23d.adviceFunc,_23d.adviceObj,true);
_23d.adviceFunc=_240;
}
_23d.srcObj=_23d["srcObj"]||dj_global;
_23d.adviceObj=_23d["adviceObj"]||_23d["targetObj"]||dj_global;
_23d.adviceFunc=_23d["adviceFunc"]||_23d["targetFunc"];
return dojo.event[fn](_23d);
};
this.kwConnect=function(_241){
return this._kwConnectImpl(_241,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
return mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
};
this.kwDisconnect=function(_244){
return this._kwConnectImpl(_244,true);
};
};
dojo.event.MethodInvocation=function(_245,obj,args){
this.jp_=_245;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_24d){
this.object=obj||dj_global;
this.methodname=_24d;
this.methodfunc=this.object[_24d];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_24f){
if(!obj){
obj=dj_global;
}
if(!obj[_24f]){
obj[_24f]=function(){
};
if(!obj[_24f]){
dojo.raise("Cannot set do-nothing method on that object "+_24f);
}
}else{
if((!dojo.lang.isFunction(obj[_24f]))&&(!dojo.lang.isAlien(obj[_24f]))){
return null;
}
}
var _250=_24f+"$joinpoint";
var _251=_24f+"$joinpoint$method";
var _252=obj[_250];
if(!_252){
var _253=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_253=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_250,_251,_24f]);
}
}
var _254=obj[_24f].length;
obj[_251]=obj[_24f];
_252=obj[_250]=new dojo.event.MethodJoinPoint(obj,_251);
obj[_24f]=function(){
var args=[];
if((_253)&&(!arguments.length)){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(_253)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _252.run.apply(_252,args);
};
obj[_24f].__preJoinArity=_254;
}
return _252;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _25a=[];
for(var x=0;x<args.length;x++){
_25a[x]=args[x];
}
var _25c=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _25e=marr[0]||dj_global;
var _25f=marr[1];
if(!_25e[_25f]){
dojo.raise("function \""+_25f+"\" does not exist on \""+_25e+"\"");
}
var _260=marr[2]||dj_global;
var _261=marr[3];
var msg=marr[6];
var _263;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _25e[_25f].apply(_25e,to.args);
}};
to.args=_25a;
var _265=parseInt(marr[4]);
var _266=((!isNaN(_265))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _269=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_25c(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_261){
_260[_261].call(_260,to);
}else{
if((_266)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_25e[_25f].call(_25e,to);
}else{
_25e[_25f].apply(_25e,args);
}
},_265);
}else{
if(msg){
_25e[_25f].call(_25e,to);
}else{
_25e[_25f].apply(_25e,args);
}
}
}
};
var _26c=function(){
if(this.squelch){
try{
return _25c.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _25c.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_26c);
}
var _26d;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_26d=mi.proceed();
}else{
if(this.methodfunc){
_26d=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_26c);
}
return (this.methodfunc)?_26d:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"]);
},addAdvice:function(_272,_273,_274,_275,_276,_277,once,_279,rate,_27b){
var arr=this.getArr(_276);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_272,_273,_274,_275,_279,rate,_27b];
if(once){
if(this.hasAdvice(_272,_273,_276,arr)>=0){
return;
}
}
if(_277=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_27e,_27f,_280,arr){
if(!arr){
arr=this.getArr(_280);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _27f=="object")?(new String(_27f)).toString():_27f;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_27e)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_286,_287,_288,once){
var arr=this.getArr(_288);
var ind=this.hasAdvice(_286,_287,_288,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_286,_287,_288,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_28c){
if(!this.topics[_28c]){
this.topics[_28c]=new this.TopicImpl(_28c);
}
return this.topics[_28c];
};
this.registerPublisher=function(_28d,obj,_28f){
var _28d=this.getTopic(_28d);
_28d.registerPublisher(obj,_28f);
};
this.subscribe=function(_290,obj,_292){
var _290=this.getTopic(_290);
_290.subscribe(obj,_292);
};
this.unsubscribe=function(_293,obj,_295){
var _293=this.getTopic(_293);
_293.unsubscribe(obj,_295);
};
this.destroy=function(_296){
this.getTopic(_296).destroy();
delete this.topics[_296];
};
this.publishApply=function(_297,args){
var _297=this.getTopic(_297);
_297.sendMessage.apply(_297,args);
};
this.publish=function(_299,_29a){
var _299=this.getTopic(_299);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_299.sendMessage.apply(_299,args);
};
};
dojo.event.topic.TopicImpl=function(_29d){
this.topicName=_29d;
this.subscribe=function(_29e,_29f){
var tf=_29f||_29e;
var to=(!_29f)?dj_global:_29e;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_2a2,_2a3){
var tf=(!_2a3)?_2a2:_2a3;
var to=(!_2a3)?null:_2a2;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_2a6){
this._getJoinPoint().squelch=_2a6;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_2a7,_2a8){
dojo.event.connect(_2a7,_2a8,this,"sendMessage");
};
this.sendMessage=function(_2a9){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_2ac){
var na;
var tna;
if(_2ac){
tna=_2ac.all||_2ac.getElementsByTagName("*");
na=[_2ac];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _2b0={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _2b4=0;
this.normalizedEventName=function(_2b5){
switch(_2b5){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _2b5;
break;
default:
return _2b5.toLowerCase();
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_2b9){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_2b9.length;x++){
node.__clobberAttrs__.push(_2b9[x]);
}
};
this.removeListener=function(node,_2bc,fp,_2be){
if(!_2be){
var _2be=false;
}
_2bc=dojo.event.browser.normalizedEventName(_2bc);
if((_2bc=="onkey")||(_2bc=="key")){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_2be);
}
_2bc="onkeypress";
}
if(_2bc.substr(0,2)=="on"){
_2bc=_2bc.substr(2);
}
if(node.removeEventListener){
node.removeEventListener(_2bc,fp,_2be);
}
};
this.addListener=function(node,_2c0,fp,_2c2,_2c3){
if(!node){
return;
}
if(!_2c2){
var _2c2=false;
}
_2c0=dojo.event.browser.normalizedEventName(_2c0);
if((_2c0=="onkey")||(_2c0=="key")){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_2c2,_2c3);
}
_2c0="onkeypress";
}
if(_2c0.substr(0,2)!="on"){
_2c0="on"+_2c0;
}
if(!_2c3){
var _2c4=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_2c2){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_2c4=fp;
}
if(node.addEventListener){
node.addEventListener(_2c0.substr(2),_2c4,_2c2);
return _2c4;
}else{
if(typeof node[_2c0]=="function"){
var _2c7=node[_2c0];
node[_2c0]=function(e){
_2c7(e);
return _2c4(e);
};
}else{
node[_2c0]=_2c4;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_2c0]);
}
return _2c4;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_2ca,_2cb){
if(typeof _2ca!="function"){
dojo.raise("listener not a function: "+_2ca);
}
dojo.event.browser.currentEvent.currentTarget=_2cb;
return _2ca.call(_2cb,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_2ce){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _2d0=evt.keyCode;
if(_2d0>=65&&_2d0<=90&&evt.shiftKey==false){
_2d0+=32;
}
if(_2d0>=1&&_2d0<=26&&evt.ctrlKey){
_2d0+=96;
}
evt.key=String.fromCharCode(_2d0);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _2d0=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_2d0+=32;
}
evt.key=String.fromCharCode(_2d0);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
default:
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_2ce?_2ce:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _2d2=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_2d2.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_2d2.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.returnValue=false;
evt.cancelBubble=true;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.provide("dojo.event.*");
dojo.provide("dojo.widget.Manager");
dojo.widget.manager=new function(){
this.widgets=[];
this.widgetIds=[];
this.topWidgets={};
var _2d4={};
var _2d5=[];
this.getUniqueId=function(_2d6){
var _2d7;
do{
_2d7=_2d6+"_"+(_2d4[_2d6]!=undefined?++_2d4[_2d6]:_2d4[_2d6]=0);
}while(this.getWidgetById(_2d7));
return _2d7;
};
this.add=function(_2d8){
this.widgets.push(_2d8);
if(!_2d8.extraArgs["id"]){
_2d8.extraArgs["id"]=_2d8.extraArgs["ID"];
}
if(_2d8.widgetId==""){
if(_2d8["id"]){
_2d8.widgetId=_2d8["id"];
}else{
if(_2d8.extraArgs["id"]){
_2d8.widgetId=_2d8.extraArgs["id"];
}else{
_2d8.widgetId=this.getUniqueId(_2d8.widgetType);
}
}
}
if(this.widgetIds[_2d8.widgetId]){
dojo.debug("widget ID collision on ID: "+_2d8.widgetId);
}
this.widgetIds[_2d8.widgetId]=_2d8;
};
this.destroyAll=function(){
for(var x=this.widgets.length-1;x>=0;x--){
try{
this.widgets[x].destroy(true);
delete this.widgets[x];
}
catch(e){
}
}
};
this.remove=function(_2da){
if(dojo.lang.isNumber(_2da)){
var tw=this.widgets[_2da].widgetId;
delete this.widgetIds[tw];
this.widgets.splice(_2da,1);
}else{
this.removeById(_2da);
}
};
this.removeById=function(id){
if(!dojo.lang.isString(id)){
id=id["widgetId"];
if(!id){
dojo.debug("invalid widget or id passed to removeById");
return;
}
}
for(var i=0;i<this.widgets.length;i++){
if(this.widgets[i].widgetId==id){
this.remove(i);
break;
}
}
};
this.getWidgetById=function(id){
if(dojo.lang.isString(id)){
return this.widgetIds[id];
}
return id;
};
this.getWidgetsByType=function(type){
var lt=type.toLowerCase();
var _2e1=(type.indexOf(":")<0?function(x){
return x.widgetType.toLowerCase();
}:function(x){
return x.getNamespacedType();
});
var ret=[];
dojo.lang.forEach(this.widgets,function(x){
if(_2e1(x)==lt){
ret.push(x);
}
});
return ret;
};
this.getWidgetsByFilter=function(_2e6,_2e7){
var ret=[];
dojo.lang.every(this.widgets,function(x){
if(_2e6(x)){
ret.push(x);
if(_2e7){
return false;
}
}
return true;
});
return (_2e7?ret[0]:ret);
};
this.getAllWidgets=function(){
return this.widgets.concat();
};
this.getWidgetByNode=function(node){
var w=this.getAllWidgets();
node=dojo.byId(node);
for(var i=0;i<w.length;i++){
if(w[i].domNode==node){
return w[i];
}
}
return null;
};
this.byId=this.getWidgetById;
this.byType=this.getWidgetsByType;
this.byFilter=this.getWidgetsByFilter;
this.byNode=this.getWidgetByNode;
var _2ed={};
var _2ee=["dojo.widget"];
for(var i=0;i<_2ee.length;i++){
_2ee[_2ee[i]]=true;
}
this.registerWidgetPackage=function(_2f0){
if(!_2ee[_2f0]){
_2ee[_2f0]=true;
_2ee.push(_2f0);
}
};
this.getWidgetPackageList=function(){
return dojo.lang.map(_2ee,function(elt){
return (elt!==true?elt:undefined);
});
};
this.getImplementation=function(_2f2,_2f3,_2f4,ns){
var impl=this.getImplementationName(_2f2,ns);
if(impl){
var ret=_2f3?new impl(_2f3):new impl();
return ret;
}
};
function buildPrefixCache(){
for(var _2f8 in dojo.render){
if(dojo.render[_2f8]["capable"]===true){
var _2f9=dojo.render[_2f8].prefixes;
for(var i=0;i<_2f9.length;i++){
_2d5.push(_2f9[i].toLowerCase());
}
}
}
}
var _2fb=function(_2fc,_2fd){
if(!_2fd){
return null;
}
for(var i=0,l=_2d5.length,_300;i<=l;i++){
_300=(i<l?_2fd[_2d5[i]]:_2fd);
if(!_300){
continue;
}
for(var name in _300){
if(name.toLowerCase()==_2fc){
return _300[name];
}
}
}
return null;
};
var _302=function(_303,_304){
var _305=dojo.evalObjPath(_304,false);
return (_305?_2fb(_303,_305):null);
};
this.getImplementationName=function(_306,ns){
var _308=_306.toLowerCase();
ns=ns||"dojo";
var imps=_2ed[ns]||(_2ed[ns]={});
var impl=imps[_308];
if(impl){
return impl;
}
if(!_2d5.length){
buildPrefixCache();
}
var _30b=dojo.ns.get(ns);
if(!_30b){
dojo.ns.register(ns,ns+".widget");
_30b=dojo.ns.get(ns);
}
if(_30b){
_30b.resolve(_306);
}
impl=_302(_308,_30b.module);
if(impl){
return (imps[_308]=impl);
}
_30b=dojo.ns.require(ns);
if((_30b)&&(_30b.resolver)){
_30b.resolve(_306);
impl=_302(_308,_30b.module);
if(impl){
return (imps[_308]=impl);
}
}
dojo.deprecated("dojo.widget.Manager.getImplementationName","Could not locate widget implementation for \""+_306+"\" in \""+_30b.module+"\" registered to namespace \""+_30b.name+"\". "+"Developers must specify correct namespaces for all non-Dojo widgets","0.5");
for(var i=0;i<_2ee.length;i++){
impl=_302(_308,_2ee[i]);
if(impl){
return (imps[_308]=impl);
}
}
throw new Error("Could not locate widget implementation for \""+_306+"\" in \""+_30b.module+"\" registered to namespace \""+_30b.name+"\"");
};
this.resizing=false;
this.onWindowResized=function(){
if(this.resizing){
return;
}
try{
this.resizing=true;
for(var id in this.topWidgets){
var _30e=this.topWidgets[id];
if(_30e.checkSize){
_30e.checkSize();
}
}
}
catch(e){
}
finally{
this.resizing=false;
}
};
if(typeof window!="undefined"){
dojo.addOnLoad(this,"onWindowResized");
dojo.event.connect(window,"onresize",this,"onWindowResized");
}
};
(function(){
var dw=dojo.widget;
var dwm=dw.manager;
var h=dojo.lang.curry(dojo.lang,"hitch",dwm);
var g=function(_313,_314){
dw[(_314||_313)]=h(_313);
};
g("add","addWidget");
g("destroyAll","destroyAllWidgets");
g("remove","removeWidget");
g("removeById","removeWidgetById");
g("getWidgetById");
g("getWidgetById","byId");
g("getWidgetsByType");
g("getWidgetsByFilter");
g("getWidgetsByType","byType");
g("getWidgetsByFilter","byFilter");
g("getWidgetByNode","byNode");
dw.all=function(n){
var _316=dwm.getAllWidgets.apply(dwm,arguments);
if(arguments.length>0){
return _316[n];
}
return _316;
};
g("registerWidgetPackage");
g("getImplementation","getWidgetImplementation");
g("getImplementationName","getWidgetImplementationName");
dw.widgets=dwm.widgets;
dw.widgetIds=dwm.widgetIds;
dw.root=dwm.root;
})();
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_318,uri){
var loc=dojo.hostenv.getModulePrefix(_318);
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri()+loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _31d=new dojo.uri.Uri(arguments[i].toString());
var _31e=new dojo.uri.Uri(uri.toString());
if((_31d.path=="")&&(_31d.scheme==null)&&(_31d.authority==null)&&(_31d.query==null)){
if(_31d.fragment!=null){
_31e.fragment=_31d.fragment;
}
_31d=_31e;
}else{
if(_31d.scheme==null){
_31d.scheme=_31e.scheme;
if(_31d.authority==null){
_31d.authority=_31e.authority;
if(_31d.path.charAt(0)!="/"){
var path=_31e.path.substring(0,_31e.path.lastIndexOf("/")+1)+_31d.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_31d.path=segs.join("/");
}
}
}
}
uri="";
if(_31d.scheme!=null){
uri+=_31d.scheme+":";
}
if(_31d.authority!=null){
uri+="//"+_31d.authority;
}
uri+=_31d.path;
if(_31d.query!=null){
uri+="?"+_31d.query;
}
if(_31d.fragment!=null){
uri+="#"+_31d.fragment;
}
}
this.uri=uri.toString();
var _322="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_322));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_322="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_322));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.uri.*");
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _326=dojo.global();
var _327=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_327.documentElement.clientWidth;
h=_326.innerHeight;
}else{
if(!dojo.render.html.opera&&_326.innerWidth){
w=_326.innerWidth;
h=_326.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_327,"documentElement.clientWidth")){
var w2=_327.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_327.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _32b=dojo.global();
var _32c=dojo.doc();
var top=_32b.pageYOffset||_32c.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_32b.pageXOffset||_32c.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _331=dojo.doc();
var _332=dojo.byId(node);
type=type.toLowerCase();
while((_332)&&(_332.nodeName.toLowerCase()!=type)){
if(_332==(_331["body"]||_331["documentElement"])){
return null;
}
_332=_332.parentNode;
}
return _332;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _33a={x:0,y:0};
if(e.pageX||e.pageY){
_33a.x=e.pageX;
_33a.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_33a.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_33a.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _33a;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _33f=dojo.doc().createElement("script");
_33f.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_33f);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_342,_343,args,_345,_346){
dojo.deprecated("dojo.html."+_342,"replaced by dojo.html."+_343+"("+(_345?"node, {"+_345+": "+_345+"}":"")+")"+(_346?"."+_346:""),"0.5");
var _347=[];
if(_345){
var _348={};
_348[_345]=args[1];
_347.push(args[0]);
_347.push(_348);
}else{
_347=args;
}
var ret=dojo.html[_343].apply(dojo.html,args);
if(_346){
return ret[_346];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.a11y");
dojo.a11y={imgPath:dojo.uri.dojoUri("src/widget/templates/images"),doAccessibleCheck:true,accessible:null,checkAccessible:function(){
if(this.accessible===null){
this.accessible=false;
if(this.doAccessibleCheck==true){
this.accessible=this.testAccessible();
}
}
return this.accessible;
},testAccessible:function(){
this.accessible=false;
if(dojo.render.html.ie||dojo.render.html.mozilla){
var div=document.createElement("div");
div.style.backgroundImage="url(\""+this.imgPath+"/tab_close.gif\")";
dojo.body().appendChild(div);
var _34b=null;
if(window.getComputedStyle){
var _34c=getComputedStyle(div,"");
_34b=_34c.getPropertyValue("background-image");
}else{
_34b=div.currentStyle.backgroundImage;
}
var _34d=false;
if(_34b!=null&&(_34b=="none"||_34b=="url(invalid-url:)")){
this.accessible=true;
}
dojo.body().removeChild(div);
}
return this.accessible;
},setCheckAccessible:function(_34e){
this.doAccessibleCheck=_34e;
},setAccessibleMode:function(){
if(this.accessible===null){
if(this.checkAccessible()){
dojo.render.html.prefixes.unshift("a11y");
}
}
return this.accessible;
}};
dojo.provide("dojo.widget.Widget");
dojo.declare("dojo.widget.Widget",null,function(){
this.children=[];
this.extraArgs={};
},{parent:null,children:[],extraArgs:{},isTopLevel:false,isModal:false,isEnabled:true,isHidden:false,isContainer:false,widgetId:"",widgetType:"Widget",ns:"dojo",getNamespacedType:function(){
return (this.ns?this.ns+":"+this.widgetType:this.widgetType).toLowerCase();
},toString:function(){
return "[Widget "+this.getNamespacedType()+", "+(this.widgetId||"NO ID")+"]";
},repr:function(){
return this.toString();
},enable:function(){
this.isEnabled=true;
},disable:function(){
this.isEnabled=false;
},hide:function(){
this.isHidden=true;
},show:function(){
this.isHidden=false;
},onResized:function(){
this.notifyChildrenOfResize();
},notifyChildrenOfResize:function(){
for(var i=0;i<this.children.length;i++){
var _350=this.children[i];
if(_350.onResized){
_350.onResized();
}
}
},create:function(args,_352,_353,ns){
if(ns){
this.ns=ns;
}
this.satisfyPropertySets(args,_352,_353);
this.mixInProperties(args,_352,_353);
this.postMixInProperties(args,_352,_353);
dojo.widget.manager.add(this);
this.buildRendering(args,_352,_353);
this.initialize(args,_352,_353);
this.postInitialize(args,_352,_353);
this.postCreate(args,_352,_353);
return this;
},destroy:function(_355){
this.destroyChildren();
this.uninitialize();
this.destroyRendering(_355);
dojo.widget.manager.removeById(this.widgetId);
},destroyChildren:function(){
var _356;
var i=0;
while(this.children.length>i){
_356=this.children[i];
if(_356 instanceof dojo.widget.Widget){
this.removeChild(_356);
_356.destroy();
continue;
}
i++;
}
},getChildrenOfType:function(type,_359){
var ret=[];
var _35b=dojo.lang.isFunction(type);
if(!_35b){
type=type.toLowerCase();
}
for(var x=0;x<this.children.length;x++){
if(_35b){
if(this.children[x] instanceof type){
ret.push(this.children[x]);
}
}else{
if(this.children[x].widgetType.toLowerCase()==type){
ret.push(this.children[x]);
}
}
if(_359){
ret=ret.concat(this.children[x].getChildrenOfType(type,_359));
}
}
return ret;
},getDescendants:function(){
var _35d=[];
var _35e=[this];
var elem;
while((elem=_35e.pop())){
_35d.push(elem);
if(elem.children){
dojo.lang.forEach(elem.children,function(elem){
_35e.push(elem);
});
}
}
return _35d;
},isFirstChild:function(){
return this===this.parent.children[0];
},isLastChild:function(){
return this===this.parent.children[this.parent.children.length-1];
},satisfyPropertySets:function(args){
return args;
},mixInProperties:function(args,frag){
if((args["fastMixIn"])||(frag["fastMixIn"])){
for(var x in args){
this[x]=args[x];
}
return;
}
var _365;
var _366=dojo.widget.lcArgsCache[this.widgetType];
if(_366==null){
_366={};
for(var y in this){
_366[((new String(y)).toLowerCase())]=y;
}
dojo.widget.lcArgsCache[this.widgetType]=_366;
}
var _368={};
for(var x in args){
if(!this[x]){
var y=_366[(new String(x)).toLowerCase()];
if(y){
args[y]=args[x];
x=y;
}
}
if(_368[x]){
continue;
}
_368[x]=true;
if((typeof this[x])!=(typeof _365)){
if(typeof args[x]!="string"){
this[x]=args[x];
}else{
if(dojo.lang.isString(this[x])){
this[x]=args[x];
}else{
if(dojo.lang.isNumber(this[x])){
this[x]=new Number(args[x]);
}else{
if(dojo.lang.isBoolean(this[x])){
this[x]=(args[x].toLowerCase()=="false")?false:true;
}else{
if(dojo.lang.isFunction(this[x])){
if(args[x].search(/[^\w\.]+/i)==-1){
this[x]=dojo.evalObjPath(args[x],false);
}else{
var tn=dojo.lang.nameAnonFunc(new Function(args[x]),this);
dojo.event.kwConnect({srcObj:this,srcFunc:x,adviceObj:this,adviceFunc:tn});
}
}else{
if(dojo.lang.isArray(this[x])){
this[x]=args[x].split(";");
}else{
if(this[x] instanceof Date){
this[x]=new Date(Number(args[x]));
}else{
if(typeof this[x]=="object"){
if(this[x] instanceof dojo.uri.Uri){
this[x]=args[x];
}else{
var _36a=args[x].split(";");
for(var y=0;y<_36a.length;y++){
var si=_36a[y].indexOf(":");
if((si!=-1)&&(_36a[y].length>si)){
this[x][_36a[y].substr(0,si).replace(/^\s+|\s+$/g,"")]=_36a[y].substr(si+1);
}
}
}
}else{
this[x]=args[x];
}
}
}
}
}
}
}
}
}else{
this.extraArgs[x.toLowerCase()]=args[x];
}
}
},postMixInProperties:function(args,frag,_36e){
},initialize:function(args,frag,_371){
return false;
},postInitialize:function(args,frag,_374){
return false;
},postCreate:function(args,frag,_377){
return false;
},uninitialize:function(){
return false;
},buildRendering:function(args,frag,_37a){
dojo.unimplemented("dojo.widget.Widget.buildRendering, on "+this.toString()+", ");
return false;
},destroyRendering:function(){
dojo.unimplemented("dojo.widget.Widget.destroyRendering");
return false;
},cleanUp:function(){
dojo.unimplemented("dojo.widget.Widget.cleanUp");
return false;
},addedTo:function(_37b){
},addChild:function(_37c){
dojo.unimplemented("dojo.widget.Widget.addChild");
return false;
},removeChild:function(_37d){
for(var x=0;x<this.children.length;x++){
if(this.children[x]===_37d){
this.children.splice(x,1);
break;
}
}
return _37d;
},resize:function(_37f,_380){
this.setWidth(_37f);
this.setHeight(_380);
},setWidth:function(_381){
if((typeof _381=="string")&&(_381.substr(-1)=="%")){
this.setPercentageWidth(_381);
}else{
this.setNativeWidth(_381);
}
},setHeight:function(_382){
if((typeof _382=="string")&&(_382.substr(-1)=="%")){
this.setPercentageHeight(_382);
}else{
this.setNativeHeight(_382);
}
},setPercentageHeight:function(_383){
return false;
},setNativeHeight:function(_384){
return false;
},setPercentageWidth:function(_385){
return false;
},setNativeWidth:function(_386){
return false;
},getPreviousSibling:function(){
var idx=this.getParentIndex();
if(idx<=0){
return null;
}
return this.parent.children[idx-1];
},getSiblings:function(){
return this.parent.children;
},getParentIndex:function(){
return dojo.lang.indexOf(this.parent.children,this,true);
},getNextSibling:function(){
var idx=this.getParentIndex();
if(idx==this.parent.children.length-1){
return null;
}
if(idx<0){
return null;
}
return this.parent.children[idx+1];
}});
dojo.widget.lcArgsCache={};
dojo.widget.tags={};
dojo.widget.tags.addParseTreeHandler=function(type){
dojo.deprecated("addParseTreeHandler",". ParseTreeHandlers are now reserved for components. Any unfiltered DojoML tag without a ParseTreeHandler is assumed to be a widget","0.5");
};
dojo.widget.tags["dojo:propertyset"]=function(_38a,_38b,_38c){
var _38d=_38b.parseProperties(_38a["dojo:propertyset"]);
};
dojo.widget.tags["dojo:connect"]=function(_38e,_38f,_390){
var _391=_38f.parseProperties(_38e["dojo:connect"]);
};
dojo.widget.buildWidgetFromParseTree=function(type,frag,_394,_395,_396,_397){
dojo.a11y.setAccessibleMode();
var _398=type.split(":");
_398=(_398.length==2)?_398[1]:type;
var _399=_397||_394.parseProperties(frag[frag["ns"]+":"+_398]);
var _39a=dojo.widget.manager.getImplementation(_398,null,null,frag["ns"]);
if(!_39a){
throw new Error("cannot find \""+type+"\" widget");
}else{
if(!_39a.create){
throw new Error("\""+type+"\" widget object has no \"create\" method and does not appear to implement *Widget");
}
}
_399["dojoinsertionindex"]=_396;
var ret=_39a.create(_399,frag,_395,frag["ns"]);
return ret;
};
dojo.widget.defineWidget=function(_39c,_39d,_39e,init,_3a0){
if(dojo.lang.isString(arguments[3])){
dojo.widget._defineWidget(arguments[0],arguments[3],arguments[1],arguments[4],arguments[2]);
}else{
var args=[arguments[0]],p=3;
if(dojo.lang.isString(arguments[1])){
args.push(arguments[1],arguments[2]);
}else{
args.push("",arguments[1]);
p=2;
}
if(dojo.lang.isFunction(arguments[p])){
args.push(arguments[p],arguments[p+1]);
}else{
args.push(null,arguments[p]);
}
dojo.widget._defineWidget.apply(this,args);
}
};
dojo.widget.defineWidget.renderers="html|svg|vml";
dojo.widget._defineWidget=function(_3a3,_3a4,_3a5,init,_3a7){
var _3a8=_3a3.split(".");
var type=_3a8.pop();
var regx="\\.("+(_3a4?_3a4+"|":"")+dojo.widget.defineWidget.renderers+")\\.";
var r=_3a3.search(new RegExp(regx));
_3a8=(r<0?_3a8.join("."):_3a3.substr(0,r));
dojo.widget.manager.registerWidgetPackage(_3a8);
var pos=_3a8.indexOf(".");
var _3ad=(pos>-1)?_3a8.substring(0,pos):_3a8;
_3a7=(_3a7)||{};
_3a7.widgetType=type;
if((!init)&&(_3a7["classConstructor"])){
init=_3a7.classConstructor;
delete _3a7.classConstructor;
}
dojo.declare(_3a3,_3a5,init,_3a7);
};
dojo.provide("dojo.widget.Parse");
dojo.widget.Parse=function(_3ae){
this.propertySetsList=[];
this.fragment=_3ae;
this.createComponents=function(frag,_3b0){
var _3b1=[];
var _3b2=false;
try{
if((frag)&&(frag["tagName"])&&(frag!=frag["nodeRef"])){
var _3b3=dojo.widget.tags;
var tna=String(frag["tagName"]).split(";");
for(var x=0;x<tna.length;x++){
var ltn=(tna[x].replace(/^\s+|\s+$/g,"")).toLowerCase();
frag.tagName=ltn;
if(_3b3[ltn]){
_3b2=true;
var ret=_3b3[ltn](frag,this,_3b0,frag["index"]);
_3b1.push(ret);
}else{
if(ltn.indexOf(":")==-1){
ltn="dojo:"+ltn;
}
var ret=dojo.widget.buildWidgetFromParseTree(ltn,frag,this,_3b0,frag["index"]);
if(ret){
_3b2=true;
_3b1.push(ret);
}
}
}
}
}
catch(e){
dojo.debug("dojo.widget.Parse: error:"+e);
}
if(!_3b2){
_3b1=_3b1.concat(this.createSubComponents(frag,_3b0));
}
return _3b1;
};
this.createSubComponents=function(_3b8,_3b9){
var frag,_3bb=[];
for(var item in _3b8){
frag=_3b8[item];
if((frag)&&(typeof frag=="object")&&(frag!=_3b8.nodeRef)&&(frag!=_3b8["tagName"])){
_3bb=_3bb.concat(this.createComponents(frag,_3b9));
}
}
return _3bb;
};
this.parsePropertySets=function(_3bd){
return [];
};
this.parseProperties=function(_3be){
var _3bf={};
for(var item in _3be){
if((_3be[item]==_3be["tagName"])||(_3be[item]==_3be.nodeRef)){
}else{
if((_3be[item]["tagName"])&&(dojo.widget.tags[_3be[item].tagName.toLowerCase()])){
}else{
if((_3be[item][0])&&(_3be[item][0].value!="")&&(_3be[item][0].value!=null)){
try{
if(item.toLowerCase()=="dataprovider"){
var _3c1=this;
this.getDataProvider(_3c1,_3be[item][0].value);
_3bf.dataProvider=this.dataProvider;
}
_3bf[item]=_3be[item][0].value;
var _3c2=this.parseProperties(_3be[item]);
for(var _3c3 in _3c2){
_3bf[_3c3]=_3c2[_3c3];
}
}
catch(e){
dojo.debug(e);
}
}
}
switch(item.toLowerCase()){
case "checked":
case "disabled":
if(typeof _3bf[item]!="boolean"){
_3bf[item]=true;
}
break;
}
}
}
return _3bf;
};
this.getDataProvider=function(_3c4,_3c5){
dojo.io.bind({url:_3c5,load:function(type,_3c7){
if(type=="load"){
_3c4.dataProvider=_3c7;
}
},mimetype:"text/javascript",sync:true});
};
this.getPropertySetById=function(_3c8){
for(var x=0;x<this.propertySetsList.length;x++){
if(_3c8==this.propertySetsList[x]["id"][0].value){
return this.propertySetsList[x];
}
}
return "";
};
this.getPropertySetsByType=function(_3ca){
var _3cb=[];
for(var x=0;x<this.propertySetsList.length;x++){
var cpl=this.propertySetsList[x];
var cpcc=cpl["componentClass"]||cpl["componentType"]||null;
var _3cf=this.propertySetsList[x]["id"][0].value;
if((cpcc)&&(_3cf==cpcc[0].value)){
_3cb.push(cpl);
}
}
return _3cb;
};
this.getPropertySets=function(_3d0){
var ppl="dojo:propertyproviderlist";
var _3d2=[];
var _3d3=_3d0["tagName"];
if(_3d0[ppl]){
var _3d4=_3d0[ppl].value.split(" ");
for(var _3d5 in _3d4){
if((_3d5.indexOf("..")==-1)&&(_3d5.indexOf("://")==-1)){
var _3d6=this.getPropertySetById(_3d5);
if(_3d6!=""){
_3d2.push(_3d6);
}
}else{
}
}
}
return (this.getPropertySetsByType(_3d3)).concat(_3d2);
};
this.createComponentFromScript=function(_3d7,_3d8,_3d9,ns){
_3d9.fastMixIn=true;
var ltn=(ns||"dojo")+":"+_3d8.toLowerCase();
if(dojo.widget.tags[ltn]){
return [dojo.widget.tags[ltn](_3d9,this,null,null,_3d9)];
}
return [dojo.widget.buildWidgetFromParseTree(ltn,_3d9,this,null,null,_3d9)];
};
};
dojo.widget._parser_collection={"dojo":new dojo.widget.Parse()};
dojo.widget.getParser=function(name){
if(!name){
name="dojo";
}
if(!this._parser_collection[name]){
this._parser_collection[name]=new dojo.widget.Parse();
}
return this._parser_collection[name];
};
dojo.widget.createWidget=function(name,_3de,_3df,_3e0){
var _3e1=false;
var _3e2=(typeof name=="string");
if(_3e2){
var pos=name.indexOf(":");
var ns=(pos>-1)?name.substring(0,pos):"dojo";
if(pos>-1){
name=name.substring(pos+1);
}
var _3e5=name.toLowerCase();
var _3e6=ns+":"+_3e5;
_3e1=(dojo.byId(name)&&(!dojo.widget.tags[_3e6]));
}
if((arguments.length==1)&&((_3e1)||(!_3e2))){
var xp=new dojo.xml.Parse();
var tn=(_3e1)?dojo.byId(name):name;
return dojo.widget.getParser().createComponents(xp.parseElement(tn,null,true))[0];
}
function fromScript(_3e9,name,_3eb,ns){
_3eb[_3e6]={dojotype:[{value:_3e5}],nodeRef:_3e9,fastMixIn:true};
_3eb.ns=ns;
return dojo.widget.getParser().createComponentFromScript(_3e9,name,_3eb,ns);
}
_3de=_3de||{};
var _3ed=false;
var tn=null;
var h=dojo.render.html.capable;
if(h){
tn=document.createElement("span");
}
if(!_3df){
_3ed=true;
_3df=tn;
if(h){
dojo.body().appendChild(_3df);
}
}else{
if(_3e0){
dojo.dom.insertAtPosition(tn,_3df,_3e0);
}else{
tn=_3df;
}
}
var _3ef=fromScript(tn,name.toLowerCase(),_3de,ns);
if((!_3ef)||(!_3ef[0])||(typeof _3ef[0].widgetType=="undefined")){
throw new Error("createWidget: Creation of \""+name+"\" widget failed.");
}
try{
if(_3ed){
if(_3ef[0].domNode.parentNode){
_3ef[0].domNode.parentNode.removeChild(_3ef[0].domNode);
}
}
}
catch(e){
dojo.debug(e);
}
return _3ef[0];
};
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_3f6,_3f7){
var out="";
for(var i=0;i<_3f6;i++){
out+=str;
if(_3f7&&i<_3f6-1){
out+=_3f7;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_406,_407,_408){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_406){
this.mimetype=_406;
}
if(_407){
this.transport=_407;
}
if(arguments.length>=4){
this.changeUrl=_408;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_40b,_40c){
},error:function(type,_40e,_40f,_410){
},timeout:function(type,_412,_413,_414){
},handle:function(type,data,_417,_418){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_419){
if(_419["url"]){
_419.url=_419.url.toString();
}
if(_419["formNode"]){
_419.formNode=dojo.byId(_419.formNode);
}
if(!_419["method"]&&_419["formNode"]&&_419["formNode"].method){
_419.method=_419["formNode"].method;
}
if(!_419["handle"]&&_419["handler"]){
_419.handle=_419.handler;
}
if(!_419["load"]&&_419["loaded"]){
_419.load=_419.loaded;
}
if(!_419["changeUrl"]&&_419["changeURL"]){
_419.changeUrl=_419.changeURL;
}
_419.encoding=dojo.lang.firstValued(_419["encoding"],djConfig["bindEncoding"],"");
_419.sendTransport=dojo.lang.firstValued(_419["sendTransport"],djConfig["ioSendTransport"],false);
var _41a=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_419[fn]&&_41a(_419[fn])){
continue;
}
if(_419["handle"]&&_41a(_419["handle"])){
_419[fn]=_419.handle;
}
}
dojo.lang.mixin(this,_419);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_421){
if(!(_421 instanceof dojo.io.Request)){
try{
_421=new dojo.io.Request(_421);
}
catch(e){
dojo.debug(e);
}
}
var _422="";
if(_421["transport"]){
_422=_421["transport"];
if(!this[_422]){
dojo.io.sendBindError(_421,"No dojo.io.bind() transport with name '"+_421["transport"]+"'.");
return _421;
}
if(!this[_422].canHandle(_421)){
dojo.io.sendBindError(_421,"dojo.io.bind() transport with name '"+_421["transport"]+"' cannot handle this type of request.");
return _421;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_421))){
_422=tmp;
break;
}
}
if(_422==""){
dojo.io.sendBindError(_421,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _421;
}
}
this[_422].bind(_421);
_421.bindSuccess=true;
return _421;
};
dojo.io.sendBindError=function(_425,_426){
if((typeof _425.error=="function"||typeof _425.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _427=new dojo.io.Error(_426);
setTimeout(function(){
_425[(typeof _425.error=="function")?"error":"handle"]("error",_427,null,_425);
},50);
}else{
dojo.raise(_426);
}
};
dojo.io.queueBind=function(_428){
if(!(_428 instanceof dojo.io.Request)){
try{
_428=new dojo.io.Request(_428);
}
catch(e){
dojo.debug(e);
}
}
var _429=_428.load;
_428.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_429.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _42b=_428.error;
_428.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_42b.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_428);
dojo.io._dispatchNextQueueBind();
return _428;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_42e,last){
var enc=/utf/i.test(_42e||"")?encodeURIComponent:dojo.string.encodeAscii;
var _431=[];
var _432=new Object();
for(var name in map){
var _434=function(elt){
var val=enc(name)+"="+enc(elt);
_431[(last==name)?"push":"unshift"](val);
};
if(!_432[name]){
var _437=map[name];
if(dojo.lang.isArray(_437)){
dojo.lang.forEach(_437,_434);
}else{
_434(_437);
}
}
}
return _431.join("&");
};
dojo.io.setIFrameSrc=function(_438,src,_43a){
try{
var r=dojo.render.html;
if(!_43a){
if(r.safari){
_438.location=src;
}else{
frames[_438.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_438.contentWindow.document;
}else{
if(r.safari){
idoc=_438.document;
}else{
idoc=_438.contentWindow;
}
}
if(!idoc){
_438.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_43d,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _43d.replace(/\%\{(\w+)\}/g,function(_440,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _443=str.split(" ");
for(var i=0;i<_443.length;i++){
_443[i]=_443[i].charAt(0).toUpperCase()+_443[i].substring(1);
}
return _443.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _448=escape(str);
var _449,re=/%u([0-9A-F]{4})/i;
while((_449=_448.match(re))){
var num=Number("0x"+_449[1]);
var _44c=escape("&#"+num+";");
ret+=_448.substring(0,_449.index)+_44c;
_448=_448.substring(_449.index+_449[0].length);
}
ret+=_448.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_451){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_451){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_45a){
if(_45a){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_45e,_45f){
if(_45f){
str=str.toLowerCase();
_45e=_45e.toLowerCase();
}
return str.indexOf(_45e)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_465){
if(_465=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_465=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_467){
var _468=[];
for(var i=0,_46a=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_467){
_468.push(str.substring(_46a,i));
_46a=i+1;
}
}
_468.push(str.substr(_46a));
return _468;
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:window.location.href,initialHash:window.location.hash,moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _46f=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_471){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_46f.apply(this,[_471]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _472=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_474){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_472){
_472.apply(this,[_474]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_477){
if(!dojo.render.html.opera){
var _478=this._getUrlQuery(_477.href);
if(_478==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_478==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_478==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _479=this.historyStack.pop();
if(!_479){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_479);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _480=url.split("?");
if(_480.length<2){
return null;
}else{
return _480[1];
}
},_loadIframeHistory:function(){
var url=dojo.hostenv.getBaseScriptUri()+"iframe_history.html?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
dojo.io.checkChildrenForFile=function(node){
var _483=false;
var _484=node.getElementsByTagName("input");
dojo.lang.forEach(_484,function(_485){
if(_483){
return;
}
if(_485.getAttribute("type")=="file"){
_483=true;
}
});
return _483;
};
dojo.io.formHasFile=function(_486){
return dojo.io.checkChildrenForFile(_486);
};
dojo.io.updateNode=function(node,_488){
node=dojo.byId(node);
var args=_488;
if(dojo.lang.isString(_488)){
args={url:_488};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
if(dojo["event"]){
try{
dojo.event.browser.clean(node.firstChild);
}
catch(e){
}
}
node.removeChild(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_48f,_490,_491){
if((!_48f)||(!_48f.tagName)||(!_48f.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_491){
_491=dojo.io.formFilter;
}
var enc=/utf/i.test(_490||"")?encodeURIComponent:dojo.string.encodeAscii;
var _493=[];
for(var i=0;i<_48f.elements.length;i++){
var elm=_48f.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_491(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_493.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_493.push(name+"="+enc(elm.value));
}
}else{
_493.push(name+"="+enc(elm.value));
}
}
}
var _499=_48f.getElementsByTagName("input");
for(var i=0;i<_499.length;i++){
var _49a=_499[i];
if(_49a.type.toLowerCase()=="image"&&_49a.form==_48f&&_491(_49a)){
var name=enc(_49a.name);
_493.push(name+"="+enc(_49a.value));
_493.push(name+".x=0");
_493.push(name+".y=0");
}
}
return _493.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _4a0=form.getElementsByTagName("input");
for(var i=0;i<_4a0.length;i++){
var _4a1=_4a0[i];
if(_4a1.type.toLowerCase()=="image"&&_4a1.form==form){
this.connect(_4a1,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _4a8=false;
if(node.disabled||!node.name){
_4a8=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_4a8=node==this.clickedButton;
}else{
_4a8=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _4a8;
},connect:function(_4a9,_4aa,_4ab){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_4a9,_4aa,this,_4ab);
}else{
var fcn=dojo.lang.hitch(this,_4ab);
_4a9[_4aa]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _4ae=this;
var _4af={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_4b1,_4b2){
return url+"|"+_4b1+"|"+_4b2.toLowerCase();
}
function addToCache(url,_4b4,_4b5,http){
_4af[getCacheKey(url,_4b4,_4b5)]=http;
}
function getFromCache(url,_4b8,_4b9){
return _4af[getCacheKey(url,_4b8,_4b9)];
}
this.clearCache=function(){
_4af={};
};
function doLoad(_4ba,http,url,_4bd,_4be){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_4ba.method.toLowerCase()=="head"){
var _4c0=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _4c0;
};
var _4c1=_4c0.split(/[\r\n]+/g);
for(var i=0;i<_4c1.length;i++){
var pair=_4c1[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_4ba.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_4ba.mimetype=="text/json"||_4ba.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_4ba.mimetype=="application/xml")||(_4ba.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_4be){
addToCache(url,_4bd,_4ba.method,http);
}
_4ba[(typeof _4ba.load=="function")?"load":"handle"]("load",ret,http,_4ba);
}else{
var _4c4=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_4ba[(typeof _4ba.error=="function")?"error":"handle"]("error",_4c4,http,_4ba);
}
}
function setHeaders(http,_4c6){
if(_4c6["headers"]){
for(var _4c7 in _4c6["headers"]){
if(_4c7.toLowerCase()=="content-type"&&!_4c6["contentType"]){
_4c6["contentType"]=_4c6["headers"][_4c7];
}else{
http.setRequestHeader(_4c7,_4c6["headers"][_4c7]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_4ae._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _4cb=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_4cb,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _4cc=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_4cd){
return _4cc&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_4cd["mimetype"].toLowerCase()||""))&&!(_4cd["formNode"]&&dojo.io.formHasFile(_4cd["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_4ce){
if(!_4ce["url"]){
if(!_4ce["formNode"]&&(_4ce["backButton"]||_4ce["back"]||_4ce["changeUrl"]||_4ce["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_4ce);
return true;
}
}
var url=_4ce.url;
var _4d0="";
if(_4ce["formNode"]){
var ta=_4ce.formNode.getAttribute("action");
if((ta)&&(!_4ce["url"])){
url=ta;
}
var tp=_4ce.formNode.getAttribute("method");
if((tp)&&(!_4ce["method"])){
_4ce.method=tp;
}
_4d0+=dojo.io.encodeForm(_4ce.formNode,_4ce.encoding,_4ce["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_4ce["file"]){
_4ce.method="post";
}
if(!_4ce["method"]){
_4ce.method="get";
}
if(_4ce.method.toLowerCase()=="get"){
_4ce.multipart=false;
}else{
if(_4ce["file"]){
_4ce.multipart=true;
}else{
if(!_4ce["multipart"]){
_4ce.multipart=false;
}
}
}
if(_4ce["backButton"]||_4ce["back"]||_4ce["changeUrl"]){
dojo.undo.browser.addToHistory(_4ce);
}
var _4d3=_4ce["content"]||{};
if(_4ce.sendTransport){
_4d3["dojo.transport"]="xmlhttp";
}
do{
if(_4ce.postContent){
_4d0=_4ce.postContent;
break;
}
if(_4d3){
_4d0+=dojo.io.argsFromMap(_4d3,_4ce.encoding);
}
if(_4ce.method.toLowerCase()=="get"||!_4ce.multipart){
break;
}
var t=[];
if(_4d0.length){
var q=_4d0.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_4ce.file){
if(dojo.lang.isArray(_4ce.file)){
for(var i=0;i<_4ce.file.length;++i){
var o=_4ce.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_4ce.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_4d0=t.join("\r\n");
}
}while(false);
var _4d9=_4ce["sync"]?false:true;
var _4da=_4ce["preventCache"]||(this.preventCache==true&&_4ce["preventCache"]!=false);
var _4db=_4ce["useCache"]==true||(this.useCache==true&&_4ce["useCache"]!=false);
if(!_4da&&_4db){
var _4dc=getFromCache(url,_4d0,_4ce.method);
if(_4dc){
doLoad(_4ce,_4dc,url,_4d0,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_4ce);
var _4de=false;
if(_4d9){
var _4df=this.inFlight.push({"req":_4ce,"http":http,"url":url,"query":_4d0,"useCache":_4db,"startTime":_4ce.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_4ae._blockAsync=true;
}
if(_4ce.method.toLowerCase()=="post"){
if(!_4ce.user){
http.open("POST",url,_4d9);
}else{
http.open("POST",url,_4d9,_4ce.user,_4ce.password);
}
setHeaders(http,_4ce);
http.setRequestHeader("Content-Type",_4ce.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_4ce.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_4d0);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_4ce,{status:404},url,_4d0,_4db);
}
}else{
var _4e0=url;
if(_4d0!=""){
_4e0+=(_4e0.indexOf("?")>-1?"&":"?")+_4d0;
}
if(_4da){
_4e0+=(dojo.string.endsWithAny(_4e0,"?","&")?"":(_4e0.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_4ce.user){
http.open(_4ce.method.toUpperCase(),_4e0,_4d9);
}else{
http.open(_4ce.method.toUpperCase(),_4e0,_4d9,_4ce.user,_4ce.password);
}
setHeaders(http,_4ce);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_4ce,{status:404},url,_4d0,_4db);
}
}
if(!_4d9){
doLoad(_4ce,http,url,_4d0,_4db);
_4ae._blockAsync=false;
}
_4ce.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_4e2,days,path,_4e5,_4e6){
var _4e7=-1;
if(typeof days=="number"&&days>=0){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_4e7=d.toGMTString();
}
_4e2=escape(_4e2);
document.cookie=name+"="+_4e2+";"+(_4e7!=-1?" expires="+_4e7+";":"")+(path?"path="+path:"")+(_4e5?"; domain="+_4e5:"")+(_4e6?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _4eb=document.cookie.substring(idx+name.length+1);
var end=_4eb.indexOf(";");
if(end==-1){
end=_4eb.length;
}
_4eb=_4eb.substring(0,end);
_4eb=unescape(_4eb);
return _4eb;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_4f2,_4f3,_4f4){
if(arguments.length==5){
_4f4=_4f2;
_4f2=null;
_4f3=null;
}
var _4f5=[],_4f6,_4f7="";
if(!_4f4){
_4f6=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_4f6){
_4f6={};
}
for(var prop in obj){
if(prop==null){
delete _4f6[prop];
}else{
if(typeof obj[prop]=="string"||typeof obj[prop]=="number"){
_4f6[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _4f6){
_4f5.push(escape(prop)+"="+escape(_4f6[prop]));
}
_4f7=_4f5.join("&");
}
dojo.io.cookie.setCookie(name,_4f7,days,path,_4f2,_4f3);
};
dojo.io.cookie.getObjectCookie=function(name){
var _4fa=null,_4fb=dojo.io.cookie.getCookie(name);
if(_4fb){
_4fa={};
var _4fc=_4fb.split("&");
for(var i=0;i<_4fc.length;i++){
var pair=_4fc[i].split("=");
var _4ff=pair[1];
if(isNaN(_4ff)){
_4ff=unescape(pair[1]);
}
_4fa[unescape(pair[0])]=_4ff;
}
}
return _4fa;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _500=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_500=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.provide("dojo.io.*");
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_506){
return (new RegExp("(^|\\s+)"+_506+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_508){
_508+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_508);
};
dojo.html.addClass=function(node,_50a){
if(dojo.html.hasClass(node,_50a)){
return false;
}
_50a=(dojo.html.getClass(node)+" "+_50a).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_50a);
};
dojo.html.setClass=function(node,_50c){
node=dojo.byId(node);
var cs=new String(_50c);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_50c);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_50f,_510){
try{
if(!_510){
var _511=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_50f+"(\\s+|$)"),"$1$2");
}else{
var _511=dojo.html.getClass(node).replace(_50f,"");
}
dojo.html.setClass(node,_511);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_513,_514){
dojo.html.removeClass(node,_514);
dojo.html.addClass(node,_513);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_515,_516,_517,_518,_519){
_519=false;
var _51a=dojo.doc();
_516=dojo.byId(_516)||_51a;
var _51b=_515.split(/\s+/g);
var _51c=[];
if(_518!=1&&_518!=2){
_518=0;
}
var _51d=new RegExp("(\\s|^)(("+_51b.join(")|(")+"))(\\s|$)");
var _51e=_51b.join(" ").length;
var _51f=[];
if(!_519&&_51a.evaluate){
var _520=".//"+(_517||"*")+"[contains(";
if(_518!=dojo.html.classMatchType.ContainsAny){
_520+="concat(' ',@class,' '), ' "+_51b.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_518==2){
_520+=" and string-length(@class)="+_51e+"]";
}else{
_520+="]";
}
}else{
_520+="concat(' ',@class,' '), ' "+_51b.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _521=_51a.evaluate(_520,_516,null,XPathResult.ANY_TYPE,null);
var _522=_521.iterateNext();
while(_522){
try{
_51f.push(_522);
_522=_521.iterateNext();
}
catch(e){
break;
}
}
return _51f;
}else{
if(!_517){
_517="*";
}
_51f=_516.getElementsByTagName(_517);
var node,i=0;
outer:
while(node=_51f[i++]){
var _525=dojo.html.getClasses(node);
if(_525.length==0){
continue outer;
}
var _526=0;
for(var j=0;j<_525.length;j++){
if(_51d.test(_525[j])){
if(_518==dojo.html.classMatchType.ContainsAny){
_51c.push(node);
continue outer;
}else{
_526++;
}
}else{
if(_518==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_526==_51b.length){
if((_518==dojo.html.classMatchType.IsOnly)&&(_526==_525.length)){
_51c.push(node);
}else{
if(_518==dojo.html.classMatchType.ContainsAll){
_51c.push(node);
}
}
}
}
return _51c;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_528){
var arr=_528.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_52c){
return _52c.replace(/([A-Z])/g,"-$1").toLowerCase();
};
dojo.html.getComputedStyle=function(node,_52e,_52f){
node=dojo.byId(node);
var _52e=dojo.html.toSelectorCase(_52e);
var _530=dojo.html.toCamelCase(_52e);
if(!node||!node.style){
return _52f;
}else{
if(document.defaultView&&dojo.html.isDescendantOf(node,node.ownerDocument)){
try{
var cs=document.defaultView.getComputedStyle(node,"");
if(cs){
return cs.getPropertyValue(_52e);
}
}
catch(e){
if(node.style.getPropertyValue){
return node.style.getPropertyValue(_52e);
}else{
return _52f;
}
}
}else{
if(node.currentStyle){
return node.currentStyle[_530];
}
}
}
if(node.style.getPropertyValue){
return node.style.getPropertyValue(_52e);
}else{
return _52f;
}
};
dojo.html.getStyleProperty=function(node,_533){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_533)]:undefined);
};
dojo.html.getStyle=function(node,_535){
var _536=dojo.html.getStyleProperty(node,_535);
return (_536?_536:dojo.html.getComputedStyle(node,_535));
};
dojo.html.setStyle=function(node,_538,_539){
node=dojo.byId(node);
if(node&&node.style){
var _53a=dojo.html.toCamelCase(_538);
node.style[_53a]=_539;
}
};
dojo.html.setStyleText=function(_53b,text){
try{
_53b.style.cssText=text;
}
catch(e){
_53b.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_53d,_53e){
if(!_53e.style.cssText){
_53d.setAttribute("style",_53e.getAttribute("style"));
}else{
_53d.style.cssText=_53e.style.cssText;
}
dojo.html.addClass(_53d,dojo.html.getClass(_53e));
};
dojo.html.getUnitValue=function(node,_540,_541){
var s=dojo.html.getComputedStyle(node,_540);
if((!s)||((s=="auto")&&(_541))){
return {value:0,units:"px"};
}
var _543=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_543){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_543[1]),units:_543[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
dojo.html.getPixelValue=function(node,_545,_546){
var _547=dojo.html.getUnitValue(node,_545,_546);
if(isNaN(_547.value)){
return 0;
}
if((_547.value)&&(_547.units!="px")){
return NaN;
}
return _547.value;
};
dojo.html.setPositivePixelValue=function(node,_549,_54a){
if(isNaN(_54a)){
return false;
}
node.style[_549]=Math.max(0,_54a)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_54b,_54c,_54d){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_54d=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_54d=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_54b+" { "+_54c+" }";
return dojo.html.styleSheet.insertRule(rule,_54d);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_54b,_54c,_54d);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_54f){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_54f){
_54f=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_54f);
}
}else{
if(document.styleSheets[0]){
if(!_54f){
_54f=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_54f);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_552,_553){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _554=dojo.hostenv.getText(URI,false,_553);
if(_554===null){
return;
}
_554=dojo.html.fixPathsInCssText(_554,URI);
if(_552){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_554)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _559=doc.getElementsByTagName("style");
for(var i=0;i<_559.length;i++){
if(_559[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _55a=dojo.html.insertCssText(_554);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_554,"nodeRef":_55a});
if(_55a&&djConfig.isDebug){
_55a.setAttribute("dbgHref",URI);
}
return _55a;
};
dojo.html.insertCssText=function(_55b,doc,URI){
if(!_55b){
return;
}
if(!doc){
doc=document;
}
if(URI){
_55b=dojo.html.fixPathsInCssText(_55b,URI);
}
var _55e=doc.createElement("style");
_55e.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_55e);
}
if(_55e.styleSheet){
_55e.styleSheet.cssText=_55b;
}else{
var _560=doc.createTextNode(_55b);
_55e.appendChild(_560);
}
return _55e;
};
dojo.html.fixPathsInCssText=function(_561,URI){
function iefixPathsInCssText(){
var _563=/AlphaImageLoader\(src\=['"]([\t\s\w()\/.\\'"-:#=&?~]*)['"]/;
while(_564=_563.exec(_561)){
url=_564[1].replace(_566,"$2");
if(!_567.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_561.substring(0,_564.index)+"AlphaImageLoader(src='"+url+"'";
_561=_561.substr(_564.index+_564[0].length);
}
return str+_561;
}
if(!_561||!URI){
return;
}
var _564,str="",url="";
var _569=/url\(\s*([\t\s\w()\/.\\'"-:#=&?]+)\s*\)/;
var _567=/(file|https?|ftps?):\/\//;
var _566=/^[\s]*(['"]?)([\w()\/.\\'"-:#=&?]*)\1[\s]*?$/;
if(dojo.render.html.ie55||dojo.render.html.ie60){
_561=iefixPathsInCssText();
}
while(_564=_569.exec(_561)){
url=_564[1].replace(_566,"$2");
if(!_567.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_561.substring(0,_564.index)+"url("+url+")";
_561=_561.substr(_564.index+_564[0].length);
}
return str+_561;
};
dojo.html.setActiveStyleSheet=function(_56a){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_56a){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _576={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _576){
if(_576[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.provide("dojo.widget.DomWidget");
dojo.widget._cssFiles={};
dojo.widget._cssStrings={};
dojo.widget._templateCache={};
dojo.widget.defaultStrings={dojoRoot:dojo.hostenv.getBaseScriptUri(),baseScriptUri:dojo.hostenv.getBaseScriptUri()};
dojo.widget.fillFromTemplateCache=function(obj,_579,_57a,_57b){
var _57c=_579||obj.templatePath;
var _57d=dojo.widget._templateCache;
if(!obj["widgetType"]){
do{
var _57e="__dummyTemplate__"+dojo.widget._templateCache.dummyCount++;
}while(_57d[_57e]);
obj.widgetType=_57e;
}
var wt=obj.widgetType;
var ts=_57d[wt];
if(!ts){
_57d[wt]={"string":null,"node":null};
if(_57b){
ts={};
}else{
ts=_57d[wt];
}
}
if((!obj.templateString)&&(!_57b)){
obj.templateString=_57a||ts["string"];
}
if((!obj.templateNode)&&(!_57b)){
obj.templateNode=ts["node"];
}
if((!obj.templateNode)&&(!obj.templateString)&&(_57c)){
var _581=dojo.hostenv.getText(_57c);
if(_581){
_581=_581.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");
var _582=_581.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_582){
_581=_582[1];
}
}else{
_581="";
}
obj.templateString=_581;
if(!_57b){
_57d[wt]["string"]=_581;
}
}
if((!ts["string"])&&(!_57b)){
ts.string=obj.templateString;
}
};
dojo.widget._templateCache.dummyCount=0;
dojo.widget.attachProperties=["dojoAttachPoint","id"];
dojo.widget.eventAttachProperty="dojoAttachEvent";
dojo.widget.onBuildProperty="dojoOnBuild";
dojo.widget.waiNames=["waiRole","waiState"];
dojo.widget.wai={waiRole:{name:"waiRole","namespace":"http://www.w3.org/TR/xhtml2",alias:"x2",prefix:"wairole:"},waiState:{name:"waiState","namespace":"http://www.w3.org/2005/07/aaa",alias:"aaa",prefix:""},setAttr:function(node,ns,attr,_586){
if(dojo.render.html.ie){
node.setAttribute(this[ns].alias+":"+attr,this[ns].prefix+_586);
}else{
node.setAttributeNS(this[ns]["namespace"],attr,this[ns].prefix+_586);
}
},getAttr:function(node,ns,attr){
if(dojo.render.html.ie){
return node.getAttribute(this[ns].alias+":"+attr);
}else{
return node.getAttributeNS(this[ns]["namespace"],attr);
}
},removeAttr:function(node,ns,attr){
var _58d=true;
if(dojo.render.html.ie){
_58d=node.removeAttribute(this[ns].alias+":"+attr);
}else{
node.removeAttributeNS(this[ns]["namespace"],attr);
}
return _58d;
}};
dojo.widget.attachTemplateNodes=function(_58e,_58f,_590){
var _591=dojo.dom.ELEMENT_NODE;
function trim(str){
return str.replace(/^\s+|\s+$/g,"");
}
if(!_58e){
_58e=_58f.domNode;
}
if(_58e.nodeType!=_591){
return;
}
var _593=_58e.all||_58e.getElementsByTagName("*");
var _594=_58f;
for(var x=-1;x<_593.length;x++){
var _596=(x==-1)?_58e:_593[x];
var _597=[];
if(!_58f.widgetsInTemplate||!_596.getAttribute("dojoType")){
for(var y=0;y<this.attachProperties.length;y++){
var _599=_596.getAttribute(this.attachProperties[y]);
if(_599){
_597=_599.split(";");
for(var z=0;z<_597.length;z++){
if(dojo.lang.isArray(_58f[_597[z]])){
_58f[_597[z]].push(_596);
}else{
_58f[_597[z]]=_596;
}
}
break;
}
}
var _59b=_596.getAttribute(this.eventAttachProperty);
if(_59b){
var evts=_59b.split(";");
for(var y=0;y<evts.length;y++){
if((!evts[y])||(!evts[y].length)){
continue;
}
var _59d=null;
var tevt=trim(evts[y]);
if(evts[y].indexOf(":")>=0){
var _59f=tevt.split(":");
tevt=trim(_59f[0]);
_59d=trim(_59f[1]);
}
if(!_59d){
_59d=tevt;
}
var tf=function(){
var ntf=new String(_59d);
return function(evt){
if(_594[ntf]){
_594[ntf](dojo.event.browser.fixEvent(evt,this));
}
};
}();
dojo.event.browser.addListener(_596,tevt,tf,false,true);
}
}
for(var y=0;y<_590.length;y++){
var _5a3=_596.getAttribute(_590[y]);
if((_5a3)&&(_5a3.length)){
var _59d=null;
var _5a4=_590[y].substr(4);
_59d=trim(_5a3);
var _5a5=[_59d];
if(_59d.indexOf(";")>=0){
_5a5=dojo.lang.map(_59d.split(";"),trim);
}
for(var z=0;z<_5a5.length;z++){
if(!_5a5[z].length){
continue;
}
var tf=function(){
var ntf=new String(_5a5[z]);
return function(evt){
if(_594[ntf]){
_594[ntf](dojo.event.browser.fixEvent(evt,this));
}
};
}();
dojo.event.browser.addListener(_596,_5a4,tf,false,true);
}
}
}
}
var _5a8=_596.getAttribute(this.templateProperty);
if(_5a8){
_58f[_5a8]=_596;
}
dojo.lang.forEach(dojo.widget.waiNames,function(name){
var wai=dojo.widget.wai[name];
var val=_596.getAttribute(wai.name);
if(val){
if(val.indexOf("-")==-1){
dojo.widget.wai.setAttr(_596,wai.name,"role",val);
}else{
var _5ac=val.split("-");
dojo.widget.wai.setAttr(_596,wai.name,_5ac[0],_5ac[1]);
}
}
},this);
var _5ad=_596.getAttribute(this.onBuildProperty);
if(_5ad){
eval("var node = baseNode; var widget = targetObj; "+_5ad);
}
}
};
dojo.widget.getDojoEventsFromStr=function(str){
var re=/(dojoOn([a-z]+)(\s?))=/gi;
var evts=str?str.match(re)||[]:[];
var ret=[];
var lem={};
for(var x=0;x<evts.length;x++){
if(evts[x].length<1){
continue;
}
var cm=evts[x].replace(/\s/,"");
cm=(cm.slice(0,cm.length-1));
if(!lem[cm]){
lem[cm]=true;
ret.push(cm);
}
}
return ret;
};
dojo.declare("dojo.widget.DomWidget",dojo.widget.Widget,function(){
if((arguments.length>0)&&(typeof arguments[0]=="object")){
this.create(arguments[0]);
}
},{templateNode:null,templateString:null,templateCssString:null,preventClobber:false,domNode:null,containerNode:null,widgetsInTemplate:false,addChild:function(_5b5,_5b6,pos,ref,_5b9){
if(!this.isContainer){
dojo.debug("dojo.widget.DomWidget.addChild() attempted on non-container widget");
return null;
}else{
if(_5b9==undefined){
_5b9=this.children.length;
}
this.addWidgetAsDirectChild(_5b5,_5b6,pos,ref,_5b9);
this.registerChild(_5b5,_5b9);
}
return _5b5;
},addWidgetAsDirectChild:function(_5ba,_5bb,pos,ref,_5be){
if((!this.containerNode)&&(!_5bb)){
this.containerNode=this.domNode;
}
var cn=(_5bb)?_5bb:this.containerNode;
if(!pos){
pos="after";
}
if(!ref){
if(!cn){
cn=dojo.body();
}
ref=cn.lastChild;
}
if(!_5be){
_5be=0;
}
_5ba.domNode.setAttribute("dojoinsertionindex",_5be);
if(!ref){
cn.appendChild(_5ba.domNode);
}else{
if(pos=="insertAtIndex"){
dojo.dom.insertAtIndex(_5ba.domNode,ref.parentNode,_5be);
}else{
if((pos=="after")&&(ref===cn.lastChild)){
cn.appendChild(_5ba.domNode);
}else{
dojo.dom.insertAtPosition(_5ba.domNode,cn,pos);
}
}
}
},registerChild:function(_5c0,_5c1){
_5c0.dojoInsertionIndex=_5c1;
var idx=-1;
for(var i=0;i<this.children.length;i++){
if(this.children[i].dojoInsertionIndex<=_5c1){
idx=i;
}
}
this.children.splice(idx+1,0,_5c0);
_5c0.parent=this;
_5c0.addedTo(this,idx+1);
delete dojo.widget.manager.topWidgets[_5c0.widgetId];
},removeChild:function(_5c4){
dojo.dom.removeNode(_5c4.domNode);
return dojo.widget.DomWidget.superclass.removeChild.call(this,_5c4);
},getFragNodeRef:function(frag){
if(!frag){
return null;
}
if(!frag[this.getNamespacedType()]){
dojo.raise("Error: no frag for widget type "+this.getNamespacedType()+", id "+this.widgetId+" (maybe a widget has set it's type incorrectly)");
}
return frag[this.getNamespacedType()]["nodeRef"];
},postInitialize:function(args,frag,_5c8){
var _5c9=this.getFragNodeRef(frag);
if(_5c8&&(_5c8.snarfChildDomOutput||!_5c9)){
_5c8.addWidgetAsDirectChild(this,"","insertAtIndex","",args["dojoinsertionindex"],_5c9);
}else{
if(_5c9){
if(this.domNode&&(this.domNode!==_5c9)){
var _5ca=_5c9.parentNode.replaceChild(this.domNode,_5c9);
}
}
}
if(_5c8){
_5c8.registerChild(this,args.dojoinsertionindex);
}else{
dojo.widget.manager.topWidgets[this.widgetId]=this;
}
if(this.widgetsInTemplate){
var _5cb=new dojo.xml.Parse();
var _5cc;
var _5cd=this.domNode.getElementsByTagName("*");
for(var i=0;i<_5cd.length;i++){
if(_5cd[i].getAttribute("dojoAttachPoint")=="subContainerWidget"){
_5cc=_5cd[i];
}
if(_5cd[i].getAttribute("dojoType")){
_5cd[i].setAttribute("_isSubWidget",true);
}
}
if(this.isContainer&&!this.containerNode){
if(_5cc){
var src=this.getFragNodeRef(frag);
if(src){
dojo.dom.moveChildren(src,_5cc);
frag["dojoDontFollow"]=true;
}
}else{
dojo.debug("No subContainerWidget node can be found in template file for widget "+this);
}
}
var _5d0=_5cb.parseElement(this.domNode,null,true);
dojo.widget.getParser().createSubComponents(_5d0,this);
var _5d1=[];
var _5d2=[this];
var w;
while((w=_5d2.pop())){
for(var i=0;i<w.children.length;i++){
var _5d4=w.children[i];
if(_5d4._processedSubWidgets||!_5d4.extraArgs["_issubwidget"]){
continue;
}
_5d1.push(_5d4);
if(_5d4.isContainer){
_5d2.push(_5d4);
}
}
}
for(var i=0;i<_5d1.length;i++){
var _5d5=_5d1[i];
if(_5d5._processedSubWidgets){
dojo.debug("This should not happen: widget._processedSubWidgets is already true!");
return;
}
_5d5._processedSubWidgets=true;
if(_5d5.extraArgs["dojoattachevent"]){
var evts=_5d5.extraArgs["dojoattachevent"].split(";");
for(var j=0;j<evts.length;j++){
var _5d8=null;
var tevt=dojo.string.trim(evts[j]);
if(tevt.indexOf(":")>=0){
var _5da=tevt.split(":");
tevt=dojo.string.trim(_5da[0]);
_5d8=dojo.string.trim(_5da[1]);
}
if(!_5d8){
_5d8=tevt;
}
if(dojo.lang.isFunction(_5d5[tevt])){
dojo.event.kwConnect({srcObj:_5d5,srcFunc:tevt,targetObj:this,targetFunc:_5d8});
}else{
alert(tevt+" is not a function in widget "+_5d5);
}
}
}
if(_5d5.extraArgs["dojoattachpoint"]){
this[_5d5.extraArgs["dojoattachpoint"]]=_5d5;
}
}
}
if(this.isContainer&&!frag["dojoDontFollow"]){
dojo.widget.getParser().createSubComponents(frag,this);
}
},buildRendering:function(args,frag){
var ts=dojo.widget._templateCache[this.widgetType];
if(args["templatecsspath"]){
args["templateCssPath"]=args["templatecsspath"];
}
var _5de=args["templateCssPath"]||this.templateCssPath;
if(_5de&&!dojo.widget._cssFiles[_5de.toString()]){
if((!this.templateCssString)&&(_5de)){
this.templateCssString=dojo.hostenv.getText(_5de);
this.templateCssPath=null;
}
dojo.widget._cssFiles[_5de.toString()]=true;
}
if((this["templateCssString"])&&(!this.templateCssString["loaded"])){
dojo.html.insertCssText(this.templateCssString,null,_5de);
if(!this.templateCssString){
this.templateCssString="";
}
this.templateCssString.loaded=true;
}
if((!this.preventClobber)&&((this.templatePath)||(this.templateNode)||((this["templateString"])&&(this.templateString.length))||((typeof ts!="undefined")&&((ts["string"])||(ts["node"]))))){
this.buildFromTemplate(args,frag);
}else{
this.domNode=this.getFragNodeRef(frag);
}
this.fillInTemplate(args,frag);
},buildFromTemplate:function(args,frag){
var _5e1=false;
if(args["templatepath"]){
_5e1=true;
args["templatePath"]=args["templatepath"];
}
dojo.widget.fillFromTemplateCache(this,args["templatePath"],null,_5e1);
var ts=dojo.widget._templateCache[this.widgetType];
if((ts)&&(!_5e1)){
if(!this.templateString.length){
this.templateString=ts["string"];
}
if(!this.templateNode){
this.templateNode=ts["node"];
}
}
var _5e3=false;
var node=null;
var tstr=this.templateString;
if((!this.templateNode)&&(this.templateString)){
_5e3=this.templateString.match(/\$\{([^\}]+)\}/g);
if(_5e3){
var hash=this.strings||{};
for(var key in dojo.widget.defaultStrings){
if(dojo.lang.isUndefined(hash[key])){
hash[key]=dojo.widget.defaultStrings[key];
}
}
for(var i=0;i<_5e3.length;i++){
var key=_5e3[i];
key=key.substring(2,key.length-1);
var kval=(key.substring(0,5)=="this.")?dojo.lang.getObjPathValue(key.substring(5),this):hash[key];
var _5ea;
if((kval)||(dojo.lang.isString(kval))){
_5ea=new String((dojo.lang.isFunction(kval))?kval.call(this,key,this.templateString):kval);
while(_5ea.indexOf("\"")>-1){
_5ea=_5ea.replace("\"","&quot;");
}
tstr=tstr.replace(_5e3[i],_5ea);
}
}
}else{
this.templateNode=this.createNodesFromText(this.templateString,true)[0];
if(!_5e1){
ts.node=this.templateNode;
}
}
}
if((!this.templateNode)&&(!_5e3)){
dojo.debug("DomWidget.buildFromTemplate: could not create template");
return false;
}else{
if(!_5e3){
node=this.templateNode.cloneNode(true);
if(!node){
return false;
}
}else{
node=this.createNodesFromText(tstr,true)[0];
}
}
this.domNode=node;
this.attachTemplateNodes();
if(this.isContainer&&this.containerNode){
var src=this.getFragNodeRef(frag);
if(src){
dojo.dom.moveChildren(src,this.containerNode);
}
}
},attachTemplateNodes:function(_5ec,_5ed){
if(!_5ec){
_5ec=this.domNode;
}
if(!_5ed){
_5ed=this;
}
return dojo.widget.attachTemplateNodes(_5ec,_5ed,dojo.widget.getDojoEventsFromStr(this.templateString));
},fillInTemplate:function(){
},destroyRendering:function(){
try{
delete this.domNode;
}
catch(e){
}
},cleanUp:function(){
},getContainerHeight:function(){
dojo.unimplemented("dojo.widget.DomWidget.getContainerHeight");
},getContainerWidth:function(){
dojo.unimplemented("dojo.widget.DomWidget.getContainerWidth");
},createNodesFromText:function(){
dojo.unimplemented("dojo.widget.DomWidget.createNodesFromText");
}});
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_5ef,_5f0){
node=dojo.byId(node);
_5f0(node,!_5ef(node));
return _5ef(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_5f5){
dojo.html[(_5f5?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_5fb){
dojo.html.setStyle(node,"display",((_5fb instanceof String||typeof _5fb=="string")?_5fb:(_5fb?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_5ff){
dojo.html.setStyle(node,"visibility",((_5ff instanceof String||typeof _5ff=="string")?_5ff:(_5ff?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_603,_604){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_604){
if(_603>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_603=0.999999;
}
}else{
if(_603<0){
_603=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_603*100+")";
}
}
node.style.filter="Alpha(Opacity="+_603*100+")";
}else{
if(h.moz){
node.style.opacity=_603;
node.style.MozOpacity=_603;
}else{
if(h.safari){
node.style.opacity=_603;
node.style.KhtmlOpacity=_603;
}else{
node.style.opacity=_603;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _610=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_610+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _610;
};
dojo.html.setStyleAttributes=function(node,_613){
node=dojo.byId(node);
var _614=_613.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_614.length;i++){
var _616=_614[i].split(":");
var name=_616[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _618=_616[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_618);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_618});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_618});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_618});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_618});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_618;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_61a,_61b){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_61b){
_61b=bs.CONTENT_BOX;
}
var _61e=2;
var _61f;
switch(_61b){
case bs.MARGIN_BOX:
_61f=3;
break;
case bs.BORDER_BOX:
_61f=2;
break;
case bs.PADDING_BOX:
default:
_61f=1;
break;
case bs.CONTENT_BOX:
_61f=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_61e=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _623;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_623=db;
}else{
_623=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _625=node;
do{
var n=_625["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_625["offsetTop"];
ret.y+=isNaN(m)?0:m;
_625=_625.offsetParent;
}while((_625!=_623)&&(_625!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_61a){
var _628=dojo.html.getScroll();
ret.y+=_628.top;
ret.x+=_628.left;
}
var _629=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_61e>_61f){
for(var i=_61f;i<_61e;++i){
ret.y+=_629[i](node,"top");
ret.x+=_629[i](node,"left");
}
}else{
if(_61e<_61f){
for(var i=_61f;i>_61e;--i){
ret.y-=_629[i-1](node,"top");
ret.x-=_629[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_62d,_62e){
var _62f=0;
for(var x=0;x<_62d.length;x++){
_62f+=dojo.html.getPixelValue(node,_62d[x],_62e);
}
return _62f;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _63c=dojo.html.getBorder(node);
return {width:pad.width+_63c.width,height:pad.height+_63c.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if((h.ie)||(h.opera)){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _641=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_641){
_641=dojo.html.getStyle(node,"box-sizing");
}
return (_641?_641:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _646=dojo.html.getBorder(node);
return {width:box.width-_646.width,height:box.height-_646.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _648=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_648.width,height:node.offsetHeight-_648.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _64b=0;
var _64c=0;
var isbb=dojo.html.isBorderBox(node);
var _64e=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_64b=args.width+_64e.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_64b);
}
if(typeof args.height!="undefined"){
_64c=args.height+_64e.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_64c);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _651=dojo.html.getBorderBox(node);
var _652=dojo.html.getMargin(node);
return {width:_651.width+_652.width,height:_651.height+_652.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _655=0;
var _656=0;
var isbb=dojo.html.isBorderBox(node);
var _658=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _659=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_655=args.width-_658.width;
_655-=_659.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_655);
}
if(typeof args.height!="undefined"){
_656=args.height-_658.height;
_656-=_659.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_656);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_65e,_65f,_660){
if(_65e instanceof Array||typeof _65e=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_65e.length<4){
_65e.push(0);
}
while(_65e.length>4){
_65e.pop();
}
var ret={left:_65e[0],top:_65e[1],width:_65e[2],height:_65e[3]};
}else{
if(!_65e.nodeType&&!(_65e instanceof String||typeof _65e=="string")&&("width" in _65e||"height" in _65e||"left" in _65e||"x" in _65e||"top" in _65e||"y" in _65e)){
var ret={left:_65e.left||_65e.x||0,top:_65e.top||_65e.y||0,width:_65e.width||0,height:_65e.height||0};
}else{
var node=dojo.byId(_65e);
var pos=dojo.html.abs(node,_65f,_660);
var _664=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_664.width,height:_664.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_666){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_669){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_66b){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_66d){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_66f){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_671){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_67b){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_67d){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.html.util");
dojo.html.getElementWindow=function(_67e){
return dojo.html.getDocumentWindow(_67e.ownerDocument);
};
dojo.html.getDocumentWindow=function(doc){
if(dojo.render.html.safari&&!doc._parentWindow){
var fix=function(win){
win.document._parentWindow=win;
for(var i=0;i<win.frames.length;i++){
fix(win.frames[i]);
}
};
fix(window.top);
}
if(dojo.render.html.ie&&window!==document.parentWindow&&!doc._parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc._parentWindow||doc.parentWindow||doc.defaultView;
};
dojo.html.gravity=function(node,e){
node=dojo.byId(node);
var _686=dojo.html.getCursorPosition(e);
with(dojo.html){
var _687=getAbsolutePosition(node,true);
var bb=getBorderBox(node);
var _689=_687.x+(bb.width/2);
var _68a=_687.y+(bb.height/2);
}
with(dojo.html.gravity){
return ((_686.x<_689?WEST:EAST)|(_686.y<_68a?NORTH:SOUTH));
}
};
dojo.html.gravity.NORTH=1;
dojo.html.gravity.SOUTH=1<<1;
dojo.html.gravity.EAST=1<<2;
dojo.html.gravity.WEST=1<<3;
dojo.html.overElement=function(_68b,e){
_68b=dojo.byId(_68b);
var _68d=dojo.html.getCursorPosition(e);
var bb=dojo.html.getBorderBox(_68b);
var _68f=dojo.html.getAbsolutePosition(_68b,true,dojo.html.boxSizing.BORDER_BOX);
var top=_68f.y;
var _691=top+bb.height;
var left=_68f.x;
var _693=left+bb.width;
return (_68d.x>=left&&_68d.x<=_693&&_68d.y>=top&&_68d.y<=_691);
};
dojo.html.renderedTextContent=function(node){
node=dojo.byId(node);
var _695="";
if(node==null){
return _695;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
var _697="unknown";
try{
_697=dojo.html.getStyle(node.childNodes[i],"display");
}
catch(E){
}
switch(_697){
case "block":
case "list-item":
case "run-in":
case "table":
case "table-row-group":
case "table-header-group":
case "table-footer-group":
case "table-row":
case "table-column-group":
case "table-column":
case "table-cell":
case "table-caption":
_695+="\n";
_695+=dojo.html.renderedTextContent(node.childNodes[i]);
_695+="\n";
break;
case "none":
break;
default:
if(node.childNodes[i].tagName&&node.childNodes[i].tagName.toLowerCase()=="br"){
_695+="\n";
}else{
_695+=dojo.html.renderedTextContent(node.childNodes[i]);
}
break;
}
break;
case 3:
case 2:
case 4:
var text=node.childNodes[i].nodeValue;
var _699="unknown";
try{
_699=dojo.html.getStyle(node,"text-transform");
}
catch(E){
}
switch(_699){
case "capitalize":
var _69a=text.split(" ");
for(var i=0;i<_69a.length;i++){
_69a[i]=_69a[i].charAt(0).toUpperCase()+_69a[i].substring(1);
}
text=_69a.join(" ");
break;
case "uppercase":
text=text.toUpperCase();
break;
case "lowercase":
text=text.toLowerCase();
break;
default:
break;
}
switch(_699){
case "nowrap":
break;
case "pre-wrap":
break;
case "pre-line":
break;
case "pre":
break;
default:
text=text.replace(/\s+/," ");
if(/\s$/.test(_695)){
text.replace(/^\s/,"");
}
break;
}
_695+=text;
break;
default:
break;
}
}
return _695;
};
dojo.html.createNodesFromText=function(txt,trim){
if(trim){
txt=txt.replace(/^\s+|\s+$/g,"");
}
var tn=dojo.doc().createElement("div");
tn.style.visibility="hidden";
dojo.body().appendChild(tn);
var _69e="none";
if((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody><tr>"+txt+"</tr></tbody></table>";
_69e="cell";
}else{
if((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody>"+txt+"</tbody></table>";
_69e="row";
}else{
if((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table>"+txt+"</table>";
_69e="section";
}
}
}
tn.innerHTML=txt;
if(tn["normalize"]){
tn.normalize();
}
var _69f=null;
switch(_69e){
case "cell":
_69f=tn.getElementsByTagName("tr")[0];
break;
case "row":
_69f=tn.getElementsByTagName("tbody")[0];
break;
case "section":
_69f=tn.getElementsByTagName("table")[0];
break;
default:
_69f=tn;
break;
}
var _6a0=[];
for(var x=0;x<_69f.childNodes.length;x++){
_6a0.push(_69f.childNodes[x].cloneNode(true));
}
tn.style.display="none";
dojo.body().removeChild(tn);
return _6a0;
};
dojo.html.placeOnScreen=function(node,_6a3,_6a4,_6a5,_6a6,_6a7,_6a8){
if(_6a3 instanceof Array||typeof _6a3=="array"){
_6a8=_6a7;
_6a7=_6a6;
_6a6=_6a5;
_6a5=_6a4;
_6a4=_6a3[1];
_6a3=_6a3[0];
}
if(_6a7 instanceof String||typeof _6a7=="string"){
_6a7=_6a7.split(",");
}
if(!isNaN(_6a5)){
_6a5=[Number(_6a5),Number(_6a5)];
}else{
if(!(_6a5 instanceof Array||typeof _6a5=="array")){
_6a5=[0,0];
}
}
var _6a9=dojo.html.getScroll().offset;
var view=dojo.html.getViewport();
node=dojo.byId(node);
var _6ab=node.style.display;
node.style.display="";
var bb=dojo.html.getBorderBox(node);
var w=bb.width;
var h=bb.height;
node.style.display=_6ab;
if(!(_6a7 instanceof Array||typeof _6a7=="array")){
_6a7=["TL"];
}
var _6af,_6b0,_6b1=Infinity,_6b2;
for(var _6b3=0;_6b3<_6a7.length;++_6b3){
var _6b4=_6a7[_6b3];
var _6b5=true;
var tryX=_6a3-(_6b4.charAt(1)=="L"?0:w)+_6a5[0]*(_6b4.charAt(1)=="L"?1:-1);
var tryY=_6a4-(_6b4.charAt(0)=="T"?0:h)+_6a5[1]*(_6b4.charAt(0)=="T"?1:-1);
if(_6a6){
tryX-=_6a9.x;
tryY-=_6a9.y;
}
if(tryX<0){
tryX=0;
_6b5=false;
}
if(tryY<0){
tryY=0;
_6b5=false;
}
var x=tryX+w;
if(x>view.width){
x=view.width-w;
_6b5=false;
}else{
x=tryX;
}
x=Math.max(_6a5[0],x)+_6a9.x;
var y=tryY+h;
if(y>view.height){
y=view.height-h;
_6b5=false;
}else{
y=tryY;
}
y=Math.max(_6a5[1],y)+_6a9.y;
if(_6b5){
_6af=x;
_6b0=y;
_6b1=0;
_6b2=_6b4;
break;
}else{
var dist=Math.pow(x-tryX-_6a9.x,2)+Math.pow(y-tryY-_6a9.y,2);
if(_6b1>dist){
_6b1=dist;
_6af=x;
_6b0=y;
_6b2=_6b4;
}
}
}
if(!_6a8){
node.style.left=_6af+"px";
node.style.top=_6b0+"px";
}
return {left:_6af,top:_6b0,x:_6af,y:_6b0,dist:_6b1,corner:_6b2};
};
dojo.html.placeOnScreenPoint=function(node,_6bc,_6bd,_6be,_6bf){
dojo.deprecated("dojo.html.placeOnScreenPoint","use dojo.html.placeOnScreen() instead","0.5");
return dojo.html.placeOnScreen(node,_6bc,_6bd,_6be,_6bf,["TL","TR","BL","BR"]);
};
dojo.html.placeOnScreenAroundElement=function(node,_6c1,_6c2,_6c3,_6c4,_6c5){
var best,_6c7=Infinity;
_6c1=dojo.byId(_6c1);
var _6c8=_6c1.style.display;
_6c1.style.display="";
var mb=dojo.html.getElementBox(_6c1,_6c3);
var _6ca=mb.width;
var _6cb=mb.height;
var _6cc=dojo.html.getAbsolutePosition(_6c1,true,_6c3);
_6c1.style.display=_6c8;
for(var _6cd in _6c4){
var pos,_6cf,_6d0;
var _6d1=_6c4[_6cd];
_6cf=_6cc.x+(_6cd.charAt(1)=="L"?0:_6ca);
_6d0=_6cc.y+(_6cd.charAt(0)=="T"?0:_6cb);
pos=dojo.html.placeOnScreen(node,_6cf,_6d0,_6c2,true,_6d1,true);
if(pos.dist==0){
best=pos;
break;
}else{
if(_6c7>pos.dist){
_6c7=pos.dist;
best=pos;
}
}
}
if(!_6c5){
node.style.left=best.left+"px";
node.style.top=best.top+"px";
}
return best;
};
dojo.html.scrollIntoView=function(node){
if(!node){
return;
}
if(dojo.render.html.ie){
if(dojo.html.getBorderBox(node.parentNode).height<node.parentNode.scrollHeight){
node.scrollIntoView(false);
}
}else{
if(dojo.render.html.mozilla){
node.scrollIntoView(false);
}else{
var _6d3=node.parentNode;
var _6d4=_6d3.scrollTop+dojo.html.getBorderBox(_6d3).height;
var _6d5=node.offsetTop+dojo.html.getMarginBox(node).height;
if(_6d4<_6d5){
_6d3.scrollTop+=(_6d5-_6d4);
}else{
if(_6d3.scrollTop>node.offsetTop){
_6d3.scrollTop-=(_6d3.scrollTop-node.offsetTop);
}
}
}
}
};
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_6dc){
if(_6dc){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_6dd,_6de){
var rgb=null;
if(dojo.lang.isArray(_6dd)){
rgb=_6dd;
}else{
if(_6dd instanceof dojo.gfx.color.Color){
rgb=_6dd.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_6dd).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_6de);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_6e2){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_6e2);
}
if(!_6e2){
_6e2=0;
}
_6e2=Math.min(Math.max(-1,_6e2),1);
_6e2=((_6e2+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_6e2));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_6e7){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_6e7));
};
dojo.gfx.color.extractRGB=function(_6e8){
var hex="0123456789abcdef";
_6e8=_6e8.toLowerCase();
if(_6e8.indexOf("rgb")==0){
var _6ea=_6e8.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_6ea.splice(1,3);
return ret;
}else{
var _6ec=dojo.gfx.color.hex2rgb(_6e8);
if(_6ec){
return _6ec;
}else{
return dojo.gfx.color.named[_6e8]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _6ee="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_6ee+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_6ee.indexOf(rgb[i].charAt(0))*16+_6ee.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.lfx.Animation");
dojo.lfx.Line=function(_6f7,end){
this.start=_6f7;
this.end=end;
if(dojo.lang.isArray(_6f7)){
var diff=[];
dojo.lang.forEach(this.start,function(s,i){
diff[i]=this.end[i]-s;
},this);
this.getValue=function(n){
var res=[];
dojo.lang.forEach(this.start,function(s,i){
res[i]=(diff[i]*n)+s;
},this);
return res;
};
}else{
var diff=end-_6f7;
this.getValue=function(n){
return (diff*n)+this.start;
};
}
};
dojo.lfx.easeDefault=function(n){
if(dojo.render.html.khtml){
return (parseFloat("0.5")+((Math.sin((n+parseFloat("1.5"))*Math.PI))/2));
}else{
return (0.5+((Math.sin((n+1.5)*Math.PI))/2));
}
};
dojo.lfx.easeIn=function(n){
return Math.pow(n,3);
};
dojo.lfx.easeOut=function(n){
return (1-Math.pow(1-n,3));
};
dojo.lfx.easeInOut=function(n){
return ((3*Math.pow(n,2))-(2*Math.pow(n,3)));
};
dojo.lfx.IAnimation=function(){
};
dojo.lang.extend(dojo.lfx.IAnimation,{curve:null,duration:1000,easing:null,repeatCount:0,rate:25,handler:null,beforeBegin:null,onBegin:null,onAnimate:null,onEnd:null,onPlay:null,onPause:null,onStop:null,play:null,pause:null,stop:null,connect:function(evt,_706,_707){
if(!_707){
_707=_706;
_706=this;
}
_707=dojo.lang.hitch(_706,_707);
var _708=this[evt]||function(){
};
this[evt]=function(){
var ret=_708.apply(this,arguments);
_707.apply(this,arguments);
return ret;
};
return this;
},fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,(args||[]));
}
return this;
},repeat:function(_70c){
this.repeatCount=_70c;
return this;
},_active:false,_paused:false});
dojo.lfx.Animation=function(_70d,_70e,_70f,_710,_711,rate){
dojo.lfx.IAnimation.call(this);
if(dojo.lang.isNumber(_70d)||(!_70d&&_70e.getValue)){
rate=_711;
_711=_710;
_710=_70f;
_70f=_70e;
_70e=_70d;
_70d=null;
}else{
if(_70d.getValue||dojo.lang.isArray(_70d)){
rate=_710;
_711=_70f;
_710=_70e;
_70f=_70d;
_70e=null;
_70d=null;
}
}
if(dojo.lang.isArray(_70f)){
this.curve=new dojo.lfx.Line(_70f[0],_70f[1]);
}else{
this.curve=_70f;
}
if(_70e!=null&&_70e>0){
this.duration=_70e;
}
if(_711){
this.repeatCount=_711;
}
if(rate){
this.rate=rate;
}
if(_70d){
dojo.lang.forEach(["handler","beforeBegin","onBegin","onEnd","onPlay","onStop","onAnimate"],function(item){
if(_70d[item]){
this.connect(item,_70d[item]);
}
},this);
}
if(_710&&dojo.lang.isFunction(_710)){
this.easing=_710;
}
};
dojo.inherits(dojo.lfx.Animation,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Animation,{_startTime:null,_endTime:null,_timer:null,_percent:0,_startRepeatCount:0,play:function(_714,_715){
if(_715){
clearTimeout(this._timer);
this._active=false;
this._paused=false;
this._percent=0;
}else{
if(this._active&&!this._paused){
return this;
}
}
this.fire("handler",["beforeBegin"]);
this.fire("beforeBegin");
if(_714>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_715);
}),_714);
return this;
}
this._startTime=new Date().valueOf();
if(this._paused){
this._startTime-=(this.duration*this._percent/100);
}
this._endTime=this._startTime+this.duration;
this._active=true;
this._paused=false;
var step=this._percent/100;
var _717=this.curve.getValue(step);
if(this._percent==0){
if(!this._startRepeatCount){
this._startRepeatCount=this.repeatCount;
}
this.fire("handler",["begin",_717]);
this.fire("onBegin",[_717]);
}
this.fire("handler",["play",_717]);
this.fire("onPlay",[_717]);
this._cycle();
return this;
},pause:function(){
clearTimeout(this._timer);
if(!this._active){
return this;
}
this._paused=true;
var _718=this.curve.getValue(this._percent/100);
this.fire("handler",["pause",_718]);
this.fire("onPause",[_718]);
return this;
},gotoPercent:function(pct,_71a){
clearTimeout(this._timer);
this._active=true;
this._paused=true;
this._percent=pct;
if(_71a){
this.play();
}
return this;
},stop:function(_71b){
clearTimeout(this._timer);
var step=this._percent/100;
if(_71b){
step=1;
}
var _71d=this.curve.getValue(step);
this.fire("handler",["stop",_71d]);
this.fire("onStop",[_71d]);
this._active=false;
this._paused=false;
return this;
},status:function(){
if(this._active){
return this._paused?"paused":"playing";
}else{
return "stopped";
}
return this;
},_cycle:function(){
clearTimeout(this._timer);
if(this._active){
var curr=new Date().valueOf();
var step=(curr-this._startTime)/(this._endTime-this._startTime);
if(step>=1){
step=1;
this._percent=100;
}else{
this._percent=step*100;
}
if((this.easing)&&(dojo.lang.isFunction(this.easing))){
step=this.easing(step);
}
var _720=this.curve.getValue(step);
this.fire("handler",["animate",_720]);
this.fire("onAnimate",[_720]);
if(step<1){
this._timer=setTimeout(dojo.lang.hitch(this,"_cycle"),this.rate);
}else{
this._active=false;
this.fire("handler",["end"]);
this.fire("onEnd");
if(this.repeatCount>0){
this.repeatCount--;
this.play(null,true);
}else{
if(this.repeatCount==-1){
this.play(null,true);
}else{
if(this._startRepeatCount){
this.repeatCount=this._startRepeatCount;
this._startRepeatCount=0;
}
}
}
}
}
return this;
}});
dojo.lfx.Combine=function(_721){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._animsEnded=0;
var _722=arguments;
if(_722.length==1&&(dojo.lang.isArray(_722[0])||dojo.lang.isArrayLike(_722[0]))){
_722=_722[0];
}
dojo.lang.forEach(_722,function(anim){
this._anims.push(anim);
anim.connect("onEnd",dojo.lang.hitch(this,"_onAnimsEnded"));
},this);
};
dojo.inherits(dojo.lfx.Combine,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Combine,{_animsEnded:0,play:function(_724,_725){
if(!this._anims.length){
return this;
}
this.fire("beforeBegin");
if(_724>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_725);
}),_724);
return this;
}
if(_725||this._anims[0].percent==0){
this.fire("onBegin");
}
this.fire("onPlay");
this._animsCall("play",null,_725);
return this;
},pause:function(){
this.fire("onPause");
this._animsCall("pause");
return this;
},stop:function(_726){
this.fire("onStop");
this._animsCall("stop",_726);
return this;
},_onAnimsEnded:function(){
this._animsEnded++;
if(this._animsEnded>=this._anims.length){
this.fire("onEnd");
}
return this;
},_animsCall:function(_727){
var args=[];
if(arguments.length>1){
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
var _72a=this;
dojo.lang.forEach(this._anims,function(anim){
anim[_727](args);
},_72a);
return this;
}});
dojo.lfx.Chain=function(_72c){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._currAnim=-1;
var _72d=arguments;
if(_72d.length==1&&(dojo.lang.isArray(_72d[0])||dojo.lang.isArrayLike(_72d[0]))){
_72d=_72d[0];
}
var _72e=this;
dojo.lang.forEach(_72d,function(anim,i,_731){
this._anims.push(anim);
if(i<_731.length-1){
anim.connect("onEnd",dojo.lang.hitch(this,"_playNext"));
}else{
anim.connect("onEnd",dojo.lang.hitch(this,function(){
this.fire("onEnd");
}));
}
},this);
};
dojo.inherits(dojo.lfx.Chain,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Chain,{_currAnim:-1,play:function(_732,_733){
if(!this._anims.length){
return this;
}
if(_733||!this._anims[this._currAnim]){
this._currAnim=0;
}
var _734=this._anims[this._currAnim];
this.fire("beforeBegin");
if(_732>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_733);
}),_732);
return this;
}
if(_734){
if(this._currAnim==0){
this.fire("handler",["begin",this._currAnim]);
this.fire("onBegin",[this._currAnim]);
}
this.fire("onPlay",[this._currAnim]);
_734.play(null,_733);
}
return this;
},pause:function(){
if(this._anims[this._currAnim]){
this._anims[this._currAnim].pause();
this.fire("onPause",[this._currAnim]);
}
return this;
},playPause:function(){
if(this._anims.length==0){
return this;
}
if(this._currAnim==-1){
this._currAnim=0;
}
var _735=this._anims[this._currAnim];
if(_735){
if(!_735._active||_735._paused){
this.play();
}else{
this.pause();
}
}
return this;
},stop:function(){
var _736=this._anims[this._currAnim];
if(_736){
_736.stop();
this.fire("onStop",[this._currAnim]);
}
return _736;
},_playNext:function(){
if(this._currAnim==-1||this._anims.length==0){
return this;
}
this._currAnim++;
if(this._anims[this._currAnim]){
this._anims[this._currAnim].play(null,true);
}
return this;
}});
dojo.lfx.combine=function(_737){
var _738=arguments;
if(dojo.lang.isArray(arguments[0])){
_738=arguments[0];
}
if(_738.length==1){
return _738[0];
}
return new dojo.lfx.Combine(_738);
};
dojo.lfx.chain=function(_739){
var _73a=arguments;
if(dojo.lang.isArray(arguments[0])){
_73a=arguments[0];
}
if(_73a.length==1){
return _73a[0];
}
return new dojo.lfx.Chain(_73a);
};
dojo.provide("dojo.html.color");
dojo.html.getBackgroundColor=function(node){
node=dojo.byId(node);
var _73c;
do{
_73c=dojo.html.getStyle(node,"background-color");
if(_73c.toLowerCase()=="rgba(0, 0, 0, 0)"){
_73c="transparent";
}
if(node==document.getElementsByTagName("body")[0]){
node=null;
break;
}
node=node.parentNode;
}while(node&&dojo.lang.inArray(["transparent",""],_73c));
if(_73c=="transparent"){
_73c=[255,255,255,0];
}else{
_73c=dojo.gfx.color.extractRGB(_73c);
}
return _73c;
};
dojo.provide("dojo.lfx.html");
dojo.lfx.html._byId=function(_73d){
if(!_73d){
return [];
}
if(dojo.lang.isArrayLike(_73d)){
if(!_73d.alreadyChecked){
var n=[];
dojo.lang.forEach(_73d,function(node){
n.push(dojo.byId(node));
});
n.alreadyChecked=true;
return n;
}else{
return _73d;
}
}else{
var n=[];
n.push(dojo.byId(_73d));
n.alreadyChecked=true;
return n;
}
};
dojo.lfx.html.propertyAnimation=function(_740,_741,_742,_743,_744){
_740=dojo.lfx.html._byId(_740);
var _745={"propertyMap":_741,"nodes":_740,"duration":_742,"easing":_743||dojo.lfx.easeDefault};
var _746=function(args){
if(args.nodes.length==1){
var pm=args.propertyMap;
if(!dojo.lang.isArray(args.propertyMap)){
var parr=[];
for(var _74a in pm){
pm[_74a].property=_74a;
parr.push(pm[_74a]);
}
pm=args.propertyMap=parr;
}
dojo.lang.forEach(pm,function(prop){
if(dj_undef("start",prop)){
if(prop.property!="opacity"){
prop.start=parseInt(dojo.html.getComputedStyle(args.nodes[0],prop.property));
}else{
prop.start=dojo.html.getOpacity(args.nodes[0]);
}
}
});
}
};
var _74c=function(_74d){
var _74e=[];
dojo.lang.forEach(_74d,function(c){
_74e.push(Math.round(c));
});
return _74e;
};
var _750=function(n,_752){
n=dojo.byId(n);
if(!n||!n.style){
return;
}
for(var s in _752){
if(s=="opacity"){
dojo.html.setOpacity(n,_752[s]);
}else{
n.style[s]=_752[s];
}
}
};
var _754=function(_755){
this._properties=_755;
this.diffs=new Array(_755.length);
dojo.lang.forEach(_755,function(prop,i){
if(dojo.lang.isFunction(prop.start)){
prop.start=prop.start(prop,i);
}
if(dojo.lang.isFunction(prop.end)){
prop.end=prop.end(prop,i);
}
if(dojo.lang.isArray(prop.start)){
this.diffs[i]=null;
}else{
if(prop.start instanceof dojo.gfx.color.Color){
prop.startRgb=prop.start.toRgb();
prop.endRgb=prop.end.toRgb();
}else{
this.diffs[i]=prop.end-prop.start;
}
}
},this);
this.getValue=function(n){
var ret={};
dojo.lang.forEach(this._properties,function(prop,i){
var _75c=null;
if(dojo.lang.isArray(prop.start)){
}else{
if(prop.start instanceof dojo.gfx.color.Color){
_75c=(prop.units||"rgb")+"(";
for(var j=0;j<prop.startRgb.length;j++){
_75c+=Math.round(((prop.endRgb[j]-prop.startRgb[j])*n)+prop.startRgb[j])+(j<prop.startRgb.length-1?",":"");
}
_75c+=")";
}else{
_75c=((this.diffs[i])*n)+prop.start+(prop.property!="opacity"?prop.units||"px":"");
}
}
ret[dojo.html.toCamelCase(prop.property)]=_75c;
},this);
return ret;
};
};
var anim=new dojo.lfx.Animation({beforeBegin:function(){
_746(_745);
anim.curve=new _754(_745.propertyMap);
},onAnimate:function(_75f){
dojo.lang.forEach(_745.nodes,function(node){
_750(node,_75f);
});
}},_745.duration,null,_745.easing);
if(_744){
for(var x in _744){
if(dojo.lang.isFunction(_744[x])){
anim.connect(x,anim,_744[x]);
}
}
}
return anim;
};
dojo.lfx.html._makeFadeable=function(_762){
var _763=function(node){
if(dojo.render.html.ie){
if((node.style.zoom.length==0)&&(dojo.html.getStyle(node,"zoom")=="normal")){
node.style.zoom="1";
}
if((node.style.width.length==0)&&(dojo.html.getStyle(node,"width")=="auto")){
node.style.width="auto";
}
}
};
if(dojo.lang.isArrayLike(_762)){
dojo.lang.forEach(_762,_763);
}else{
_763(_762);
}
};
dojo.lfx.html.fade=function(_765,_766,_767,_768,_769){
_765=dojo.lfx.html._byId(_765);
var _76a={property:"opacity"};
if(!dj_undef("start",_766)){
_76a.start=_766.start;
}else{
_76a.start=function(){
return dojo.html.getOpacity(_765[0]);
};
}
if(!dj_undef("end",_766)){
_76a.end=_766.end;
}else{
dojo.raise("dojo.lfx.html.fade needs an end value");
}
var anim=dojo.lfx.propertyAnimation(_765,[_76a],_767,_768);
anim.connect("beforeBegin",function(){
dojo.lfx.html._makeFadeable(_765);
});
if(_769){
anim.connect("onEnd",function(){
_769(_765,anim);
});
}
return anim;
};
dojo.lfx.html.fadeIn=function(_76c,_76d,_76e,_76f){
return dojo.lfx.html.fade(_76c,{end:1},_76d,_76e,_76f);
};
dojo.lfx.html.fadeOut=function(_770,_771,_772,_773){
return dojo.lfx.html.fade(_770,{end:0},_771,_772,_773);
};
dojo.lfx.html.fadeShow=function(_774,_775,_776,_777){
_774=dojo.lfx.html._byId(_774);
dojo.lang.forEach(_774,function(node){
dojo.html.setOpacity(node,0);
});
var anim=dojo.lfx.html.fadeIn(_774,_775,_776,_777);
anim.connect("beforeBegin",function(){
if(dojo.lang.isArrayLike(_774)){
dojo.lang.forEach(_774,dojo.html.show);
}else{
dojo.html.show(_774);
}
});
return anim;
};
dojo.lfx.html.fadeHide=function(_77a,_77b,_77c,_77d){
var anim=dojo.lfx.html.fadeOut(_77a,_77b,_77c,function(){
if(dojo.lang.isArrayLike(_77a)){
dojo.lang.forEach(_77a,dojo.html.hide);
}else{
dojo.html.hide(_77a);
}
if(_77d){
_77d(_77a,anim);
}
});
return anim;
};
dojo.lfx.html.wipeIn=function(_77f,_780,_781,_782){
_77f=dojo.lfx.html._byId(_77f);
var _783=[];
dojo.lang.forEach(_77f,function(node){
var _785={};
dojo.html.show(node);
var _786=dojo.html.getBorderBox(node).height;
dojo.html.hide(node);
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:1,end:function(){
return _786;
}}},_780,_781);
anim.connect("beforeBegin",function(){
_785.overflow=node.style.overflow;
_785.height=node.style.height;
with(node.style){
overflow="hidden";
_786="1px";
}
dojo.html.show(node);
});
anim.connect("onEnd",function(){
with(node.style){
overflow=_785.overflow;
_786=_785.height;
}
if(_782){
_782(node,anim);
}
});
_783.push(anim);
});
return dojo.lfx.combine(_783);
};
dojo.lfx.html.wipeOut=function(_788,_789,_78a,_78b){
_788=dojo.lfx.html._byId(_788);
var _78c=[];
dojo.lang.forEach(_788,function(node){
var _78e={};
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:function(){
return dojo.html.getContentBox(node).height;
},end:1}},_789,_78a,{"beforeBegin":function(){
_78e.overflow=node.style.overflow;
_78e.height=node.style.height;
with(node.style){
overflow="hidden";
}
dojo.html.show(node);
},"onEnd":function(){
dojo.html.hide(node);
with(node.style){
overflow=_78e.overflow;
height=_78e.height;
}
if(_78b){
_78b(node,anim);
}
}});
_78c.push(anim);
});
return dojo.lfx.combine(_78c);
};
dojo.lfx.html.slideTo=function(_790,_791,_792,_793,_794){
_790=dojo.lfx.html._byId(_790);
var _795=[];
var _796=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_791)){
dojo.deprecated("dojo.lfx.html.slideTo(node, array)","use dojo.lfx.html.slideTo(node, {top: value, left: value});","0.5");
_791={top:_791[0],left:_791[1]};
}
dojo.lang.forEach(_790,function(node){
var top=null;
var left=null;
var init=(function(){
var _79b=node;
return function(){
var pos=_796(_79b,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_796(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_796(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_79b,true);
dojo.html.setStyleAttributes(_79b,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:(_791.top||0)},"left":{start:left,end:(_791.left||0)}},_792,_793,{"beforeBegin":init});
if(_794){
anim.connect("onEnd",function(){
_794(_790,anim);
});
}
_795.push(anim);
});
return dojo.lfx.combine(_795);
};
dojo.lfx.html.slideBy=function(_79f,_7a0,_7a1,_7a2,_7a3){
_79f=dojo.lfx.html._byId(_79f);
var _7a4=[];
var _7a5=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_7a0)){
dojo.deprecated("dojo.lfx.html.slideBy(node, array)","use dojo.lfx.html.slideBy(node, {top: value, left: value});","0.5");
_7a0={top:_7a0[0],left:_7a0[1]};
}
dojo.lang.forEach(_79f,function(node){
var top=null;
var left=null;
var init=(function(){
var _7aa=node;
return function(){
var pos=_7a5(_7aa,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_7a5(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_7a5(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_7aa,true);
dojo.html.setStyleAttributes(_7aa,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:top+(_7a0.top||0)},"left":{start:left,end:left+(_7a0.left||0)}},_7a1,_7a2).connect("beforeBegin",init);
if(_7a3){
anim.connect("onEnd",function(){
_7a3(_79f,anim);
});
}
_7a4.push(anim);
});
return dojo.lfx.combine(_7a4);
};
dojo.lfx.html.explode=function(_7ae,_7af,_7b0,_7b1,_7b2){
var h=dojo.html;
_7ae=dojo.byId(_7ae);
_7af=dojo.byId(_7af);
var _7b4=h.toCoordinateObject(_7ae,true);
var _7b5=document.createElement("div");
h.copyStyle(_7b5,_7af);
if(_7af.explodeClassName){
_7b5.className=_7af.explodeClassName;
}
with(_7b5.style){
position="absolute";
display="none";
}
dojo.body().appendChild(_7b5);
with(_7af.style){
visibility="hidden";
display="block";
}
var _7b6=h.toCoordinateObject(_7af,true);
with(_7af.style){
display="none";
visibility="visible";
}
var _7b7={opacity:{start:0.5,end:1}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_7b7[type]={start:_7b4[type],end:_7b6[type]};
});
var anim=new dojo.lfx.propertyAnimation(_7b5,_7b7,_7b0,_7b1,{"beforeBegin":function(){
h.setDisplay(_7b5,"block");
},"onEnd":function(){
h.setDisplay(_7af,"block");
_7b5.parentNode.removeChild(_7b5);
}});
if(_7b2){
anim.connect("onEnd",function(){
_7b2(_7af,anim);
});
}
return anim;
};
dojo.lfx.html.implode=function(_7ba,end,_7bc,_7bd,_7be){
var h=dojo.html;
_7ba=dojo.byId(_7ba);
end=dojo.byId(end);
var _7c0=dojo.html.toCoordinateObject(_7ba,true);
var _7c1=dojo.html.toCoordinateObject(end,true);
var _7c2=document.createElement("div");
dojo.html.copyStyle(_7c2,_7ba);
if(_7ba.explodeClassName){
_7c2.className=_7ba.explodeClassName;
}
dojo.html.setOpacity(_7c2,0.3);
with(_7c2.style){
position="absolute";
display="none";
backgroundColor=h.getStyle(_7ba,"background-color").toLowerCase();
}
dojo.body().appendChild(_7c2);
var _7c3={opacity:{start:1,end:0.5}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_7c3[type]={start:_7c0[type],end:_7c1[type]};
});
var anim=new dojo.lfx.propertyAnimation(_7c2,_7c3,_7bc,_7bd,{"beforeBegin":function(){
dojo.html.hide(_7ba);
dojo.html.show(_7c2);
},"onEnd":function(){
_7c2.parentNode.removeChild(_7c2);
}});
if(_7be){
anim.connect("onEnd",function(){
_7be(_7ba,anim);
});
}
return anim;
};
dojo.lfx.html.highlight=function(_7c6,_7c7,_7c8,_7c9,_7ca){
_7c6=dojo.lfx.html._byId(_7c6);
var _7cb=[];
dojo.lang.forEach(_7c6,function(node){
var _7cd=dojo.html.getBackgroundColor(node);
var bg=dojo.html.getStyle(node,"background-color").toLowerCase();
var _7cf=dojo.html.getStyle(node,"background-image");
var _7d0=(bg=="transparent"||bg=="rgba(0, 0, 0, 0)");
while(_7cd.length>3){
_7cd.pop();
}
var rgb=new dojo.gfx.color.Color(_7c7);
var _7d2=new dojo.gfx.color.Color(_7cd);
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:rgb,end:_7d2}},_7c8,_7c9,{"beforeBegin":function(){
if(_7cf){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+rgb.toRgb().join(",")+")";
},"onEnd":function(){
if(_7cf){
node.style.backgroundImage=_7cf;
}
if(_7d0){
node.style.backgroundColor="transparent";
}
if(_7ca){
_7ca(node,anim);
}
}});
_7cb.push(anim);
});
return dojo.lfx.combine(_7cb);
};
dojo.lfx.html.unhighlight=function(_7d4,_7d5,_7d6,_7d7,_7d8){
_7d4=dojo.lfx.html._byId(_7d4);
var _7d9=[];
dojo.lang.forEach(_7d4,function(node){
var _7db=new dojo.gfx.color.Color(dojo.html.getBackgroundColor(node));
var rgb=new dojo.gfx.color.Color(_7d5);
var _7dd=dojo.html.getStyle(node,"background-image");
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:_7db,end:rgb}},_7d6,_7d7,{"beforeBegin":function(){
if(_7dd){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+_7db.toRgb().join(",")+")";
},"onEnd":function(){
if(_7d8){
_7d8(node,anim);
}
}});
_7d9.push(anim);
});
return dojo.lfx.combine(_7d9);
};
dojo.lang.mixin(dojo.lfx,dojo.lfx.html);
dojo.provide("dojo.lfx.*");
dojo.provide("dojo.lfx.toggle");
dojo.lfx.toggle.plain={show:function(node,_7e0,_7e1,_7e2){
dojo.html.show(node);
if(dojo.lang.isFunction(_7e2)){
_7e2();
}
},hide:function(node,_7e4,_7e5,_7e6){
dojo.html.hide(node);
if(dojo.lang.isFunction(_7e6)){
_7e6();
}
}};
dojo.lfx.toggle.fade={show:function(node,_7e8,_7e9,_7ea){
dojo.lfx.fadeShow(node,_7e8,_7e9,_7ea).play();
},hide:function(node,_7ec,_7ed,_7ee){
dojo.lfx.fadeHide(node,_7ec,_7ed,_7ee).play();
}};
dojo.lfx.toggle.wipe={show:function(node,_7f0,_7f1,_7f2){
dojo.lfx.wipeIn(node,_7f0,_7f1,_7f2).play();
},hide:function(node,_7f4,_7f5,_7f6){
dojo.lfx.wipeOut(node,_7f4,_7f5,_7f6).play();
}};
dojo.lfx.toggle.explode={show:function(node,_7f8,_7f9,_7fa,_7fb){
dojo.lfx.explode(_7fb||{x:0,y:0,width:0,height:0},node,_7f8,_7f9,_7fa).play();
},hide:function(node,_7fd,_7fe,_7ff,_800){
dojo.lfx.implode(node,_800||{x:0,y:0,width:0,height:0},_7fd,_7fe,_7ff).play();
}};
dojo.provide("dojo.widget.HtmlWidget");
dojo.declare("dojo.widget.HtmlWidget",dojo.widget.DomWidget,{widgetType:"HtmlWidget",templateCssPath:null,templatePath:null,lang:"",toggle:"plain",toggleDuration:150,animationInProgress:false,initialize:function(args,frag){
},postMixInProperties:function(args,frag){
if(this.lang===""){
this.lang=null;
}
this.toggleObj=dojo.lfx.toggle[this.toggle.toLowerCase()]||dojo.lfx.toggle.plain;
},getContainerHeight:function(){
dojo.unimplemented("dojo.widget.HtmlWidget.getContainerHeight");
},getContainerWidth:function(){
return this.parent.domNode.offsetWidth;
},setNativeHeight:function(_805){
var ch=this.getContainerHeight();
},createNodesFromText:function(txt,wrap){
return dojo.html.createNodesFromText(txt,wrap);
},destroyRendering:function(_809){
try{
if(!_809&&this.domNode){
dojo.event.browser.clean(this.domNode);
}
this.domNode.parentNode.removeChild(this.domNode);
delete this.domNode;
}
catch(e){
}
},isShowing:function(){
return dojo.html.isShowing(this.domNode);
},toggleShowing:function(){
if(this.isHidden){
this.show();
}else{
this.hide();
}
},show:function(){
this.animationInProgress=true;
this.isHidden=false;
this.toggleObj.show(this.domNode,this.toggleDuration,null,dojo.lang.hitch(this,this.onShow),this.explodeSrc);
},onShow:function(){
this.animationInProgress=false;
this.checkSize();
},hide:function(){
this.animationInProgress=true;
this.isHidden=true;
this.toggleObj.hide(this.domNode,this.toggleDuration,null,dojo.lang.hitch(this,this.onHide),this.explodeSrc);
},onHide:function(){
this.animationInProgress=false;
},_isResized:function(w,h){
if(!this.isShowing()){
return false;
}
var wh=dojo.html.getMarginBox(this.domNode);
var _80d=w||wh.width;
var _80e=h||wh.height;
if(this.width==_80d&&this.height==_80e){
return false;
}
this.width=_80d;
this.height=_80e;
return true;
},checkSize:function(){
if(!this._isResized()){
return;
}
this.onResized();
},resizeTo:function(w,h){
dojo.html.setMarginBox(this.domNode,{width:w,height:h});
if(this.isShowing()){
this.onResized();
}
},resizeSoon:function(){
if(this.isShowing()){
dojo.lang.setTimeout(this,this.onResized,0);
}
},onResized:function(){
dojo.lang.forEach(this.children,function(_811){
if(_811.checkSize){
_811.checkSize();
}
});
}});
dojo.provide("dojo.widget.*");
dojo.provide("dojo.widget.Toolbar");
dojo.widget.defineWidget("dojo.widget.ToolbarContainer",dojo.widget.HtmlWidget,{isContainer:true,templateString:"<div class=\"toolbarContainer\" dojoAttachPoint=\"containerNode\"></div>",templateCssPath:dojo.uri.dojoUri("src/widget/templates/Toolbar.css"),getItem:function(name){
if(name instanceof dojo.widget.ToolbarItem){
return name;
}
for(var i=0;i<this.children.length;i++){
var _814=this.children[i];
if(_814 instanceof dojo.widget.Toolbar){
var item=_814.getItem(name);
if(item){
return item;
}
}
}
return null;
},getItems:function(){
var _816=[];
for(var i=0;i<this.children.length;i++){
var _818=this.children[i];
if(_818 instanceof dojo.widget.Toolbar){
_816=_816.concat(_818.getItems());
}
}
return _816;
},enable:function(){
for(var i=0;i<this.children.length;i++){
var _81a=this.children[i];
if(_81a instanceof dojo.widget.Toolbar){
_81a.enable.apply(_81a,arguments);
}
}
},disable:function(){
for(var i=0;i<this.children.length;i++){
var _81c=this.children[i];
if(_81c instanceof dojo.widget.Toolbar){
_81c.disable.apply(_81c,arguments);
}
}
},select:function(name){
for(var i=0;i<this.children.length;i++){
var _81f=this.children[i];
if(_81f instanceof dojo.widget.Toolbar){
_81f.select(arguments);
}
}
},deselect:function(name){
for(var i=0;i<this.children.length;i++){
var _822=this.children[i];
if(_822 instanceof dojo.widget.Toolbar){
_822.deselect(arguments);
}
}
},getItemsState:function(){
var _823={};
for(var i=0;i<this.children.length;i++){
var _825=this.children[i];
if(_825 instanceof dojo.widget.Toolbar){
dojo.lang.mixin(_823,_825.getItemsState());
}
}
return _823;
},getItemsActiveState:function(){
var _826={};
for(var i=0;i<this.children.length;i++){
var _828=this.children[i];
if(_828 instanceof dojo.widget.Toolbar){
dojo.lang.mixin(_826,_828.getItemsActiveState());
}
}
return _826;
},getItemsSelectedState:function(){
var _829={};
for(var i=0;i<this.children.length;i++){
var _82b=this.children[i];
if(_82b instanceof dojo.widget.Toolbar){
dojo.lang.mixin(_829,_82b.getItemsSelectedState());
}
}
return _829;
}});
dojo.widget.defineWidget("dojo.widget.Toolbar",dojo.widget.HtmlWidget,{isContainer:true,templateString:"<div class=\"toolbar\" dojoAttachPoint=\"containerNode\" unselectable=\"on\" dojoOnMouseover=\"_onmouseover\" dojoOnMouseout=\"_onmouseout\" dojoOnClick=\"_onclick\" dojoOnMousedown=\"_onmousedown\" dojoOnMouseup=\"_onmouseup\"></div>",_getItem:function(node){
var _82d=new Date();
var _82e=null;
while(node&&node!=this.domNode){
if(dojo.html.hasClass(node,"toolbarItem")){
var _82f=dojo.widget.manager.getWidgetsByFilter(function(w){
return w.domNode==node;
});
if(_82f.length==1){
_82e=_82f[0];
break;
}else{
if(_82f.length>1){
dojo.raise("Toolbar._getItem: More than one widget matches the node");
}
}
}
node=node.parentNode;
}
return _82e;
},_onmouseover:function(e){
var _832=this._getItem(e.target);
if(_832&&_832._onmouseover){
_832._onmouseover(e);
}
},_onmouseout:function(e){
var _834=this._getItem(e.target);
if(_834&&_834._onmouseout){
_834._onmouseout(e);
}
},_onclick:function(e){
var _836=this._getItem(e.target);
if(_836&&_836._onclick){
_836._onclick(e);
}
},_onmousedown:function(e){
var _838=this._getItem(e.target);
if(_838&&_838._onmousedown){
_838._onmousedown(e);
}
},_onmouseup:function(e){
var _83a=this._getItem(e.target);
if(_83a&&_83a._onmouseup){
_83a._onmouseup(e);
}
},addChild:function(item,pos,_83d){
var _83e=dojo.widget.ToolbarItem.make(item,null,_83d);
var ret=dojo.widget.Toolbar.superclass.addChild.call(this,_83e,null,pos,null);
return ret;
},push:function(){
for(var i=0;i<arguments.length;i++){
this.addChild(arguments[i]);
}
},getItem:function(name){
if(name instanceof dojo.widget.ToolbarItem){
return name;
}
for(var i=0;i<this.children.length;i++){
var _843=this.children[i];
if(_843 instanceof dojo.widget.ToolbarItem&&_843._name==name){
return _843;
}
}
return null;
},getItems:function(){
var _844=[];
for(var i=0;i<this.children.length;i++){
var _846=this.children[i];
if(_846 instanceof dojo.widget.ToolbarItem){
_844.push(_846);
}
}
return _844;
},getItemsState:function(){
var _847={};
for(var i=0;i<this.children.length;i++){
var _849=this.children[i];
if(_849 instanceof dojo.widget.ToolbarItem){
_847[_849._name]={selected:_849._selected,enabled:_849._enabled};
}
}
return _847;
},getItemsActiveState:function(){
var _84a=this.getItemsState();
for(var item in _84a){
_84a[item]=_84a[item].enabled;
}
return _84a;
},getItemsSelectedState:function(){
var _84c=this.getItemsState();
for(var item in _84c){
_84c[item]=_84c[item].selected;
}
return _84c;
},enable:function(){
var _84e=arguments.length?arguments:this.children;
for(var i=0;i<_84e.length;i++){
var _850=this.getItem(_84e[i]);
if(_850 instanceof dojo.widget.ToolbarItem){
_850.enable(false,true);
}
}
},disable:function(){
var _851=arguments.length?arguments:this.children;
for(var i=0;i<_851.length;i++){
var _853=this.getItem(_851[i]);
if(_853 instanceof dojo.widget.ToolbarItem){
_853.disable();
}
}
},select:function(){
for(var i=0;i<arguments.length;i++){
var name=arguments[i];
var item=this.getItem(name);
if(item){
item.select();
}
}
},deselect:function(){
for(var i=0;i<arguments.length;i++){
var name=arguments[i];
var item=this.getItem(name);
if(item){
item.disable();
}
}
},setValue:function(){
for(var i=0;i<arguments.length;i+=2){
var name=arguments[i],_85c=arguments[i+1];
var item=this.getItem(name);
if(item){
if(item instanceof dojo.widget.ToolbarItem){
item.setValue(_85c);
}
}
}
}});
dojo.widget.defineWidget("dojo.widget.ToolbarItem",dojo.widget.HtmlWidget,{templateString:"<span unselectable=\"on\" class=\"toolbarItem\"></span>",_name:null,getName:function(){
return this._name;
},setName:function(_85e){
return (this._name=_85e);
},getValue:function(){
return this.getName();
},setValue:function(_85f){
return this.setName(_85f);
},_selected:false,isSelected:function(){
return this._selected;
},setSelected:function(is,_861,_862){
if(!this._toggleItem&&!_861){
return;
}
is=Boolean(is);
if(_861||this._enabled&&this._selected!=is){
this._selected=is;
this.update();
if(!_862){
this._fireEvent(is?"onSelect":"onDeselect");
this._fireEvent("onChangeSelect");
}
}
},select:function(_863,_864){
return this.setSelected(true,_863,_864);
},deselect:function(_865,_866){
return this.setSelected(false,_865,_866);
},_toggleItem:false,isToggleItem:function(){
return this._toggleItem;
},setToggleItem:function(_867){
this._toggleItem=Boolean(_867);
},toggleSelected:function(_868){
return this.setSelected(!this._selected,_868);
},_enabled:true,isEnabled:function(){
return this._enabled;
},setEnabled:function(is,_86a,_86b){
is=Boolean(is);
if(_86a||this._enabled!=is){
this._enabled=is;
this.update();
if(!_86b){
this._fireEvent(this._enabled?"onEnable":"onDisable");
this._fireEvent("onChangeEnabled");
}
}
return this._enabled;
},enable:function(_86c,_86d){
return this.setEnabled(true,_86c,_86d);
},disable:function(_86e,_86f){
return this.setEnabled(false,_86e,_86f);
},toggleEnabled:function(_870,_871){
return this.setEnabled(!this._enabled,_870,_871);
},_icon:null,getIcon:function(){
return this._icon;
},setIcon:function(_872){
var icon=dojo.widget.Icon.make(_872);
if(this._icon){
this._icon.setIcon(icon);
}else{
this._icon=icon;
}
var _874=this._icon.getNode();
if(_874.parentNode!=this.domNode){
if(this.domNode.hasChildNodes()){
this.domNode.insertBefore(_874,this.domNode.firstChild);
}else{
this.domNode.appendChild(_874);
}
}
return this._icon;
},_label:"",getLabel:function(){
return this._label;
},setLabel:function(_875){
var ret=(this._label=_875);
if(!this.labelNode){
this.labelNode=document.createElement("span");
this.domNode.appendChild(this.labelNode);
}
this.labelNode.innerHTML="";
this.labelNode.appendChild(document.createTextNode(this._label));
this.update();
return ret;
},update:function(){
if(this._enabled){
dojo.html.removeClass(this.domNode,"disabled");
if(this._selected){
dojo.html.addClass(this.domNode,"selected");
}else{
dojo.html.removeClass(this.domNode,"selected");
}
}else{
this._selected=false;
dojo.html.addClass(this.domNode,"disabled");
dojo.html.removeClass(this.domNode,"down");
dojo.html.removeClass(this.domNode,"hover");
}
this._updateIcon();
},_updateIcon:function(){
if(this._icon){
if(this._enabled){
if(this._cssHover){
this._icon.hover();
}else{
if(this._selected){
this._icon.select();
}else{
this._icon.enable();
}
}
}else{
this._icon.disable();
}
}
},_fireEvent:function(evt){
if(typeof this[evt]=="function"){
var args=[this];
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
this[evt].apply(this,args);
}
},_onmouseover:function(e){
if(!this._enabled){
return;
}
dojo.html.addClass(this.domNode,"hover");
this._fireEvent("onMouseOver");
},_onmouseout:function(e){
dojo.html.removeClass(this.domNode,"hover");
dojo.html.removeClass(this.domNode,"down");
if(!this._selected){
dojo.html.removeClass(this.domNode,"selected");
}
this._fireEvent("onMouseOut");
},_onclick:function(e){
if(this._enabled&&!this._toggleItem){
this._fireEvent("onClick");
}
},_onmousedown:function(e){
if(e.preventDefault){
e.preventDefault();
}
if(!this._enabled){
return;
}
dojo.html.addClass(this.domNode,"down");
if(this._toggleItem){
if(this.parent.preventDeselect&&this._selected){
return;
}
this.toggleSelected();
}
this._fireEvent("onMouseDown");
},_onmouseup:function(e){
dojo.html.removeClass(this.domNode,"down");
this._fireEvent("onMouseUp");
},onClick:function(){
},onMouseOver:function(){
},onMouseOut:function(){
},onMouseDown:function(){
},onMouseUp:function(){
},fillInTemplate:function(args,frag){
if(args.name){
this._name=args.name;
}
if(args.selected){
this.select();
}
if(args.disabled){
this.disable();
}
if(args.label){
this.setLabel(args.label);
}
if(args.icon){
this.setIcon(args.icon);
}
if(args.toggleitem||args.toggleItem){
this.setToggleItem(true);
}
}});
dojo.widget.ToolbarItem.make=function(wh,_882,_883){
var item=null;
if(wh instanceof Array){
item=dojo.widget.createWidget("ToolbarButtonGroup",_883);
item.setName(wh[0]);
for(var i=1;i<wh.length;i++){
item.addChild(wh[i]);
}
}else{
if(wh instanceof dojo.widget.ToolbarItem){
item=wh;
}else{
if(wh instanceof dojo.uri.Uri){
item=dojo.widget.createWidget("ToolbarButton",dojo.lang.mixin(_883||{},{icon:new dojo.widget.Icon(wh.toString())}));
}else{
if(_882){
item=dojo.widget.createWidget(wh,_883);
}else{
if(typeof wh=="string"||wh instanceof String){
switch(wh.charAt(0)){
case "|":
case "-":
case "/":
item=dojo.widget.createWidget("ToolbarSeparator",_883);
break;
case " ":
if(wh.length==1){
item=dojo.widget.createWidget("ToolbarSpace",_883);
}else{
item=dojo.widget.createWidget("ToolbarFlexibleSpace",_883);
}
break;
default:
if(/\.(gif|jpg|jpeg|png)$/i.test(wh)){
item=dojo.widget.createWidget("ToolbarButton",dojo.lang.mixin(_883||{},{icon:new dojo.widget.Icon(wh.toString())}));
}else{
item=dojo.widget.createWidget("ToolbarButton",dojo.lang.mixin(_883||{},{label:wh.toString()}));
}
}
}else{
if(wh&&wh.tagName&&/^img$/i.test(wh.tagName)){
item=dojo.widget.createWidget("ToolbarButton",dojo.lang.mixin(_883||{},{icon:wh}));
}else{
item=dojo.widget.createWidget("ToolbarButton",dojo.lang.mixin(_883||{},{label:wh.toString()}));
}
}
}
}
}
}
return item;
};
dojo.widget.defineWidget("dojo.widget.ToolbarButtonGroup",dojo.widget.ToolbarItem,{isContainer:true,templateString:"<span unselectable=\"on\" class=\"toolbarButtonGroup\" dojoAttachPoint=\"containerNode\"></span>",defaultButton:"",postCreate:function(){
for(var i=0;i<this.children.length;i++){
this._injectChild(this.children[i]);
}
},addChild:function(item,pos,_889){
var _88a=dojo.widget.ToolbarItem.make(item,null,dojo.lang.mixin(_889||{},{toggleItem:true}));
var ret=dojo.widget.ToolbarButtonGroup.superclass.addChild.call(this,_88a,null,pos,null);
this._injectChild(_88a);
return ret;
},_injectChild:function(_88c){
dojo.event.connect(_88c,"onSelect",this,"onChildSelected");
dojo.event.connect(_88c,"onDeselect",this,"onChildDeSelected");
if(_88c._name==this.defaultButton||(typeof this.defaultButton=="number"&&this.children.length-1==this.defaultButton)){
_88c.select(false,true);
}
},getItem:function(name){
if(name instanceof dojo.widget.ToolbarItem){
return name;
}
for(var i=0;i<this.children.length;i++){
var _88f=this.children[i];
if(_88f instanceof dojo.widget.ToolbarItem&&_88f._name==name){
return _88f;
}
}
return null;
},getItems:function(){
var _890=[];
for(var i=0;i<this.children.length;i++){
var _892=this.children[i];
if(_892 instanceof dojo.widget.ToolbarItem){
_890.push(_892);
}
}
return _890;
},onChildSelected:function(e){
this.select(e._name);
},onChildDeSelected:function(e){
this._fireEvent("onChangeSelect",this._value);
},enable:function(_895,_896){
for(var i=0;i<this.children.length;i++){
var _898=this.children[i];
if(_898 instanceof dojo.widget.ToolbarItem){
_898.enable(_895,_896);
if(_898._name==this._value){
_898.select(_895,_896);
}
}
}
},disable:function(_899,_89a){
for(var i=0;i<this.children.length;i++){
var _89c=this.children[i];
if(_89c instanceof dojo.widget.ToolbarItem){
_89c.disable(_899,_89a);
}
}
},_value:"",getValue:function(){
return this._value;
},select:function(name,_89e,_89f){
for(var i=0;i<this.children.length;i++){
var _8a1=this.children[i];
if(_8a1 instanceof dojo.widget.ToolbarItem){
if(_8a1._name==name){
_8a1.select(_89e,_89f);
this._value=name;
}else{
_8a1.deselect(true,true);
}
}
}
if(!_89f){
this._fireEvent("onSelect",this._value);
this._fireEvent("onChangeSelect",this._value);
}
},setValue:this.select,preventDeselect:false});
dojo.widget.defineWidget("dojo.widget.ToolbarButton",dojo.widget.ToolbarItem,{fillInTemplate:function(args,frag){
dojo.widget.ToolbarButton.superclass.fillInTemplate.call(this,args,frag);
dojo.html.addClass(this.domNode,"toolbarButton");
if(this._icon){
this.setIcon(this._icon);
}
if(this._label){
this.setLabel(this._label);
}
if(!this._name){
if(this._label){
this.setName(this._label);
}else{
if(this._icon){
var src=this._icon.getSrc("enabled").match(/[\/^]([^\.\/]+)\.(gif|jpg|jpeg|png)$/i);
if(src){
this.setName(src[1]);
}
}else{
this._name=this._widgetId;
}
}
}
}});
dojo.widget.defineWidget("dojo.widget.ToolbarDialog",dojo.widget.ToolbarButton,{fillInTemplate:function(args,frag){
dojo.widget.ToolbarDialog.superclass.fillInTemplate.call(this,args,frag);
dojo.event.connect(this,"onSelect",this,"showDialog");
dojo.event.connect(this,"onDeselect",this,"hideDialog");
},showDialog:function(e){
dojo.lang.setTimeout(dojo.event.connect,1,document,"onmousedown",this,"deselect");
},hideDialog:function(e){
dojo.event.disconnect(document,"onmousedown",this,"deselect");
}});
dojo.widget.defineWidget("dojo.widget.ToolbarMenu",dojo.widget.ToolbarDialog,{});
dojo.widget.ToolbarMenuItem=function(){
};
dojo.widget.defineWidget("dojo.widget.ToolbarSeparator",dojo.widget.ToolbarItem,{templateString:"<span unselectable=\"on\" class=\"toolbarItem toolbarSeparator\"></span>",defaultIconPath:new dojo.uri.dojoUri("src/widget/templates/buttons/sep.gif"),fillInTemplate:function(args,frag,skip){
dojo.widget.ToolbarSeparator.superclass.fillInTemplate.call(this,args,frag);
this._name=this.widgetId;
if(!skip){
if(!this._icon){
this.setIcon(this.defaultIconPath);
}
this.domNode.appendChild(this._icon.getNode());
}
},_onmouseover:null,_onmouseout:null,_onclick:null,_onmousedown:null,_onmouseup:null});
dojo.widget.defineWidget("dojo.widget.ToolbarSpace",dojo.widget.ToolbarSeparator,{fillInTemplate:function(args,frag,skip){
dojo.widget.ToolbarSpace.superclass.fillInTemplate.call(this,args,frag,true);
if(!skip){
dojo.html.addClass(this.domNode,"toolbarSpace");
}
}});
dojo.widget.defineWidget("dojo.widget.ToolbarSelect",dojo.widget.ToolbarItem,{templateString:"<span class=\"toolbarItem toolbarSelect\" unselectable=\"on\"><select dojoAttachPoint=\"selectBox\" dojoOnChange=\"changed\"></select></span>",fillInTemplate:function(args,frag){
dojo.widget.ToolbarSelect.superclass.fillInTemplate.call(this,args,frag,true);
var keys=args.values;
var i=0;
for(var val in keys){
var opt=document.createElement("option");
opt.setAttribute("value",keys[val]);
opt.innerHTML=val;
this.selectBox.appendChild(opt);
}
},changed:function(e){
this._fireEvent("onSetValue",this.selectBox.value);
},setEnabled:function(is,_8b7,_8b8){
var ret=dojo.widget.ToolbarSelect.superclass.setEnabled.call(this,is,_8b7,_8b8);
this.selectBox.disabled=!this._enabled;
return ret;
},_onmouseover:null,_onmouseout:null,_onclick:null,_onmousedown:null,_onmouseup:null});
dojo.widget.Icon=function(_8ba,_8bb,_8bc,_8bd){
if(!arguments.length){
throw new Error("Icon must have at least an enabled state");
}
var _8be=["enabled","disabled","hovered","selected"];
var _8bf="enabled";
var _8c0=document.createElement("img");
this.getState=function(){
return _8bf;
};
this.setState=function(_8c1){
if(dojo.lang.inArray(_8be,_8c1)){
if(this[_8c1]){
_8bf=_8c1;
var img=this[_8bf];
if((dojo.render.html.ie55||dojo.render.html.ie60)&&img.src&&img.src.match(/[.]png$/i)){
_8c0.width=img.width||img.offsetWidth;
_8c0.height=img.height||img.offsetHeight;
_8c0.setAttribute("src",dojo.uri.dojoUri("src/widget/templates/images/blank.gif").uri);
_8c0.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+img.src+"',sizingMethod='image')";
}else{
_8c0.setAttribute("src",img.src);
}
}
}else{
throw new Error("Invalid state set on Icon (state: "+_8c1+")");
}
};
this.setSrc=function(_8c3,_8c4){
if(/^img$/i.test(_8c4.tagName)){
this[_8c3]=_8c4;
}else{
if(typeof _8c4=="string"||_8c4 instanceof String||_8c4 instanceof dojo.uri.Uri){
this[_8c3]=new Image();
this[_8c3].src=_8c4.toString();
}
}
return this[_8c3];
};
this.setIcon=function(icon){
for(var i=0;i<_8be.length;i++){
if(icon[_8be[i]]){
this.setSrc(_8be[i],icon[_8be[i]]);
}
}
this.update();
};
this.enable=function(){
this.setState("enabled");
};
this.disable=function(){
this.setState("disabled");
};
this.hover=function(){
this.setState("hovered");
};
this.select=function(){
this.setState("selected");
};
this.getSize=function(){
return {width:_8c0.width||_8c0.offsetWidth,height:_8c0.height||_8c0.offsetHeight};
};
this.setSize=function(w,h){
_8c0.width=w;
_8c0.height=h;
return {width:w,height:h};
};
this.getNode=function(){
return _8c0;
};
this.getSrc=function(_8c9){
if(_8c9){
return this[_8c9].src;
}
return _8c0.src||"";
};
this.update=function(){
this.setState(_8bf);
};
for(var i=0;i<_8be.length;i++){
var arg=arguments[i];
var _8cc=_8be[i];
this[_8cc]=null;
if(!arg){
continue;
}
this.setSrc(_8cc,arg);
}
this.enable();
};
dojo.widget.Icon.make=function(a,b,c,d){
for(var i=0;i<arguments.length;i++){
if(arguments[i] instanceof dojo.widget.Icon){
return arguments[i];
}
}
return new dojo.widget.Icon(a,b,c,d);
};
dojo.widget.defineWidget("dojo.widget.ToolbarColorDialog",dojo.widget.ToolbarDialog,{palette:"7x10",fillInTemplate:function(args,frag){
dojo.widget.ToolbarColorDialog.superclass.fillInTemplate.call(this,args,frag);
this.dialog=dojo.widget.createWidget("ColorPalette",{palette:this.palette});
this.dialog.domNode.style.position="absolute";
dojo.event.connect(this.dialog,"onColorSelect",this,"_setValue");
},_setValue:function(_8d4){
this._value=_8d4;
this._fireEvent("onSetValue",_8d4);
},showDialog:function(e){
dojo.widget.ToolbarColorDialog.superclass.showDialog.call(this,e);
var abs=dojo.html.getAbsolutePosition(this.domNode,true);
var y=abs.y+dojo.html.getBorderBox(this.domNode).height;
this.dialog.showAt(abs.x,y);
},hideDialog:function(e){
dojo.widget.ToolbarColorDialog.superclass.hideDialog.call(this,e);
this.dialog.hide();
}});
dojo.provide("dojo.html.*");
dojo.provide("dojo.widget.RichText");
if(dojo.hostenv.post_load_){
(function(){
var _8d9=dojo.doc().createElement("textarea");
_8d9.id="dojo.widget.RichText.savedContent";
_8d9.style="display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;";
dojo.body().appendChild(_8d9);
})();
}else{
try{
dojo.doc().write("<textarea id=\"dojo.widget.RichText.savedContent\" "+"style=\"display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;\"></textarea>");
}
catch(e){
}
}
dojo.widget.defineWidget("dojo.widget.RichText",dojo.widget.HtmlWidget,{inheritWidth:false,focusOnLoad:true,saveName:"",_content:"",height:"",minHeight:"1em",isClosed:true,isLoaded:false,useActiveX:false,relativeImageUrls:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",fillInTemplate:function(){
dojo.event.topic.publish("dojo.widget.RichText::init",this);
this.open();
dojo.event.connect(this,"onKeyPressed",this,"afterKeyPress");
dojo.event.connect(this,"onKeyPress",this,"keyPress");
dojo.event.connect(this,"onKeyDown",this,"keyDown");
dojo.event.connect(this,"onKeyUp",this,"keyUp");
var ctrl=this.KEY_CTRL;
var exec=function(cmd,arg){
return arguments.length==1?function(){
this.execCommand(cmd);
}:function(){
this.execCommand(cmd,arg);
};
};
this.addKeyHandler("b",ctrl,exec("bold"));
this.addKeyHandler("i",ctrl,exec("italic"));
this.addKeyHandler("u",ctrl,exec("underline"));
this.addKeyHandler("a",ctrl,exec("selectall"));
this.addKeyHandler("s",ctrl,function(){
this.save(true);
});
this.addKeyHandler("1",ctrl,exec("formatblock","h1"));
this.addKeyHandler("2",ctrl,exec("formatblock","h2"));
this.addKeyHandler("3",ctrl,exec("formatblock","h3"));
this.addKeyHandler("4",ctrl,exec("formatblock","h4"));
this.addKeyHandler("\\",ctrl,exec("insertunorderedlist"));
if(!dojo.render.html.ie){
this.addKeyHandler("Z",ctrl,exec("redo"));
}
},events:["onBlur","onFocus","onKeyPress","onKeyDown","onKeyUp","onClick"],open:function(_8de){
var h=dojo.render.html;
dojo.event.topic.publish("dojo.widget.RichText::open",this);
if(!this.isClosed){
this.close();
}
this._content="";
if((arguments.length==1)&&(_8de["nodeName"])){
this.domNode=_8de;
}
if((this.domNode["nodeName"])&&(this.domNode.nodeName.toLowerCase()=="textarea")){
this.textarea=this.domNode;
var html=dojo.string.trim(this.textarea.value);
if(html==""){
html="&nbsp;";
}
this.domNode=dojo.doc().createElement("div");
dojo.html.copyStyle(this.domNode,this.textarea);
var _8e1=dojo.lang.hitch(this,function(){
with(this.textarea.style){
display="block";
position="absolute";
left=top="-1000px";
if(h.ie){
this.__overflow=overflow;
overflow="hidden";
}
}
});
if(h.ie){
setTimeout(_8e1,10);
}else{
_8e1();
}
if(!h.safari){
dojo.html.insertBefore(this.domNode,this.textarea);
}
if(this.textarea.form){
dojo.event.connect(this.textarea.form,"onsubmit",dojo.lang.hitch(this,function(){
this.textarea.value=this.getEditorContent();
}));
}
var _8e2=this;
dojo.event.connect(this,"postCreate",function(){
dojo.html.insertAfter(_8e2.textarea,_8e2.domNode);
});
}else{
var html=this._preFilterContent(dojo.string.trim(this.domNode.innerHTML));
if(html==""){
html="&nbsp;";
}
}
var _8e3=dojo.html.getContentBox(this.domNode);
this._oldHeight=_8e3.height;
this._oldWidth=_8e3.width;
this._firstChildContributingMargin=this._getContributingMargin(this.domNode,"top");
this._lastChildContributingMargin=this._getContributingMargin(this.domNode,"bottom");
this.savedContent=dojo.doc().createElement("div");
while(this.domNode.hasChildNodes()){
this.savedContent.appendChild(this.domNode.firstChild);
}
this.editingArea=dojo.doc().createElement("div");
this.domNode.appendChild(this.editingArea);
if((this.domNode["nodeName"])&&(this.domNode.nodeName=="LI")){
this.domNode.innerHTML=" <br>";
}
if(this.saveName!=""){
var _8e4=dojo.doc().getElementById("dojo.widget.RichText.savedContent");
if(_8e4.value!=""){
var _8e5=_8e4.value.split(this._SEPARATOR);
for(var i=0;i<_8e5.length;i++){
var data=_8e5[i].split(":");
if(data[0]==this.saveName){
html=data[1];
_8e5.splice(i,1);
break;
}
}
}
dojo.event.connect("before",window,"onunload",this,"_saveContent");
}
if(h.ie70&&this.useActiveX){
dojo.debug("activeX in ie70 is not currently supported, useActiveX is ignored for now.");
this.useActiveX=false;
}
if(this.useActiveX&&h.ie){
var self=this;
setTimeout(function(){
self._drawObject(html);
},0);
}else{
if(h.ie){
this.iframe=dojo.doc().createElement("iframe");
this.iframe.src="javascript:void(0)";
this.editorObject=this.iframe;
with(this.iframe.style){
border="0";
width="100%";
}
this.iframe.frameBorder=0;
this.editingArea.appendChild(this.iframe);
this.window=this.iframe.contentWindow;
this.document=this.window.document;
this.document.open();
this.document.write("<html><head></head><body style='margin: 0; padding: 0;border: 0; overflow: hidden;'><div></div></body></html>");
this.document.close();
this.editNode=this.document.body.firstChild;
this.editNode.contentEditable=true;
with(this.iframe.style){
if(h.ie70){
if(this.height){
height=this.height;
}
if(this.minHeight){
minHeight=this.minHeight;
}
}else{
height=this.height?this.height:this.minHeight;
}
}
if(!this._cacheLocalBlockFormatNames()){
var _8e9=["p","pre","address","h1","h2","h3","h4","h5","h6","ol","div","ul"];
var _8ea="";
for(var i in _8e9){
if(_8e9[i].charAt(1)!="l"){
_8ea+="<"+_8e9[i]+"><span>content</span></"+_8e9[i]+">";
}else{
_8ea+="<"+_8e9[i]+"><li>content</li></"+_8e9[i]+">";
}
}
with(this.editNode.style){
position="absolute";
left="-2000px";
top="-2000px";
}
this.editNode.innerHTML=_8ea;
var node=this.editNode.firstChild;
while(node){
dojo.withGlobal(this.window,"selectElement",dojo.html.selection,[node.firstChild]);
var _8ec=node.tagName.toLowerCase();
this._local2NativeFormatNames[_8ec]=this.queryCommandValue("formatblock");
this._native2LocalFormatNames[this._local2NativeFormatNames[_8ec]]=_8ec;
node=node.nextSibling;
}
with(this.editNode.style){
position="";
left="";
top="";
}
}
this.editNode.innerHTML=html;
if(this.height){
this.document.body.style.overflowY="scroll";
}
dojo.lang.forEach(this.events,function(e){
dojo.event.connect(this.editNode,e.toLowerCase(),this,e);
},this);
this.onLoad();
}else{
this._drawIframe(html);
this.editorObject=this.iframe;
}
}
if(this.domNode.nodeName=="LI"){
this.domNode.lastChild.style.marginTop="-1.2em";
}
dojo.html.addClass(this.domNode,"RichTextEditable");
this.isClosed=false;
},_hasCollapseableMargin:function(_8ee,side){
if(dojo.html.getPixelValue(_8ee,"border-"+side+"-width",false)){
return false;
}else{
if(dojo.html.getPixelValue(_8ee,"padding-"+side,false)){
return false;
}else{
return true;
}
}
},_getContributingMargin:function(_8f0,_8f1){
if(_8f1=="top"){
var _8f2="previousSibling";
var _8f3="nextSibling";
var _8f4="firstChild";
var _8f5="margin-top";
var _8f6="margin-bottom";
}else{
var _8f2="nextSibling";
var _8f3="previousSibling";
var _8f4="lastChild";
var _8f5="margin-bottom";
var _8f6="margin-top";
}
var _8f7=dojo.html.getPixelValue(_8f0,_8f5,false);
function isSignificantNode(_8f8){
return !(_8f8.nodeType==3&&dojo.string.isBlank(_8f8.data))&&dojo.html.getStyle(_8f8,"display")!="none"&&!dojo.html.isPositionAbsolute(_8f8);
}
var _8f9=0;
var _8fa=_8f0[_8f4];
while(_8fa){
while((!isSignificantNode(_8fa))&&_8fa[_8f3]){
_8fa=_8fa[_8f3];
}
_8f9=Math.max(_8f9,dojo.html.getPixelValue(_8fa,_8f5,false));
if(!this._hasCollapseableMargin(_8fa,_8f1)){
break;
}
_8fa=_8fa[_8f4];
}
if(!this._hasCollapseableMargin(_8f0,_8f1)){
return parseInt(_8f9);
}
var _8fb=0;
var _8fc=_8f0[_8f2];
while(_8fc){
if(isSignificantNode(_8fc)){
_8fb=dojo.html.getPixelValue(_8fc,_8f6,false);
break;
}
_8fc=_8fc[_8f2];
}
if(!_8fc){
_8fb=dojo.html.getPixelValue(_8f0.parentNode,_8f5,false);
}
if(_8f9>_8f7){
return parseInt(Math.max((_8f9-_8f7)-_8fb,0));
}else{
return 0;
}
},_drawIframe:function(html){
var _8fe=Boolean(dojo.render.html.moz&&(typeof window.XML=="undefined"));
if(!this.iframe){
var _8ff=(new dojo.uri.Uri(dojo.doc().location)).host;
this.iframe=dojo.doc().createElement("iframe");
with(this.iframe){
style.border="none";
style.lineHeight="0";
style.verticalAlign="bottom";
scrolling=this.height?"auto":"no";
}
}
this.iframe.src=dojo.uri.dojoUri("src/widget/templates/richtextframe.html")+((dojo.doc().domain!=_8ff)?("#"+dojo.doc().domain):"");
this.iframe.width=this.inheritWidth?this._oldWidth:"100%";
if(this.height){
this.iframe.style.height=this.height;
}else{
var _900=this._oldHeight;
if(this._hasCollapseableMargin(this.domNode,"top")){
_900+=this._firstChildContributingMargin;
}
if(this._hasCollapseableMargin(this.domNode,"bottom")){
_900+=this._lastChildContributingMargin;
}
this.iframe.height=_900;
}
var _901=dojo.doc().createElement("div");
_901.innerHTML=html;
if(this.relativeImageUrls){
var imgs=_901.getElementsByTagName("img");
for(var i=0;i<imgs.length;i++){
imgs[i].src=(new dojo.uri.Uri(dojo.global().location,imgs[i].src)).toString();
}
html=_901.innerHTML;
}
var _904=dojo.html.firstElement(_901);
var _905=dojo.html.lastElement(_901);
if(_904){
_904.style.marginTop=this._firstChildContributingMargin+"px";
}
if(_905){
_905.style.marginBottom=this._lastChildContributingMargin+"px";
}
_901.style.position="absolute";
this.editingArea.appendChild(_901);
this.editingArea.appendChild(this.iframe);
if(dojo.render.html.safari){
this.iframe.src=this.iframe.src;
}
var _906=false;
var _907=dojo.lang.hitch(this,function(){
if(!_906){
_906=true;
}else{
return;
}
if(!this.editNode){
if(this.iframe.contentWindow){
this.window=this.iframe.contentWindow;
this.document=this.iframe.contentWindow.document;
}else{
if(this.iframe.contentDocument){
this.window=this.iframe.contentDocument.window;
this.document=this.iframe.contentDocument;
}
}
var _908=(function(_909){
return function(_90a){
return dojo.html.getStyle(_909,_90a);
};
})(this.domNode);
var font=_908("font-weight")+" "+_908("font-size")+" "+_908("font-family");
var _90c="1.0";
var _90d=dojo.html.getUnitValue(this.domNode,"line-height");
if(_90d.value&&_90d.units==""){
_90c=_90d.value;
}
dojo.html.insertCssText("    body,html { background: transparent; padding: 0; margin: 0; }\n"+"    body { top: 0; left: 0; right: 0;"+(((this.height)||(dojo.render.html.opera))?"":" position: fixed; ")+"        font: "+font+";\n"+"        min-height: "+this.minHeight+"; \n"+"        line-height: "+_90c+"} \n"+"    p { margin: 1em 0 !important; }\n"+"    body > *:first-child { padding-top: 0 !important; margin-top: "+this._firstChildContributingMargin+"px !important; }\n"+"    body > *:last-child { padding-bottom: 0 !important; margin-bottom: "+this._lastChildContributingMargin+"px !important; }\n"+"    li > ul:-moz-first-node, li > ol:-moz-first-node { padding-top: 1.2em; }\n"+"    li { min-height: 1.2em; }\n"+"",this.document);
_901.parentNode.removeChild(_901);
this.document.body.innerHTML=html;
if(_8fe||dojo.render.html.safari){
this.document.designMode="on";
}
this.onLoad();
}else{
_901.parentNode.removeChild(_901);
this.editNode.innerHTML=html;
this.onDisplayChanged();
}
});
if(this.editNode){
_907();
}else{
if(dojo.render.html.moz){
this.iframe.onload=function(){
setTimeout(_907,250);
};
}else{
this.iframe.onload=_907;
}
}
},_applyEditingAreaStyleSheets:function(){
var _90e=[];
if(this.styleSheets){
_90e=this.styleSheets.split(";");
}
_90e=_90e.concat(this.editingAreaStyleSheets);
this.editingAreaStyleSheets=[];
if(_90e.length>0){
for(var i=0;i<_90e.length;i++){
var url=_90e[i];
if(url){
this.addStyleSheet(new dojo.uri.Uri(url));
}
}
}
},addStyleSheet:function(uri){
var url=uri.toString();
if(dojo.lang.find(this.editingAreaStyleSheets,url)>-1){
dojo.debug("dojo.widget.RichText.addStyleSheet: Style sheet "+url+" is already applied to the editing area!");
return;
}
if(url.charAt(0)=="."||(url.charAt(0)!="/"&&!uri.host)){
url=(new dojo.uri.Uri(dojo.global().location,url)).toString();
}
this.editingAreaStyleSheets.push(url);
if(this.document.createStyleSheet){
this.document.createStyleSheet(url);
}else{
var head=this.document.getElementsByTagName("head")[0];
var _914=this.document.createElement("link");
with(_914){
rel="stylesheet";
type="text/css";
href=url;
}
head.appendChild(_914);
}
},removeStyleSheet:function(uri){
var url=uri.toString();
var _917=dojo.lang.find(this.editingAreaStyleSheets,url);
if(_917==-1){
dojo.debug("dojo.widget.RichText.removeStyleSheet: Style sheet "+url+" is not applied to the editing area so it can not be removed!");
return;
}
delete this.editingAreaStyleSheets[_917];
var _918=this.document.getElementsByTagName("link");
for(var i=0;i<_918.length;i++){
if(_918[i].href==url){
if(dojo.render.html.ie){
_918[i].href="";
}
dojo.html.removeNode(_918[i]);
break;
}
}
},_drawObject:function(html){
this.object=dojo.html.createExternalElement(dojo.doc(),"object");
with(this.object){
classid="clsid:2D360201-FFF5-11D1-8D03-00A0C959BC0A";
width=this.inheritWidth?this._oldWidth:"100%";
style.height=this.height?this.height:(this._oldHeight+"px");
Scrollbars=this.height?true:false;
Appearance=this._activeX.appearance.flat;
}
this.editorObject=this.object;
this.editingArea.appendChild(this.object);
this.object.attachEvent("DocumentComplete",dojo.lang.hitch(this,"onLoad"));
dojo.lang.forEach(this.events,function(e){
this.object.attachEvent(e.toLowerCase(),dojo.lang.hitch(this,e));
},this);
this.object.DocumentHTML="<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">"+"<html><title></title>"+"<style type=\"text/css\">"+"    body,html { padding: 0; margin: 0; }"+(this.height?"":"    body,  { overflow: hidden; }")+"</style>"+"<body><div>"+html+"<div></body></html>";
this._cacheLocalBlockFormatNames();
},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_cacheLocalBlockFormatNames:function(){
if(!this._native2LocalFormatNames["p"]){
var obj=this.object;
if(!obj){
try{
obj=dojo.html.createExternalElement(dojo.doc(),"object");
obj.classid="clsid:2D360201-FFF5-11D1-8D03-00A0C959BC0A";
dojo.body().appendChild(obj);
obj.DocumentHTML="<html><head></head><body></body></html>";
}
catch(e){
return false;
}
}
var _91d=new ActiveXObject("DEGetBlockFmtNamesParam.DEGetBlockFmtNamesParam");
obj.ExecCommand(this._activeX.command["getblockformatnames"],0,_91d);
var _91e=new VBArray(_91d.Names);
var _91f=_91e.toArray();
var _920=["p","pre","address","h1","h2","h3","h4","h5","h6","ol","ul","","","","","div"];
for(var i=0;i<_920.length;++i){
if(_920[i].length>0){
this._local2NativeFormatNames[_91f[i]]=_920[i];
this._native2LocalFormatNames[_920[i]]=_91f[i];
}
}
if(!this.object){
dojo.body().removeChild(obj);
}
}
return true;
},_isResized:function(){
return false;
},onLoad:function(e){
this.isLoaded=true;
if(this.object){
this.document=this.object.DOM;
this.window=this.document.parentWindow;
this.editNode=this.document.body.firstChild;
this.editingArea.style.height=this.height?this.height:this.minHeight;
this.connect(this,"onDisplayChanged","_updateHeight");
this.window._frameElement=this.object;
}else{
if(this.iframe&&!dojo.render.html.ie){
this.editNode=this.document.body;
this.connect(this,"onDisplayChanged","_updateHeight");
try{
this.document.execCommand("useCSS",false,true);
this.document.execCommand("styleWithCSS",false,false);
}
catch(e2){
}
if(dojo.render.html.safari){
this.connect(this.editNode,"onblur","onBlur");
this.connect(this.editNode,"onfocus","onFocus");
this.connect(this.editNode,"onclick","onFocus");
this.interval=setInterval(dojo.lang.hitch(this,"onDisplayChanged"),750);
}else{
if(dojo.render.html.mozilla||dojo.render.html.opera){
var doc=this.document;
var _924=dojo.event.browser.addListener;
var self=this;
dojo.lang.forEach(this.events,function(e){
var l=_924(self.document,e.substr(2).toLowerCase(),dojo.lang.hitch(self,e));
if(e=="onBlur"){
var _928={unBlur:function(e){
dojo.event.browser.removeListener(doc,"blur",l);
}};
dojo.event.connect("before",self,"close",_928,"unBlur");
}
});
}
}
}else{
if(dojo.render.html.ie){
this.connect(this,"onDisplayChanged","_updateHeight");
this.editNode.style.zoom=1;
}
}
}
this._applyEditingAreaStyleSheets();
if(this.focusOnLoad){
this.focus();
}
this.onDisplayChanged(e);
},onKeyDown:function(e){
if((!e)&&(this.object)){
e=dojo.event.browser.fixEvent(this.window.event);
}
if((dojo.render.html.ie)&&(e.keyCode==e.KEY_TAB)){
e.preventDefault();
e.stopPropagation();
this.execCommand((e.shiftKey?"outdent":"indent"));
}else{
if(dojo.render.html.ie){
if((65<=e.keyCode)&&(e.keyCode<=90)){
e.charCode=e.keyCode;
this.onKeyPress(e);
}
}
}
},onKeyUp:function(e){
return;
},KEY_CTRL:1,onKeyPress:function(e){
if((!e)&&(this.object)){
e=dojo.event.browser.fixEvent(this.window.event);
}
var _92d=e.ctrlKey?this.KEY_CTRL:0;
if(this._keyHandlers[e.key]){
var _92e=this._keyHandlers[e.key],i=0,_930;
while(_930=_92e[i++]){
if(_92d==_930.modifiers){
_930.handler.call(this);
e.preventDefault();
break;
}
}
}
dojo.lang.setTimeout(this,this.onKeyPressed,1,e);
},addKeyHandler:function(key,_932,_933){
if(!(this._keyHandlers[key] instanceof Array)){
this._keyHandlers[key]=[];
}
this._keyHandlers[key].push({modifiers:_932||0,handler:_933});
},onKeyPressed:function(e){
this.onDisplayChanged();
},onClick:function(e){
this.onDisplayChanged(e);
},onBlur:function(e){
},_initialFocus:true,onFocus:function(e){
if((dojo.render.html.mozilla)&&(this._initialFocus)){
this._initialFocus=false;
if(dojo.string.trim(this.editNode.innerHTML)=="&nbsp;"){
this.placeCursorAtStart();
}
}
},blur:function(){
if(this.iframe){
this.window.blur();
}else{
if(this.object){
this.document.body.blur();
}else{
if(this.editNode){
this.editNode.blur();
}
}
}
},focus:function(){
if(this.iframe&&!dojo.render.html.ie){
this.window.focus();
}else{
if(this.object){
this.document.focus();
}else{
if(this.editNode&&this.editNode.focus){
this.editNode.focus();
}else{
dojo.debug("Have no idea how to focus into the editor!");
}
}
}
},onDisplayChanged:function(e){
},_activeX:{command:{bold:5000,italic:5023,underline:5048,justifycenter:5024,justifyleft:5025,justifyright:5026,cut:5003,copy:5002,paste:5032,"delete":5004,undo:5049,redo:5033,removeformat:5034,selectall:5035,unlink:5050,indent:5018,outdent:5031,insertorderedlist:5030,insertunorderedlist:5051,inserttable:5022,insertcell:5019,insertcol:5020,insertrow:5021,deletecells:5005,deletecols:5006,deleterows:5007,mergecells:5029,splitcell:5047,setblockformat:5043,getblockformat:5011,getblockformatnames:5012,setfontname:5044,getfontname:5013,setfontsize:5045,getfontsize:5014,setbackcolor:5042,getbackcolor:5010,setforecolor:5046,getforecolor:5015,findtext:5008,font:5009,hyperlink:5016,image:5017,lockelement:5027,makeabsolute:5028,sendbackward:5036,bringforward:5037,sendbelowtext:5038,bringabovetext:5039,sendtoback:5040,bringtofront:5041,properties:5052},ui:{"default":0,prompt:1,noprompt:2},status:{notsupported:0,disabled:1,enabled:3,latched:7,ninched:11},appearance:{flat:0,inset:1},state:{unchecked:0,checked:1,gray:2}},_normalizeCommand:function(cmd){
var drh=dojo.render.html;
var _93b=cmd.toLowerCase();
if(_93b=="formatblock"){
if(drh.safari){
_93b="heading";
}
}else{
if(this.object){
switch(_93b){
case "createlink":
_93b="hyperlink";
break;
case "insertimage":
_93b="image";
break;
}
}else{
if(_93b=="hilitecolor"&&!drh.mozilla){
_93b="backcolor";
}
}
}
return _93b;
},queryCommandAvailable:function(_93c){
var ie=1;
var _93e=1<<1;
var _93f=1<<2;
var _940=1<<3;
var _941=1<<4;
var _942=false;
if(dojo.render.html.safari){
var tmp=dojo.render.html.UA.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
_942=true;
}
}
function isSupportedBy(_945){
return {ie:Boolean(_945&ie),mozilla:Boolean(_945&_93e),safari:Boolean(_945&_93f),safari420:Boolean(_945&_941),opera:Boolean(_945&_940)};
}
var _946=null;
switch(_93c.toLowerCase()){
case "bold":
case "italic":
case "underline":
case "subscript":
case "superscript":
case "fontname":
case "fontsize":
case "forecolor":
case "hilitecolor":
case "justifycenter":
case "justifyfull":
case "justifyleft":
case "justifyright":
case "delete":
case "selectall":
_946=isSupportedBy(_93e|ie|_93f|_940);
break;
case "createlink":
case "unlink":
case "removeformat":
case "inserthorizontalrule":
case "insertimage":
case "insertorderedlist":
case "insertunorderedlist":
case "indent":
case "outdent":
case "formatblock":
case "inserthtml":
case "undo":
case "redo":
case "strikethrough":
_946=isSupportedBy(_93e|ie|_940|_941);
break;
case "blockdirltr":
case "blockdirrtl":
case "dirltr":
case "dirrtl":
case "inlinedirltr":
case "inlinedirrtl":
_946=isSupportedBy(ie);
break;
case "cut":
case "copy":
case "paste":
_946=isSupportedBy(ie|_93e|_941);
break;
case "inserttable":
_946=isSupportedBy(_93e|(this.object?ie:0));
break;
case "insertcell":
case "insertcol":
case "insertrow":
case "deletecells":
case "deletecols":
case "deleterows":
case "mergecells":
case "splitcell":
_946=isSupportedBy(this.object?ie:0);
break;
default:
return false;
}
return (dojo.render.html.ie&&_946.ie)||(dojo.render.html.mozilla&&_946.mozilla)||(dojo.render.html.safari&&_946.safari)||(_942&&_946.safari420)||(dojo.render.html.opera&&_946.opera);
},execCommand:function(_947,_948){
var _949;
this.focus();
_947=this._normalizeCommand(_947);
if(_948!=undefined){
if(_947=="heading"){
throw new Error("unimplemented");
}else{
if(_947=="formatblock"){
if(this.object){
_948=this._native2LocalFormatNames[_948];
}else{
if(drh.ie){
_948="<"+_948+">";
}
}
}
}
}
if(this.object){
switch(_947){
case "hilitecolor":
_947="setbackcolor";
break;
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_947="set"+_947;
break;
case "formatblock":
_947="setblockformat";
}
if(_947=="strikethrough"){
_947="inserthtml";
var _94a=this.document.selection.createRange();
if(!_94a.htmlText){
return;
}
_948=_94a.htmlText.strike();
}else{
if(_947=="inserthorizontalrule"){
_947="inserthtml";
_948="<hr>";
}
}
if(_947=="inserthtml"){
var _94a=this.document.selection.createRange();
if(this.document.selection.type.toUpperCase()=="CONTROL"){
for(var i=0;i<_94a.length;i++){
_94a.item(i).outerHTML=_948;
}
}else{
_94a.pasteHTML(_948);
_94a.select();
}
_949=true;
}else{
if(arguments.length==1){
_949=this.object.ExecCommand(this._activeX.command[_947],this._activeX.ui.noprompt);
}else{
_949=this.object.ExecCommand(this._activeX.command[_947],this._activeX.ui.noprompt,_948);
}
}
}else{
if(_947=="inserthtml"){
if(dojo.render.html.ie){
var _94c=this.document.selection.createRange();
_94c.pasteHTML(_948);
_94c.select();
return true;
}else{
return this.document.execCommand(_947,false,_948);
}
}else{
if((_947=="unlink")&&(this.queryCommandEnabled("unlink"))&&(dojo.render.html.mozilla)){
var _94d=this.window.getSelection();
var _94e=_94d.getRangeAt(0);
var _94f=_94e.startContainer;
var _950=_94e.startOffset;
var _951=_94e.endContainer;
var _952=_94e.endOffset;
var a=dojo.withGlobal(this.window,"getAncestorElement",dojo.html.selection,["a"]);
dojo.withGlobal(this.window,"selectElement",dojo.html.selection,[a]);
_949=this.document.execCommand("unlink",false,null);
var _94e=this.document.createRange();
_94e.setStart(_94f,_950);
_94e.setEnd(_951,_952);
_94d.removeAllRanges();
_94d.addRange(_94e);
return _949;
}else{
if((_947=="hilitecolor")&&(dojo.render.html.mozilla)){
this.document.execCommand("useCSS",false,false);
_949=this.document.execCommand(_947,false,_948);
this.document.execCommand("useCSS",false,true);
}else{
if((dojo.render.html.ie)&&((_947=="backcolor")||(_947=="forecolor"))){
_948=arguments.length>1?_948:null;
_949=this.document.execCommand(_947,false,_948);
}else{
_948=arguments.length>1?_948:null;
if(_948||_947!="createlink"){
_949=this.document.execCommand(_947,false,_948);
}
}
}
}
}
}
this.onDisplayChanged();
return _949;
},queryCommandEnabled:function(_954){
_954=this._normalizeCommand(_954);
if(this.object){
switch(_954){
case "hilitecolor":
_954="setbackcolor";
break;
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_954="set"+_954;
break;
case "formatblock":
_954="setblockformat";
break;
case "strikethrough":
_954="bold";
break;
case "inserthorizontalrule":
return true;
}
if(typeof this._activeX.command[_954]=="undefined"){
return false;
}
var _955=this.object.QueryStatus(this._activeX.command[_954]);
return ((_955!=this._activeX.status.notsupported)&&(_955!=this._activeX.status.disabled));
}else{
if(dojo.render.html.mozilla){
if(_954=="unlink"){
return dojo.withGlobal(this.window,"hasAncestorElement",dojo.html.selection,["a"]);
}else{
if(_954=="inserttable"){
return true;
}
}
}
var elem=(dojo.render.html.ie)?this.document.selection.createRange():this.document;
return elem.queryCommandEnabled(_954);
}
},queryCommandState:function(_957){
_957=this._normalizeCommand(_957);
if(this.object){
if(_957=="forecolor"){
_957="setforecolor";
}else{
if(_957=="backcolor"){
_957="setbackcolor";
}else{
if(_957=="strikethrough"){
return dojo.withGlobal(this.window,"hasAncestorElement",dojo.html.selection,["strike"]);
}else{
if(_957=="inserthorizontalrule"){
return false;
}
}
}
}
if(typeof this._activeX.command[_957]=="undefined"){
return null;
}
var _958=this.object.QueryStatus(this._activeX.command[_957]);
return ((_958==this._activeX.status.latched)||(_958==this._activeX.status.ninched));
}else{
return this.document.queryCommandState(_957);
}
},queryCommandValue:function(_959){
_959=this._normalizeCommand(_959);
if(this.object){
switch(_959){
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_959="get"+_959;
return this.object.execCommand(this._activeX.command[_959],this._activeX.ui.noprompt);
case "formatblock":
var _95a=this.object.execCommand(this._activeX.command["getblockformat"],this._activeX.ui.noprompt);
if(_95a){
return this._local2NativeFormatNames[_95a];
}
}
}else{
if(dojo.render.html.ie&&_959=="formatblock"){
return this._local2NativeFormatNames[this.document.queryCommandValue(_959)]||this.document.queryCommandValue(_959);
}
return this.document.queryCommandValue(_959);
}
},placeCursorAtStart:function(){
this.focus();
if(dojo.render.html.moz&&this.editNode.firstChild&&this.editNode.firstChild.nodeType!=dojo.dom.TEXT_NODE){
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode.firstChild]);
}else{
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode]);
}
dojo.withGlobal(this.window,"collapse",dojo.html.selection,[true]);
},placeCursorAtEnd:function(){
this.focus();
if(dojo.render.html.moz&&this.editNode.lastChild&&this.editNode.lastChild.nodeType!=dojo.dom.TEXT_NODE){
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode.lastChild]);
}else{
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode]);
}
dojo.withGlobal(this.window,"collapse",dojo.html.selection,[false]);
},replaceEditorContent:function(html){
html=this._preFilterContent(html);
if(this.isClosed){
this.domNode.innerHTML=html;
}else{
if(this.window&&this.window.getSelection&&!dojo.render.html.moz){
this.editNode.innerHTML=html;
}else{
if((this.window&&this.window.getSelection)||(this.document&&this.document.selection)){
this.execCommand("selectall");
this.execCommand("inserthtml",html);
}
}
}
},_preFilterContent:function(html){
var ec=html;
dojo.lang.forEach(this.contentPreFilters,function(ef){
ec=ef(ec);
});
if(this.contentDomPreFilters.length>0){
var dom=dojo.doc().createElement("div");
dom.style.display="none";
dojo.body().appendChild(dom);
dom.innerHTML=ec;
dojo.lang.forEach(this.contentDomPreFilters,function(ef){
dom=ef(dom);
});
ec=dom.innerHTML;
dojo.body().removeChild(dom);
}
return ec;
},_postFilterContent:function(html){
var ec=html;
if(this.contentDomPostFilters.length>0){
var dom=this.document.createElement("div");
dom.innerHTML=ec;
dojo.lang.forEach(this.contentDomPostFilters,function(ef){
dom=ef(dom);
});
ec=dom.innerHTML;
}
dojo.lang.forEach(this.contentPostFilters,function(ef){
ec=ef(ec);
});
return ec;
},_lastHeight:0,_updateHeight:function(){
if(!this.isLoaded){
return;
}
if(this.height){
return;
}
var _966=dojo.html.getBorderBox(this.editNode).height;
if(!_966){
_966=dojo.html.getBorderBox(this.document.body).height;
}
if(_966==0){
dojo.debug("Can not figure out the height of the editing area!");
return;
}
this._lastHeight=_966;
this.editorObject.style.height=this._lastHeight+"px";
this.window.scrollTo(0,0);
},_saveContent:function(e){
var _968=dojo.doc().getElementById("dojo.widget.RichText.savedContent");
_968.value+=this._SEPARATOR+this.saveName+":"+this.getEditorContent();
},getEditorContent:function(){
var ec="";
try{
ec=(this._content.length>0)?this._content:this.editNode.innerHTML;
if(dojo.string.trim(ec)=="&nbsp;"){
ec="";
}
}
catch(e){
}
if(dojo.render.html.ie&&!this.object){
var re=new RegExp("(?:<p>&nbsp;</p>[\n\r]*)+$","i");
ec=ec.replace(re,"");
}
ec=this._postFilterContent(ec);
if(this.relativeImageUrls){
var _96b=dojo.global().location.protocol+"//"+dojo.global().location.host;
var _96c=dojo.global().location.pathname;
if(_96c.match(/\/$/)){
}else{
var _96d=_96c.split("/");
if(_96d.length){
_96d.pop();
}
_96c=_96d.join("/")+"/";
}
var _96e=new RegExp("(<img[^>]* src=[\"'])("+_96b+"("+_96c+")?)","ig");
ec=ec.replace(_96e,"$1");
}
return ec;
},close:function(save,_970){
if(this.isClosed){
return false;
}
if(arguments.length==0){
save=true;
}
this._content=this._postFilterContent(this.editNode.innerHTML);
var _971=(this.savedContent.innerHTML!=this._content);
if(this.interval){
clearInterval(this.interval);
}
if(dojo.render.html.ie&&!this.object){
dojo.event.browser.clean(this.editNode);
}
if(this.iframe){
delete this.iframe;
}
if(this.textarea){
with(this.textarea.style){
position="";
left=top="";
if(dojo.render.html.ie){
overflow=this.__overflow;
this.__overflow=null;
}
}
this.domNode.parentNode.removeChild(this.domNode);
this.domNode=this.textarea;
}else{
this.domNode.innerHTML="";
}
if(save){
dojo.event.browser.clean(this.savedContent);
if(dojo.render.html.moz){
var nc=dojo.doc().createElement("span");
this.domNode.appendChild(nc);
nc.innerHTML=this.editNode.innerHTML;
}else{
this.domNode.innerHTML=this._content;
}
}else{
while(this.savedContent.hasChildNodes()){
this.domNode.appendChild(this.savedContent.firstChild);
}
}
delete this.savedContent;
dojo.html.removeClass(this.domNode,"RichTextEditable");
this.isClosed=true;
this.isLoaded=false;
delete this.editNode;
if(this.window._frameElement){
this.window._frameElement=null;
}
this.window=null;
this.document=null;
this.object=null;
this.editingArea=null;
this.editorObject=null;
return _971;
},destroyRendering:function(){
},destroy:function(){
this.destroyRendering();
if(!this.isClosed){
this.close(false);
}
dojo.widget.RichText.superclass.destroy.call(this);
},connect:function(_973,_974,_975){
dojo.event.connect(_973,_974,this,_975);
},disconnect:function(_976,_977,_978){
dojo.event.disconnect(_976,_977,this,_978);
},disconnectAllWithRoot:function(_979){
dojo.deprecated("disconnectAllWithRoot","is deprecated. No need to disconnect manually","0.5");
},_fixContentForMoz:function(html){
html=html.replace(/<strong([ \>])/gi,"<b$1");
html=html.replace(/<\/strong>/gi,"</b>");
html=html.replace(/<em([ \>])/gi,"<i$1");
html=html.replace(/<\/em>/gi,"</i>");
return html;
}},"html",function(){
this.contentPreFilters=[];
this.contentPostFilters=[];
this.contentDomPreFilters=[];
this.contentDomPostFilters=[];
this.styleSheets="";
this.editingAreaStyleSheets=[];
if(dojo.render.html.moz){
this.contentPreFilters.push(this._fixContentForMoz);
}
this._keyHandlers={};
});
dojo.provide("dojo.html.selection");
dojo.html.selectionType={NONE:0,TEXT:1,CONTROL:2};
dojo.html.clearSelection=function(){
var _97b=dojo.global();
var _97c=dojo.doc();
try{
if(_97b["getSelection"]){
if(dojo.render.html.safari){
_97b.getSelection().collapse();
}else{
_97b.getSelection().removeAllRanges();
}
}else{
if(_97c.selection){
if(_97c.selection.empty){
_97c.selection.empty();
}else{
if(_97c.selection.clear){
_97c.selection.clear();
}
}
}
}
return true;
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.html.disableSelection=function(_97d){
_97d=dojo.byId(_97d)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_97d.style.MozUserSelect="none";
}else{
if(h.safari){
_97d.style.KhtmlUserSelect="none";
}else{
if(h.ie){
_97d.unselectable="on";
}else{
return false;
}
}
}
return true;
};
dojo.html.enableSelection=function(_97f){
_97f=dojo.byId(_97f)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_97f.style.MozUserSelect="";
}else{
if(h.safari){
_97f.style.KhtmlUserSelect="";
}else{
if(h.ie){
_97f.unselectable="off";
}else{
return false;
}
}
}
return true;
};
dojo.html.selectElement=function(_981){
dojo.deprecated("dojo.html.selectElement","replaced by dojo.html.selection.selectElementChildren",0.5);
};
dojo.html.selectInputText=function(_982){
var _983=dojo.global();
var _984=dojo.doc();
_982=dojo.byId(_982);
if(_984["selection"]&&dojo.body()["createTextRange"]){
var _985=_982.createTextRange();
_985.moveStart("character",0);
_985.moveEnd("character",_982.value.length);
_985.select();
}else{
if(_983["getSelection"]){
var _986=_983.getSelection();
_982.setSelectionRange(0,_982.value.length);
}
}
_982.focus();
};
dojo.html.isSelectionCollapsed=function(){
dojo.deprecated("dojo.html.isSelectionCollapsed","replaced by dojo.html.selection.isCollapsed",0.5);
return dojo.html.selection.isCollapsed();
};
dojo.lang.mixin(dojo.html.selection,{getType:function(){
if(dojo.doc()["selection"]){
return dojo.html.selectionType[dojo.doc().selection.type.toUpperCase()];
}else{
var _987=dojo.html.selectionType.TEXT;
var oSel;
try{
oSel=dojo.global().getSelection();
}
catch(e){
}
if(oSel&&oSel.rangeCount==1){
var _989=oSel.getRangeAt(0);
if(_989.startContainer==_989.endContainer&&(_989.endOffset-_989.startOffset)==1&&_989.startContainer.nodeType!=dojo.dom.TEXT_NODE){
_987=dojo.html.selectionType.CONTROL;
}
}
return _987;
}
},isCollapsed:function(){
var _98a=dojo.global();
var _98b=dojo.doc();
if(_98b["selection"]){
return _98b.selection.createRange().text=="";
}else{
if(_98a["getSelection"]){
var _98c=_98a.getSelection();
if(dojo.lang.isString(_98c)){
return _98c=="";
}else{
return _98c.isCollapsed||_98c.toString()=="";
}
}
}
},getSelectedElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
if(dojo.doc()["selection"]){
var _98d=dojo.doc().selection.createRange();
if(_98d&&_98d.item){
return dojo.doc().selection.createRange().item(0);
}
}else{
var _98e=dojo.global().getSelection();
return _98e.anchorNode.childNodes[_98e.anchorOffset];
}
}
},getParentElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
var p=dojo.html.selection.getSelectedElement();
if(p){
return p.parentNode;
}
}else{
if(dojo.doc()["selection"]){
return dojo.doc().selection.createRange().parentElement();
}else{
var _990=dojo.global().getSelection();
if(_990){
var node=_990.anchorNode;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.parentNode;
}
return node;
}
}
}
},getSelectedText:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().text;
}else{
var _992=dojo.global().getSelection();
if(_992){
return _992.toString();
}
}
},getSelectedHtml:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().htmlText;
}else{
var _993=dojo.global().getSelection();
if(_993&&_993.rangeCount){
var frag=_993.getRangeAt(0).cloneContents();
var div=document.createElement("div");
div.appendChild(frag);
return div.innerHTML;
}
return null;
}
},hasAncestorElement:function(_996){
return (dojo.html.selection.getAncestorElement.apply(this,arguments)!=null);
},getAncestorElement:function(_997){
var node=dojo.html.selection.getSelectedElement()||dojo.html.selection.getParentElement();
while(node){
if(dojo.html.selection.isTag(node,arguments).length>0){
return node;
}
node=node.parentNode;
}
return null;
},isTag:function(node,tags){
if(node&&node.tagName){
for(var i=0;i<tags.length;i++){
if(node.tagName.toLowerCase()==String(tags[i]).toLowerCase()){
return String(tags[i]).toLowerCase();
}
}
}
return "";
},selectElement:function(_99c){
var _99d=dojo.global();
var _99e=dojo.doc();
_99c=dojo.byId(_99c);
if(_99e.selection&&dojo.body().createTextRange){
try{
var _99f=dojo.body().createControlRange();
_99f.addElement(_99c);
_99f.select();
}
catch(e){
dojo.html.selection.selectElementChildren(_99c);
}
}else{
if(_99d["getSelection"]){
var _9a0=_99d.getSelection();
if(_9a0["removeAllRanges"]){
var _99f=_99e.createRange();
_99f.selectNode(_99c);
_9a0.removeAllRanges();
_9a0.addRange(_99f);
}
}
}
},selectElementChildren:function(_9a1){
var _9a2=dojo.global();
var _9a3=dojo.doc();
_9a1=dojo.byId(_9a1);
if(_9a3.selection&&dojo.body().createTextRange){
var _9a4=dojo.body().createTextRange();
_9a4.moveToElementText(_9a1);
_9a4.select();
}else{
if(_9a2["getSelection"]){
var _9a5=_9a2.getSelection();
if(_9a5["setBaseAndExtent"]){
_9a5.setBaseAndExtent(_9a1,0,_9a1,_9a1.innerText.length-1);
}else{
if(_9a5["selectAllChildren"]){
_9a5.selectAllChildren(_9a1);
}
}
}
}
},getBookmark:function(){
var _9a6;
var _9a7=dojo.doc();
if(_9a7["selection"]){
var _9a8=_9a7.selection.createRange();
_9a6=_9a8.getBookmark();
}else{
var _9a9;
try{
_9a9=dojo.global().getSelection();
}
catch(e){
}
if(_9a9){
var _9a8=_9a9.getRangeAt(0);
_9a6=_9a8.cloneRange();
}else{
dojo.debug("No idea how to store the current selection for this browser!");
}
}
return _9a6;
},moveToBookmark:function(_9aa){
var _9ab=dojo.doc();
if(_9ab["selection"]){
var _9ac=_9ab.selection.createRange();
_9ac.moveToBookmark(_9aa);
_9ac.select();
}else{
var _9ad;
try{
_9ad=dojo.global().getSelection();
}
catch(e){
}
if(_9ad&&_9ad["removeAllRanges"]){
_9ad.removeAllRanges();
_9ad.addRange(_9aa);
}else{
dojo.debug("No idea how to restore selection for this browser!");
}
}
},collapse:function(_9ae){
if(dojo.global()["getSelection"]){
var _9af=dojo.global().getSelection();
if(_9af.removeAllRanges){
if(_9ae){
_9af.collapseToStart();
}else{
_9af.collapseToEnd();
}
}else{
dojo.global().getSelection().collapse(_9ae);
}
}else{
if(dojo.doc().selection){
var _9b0=dojo.doc().selection.createRange();
_9b0.collapse(_9ae);
_9b0.select();
}
}
},remove:function(){
if(dojo.doc().selection){
var _9b1=dojo.doc().selection;
if(_9b1.type.toUpperCase()!="NONE"){
_9b1.clear();
}
return _9b1;
}else{
var _9b1=dojo.global().getSelection();
for(var i=0;i<_9b1.rangeCount;i++){
_9b1.getRangeAt(i).deleteContents();
}
return _9b1;
}
}});
dojo.provide("dojo.widget.ColorPalette");
dojo.widget.defineWidget("dojo.widget.ColorPalette",dojo.widget.HtmlWidget,{palette:"7x10",bgIframe:null,palettes:{"7x10":[["fff","fcc","fc9","ff9","ffc","9f9","9ff","cff","ccf","fcf"],["ccc","f66","f96","ff6","ff3","6f9","3ff","6ff","99f","f9f"],["c0c0c0","f00","f90","fc6","ff0","3f3","6cc","3cf","66c","c6c"],["999","c00","f60","fc3","fc0","3c0","0cc","36f","63f","c3c"],["666","900","c60","c93","990","090","399","33f","60c","939"],["333","600","930","963","660","060","366","009","339","636"],["000","300","630","633","330","030","033","006","309","303"]],"3x4":[["ffffff","00ff00","008000","0000ff"],["c0c0c0","ffff00","ff00ff","000080"],["808080","ff0000","800080","000000"]]},buildRendering:function(){
this.domNode=document.createElement("table");
dojo.html.disableSelection(this.domNode);
dojo.event.connect(this.domNode,"onmousedown",function(e){
e.preventDefault();
});
with(this.domNode){
cellPadding="0";
cellSpacing="1";
border="1";
style.backgroundColor="white";
}
var _9b4=this.palettes[this.palette];
for(var i=0;i<_9b4.length;i++){
var tr=this.domNode.insertRow(-1);
for(var j=0;j<_9b4[i].length;j++){
if(_9b4[i][j].length==3){
_9b4[i][j]=_9b4[i][j].replace(/(.)(.)(.)/,"$1$1$2$2$3$3");
}
var td=tr.insertCell(-1);
with(td.style){
backgroundColor="#"+_9b4[i][j];
border="1px solid gray";
width=height="15px";
fontSize="1px";
}
td.color="#"+_9b4[i][j];
td.onmouseover=function(e){
this.style.borderColor="white";
};
td.onmouseout=function(e){
this.style.borderColor="gray";
};
dojo.event.connect(td,"onmousedown",this,"click");
td.innerHTML="&nbsp;";
}
}
if(dojo.render.html.ie){
this.bgIframe=document.createElement("<iframe frameborder='0' src='javascript:void(0);'>");
with(this.bgIframe.style){
position="absolute";
left=top="0px";
display="none";
}
dojo.body().appendChild(this.bgIframe);
dojo.html.setOpacity(this.bgIframe,0);
}
},click:function(e){
this.onColorSelect(e.currentTarget.color);
e.currentTarget.style.borderColor="gray";
},onColorSelect:function(_9bc){
},hide:function(){
this.domNode.parentNode.removeChild(this.domNode);
if(this.bgIframe){
this.bgIframe.style.display="none";
}
},showAt:function(x,y){
with(this.domNode.style){
top=y+"px";
left=x+"px";
zIndex=999;
}
dojo.body().appendChild(this.domNode);
if(this.bgIframe){
with(this.bgIframe.style){
display="block";
top=y+"px";
left=x+"px";
zIndex=998;
var s=dojo.html.getMarginBox(this.domNode);
width=s.width+"px";
height=s.height+"px";
}
}
}});
dojo.provide("dojo.widget.Editor");
dojo.deprecated("dojo.widget.Editor","is replaced by dojo.widget.Editor2","0.5");
dojo.widget.tags.addParseTreeHandler("dojo:Editor");
dojo.widget.Editor=function(){
dojo.widget.HtmlWidget.call(this);
this.contentFilters=[];
this._toolbars=[];
};
dojo.inherits(dojo.widget.Editor,dojo.widget.HtmlWidget);
dojo.widget.Editor.itemGroups={textGroup:["bold","italic","underline","strikethrough"],blockGroup:["formatBlock","fontName","fontSize"],justifyGroup:["justifyleft","justifycenter","justifyright"],commandGroup:["save","cancel"],colorGroup:["forecolor","hilitecolor"],listGroup:["insertorderedlist","insertunorderedlist"],indentGroup:["outdent","indent"],linkGroup:["createlink","insertimage","inserthorizontalrule"]};
dojo.widget.Editor.formatBlockValues={"Normal":"p","Main heading":"h2","Sub heading":"h3","Sub sub heading":"h4","Preformatted":"pre"};
dojo.widget.Editor.fontNameValues={"Arial":"Arial, Helvetica, sans-serif","Verdana":"Verdana, sans-serif","Times New Roman":"Times New Roman, serif","Courier":"Courier New, monospace"};
dojo.widget.Editor.fontSizeValues={"1 (8 pt)":"1","2 (10 pt)":"2","3 (12 pt)":"3","4 (14 pt)":"4","5 (18 pt)":"5","6 (24 pt)":"6","7 (36 pt)":"7"};
dojo.widget.Editor.defaultItems=["commandGroup","|","blockGroup","|","textGroup","|","colorGroup","|","justifyGroup","|","listGroup","indentGroup","|","linkGroup"];
dojo.widget.Editor.supportedCommands=["save","cancel","|","-","/"," "];
dojo.lang.extend(dojo.widget.Editor,{widgetType:"Editor",saveUrl:"",saveMethod:"post",saveArgName:"editorContent",closeOnSave:false,items:dojo.widget.Editor.defaultItems,formatBlockItems:dojo.lang.shallowCopy(dojo.widget.Editor.formatBlockValues),fontNameItems:dojo.lang.shallowCopy(dojo.widget.Editor.fontNameValues),fontSizeItems:dojo.lang.shallowCopy(dojo.widget.Editor.fontSizeValues),getItemProperties:function(name){
var _9c1={};
switch(name.toLowerCase()){
case "bold":
case "italic":
case "underline":
case "strikethrough":
_9c1.toggleItem=true;
break;
case "justifygroup":
_9c1.defaultButton="justifyleft";
_9c1.preventDeselect=true;
_9c1.buttonGroup=true;
break;
case "listgroup":
_9c1.buttonGroup=true;
break;
case "save":
case "cancel":
_9c1.label=dojo.string.capitalize(name);
break;
case "forecolor":
case "hilitecolor":
_9c1.name=name;
_9c1.toggleItem=true;
_9c1.icon=this.getCommandImage(name);
break;
case "formatblock":
_9c1.name="formatBlock";
_9c1.values=this.formatBlockItems;
break;
case "fontname":
_9c1.name="fontName";
_9c1.values=this.fontNameItems;
case "fontsize":
_9c1.name="fontSize";
_9c1.values=this.fontSizeItems;
}
return _9c1;
},validateItems:true,focusOnLoad:true,minHeight:"1em",_richText:null,_richTextType:"RichText",_toolbarContainer:null,_toolbarContainerType:"ToolbarContainer",_toolbars:[],_toolbarType:"Toolbar",_toolbarItemType:"ToolbarItem",buildRendering:function(args,frag){
var node=frag["dojo:"+this.widgetType.toLowerCase()]["nodeRef"];
var trt=dojo.widget.createWidget(this._richTextType,{focusOnLoad:this.focusOnLoad,minHeight:this.minHeight},node);
var _9c6=this;
setTimeout(function(){
_9c6.setRichText(trt);
_9c6.initToolbar();
_9c6.fillInTemplate(args,frag);
},0);
},setRichText:function(_9c7){
if(this._richText&&this._richText==_9c7){
dojo.debug("Already set the richText to this richText!");
return;
}
if(this._richText&&!this._richText.isClosed){
dojo.debug("You are switching richTexts yet you haven't closed the current one. Losing reference!");
}
this._richText=_9c7;
dojo.event.connect(this._richText,"close",this,"onClose");
dojo.event.connect(this._richText,"onLoad",this,"onLoad");
dojo.event.connect(this._richText,"onDisplayChanged",this,"updateToolbar");
if(this._toolbarContainer){
this._toolbarContainer.enable();
this.updateToolbar(true);
}
},initToolbar:function(){
if(this._toolbarContainer){
return;
}
this._toolbarContainer=dojo.widget.createWidget(this._toolbarContainerType);
var tb=this.addToolbar();
var last=true;
for(var i=0;i<this.items.length;i++){
if(this.items[i]=="\n"){
tb=this.addToolbar();
}else{
if((this.items[i]=="|")&&(!last)){
last=true;
}else{
last=this.addItem(this.items[i],tb);
}
}
}
this.insertToolbar(this._toolbarContainer.domNode,this._richText.domNode);
},insertToolbar:function(_9cb,_9cc){
dojo.html.insertBefore(_9cb,_9cc);
},addToolbar:function(_9cd){
this.initToolbar();
if(!(_9cd instanceof dojo.widget.Toolbar)){
_9cd=dojo.widget.createWidget(this._toolbarType);
}
this._toolbarContainer.addChild(_9cd);
this._toolbars.push(_9cd);
return _9cd;
},addItem:function(item,tb,_9d0){
if(!tb){
tb=this._toolbars[0];
}
var cmd=((item)&&(!dojo.lang.isUndefined(item["getValue"])))?cmd=item["getValue"]():item;
var _9d2=dojo.widget.Editor.itemGroups;
if(item instanceof dojo.widget.ToolbarItem){
tb.addChild(item);
}else{
if(_9d2[cmd]){
var _9d3=_9d2[cmd];
var _9d4=true;
if(cmd=="justifyGroup"||cmd=="listGroup"){
var _9d5=[cmd];
for(var i=0;i<_9d3.length;i++){
if(_9d0||this.isSupportedCommand(_9d3[i])){
_9d5.push(this.getCommandImage(_9d3[i]));
}else{
_9d4=false;
}
}
if(_9d5.length){
var btn=tb.addChild(_9d5,null,this.getItemProperties(cmd));
dojo.event.connect(btn,"onClick",this,"_action");
dojo.event.connect(btn,"onChangeSelect",this,"_action");
}
return _9d4;
}else{
for(var i=0;i<_9d3.length;i++){
if(!this.addItem(_9d3[i],tb)){
_9d4=false;
}
}
return _9d4;
}
}else{
if((!_9d0)&&(!this.isSupportedCommand(cmd))){
return false;
}
if(_9d0||this.isSupportedCommand(cmd)){
cmd=cmd.toLowerCase();
if(cmd=="formatblock"){
var _9d8=dojo.widget.createWidget("ToolbarSelect",{name:"formatBlock",values:this.formatBlockItems});
tb.addChild(_9d8);
var _9d9=this;
dojo.event.connect(_9d8,"onSetValue",function(item,_9db){
_9d9.onAction("formatBlock",_9db);
});
}else{
if(cmd=="fontname"){
var _9d8=dojo.widget.createWidget("ToolbarSelect",{name:"fontName",values:this.fontNameItems});
tb.addChild(_9d8);
dojo.event.connect(_9d8,"onSetValue",dojo.lang.hitch(this,function(item,_9dd){
this.onAction("fontName",_9dd);
}));
}else{
if(cmd=="fontsize"){
var _9d8=dojo.widget.createWidget("ToolbarSelect",{name:"fontSize",values:this.fontSizeItems});
tb.addChild(_9d8);
dojo.event.connect(_9d8,"onSetValue",dojo.lang.hitch(this,function(item,_9df){
this.onAction("fontSize",_9df);
}));
}else{
if(dojo.lang.inArray(cmd,["forecolor","hilitecolor"])){
var btn=tb.addChild(dojo.widget.createWidget("ToolbarColorDialog",this.getItemProperties(cmd)));
dojo.event.connect(btn,"onSetValue",this,"_setValue");
}else{
var btn=tb.addChild(this.getCommandImage(cmd),null,this.getItemProperties(cmd));
if(cmd=="save"){
dojo.event.connect(btn,"onClick",this,"_save");
}else{
if(cmd=="cancel"){
dojo.event.connect(btn,"onClick",this,"_close");
}else{
dojo.event.connect(btn,"onClick",this,"_action");
dojo.event.connect(btn,"onChangeSelect",this,"_action");
}
}
}
}
}
}
}
}
}
return true;
},enableToolbar:function(){
if(this._toolbarContainer){
this._toolbarContainer.domNode.style.display="";
this._toolbarContainer.enable();
}
},disableToolbar:function(hide){
if(hide){
if(this._toolbarContainer){
this._toolbarContainer.domNode.style.display="none";
}
}else{
if(this._toolbarContainer){
this._toolbarContainer.disable();
}
}
},_updateToolbarLastRan:null,_updateToolbarTimer:null,_updateToolbarFrequency:500,updateToolbar:function(_9e1){
if(!this._toolbarContainer){
return;
}
var diff=new Date()-this._updateToolbarLastRan;
if(!_9e1&&this._updateToolbarLastRan&&(diff<this._updateToolbarFrequency)){
clearTimeout(this._updateToolbarTimer);
var _9e3=this;
this._updateToolbarTimer=setTimeout(function(){
_9e3.updateToolbar();
},this._updateToolbarFrequency/2);
return;
}else{
this._updateToolbarLastRan=new Date();
}
var _9e4=this._toolbarContainer.getItems();
for(var i=0;i<_9e4.length;i++){
var item=_9e4[i];
if(item instanceof dojo.widget.ToolbarSeparator){
continue;
}
var cmd=item._name;
if(cmd=="save"||cmd=="cancel"){
continue;
}else{
if(cmd=="justifyGroup"){
try{
if(!this._richText.queryCommandEnabled("justifyleft")){
item.disable(false,true);
}else{
item.enable(false,true);
var _9e8=item.getItems();
for(var j=0;j<_9e8.length;j++){
var name=_9e8[j]._name;
var _9eb=this._richText.queryCommandValue(name);
if(typeof _9eb=="boolean"&&_9eb){
_9eb=name;
break;
}else{
if(typeof _9eb=="string"){
_9eb="justify"+_9eb;
}else{
_9eb=null;
}
}
}
if(!_9eb){
_9eb="justifyleft";
}
item.setValue(_9eb,false,true);
}
}
catch(err){
}
}else{
if(cmd=="listGroup"){
var _9ec=item.getItems();
for(var j=0;j<_9ec.length;j++){
this.updateItem(_9ec[j]);
}
}else{
this.updateItem(item);
}
}
}
}
},updateItem:function(item){
try{
var cmd=item._name;
var _9ef=this._richText.queryCommandEnabled(cmd);
item.setEnabled(_9ef,false,true);
var _9f0=this._richText.queryCommandState(cmd);
if(_9f0&&cmd=="underline"){
_9f0=!this._richText.queryCommandEnabled("unlink");
}
item.setSelected(_9f0,false,true);
return true;
}
catch(err){
return false;
}
},supportedCommands:dojo.widget.Editor.supportedCommands.concat(),isSupportedCommand:function(cmd){
var yes=dojo.lang.inArray(cmd,this.supportedCommands);
if(!yes){
try{
var _9f3=this._richText||dojo.widget.HtmlRichText.prototype;
yes=_9f3.queryCommandAvailable(cmd);
}
catch(E){
}
}
return yes;
},getCommandImage:function(cmd){
if(cmd=="|"){
return cmd;
}else{
return dojo.uri.dojoUri("src/widget/templates/buttons/"+cmd+".gif");
}
},_action:function(e){
this._fire("onAction",e.getValue());
},_setValue:function(a,b){
this._fire("onAction",a.getValue(),b);
},_save:function(e){
if(!this._richText.isClosed){
if(this.saveUrl.length){
var _9f9={};
_9f9[this.saveArgName]=this.getHtml();
dojo.io.bind({method:this.saveMethod,url:this.saveUrl,content:_9f9});
}else{
dojo.debug("please set a saveUrl for the editor");
}
if(this.closeOnSave){
this._richText.close(e.getName().toLowerCase()=="save");
}
}
},_close:function(e){
if(!this._richText.isClosed){
this._richText.close(e.getName().toLowerCase()=="save");
}
},onAction:function(cmd,_9fc){
switch(cmd){
case "createlink":
if(!(_9fc=prompt("Please enter the URL of the link:","http://"))){
return;
}
break;
case "insertimage":
if(!(_9fc=prompt("Please enter the URL of the image:","http://"))){
return;
}
break;
}
this._richText.execCommand(cmd,_9fc);
},fillInTemplate:function(args,frag){
},_fire:function(_9ff){
if(dojo.lang.isFunction(this[_9ff])){
var args=[];
if(arguments.length==1){
args.push(this);
}else{
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
this[_9ff].apply(this,args);
}
},getHtml:function(){
this._richText.contentFilters=this._richText.contentFilters.concat(this.contentFilters);
return this._richText.getEditorContent();
},getEditorContent:function(){
return this.getHtml();
},onClose:function(save,hide){
this.disableToolbar(hide);
if(save){
this._fire("onSave");
}else{
this._fire("onCancel");
}
},onLoad:function(){
},onSave:function(){
},onCancel:function(){
}});
dojo.provide("dojo.lang.type");
dojo.lang.whatAmI=function(_a04){
dojo.deprecated("dojo.lang.whatAmI","use dojo.lang.getType instead","0.5");
return dojo.lang.getType(_a04);
};
dojo.lang.whatAmI.custom={};
dojo.lang.getType=function(_a05){
try{
if(dojo.lang.isArray(_a05)){
return "array";
}
if(dojo.lang.isFunction(_a05)){
return "function";
}
if(dojo.lang.isString(_a05)){
return "string";
}
if(dojo.lang.isNumber(_a05)){
return "number";
}
if(dojo.lang.isBoolean(_a05)){
return "boolean";
}
if(dojo.lang.isAlien(_a05)){
return "alien";
}
if(dojo.lang.isUndefined(_a05)){
return "undefined";
}
for(var name in dojo.lang.whatAmI.custom){
if(dojo.lang.whatAmI.custom[name](_a05)){
return name;
}
}
if(dojo.lang.isObject(_a05)){
return "object";
}
}
catch(e){
}
return "unknown";
};
dojo.lang.isNumeric=function(_a07){
return (!isNaN(_a07)&&isFinite(_a07)&&(_a07!=null)&&!dojo.lang.isBoolean(_a07)&&!dojo.lang.isArray(_a07)&&!/^\s*$/.test(_a07));
};
dojo.lang.isBuiltIn=function(_a08){
return (dojo.lang.isArray(_a08)||dojo.lang.isFunction(_a08)||dojo.lang.isString(_a08)||dojo.lang.isNumber(_a08)||dojo.lang.isBoolean(_a08)||(_a08==null)||(_a08 instanceof Error)||(typeof _a08=="error"));
};
dojo.lang.isPureObject=function(_a09){
return ((_a09!=null)&&dojo.lang.isObject(_a09)&&_a09.constructor==Object);
};
dojo.lang.isOfType=function(_a0a,type,_a0c){
var _a0d=false;
if(_a0c){
_a0d=_a0c["optional"];
}
if(_a0d&&((_a0a===null)||dojo.lang.isUndefined(_a0a))){
return true;
}
if(dojo.lang.isArray(type)){
var _a0e=type;
for(var i in _a0e){
var _a10=_a0e[i];
if(dojo.lang.isOfType(_a0a,_a10)){
return true;
}
}
return false;
}else{
if(dojo.lang.isString(type)){
type=type.toLowerCase();
}
switch(type){
case Array:
case "array":
return dojo.lang.isArray(_a0a);
case Function:
case "function":
return dojo.lang.isFunction(_a0a);
case String:
case "string":
return dojo.lang.isString(_a0a);
case Number:
case "number":
return dojo.lang.isNumber(_a0a);
case "numeric":
return dojo.lang.isNumeric(_a0a);
case Boolean:
case "boolean":
return dojo.lang.isBoolean(_a0a);
case Object:
case "object":
return dojo.lang.isObject(_a0a);
case "pureobject":
return dojo.lang.isPureObject(_a0a);
case "builtin":
return dojo.lang.isBuiltIn(_a0a);
case "alien":
return dojo.lang.isAlien(_a0a);
case "undefined":
return dojo.lang.isUndefined(_a0a);
case null:
case "null":
return (_a0a===null);
case "optional":
dojo.deprecated("dojo.lang.isOfType(value, [type, \"optional\"])","use dojo.lang.isOfType(value, type, {optional: true} ) instead","0.5");
return ((_a0a===null)||dojo.lang.isUndefined(_a0a));
default:
if(dojo.lang.isFunction(type)){
return (_a0a instanceof type);
}else{
dojo.raise("dojo.lang.isOfType() was passed an invalid type");
}
}
}
dojo.raise("If we get here, it means a bug was introduced above.");
};
dojo.lang.getObject=function(str){
var _a12=str.split("."),i=0,obj=dj_global;
do{
obj=obj[_a12[i++]];
}while(i<_a12.length&&obj);
return (obj!=dj_global)?obj:null;
};
dojo.lang.doesObjectExist=function(str){
var _a16=str.split("."),i=0,obj=dj_global;
do{
obj=obj[_a16[i++]];
}while(i<_a16.length&&obj);
return (obj&&obj!=dj_global);
};
dojo.provide("dojo.lang.assert");
dojo.lang.assert=function(_a19,_a1a){
if(!_a19){
var _a1b="An assert statement failed.\n"+"The method dojo.lang.assert() was called with a 'false' value.\n";
if(_a1a){
_a1b+="Here's the assert message:\n"+_a1a+"\n";
}
throw new Error(_a1b);
}
};
dojo.lang.assertType=function(_a1c,type,_a1e){
if(dojo.lang.isString(_a1e)){
dojo.deprecated("dojo.lang.assertType(value, type, \"message\")","use dojo.lang.assertType(value, type) instead","0.5");
}
if(!dojo.lang.isOfType(_a1c,type,_a1e)){
if(!dojo.lang.assertType._errorMessage){
dojo.lang.assertType._errorMessage="Type mismatch: dojo.lang.assertType() failed.";
}
dojo.lang.assert(false,dojo.lang.assertType._errorMessage);
}
};
dojo.lang.assertValidKeywords=function(_a1f,_a20,_a21){
var key;
if(!_a21){
if(!dojo.lang.assertValidKeywords._errorMessage){
dojo.lang.assertValidKeywords._errorMessage="In dojo.lang.assertValidKeywords(), found invalid keyword:";
}
_a21=dojo.lang.assertValidKeywords._errorMessage;
}
if(dojo.lang.isArray(_a20)){
for(key in _a1f){
if(!dojo.lang.inArray(_a20,key)){
dojo.lang.assert(false,_a21+" "+key);
}
}
}else{
for(key in _a1f){
if(!(key in _a20)){
dojo.lang.assert(false,_a21+" "+key);
}
}
}
};
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_a23){
this.pairs=[];
this.returnWrappers=_a23||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_a25,wrap,_a27,_a28){
var type=(_a28)?"unshift":"push";
this.pairs[type]([name,_a25,wrap,_a27]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.lang.repr");
dojo.lang.reprRegistry=new dojo.AdapterRegistry();
dojo.lang.registerRepr=function(name,_a30,wrap,_a32){
dojo.lang.reprRegistry.register(name,_a30,wrap,_a32);
};
dojo.lang.repr=function(obj){
if(typeof (obj)=="undefined"){
return "undefined";
}else{
if(obj===null){
return "null";
}
}
try{
if(typeof (obj["__repr__"])=="function"){
return obj["__repr__"]();
}else{
if((typeof (obj["repr"])=="function")&&(obj.repr!=arguments.callee)){
return obj["repr"]();
}
}
return dojo.lang.reprRegistry.match(obj);
}
catch(e){
if(typeof (obj.NAME)=="string"&&(obj.toString==Function.prototype.toString||obj.toString==Object.prototype.toString)){
return obj.NAME;
}
}
if(typeof (obj)=="function"){
obj=(obj+"").replace(/^\s+/,"");
var idx=obj.indexOf("{");
if(idx!=-1){
obj=obj.substr(0,idx)+"{...}";
}
}
return obj+"";
};
dojo.lang.reprArrayLike=function(arr){
try{
var na=dojo.lang.map(arr,dojo.lang.repr);
return "["+na.join(", ")+"]";
}
catch(e){
}
};
(function(){
var m=dojo.lang;
m.registerRepr("arrayLike",m.isArrayLike,m.reprArrayLike);
m.registerRepr("string",m.isString,m.reprString);
m.registerRepr("numbers",m.isNumber,m.reprNumber);
m.registerRepr("boolean",m.isBoolean,m.reprNumber);
})();
dojo.provide("dojo.lang.*");
dojo.provide("dojo.html.iframe");
dojo.html.iframeContentWindow=function(_a38){
var win=dojo.html.getDocumentWindow(dojo.html.iframeContentDocument(_a38))||dojo.html.iframeContentDocument(_a38).__parent__||(_a38.name&&document.frames[_a38.name])||null;
return win;
};
dojo.html.iframeContentDocument=function(_a3a){
var doc=_a3a.contentDocument||((_a3a.contentWindow)&&(_a3a.contentWindow.document))||((_a3a.name)&&(document.frames[_a3a.name])&&(document.frames[_a3a.name].document))||null;
return doc;
};
dojo.html.BackgroundIframe=function(node){
if(dojo.render.html.ie55||dojo.render.html.ie60){
var html="<iframe src='javascript:false'"+"' style='position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;"+"z-index: -1; filter:Alpha(Opacity=\"0\");' "+">";
this.iframe=dojo.doc().createElement(html);
this.iframe.tabIndex=-1;
if(node){
node.appendChild(this.iframe);
this.domNode=node;
}else{
dojo.body().appendChild(this.iframe);
this.iframe.style.display="none";
}
}
};
dojo.lang.extend(dojo.html.BackgroundIframe,{iframe:null,onResized:function(){
if(this.iframe&&this.domNode&&this.domNode.parentNode){
var _a3e=dojo.html.getMarginBox(this.domNode);
if(_a3e.width==0||_a3e.height==0){
dojo.lang.setTimeout(this,this.onResized,100);
return;
}
this.iframe.style.width=_a3e.width+"px";
this.iframe.style.height=_a3e.height+"px";
}
},size:function(node){
if(!this.iframe){
return;
}
var _a40=dojo.html.toCoordinateObject(node,true,dojo.html.boxSizing.BORDER_BOX);
this.iframe.style.width=_a40.width+"px";
this.iframe.style.height=_a40.height+"px";
this.iframe.style.left=_a40.left+"px";
this.iframe.style.top=_a40.top+"px";
},setZIndex:function(node){
if(!this.iframe){
return;
}
if(dojo.dom.isNode(node)){
this.iframe.style.zIndex=dojo.html.getStyle(node,"z-index")-1;
}else{
if(!isNaN(node)){
this.iframe.style.zIndex=node;
}
}
},show:function(){
if(!this.iframe){
return;
}
this.iframe.style.display="block";
},hide:function(){
if(!this.iframe){
return;
}
this.iframe.style.display="none";
},remove:function(){
dojo.html.removeNode(this.iframe);
}});
dojo.provide("dojo.widget.PopupContainer");
dojo.declare("dojo.widget.PopupContainerBase",null,function(){
this.queueOnAnimationFinish=[];
},{isContainer:true,templateString:"<div dojoAttachPoint=\"containerNode\" style=\"display:none;position:absolute;\" class=\"dojoPopupContainer\" ></div>",isShowingNow:false,currentSubpopup:null,beginZIndex:1000,parentPopup:null,parent:null,popupIndex:0,aroundBox:dojo.html.boxSizing.BORDER_BOX,openedForWindow:null,processKey:function(evt){
return false;
},applyPopupBasicStyle:function(){
with(this.domNode.style){
display="none";
position="absolute";
}
},aboutToShow:function(){
},open:function(x,y,_a45,_a46,_a47,_a48){
if(this.isShowingNow){
return;
}
this.aboutToShow();
if(this.animationInProgress){
this.queueOnAnimationFinish.push(this.open,arguments);
return;
}
this.parent=_a45;
var _a49=false,node,_a4b;
if(typeof x=="object"){
node=x;
_a4b=_a46;
_a46=_a45;
_a45=y;
_a49=true;
}
dojo.body().appendChild(this.domNode);
_a46=_a46||_a45["domNode"]||[];
var _a4c=null;
this.isTopLevel=true;
while(_a45){
if(_a45!==this&&(_a45.setOpenedSubpopup!=undefined&&_a45.applyPopupBasicStyle!=undefined)){
_a4c=_a45;
this.isTopLevel=false;
_a4c.setOpenedSubpopup(this);
break;
}
_a45=_a45.parent;
}
this.parentPopup=_a4c;
this.popupIndex=_a4c?_a4c.popupIndex+1:1;
if(this.isTopLevel){
var _a4d=dojo.html.isNode(_a46)?_a46:null;
dojo.widget.PopupManager.opened(this,_a4d);
}
if(this.isTopLevel&&!dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.isCollapsed)){
this._bookmark=dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.getBookmark);
}else{
this._bookmark=null;
}
if(_a46 instanceof Array){
_a46={left:_a46[0],top:_a46[1],width:0,height:0};
}
with(this.domNode.style){
display="";
zIndex=this.beginZIndex+this.popupIndex;
}
if(_a49){
this.move(node,_a48,_a4b);
}else{
this.move(x,y,_a48,_a47);
}
this.domNode.style.display="none";
this.explodeSrc=_a46;
this.show();
this.isShowingNow=true;
},move:function(x,y,_a50,_a51){
var _a52=(typeof x=="object");
if(_a52){
var _a53=_a50;
var node=x;
_a50=y;
if(!_a53){
_a53={"BL":"TL","TL":"BL"};
}
dojo.html.placeOnScreenAroundElement(this.domNode,node,_a50,this.aroundBox,_a53);
}else{
if(!_a51){
_a51="TL,TR,BL,BR";
}
dojo.html.placeOnScreen(this.domNode,x,y,_a50,true,_a51);
}
},close:function(_a55){
if(_a55){
this.domNode.style.display="none";
}
if(this.animationInProgress){
this.queueOnAnimationFinish.push(this.close,[]);
return;
}
this.closeSubpopup(_a55);
this.hide();
if(this.bgIframe){
this.bgIframe.hide();
this.bgIframe.size({left:0,top:0,width:0,height:0});
}
if(this.isTopLevel){
dojo.widget.PopupManager.closed(this);
}
this.isShowingNow=false;
try{
this.parent.domNode.focus();
}
catch(e){
}
if(this._bookmark&&dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.isCollapsed)){
if(this.openedForWindow){
this.openedForWindow.focus();
}
dojo.withGlobal(this.openedForWindow||dojo.global(),"moveToBookmark",dojo.html.selection,[this._bookmark]);
}
this._bookmark=null;
},closeAll:function(_a56){
if(this.parentPopup){
this.parentPopup.closeAll(_a56);
}else{
this.close(_a56);
}
},setOpenedSubpopup:function(_a57){
this.currentSubpopup=_a57;
},closeSubpopup:function(_a58){
if(this.currentSubpopup==null){
return;
}
this.currentSubpopup.close(_a58);
this.currentSubpopup=null;
},onShow:function(){
dojo.widget.PopupContainer.superclass.onShow.apply(this,arguments);
this.openedSize={w:this.domNode.style.width,h:this.domNode.style.height};
if(dojo.render.html.ie){
if(!this.bgIframe){
this.bgIframe=new dojo.html.BackgroundIframe();
this.bgIframe.setZIndex(this.domNode);
}
this.bgIframe.size(this.domNode);
this.bgIframe.show();
}
this.processQueue();
},processQueue:function(){
if(!this.queueOnAnimationFinish.length){
return;
}
var func=this.queueOnAnimationFinish.shift();
var args=this.queueOnAnimationFinish.shift();
func.apply(this,args);
},onHide:function(){
dojo.widget.HtmlWidget.prototype.onHide.call(this);
if(this.openedSize){
with(this.domNode.style){
width=this.openedSize.w;
height=this.openedSize.h;
}
}
this.processQueue();
}});
dojo.widget.defineWidget("dojo.widget.PopupContainer",[dojo.widget.HtmlWidget,dojo.widget.PopupContainerBase],{});
dojo.widget.PopupManager=new function(){
this.currentMenu=null;
this.currentButton=null;
this.currentFocusMenu=null;
this.focusNode=null;
this.registeredWindows=[];
this.registerWin=function(win){
if(!win.__PopupManagerRegistered){
dojo.event.connect(win.document,"onmousedown",this,"onClick");
dojo.event.connect(win,"onscroll",this,"onClick");
dojo.event.connect(win.document,"onkey",this,"onKey");
win.__PopupManagerRegistered=true;
this.registeredWindows.push(win);
}
};
this.registerAllWindows=function(_a5c){
if(!_a5c){
_a5c=dojo.html.getDocumentWindow(window.top&&window.top.document||window.document);
}
this.registerWin(_a5c);
for(var i=0;i<_a5c.frames.length;i++){
try{
var win=dojo.html.getDocumentWindow(_a5c.frames[i].document);
if(win){
this.registerAllWindows(win);
}
}
catch(e){
}
}
};
this.unRegisterWin=function(win){
if(win.__PopupManagerRegistered){
dojo.event.disconnect(win.document,"onmousedown",this,"onClick");
dojo.event.disconnect(win,"onscroll",this,"onClick");
dojo.event.disconnect(win.document,"onkey",this,"onKey");
win.__PopupManagerRegistered=false;
}
};
this.unRegisterAllWindows=function(){
for(var i=0;i<this.registeredWindows.length;++i){
this.unRegisterWin(this.registeredWindows[i]);
}
this.registeredWindows=[];
};
dojo.addOnLoad(this,"registerAllWindows");
dojo.addOnUnload(this,"unRegisterAllWindows");
this.closed=function(menu){
if(this.currentMenu==menu){
this.currentMenu=null;
this.currentButton=null;
this.currentFocusMenu=null;
}
};
this.opened=function(menu,_a63){
if(menu==this.currentMenu){
return;
}
if(this.currentMenu){
this.currentMenu.close();
}
this.currentMenu=menu;
this.currentFocusMenu=menu;
this.currentButton=_a63;
};
this.setFocusedMenu=function(menu){
this.currentFocusMenu=menu;
};
this.onKey=function(e){
if(!e.key){
return;
}
if(!this.currentMenu||!this.currentMenu.isShowingNow){
return;
}
var m=this.currentFocusMenu;
while(m){
if(m.processKey(e)){
e.preventDefault();
e.stopPropagation();
break;
}
m=m.parentPopup;
}
},this.onClick=function(e){
if(!this.currentMenu){
return;
}
var _a68=dojo.html.getScroll().offset;
var m=this.currentMenu;
while(m){
if(dojo.html.overElement(m.domNode,e)||dojo.html.isDescendantOf(e.target,m.domNode)){
return;
}
m=m.currentSubpopup;
}
if(this.currentButton&&dojo.html.overElement(this.currentButton,e)){
return;
}
this.currentMenu.close();
};
};
dojo.provide("dojo.widget.ContentPane");
dojo.widget.defineWidget("dojo.widget.ContentPane",dojo.widget.HtmlWidget,function(){
this._styleNodes=[];
this._onLoadStack=[];
this._onUnloadStack=[];
this._callOnUnload=false;
this._ioBindObj;
this.scriptScope;
this.bindArgs={};
},{isContainer:true,adjustPaths:true,href:"",extractContent:true,parseContent:true,cacheContent:true,preload:false,refreshOnShow:false,handler:"",executeScripts:false,scriptSeparation:true,loadingMessage:"Loading...",isLoaded:false,postCreate:function(args,frag,_a6c){
if(this.handler!==""){
this.setHandler(this.handler);
}
if(this.isShowing()||this.preload){
this.loadContents();
}
},show:function(){
if(this.refreshOnShow){
this.refresh();
}else{
this.loadContents();
}
dojo.widget.ContentPane.superclass.show.call(this);
},refresh:function(){
this.isLoaded=false;
this.loadContents();
},loadContents:function(){
if(this.isLoaded){
return;
}
if(dojo.lang.isFunction(this.handler)){
this._runHandler();
}else{
if(this.href!=""){
this._downloadExternalContent(this.href,this.cacheContent&&!this.refreshOnShow);
}
}
},setUrl:function(url){
this.href=url;
this.isLoaded=false;
if(this.preload||this.isShowing()){
this.loadContents();
}
},abort:function(){
var bind=this._ioBindObj;
if(!bind||!bind.abort){
return;
}
bind.abort();
delete this._ioBindObj;
},_downloadExternalContent:function(url,_a70){
this.abort();
this._handleDefaults(this.loadingMessage,"onDownloadStart");
var self=this;
this._ioBindObj=dojo.io.bind(this._cacheSetting({url:url,mimetype:"text/html",handler:function(type,data,xhr){
delete self._ioBindObj;
if(type=="load"){
self.onDownloadEnd.call(self,url,data);
}else{
var e={responseText:xhr.responseText,status:xhr.status,statusText:xhr.statusText,responseHeaders:xhr.getAllResponseHeaders(),text:"Error loading '"+url+"' ("+xhr.status+" "+xhr.statusText+")"};
self._handleDefaults.call(self,e,"onDownloadError");
self.onLoad();
}
}},_a70));
},_cacheSetting:function(_a76,_a77){
for(var x in this.bindArgs){
if(dojo.lang.isUndefined(_a76[x])){
_a76[x]=this.bindArgs[x];
}
}
if(dojo.lang.isUndefined(_a76.useCache)){
_a76.useCache=_a77;
}
if(dojo.lang.isUndefined(_a76.preventCache)){
_a76.preventCache=!_a77;
}
if(dojo.lang.isUndefined(_a76.mimetype)){
_a76.mimetype="text/html";
}
return _a76;
},onLoad:function(e){
this._runStack("_onLoadStack");
this.isLoaded=true;
},onUnLoad:function(e){
dojo.deprecated(this.widgetType+".onUnLoad, use .onUnload (lowercased load)",0.5);
},onUnload:function(e){
this._runStack("_onUnloadStack");
delete this.scriptScope;
if(this.onUnLoad!==dojo.widget.ContentPane.prototype.onUnLoad){
this.onUnLoad.apply(this,arguments);
}
},_runStack:function(_a7c){
var st=this[_a7c];
var err="";
var _a7f=this.scriptScope||window;
for(var i=0;i<st.length;i++){
try{
st[i].call(_a7f);
}
catch(e){
err+="\n"+st[i]+" failed: "+e.description;
}
}
this[_a7c]=[];
if(err.length){
var name=(_a7c=="_onLoadStack")?"addOnLoad":"addOnUnLoad";
this._handleDefaults(name+" failure\n "+err,"onExecError","debug");
}
},addOnLoad:function(obj,func){
this._pushOnStack(this._onLoadStack,obj,func);
},addOnUnload:function(obj,func){
this._pushOnStack(this._onUnloadStack,obj,func);
},addOnUnLoad:function(){
dojo.deprecated(this.widgetType+".addOnUnLoad, use addOnUnload instead. (lowercased Load)",0.5);
this.addOnUnload.apply(this,arguments);
},_pushOnStack:function(_a86,obj,func){
if(typeof func=="undefined"){
_a86.push(obj);
}else{
_a86.push(function(){
obj[func]();
});
}
},destroy:function(){
this.onUnload();
dojo.widget.ContentPane.superclass.destroy.call(this);
},onExecError:function(e){
},onContentError:function(e){
},onDownloadError:function(e){
},onDownloadStart:function(e){
},onDownloadEnd:function(url,data){
data=this.splitAndFixPaths(data,url);
this.setContent(data);
},_handleDefaults:function(e,_a90,_a91){
if(!_a90){
_a90="onContentError";
}
if(dojo.lang.isString(e)){
e={text:e};
}
if(!e.text){
e.text=e.toString();
}
e.toString=function(){
return this.text;
};
if(typeof e.returnValue!="boolean"){
e.returnValue=true;
}
if(typeof e.preventDefault!="function"){
e.preventDefault=function(){
this.returnValue=false;
};
}
this[_a90](e);
if(e.returnValue){
switch(_a91){
case true:
case "alert":
alert(e.toString());
break;
case "debug":
dojo.debug(e.toString());
break;
default:
if(this._callOnUnload){
this.onUnload();
}
this._callOnUnload=false;
if(arguments.callee._loopStop){
dojo.debug(e.toString());
}else{
arguments.callee._loopStop=true;
this._setContent(e.toString());
}
}
}
arguments.callee._loopStop=false;
},splitAndFixPaths:function(s,url){
var _a94=[],_a95=[],tmp=[];
var _a97=[],_a98=[],attr=[],_a9a=[];
var str="",path="",fix="",_a9e="",tag="",_aa0="";
if(!url){
url="./";
}
if(s){
var _aa1=/<title[^>]*>([\s\S]*?)<\/title>/i;
while(_a97=_aa1.exec(s)){
_a94.push(_a97[1]);
s=s.substring(0,_a97.index)+s.substr(_a97.index+_a97[0].length);
}
if(this.adjustPaths){
var _aa2=/<[a-z][a-z0-9]*[^>]*\s(?:(?:src|href|style)=[^>])+[^>]*>/i;
var _aa3=/\s(src|href|style)=(['"]?)([\w()\[\]\/.,\\'"-:;#=&?\s@]+?)\2/i;
var _aa4=/^(?:[#]|(?:(?:https?|ftps?|file|javascript|mailto|news):))/;
while(tag=_aa2.exec(s)){
str+=s.substring(0,tag.index);
s=s.substring((tag.index+tag[0].length),s.length);
tag=tag[0];
_a9e="";
while(attr=_aa3.exec(tag)){
path="";
_aa0=attr[3];
switch(attr[1].toLowerCase()){
case "src":
case "href":
if(_aa4.exec(_aa0)){
path=_aa0;
}else{
path=(new dojo.uri.Uri(url,_aa0).toString());
}
break;
case "style":
path=dojo.html.fixPathsInCssText(_aa0,url);
break;
default:
path=_aa0;
}
fix=" "+attr[1]+"="+attr[2]+path+attr[2];
_a9e+=tag.substring(0,attr.index)+fix;
tag=tag.substring((attr.index+attr[0].length),tag.length);
}
str+=_a9e+tag;
}
s=str+s;
}
_aa1=/(?:<(style)[^>]*>([\s\S]*?)<\/style>|<link ([^>]*rel=['"]?stylesheet['"]?[^>]*)>)/i;
while(_a97=_aa1.exec(s)){
if(_a97[1]&&_a97[1].toLowerCase()=="style"){
_a9a.push(dojo.html.fixPathsInCssText(_a97[2],url));
}else{
if(attr=_a97[3].match(/href=(['"]?)([^'">]*)\1/i)){
_a9a.push({path:attr[2]});
}
}
s=s.substring(0,_a97.index)+s.substr(_a97.index+_a97[0].length);
}
var _aa1=/<script([^>]*)>([\s\S]*?)<\/script>/i;
var _aa5=/src=(['"]?)([^"']*)\1/i;
var _aa6=/.*(\bdojo\b\.js(?:\.uncompressed\.js)?)$/;
var _aa7=/(?:var )?\bdjConfig\b(?:[\s]*=[\s]*\{[^}]+\}|\.[\w]*[\s]*=[\s]*[^;\n]*)?;?|dojo\.hostenv\.writeIncludes\(\s*\);?/g;
var _aa8=/dojo\.(?:(?:require(?:After)?(?:If)?)|(?:widget\.(?:manager\.)?registerWidgetPackage)|(?:(?:hostenv\.)?setModulePrefix|registerModulePath)|defineNamespace)\((['"]).*?\1\)\s*;?/;
while(_a97=_aa1.exec(s)){
if(this.executeScripts&&_a97[1]){
if(attr=_aa5.exec(_a97[1])){
if(_aa6.exec(attr[2])){
dojo.debug("Security note! inhibit:"+attr[2]+" from  being loaded again.");
}else{
_a95.push({path:attr[2]});
}
}
}
if(_a97[2]){
var sc=_a97[2].replace(_aa7,"");
if(!sc){
continue;
}
while(tmp=_aa8.exec(sc)){
_a98.push(tmp[0]);
sc=sc.substring(0,tmp.index)+sc.substr(tmp.index+tmp[0].length);
}
if(this.executeScripts){
_a95.push(sc);
}
}
s=s.substr(0,_a97.index)+s.substr(_a97.index+_a97[0].length);
}
if(this.extractContent){
_a97=s.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_a97){
s=_a97[1];
}
}
if(this.executeScripts&&this.scriptSeparation){
var _aa1=/(<[a-zA-Z][a-zA-Z0-9]*\s[^>]*?\S=)((['"])[^>]*scriptScope[^>]*>)/;
var _aaa=/([\s'";:\(])scriptScope(.*)/;
str="";
while(tag=_aa1.exec(s)){
tmp=((tag[3]=="'")?"\"":"'");
fix="";
str+=s.substring(0,tag.index)+tag[1];
while(attr=_aaa.exec(tag[2])){
tag[2]=tag[2].substring(0,attr.index)+attr[1]+"dojo.widget.byId("+tmp+this.widgetId+tmp+").scriptScope"+attr[2];
}
str+=tag[2];
s=s.substr(tag.index+tag[0].length);
}
s=str+s;
}
}
return {"xml":s,"styles":_a9a,"titles":_a94,"requires":_a98,"scripts":_a95,"url":url};
},_setContent:function(cont){
this.destroyChildren();
for(var i=0;i<this._styleNodes.length;i++){
if(this._styleNodes[i]&&this._styleNodes[i].parentNode){
this._styleNodes[i].parentNode.removeChild(this._styleNodes[i]);
}
}
this._styleNodes=[];
var node=this.containerNode||this.domNode;
while(node.firstChild){
try{
dojo.event.browser.clean(node.firstChild);
}
catch(e){
}
node.removeChild(node.firstChild);
}
try{
if(typeof cont!="string"){
node.innerHTML="";
node.appendChild(cont);
}else{
node.innerHTML=cont;
}
}
catch(e){
e.text="Couldn't load content:"+e.description;
this._handleDefaults(e,"onContentError");
}
},setContent:function(data){
this.abort();
if(this._callOnUnload){
this.onUnload();
}
this._callOnUnload=true;
if(!data||dojo.html.isNode(data)){
this._setContent(data);
this.onResized();
this.onLoad();
}else{
if(typeof data.xml!="string"){
this.href="";
data=this.splitAndFixPaths(data);
}
this._setContent(data.xml);
for(var i=0;i<data.styles.length;i++){
if(data.styles[i].path){
this._styleNodes.push(dojo.html.insertCssFile(data.styles[i].path));
}else{
this._styleNodes.push(dojo.html.insertCssText(data.styles[i]));
}
}
if(this.parseContent){
for(var i=0;i<data.requires.length;i++){
try{
eval(data.requires[i]);
}
catch(e){
e.text="ContentPane: error in package loading calls, "+(e.description||e);
this._handleDefaults(e,"onContentError","debug");
}
}
}
var _ab0=this;
function asyncParse(){
if(_ab0.executeScripts){
_ab0._executeScripts(data.scripts);
}
if(_ab0.parseContent){
var node=_ab0.containerNode||_ab0.domNode;
var _ab2=new dojo.xml.Parse();
var frag=_ab2.parseElement(node,null,true);
dojo.widget.getParser().createSubComponents(frag,_ab0);
}
_ab0.onResized();
_ab0.onLoad();
}
if(dojo.hostenv.isXDomain&&data.requires.length){
dojo.addOnLoad(asyncParse);
}else{
asyncParse();
}
}
},setHandler:function(_ab4){
var fcn=dojo.lang.isFunction(_ab4)?_ab4:window[_ab4];
if(!dojo.lang.isFunction(fcn)){
this._handleDefaults("Unable to set handler, '"+_ab4+"' not a function.","onExecError",true);
return;
}
this.handler=function(){
return fcn.apply(this,arguments);
};
},_runHandler:function(){
var ret=true;
if(dojo.lang.isFunction(this.handler)){
this.handler(this,this.domNode);
ret=false;
}
this.onLoad();
return ret;
},_executeScripts:function(_ab7){
var self=this;
var tmp="",code="";
for(var i=0;i<_ab7.length;i++){
if(_ab7[i].path){
dojo.io.bind(this._cacheSetting({"url":_ab7[i].path,"load":function(type,_abd){
dojo.lang.hitch(self,tmp=";"+_abd);
},"error":function(type,_abf){
_abf.text=type+" downloading remote script";
self._handleDefaults.call(self,_abf,"onExecError","debug");
},"mimetype":"text/plain","sync":true},this.cacheContent));
code+=tmp;
}else{
code+=_ab7[i];
}
}
try{
if(this.scriptSeparation){
delete this.scriptScope;
this.scriptScope=new (new Function("_container_",code+"; return this;"))(self);
}else{
var djg=dojo.global();
if(djg.execScript){
djg.execScript(code);
}else{
var djd=dojo.doc();
var sc=djd.createElement("script");
sc.appendChild(djd.createTextNode(code));
(this.containerNode||this.domNode).appendChild(sc);
}
}
}
catch(e){
e.text="Error running scripts from content:\n"+e.description;
this._handleDefaults(e,"onExecError","debug");
}
}});
dojo.provide("dojo.widget.Editor2Toolbar");
dojo.widget.Editor2ToolbarItemManager={_registeredItemHandlers:[],registerHandler:function(obj,func){
if(arguments.length==2){
this._registeredItemHandlers.push(function(){
return obj[func].apply(obj,arguments);
});
}else{
this._registeredItemHandlers.push(obj);
}
},removeHandler:function(func){
for(var i in this._registeredItemHandlers){
if(func===this._registeredItemHandlers[i]){
delete this._registeredItemHandlers[i];
return;
}
}
dojo.debug("Editor2ToolbarItemManager handler "+func+" is not registered, can not remove.");
},destroy:function(){
for(var i in this._registeredItemHandlers){
delete this._registeredItemHandlers[i];
}
},getToolbarItem:function(name){
var item;
name=name.toLowerCase();
for(var i in this._registeredItemHandlers){
item=this._registeredItemHandlers[i](name);
if(item){
break;
}
}
if(!item){
switch(name){
case "bold":
case "copy":
case "cut":
case "delete":
case "indent":
case "inserthorizontalrule":
case "insertorderedlist":
case "insertunorderedlist":
case "italic":
case "justifycenter":
case "justifyfull":
case "justifyleft":
case "justifyright":
case "outdent":
case "paste":
case "redo":
case "removeformat":
case "selectall":
case "strikethrough":
case "subscript":
case "superscript":
case "underline":
case "undo":
case "unlink":
case "createlink":
case "insertimage":
case "htmltoggle":
item=new dojo.widget.Editor2ToolbarButton(name);
break;
case "forecolor":
case "hilitecolor":
item=new dojo.widget.Editor2ToolbarColorPaletteButton(name);
break;
case "plainformatblock":
item=new dojo.widget.Editor2ToolbarFormatBlockPlainSelect("formatblock");
break;
case "formatblock":
item=new dojo.widget.Editor2ToolbarFormatBlockSelect("formatblock");
break;
case "fontsize":
item=new dojo.widget.Editor2ToolbarFontSizeSelect("fontsize");
break;
case "fontname":
item=new dojo.widget.Editor2ToolbarFontNameSelect("fontname");
break;
case "inserttable":
case "insertcell":
case "insertcol":
case "insertrow":
case "deletecells":
case "deletecols":
case "deleterows":
case "mergecells":
case "splitcell":
dojo.debug(name+" is implemented in dojo.widget.Editor2Plugin.TableOperation, please require it first.");
break;
case "inserthtml":
case "blockdirltr":
case "blockdirrtl":
case "dirltr":
case "dirrtl":
case "inlinedirltr":
case "inlinedirrtl":
dojo.debug("Not yet implemented toolbar item: "+name);
break;
default:
dojo.debug("dojo.widget.Editor2ToolbarItemManager.getToolbarItem: Unknown toolbar item: "+name);
}
}
return item;
}};
dojo.addOnUnload(dojo.widget.Editor2ToolbarItemManager,"destroy");
dojo.declare("dojo.widget.Editor2ToolbarButton",null,{initializer:function(name){
this._name=name;
this._command=dojo.widget.Editor2Manager.getCommand(name);
},create:function(node,_acd,_ace){
this._domNode=node;
this.disableSelection(this._domNode);
this._parentToolbar=_acd;
dojo.event.connect(this._domNode,"onclick",this,"onClick");
if(!_ace){
dojo.event.connect(this._domNode,"onmouseover",this,"onMouseOver");
dojo.event.connect(this._domNode,"onmouseout",this,"onMouseOut");
}
},disableSelection:function(_acf){
dojo.html.disableSelection(_acf);
var _ad0=_acf.all||_acf.getElementsByTagName("*");
for(var x=0;x<_ad0.length;x++){
dojo.html.disableSelection(_ad0[x]);
}
},onMouseOver:function(){
if(this._command.getState()!=dojo.widget.Editor2Manager.commandState.Disabled){
this.highlightToolbarItem();
}
},onMouseOut:function(){
this.unhighlightToolbarItem();
},destroy:function(){
this._domNode=null;
delete this._command;
this._parentToolbar=null;
},onClick:function(e){
if(this._domNode&&!this._domNode.disabled&&this._command){
e.preventDefault();
e.stopPropagation();
this._command.execute();
}
},refreshState:function(){
if(this._domNode&&this._command){
var em=dojo.widget.Editor2Manager;
var _ad4=this._command.getState();
if(_ad4!=this._lastState){
switch(_ad4){
case em.commandState.Latched:
this.latchToolbarItem();
break;
case em.commandState.Enabled:
this.enableToolbarItem();
break;
case em.commandState.Disabled:
default:
this.disableToolbarItem();
}
this._lastState=_ad4;
}
return _ad4;
}
},latchToolbarItem:function(){
this._domNode.disabled=false;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarLatchedItemStyle);
},enableToolbarItem:function(){
this._domNode.disabled=false;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarEnabledItemStyle);
},disableToolbarItem:function(){
this._domNode.disabled=true;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarDisabledItemStyle);
},highlightToolbarItem:function(){
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarHighlightedItemStyle);
},unhighlightToolbarItem:function(){
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarHighlightedItemStyle);
},removeToolbarItemStyle:function(){
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarEnabledItemStyle);
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarLatchedItemStyle);
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarDisabledItemStyle);
this.unhighlightToolbarItem();
}});
dojo.declare("dojo.widget.Editor2ToolbarDropDownButton",dojo.widget.Editor2ToolbarButton,{onClick:function(){
if(this._domNode){
if(!this._dropdown){
this._dropdown=dojo.widget.createWidget("PopupContainer",{});
this._domNode.appendChild(this._dropdown.domNode);
}
if(this._dropdown.isShowingNow){
this._dropdown.close();
}else{
this.onDropDownShown();
this._dropdown.open(this._domNode,null,this._domNode);
}
}
},destroy:function(){
this.onDropDownDestroy();
if(this._dropdown){
this._dropdown.destroy();
}
dojo.widget.Editor2ToolbarDropDownButton.superclass.destroy.call(this);
},onDropDownShown:function(){
},onDropDownDestroy:function(){
}});
dojo.declare("dojo.widget.Editor2ToolbarColorPaletteButton",dojo.widget.Editor2ToolbarDropDownButton,{onDropDownShown:function(){
if(!this._colorpalette){
this._colorpalette=dojo.widget.createWidget("ColorPalette",{});
this._dropdown.addChild(this._colorpalette);
this.disableSelection(this._dropdown.domNode);
this.disableSelection(this._colorpalette.domNode);
dojo.event.connect(this._colorpalette,"onColorSelect",this,"setColor");
dojo.event.connect(this._dropdown,"open",this,"latchToolbarItem");
dojo.event.connect(this._dropdown,"close",this,"enableToolbarItem");
}
},setColor:function(_ad5){
this._dropdown.close();
this._command.execute(_ad5);
}});
dojo.declare("dojo.widget.Editor2ToolbarFormatBlockPlainSelect",dojo.widget.Editor2ToolbarButton,{create:function(node,_ad7){
this._domNode=node;
this.disableSelection(this._domNode);
this._parentToolbar=_ad7;
dojo.event.connect(this._domNode,"onchange",this,"onChange");
},destroy:function(){
this._domNode=null;
this._command=null;
this._parentToolbar=null;
},onChange:function(){
if(this._domNode){
var sv=this._domNode.value.toLowerCase();
this._command.execute(sv);
}
},refreshState:function(){
if(this._domNode&&this._command){
dojo.widget.Editor2ToolbarFormatBlockPlainSelect.superclass.refreshState.call(this);
var _ad9=this._command.getValue();
if(!_ad9){
_ad9="";
}
dojo.lang.forEach(this._domNode.options,function(item){
if(item.value.toLowerCase()==_ad9.toLowerCase()){
item.selected=true;
}
});
}
}});
dojo.declare("dojo.widget.Editor2ToolbarComboItem",dojo.widget.Editor2ToolbarDropDownButton,{href:null,create:function(node,_adc){
dojo.widget.Editor2ToolbarComboItem.superclass.create.call(this,node,_adc);
if(!this._contentPane){
dojo.require("dojo.widget.ContentPane");
this._contentPane=dojo.widget.createWidget("ContentPane",{preload:"true"});
this._contentPane.addOnLoad(this,"setup");
this._contentPane.setUrl(this.href);
}
},onMouseOver:function(e){
dojo.html.addClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectStyle);
},onMouseOut:function(e){
dojo.html.removeClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectStyle);
},onDropDownShown:function(){
if(!this._dropdown.__addedContentPage){
this._dropdown.addChild(this._contentPane);
this._dropdown.__addedContentPage=true;
}
},setup:function(){
},onChange:function(e){
var name=e.currentTarget.getAttribute("dropDownItemName");
this._command.execute(name);
this._dropdown.close();
},onMouseOverItem:function(e){
dojo.html.addClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectItemStyle);
},onMouseOutItem:function(e){
dojo.html.removeClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectItemStyle);
},refreshState:function(){
}});
dojo.declare("dojo.widget.Editor2ToolbarFormatBlockSelect",dojo.widget.Editor2ToolbarComboItem,{href:dojo.uri.dojoUri("src/widget/templates/Editor2/EditorToolbar_FormatBlock.html"),setup:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.setup.call(this);
var _ae3=this._contentPane.domNode.all||this._contentPane.domNode.getElementsByTagName("*");
this._blockNames={};
this._blockDisplayNames={};
for(var x=0;x<_ae3.length;x++){
var node=_ae3[x];
dojo.html.disableSelection(node);
var name=node.getAttribute("dropDownItemName");
if(name){
this._blockNames[name]=node;
var _ae7=node.getElementsByTagName(name);
this._blockDisplayNames[name]=_ae7[_ae7.length-1].innerHTML;
}
}
for(var name in this._blockNames){
dojo.event.connect(this._blockNames[name],"onclick",this,"onChange");
dojo.event.connect(this._blockNames[name],"onmouseover",this,"onMouseOverItem");
dojo.event.connect(this._blockNames[name],"onmouseout",this,"onMouseOutItem");
}
},onDropDownDestroy:function(){
if(this._blockNames){
for(var name in this._blockNames){
delete this._blockNames[name];
delete this._blockDisplayNames[name];
}
}
},refreshState:function(){
if(this._command){
var _ae9=this._command.getValue();
if(_ae9==this._lastSelectedFormat&&this._blockDisplayNames){
return;
}
this._lastSelectedFormat=_ae9;
var _aea=this._domNode.getElementsByTagName("label")[0];
var _aeb=false;
if(this._blockDisplayNames){
for(var name in this._blockDisplayNames){
if(name==_ae9){
_aea.innerHTML=this._blockDisplayNames[name];
_aeb=true;
break;
}
}
if(!_aeb){
_aea.innerHTML="&nbsp;";
}
}
}
}});
dojo.declare("dojo.widget.Editor2ToolbarFontSizeSelect",dojo.widget.Editor2ToolbarComboItem,{href:dojo.uri.dojoUri("src/widget/templates/Editor2/EditorToolbar_FontSize.html"),setup:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.setup.call(this);
var _aed=this._contentPane.domNode.all||this._contentPane.domNode.getElementsByTagName("*");
this._fontsizes={};
this._fontSizeDisplayNames={};
for(var x=0;x<_aed.length;x++){
var node=_aed[x];
dojo.html.disableSelection(node);
var name=node.getAttribute("dropDownItemName");
if(name){
this._fontsizes[name]=node;
this._fontSizeDisplayNames[name]=node.getElementsByTagName("font")[0].innerHTML;
}
}
for(var name in this._fontsizes){
dojo.event.connect(this._fontsizes[name],"onclick",this,"onChange");
dojo.event.connect(this._fontsizes[name],"onmouseover",this,"onMouseOverItem");
dojo.event.connect(this._fontsizes[name],"onmouseout",this,"onMouseOutItem");
}
},onDropDownDestroy:function(){
if(this._fontsizes){
for(var name in this._fontsizes){
delete this._fontsizes[name];
delete this._fontSizeDisplayNames[name];
}
}
},refreshState:function(){
if(this._command){
var size=this._command.getValue();
if(size==this._lastSelectedSize&&this._fontSizeDisplayNames){
return;
}
this._lastSelectedSize=size;
var _af3=this._domNode.getElementsByTagName("label")[0];
var _af4=false;
if(this._fontSizeDisplayNames){
for(var name in this._fontSizeDisplayNames){
if(name==size){
_af3.innerHTML=this._fontSizeDisplayNames[name];
_af4=true;
break;
}
}
if(!_af4){
_af3.innerHTML="&nbsp;";
}
}
}
}});
dojo.declare("dojo.widget.Editor2ToolbarFontNameSelect",dojo.widget.Editor2ToolbarFontSizeSelect,{href:dojo.uri.dojoUri("src/widget/templates/Editor2/EditorToolbar_FontName.html")});
dojo.widget.defineWidget("dojo.widget.Editor2Toolbar",dojo.widget.HtmlWidget,{templatePath:dojo.uri.dojoUri("src/widget/templates/EditorToolbar.html"),templateCssPath:dojo.uri.dojoUri("src/widget/templates/EditorToolbar.css"),ToolbarLatchedItemStyle:"ToolbarButtonLatched",ToolbarEnabledItemStyle:"ToolbarButtonEnabled",ToolbarDisabledItemStyle:"ToolbarButtonDisabled",ToolbarHighlightedItemStyle:"ToolbarButtonHighlighted",ToolbarHighlightedSelectStyle:"ToolbarSelectHighlighted",ToolbarHighlightedSelectItemStyle:"ToolbarSelectHighlightedItem",postCreate:function(){
var _af6=dojo.html.getElementsByClass("dojoEditorToolbarItem",this.domNode);
this.items={};
for(var x=0;x<_af6.length;x++){
var node=_af6[x];
var _af9=node.getAttribute("dojoETItemName");
if(_af9){
var item=dojo.widget.Editor2ToolbarItemManager.getToolbarItem(_af9);
if(item){
item.create(node,this);
this.items[_af9.toLowerCase()]=item;
}else{
node.style.display="none";
}
}
}
},update:function(){
for(var cmd in this.items){
this.items[cmd].refreshState();
}
},destroy:function(){
for(var it in this.items){
this.items[it].destroy();
delete this.items[it];
}
dojo.widget.Editor2Toolbar.superclass.destroy.call(this);
}},"html",function(){
dojo.event.connect(this,"fillInTemplate",dojo.lang.hitch(this,function(){
if(dojo.render.html.ie){
this.domNode.style.zoom=1;
}
}));
});
dojo.provide("dojo.lfx.shadow");
dojo.lfx.shadow=function(node){
this.shadowPng=dojo.uri.dojoUri("src/html/images/shadow");
this.shadowThickness=8;
this.shadowOffset=15;
this.init(node);
};
dojo.extend(dojo.lfx.shadow,{init:function(node){
this.node=node;
this.pieces={};
var x1=-1*this.shadowThickness;
var y0=this.shadowOffset;
var y1=this.shadowOffset+this.shadowThickness;
this._makePiece("tl","top",y0,"left",x1);
this._makePiece("l","top",y1,"left",x1,"scale");
this._makePiece("tr","top",y0,"left",0);
this._makePiece("r","top",y1,"left",0,"scale");
this._makePiece("bl","top",0,"left",x1);
this._makePiece("b","top",0,"left",0,"crop");
this._makePiece("br","top",0,"left",0);
},_makePiece:function(name,_b03,_b04,_b05,_b06,_b07){
var img;
var url=this.shadowPng+name.toUpperCase()+".png";
if(dojo.render.html.ie55||dojo.render.html.ie60){
img=dojo.doc().createElement("div");
img.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+url+"'"+(_b07?", sizingMethod='"+_b07+"'":"")+")";
}else{
img=dojo.doc().createElement("img");
img.src=url;
}
img.style.position="absolute";
img.style[_b03]=_b04+"px";
img.style[_b05]=_b06+"px";
img.style.width=this.shadowThickness+"px";
img.style.height=this.shadowThickness+"px";
this.pieces[name]=img;
this.node.appendChild(img);
},size:function(_b0a,_b0b){
var _b0c=_b0b-(this.shadowOffset+this.shadowThickness+1);
if(_b0c<0){
_b0c=0;
}
if(_b0b<1){
_b0b=1;
}
if(_b0a<1){
_b0a=1;
}
with(this.pieces){
l.style.height=_b0c+"px";
r.style.height=_b0c+"px";
b.style.width=(_b0a-1)+"px";
bl.style.top=(_b0b-1)+"px";
b.style.top=(_b0b-1)+"px";
br.style.top=(_b0b-1)+"px";
tr.style.left=(_b0a-1)+"px";
r.style.left=(_b0a-1)+"px";
br.style.left=(_b0a-1)+"px";
}
}});
dojo.provide("dojo.widget.html.layout");
dojo.widget.html.layout=function(_b0d,_b0e,_b0f){
dojo.html.addClass(_b0d,"dojoLayoutContainer");
_b0e=dojo.lang.filter(_b0e,function(_b10,idx){
_b10.idx=idx;
return dojo.lang.inArray(["top","bottom","left","right","client","flood"],_b10.layoutAlign);
});
if(_b0f&&_b0f!="none"){
var rank=function(_b13){
switch(_b13.layoutAlign){
case "flood":
return 1;
case "left":
case "right":
return (_b0f=="left-right")?2:3;
case "top":
case "bottom":
return (_b0f=="left-right")?3:2;
default:
return 4;
}
};
_b0e.sort(function(a,b){
return (rank(a)-rank(b))||(a.idx-b.idx);
});
}
var f={top:dojo.html.getPixelValue(_b0d,"padding-top",true),left:dojo.html.getPixelValue(_b0d,"padding-left",true)};
dojo.lang.mixin(f,dojo.html.getContentBox(_b0d));
dojo.lang.forEach(_b0e,function(_b17){
var elm=_b17.domNode;
var pos=_b17.layoutAlign;
with(elm.style){
left=f.left+"px";
top=f.top+"px";
bottom="auto";
right="auto";
}
dojo.html.addClass(elm,"dojoAlign"+dojo.string.capitalize(pos));
if((pos=="top")||(pos=="bottom")){
dojo.html.setMarginBox(elm,{width:f.width});
var h=dojo.html.getMarginBox(elm).height;
f.height-=h;
if(pos=="top"){
f.top+=h;
}else{
elm.style.top=f.top+f.height+"px";
}
}else{
if(pos=="left"||pos=="right"){
var w=dojo.html.getMarginBox(elm).width;
dojo.html.setMarginBox(elm,{width:w,height:f.height});
f.width-=w;
if(pos=="left"){
f.left+=w;
}else{
elm.style.left=f.left+f.width+"px";
}
}else{
if(pos=="flood"||pos=="client"){
dojo.html.setMarginBox(elm,{width:f.width,height:f.height});
}
}
}
if(_b17.onResized){
_b17.onResized();
}
});
};
dojo.html.insertCssText(".dojoLayoutContainer{ position: relative; display: block; }\n"+"body .dojoAlignTop, body .dojoAlignBottom, body .dojoAlignLeft, body .dojoAlignRight { position: absolute; overflow: hidden; }\n"+"body .dojoAlignClient { position: absolute }\n"+".dojoAlignClient { overflow: auto; }\n");
dojo.provide("dojo.dnd.DragAndDrop");
dojo.declare("dojo.dnd.DragSource",null,{type:"",onDragEnd:function(){
},onDragStart:function(){
},onSelected:function(){
},unregister:function(){
dojo.dnd.dragManager.unregisterDragSource(this);
},reregister:function(){
dojo.dnd.dragManager.registerDragSource(this);
}},function(){
var dm=dojo.dnd.dragManager;
if(dm["registerDragSource"]){
dm.registerDragSource(this);
}
});
dojo.declare("dojo.dnd.DragObject",null,{type:"",onDragStart:function(){
},onDragMove:function(){
},onDragOver:function(){
},onDragOut:function(){
},onDragEnd:function(){
},onDragLeave:this.onDragOut,onDragEnter:this.onDragOver,ondragout:this.onDragOut,ondragover:this.onDragOver},function(){
var dm=dojo.dnd.dragManager;
if(dm["registerDragObject"]){
dm.registerDragObject(this);
}
});
dojo.declare("dojo.dnd.DropTarget",null,{acceptsType:function(type){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
if(!dojo.lang.inArray(this.acceptedTypes,type)){
return false;
}
}
return true;
},accepts:function(_b1f){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
for(var i=0;i<_b1f.length;i++){
if(!dojo.lang.inArray(this.acceptedTypes,_b1f[i].type)){
return false;
}
}
}
return true;
},unregister:function(){
dojo.dnd.dragManager.unregisterDropTarget(this);
},onDragOver:function(){
},onDragOut:function(){
},onDragMove:function(){
},onDropStart:function(){
},onDrop:function(){
},onDropEnd:function(){
}},function(){
if(this.constructor==dojo.dnd.DropTarget){
return;
}
this.acceptedTypes=[];
dojo.dnd.dragManager.registerDropTarget(this);
});
dojo.dnd.DragEvent=function(){
this.dragSource=null;
this.dragObject=null;
this.target=null;
this.eventStatus="success";
};
dojo.declare("dojo.dnd.DragManager",null,{selectedSources:[],dragObjects:[],dragSources:[],registerDragSource:function(){
},dropTargets:[],registerDropTarget:function(){
},lastDragTarget:null,currentDragTarget:null,onKeyDown:function(){
},onMouseOut:function(){
},onMouseMove:function(){
},onMouseUp:function(){
}});
dojo.provide("dojo.dnd.HtmlDragManager");
dojo.declare("dojo.dnd.HtmlDragManager",dojo.dnd.DragManager,{disabled:false,nestedTargets:false,mouseDownTimer:null,dsCounter:0,dsPrefix:"dojoDragSource",dropTargetDimensions:[],currentDropTarget:null,previousDropTarget:null,_dragTriggered:false,selectedSources:[],dragObjects:[],currentX:null,currentY:null,lastX:null,lastY:null,mouseDownX:null,mouseDownY:null,threshold:7,dropAcceptable:false,cancelEvent:function(e){
e.stopPropagation();
e.preventDefault();
},registerDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _b24=dp+"Idx_"+(this.dsCounter++);
ds.dragSourceId=_b24;
this.dragSources[_b24]=ds;
ds.domNode.setAttribute(dp,_b24);
if(dojo.render.html.ie){
dojo.event.browser.addListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},unregisterDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _b27=ds.dragSourceId;
delete ds.dragSourceId;
delete this.dragSources[_b27];
ds.domNode.setAttribute(dp,null);
if(dojo.render.html.ie){
dojo.event.browser.removeListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},registerDropTarget:function(dt){
this.dropTargets.push(dt);
},unregisterDropTarget:function(dt){
var _b2a=dojo.lang.find(this.dropTargets,dt,true);
if(_b2a>=0){
this.dropTargets.splice(_b2a,1);
}
},getDragSource:function(e){
var tn=e.target;
if(tn===dojo.body()){
return;
}
var ta=dojo.html.getAttribute(tn,this.dsPrefix);
while((!ta)&&(tn)){
tn=tn.parentNode;
if((!tn)||(tn===dojo.body())){
return;
}
ta=dojo.html.getAttribute(tn,this.dsPrefix);
}
return this.dragSources[ta];
},onKeyDown:function(e){
},onMouseDown:function(e){
if(this.disabled){
return;
}
if(dojo.render.html.ie){
if(e.button!=1){
return;
}
}else{
if(e.which!=1){
return;
}
}
var _b30=e.target.nodeType==dojo.html.TEXT_NODE?e.target.parentNode:e.target;
if(dojo.html.isTag(_b30,"button","textarea","input","select","option")){
return;
}
var ds=this.getDragSource(e);
if(!ds){
return;
}
if(!dojo.lang.inArray(this.selectedSources,ds)){
this.selectedSources.push(ds);
ds.onSelected();
}
this.mouseDownX=e.pageX;
this.mouseDownY=e.pageY;
e.preventDefault();
dojo.event.connect(document,"onmousemove",this,"onMouseMove");
},onMouseUp:function(e,_b33){
if(this.selectedSources.length==0){
return;
}
this.mouseDownX=null;
this.mouseDownY=null;
this._dragTriggered=false;
e.dragSource=this.dragSource;
if((!e.shiftKey)&&(!e.ctrlKey)){
if(this.currentDropTarget){
this.currentDropTarget.onDropStart();
}
dojo.lang.forEach(this.dragObjects,function(_b34){
var ret=null;
if(!_b34){
return;
}
if(this.currentDropTarget){
e.dragObject=_b34;
var ce=this.currentDropTarget.domNode.childNodes;
if(ce.length>0){
e.dropTarget=ce[0];
while(e.dropTarget==_b34.domNode){
e.dropTarget=e.dropTarget.nextSibling;
}
}else{
e.dropTarget=this.currentDropTarget.domNode;
}
if(this.dropAcceptable){
ret=this.currentDropTarget.onDrop(e);
}else{
this.currentDropTarget.onDragOut(e);
}
}
e.dragStatus=this.dropAcceptable&&ret?"dropSuccess":"dropFailure";
dojo.lang.delayThese([function(){
try{
_b34.dragSource.onDragEnd(e);
}
catch(err){
var _b37={};
for(var i in e){
if(i=="type"){
_b37.type="mouseup";
continue;
}
_b37[i]=e[i];
}
_b34.dragSource.onDragEnd(_b37);
}
},function(){
_b34.onDragEnd(e);
}]);
},this);
this.selectedSources=[];
this.dragObjects=[];
this.dragSource=null;
if(this.currentDropTarget){
this.currentDropTarget.onDropEnd();
}
}else{
}
dojo.event.disconnect(document,"onmousemove",this,"onMouseMove");
this.currentDropTarget=null;
},onScroll:function(){
for(var i=0;i<this.dragObjects.length;i++){
if(this.dragObjects[i].updateDragOffset){
this.dragObjects[i].updateDragOffset();
}
}
if(this.dragObjects.length){
this.cacheTargetLocations();
}
},_dragStartDistance:function(x,y){
if((!this.mouseDownX)||(!this.mouseDownX)){
return;
}
var dx=Math.abs(x-this.mouseDownX);
var dx2=dx*dx;
var dy=Math.abs(y-this.mouseDownY);
var dy2=dy*dy;
return parseInt(Math.sqrt(dx2+dy2),10);
},cacheTargetLocations:function(){
dojo.profile.start("cacheTargetLocations");
this.dropTargetDimensions=[];
dojo.lang.forEach(this.dropTargets,function(_b40){
var tn=_b40.domNode;
if(!tn||dojo.lang.find(_b40.acceptedTypes,this.dragSource.type)<0){
return;
}
var abs=dojo.html.getAbsolutePosition(tn,true);
var bb=dojo.html.getBorderBox(tn);
this.dropTargetDimensions.push([[abs.x,abs.y],[abs.x+bb.width,abs.y+bb.height],_b40]);
},this);
dojo.profile.end("cacheTargetLocations");
},onMouseMove:function(e){
if((dojo.render.html.ie)&&(e.button!=1)){
this.currentDropTarget=null;
this.onMouseUp(e,true);
return;
}
if((this.selectedSources.length)&&(!this.dragObjects.length)){
var dx;
var dy;
if(!this._dragTriggered){
this._dragTriggered=(this._dragStartDistance(e.pageX,e.pageY)>this.threshold);
if(!this._dragTriggered){
return;
}
dx=e.pageX-this.mouseDownX;
dy=e.pageY-this.mouseDownY;
}
this.dragSource=this.selectedSources[0];
dojo.lang.forEach(this.selectedSources,function(_b47){
if(!_b47){
return;
}
var tdo=_b47.onDragStart(e);
if(tdo){
tdo.onDragStart(e);
tdo.dragOffset.y+=dy;
tdo.dragOffset.x+=dx;
tdo.dragSource=_b47;
this.dragObjects.push(tdo);
}
},this);
this.previousDropTarget=null;
this.cacheTargetLocations();
}
dojo.lang.forEach(this.dragObjects,function(_b49){
if(_b49){
_b49.onDragMove(e);
}
});
if(this.currentDropTarget){
var c=dojo.html.toCoordinateObject(this.currentDropTarget.domNode,true);
var dtp=[[c.x,c.y],[c.x+c.width,c.y+c.height]];
}
if((!this.nestedTargets)&&(dtp)&&(this.isInsideBox(e,dtp))){
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}else{
var _b4c=this.findBestTarget(e);
if(_b4c.target===null){
if(this.currentDropTarget){
this.currentDropTarget.onDragOut(e);
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget=null;
}
this.dropAcceptable=false;
return;
}
if(this.currentDropTarget!==_b4c.target){
if(this.currentDropTarget){
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget.onDragOut(e);
}
this.currentDropTarget=_b4c.target;
e.dragObjects=this.dragObjects;
this.dropAcceptable=this.currentDropTarget.onDragOver(e);
}else{
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}
}
},findBestTarget:function(e){
var _b4e=this;
var _b4f=new Object();
_b4f.target=null;
_b4f.points=null;
dojo.lang.every(this.dropTargetDimensions,function(_b50){
if(!_b4e.isInsideBox(e,_b50)){
return true;
}
_b4f.target=_b50[2];
_b4f.points=_b50;
return Boolean(_b4e.nestedTargets);
});
return _b4f;
},isInsideBox:function(e,_b52){
if((e.pageX>_b52[0][0])&&(e.pageX<_b52[1][0])&&(e.pageY>_b52[0][1])&&(e.pageY<_b52[1][1])){
return true;
}
return false;
},onMouseOver:function(e){
},onMouseOut:function(e){
}});
dojo.dnd.dragManager=new dojo.dnd.HtmlDragManager();
(function(){
var d=document;
var dm=dojo.dnd.dragManager;
dojo.event.connect(d,"onkeydown",dm,"onKeyDown");
dojo.event.connect(d,"onmouseover",dm,"onMouseOver");
dojo.event.connect(d,"onmouseout",dm,"onMouseOut");
dojo.event.connect(d,"onmousedown",dm,"onMouseDown");
dojo.event.connect(d,"onmouseup",dm,"onMouseUp");
dojo.event.connect(window,"onscroll",dm,"onScroll");
})();
dojo.provide("dojo.dnd.HtmlDragAndDrop");
dojo.declare("dojo.dnd.HtmlDragSource",dojo.dnd.DragSource,{dragClass:"",onDragStart:function(){
var _b57=new dojo.dnd.HtmlDragObject(this.dragObject,this.type);
if(this.dragClass){
_b57.dragClass=this.dragClass;
}
if(this.constrainToContainer){
_b57.constrainTo(this.constrainingContainer||this.domNode.parentNode);
}
return _b57;
},setDragHandle:function(node){
node=dojo.byId(node);
dojo.dnd.dragManager.unregisterDragSource(this);
this.domNode=node;
dojo.dnd.dragManager.registerDragSource(this);
},setDragTarget:function(node){
this.dragObject=node;
},constrainTo:function(_b5a){
this.constrainToContainer=true;
if(_b5a){
this.constrainingContainer=_b5a;
}
},onSelected:function(){
for(var i=0;i<this.dragObjects.length;i++){
dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragSource(this.dragObjects[i]));
}
},addDragObjects:function(el){
for(var i=0;i<arguments.length;i++){
this.dragObjects.push(arguments[i]);
}
}},function(node,type){
node=dojo.byId(node);
this.dragObjects=[];
this.constrainToContainer=false;
if(node){
this.domNode=node;
this.dragObject=node;
dojo.dnd.DragSource.call(this);
this.type=(type)||(this.domNode.nodeName.toLowerCase());
}
});
dojo.declare("dojo.dnd.HtmlDragObject",dojo.dnd.DragObject,{dragClass:"",opacity:0.5,createIframe:true,disableX:false,disableY:false,createDragNode:function(){
var node=this.domNode.cloneNode(true);
if(this.dragClass){
dojo.html.addClass(node,this.dragClass);
}
if(this.opacity<1){
dojo.html.setOpacity(node,this.opacity);
}
if(node.tagName.toLowerCase()=="tr"){
var doc=this.domNode.ownerDocument;
var _b62=doc.createElement("table");
var _b63=doc.createElement("tbody");
_b62.appendChild(_b63);
_b63.appendChild(node);
var _b64=this.domNode.childNodes;
var _b65=node.childNodes;
for(var i=0;i<_b64.length;i++){
if((_b65[i])&&(_b65[i].style)){
_b65[i].style.width=dojo.html.getContentBox(_b64[i]).width+"px";
}
}
node=_b62;
}
if((dojo.render.html.ie55||dojo.render.html.ie60)&&this.createIframe){
with(node.style){
top="0px";
left="0px";
}
var _b67=document.createElement("div");
_b67.appendChild(node);
this.bgIframe=new dojo.html.BackgroundIframe(_b67);
_b67.appendChild(this.bgIframe.iframe);
node=_b67;
}
node.style.zIndex=999;
return node;
},onDragStart:function(e){
dojo.html.clearSelection();
this.scrollOffset=dojo.html.getScroll().offset;
this.dragStartPosition=dojo.html.getAbsolutePosition(this.domNode,true);
this.dragOffset={y:this.dragStartPosition.y-e.pageY,x:this.dragStartPosition.x-e.pageX};
this.dragClone=this.createDragNode();
this.containingBlockPosition=this.domNode.offsetParent?dojo.html.getAbsolutePosition(this.domNode.offsetParent,true):{x:0,y:0};
if(this.constrainToContainer){
this.constraints=this.getConstraints();
}
with(this.dragClone.style){
position="absolute";
top=this.dragOffset.y+e.pageY+"px";
left=this.dragOffset.x+e.pageX+"px";
}
dojo.body().appendChild(this.dragClone);
dojo.event.connect(this.domNode,"onclick",this,"squelchOnClick");
dojo.event.topic.publish("dragStart",{source:this});
},getConstraints:function(){
if(this.constrainingContainer.nodeName.toLowerCase()=="body"){
var _b69=dojo.html.getViewport();
var _b6a=_b69.width;
var _b6b=_b69.height;
var x=0;
var y=0;
}else{
var _b6e=dojo.html.getContentBox(this.constrainingContainer);
_b6a=_b6e.width;
_b6b=_b6e.height;
x=this.containingBlockPosition.x+dojo.html.getPixelValue(this.constrainingContainer,"padding-left",true)+dojo.html.getBorderExtent(this.constrainingContainer,"left");
y=this.containingBlockPosition.y+dojo.html.getPixelValue(this.constrainingContainer,"padding-top",true)+dojo.html.getBorderExtent(this.constrainingContainer,"top");
}
var mb=dojo.html.getMarginBox(this.domNode);
return {minX:x,minY:y,maxX:x+_b6a-mb.width,maxY:y+_b6b-mb.height};
},updateDragOffset:function(){
var _b70=dojo.html.getScroll().offset;
if(_b70.y!=this.scrollOffset.y){
var diff=_b70.y-this.scrollOffset.y;
this.dragOffset.y+=diff;
this.scrollOffset.y=_b70.y;
}
if(_b70.x!=this.scrollOffset.x){
var diff=_b70.x-this.scrollOffset.x;
this.dragOffset.x+=diff;
this.scrollOffset.x=_b70.x;
}
},onDragMove:function(e){
this.updateDragOffset();
var x=this.dragOffset.x+e.pageX;
var y=this.dragOffset.y+e.pageY;
if(this.constrainToContainer){
if(x<this.constraints.minX){
x=this.constraints.minX;
}
if(y<this.constraints.minY){
y=this.constraints.minY;
}
if(x>this.constraints.maxX){
x=this.constraints.maxX;
}
if(y>this.constraints.maxY){
y=this.constraints.maxY;
}
}
this.setAbsolutePosition(x,y);
dojo.event.topic.publish("dragMove",{source:this});
},setAbsolutePosition:function(x,y){
if(!this.disableY){
this.dragClone.style.top=y+"px";
}
if(!this.disableX){
this.dragClone.style.left=x+"px";
}
},onDragEnd:function(e){
switch(e.dragStatus){
case "dropSuccess":
dojo.html.removeNode(this.dragClone);
this.dragClone=null;
break;
case "dropFailure":
var _b78=dojo.html.getAbsolutePosition(this.dragClone,true);
var _b79={left:this.dragStartPosition.x+1,top:this.dragStartPosition.y+1};
var anim=dojo.lfx.slideTo(this.dragClone,_b79,500,dojo.lfx.easeOut);
var _b7b=this;
dojo.event.connect(anim,"onEnd",function(e){
dojo.lang.setTimeout(function(){
dojo.html.removeNode(_b7b.dragClone);
_b7b.dragClone=null;
},200);
});
anim.play();
break;
}
dojo.event.topic.publish("dragEnd",{source:this});
},squelchOnClick:function(e){
dojo.event.browser.stopEvent(e);
dojo.lang.setTimeout(function(){
dojo.event.disconnect(this.domNode,"onclick",this,"squelchOnClick");
},50);
},constrainTo:function(_b7e){
this.constrainToContainer=true;
if(_b7e){
this.constrainingContainer=_b7e;
}else{
this.constrainingContainer=this.domNode.parentNode;
}
}},function(node,type){
this.domNode=dojo.byId(node);
this.type=type;
this.constrainToContainer=false;
this.dragSource=null;
});
dojo.declare("dojo.dnd.HtmlDropTarget",dojo.dnd.DropTarget,{vertical:false,onDragOver:function(e){
if(!this.accepts(e.dragObjects)){
return false;
}
this.childBoxes=[];
for(var i=0,_b83;i<this.domNode.childNodes.length;i++){
_b83=this.domNode.childNodes[i];
if(_b83.nodeType!=dojo.html.ELEMENT_NODE){
continue;
}
var pos=dojo.html.getAbsolutePosition(_b83,true);
var _b85=dojo.html.getBorderBox(_b83);
this.childBoxes.push({top:pos.y,bottom:pos.y+_b85.height,left:pos.x,right:pos.x+_b85.width,height:_b85.height,width:_b85.width,node:_b83});
}
return true;
},_getNodeUnderMouse:function(e){
for(var i=0,_b88;i<this.childBoxes.length;i++){
with(this.childBoxes[i]){
if(e.pageX>=left&&e.pageX<=right&&e.pageY>=top&&e.pageY<=bottom){
return i;
}
}
}
return -1;
},createDropIndicator:function(){
this.dropIndicator=document.createElement("div");
with(this.dropIndicator.style){
position="absolute";
zIndex=999;
if(this.vertical){
borderLeftWidth="1px";
borderLeftColor="black";
borderLeftStyle="solid";
height=dojo.html.getBorderBox(this.domNode).height+"px";
top=dojo.html.getAbsolutePosition(this.domNode,true).y+"px";
}else{
borderTopWidth="1px";
borderTopColor="black";
borderTopStyle="solid";
width=dojo.html.getBorderBox(this.domNode).width+"px";
left=dojo.html.getAbsolutePosition(this.domNode,true).x+"px";
}
}
},onDragMove:function(e,_b8a){
var i=this._getNodeUnderMouse(e);
if(!this.dropIndicator){
this.createDropIndicator();
}
var _b8c=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
var hide=false;
if(i<0){
if(this.childBoxes.length){
var _b8e=(dojo.html.gravity(this.childBoxes[0].node,e)&_b8c);
if(_b8e){
hide=true;
}
}else{
var _b8e=true;
}
}else{
var _b8f=this.childBoxes[i];
var _b8e=(dojo.html.gravity(_b8f.node,e)&_b8c);
if(_b8f.node===_b8a[0].dragSource.domNode){
hide=true;
}else{
var _b90=_b8e?(i>0?this.childBoxes[i-1]:_b8f):(i<this.childBoxes.length-1?this.childBoxes[i+1]:_b8f);
if(_b90.node===_b8a[0].dragSource.domNode){
hide=true;
}
}
}
if(hide){
this.dropIndicator.style.display="none";
return;
}else{
this.dropIndicator.style.display="";
}
this.placeIndicator(e,_b8a,i,_b8e);
if(!dojo.html.hasParent(this.dropIndicator)){
dojo.body().appendChild(this.dropIndicator);
}
},placeIndicator:function(e,_b92,_b93,_b94){
var _b95=this.vertical?"left":"top";
var _b96;
if(_b93<0){
if(this.childBoxes.length){
_b96=_b94?this.childBoxes[0]:this.childBoxes[this.childBoxes.length-1];
}else{
this.dropIndicator.style[_b95]=dojo.html.getAbsolutePosition(this.domNode,true)[this.vertical?"x":"y"]+"px";
}
}else{
_b96=this.childBoxes[_b93];
}
if(_b96){
this.dropIndicator.style[_b95]=(_b94?_b96[_b95]:_b96[this.vertical?"right":"bottom"])+"px";
if(this.vertical){
this.dropIndicator.style.height=_b96.height+"px";
this.dropIndicator.style.top=_b96.top+"px";
}else{
this.dropIndicator.style.width=_b96.width+"px";
this.dropIndicator.style.left=_b96.left+"px";
}
}
},onDragOut:function(e){
if(this.dropIndicator){
dojo.html.removeNode(this.dropIndicator);
delete this.dropIndicator;
}
},onDrop:function(e){
this.onDragOut(e);
var i=this._getNodeUnderMouse(e);
var _b9a=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
if(i<0){
if(this.childBoxes.length){
if(dojo.html.gravity(this.childBoxes[0].node,e)&_b9a){
return this.insert(e,this.childBoxes[0].node,"before");
}else{
return this.insert(e,this.childBoxes[this.childBoxes.length-1].node,"after");
}
}
return this.insert(e,this.domNode,"append");
}
var _b9b=this.childBoxes[i];
if(dojo.html.gravity(_b9b.node,e)&_b9a){
return this.insert(e,_b9b.node,"before");
}else{
return this.insert(e,_b9b.node,"after");
}
},insert:function(e,_b9d,_b9e){
var node=e.dragObject.domNode;
if(_b9e=="before"){
return dojo.html.insertBefore(node,_b9d);
}else{
if(_b9e=="after"){
return dojo.html.insertAfter(node,_b9d);
}else{
if(_b9e=="append"){
_b9d.appendChild(node);
return true;
}
}
}
return false;
}},function(node,_ba1){
if(arguments.length==0){
return;
}
this.domNode=dojo.byId(node);
dojo.dnd.DropTarget.call(this);
if(_ba1&&dojo.lang.isString(_ba1)){
_ba1=[_ba1];
}
this.acceptedTypes=_ba1||[];
});
dojo.provide("dojo.dnd.*");
dojo.provide("dojo.dnd.HtmlDragMove");
dojo.declare("dojo.dnd.HtmlDragMoveSource",dojo.dnd.HtmlDragSource,{onDragStart:function(){
var _ba2=new dojo.dnd.HtmlDragMoveObject(this.dragObject,this.type);
if(this.constrainToContainer){
_ba2.constrainTo(this.constrainingContainer);
}
return _ba2;
},onSelected:function(){
for(var i=0;i<this.dragObjects.length;i++){
dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragMoveSource(this.dragObjects[i]));
}
}});
dojo.declare("dojo.dnd.HtmlDragMoveObject",dojo.dnd.HtmlDragObject,{onDragEnd:function(e){
dojo.event.connect(this.domNode,"onclick",this,"squelchOnClick");
},onDragStart:function(e){
dojo.html.clearSelection();
this.dragClone=this.domNode;
this.scrollOffset=dojo.html.getScroll().offset;
this.dragStartPosition=dojo.html.abs(this.domNode,true);
this.dragOffset={y:this.dragStartPosition.y-e.pageY,x:this.dragStartPosition.x-e.pageX};
this.containingBlockPosition=this.domNode.offsetParent?dojo.html.abs(this.domNode.offsetParent,true):{x:0,y:0};
this.dragClone.style.position="absolute";
if(this.constrainToContainer){
this.constraints=this.getConstraints();
}
},setAbsolutePosition:function(x,y){
if(!this.disableY){
this.domNode.style.top=(y-this.containingBlockPosition.y)+"px";
}
if(!this.disableX){
this.domNode.style.left=(x-this.containingBlockPosition.x)+"px";
}
}});
dojo.provide("dojo.widget.Dialog");
dojo.declare("dojo.widget.ModalDialogBase",null,{isContainer:true,shared:{bg:null,bgIframe:null},focusElement:"",bgColor:"black",bgOpacity:0.4,followScroll:true,trapTabs:function(e){
if(e.target==this.tabStartOuter){
if(this._fromTrap){
this.tabStart.focus();
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabEnd.focus();
}
}else{
if(e.target==this.tabStart){
if(this._fromTrap){
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabEnd.focus();
}
}else{
if(e.target==this.tabEndOuter){
if(this._fromTrap){
this.tabEnd.focus();
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabStart.focus();
}
}else{
if(e.target==this.tabEnd){
if(this._fromTrap){
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabStart.focus();
}
}
}
}
}
},clearTrap:function(e){
var _baa=this;
setTimeout(function(){
_baa._fromTrap=false;
},100);
},postCreate:function(){
with(this.domNode.style){
position="absolute";
zIndex=999;
display="none";
overflow="visible";
}
var b=dojo.body();
b.appendChild(this.domNode);
if(!this.shared.bg){
this.shared.bg=document.createElement("div");
this.shared.bg.className="dialogUnderlay";
with(this.shared.bg.style){
position="absolute";
left=top="0px";
zIndex=998;
display="none";
}
this.setBackgroundColor(this.bgColor);
b.appendChild(this.shared.bg);
this.shared.bgIframe=new dojo.html.BackgroundIframe(this.shared.bg);
}
},setBackgroundColor:function(_bac){
if(arguments.length>=3){
_bac=new dojo.gfx.color.Color(arguments[0],arguments[1],arguments[2]);
}else{
_bac=new dojo.gfx.color.Color(_bac);
}
this.shared.bg.style.backgroundColor=_bac.toString();
return this.bgColor=_bac;
},setBackgroundOpacity:function(op){
if(arguments.length==0){
op=this.bgOpacity;
}
dojo.html.setOpacity(this.shared.bg,op);
try{
this.bgOpacity=dojo.html.getOpacity(this.shared.bg);
}
catch(e){
this.bgOpacity=op;
}
return this.bgOpacity;
},_sizeBackground:function(){
if(this.bgOpacity>0){
var _bae=dojo.html.getViewport();
var h=_bae.height;
var w=_bae.width;
with(this.shared.bg.style){
width=w+"px";
height=h+"px";
}
var _bb1=dojo.html.getScroll().offset;
this.shared.bg.style.top=_bb1.y+"px";
this.shared.bg.style.left=_bb1.x+"px";
var _bae=dojo.html.getViewport();
if(_bae.width!=w){
this.shared.bg.style.width=_bae.width+"px";
}
if(_bae.height!=h){
this.shared.bg.style.height=_bae.height+"px";
}
}
},_showBackground:function(){
if(this.bgOpacity>0){
this.shared.bg.style.display="block";
}
},placeModalDialog:function(){
var _bb2=dojo.html.getScroll().offset;
var _bb3=dojo.html.getViewport();
var mb=dojo.html.getMarginBox(this.containerNode);
var x=_bb2.x+(_bb3.width-mb.width)/2;
var y=_bb2.y+(_bb3.height-mb.height)/2;
with(this.domNode.style){
left=x+"px";
top=y+"px";
}
},showModalDialog:function(){
if(this.followScroll&&!this._scrollConnected){
this._scrollConnected=true;
dojo.event.connect(window,"onscroll",this,"_onScroll");
}
this.setBackgroundOpacity();
this._sizeBackground();
this._showBackground();
},hideModalDialog:function(){
if(this.focusElement){
dojo.byId(this.focusElement).focus();
dojo.byId(this.focusElement).blur();
}
this.shared.bg.style.display="none";
this.shared.bg.style.width=this.shared.bg.style.height="1px";
if(this._scrollConnected){
this._scrollConnected=false;
dojo.event.disconnect(window,"onscroll",this,"_onScroll");
}
},_onScroll:function(){
var _bb7=dojo.html.getScroll().offset;
this.shared.bg.style.top=_bb7.y+"px";
this.shared.bg.style.left=_bb7.x+"px";
this.placeModalDialog();
},checkSize:function(){
if(this.isShowing()){
this._sizeBackground();
this.placeModalDialog();
this.onResized();
}
}});
dojo.widget.defineWidget("dojo.widget.Dialog",[dojo.widget.ContentPane,dojo.widget.ModalDialogBase],{templatePath:dojo.uri.dojoUri("src/widget/templates/Dialog.html"),blockDuration:0,lifetime:0,show:function(){
if(this.lifetime){
this.timeRemaining=this.lifetime;
if(!this.blockDuration){
dojo.event.connect(this.shared.bg,"onclick",this,"hide");
}else{
dojo.event.disconnect(this.shared.bg,"onclick",this,"hide");
}
if(this.timerNode){
this.timerNode.innerHTML=Math.ceil(this.timeRemaining/1000);
}
if(this.blockDuration&&this.closeNode){
if(this.lifetime>this.blockDuration){
this.closeNode.style.visibility="hidden";
}else{
this.closeNode.style.display="none";
}
}
this.timer=setInterval(dojo.lang.hitch(this,"_onTick"),100);
}
this.showModalDialog();
dojo.widget.Dialog.superclass.show.call(this);
},onLoad:function(){
this.placeModalDialog();
dojo.widget.Dialog.superclass.onLoad.call(this);
},fillInTemplate:function(){
},hide:function(){
this.hideModalDialog();
dojo.widget.Dialog.superclass.hide.call(this);
if(this.timer){
clearInterval(this.timer);
}
},setTimerNode:function(node){
this.timerNode=node;
},setCloseControl:function(node){
this.closeNode=node;
dojo.event.connect(node,"onclick",this,"hide");
},setShowControl:function(node){
dojo.event.connect(node,"onclick",this,"show");
},_onTick:function(){
if(this.timer){
this.timeRemaining-=100;
if(this.lifetime-this.timeRemaining>=this.blockDuration){
dojo.event.connect(this.shared.bg,"onclick",this,"hide");
if(this.closeNode){
this.closeNode.style.visibility="visible";
}
}
if(!this.timeRemaining){
clearInterval(this.timer);
this.hide();
}else{
if(this.timerNode){
this.timerNode.innerHTML=Math.ceil(this.timeRemaining/1000);
}
}
}
}});
dojo.provide("dojo.widget.ResizeHandle");
dojo.widget.defineWidget("dojo.widget.ResizeHandle",dojo.widget.HtmlWidget,{isSizing:false,startPoint:null,startSize:null,minSize:null,targetElmId:"",templateCssPath:dojo.uri.dojoUri("src/widget/templates/ResizeHandle.css"),templateString:"<div class=\"dojoHtmlResizeHandle\"><div></div></div>",postCreate:function(){
dojo.event.connect(this.domNode,"onmousedown",this,"beginSizing");
},beginSizing:function(e){
if(this.isSizing){
return false;
}
this.targetWidget=dojo.widget.byId(this.targetElmId);
this.targetDomNode=this.targetWidget?this.targetWidget.domNode:dojo.byId(this.targetElmId);
if(!this.targetDomNode){
return;
}
this.isSizing=true;
this.startPoint={"x":e.clientX,"y":e.clientY};
var mb=dojo.html.getMarginBox(this.targetDomNode);
this.startSize={"w":mb.width,"h":mb.height};
dojo.event.kwConnect({srcObj:dojo.body(),srcFunc:"onmousemove",targetObj:this,targetFunc:"changeSizing",rate:25});
dojo.event.connect(dojo.body(),"onmouseup",this,"endSizing");
e.preventDefault();
},changeSizing:function(e){
try{
if(!e.clientX||!e.clientY){
return;
}
}
catch(e){
return;
}
var dx=this.startPoint.x-e.clientX;
var dy=this.startPoint.y-e.clientY;
var newW=this.startSize.w-dx;
var newH=this.startSize.h-dy;
if(this.minSize){
var mb=dojo.html.getMarginBox(this.targetDomNode);
if(newW<this.minSize.w){
newW=mb.width;
}
if(newH<this.minSize.h){
newH=mb.height;
}
}
if(this.targetWidget){
this.targetWidget.resizeTo(newW,newH);
}else{
dojo.html.setMarginBox(this.targetDomNode,{width:newW,height:newH});
}
e.preventDefault();
},endSizing:function(e){
dojo.event.disconnect(dojo.body(),"onmousemove",this,"changeSizing");
dojo.event.disconnect(dojo.body(),"onmouseup",this,"endSizing");
this.isSizing=false;
}});
dojo.provide("dojo.widget.FloatingPane");
dojo.declare("dojo.widget.FloatingPaneBase",null,{title:"",iconSrc:"",hasShadow:false,constrainToContainer:false,taskBarId:"",resizable:true,titleBarDisplay:true,windowState:"normal",displayCloseAction:false,displayMinimizeAction:false,displayMaximizeAction:false,_max_taskBarConnectAttempts:5,_taskBarConnectAttempts:0,templatePath:dojo.uri.dojoUri("src/widget/templates/FloatingPane.html"),templateCssPath:dojo.uri.dojoUri("src/widget/templates/FloatingPane.css"),fillInFloatingPaneTemplate:function(args,frag){
var _bc6=this.getFragNodeRef(frag);
dojo.html.copyStyle(this.domNode,_bc6);
dojo.body().appendChild(this.domNode);
if(!this.isShowing()){
this.windowState="minimized";
}
if(this.iconSrc==""){
dojo.html.removeNode(this.titleBarIcon);
}else{
this.titleBarIcon.src=this.iconSrc.toString();
}
if(this.titleBarDisplay){
this.titleBar.style.display="";
dojo.html.disableSelection(this.titleBar);
this.titleBarIcon.style.display=(this.iconSrc==""?"none":"");
this.minimizeAction.style.display=(this.displayMinimizeAction?"":"none");
this.maximizeAction.style.display=(this.displayMaximizeAction&&this.windowState!="maximized"?"":"none");
this.restoreAction.style.display=(this.displayMaximizeAction&&this.windowState=="maximized"?"":"none");
this.closeAction.style.display=(this.displayCloseAction?"":"none");
this.drag=new dojo.dnd.HtmlDragMoveSource(this.domNode);
if(this.constrainToContainer){
this.drag.constrainTo();
}
this.drag.setDragHandle(this.titleBar);
var self=this;
dojo.event.topic.subscribe("dragMove",function(info){
if(info.source.domNode==self.domNode){
dojo.event.topic.publish("floatingPaneMove",{source:self});
}
});
}
if(this.resizable){
this.resizeBar.style.display="";
this.resizeHandle=dojo.widget.createWidget("ResizeHandle",{targetElmId:this.widgetId,id:this.widgetId+"_resize"});
this.resizeBar.appendChild(this.resizeHandle.domNode);
}
if(this.hasShadow){
this.shadow=new dojo.lfx.shadow(this.domNode);
}
this.bgIframe=new dojo.html.BackgroundIframe(this.domNode);
if(this.taskBarId){
this._taskBarSetup();
}
dojo.body().removeChild(this.domNode);
},postCreate:function(){
if(dojo.hostenv.post_load_){
this._setInitialWindowState();
}else{
dojo.addOnLoad(this,"_setInitialWindowState");
}
},maximizeWindow:function(evt){
var mb=dojo.html.getMarginBox(this.domNode);
this.previous={width:mb.width||this.width,height:mb.height||this.height,left:this.domNode.style.left,top:this.domNode.style.top,bottom:this.domNode.style.bottom,right:this.domNode.style.right};
if(this.domNode.parentNode.style.overflow.toLowerCase()!="hidden"){
this.parentPrevious={overflow:this.domNode.parentNode.style.overflow};
dojo.debug(this.domNode.parentNode.style.overflow);
this.domNode.parentNode.style.overflow="hidden";
}
this.domNode.style.left=dojo.html.getPixelValue(this.domNode.parentNode,"padding-left",true)+"px";
this.domNode.style.top=dojo.html.getPixelValue(this.domNode.parentNode,"padding-top",true)+"px";
if((this.domNode.parentNode.nodeName.toLowerCase()=="body")){
var _bcb=dojo.html.getViewport();
var _bcc=dojo.html.getPadding(dojo.body());
this.resizeTo(_bcb.width-_bcc.width,_bcb.height-_bcc.height);
}else{
var _bcd=dojo.html.getContentBox(this.domNode.parentNode);
this.resizeTo(_bcd.width,_bcd.height);
}
this.maximizeAction.style.display="none";
this.restoreAction.style.display="";
if(this.resizeHandle){
this.resizeHandle.domNode.style.display="none";
}
this.drag.setDragHandle(null);
this.windowState="maximized";
},minimizeWindow:function(evt){
this.hide();
for(var attr in this.parentPrevious){
this.domNode.parentNode.style[attr]=this.parentPrevious[attr];
}
this.lastWindowState=this.windowState;
this.windowState="minimized";
},restoreWindow:function(evt){
if(this.windowState=="minimized"){
this.show();
if(this.lastWindowState=="maximized"){
this.domNode.parentNode.style.overflow="hidden";
this.windowState="maximized";
}else{
this.windowState="normal";
}
}else{
if(this.windowState=="maximized"){
for(var attr in this.previous){
this.domNode.style[attr]=this.previous[attr];
}
for(var attr in this.parentPrevious){
this.domNode.parentNode.style[attr]=this.parentPrevious[attr];
}
this.resizeTo(this.previous.width,this.previous.height);
this.previous=null;
this.parentPrevious=null;
this.restoreAction.style.display="none";
this.maximizeAction.style.display=this.displayMaximizeAction?"":"none";
if(this.resizeHandle){
this.resizeHandle.domNode.style.display="";
}
this.drag.setDragHandle(this.titleBar);
this.windowState="normal";
}else{
}
}
},toggleDisplay:function(){
if(this.windowState=="minimized"){
this.restoreWindow();
}else{
this.minimizeWindow();
}
},closeWindow:function(evt){
dojo.html.removeNode(this.domNode);
this.destroy();
},onMouseDown:function(evt){
this.bringToTop();
},bringToTop:function(){
var _bd4=dojo.widget.manager.getWidgetsByType(this.widgetType);
var _bd5=[];
for(var x=0;x<_bd4.length;x++){
if(this.widgetId!=_bd4[x].widgetId){
_bd5.push(_bd4[x]);
}
}
_bd5.sort(function(a,b){
return a.domNode.style.zIndex-b.domNode.style.zIndex;
});
_bd5.push(this);
var _bd9=100;
for(x=0;x<_bd5.length;x++){
_bd5[x].domNode.style.zIndex=_bd9+x*2;
}
},_setInitialWindowState:function(){
if(this.isShowing()){
this.width=-1;
var mb=dojo.html.getMarginBox(this.domNode);
this.resizeTo(mb.width,mb.height);
}
if(this.windowState=="maximized"){
this.maximizeWindow();
this.show();
return;
}
if(this.windowState=="normal"){
this.show();
return;
}
if(this.windowState=="minimized"){
this.hide();
return;
}
this.windowState="minimized";
},_taskBarSetup:function(){
var _bdb=dojo.widget.getWidgetById(this.taskBarId);
if(!_bdb){
if(this._taskBarConnectAttempts<this._max_taskBarConnectAttempts){
dojo.lang.setTimeout(this,this._taskBarSetup,50);
this._taskBarConnectAttempts++;
}else{
dojo.debug("Unable to connect to the taskBar");
}
return;
}
_bdb.addChild(this);
},showFloatingPane:function(){
this.bringToTop();
},onFloatingPaneShow:function(){
var mb=dojo.html.getMarginBox(this.domNode);
this.resizeTo(mb.width,mb.height);
},resizeTo:function(_bdd,_bde){
dojo.html.setMarginBox(this.domNode,{width:_bdd,height:_bde});
dojo.widget.html.layout(this.domNode,[{domNode:this.titleBar,layoutAlign:"top"},{domNode:this.resizeBar,layoutAlign:"bottom"},{domNode:this.containerNode,layoutAlign:"client"}]);
dojo.widget.html.layout(this.containerNode,this.children,"top-bottom");
this.bgIframe.onResized();
if(this.shadow){
this.shadow.size(_bdd,_bde);
}
this.onResized();
},checkSize:function(){
}});
dojo.widget.defineWidget("dojo.widget.FloatingPane",[dojo.widget.ContentPane,dojo.widget.FloatingPaneBase],{fillInTemplate:function(args,frag){
this.fillInFloatingPaneTemplate(args,frag);
dojo.widget.FloatingPane.superclass.fillInTemplate.call(this,args,frag);
},postCreate:function(){
dojo.widget.FloatingPaneBase.prototype.postCreate.apply(this,arguments);
dojo.widget.FloatingPane.superclass.postCreate.apply(this,arguments);
},show:function(){
dojo.widget.FloatingPane.superclass.show.apply(this,arguments);
this.showFloatingPane();
},onShow:function(){
dojo.widget.FloatingPane.superclass.onShow.call(this);
this.onFloatingPaneShow();
}});
dojo.widget.defineWidget("dojo.widget.ModalFloatingPane",[dojo.widget.FloatingPane,dojo.widget.ModalDialogBase],{windowState:"minimized",displayCloseAction:true,postCreate:function(){
dojo.widget.ModalDialogBase.prototype.postCreate.call(this);
dojo.widget.ModalFloatingPane.superclass.postCreate.call(this);
},show:function(){
dojo.widget.ModalFloatingPane.superclass.show.apply(this,arguments);
this.showModalDialog();
this.placeModalDialog();
this.shared.bg.style.zIndex=this.domNode.style.zIndex-1;
},hide:function(){
this.hideModalDialog();
dojo.widget.ModalFloatingPane.superclass.hide.apply(this,arguments);
},closeWindow:function(){
this.hide();
dojo.widget.ModalFloatingPane.superclass.closeWindow.apply(this,arguments);
}});
dojo.provide("dojo.widget.Editor2Plugin.AlwaysShowToolbar");
dojo.event.topic.subscribe("dojo.widget.Editor2::onLoad",function(_be1){
if(_be1.toolbarAlwaysVisible){
var p=new dojo.widget.Editor2Plugin.AlwaysShowToolbar(_be1);
}
});
dojo.declare("dojo.widget.Editor2Plugin.AlwaysShowToolbar",null,function(_be3){
this.editor=_be3;
this.editor.registerLoadedPlugin(this);
this.setup();
},{_scrollSetUp:false,_fixEnabled:false,_scrollThreshold:false,_handleScroll:true,setup:function(){
var tdn=this.editor.toolbarWidget;
if(!tdn.tbBgIframe){
tdn.tbBgIframe=new dojo.html.BackgroundIframe(tdn.domNode);
tdn.tbBgIframe.onResized();
}
this.scrollInterval=setInterval(dojo.lang.hitch(this,"globalOnScrollHandler"),100);
dojo.event.connect("before",this.editor.toolbarWidget,"destroy",this,"destroy");
},globalOnScrollHandler:function(){
var isIE=dojo.render.html.ie;
if(!this._handleScroll){
return;
}
var dh=dojo.html;
var tdn=this.editor.toolbarWidget.domNode;
var db=dojo.body();
if(!this._scrollSetUp){
this._scrollSetUp=true;
var _be9=dh.getMarginBox(this.editor.domNode).width;
this._scrollThreshold=dh.abs(tdn,true).y;
if((isIE)&&(db)&&(dh.getStyle(db,"background-image")=="none")){
with(db.style){
backgroundImage="url("+dojo.uri.dojoUri("src/widget/templates/images/blank.gif")+")";
backgroundAttachment="fixed";
}
}
}
var _bea=(window["pageYOffset"])?window["pageYOffset"]:(document["documentElement"]||document["body"]).scrollTop;
if(_bea>this._scrollThreshold){
if(!this._fixEnabled){
var _beb=dojo.html.getMarginBox(tdn);
this.editor.editorObject.style.marginTop=_beb.height+"px";
if(isIE){
tdn.style.left=dojo.html.abs(tdn,dojo.html.boxSizing.MARGIN_BOX).x;
dojo.body().appendChild(tdn);
dojo.html.addClass(tdn,"IEFixedToolbar");
}else{
with(tdn.style){
position="fixed";
top="0px";
}
}
tdn.style.width=_beb.width+"px";
tdn.style.zIndex=1000;
this._fixEnabled=true;
}
if(!dojo.render.html.safari){
var _bec=(this.height)?parseInt(this.editor.height):this.editor._lastHeight;
if(_bea>(this._scrollThreshold+_bec)){
tdn.style.display="none";
}else{
tdn.style.display="";
}
}
}else{
if(this._fixEnabled){
(this.editor.object||this.editor.iframe).style.marginTop=null;
with(tdn.style){
position="";
top="";
zIndex="";
display="";
}
if(isIE){
tdn.style.left="";
dojo.html.removeClass(tdn,"IEFixedToolbar");
dojo.html.insertBefore(tdn,this.editor.object||this.editor.iframe);
}
tdn.style.width="";
this._fixEnabled=false;
}
}
},destroy:function(){
this._handleScroll=false;
clearInterval(this.scrollInterval);
this.editor.unregisterLoadedPlugin(this);
if(dojo.render.html.ie){
dojo.html.removeClass(this.editor.toolbarWidget.domNode,"IEFixedToolbar");
}
}});
dojo.provide("dojo.widget.Editor2");
dojo.widget.Editor2Manager={_currentInstance:null,_loadedCommands:{},commandState:{Disabled:0,Latched:1,Enabled:2},getCurrentInstance:function(){
return this._currentInstance;
},setCurrentInstance:function(inst){
this._currentInstance=inst;
},registerCommand:function(name,cmd){
name=name.toLowerCase();
if(this._loadedCommands[name]){
delete this._loadedCommands[name];
}
this._loadedCommands[name]=cmd;
},getCommand:function(name){
name=name.toLowerCase();
var _bf1=this._loadedCommands[name];
if(_bf1){
return _bf1;
}
switch(name){
case "htmltoggle":
_bf1=new dojo.widget.Editor2BrowserCommand(name);
break;
case "formatblock":
_bf1=new dojo.widget.Editor2FormatBlockCommand(name);
break;
case "anchor":
_bf1=new dojo.widget.Editor2Command(name);
break;
case "createlink":
_bf1=new dojo.widget.Editor2DialogCommand(name,{contentFile:"dojo.widget.Editor2Plugin.CreateLinkDialog",contentClass:"Editor2CreateLinkDialog",title:"Insert/Edit Link",width:"300px",height:"200px"});
break;
case "insertimage":
_bf1=new dojo.widget.Editor2DialogCommand(name,{contentFile:"dojo.widget.Editor2Plugin.InsertImageDialog",contentClass:"Editor2InsertImageDialog",title:"Insert/Edit Image",width:"400px",height:"270px"});
break;
default:
var _bf2=this.getCurrentInstance();
if((_bf2&&_bf2.queryCommandAvailable(name))||(!_bf2&&dojo.widget.Editor2.prototype.queryCommandAvailable(name))){
_bf1=new dojo.widget.Editor2BrowserCommand(name);
}else{
dojo.debug("dojo.widget.Editor2Manager.getCommand: Unknown command "+name);
return;
}
}
this._loadedCommands[name]=_bf1;
return _bf1;
},destroy:function(){
this._currentInstance=null;
for(var cmd in this._loadedCommands){
this._loadedCommands[cmd].destory();
}
}};
dojo.addOnUnload(dojo.widget.Editor2Manager,"destroy");
dojo.lang.declare("dojo.widget.Editor2Command",null,{initializer:function(name){
this._name=name;
},execute:function(para){
dojo.unimplemented("dojo.widget.Editor2Command.execute");
},getState:function(){
return dojo.widget.Editor2Manager.commandState.Enabled;
},destory:function(){
}});
dojo.lang.declare("dojo.widget.Editor2BrowserCommand",dojo.widget.Editor2Command,{execute:function(para){
var _bf7=dojo.widget.Editor2Manager.getCurrentInstance();
if(_bf7){
_bf7.execCommand(this._name,para);
}
},getState:function(){
var _bf8=dojo.widget.Editor2Manager.getCurrentInstance();
if(_bf8){
try{
if(_bf8.queryCommandEnabled(this._name)){
if(_bf8.queryCommandState(this._name)){
return dojo.widget.Editor2Manager.commandState.Latched;
}else{
return dojo.widget.Editor2Manager.commandState.Enabled;
}
}else{
return dojo.widget.Editor2Manager.commandState.Disabled;
}
}
catch(e){
return dojo.widget.Editor2Manager.commandState.Enabled;
}
}
return dojo.widget.Editor2Manager.commandState.Disabled;
},getValue:function(){
var _bf9=dojo.widget.Editor2Manager.getCurrentInstance();
if(_bf9){
try{
return _bf9.queryCommandValue(this._name);
}
catch(e){
}
}
}});
dojo.lang.declare("dojo.widget.Editor2FormatBlockCommand",dojo.widget.Editor2BrowserCommand,{});
dojo.widget.defineWidget("dojo.widget.Editor2Dialog",[dojo.widget.HtmlWidget,dojo.widget.FloatingPaneBase,dojo.widget.ModalDialogBase],{templatePath:dojo.uri.dojoUri("src/widget/templates/Editor2/EditorDialog.html"),modal:true,width:false,height:false,windowState:"minimized",displayCloseAction:true,contentFile:"",contentClass:"",fillInTemplate:function(args,frag){
this.fillInFloatingPaneTemplate(args,frag);
dojo.widget.Editor2Dialog.superclass.fillInTemplate.call(this,args,frag);
},postCreate:function(){
if(this.contentFile){
dojo.require(this.contentFile);
}
if(this.modal){
dojo.widget.ModalDialogBase.prototype.postCreate.call(this);
}else{
with(this.domNode.style){
zIndex=999;
display="none";
}
}
dojo.widget.FloatingPaneBase.prototype.postCreate.apply(this,arguments);
dojo.widget.Editor2Dialog.superclass.postCreate.call(this);
if(this.width&&this.height){
with(this.domNode.style){
width=this.width;
height=this.height;
}
}
},createContent:function(){
if(!this.contentWidget&&this.contentClass){
this.contentWidget=dojo.widget.createWidget(this.contentClass);
this.addChild(this.contentWidget);
}
},show:function(){
if(!this.contentWidget){
dojo.widget.Editor2Dialog.superclass.show.apply(this,arguments);
this.createContent();
dojo.widget.Editor2Dialog.superclass.hide.call(this);
}
if(!this.contentWidget||!this.contentWidget.loadContent()){
return;
}
this.showFloatingPane();
dojo.widget.Editor2Dialog.superclass.show.apply(this,arguments);
if(this.modal){
this.showModalDialog();
}
this.placeModalDialog();
if(this.modal){
this.shared.bg.style.zIndex=this.domNode.style.zIndex-1;
}
},onShow:function(){
dojo.widget.Editor2Dialog.superclass.onShow.call(this);
this.onFloatingPaneShow();
},closeWindow:function(){
this.hide();
dojo.widget.Editor2Dialog.superclass.closeWindow.apply(this,arguments);
},hide:function(){
if(this.modal){
this.hideModalDialog();
}
dojo.widget.Editor2Dialog.superclass.hide.call(this);
}});
dojo.widget.defineWidget("dojo.widget.Editor2DialogContent",dojo.widget.HtmlWidget,{widgetsInTemplate:true,loadContent:function(){
return true;
},cancel:function(){
this.parent.hide();
}});
dojo.lang.declare("dojo.widget.Editor2DialogCommand",dojo.widget.Editor2BrowserCommand,function(name,_bfd){
this.dialogParas=_bfd;
},{execute:function(){
if(!this.dialog){
if(!this.dialogParas.contentFile||!this.dialogParas.contentClass){
alert("contentFile and contentClass should be set for dojo.widget.Editor2DialogCommand.dialogParas!");
return;
}
this.dialog=dojo.widget.createWidget("Editor2Dialog",this.dialogParas);
dojo.body().appendChild(this.dialog.domNode);
dojo.event.connect(this,"destroy",this.dialog,"destroy");
}
this.dialog.show();
}});
dojo.widget.defineWidget("dojo.widget.Editor2",dojo.widget.RichText,{shareToolbar:false,toolbarAlwaysVisible:false,toolbarWidget:null,scrollInterval:null,toolbarTemplatePath:dojo.uri.dojoUri("src/widget/templates/EditorToolbarOneline.html"),toolbarTemplateCssPath:null,_inSourceMode:false,_htmlEditNode:null,editorOnLoad:function(){
dojo.event.topic.publish("dojo.widget.Editor2::preLoadingToolbar",this);
if(this.toolbarAlwaysVisible){
dojo.require("dojo.widget.Editor2Plugin.AlwaysShowToolbar");
}
var _bfe=dojo.widget.byType("Editor2Toolbar");
if((!_bfe.length)||(!this.shareToolbar)){
if(this.toolbarWidget){
this.toolbarWidget.show();
dojo.html.insertBefore(this.toolbarWidget.domNode,this.domNode.firstChild);
}else{
var _bff={};
_bff.templatePath=this.toolbarTemplatePath;
if(this.toolbarTemplateCssPath){
_bff.templateCssPath=this.toolbarTemplateCssPath;
}
this.toolbarWidget=dojo.widget.createWidget("Editor2Toolbar",_bff,this.domNode.firstChild,"before");
dojo.event.connect(this,"close",this.toolbarWidget,"hide");
this.toolbarLoaded();
}
}else{
this.toolbarWidget=_bfe[0];
}
dojo.event.topic.registerPublisher("Editor2.clobberFocus",this,"clobberFocus");
dojo.event.topic.subscribe("Editor2.clobberFocus",this,"setBlur");
dojo.event.topic.publish("dojo.widget.Editor2::onLoad",this);
},toolbarLoaded:function(){
},registerLoadedPlugin:function(obj){
if(!this.loadedPlugins){
this.loadedPlugins=[];
}
this.loadedPlugins.push(obj);
},unregisterLoadedPlugin:function(obj){
for(var i in this.loadedPlugins){
if(this.loadedPlugins[i]===obj){
delete this.loadedPlugins[i];
return;
}
}
dojo.debug("dojo.widget.Editor2.unregisterLoadedPlugin: unknow plugin object: "+obj);
},execCommand:function(_c03,_c04){
switch(_c03.toLowerCase()){
case "htmltoggle":
this.toggleHtmlEditing();
break;
default:
dojo.widget.Editor2.superclass.execCommand.apply(this,arguments);
}
},queryCommandEnabled:function(_c05,_c06){
switch(_c05.toLowerCase()){
case "htmltoggle":
return true;
default:
if(this._inSourceMode){
return false;
}
return dojo.widget.Editor2.superclass.queryCommandEnabled.apply(this,arguments);
}
},queryCommandState:function(_c07,_c08){
switch(_c07.toLowerCase()){
case "htmltoggle":
return this._inSourceMode;
default:
return dojo.widget.Editor2.superclass.queryCommandState.apply(this,arguments);
}
},onClick:function(e){
dojo.widget.Editor2.superclass.onClick.call(this,e);
if(dojo.widget.PopupManager){
if(!e){
e=this.window.event;
}
dojo.widget.PopupManager.onClick(e);
}
},clobberFocus:function(){
},toggleHtmlEditing:function(){
if(this===dojo.widget.Editor2Manager.getCurrentInstance()){
if(!this._inSourceMode){
this._inSourceMode=true;
if(!this._htmlEditNode){
this._htmlEditNode=dojo.doc().createElement("textarea");
dojo.html.insertAfter(this._htmlEditNode,this.editorObject);
}
this._htmlEditNode.style.display="";
this._htmlEditNode.style.width="100%";
this._htmlEditNode.style.height=dojo.html.getBorderBox(this.editNode).height+"px";
this._htmlEditNode.value=this.editNode.innerHTML;
with(this.editorObject.style){
position="absolute";
left="-2000px";
top="-2000px";
}
}else{
this._inSourceMode=false;
this._htmlEditNode.blur();
with(this.editorObject.style){
position="";
left="";
top="";
}
dojo.lang.setTimeout(this,"replaceEditorContent",1,this._htmlEditNode.value);
this._htmlEditNode.style.display="none";
this.focus();
}
this.updateToolbar(true);
}
},setFocus:function(){
if(dojo.widget.Editor2Manager.getCurrentInstance()===this){
return;
}
this.clobberFocus();
dojo.widget.Editor2Manager.setCurrentInstance(this);
},setBlur:function(){
},saveSelection:function(){
this._bookmark=null;
this._bookmark=dojo.withGlobal(this.window,dojo.html.selection.getBookmark);
},restoreSelection:function(){
if(this._bookmark){
this.focus();
dojo.withGlobal(this.window,"moveToBookmark",dojo.html.selection,[this._bookmark]);
this._bookmark=null;
}else{
dojo.debug("restoreSelection: no saved selection is found!");
}
},_updateToolbarLastRan:null,_updateToolbarTimer:null,_updateToolbarFrequency:500,updateToolbar:function(_c0a){
if((!this.isLoaded)||(!this.toolbarWidget)){
return;
}
var diff=new Date()-this._updateToolbarLastRan;
if((!_c0a)&&(this._updateToolbarLastRan)&&((diff<this._updateToolbarFrequency))){
clearTimeout(this._updateToolbarTimer);
var _c0c=this;
this._updateToolbarTimer=setTimeout(function(){
_c0c.updateToolbar();
},this._updateToolbarFrequency/2);
return;
}else{
this._updateToolbarLastRan=new Date();
}
if(dojo.widget.Editor2Manager.getCurrentInstance()!==this){
return;
}
this.toolbarWidget.update();
},destroy:function(_c0d){
this._htmlEditNode=null;
dojo.event.disconnect(this,"close",this.toolbarWidget,"hide");
if(!_c0d){
this.toolbarWidget.destroy();
}
dojo.widget.Editor2.superclass.destroy.call(this);
},onDisplayChanged:function(e){
dojo.widget.Editor2.superclass.onDisplayChanged.call(this,e);
this.updateToolbar();
},onLoad:function(){
try{
dojo.widget.Editor2.superclass.onLoad.call(this);
}
catch(e){
dojo.debug(e);
}
this.editorOnLoad();
},onFocus:function(){
dojo.widget.Editor2.superclass.onFocus.call(this);
this.setFocus();
},getEditorContent:function(){
if(this._inSourceMode){
this.replaceEditorContent(this._htmlEditNode.value);
}
return dojo.widget.Editor2.superclass.getEditorContent.call(this);
}},"html");


__CPAN_EDITION__ editor build.txt

Files baked into this package:

dojoGuardStart.js,
../src/bootstrap1.js,
../src/loader.js,
dojoGuardEnd.js,
../src/hostenv_browser.js,
../src/bootstrap2.js,
../src/dom.js,
../src/xml/Parse.js,
../src/lang/common.js,
../src/lang/func.js,
../src/lang/array.js,
../src/lang/extras.js,
../src/lang/declare.js,
../src/ns.js,
../src/event/common.js,
../src/event/topic.js,
../src/event/browser.js,
../src/event/__package__.js,
../src/widget/Manager.js,
../src/uri/Uri.js,
../src/uri/__package__.js,
../src/html/common.js,
../src/a11y.js,
../src/widget/Widget.js,
../src/widget/Parse.js,
../src/string/common.js,
../src/string.js,
../src/io/common.js,
../src/string/extras.js,
../src/undo/browser.js,
../src/io/BrowserIO.js,
../src/io/cookie.js,
../src/io/__package__.js,
../src/html/style.js,
../src/widget/DomWidget.js,
../src/html/display.js,
../src/html/layout.js,
../src/html/util.js,
../src/gfx/color.js,
../src/lfx/Animation.js,
../src/html/color.js,
../src/lfx/html.js,
../src/lfx/__package__.js,
../src/lfx/toggle.js,
../src/widget/HtmlWidget.js,
../src/widget/__package__.js,
../src/widget/Toolbar.js,
../src/html/__package__.js,
../src/widget/RichText.js,
../src/html/selection.js,
../src/widget/ColorPalette.js,
../src/widget/Editor.js,
../src/lang/type.js,
../src/lang/assert.js,
../src/AdapterRegistry.js,
../src/lang/repr.js,
../src/lang/__package__.js,
../src/html/iframe.js,
../src/widget/PopupContainer.js,
../src/widget/ContentPane.js,
../src/widget/Editor2Toolbar.js,
../src/lfx/shadow.js,
../src/widget/html/layout.js,
../src/dnd/DragAndDrop.js,
../src/dnd/HtmlDragManager.js,
../src/dnd/HtmlDragAndDrop.js,
../src/dnd/__package__.js,
../src/dnd/HtmlDragMove.js,
../src/widget/Dialog.js,
../src/widget/ResizeHandle.js,
../src/widget/FloatingPane.js,
../src/widget/Editor2Plugin/AlwaysShowToolbar.js,
../src/widget/Editor2.js

		
__CPAN_EDITION__ event dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:0,flag:"",revision:Number("$Rev: 6258 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
return _6e?_6e.toLowerCase():dojo.locale;
};
dojo.hostenv.searchLocalePath=function(_6f,_70,_71){
_6f=dojo.hostenv.normalizeLocale(_6f);
var _72=_6f.split("-");
var _73=[];
for(var i=_72.length;i>0;i--){
_73.push(_72.slice(0,i).join("-"));
}
_73.push(false);
if(_70){
_73.reverse();
}
for(var j=_73.length-1;j>=0;j--){
var loc=_73[j]||"ROOT";
var _77=_71(loc);
if(_77){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_78){
_78=dojo.hostenv.normalizeLocale(_78);
dojo.hostenv.searchLocalePath(_78,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7b=djConfig.extraLocale||[];
for(var i=0;i<_7b.length;i++){
preload(_7b[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7d,_7e,_7f){
dojo.hostenv.preloadLocalizations();
var _80=[_7d,"nls",_7e].join(".");
var _81=dojo.hostenv.findModule(_80);
if(_81){
if(djConfig.localizationComplete&&_81._built){
return;
}
var _82=dojo.hostenv.normalizeLocale(_7f).replace("-","_");
var _83=_80+"."+_82;
if(dojo.hostenv.findModule(_83)){
return;
}
}
_81=dojo.hostenv.startPackage(_80);
var _84=dojo.hostenv.getModuleSymbols(_7d);
var _85=_84.concat("nls").join("/");
var _86;
dojo.hostenv.searchLocalePath(_7f,false,function(loc){
var _88=loc.replace("-","_");
var _89=_80+"."+_88;
var _8a=false;
if(!dojo.hostenv.findModule(_89)){
dojo.hostenv.startPackage(_89);
var _8b=[_85];
if(loc!="ROOT"){
_8b.push(loc);
}
_8b.push(_7e);
var _8c=_8b.join("/")+".js";
_8a=dojo.hostenv.loadPath(_8c,null,function(_8d){
var _8e=function(){
};
_8e.prototype=_86;
_81[_88]=new _8e();
for(var j in _8d){
_81[_88][j]=_8d[j];
}
});
}else{
_8a=true;
}
if(_8a&&_81[_88]){
_86=_81[_88];
}else{
_81[_88]=_86;
}
});
};
(function(){
var _90=djConfig.extraLocale;
if(_90){
if(!_90 instanceof Array){
_90=[_90];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_94){
req(m,b,_94);
if(_94){
return;
}
for(var i=0;i<_90.length;i++){
req(m,b,_90[i]);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _96=document.location.toString();
var _97=_96.split("?",2);
if(_97.length>1){
var _98=_97[1];
var _99=_98.split("&");
for(var x in _99){
var sp=_99[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _9d=document.getElementsByTagName("script");
var _9e=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_9d.length;i++){
var src=_9d[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_9e);
if(m){
var _a2=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_a2+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_a2;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_a2;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _aa=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_aa>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_aa+6,_aa+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _ac=window["document"];
var tdi=_ac["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b0=null;
var _b1=null;
try{
_b0=new XMLHttpRequest();
}
catch(e){
}
if(!_b0){
for(var i=0;i<3;++i){
var _b3=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b0=new ActiveXObject(_b3);
}
catch(e){
_b1=e;
}
if(_b0){
dojo.hostenv._XMLHTTP_PROGIDS=[_b3];
break;
}
}
}
if(!_b0){
return dojo.raise("XMLHTTP not available",_b1);
}
return _b0;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_b5,_b6){
if(!_b5){
this._blockAsync=true;
}
var _b7=this.getXmlhttpObject();
function isDocumentOk(_b8){
var _b9=_b8["status"];
return Boolean((!_b9)||((200<=_b9)&&(300>_b9))||(_b9==304));
}
if(_b5){
var _ba=this,_bb=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_b7.onreadystatechange=function(){
if(_bb){
gbl.clearTimeout(_bb);
_bb=null;
}
if(_ba._blockAsync||(xhr&&xhr._blockAsync)){
_bb=gbl.setTimeout(function(){
_b7.onreadystatechange.apply(this);
},10);
}else{
if(4==_b7.readyState){
if(isDocumentOk(_b7)){
_b5(_b7.responseText);
}
}
}
};
}
_b7.open("GET",uri,_b5?true:false);
try{
_b7.send(null);
if(_b5){
return null;
}
if(!isDocumentOk(_b7)){
var err=Error("Unable to load "+uri+" status:"+_b7.status);
err.status=_b7.status;
err.responseText=_b7.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_b6)&&(!_b5)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _b7.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_bf){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_bf);
}else{
try{
var _c0=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c0){
_c0=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_bf));
_c0.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_bf+"</div>");
}
catch(e2){
window.status=_bf;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_c2,_c3,fp,_c5){
var _c6=_c2["on"+_c3]||function(){
};
_c2["on"+_c3]=function(){
fp.apply(_c2,arguments);
_c6.apply(_c2,arguments);
};
return true;
}
function dj_load_init(e){
var _c8=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_c8!="domcontentloaded"&&_c8!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _c9=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_c9();
dojo.hostenv.modulesLoaded();
}else{
dojo.addOnLoad(_c9);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _cb=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_cb=_cb.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_cb=_cb.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_cb.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _cc=new dojo.xml.Parse();
if(_cb.length>0){
for(var x=0;x<_cb.length;x++){
var _ce=document.getElementById(_cb[x]);
if(!_ce){
continue;
}
var _cf=_cc.parseElement(_ce,null,true);
dojo.widget.getParser().createComponents(_cf);
}
}else{
if(djConfig.parseWidgets){
var _cf=_cc.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_cf);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_d4,_d5){
dj_currentContext=_d4;
dj_currentDocument=_d5;
};
dojo._fireCallback=function(_d6,_d7,_d8){
if((_d7)&&((typeof _d6=="string")||(_d6 instanceof String))){
_d6=_d7[_d6];
}
return (_d7?_d6.apply(_d7,_d8||[]):_d6());
};
dojo.withGlobal=function(_d9,_da,_db,_dc){
var _dd;
var _de=dj_currentContext;
var _df=dj_currentDocument;
try{
dojo.setContext(_d9,_d9.document);
_dd=dojo._fireCallback(_da,_db,_dc);
}
finally{
dojo.setContext(_de,_df);
}
return _dd;
};
dojo.withDoc=function(_e0,_e1,_e2,_e3){
var _e4;
var _e5=dj_currentDocument;
try{
dj_currentDocument=_e0;
_e4=dojo._fireCallback(_e1,_e2,_e3);
}
finally{
dj_currentDocument=_e5;
}
return _e4;
};
}
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _e6=false;
var _e7=false;
var _e8=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_e6=true;
}else{
if(typeof this["load"]=="function"){
_e7=true;
}else{
if(window.widget){
_e8=true;
}
}
}
var _e9=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_e9.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_e6)&&(!_e8)){
_e9.push("browser_debug.js");
}
var _ea=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_ea=djConfig["baseLoaderUri"];
}
for(var x=0;x<_e9.length;x++){
var _ec=_ea+"src/"+_e9[x];
if(_e6||_e7){
load(_ec);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_ec+"'></scr"+"ipt>");
}
catch(e){
var _ed=document.createElement("script");
_ed.src=_ec;
document.getElementsByTagName("head")[0].appendChild(_ed);
}
}
}
})();
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(typeof _ef!="function"){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
if(!it){
return false;
}
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction()&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.array");
dojo.lang.has=function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
};
dojo.lang.isEmpty=function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _117=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_117++;
break;
}
}
return _117==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
};
dojo.lang.map=function(arr,obj,_11b){
var _11c=dojo.lang.isString(arr);
if(_11c){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_11b)){
_11b=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_11b){
var _11d=obj;
obj=_11b;
_11b=_11d;
}
}
if(Array.map){
var _11e=Array.map(arr,_11b,obj);
}else{
var _11e=[];
for(var i=0;i<arr.length;++i){
_11e.push(_11b.call(obj,arr[i]));
}
}
if(_11c){
return _11e.join("");
}else{
return _11e;
}
};
dojo.lang.reduce=function(arr,_121,obj,_123){
var _124=_121;
var ob=obj?obj:dj_global;
dojo.lang.map(arr,function(val){
_124=_123.call(ob,_124,val);
});
return _124;
};
dojo.lang.forEach=function(_127,_128,_129){
if(dojo.lang.isString(_127)){
_127=_127.split("");
}
if(Array.forEach){
Array.forEach(_127,_128,_129);
}else{
if(!_129){
_129=dj_global;
}
for(var i=0,l=_127.length;i<l;i++){
_128.call(_129,_127[i],i,_127);
}
}
};
dojo.lang._everyOrSome=function(_12c,arr,_12e,_12f){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_12c?"every":"some"](arr,_12e,_12f);
}else{
if(!_12f){
_12f=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _132=_12e.call(_12f,arr[i],i,arr);
if(_12c&&!_132){
return false;
}else{
if((!_12c)&&(_132)){
return true;
}
}
}
return Boolean(_12c);
}
};
dojo.lang.every=function(arr,_134,_135){
return this._everyOrSome(true,arr,_134,_135);
};
dojo.lang.some=function(arr,_137,_138){
return this._everyOrSome(false,arr,_137,_138);
};
dojo.lang.filter=function(arr,_13a,_13b){
var _13c=dojo.lang.isString(arr);
if(_13c){
arr=arr.split("");
}
var _13d;
if(Array.filter){
_13d=Array.filter(arr,_13a,_13b);
}else{
if(!_13b){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_13b=dj_global;
}
_13d=[];
for(var i=0;i<arr.length;i++){
if(_13a.call(_13b,arr[i],i,arr)){
_13d.push(arr[i]);
}
}
}
if(_13c){
return _13d.join("");
}else{
return _13d;
}
};
dojo.lang.unnest=function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
};
dojo.lang.toArray=function(_142,_143){
var _144=[];
for(var i=_143||0;i<_142.length;i++){
_144.push(_142[i]);
}
return _144;
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_147){
var _148=window,_149=2;
if(!dojo.lang.isFunction(func)){
_148=func;
func=_147;
_147=arguments[2];
_149++;
}
if(dojo.lang.isString(func)){
func=_148[func];
}
var args=[];
for(var i=_149;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_148,args);
},_147);
};
dojo.lang.clearTimeout=function(_14c){
dojo.global().clearTimeout(_14c);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_155,_156,_157){
with(dojo.parseObjPath(_155,_156,_157)){
return dojo.evalProp(prop,obj,_157);
}
};
dojo.lang.setObjPathValue=function(_158,_159,_15a,_15b){
if(arguments.length<4){
_15b=true;
}
with(dojo.parseObjPath(_158,_15a,_15b)){
if(obj&&(_15b||(prop in obj))){
obj[prop]=_159;
}
}
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_15c,_15d){
var fcn=(dojo.lang.isString(_15d)?_15c[_15d]:_15d)||function(){
};
return function(){
return fcn.apply(_15c,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_15f,_160,_161){
var nso=(_160||dojo.lang.anon);
if((_161)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_15f){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_15f;
return ret;
};
dojo.lang.forward=function(_165){
return function(){
return this[_165].apply(this,arguments);
};
};
dojo.lang.curry=function(ns,func){
var _168=[];
ns=ns||dj_global;
if(dojo.lang.isString(func)){
func=ns[func];
}
for(var x=2;x<arguments.length;x++){
_168.push(arguments[x]);
}
var _16a=(func["__preJoinArity"]||func.length)-_168.length;
function gather(_16b,_16c,_16d){
var _16e=_16d;
var _16f=_16c.slice(0);
for(var x=0;x<_16b.length;x++){
_16f.push(_16b[x]);
}
_16d=_16d-_16b.length;
if(_16d<=0){
var res=func.apply(ns,_16f);
_16d=_16e;
return res;
}else{
return function(){
return gather(arguments,_16f,_16d);
};
}
}
return gather([],_168,_16a);
};
dojo.lang.curryArguments=function(ns,func,args,_175){
var _176=[];
var x=_175||0;
for(x=_175;x<args.length;x++){
_176.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[ns,func].concat(_176));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_17c,_17d){
if(!farr.length){
if(typeof _17d=="function"){
_17d();
}
return;
}
if((typeof _17c=="undefined")&&(typeof cb=="number")){
_17c=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_17c){
_17c=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_17c,_17d);
},_17c);
};
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_17f){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _182=dl.nameAnonFunc(args[2],ao.adviceObj,_17f);
ao.adviceFunc=_182;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _182=dl.nameAnonFunc(args[0],ao.srcObj,_17f);
ao.srcFunc=_182;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _182=dl.nameAnonFunc(args[1],dj_global,_17f);
ao.srcFunc=_182;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _182=dl.nameAnonFunc(args[3],dj_global,_17f);
ao.adviceObj=dj_global;
ao.adviceFunc=_182;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _182=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_17f);
ao.aroundFunc=_182;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _184={};
for(var x in ao){
_184[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_184.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_184));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _18c;
if((arguments.length==1)&&(typeof a1=="object")){
_18c=a1;
}else{
_18c={srcObj:a1,srcFunc:a2};
}
_18c.adviceFunc=function(){
var _18d=[];
for(var x=0;x<arguments.length;x++){
_18d.push(arguments[x]);
}
dojo.debug("("+_18c.srcObj+")."+_18c.srcFunc,":",_18d.join(", "));
};
this.kwConnect(_18c);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this._kwConnectImpl=function(_194,_195){
var fn=(_195)?"disconnect":"connect";
if(typeof _194["srcFunc"]=="function"){
_194.srcObj=_194["srcObj"]||dj_global;
var _197=dojo.lang.nameAnonFunc(_194.srcFunc,_194.srcObj,true);
_194.srcFunc=_197;
}
if(typeof _194["adviceFunc"]=="function"){
_194.adviceObj=_194["adviceObj"]||dj_global;
var _197=dojo.lang.nameAnonFunc(_194.adviceFunc,_194.adviceObj,true);
_194.adviceFunc=_197;
}
_194.srcObj=_194["srcObj"]||dj_global;
_194.adviceObj=_194["adviceObj"]||_194["targetObj"]||dj_global;
_194.adviceFunc=_194["adviceFunc"]||_194["targetFunc"];
return dojo.event[fn](_194);
};
this.kwConnect=function(_198){
return this._kwConnectImpl(_198,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
return mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
};
this.kwDisconnect=function(_19b){
return this._kwConnectImpl(_19b,true);
};
};
dojo.event.MethodInvocation=function(_19c,obj,args){
this.jp_=_19c;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_1a4){
this.object=obj||dj_global;
this.methodname=_1a4;
this.methodfunc=this.object[_1a4];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_1a6){
if(!obj){
obj=dj_global;
}
if(!obj[_1a6]){
obj[_1a6]=function(){
};
if(!obj[_1a6]){
dojo.raise("Cannot set do-nothing method on that object "+_1a6);
}
}else{
if((!dojo.lang.isFunction(obj[_1a6]))&&(!dojo.lang.isAlien(obj[_1a6]))){
return null;
}
}
var _1a7=_1a6+"$joinpoint";
var _1a8=_1a6+"$joinpoint$method";
var _1a9=obj[_1a7];
if(!_1a9){
var _1aa=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_1aa=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_1a7,_1a8,_1a6]);
}
}
var _1ab=obj[_1a6].length;
obj[_1a8]=obj[_1a6];
_1a9=obj[_1a7]=new dojo.event.MethodJoinPoint(obj,_1a8);
obj[_1a6]=function(){
var args=[];
if((_1aa)&&(!arguments.length)){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(_1aa)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _1a9.run.apply(_1a9,args);
};
obj[_1a6].__preJoinArity=_1ab;
}
return _1a9;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _1b1=[];
for(var x=0;x<args.length;x++){
_1b1[x]=args[x];
}
var _1b3=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _1b5=marr[0]||dj_global;
var _1b6=marr[1];
if(!_1b5[_1b6]){
dojo.raise("function \""+_1b6+"\" does not exist on \""+_1b5+"\"");
}
var _1b7=marr[2]||dj_global;
var _1b8=marr[3];
var msg=marr[6];
var _1ba;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _1b5[_1b6].apply(_1b5,to.args);
}};
to.args=_1b1;
var _1bc=parseInt(marr[4]);
var _1bd=((!isNaN(_1bc))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _1c0=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_1b3(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_1b8){
_1b7[_1b8].call(_1b7,to);
}else{
if((_1bd)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_1b5[_1b6].call(_1b5,to);
}else{
_1b5[_1b6].apply(_1b5,args);
}
},_1bc);
}else{
if(msg){
_1b5[_1b6].call(_1b5,to);
}else{
_1b5[_1b6].apply(_1b5,args);
}
}
}
};
var _1c3=function(){
if(this.squelch){
try{
return _1b3.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _1b3.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_1c3);
}
var _1c4;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_1c4=mi.proceed();
}else{
if(this.methodfunc){
_1c4=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_1c3);
}
return (this.methodfunc)?_1c4:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"]);
},addAdvice:function(_1c9,_1ca,_1cb,_1cc,_1cd,_1ce,once,_1d0,rate,_1d2){
var arr=this.getArr(_1cd);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_1c9,_1ca,_1cb,_1cc,_1d0,rate,_1d2];
if(once){
if(this.hasAdvice(_1c9,_1ca,_1cd,arr)>=0){
return;
}
}
if(_1ce=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_1d5,_1d6,_1d7,arr){
if(!arr){
arr=this.getArr(_1d7);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _1d6=="object")?(new String(_1d6)).toString():_1d6;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_1d5)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_1dd,_1de,_1df,once){
var arr=this.getArr(_1df);
var ind=this.hasAdvice(_1dd,_1de,_1df,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_1dd,_1de,_1df,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_1e3){
if(!this.topics[_1e3]){
this.topics[_1e3]=new this.TopicImpl(_1e3);
}
return this.topics[_1e3];
};
this.registerPublisher=function(_1e4,obj,_1e6){
var _1e4=this.getTopic(_1e4);
_1e4.registerPublisher(obj,_1e6);
};
this.subscribe=function(_1e7,obj,_1e9){
var _1e7=this.getTopic(_1e7);
_1e7.subscribe(obj,_1e9);
};
this.unsubscribe=function(_1ea,obj,_1ec){
var _1ea=this.getTopic(_1ea);
_1ea.unsubscribe(obj,_1ec);
};
this.destroy=function(_1ed){
this.getTopic(_1ed).destroy();
delete this.topics[_1ed];
};
this.publishApply=function(_1ee,args){
var _1ee=this.getTopic(_1ee);
_1ee.sendMessage.apply(_1ee,args);
};
this.publish=function(_1f0,_1f1){
var _1f0=this.getTopic(_1f0);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_1f0.sendMessage.apply(_1f0,args);
};
};
dojo.event.topic.TopicImpl=function(_1f4){
this.topicName=_1f4;
this.subscribe=function(_1f5,_1f6){
var tf=_1f6||_1f5;
var to=(!_1f6)?dj_global:_1f5;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_1f9,_1fa){
var tf=(!_1fa)?_1f9:_1fa;
var to=(!_1fa)?null:_1f9;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_1fd){
this._getJoinPoint().squelch=_1fd;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_1fe,_1ff){
dojo.event.connect(_1fe,_1ff,this,"sendMessage");
};
this.sendMessage=function(_200){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_203){
var na;
var tna;
if(_203){
tna=_203.all||_203.getElementsByTagName("*");
na=[_203];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _207={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _20b=0;
this.normalizedEventName=function(_20c){
switch(_20c){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _20c;
break;
default:
return _20c.toLowerCase();
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_210){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_210.length;x++){
node.__clobberAttrs__.push(_210[x]);
}
};
this.removeListener=function(node,_213,fp,_215){
if(!_215){
var _215=false;
}
_213=dojo.event.browser.normalizedEventName(_213);
if((_213=="onkey")||(_213=="key")){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_215);
}
_213="onkeypress";
}
if(_213.substr(0,2)=="on"){
_213=_213.substr(2);
}
if(node.removeEventListener){
node.removeEventListener(_213,fp,_215);
}
};
this.addListener=function(node,_217,fp,_219,_21a){
if(!node){
return;
}
if(!_219){
var _219=false;
}
_217=dojo.event.browser.normalizedEventName(_217);
if((_217=="onkey")||(_217=="key")){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_219,_21a);
}
_217="onkeypress";
}
if(_217.substr(0,2)!="on"){
_217="on"+_217;
}
if(!_21a){
var _21b=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_219){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_21b=fp;
}
if(node.addEventListener){
node.addEventListener(_217.substr(2),_21b,_219);
return _21b;
}else{
if(typeof node[_217]=="function"){
var _21e=node[_217];
node[_217]=function(e){
_21e(e);
return _21b(e);
};
}else{
node[_217]=_21b;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_217]);
}
return _21b;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_221,_222){
if(typeof _221!="function"){
dojo.raise("listener not a function: "+_221);
}
dojo.event.browser.currentEvent.currentTarget=_222;
return _221.call(_222,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_225){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _227=evt.keyCode;
if(_227>=65&&_227<=90&&evt.shiftKey==false){
_227+=32;
}
if(_227>=1&&_227<=26&&evt.ctrlKey){
_227+=96;
}
evt.key=String.fromCharCode(_227);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _227=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_227+=32;
}
evt.key=String.fromCharCode(_227);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
default:
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_225?_225:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _229=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_229.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_229.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.returnValue=false;
evt.cancelBubble=true;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.provide("dojo.event.*");


__CPAN_EDITION__ event build.txt

Files baked into this package:

dojoGuardStart.js,
../src/bootstrap1.js,
../src/loader.js,
dojoGuardEnd.js,
../src/hostenv_browser.js,
../src/bootstrap2.js,
../src/lang/common.js,
../src/lang/array.js,
../src/lang/extras.js,
../src/lang/func.js,
../src/event/common.js,
../src/event/topic.js,
../src/event/browser.js,
../src/event/__package__.js

		
__CPAN_EDITION__ event_and_io dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:0,flag:"",revision:Number("$Rev: 6258 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
return _6e?_6e.toLowerCase():dojo.locale;
};
dojo.hostenv.searchLocalePath=function(_6f,_70,_71){
_6f=dojo.hostenv.normalizeLocale(_6f);
var _72=_6f.split("-");
var _73=[];
for(var i=_72.length;i>0;i--){
_73.push(_72.slice(0,i).join("-"));
}
_73.push(false);
if(_70){
_73.reverse();
}
for(var j=_73.length-1;j>=0;j--){
var loc=_73[j]||"ROOT";
var _77=_71(loc);
if(_77){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_78){
_78=dojo.hostenv.normalizeLocale(_78);
dojo.hostenv.searchLocalePath(_78,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7b=djConfig.extraLocale||[];
for(var i=0;i<_7b.length;i++){
preload(_7b[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7d,_7e,_7f){
dojo.hostenv.preloadLocalizations();
var _80=[_7d,"nls",_7e].join(".");
var _81=dojo.hostenv.findModule(_80);
if(_81){
if(djConfig.localizationComplete&&_81._built){
return;
}
var _82=dojo.hostenv.normalizeLocale(_7f).replace("-","_");
var _83=_80+"."+_82;
if(dojo.hostenv.findModule(_83)){
return;
}
}
_81=dojo.hostenv.startPackage(_80);
var _84=dojo.hostenv.getModuleSymbols(_7d);
var _85=_84.concat("nls").join("/");
var _86;
dojo.hostenv.searchLocalePath(_7f,false,function(loc){
var _88=loc.replace("-","_");
var _89=_80+"."+_88;
var _8a=false;
if(!dojo.hostenv.findModule(_89)){
dojo.hostenv.startPackage(_89);
var _8b=[_85];
if(loc!="ROOT"){
_8b.push(loc);
}
_8b.push(_7e);
var _8c=_8b.join("/")+".js";
_8a=dojo.hostenv.loadPath(_8c,null,function(_8d){
var _8e=function(){
};
_8e.prototype=_86;
_81[_88]=new _8e();
for(var j in _8d){
_81[_88][j]=_8d[j];
}
});
}else{
_8a=true;
}
if(_8a&&_81[_88]){
_86=_81[_88];
}else{
_81[_88]=_86;
}
});
};
(function(){
var _90=djConfig.extraLocale;
if(_90){
if(!_90 instanceof Array){
_90=[_90];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_94){
req(m,b,_94);
if(_94){
return;
}
for(var i=0;i<_90.length;i++){
req(m,b,_90[i]);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _96=document.location.toString();
var _97=_96.split("?",2);
if(_97.length>1){
var _98=_97[1];
var _99=_98.split("&");
for(var x in _99){
var sp=_99[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _9d=document.getElementsByTagName("script");
var _9e=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_9d.length;i++){
var src=_9d[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_9e);
if(m){
var _a2=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_a2+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_a2;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_a2;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _aa=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_aa>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_aa+6,_aa+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _ac=window["document"];
var tdi=_ac["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b0=null;
var _b1=null;
try{
_b0=new XMLHttpRequest();
}
catch(e){
}
if(!_b0){
for(var i=0;i<3;++i){
var _b3=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b0=new ActiveXObject(_b3);
}
catch(e){
_b1=e;
}
if(_b0){
dojo.hostenv._XMLHTTP_PROGIDS=[_b3];
break;
}
}
}
if(!_b0){
return dojo.raise("XMLHTTP not available",_b1);
}
return _b0;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_b5,_b6){
if(!_b5){
this._blockAsync=true;
}
var _b7=this.getXmlhttpObject();
function isDocumentOk(_b8){
var _b9=_b8["status"];
return Boolean((!_b9)||((200<=_b9)&&(300>_b9))||(_b9==304));
}
if(_b5){
var _ba=this,_bb=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_b7.onreadystatechange=function(){
if(_bb){
gbl.clearTimeout(_bb);
_bb=null;
}
if(_ba._blockAsync||(xhr&&xhr._blockAsync)){
_bb=gbl.setTimeout(function(){
_b7.onreadystatechange.apply(this);
},10);
}else{
if(4==_b7.readyState){
if(isDocumentOk(_b7)){
_b5(_b7.responseText);
}
}
}
};
}
_b7.open("GET",uri,_b5?true:false);
try{
_b7.send(null);
if(_b5){
return null;
}
if(!isDocumentOk(_b7)){
var err=Error("Unable to load "+uri+" status:"+_b7.status);
err.status=_b7.status;
err.responseText=_b7.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_b6)&&(!_b5)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _b7.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_bf){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_bf);
}else{
try{
var _c0=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c0){
_c0=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_bf));
_c0.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_bf+"</div>");
}
catch(e2){
window.status=_bf;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_c2,_c3,fp,_c5){
var _c6=_c2["on"+_c3]||function(){
};
_c2["on"+_c3]=function(){
fp.apply(_c2,arguments);
_c6.apply(_c2,arguments);
};
return true;
}
function dj_load_init(e){
var _c8=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_c8!="domcontentloaded"&&_c8!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _c9=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_c9();
dojo.hostenv.modulesLoaded();
}else{
dojo.addOnLoad(_c9);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _cb=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_cb=_cb.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_cb=_cb.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_cb.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _cc=new dojo.xml.Parse();
if(_cb.length>0){
for(var x=0;x<_cb.length;x++){
var _ce=document.getElementById(_cb[x]);
if(!_ce){
continue;
}
var _cf=_cc.parseElement(_ce,null,true);
dojo.widget.getParser().createComponents(_cf);
}
}else{
if(djConfig.parseWidgets){
var _cf=_cc.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_cf);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_d4,_d5){
dj_currentContext=_d4;
dj_currentDocument=_d5;
};
dojo._fireCallback=function(_d6,_d7,_d8){
if((_d7)&&((typeof _d6=="string")||(_d6 instanceof String))){
_d6=_d7[_d6];
}
return (_d7?_d6.apply(_d7,_d8||[]):_d6());
};
dojo.withGlobal=function(_d9,_da,_db,_dc){
var _dd;
var _de=dj_currentContext;
var _df=dj_currentDocument;
try{
dojo.setContext(_d9,_d9.document);
_dd=dojo._fireCallback(_da,_db,_dc);
}
finally{
dojo.setContext(_de,_df);
}
return _dd;
};
dojo.withDoc=function(_e0,_e1,_e2,_e3){
var _e4;
var _e5=dj_currentDocument;
try{
dj_currentDocument=_e0;
_e4=dojo._fireCallback(_e1,_e2,_e3);
}
finally{
dj_currentDocument=_e5;
}
return _e4;
};
}
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _e6=false;
var _e7=false;
var _e8=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_e6=true;
}else{
if(typeof this["load"]=="function"){
_e7=true;
}else{
if(window.widget){
_e8=true;
}
}
}
var _e9=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_e9.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_e6)&&(!_e8)){
_e9.push("browser_debug.js");
}
var _ea=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_ea=djConfig["baseLoaderUri"];
}
for(var x=0;x<_e9.length;x++){
var _ec=_ea+"src/"+_e9[x];
if(_e6||_e7){
load(_ec);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_ec+"'></scr"+"ipt>");
}
catch(e){
var _ed=document.createElement("script");
_ed.src=_ec;
document.getElementsByTagName("head")[0].appendChild(_ed);
}
}
}
})();
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_f4,_f5){
var out="";
for(var i=0;i<_f4;i++){
out+=str;
if(_f5&&i<_f4-1){
out+=_f5;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_103,_104){
if(typeof _104!="function"){
dojo.raise("dojo.inherits: superclass argument ["+_104+"] must be a function (subclass: ["+_103+"']");
}
_103.prototype=new _104();
_103.prototype.constructor=_103;
_103.superclass=_104.prototype;
_103["super"]=_104.prototype;
};
dojo.lang._mixin=function(obj,_106){
var tobj={};
for(var x in _106){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_106[x])){
obj[x]=_106[x];
}
}
if(dojo.render.html.ie&&(typeof (_106["toString"])=="function")&&(_106["toString"]!=obj["toString"])&&(_106["toString"]!=tobj["toString"])){
obj.toString=_106.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_10a){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_10d,_10e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_10d.prototype,arguments[i]);
}
return _10d;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_111,_112,_113,_114){
if(!dojo.lang.isArrayLike(_111)&&dojo.lang.isArrayLike(_112)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_111;
_111=_112;
_112=temp;
}
var _116=dojo.lang.isString(_111);
if(_116){
_111=_111.split("");
}
if(_114){
var step=-1;
var i=_111.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_111.length;
}
if(_113){
while(i!=end){
if(_111[i]===_112){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_111[i]==_112){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_11a,_11b,_11c){
return dojo.lang.find(_11a,_11b,_11c,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_11d,_11e){
return dojo.lang.find(_11d,_11e)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
if(!it){
return false;
}
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction()&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_129){
var _12a=window,_12b=2;
if(!dojo.lang.isFunction(func)){
_12a=func;
func=_129;
_129=arguments[2];
_12b++;
}
if(dojo.lang.isString(func)){
func=_12a[func];
}
var args=[];
for(var i=_12b;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_12a,args);
},_129);
};
dojo.lang.clearTimeout=function(_12e){
dojo.global().clearTimeout(_12e);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_137,_138,_139){
with(dojo.parseObjPath(_137,_138,_139)){
return dojo.evalProp(prop,obj,_139);
}
};
dojo.lang.setObjPathValue=function(_13a,_13b,_13c,_13d){
if(arguments.length<4){
_13d=true;
}
with(dojo.parseObjPath(_13a,_13c,_13d)){
if(obj&&(_13d||(prop in obj))){
obj[prop]=_13b;
}
}
};
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_13f,_140,_141){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_13f){
this.mimetype=_13f;
}
if(_140){
this.transport=_140;
}
if(arguments.length>=4){
this.changeUrl=_141;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,load:function(type,data,_144,_145){
},error:function(type,_147,_148,_149){
},timeout:function(type,_14b,_14c,_14d){
},handle:function(type,data,_150,_151){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_152){
if(_152["url"]){
_152.url=_152.url.toString();
}
if(_152["formNode"]){
_152.formNode=dojo.byId(_152.formNode);
}
if(!_152["method"]&&_152["formNode"]&&_152["formNode"].method){
_152.method=_152["formNode"].method;
}
if(!_152["handle"]&&_152["handler"]){
_152.handle=_152.handler;
}
if(!_152["load"]&&_152["loaded"]){
_152.load=_152.loaded;
}
if(!_152["changeUrl"]&&_152["changeURL"]){
_152.changeUrl=_152.changeURL;
}
_152.encoding=dojo.lang.firstValued(_152["encoding"],djConfig["bindEncoding"],"");
_152.sendTransport=dojo.lang.firstValued(_152["sendTransport"],djConfig["ioSendTransport"],false);
var _153=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_152[fn]&&_153(_152[fn])){
continue;
}
if(_152["handle"]&&_153(_152["handle"])){
_152[fn]=_152.handle;
}
}
dojo.lang.mixin(this,_152);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_15a){
if(!(_15a instanceof dojo.io.Request)){
try{
_15a=new dojo.io.Request(_15a);
}
catch(e){
dojo.debug(e);
}
}
var _15b="";
if(_15a["transport"]){
_15b=_15a["transport"];
if(!this[_15b]){
dojo.io.sendBindError(_15a,"No dojo.io.bind() transport with name '"+_15a["transport"]+"'.");
return _15a;
}
if(!this[_15b].canHandle(_15a)){
dojo.io.sendBindError(_15a,"dojo.io.bind() transport with name '"+_15a["transport"]+"' cannot handle this type of request.");
return _15a;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_15a))){
_15b=tmp;
break;
}
}
if(_15b==""){
dojo.io.sendBindError(_15a,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _15a;
}
}
this[_15b].bind(_15a);
_15a.bindSuccess=true;
return _15a;
};
dojo.io.sendBindError=function(_15e,_15f){
if((typeof _15e.error=="function"||typeof _15e.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _160=new dojo.io.Error(_15f);
setTimeout(function(){
_15e[(typeof _15e.error=="function")?"error":"handle"]("error",_160,null,_15e);
},50);
}else{
dojo.raise(_15f);
}
};
dojo.io.queueBind=function(_161){
if(!(_161 instanceof dojo.io.Request)){
try{
_161=new dojo.io.Request(_161);
}
catch(e){
dojo.debug(e);
}
}
var _162=_161.load;
_161.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_162.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _164=_161.error;
_161.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_164.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_161);
dojo.io._dispatchNextQueueBind();
return _161;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_167,last){
var enc=/utf/i.test(_167||"")?encodeURIComponent:dojo.string.encodeAscii;
var _16a=[];
var _16b=new Object();
for(var name in map){
var _16d=function(elt){
var val=enc(name)+"="+enc(elt);
_16a[(last==name)?"push":"unshift"](val);
};
if(!_16b[name]){
var _170=map[name];
if(dojo.lang.isArray(_170)){
dojo.lang.forEach(_170,_16d);
}else{
_16d(_170);
}
}
}
return _16a.join("&");
};
dojo.io.setIFrameSrc=function(_171,src,_173){
try{
var r=dojo.render.html;
if(!_173){
if(r.safari){
_171.location=src;
}else{
frames[_171.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_171.contentWindow.document;
}else{
if(r.safari){
idoc=_171.document;
}else{
idoc=_171.contentWindow;
}
}
if(!idoc){
_171.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.lang.array");
dojo.lang.has=function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
};
dojo.lang.isEmpty=function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _17a=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_17a++;
break;
}
}
return _17a==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
};
dojo.lang.map=function(arr,obj,_17e){
var _17f=dojo.lang.isString(arr);
if(_17f){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_17e)){
_17e=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_17e){
var _180=obj;
obj=_17e;
_17e=_180;
}
}
if(Array.map){
var _181=Array.map(arr,_17e,obj);
}else{
var _181=[];
for(var i=0;i<arr.length;++i){
_181.push(_17e.call(obj,arr[i]));
}
}
if(_17f){
return _181.join("");
}else{
return _181;
}
};
dojo.lang.reduce=function(arr,_184,obj,_186){
var _187=_184;
var ob=obj?obj:dj_global;
dojo.lang.map(arr,function(val){
_187=_186.call(ob,_187,val);
});
return _187;
};
dojo.lang.forEach=function(_18a,_18b,_18c){
if(dojo.lang.isString(_18a)){
_18a=_18a.split("");
}
if(Array.forEach){
Array.forEach(_18a,_18b,_18c);
}else{
if(!_18c){
_18c=dj_global;
}
for(var i=0,l=_18a.length;i<l;i++){
_18b.call(_18c,_18a[i],i,_18a);
}
}
};
dojo.lang._everyOrSome=function(_18f,arr,_191,_192){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_18f?"every":"some"](arr,_191,_192);
}else{
if(!_192){
_192=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _195=_191.call(_192,arr[i],i,arr);
if(_18f&&!_195){
return false;
}else{
if((!_18f)&&(_195)){
return true;
}
}
}
return Boolean(_18f);
}
};
dojo.lang.every=function(arr,_197,_198){
return this._everyOrSome(true,arr,_197,_198);
};
dojo.lang.some=function(arr,_19a,_19b){
return this._everyOrSome(false,arr,_19a,_19b);
};
dojo.lang.filter=function(arr,_19d,_19e){
var _19f=dojo.lang.isString(arr);
if(_19f){
arr=arr.split("");
}
var _1a0;
if(Array.filter){
_1a0=Array.filter(arr,_19d,_19e);
}else{
if(!_19e){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_19e=dj_global;
}
_1a0=[];
for(var i=0;i<arr.length;i++){
if(_19d.call(_19e,arr[i],i,arr)){
_1a0.push(arr[i]);
}
}
}
if(_19f){
return _1a0.join("");
}else{
return _1a0;
}
};
dojo.lang.unnest=function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
};
dojo.lang.toArray=function(_1a5,_1a6){
var _1a7=[];
for(var i=_1a6||0;i<_1a5.length;i++){
_1a7.push(_1a5[i]);
}
return _1a7;
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_1a9,_1aa){
var fcn=(dojo.lang.isString(_1aa)?_1a9[_1aa]:_1aa)||function(){
};
return function(){
return fcn.apply(_1a9,arguments);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_1ac,_1ad,_1ae){
var nso=(_1ad||dojo.lang.anon);
if((_1ae)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_1ac){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_1ac;
return ret;
};
dojo.lang.forward=function(_1b2){
return function(){
return this[_1b2].apply(this,arguments);
};
};
dojo.lang.curry=function(ns,func){
var _1b5=[];
ns=ns||dj_global;
if(dojo.lang.isString(func)){
func=ns[func];
}
for(var x=2;x<arguments.length;x++){
_1b5.push(arguments[x]);
}
var _1b7=(func["__preJoinArity"]||func.length)-_1b5.length;
function gather(_1b8,_1b9,_1ba){
var _1bb=_1ba;
var _1bc=_1b9.slice(0);
for(var x=0;x<_1b8.length;x++){
_1bc.push(_1b8[x]);
}
_1ba=_1ba-_1b8.length;
if(_1ba<=0){
var res=func.apply(ns,_1bc);
_1ba=_1bb;
return res;
}else{
return function(){
return gather(arguments,_1bc,_1ba);
};
}
}
return gather([],_1b5,_1b7);
};
dojo.lang.curryArguments=function(ns,func,args,_1c2){
var _1c3=[];
var x=_1c2||0;
for(x=_1c2;x<args.length;x++){
_1c3.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[ns,func].concat(_1c3));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1c9,_1ca){
if(!farr.length){
if(typeof _1ca=="function"){
_1ca();
}
return;
}
if((typeof _1c9=="undefined")&&(typeof cb=="number")){
_1c9=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1c9){
_1c9=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1c9,_1ca);
},_1c9);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_1cb,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _1cb.replace(/\%\{(\w+)\}/g,function(_1ce,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _1d1=str.split(" ");
for(var i=0;i<_1d1.length;i++){
_1d1[i]=_1d1[i].charAt(0).toUpperCase()+_1d1[i].substring(1);
}
return _1d1.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _1d6=escape(str);
var _1d7,re=/%u([0-9A-F]{4})/i;
while((_1d7=_1d6.match(re))){
var num=Number("0x"+_1d7[1]);
var _1da=escape("&#"+num+";");
ret+=_1d6.substring(0,_1d7.index)+_1da;
_1d6=_1d6.substring(_1d7.index+_1d7[0].length);
}
ret+=_1d6.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_1df){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_1df){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_1e8){
if(_1e8){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1ec,_1ed){
if(_1ed){
str=str.toLowerCase();
_1ec=_1ec.toLowerCase();
}
return str.indexOf(_1ec)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1f3){
if(_1f3=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1f3=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1f5){
var _1f6=[];
for(var i=0,_1f8=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1f5){
_1f6.push(str.substring(_1f8,i));
_1f8=i+1;
}
}
_1f6.push(str.substr(_1f8));
return _1f6;
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(E){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _1fa=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_1fa.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_1fc,_1fd){
var node=_1fc.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_1fd&&node&&node.tagName&&node.tagName.toLowerCase()!=_1fd.toLowerCase()){
node=dojo.dom.nextElement(node,_1fd);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_1ff,_200){
var node=_1ff.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_200&&node&&node.tagName&&node.tagName.toLowerCase()!=_200.toLowerCase()){
node=dojo.dom.prevElement(node,_200);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_203){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_203&&_203.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_203);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_205){
if(!node){
return null;
}
if(_205){
_205=_205.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_205&&_205.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_205);
}
return node;
};
dojo.dom.moveChildren=function(_206,_207,trim){
var _209=0;
if(trim){
while(_206.hasChildNodes()&&_206.firstChild.nodeType==dojo.dom.TEXT_NODE){
_206.removeChild(_206.firstChild);
}
while(_206.hasChildNodes()&&_206.lastChild.nodeType==dojo.dom.TEXT_NODE){
_206.removeChild(_206.lastChild);
}
}
while(_206.hasChildNodes()){
_207.appendChild(_206.firstChild);
_209++;
}
return _209;
};
dojo.dom.copyChildren=function(_20a,_20b,trim){
var _20d=_20a.cloneNode(true);
return this.moveChildren(_20d,_20b,trim);
};
dojo.dom.removeChildren=function(node){
var _20f=node.childNodes.length;
while(node.hasChildNodes()){
node.removeChild(node.firstChild);
}
return _20f;
};
dojo.dom.replaceChildren=function(node,_211){
dojo.dom.removeChildren(node);
node.appendChild(_211);
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_214,_215){
var _216=[];
var _217=(_214&&(_214 instanceof Function||typeof _214=="function"));
while(node){
if(!_217||_214(node)){
_216.push(node);
}
if(_215&&_216.length>0){
return _216[0];
}
node=node.parentNode;
}
if(_215){
return null;
}
return _216;
};
dojo.dom.getAncestorsByTag=function(node,tag,_21a){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_21a);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_21f,_220){
if(_220&&node){
node=node.parentNode;
}
while(node){
if(node==_21f){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _223=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _224=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_224.length;i++){
try{
doc=new ActiveXObject(_224[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_223.implementation)&&(_223.implementation.createDocument)){
doc=_223.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_227){
if(!_227){
_227="text/xml";
}
if(!dj_undef("DOMParser")){
var _228=new DOMParser();
return _228.parseFromString(str,_227);
}else{
if(!dj_undef("ActiveXObject")){
var _229=dojo.dom.createDocument();
if(_229){
_229.async=false;
_229.loadXML(str);
return _229;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _22a=dojo.doc();
if(_22a.createElement){
var tmp=_22a.createElement("xml");
tmp.innerHTML=str;
if(_22a.implementation&&_22a.implementation.createDocument){
var _22c=_22a.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_22c.importNode(tmp.childNodes.item(i),true);
}
return _22c;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_22f){
if(_22f.firstChild){
_22f.insertBefore(node,_22f.firstChild);
}else{
_22f.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_232){
if(_232!=true&&(node===ref||node.nextSibling===ref)){
return false;
}
var _233=ref.parentNode;
_233.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_236){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_236!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_236);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_23a){
if((!node)||(!ref)||(!_23a)){
return false;
}
switch(_23a.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_23c,_23d){
var _23e=_23c.childNodes;
if(!_23e.length){
_23c.appendChild(node);
return true;
}
var _23f=null;
for(var i=0;i<_23e.length;i++){
var _241=_23e.item(i)["getAttribute"]?parseInt(_23e.item(i).getAttribute("dojoinsertionindex")):-1;
if(_241<_23d){
_23f=_23e.item(i);
}
}
if(_23f){
return dojo.dom.insertAfter(node,_23f);
}else{
return dojo.dom.insertBefore(node,_23e.item(0));
}
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _244=dojo.doc();
dojo.dom.replaceChildren(node,_244.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _245="";
if(node==null){
return _245;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_245+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_245+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _245;
}
};
dojo.dom.hasParent=function(node){
return node&&node.parentNode&&dojo.dom.isNode(node.parentNode);
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_24b,_24c,_24d){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_24b,_24c,_24d);
}else{
var _24e=elem.ownerDocument;
var _24f=_24e.createNode(2,_24c,_24b);
_24f.nodeValue=_24d;
elem.setAttributeNode(_24f);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:window.location.href,initialHash:window.location.hash,moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _254=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_256){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_254.apply(this,[_256]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _257=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_259){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_257){
_257.apply(this,[_259]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_25c){
if(!dojo.render.html.opera){
var _25d=this._getUrlQuery(_25c.href);
if(_25d==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_25d==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_25d==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _25e=this.historyStack.pop();
if(!_25e){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_25e);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _265=url.split("?");
if(_265.length<2){
return null;
}else{
return _265[1];
}
},_loadIframeHistory:function(){
var url=dojo.hostenv.getBaseScriptUri()+"iframe_history.html?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
dojo.io.checkChildrenForFile=function(node){
var _268=false;
var _269=node.getElementsByTagName("input");
dojo.lang.forEach(_269,function(_26a){
if(_268){
return;
}
if(_26a.getAttribute("type")=="file"){
_268=true;
}
});
return _268;
};
dojo.io.formHasFile=function(_26b){
return dojo.io.checkChildrenForFile(_26b);
};
dojo.io.updateNode=function(node,_26d){
node=dojo.byId(node);
var args=_26d;
if(dojo.lang.isString(_26d)){
args={url:_26d};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
if(dojo["event"]){
try{
dojo.event.browser.clean(node.firstChild);
}
catch(e){
}
}
node.removeChild(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_274,_275,_276){
if((!_274)||(!_274.tagName)||(!_274.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_276){
_276=dojo.io.formFilter;
}
var enc=/utf/i.test(_275||"")?encodeURIComponent:dojo.string.encodeAscii;
var _278=[];
for(var i=0;i<_274.elements.length;i++){
var elm=_274.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_276(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_278.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_278.push(name+"="+enc(elm.value));
}
}else{
_278.push(name+"="+enc(elm.value));
}
}
}
var _27e=_274.getElementsByTagName("input");
for(var i=0;i<_27e.length;i++){
var _27f=_27e[i];
if(_27f.type.toLowerCase()=="image"&&_27f.form==_274&&_276(_27f)){
var name=enc(_27f.name);
_278.push(name+"="+enc(_27f.value));
_278.push(name+".x=0");
_278.push(name+".y=0");
}
}
return _278.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _285=form.getElementsByTagName("input");
for(var i=0;i<_285.length;i++){
var _286=_285[i];
if(_286.type.toLowerCase()=="image"&&_286.form==form){
this.connect(_286,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _28d=false;
if(node.disabled||!node.name){
_28d=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_28d=node==this.clickedButton;
}else{
_28d=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _28d;
},connect:function(_28e,_28f,_290){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_28e,_28f,this,_290);
}else{
var fcn=dojo.lang.hitch(this,_290);
_28e[_28f]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _293=this;
var _294={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_296,_297){
return url+"|"+_296+"|"+_297.toLowerCase();
}
function addToCache(url,_299,_29a,http){
_294[getCacheKey(url,_299,_29a)]=http;
}
function getFromCache(url,_29d,_29e){
return _294[getCacheKey(url,_29d,_29e)];
}
this.clearCache=function(){
_294={};
};
function doLoad(_29f,http,url,_2a2,_2a3){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_29f.method.toLowerCase()=="head"){
var _2a5=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _2a5;
};
var _2a6=_2a5.split(/[\r\n]+/g);
for(var i=0;i<_2a6.length;i++){
var pair=_2a6[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_29f.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_29f.mimetype=="text/json"||_29f.mimetype=="application/json"){
try{
ret=dj_eval("("+http.responseText+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_29f.mimetype=="application/xml")||(_29f.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_2a3){
addToCache(url,_2a2,_29f.method,http);
}
_29f[(typeof _29f.load=="function")?"load":"handle"]("load",ret,http,_29f);
}else{
var _2a9=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_29f[(typeof _29f.error=="function")?"error":"handle"]("error",_2a9,http,_29f);
}
}
function setHeaders(http,_2ab){
if(_2ab["headers"]){
for(var _2ac in _2ab["headers"]){
if(_2ac.toLowerCase()=="content-type"&&!_2ab["contentType"]){
_2ab["contentType"]=_2ab["headers"][_2ac];
}else{
http.setRequestHeader(_2ac,_2ab["headers"][_2ac]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_293._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _2b0=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_2b0,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _2b1=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_2b2){
return _2b1&&dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript","text/json","application/json"],(_2b2["mimetype"].toLowerCase()||""))&&!(_2b2["formNode"]&&dojo.io.formHasFile(_2b2["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_2b3){
if(!_2b3["url"]){
if(!_2b3["formNode"]&&(_2b3["backButton"]||_2b3["back"]||_2b3["changeUrl"]||_2b3["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_2b3);
return true;
}
}
var url=_2b3.url;
var _2b5="";
if(_2b3["formNode"]){
var ta=_2b3.formNode.getAttribute("action");
if((ta)&&(!_2b3["url"])){
url=ta;
}
var tp=_2b3.formNode.getAttribute("method");
if((tp)&&(!_2b3["method"])){
_2b3.method=tp;
}
_2b5+=dojo.io.encodeForm(_2b3.formNode,_2b3.encoding,_2b3["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_2b3["file"]){
_2b3.method="post";
}
if(!_2b3["method"]){
_2b3.method="get";
}
if(_2b3.method.toLowerCase()=="get"){
_2b3.multipart=false;
}else{
if(_2b3["file"]){
_2b3.multipart=true;
}else{
if(!_2b3["multipart"]){
_2b3.multipart=false;
}
}
}
if(_2b3["backButton"]||_2b3["back"]||_2b3["changeUrl"]){
dojo.undo.browser.addToHistory(_2b3);
}
var _2b8=_2b3["content"]||{};
if(_2b3.sendTransport){
_2b8["dojo.transport"]="xmlhttp";
}
do{
if(_2b3.postContent){
_2b5=_2b3.postContent;
break;
}
if(_2b8){
_2b5+=dojo.io.argsFromMap(_2b8,_2b3.encoding);
}
if(_2b3.method.toLowerCase()=="get"||!_2b3.multipart){
break;
}
var t=[];
if(_2b5.length){
var q=_2b5.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_2b3.file){
if(dojo.lang.isArray(_2b3.file)){
for(var i=0;i<_2b3.file.length;++i){
var o=_2b3.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_2b3.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_2b5=t.join("\r\n");
}
}while(false);
var _2be=_2b3["sync"]?false:true;
var _2bf=_2b3["preventCache"]||(this.preventCache==true&&_2b3["preventCache"]!=false);
var _2c0=_2b3["useCache"]==true||(this.useCache==true&&_2b3["useCache"]!=false);
if(!_2bf&&_2c0){
var _2c1=getFromCache(url,_2b5,_2b3.method);
if(_2c1){
doLoad(_2b3,_2c1,url,_2b5,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_2b3);
var _2c3=false;
if(_2be){
var _2c4=this.inFlight.push({"req":_2b3,"http":http,"url":url,"query":_2b5,"useCache":_2c0,"startTime":_2b3.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_293._blockAsync=true;
}
if(_2b3.method.toLowerCase()=="post"){
if(!_2b3.user){
http.open("POST",url,_2be);
}else{
http.open("POST",url,_2be,_2b3.user,_2b3.password);
}
setHeaders(http,_2b3);
http.setRequestHeader("Content-Type",_2b3.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_2b3.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_2b5);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b3,{status:404},url,_2b5,_2c0);
}
}else{
var _2c5=url;
if(_2b5!=""){
_2c5+=(_2c5.indexOf("?")>-1?"&":"?")+_2b5;
}
if(_2bf){
_2c5+=(dojo.string.endsWithAny(_2c5,"?","&")?"":(_2c5.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_2b3.user){
http.open(_2b3.method.toUpperCase(),_2c5,_2be);
}else{
http.open(_2b3.method.toUpperCase(),_2c5,_2be,_2b3.user,_2b3.password);
}
setHeaders(http,_2b3);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2b3,{status:404},url,_2b5,_2c0);
}
}
if(!_2be){
doLoad(_2b3,http,url,_2b5,_2c0);
_293._blockAsync=false;
}
_2b3.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_2c7,days,path,_2ca,_2cb){
var _2cc=-1;
if(typeof days=="number"&&days>=0){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_2cc=d.toGMTString();
}
_2c7=escape(_2c7);
document.cookie=name+"="+_2c7+";"+(_2cc!=-1?" expires="+_2cc+";":"")+(path?"path="+path:"")+(_2ca?"; domain="+_2ca:"")+(_2cb?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _2d0=document.cookie.substring(idx+name.length+1);
var end=_2d0.indexOf(";");
if(end==-1){
end=_2d0.length;
}
_2d0=_2d0.substring(0,end);
_2d0=unescape(_2d0);
return _2d0;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_2d7,_2d8,_2d9){
if(arguments.length==5){
_2d9=_2d7;
_2d7=null;
_2d8=null;
}
var _2da=[],_2db,_2dc="";
if(!_2d9){
_2db=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_2db){
_2db={};
}
for(var prop in obj){
if(prop==null){
delete _2db[prop];
}else{
if(typeof obj[prop]=="string"||typeof obj[prop]=="number"){
_2db[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _2db){
_2da.push(escape(prop)+"="+escape(_2db[prop]));
}
_2dc=_2da.join("&");
}
dojo.io.cookie.setCookie(name,_2dc,days,path,_2d7,_2d8);
};
dojo.io.cookie.getObjectCookie=function(name){
var _2df=null,_2e0=dojo.io.cookie.getCookie(name);
if(_2e0){
_2df={};
var _2e1=_2e0.split("&");
for(var i=0;i<_2e1.length;i++){
var pair=_2e1[i].split("=");
var _2e4=pair[1];
if(isNaN(_2e4)){
_2e4=unescape(pair[1]);
}
_2df[unescape(pair[0])]=_2e4;
}
}
return _2df;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _2e5=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_2e5=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.provide("dojo.io.*");
dojo.provide("dojo.io");
dojo.deprecated("dojo.io","replaced by dojo.io.*","0.5");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_2e7){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _2ea=dl.nameAnonFunc(args[2],ao.adviceObj,_2e7);
ao.adviceFunc=_2ea;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _2ea=dl.nameAnonFunc(args[0],ao.srcObj,_2e7);
ao.srcFunc=_2ea;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _2ea=dl.nameAnonFunc(args[1],dj_global,_2e7);
ao.srcFunc=_2ea;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _2ea=dl.nameAnonFunc(args[3],dj_global,_2e7);
ao.adviceObj=dj_global;
ao.adviceFunc=_2ea;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _2ea=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_2e7);
ao.aroundFunc=_2ea;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _2ec={};
for(var x in ao){
_2ec[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_2ec.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_2ec));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _2f4;
if((arguments.length==1)&&(typeof a1=="object")){
_2f4=a1;
}else{
_2f4={srcObj:a1,srcFunc:a2};
}
_2f4.adviceFunc=function(){
var _2f5=[];
for(var x=0;x<arguments.length;x++){
_2f5.push(arguments[x]);
}
dojo.debug("("+_2f4.srcObj+")."+_2f4.srcFunc,":",_2f5.join(", "));
};
this.kwConnect(_2f4);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this._kwConnectImpl=function(_2fc,_2fd){
var fn=(_2fd)?"disconnect":"connect";
if(typeof _2fc["srcFunc"]=="function"){
_2fc.srcObj=_2fc["srcObj"]||dj_global;
var _2ff=dojo.lang.nameAnonFunc(_2fc.srcFunc,_2fc.srcObj,true);
_2fc.srcFunc=_2ff;
}
if(typeof _2fc["adviceFunc"]=="function"){
_2fc.adviceObj=_2fc["adviceObj"]||dj_global;
var _2ff=dojo.lang.nameAnonFunc(_2fc.adviceFunc,_2fc.adviceObj,true);
_2fc.adviceFunc=_2ff;
}
_2fc.srcObj=_2fc["srcObj"]||dj_global;
_2fc.adviceObj=_2fc["adviceObj"]||_2fc["targetObj"]||dj_global;
_2fc.adviceFunc=_2fc["adviceFunc"]||_2fc["targetFunc"];
return dojo.event[fn](_2fc);
};
this.kwConnect=function(_300){
return this._kwConnectImpl(_300,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
return mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
};
this.kwDisconnect=function(_303){
return this._kwConnectImpl(_303,true);
};
};
dojo.event.MethodInvocation=function(_304,obj,args){
this.jp_=_304;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_30c){
this.object=obj||dj_global;
this.methodname=_30c;
this.methodfunc=this.object[_30c];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_30e){
if(!obj){
obj=dj_global;
}
if(!obj[_30e]){
obj[_30e]=function(){
};
if(!obj[_30e]){
dojo.raise("Cannot set do-nothing method on that object "+_30e);
}
}else{
if((!dojo.lang.isFunction(obj[_30e]))&&(!dojo.lang.isAlien(obj[_30e]))){
return null;
}
}
var _30f=_30e+"$joinpoint";
var _310=_30e+"$joinpoint$method";
var _311=obj[_30f];
if(!_311){
var _312=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_312=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_30f,_310,_30e]);
}
}
var _313=obj[_30e].length;
obj[_310]=obj[_30e];
_311=obj[_30f]=new dojo.event.MethodJoinPoint(obj,_310);
obj[_30e]=function(){
var args=[];
if((_312)&&(!arguments.length)){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(_312)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _311.run.apply(_311,args);
};
obj[_30e].__preJoinArity=_313;
}
return _311;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _319=[];
for(var x=0;x<args.length;x++){
_319[x]=args[x];
}
var _31b=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _31d=marr[0]||dj_global;
var _31e=marr[1];
if(!_31d[_31e]){
dojo.raise("function \""+_31e+"\" does not exist on \""+_31d+"\"");
}
var _31f=marr[2]||dj_global;
var _320=marr[3];
var msg=marr[6];
var _322;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _31d[_31e].apply(_31d,to.args);
}};
to.args=_319;
var _324=parseInt(marr[4]);
var _325=((!isNaN(_324))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _328=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_31b(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_320){
_31f[_320].call(_31f,to);
}else{
if((_325)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_31d[_31e].call(_31d,to);
}else{
_31d[_31e].apply(_31d,args);
}
},_324);
}else{
if(msg){
_31d[_31e].call(_31d,to);
}else{
_31d[_31e].apply(_31d,args);
}
}
}
};
var _32b=function(){
if(this.squelch){
try{
return _31b.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _31b.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_32b);
}
var _32c;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_32c=mi.proceed();
}else{
if(this.methodfunc){
_32c=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_32b);
}
return (this.methodfunc)?_32c:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"]);
},addAdvice:function(_331,_332,_333,_334,_335,_336,once,_338,rate,_33a){
var arr=this.getArr(_335);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_331,_332,_333,_334,_338,rate,_33a];
if(once){
if(this.hasAdvice(_331,_332,_335,arr)>=0){
return;
}
}
if(_336=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_33d,_33e,_33f,arr){
if(!arr){
arr=this.getArr(_33f);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _33e=="object")?(new String(_33e)).toString():_33e;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_33d)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_345,_346,_347,once){
var arr=this.getArr(_347);
var ind=this.hasAdvice(_345,_346,_347,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_345,_346,_347,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_34b){
if(!this.topics[_34b]){
this.topics[_34b]=new this.TopicImpl(_34b);
}
return this.topics[_34b];
};
this.registerPublisher=function(_34c,obj,_34e){
var _34c=this.getTopic(_34c);
_34c.registerPublisher(obj,_34e);
};
this.subscribe=function(_34f,obj,_351){
var _34f=this.getTopic(_34f);
_34f.subscribe(obj,_351);
};
this.unsubscribe=function(_352,obj,_354){
var _352=this.getTopic(_352);
_352.unsubscribe(obj,_354);
};
this.destroy=function(_355){
this.getTopic(_355).destroy();
delete this.topics[_355];
};
this.publishApply=function(_356,args){
var _356=this.getTopic(_356);
_356.sendMessage.apply(_356,args);
};
this.publish=function(_358,_359){
var _358=this.getTopic(_358);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_358.sendMessage.apply(_358,args);
};
};
dojo.event.topic.TopicImpl=function(_35c){
this.topicName=_35c;
this.subscribe=function(_35d,_35e){
var tf=_35e||_35d;
var to=(!_35e)?dj_global:_35d;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_361,_362){
var tf=(!_362)?_361:_362;
var to=(!_362)?null:_361;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_365){
this._getJoinPoint().squelch=_365;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_366,_367){
dojo.event.connect(_366,_367,this,"sendMessage");
};
this.sendMessage=function(_368){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_36b){
var na;
var tna;
if(_36b){
tna=_36b.all||_36b.getElementsByTagName("*");
na=[_36b];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _36f={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _373=0;
this.normalizedEventName=function(_374){
switch(_374){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _374;
break;
default:
return _374.toLowerCase();
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_378){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_378.length;x++){
node.__clobberAttrs__.push(_378[x]);
}
};
this.removeListener=function(node,_37b,fp,_37d){
if(!_37d){
var _37d=false;
}
_37b=dojo.event.browser.normalizedEventName(_37b);
if((_37b=="onkey")||(_37b=="key")){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_37d);
}
_37b="onkeypress";
}
if(_37b.substr(0,2)=="on"){
_37b=_37b.substr(2);
}
if(node.removeEventListener){
node.removeEventListener(_37b,fp,_37d);
}
};
this.addListener=function(node,_37f,fp,_381,_382){
if(!node){
return;
}
if(!_381){
var _381=false;
}
_37f=dojo.event.browser.normalizedEventName(_37f);
if((_37f=="onkey")||(_37f=="key")){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_381,_382);
}
_37f="onkeypress";
}
if(_37f.substr(0,2)!="on"){
_37f="on"+_37f;
}
if(!_382){
var _383=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_381){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_383=fp;
}
if(node.addEventListener){
node.addEventListener(_37f.substr(2),_383,_381);
return _383;
}else{
if(typeof node[_37f]=="function"){
var _386=node[_37f];
node[_37f]=function(e){
_386(e);
return _383(e);
};
}else{
node[_37f]=_383;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_37f]);
}
return _383;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_389,_38a){
if(typeof _389!="function"){
dojo.raise("listener not a function: "+_389);
}
dojo.event.browser.currentEvent.currentTarget=_38a;
return _389.call(_38a,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_38d){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _38f=evt.keyCode;
if(_38f>=65&&_38f<=90&&evt.shiftKey==false){
_38f+=32;
}
if(_38f>=1&&_38f<=26&&evt.ctrlKey){
_38f+=96;
}
evt.key=String.fromCharCode(_38f);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _38f=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_38f+=32;
}
evt.key=String.fromCharCode(_38f);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
default:
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_38d?_38d:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _391=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_391.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_391.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.returnValue=false;
evt.cancelBubble=true;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.provide("dojo.event.*");


__CPAN_EDITION__ event_and_io build.txt

Files baked into this package:

dojoGuardStart.js,
../src/bootstrap1.js,
../src/loader.js,
dojoGuardEnd.js,
../src/hostenv_browser.js,
../src/bootstrap2.js,
../src/string/common.js,
../src/string.js,
../src/lang/common.js,
../src/lang/extras.js,
../src/io/common.js,
../src/lang/array.js,
../src/lang/func.js,
../src/string/extras.js,
../src/dom.js,
../src/undo/browser.js,
../src/io/BrowserIO.js,
../src/io/cookie.js,
../src/io/__package__.js,
../src/io.js,
../src/event/common.js,
../src/event/topic.js,
../src/event/browser.js,
../src/event/__package__.js

		
__CPAN_EDITION__ kitchen_sink dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:0,flag:"",revision:Number("$Rev: 6258 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
return _6e?_6e.toLowerCase():dojo.locale;
};
dojo.hostenv.searchLocalePath=function(_6f,_70,_71){
_6f=dojo.hostenv.normalizeLocale(_6f);
var _72=_6f.split("-");
var _73=[];
for(var i=_72.length;i>0;i--){
_73.push(_72.slice(0,i).join("-"));
}
_73.push(false);
if(_70){
_73.reverse();
}
for(var j=_73.length-1;j>=0;j--){
var loc=_73[j]||"ROOT";
var _77=_71(loc);
if(_77){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_78){
_78=dojo.hostenv.normalizeLocale(_78);
dojo.hostenv.searchLocalePath(_78,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7b=djConfig.extraLocale||[];
for(var i=0;i<_7b.length;i++){
preload(_7b[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7d,_7e,_7f){
dojo.hostenv.preloadLocalizations();
var _80=[_7d,"nls",_7e].join(".");
var _81=dojo.hostenv.findModule(_80);
if(_81){
if(djConfig.localizationComplete&&_81._built){
return;
}
var _82=dojo.hostenv.normalizeLocale(_7f).replace("-","_");
var _83=_80+"."+_82;
if(dojo.hostenv.findModule(_83)){
return;
}
}
_81=dojo.hostenv.startPackage(_80);
var _84=dojo.hostenv.getModuleSymbols(_7d);
var _85=_84.concat("nls").join("/");
var _86;
dojo.hostenv.searchLocalePath(_7f,false,function(loc){
var _88=loc.replace("-","_");
var _89=_80+"."+_88;
var _8a=false;
if(!dojo.hostenv.findModule(_89)){
dojo.hostenv.startPackage(_89);
var _8b=[_85];
if(loc!="ROOT"){
_8b.push(loc);
}
_8b.push(_7e);
var _8c=_8b.join("/")+".js";
_8a=dojo.hostenv.loadPath(_8c,null,function(_8d){
var _8e=function(){
};
_8e.prototype=_86;
_81[_88]=new _8e();
for(var j in _8d){
_81[_88][j]=_8d[j];
}
});
}else{
_8a=true;
}
if(_8a&&_81[_88]){
_86=_81[_88];
}else{
_81[_88]=_86;
}
});
};
(function(){
var _90=djConfig.extraLocale;
if(_90){
if(!_90 instanceof Array){
_90=[_90];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_94){
req(m,b,_94);
if(_94){
return;
}
for(var i=0;i<_90.length;i++){
req(m,b,_90[i]);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _96=document.location.toString();
var _97=_96.split("?",2);
if(_97.length>1){
var _98=_97[1];
var _99=_98.split("&");
for(var x in _99){
var sp=_99[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _9d=document.getElementsByTagName("script");
var _9e=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_9d.length;i++){
var src=_9d[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_9e);
if(m){
var _a2=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_a2+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_a2;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_a2;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _aa=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_aa>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_aa+6,_aa+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _ac=window["document"];
var tdi=_ac["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b0=null;
var _b1=null;
try{
_b0=new XMLHttpRequest();
}
catch(e){
}
if(!_b0){
for(var i=0;i<3;++i){
var _b3=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b0=new ActiveXObject(_b3);
}
catch(e){
_b1=e;
}
if(_b0){
dojo.hostenv._XMLHTTP_PROGIDS=[_b3];
break;
}
}
}
if(!_b0){
return dojo.raise("XMLHTTP not available",_b1);
}
return _b0;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_b5,_b6){
if(!_b5){
this._blockAsync=true;
}
var _b7=this.getXmlhttpObject();
function isDocumentOk(_b8){
var _b9=_b8["status"];
return Boolean((!_b9)||((200<=_b9)&&(300>_b9))||(_b9==304));
}
if(_b5){
var _ba=this,_bb=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_b7.onreadystatechange=function(){
if(_bb){
gbl.clearTimeout(_bb);
_bb=null;
}
if(_ba._blockAsync||(xhr&&xhr._blockAsync)){
_bb=gbl.setTimeout(function(){
_b7.onreadystatechange.apply(this);
},10);
}else{
if(4==_b7.readyState){
if(isDocumentOk(_b7)){
_b5(_b7.responseText);
}
}
}
};
}
_b7.open("GET",uri,_b5?true:false);
try{
_b7.send(null);
if(_b5){
return null;
}
if(!isDocumentOk(_b7)){
var err=Error("Unable to load "+uri+" status:"+_b7.status);
err.status=_b7.status;
err.responseText=_b7.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_b6)&&(!_b5)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _b7.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_bf){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_bf);
}else{
try{
var _c0=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c0){
_c0=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_bf));
_c0.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_bf+"</div>");
}
catch(e2){
window.status=_bf;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_c2,_c3,fp,_c5){
var _c6=_c2["on"+_c3]||function(){
};
_c2["on"+_c3]=function(){
fp.apply(_c2,arguments);
_c6.apply(_c2,arguments);
};
return true;
}
function dj_load_init(e){
var _c8=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_c8!="domcontentloaded"&&_c8!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _c9=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_c9();
dojo.hostenv.modulesLoaded();
}else{
dojo.addOnLoad(_c9);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&!djConfig.delayMozLoadingFix)){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _cb=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_cb=_cb.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_cb=_cb.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_cb.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _cc=new dojo.xml.Parse();
if(_cb.length>0){
for(var x=0;x<_cb.length;x++){
var _ce=document.getElementById(_cb[x]);
if(!_ce){
continue;
}
var _cf=_cc.parseElement(_ce,null,true);
dojo.widget.getParser().createComponents(_cf);
}
}else{
if(djConfig.parseWidgets){
var _cf=_cc.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_cf);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_d4,_d5){
dj_currentContext=_d4;
dj_currentDocument=_d5;
};
dojo._fireCallback=function(_d6,_d7,_d8){
if((_d7)&&((typeof _d6=="string")||(_d6 instanceof String))){
_d6=_d7[_d6];
}
return (_d7?_d6.apply(_d7,_d8||[]):_d6());
};
dojo.withGlobal=function(_d9,_da,_db,_dc){
var _dd;
var _de=dj_currentContext;
var _df=dj_currentDocument;
try{
dojo.setContext(_d9,_d9.document);
_dd=dojo._fireCallback(_da,_db,_dc);
}
finally{
dojo.setContext(_de,_df);
}
return _dd;
};
dojo.withDoc=function(_e0,_e1,_e2,_e3){
var _e4;
var _e5=dj_currentDocument;
try{
dj_currentDocument=_e0;
_e4=dojo._fireCallback(_e1,_e2,_e3);
}
finally{
dj_currentDocument=_e5;
}
return _e4;
};
}
(function(){
if(typeof dj_usingBootstrap!="undefined"){
return;
}
var _e6=false;
var _e7=false;
var _e8=false;
if((typeof this["load"]=="function")&&((typeof this["Packages"]=="function")||(typeof this["Packages"]=="object"))){
_e6=true;
}else{
if(typeof this["load"]=="function"){
_e7=true;
}else{
if(window.widget){
_e8=true;
}
}
}
var _e9=[];
if((this["djConfig"])&&((djConfig["isDebug"])||(djConfig["debugAtAllCosts"]))){
_e9.push("debug.js");
}
if((this["djConfig"])&&(djConfig["debugAtAllCosts"])&&(!_e6)&&(!_e8)){
_e9.push("browser_debug.js");
}
var _ea=djConfig["baseScriptUri"];
if((this["djConfig"])&&(djConfig["baseLoaderUri"])){
_ea=djConfig["baseLoaderUri"];
}
for(var x=0;x<_e9.length;x++){
var _ec=_ea+"src/"+_e9[x];
if(_e6||_e7){
load(_ec);
}else{
try{
document.write("<scr"+"ipt type='text/javascript' src='"+_ec+"'></scr"+"ipt>");
}
catch(e){
var _ed=document.createElement("script");
_ed.src=_ec;
document.getElementsByTagName("head")[0].appendChild(_ed);
}
}
}
})();
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(typeof _ef!="function"){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
if(!it){
return false;
}
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction()&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang");
dojo.deprecated("dojo.lang","replaced by dojo.lang.common","0.5");
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(E){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _114=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_114.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_116,_117){
var node=_116.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_117&&node&&node.tagName&&node.tagName.toLowerCase()!=_117.toLowerCase()){
node=dojo.dom.nextElement(node,_117);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_119,_11a){
var node=_119.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_11a&&node&&node.tagName&&node.tagName.toLowerCase()!=_11a.toLowerCase()){
node=dojo.dom.prevElement(node,_11a);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_11d){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_11d&&_11d.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_11d);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_11f){
if(!node){
return null;
}
if(_11f){
_11f=_11f.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_11f&&_11f.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_11f);
}
return node;
};
dojo.dom.moveChildren=function(_120,_121,trim){
var _123=0;
if(trim){
while(_120.hasChildNodes()