#!/opt/perl/bin/perl -T
#
# File:  webcgi/session/demo.pl
# Desc:  Generic PSD "persistent user session" CGI script
# Date:  Wed Sep 22 14:01:28 2004
# Stat:  Prototype, Experimental
#
# Abstract:
#        This "CGI" script is intended to be run by the PSD
#        session manager as a persistent user session. Except 
#        for the 'handleInput' (wrapper) method, this should
#        act just like a "normal" CGI script with the addition
#        of persistent user data maintained across multiple
#        client accesses (when client accesses via SSL with a
#        "HTTP Cookie" generated by the PSD session manager).
#
#        Any text sent to STDOUT via 'print' or 'printf' will 
#        be collected and must be 'flushed' at the end of each 
#        request cycle (see the 'handleInput' method). Any text 
#        written to STDERR will be collected by the PSD session 
#        manager. If this script terminates prior to flushing 
#        any text from STDOUT, the PSD session manager assumes
#        an error occurred. It will then create an error message
#        (response code 401), include any STDERR text, and send 
#        this back to the Web client to aid in troubleshooting.
#        Additional information will be written to the PSD log.
#
# Synopsis:
#        For now, the PSD session manager will look in an
#        application's ".../webcgi/session" subdirectory for
#        a script name that matches the "PSD Realm". E.g.:
#        . if realm = "demo", script name must be "demo.pl"
#        . if realm = "test", script name must be "test.pl"
#
#        This script should use the PSD utility class that
#        wraps the normal CGI class. See the 'handleInput'
#        method for usage and additional comments.
#

#use lib "/nethome/cobb/source/perl/tools/psd/lib";
# use POE::Component::Server::PSD::Session::Demo;   # is included, below
run POE::Component::PSD::Server::Session::Demo( @ARGV );
exit(0);

#-----------------------------------------------------------------------

package POE::Component::PSD::Server::Session::Demo;
use strict;
use warnings;
use PTools::Local;

BEGIN {
   $ENV{PATH} = '/bin:/usr/bin:/usr/sbin';
   use lib "/home/cobb/misc/toolsDist/POE-Component-PSD/lib";
   chomp(my $cwd = `/bin/pwd`);
   ## die PTools::Local->dump('incpath');
   ## die "DEBUG: cwd='$cwd'";
}

our $PACK    = __PACKAGE__;
our $VERSION = "0.01";
our @ISA     = ( );

use CGI;
use POE::Component::PSD::Server::CGI;  ## qw( Debug );
use PTools::Date::Format;
use PTools::String;


# FIX: cleanup this mess of package-global vars.
#
my $Local = "PTools::Local";
my($UriPath, $Realm, $LastClick, $UserSession) = ("","","","");
my($Counter, $DataLoaded)        = (0,0);
my $MainMenuPath = "/session/";
my $Login;

my $DFM = "PTools::Date::Format";

BEGIN {    # must do this since this is a script, not a module
   $DFM = "PTools::Date::Format";
   $PACK  = __PACKAGE__;
   $Local = "PTools::Local";
}

sub run
{   my($class, $login, $userSession, $realm ) = @_;

    $login       ||= "*Unknown Login*";
    $userSession ||= "*Unknown Session*";
    $realm       ||= "*Unknown Realm*";

    $MainMenuPath= "/session/";                # FIX: don't hard-code path
    $UriPath     = $MainMenuPath . $realm;
    $Login       = $login;
    $UserSession = $userSession;
    $Realm       = ucfirst( lc $realm );
  # $SessStart   = time();

    # Do any additional initialiation/setup prior to calling 
    # the 'handleInput' method as this loops until whatever
    # mechanism is used to indicate a 'session logout'.

    $class->handleInput();

    # Do any cleanup/teardown after a 'logout' has occurred.

    exit(0);
}

# FIX: cleanup this mess of package-global vars.
#
my($title, $formTextHeading, $formTextBody, $output);
my($timerHead, $timerBody);
my($button, $data, $Data) = ("","","");
my($cgi, $len);
my $filename;

sub handleInput
{   my($class) = @_;

   ## die $Local->dump('inclib');

    my $cgiWrapper = "POE::Component::PSD::Server::CGI";

    while ( 1 ) {
	# Each loop iteration is one HTTP request event cycle,
	# which reads input from the client and generates output.
	#
        $Local->resetVariables();

	$cgi = $cgiWrapper->new();             # parse new request

        print $class->genHtml( $cgi );         # generate the response

        $cgi->flushOutput();                   # send response to client

	# The 'logout' mechanism can be whatever you choose...
	# in this demo script it's clicking the 'Logout' button.
	# Just do a return here to allow any cleanup processing.
	#
	($button) = $cgi->param('Button') || $cgi->param('button') || "";
	return if ($button eq "Logout" );      # exit/Logout
    }
    ## return;
}

sub genHtml
{   my($class, $unused ) = @_;

    # When invoking multiple 'new' calls for CGI.pm, simply use
    # the original CGI.pm module and invoke 'new' on that. E.g.:
    #
    my $cgi = new CGI;            # ignore passed 'cgi wrapper' object

    # Note that "normal" CGI headers will work as expected,
    # and that both NPH and Non-NPH headers will work here:
    #
    print $cgi->header( -type => 'text/html',  -nph => 1 );


    ($button) = $cgi->param('Button')   || $cgi->param('button') ||"";
    $filename = $cgi->param('filename') ||"";
    ($data)   = $cgi->param('data')     ||"";
    $len = length( $data );

  # warn "DEBUG: Button='$button'\n";
  # warn "DEBUG: FILENAME='$filename'\n"  if $filename;

    ##warn "DEBUG: data(1) input len='$len' bytes\n";
    if ($len < 10) {
	##warn "DEBUG: data(1) input='$data'\n";
    }
	
    # Any data in the form's 'textarea' variable? If so,
    # cache a copy here so it will remain persistent.
    #
    if ($data) {
	##warn "DEBUG copying 'data' to 'Data' variable\n";
	($Data = $data);
    } elsif ($Data) {
	$data = $Data;
	$len = length( $data );
	##warn "DEBUG restoring 'data' from 'Data' variable\n";
    }

    # Simple/strange hack to load data into the form's textarea:
    # If the 'textarea' value starts with "load", load a file.
    #
    if ($data =~ /^load/) {
	$data = $class->loadData() ||"NOT LOADED";
	   ### if (! $DataLoaded);
	$DataLoaded = 1;
	## warn "DEBUG storing 'data' in 'Data' variable\n";
	($Data = $data);
    }

    ## warn "DEBUG:----------realm='$realm'-------------------\n";

    if ($button eq "Logout" ) {
	my $format  = "%d-%b-%Y %H:%M:%S";         # 21-Dec-2005 21:05:39
	my $dateStr = $DFM->time2str( $format, time() );

	### die "ABORT TEST";

	$formTextHeading = $class->formTextHeading( "logged-out" );

	$title  = "$Login - Session $$ ended at $dateStr";
	($timerHead,$timerBody) = ("","");
	$formTextBody   = "";

    } else {
	$Counter++;

	$title  = "$Login - Session $$";

	if (1) {
	    ($timerHead,$timerBody)  = $class->genTimer();
	} else {
	    ($timerHead,$timerBody) = ("","");
	}

	$formTextHeading = $class->formTextHeading( "logged-in" );

	$formTextBody = $class->formTextBody( $len );
    }

    my $formEnv = "";
    if ($button eq "Show Env" ) {
	$formEnv .= "<p><hr><pre>\n";
	foreach my $ev (sort keys %ENV) {
	    $formEnv .= "$ev = $ENV{$ev}\n";
	}
	$formEnv .= "</pre>\n";
    }

    #---------------------------------------------------------------
    # Here's where all the form text, etc is assembled and output
    # to parent (PSD session manager) and then back to Web client.

    $output = "<html>
<head>
<title> $title </title>
$timerHead
</head>
<body>
<p>
<ul>
$formTextHeading 
<p> $formTextBody
</ul>
$formEnv
</body>
</html>";

    if (0) {
	my $len = length( $output );
	$class->err2parent( "(sending $len bytes to parent)" );
    }

    return( $output );
    #---------------------------------------------------------------

    ## warn "JUST TESTING";
    ## $class->err2parent( "JUST TESTING" );
    return;
}


sub formTextHeading
{   my($class, $mode) = @_;

    my $realm   = $Realm  || $UriPath;
    my $format  = "%d-%b-%Y %H:%M:%S";         # 21-Dec-2005 21:05:39
    my $dateStr = $DFM->time2str( $format, time() );

    my $text;
    if ($mode eq "logged-in") {

	$text = "
<p>
<h2> $realm Session </h2>
<li> Session will time out in $timerBody 
<li> Logged in as user: <b>$Login</b>
<li> Access count = <b>$Counter</b> 
    &nbsp;&nbsp;&nbsp;
    Last access: $dateStr
"; # End of $text


    } elsif ($mode eq "logged-out") {

	my $clicks = PTools::String->plural( $Counter, "click","s" );
	$text = "
<h2> $Realm Session </h2>
<b>$Login</b> logged out.
Session <b>$$</b> ended at $dateStr
<br><ul><font size='-1'>
	    (After only $Counter button $clicks!)
</ul></font>
<p> <a href='$UriPath'>Restart Session</a>
<p> <a href='$MainMenuPath'>Main Menu</a>
"; # End of $text

    } else {
	$text = "Unknown 'mode': $mode";
    }
    return $text;
}


sub formTextBody
{   my($class,  $dataLength ) = @_;

    my $text = "
<form method='post' action='$UriPath' 
	    enctype='application/x-www-form-urlencoded'>

<table cellpadding='5' cellspacing='0' border='0'>
<tr>
   <td>
	<input type='submit' name='Button' value='Click Me'>
   </td>

   <td>
	<input type='submit' name='Button' value='Logout'>
   </td>

   <td>
	<input type='submit' name='Button' value='Show Env'>
   </td>
</tr>

<tr>
   <td>
	<p>
	<a href='$MainMenuPath'> Main Menu</a>
   </td>
</tr>
</table>

<p>
<table width='70%' border='1'>
<tr>
   <td>
	<textarea name='data' rows='5' cols='70'>$data</textarea>
   </td>
</tr>
<tr>
   <td>
       <font size='-2'>
       Text area contains $dataLength bytes
       </font>
   </td>
</tr>
</table>
</form>
    ";  # End of $text

    #-----------------------------------------------------------
    # How to get PHP working in Proxied result?
    my $formAddition = "
<br>
<pre>
[PHP Modules]
<?php
    \$extension_list = get_loaded_extensions();
    \$disable_msg    = '    <<---- consider removing this';
    foreach(\$extension_list as \$id => \$extension) {
	if (\$extension == 'posix') {
	    #echo(\$id .'. <b>' . \$extension . \$disable_msg . \"</b>\n    \");
	    echo('<b>' . \$extension . \$disable_msg . \"</b>\n    \");
	} else {
	    #echo(\$id .'. ' . \$extension . \"\n    \");
	    echo(\$extension . \"\n    \");
	}
    }
?>
</pre>
    ";  # End of $formAddition

    ## $text .= $formAddition;     # Not yet working.

    #-----------------------------------------------------------
    # Demo of a "file upload" form
    ##my $formUpload = "
    ##";  # End of $formAddition

    my $formUpload;
    $formUpload .= $cgi->start_multipart_form(
	-action=> $UriPath,
    );
    $formUpload .= $cgi->filefield(
	-name=> 'filename',
	-size=> 50,
    );
    $formUpload .= $cgi->submit(
	-name=> 'Button',
	-value=> 'Send File',
    );
    $formUpload .= $cgi->end_form();

    if ($filename) {
	my(@stat) = stat( $filename );
	my $fsize = $stat[7] ||"*Unknown*";
	$formUpload .= "
	<p>
	Received <b>$filename</b> (size: $fsize bytes)
	";
    }

    $text .= $formUpload;

    return $text;
}

sub loadData
{   my($class) = @_;

    my $dataFile = $Local->path('app_datdir', "LoremIpsum.dat");
    my $data;

    ## warn "DEBUG: look for '$dataFile' in '$PACK'\n";

    if (! -r $dataFile) {
	$data = "Can't read '$dataFile': $!";
    } else {
	## warn "DEBUG: loading data in '$PACK'\n";
	local(*IN);
	if (open(IN, "<$dataFile")) {
	    while(my $line = <IN>) {
		$data .= $line;
	    }
	    close(IN);
	} else {
	    $data = "Can't open '$dataFile': $!";
	}
    }
    return $data;
}

sub genTimer
{   my($class, $args) = @_;

    my $format  = "%m/%d/%Y %H:%M:%S";         # 06/02/2006 19:55:23
    my $timeout = time() + (60 * 60 * 1) + 3;  # 1 hour and 3 seconds
  # my $timeout = time() + 20;                 # DEBUG: just 20 secs
    my $dateStr = $DFM->time2str( $format, $timeout );

    my $timerHead = "
<script language='JavaScript'>
    TargetDate = '$dateStr';
 // BackColor = 'white';
 // ForeColor = 'navy';
    CountActive = true;
    CountStepper = -1;
 // DisplayFormat = '%%D%% Days, %%H%% Hours, %%M%% Minutes, %%S%% Seconds.';
 // DisplayFormat = '%%H%% Hours, %%M%% Minutes, %%S%% Seconds.';
    DisplayFormat = '%%H%%:%%M%%:%%S%%';
    FinishMessage = '<b>(Session has timed out)</b>';
</script>
";  # End of $timerHead

    my $counter_js = "/tooltest/psd/js/counter.js";
    my $timerBody = 
	"<script language='JavaScript' src='$counter_js'> </script>";
    # End of $timerBody

    return( $timerHead, $timerBody );
}
#_________________________
1; # Required by require()

__END__

