package String::Perl::Warnings;
{
  $String::Perl::Warnings::VERSION = '1.10';
}

#ABSTRACT: Determine if a string looks like a perl warning

use strict;
use warnings; # Duh >:)
use Regexp::Assemble;

require Exporter;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw(is_warning not_warning);

our $re;

{

my $lines = [
q{.+?\ \"\\x.+?\"\ does\ not\ map\ to\ Unicode},
q{.+?\ \(\.\.\.\)\ interpreted\ as\ function},
q{.+?\ argument\ is\ not\ a\ HASH\ or\ ARRAY\ element},
q{.+?\ argument\ is\ not\ a\ HASH\ or\ ARRAY\ element\ or\ a\ subroutine},
q{.+?\ argument\ is\ not\ a\ HASH\ or\ ARRAY\ element\ or\ slice},
q{.+?\ argument\ is\ not\ a\ subroutine\ name},
q{.+?\ defines\ neither\ package\ nor\ VERSION\-\-version\ check\ failed},
q{.+?\ did\ not\ return\ a\ true\ value},
q{.+?\ does\ not\ define\ .+?\:\:VERSION\-\-version\ check\ failed},
q{.+?\ failed\-\-call\ queue\ aborted},
q{.+?\ found\ where\ operator\ expected},
q{.+?\ had\ compilation\ errors},
q{.+?\ had\ compilation\ errors\.},
q{.+?\ has\ too\ many\ errors},
q{.+?\ matches\ null\ string\ many\ times},
q{.+?\ matches\ null\ string\ many\ times\ in\ regex\;},
q{.+?\ matches\ null\ string\ many\ times\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{.+?\ never\ introduced},
q{.+?\ not\ allowed\ in\ length\ fields},
q{.+?\ package\ attribute\ may\ clash\ with\ future\ reserved\ word\:\ .+?},
q{.+?\ syntax},
q{.+?\ syntax\ OK},
q{.+?\(\)\ called\ too\ early\ to\ check\ prototype},
q{.+?\(\)\ on\ unopened\ .+?},
q{.+?\(\)\ on\ unopened\ .+?\ .+?},
q{.+?\-group\ starts\ with\ a\ count},
q{.+?\:\ Command\ not\ found},
q{.+?\:\ Eval\-group\ in\ insecure\ regular\ expression},
q{.+?\:\ Eval\-group\ not\ allowed\ at\ run\ time},
q{.+?\:\ Eval\-group\ not\ allowed\ at\ runtime\,\ use\ re\ \'eval\'},
q{.+?\:\ Eval\-group\ not\ allowed\,\ use\ re\ \'eval\'},
q{.+?\:\ Expression\ syntax},
q{.+?\:\ Undefined\ variable},
q{.+?\:\ not\ found},
q{.+?etsockopt\(\)\ on\ closed\ socket\ .+?},
q{.+?seek\(\)\ on\ unopened\ file},
q{.+?seek\(\)\ on\ unopened\ filehandle},
q{500\ Server\ error},
q{5\.005\ threads\ are\ deprecated},
q{A\ sequence\ of\ multiple\ spaces\ in\ a\ charnames\ alias\ definition\ is\ deprecated},
q{A\ thread\ exited\ while\ .+?\ other\ threads\ were\ still\ running},
q{A\ thread\ exited\ while\ .+?\ threads\ were\ running},
q{Allocation\ too\ large\:\ .+?},
q{Ambiguous\ call\ resolved\ as\ CORE\:\:.+?\(\)\,\ qualify\ as\ such\ or\ use\ \&},
q{Ambiguous\ range\ in\ transliteration\ operator},
q{Ambiguous\ use\ of\ .+?\ resolved\ as\ .+?},
q{Ambiguous\ use\ of\ .+?\ resolved\ as\ operator\ .+?},
q{Ambiguous\ use\ of\ .+?\{.+?\[\.\.\.\]\}\ resolved\ to\ .+?.+?\[\.\.\.\]},
q{Ambiguous\ use\ of\ .+?\{.+?\{\.\.\.\}\}\ resolved\ to\ .+?.+?\{\.\.\.\}},
q{Ambiguous\ use\ of\ .+?\{.+?\}\ resolved\ to\ .+?.+?},
q{Ambiguous\ use\ of\ \'s\/\/le\.\.\.\'\ resolved\ as\ \'s\/\/\ le\.\.\.\'\;\ Rewrite\ as\ \'s\/\/el\'\ if\ you\ meant\ \'use\ locale\ rules\ and\ evaluate\ rhs\ as\ an\ expression\'\.\ \ In\ Perl\ 5\.16\,\ it\ will\ be\ resolved\ the\ other\ way},
q{Ambiguous\ use\ of\ \'s\/\/le\.\.\.\'\ resolved\ as\ \'s\/\/\ le\.\.\.\'\;\ Rewrite\ as\ \'s\/\/el\'\ if\ you\ meant\ \'use\ locale\ rules\ and\ evaluate\ rhs\ as\ an\ expression\'\.\ \ In\ Perl\ 5\.18\,\ it\ will\ be\ resolved\ the\ other\ way},
q{Ambiguous\ use\ of\ \-.+?\ resolved\ as\ \-\&.+?\(\)},
q{Applying\ .+?\ to\ .+?\ will\ act\ on\ scalar\(.+?\)},
q{Arg\ too\ short\ for\ msgsnd},
q{Args\ must\ match\ \#\!\ line},
q{Argument\ \".+?\"\ isn\'t\ numeric.+?},
q{Argument\ list\ not\ closed\ for\ PerlIO\ layer\ \".+?\"},
q{Array\ \@.+?\ missing\ the\ \@\ in\ argument\ .+?\ of\ .+?\(\)},
q{Assertion\ failed\:\ file\ \".+?\"},
q{Assigning\ non\-zero\ to\ \$\[\ is\ no\ longer\ possible},
q{Assignment\ to\ both\ a\ list\ and\ a\ scalar},
q{Attempt\ to\ access\ disallowed\ key\ \'.+?\'\ in\ a\ restricted\ hash},
q{Attempt\ to\ bless\ into\ a\ reference},
q{Attempt\ to\ clear\ a\ restricted\ hash},
q{Attempt\ to\ clear\ deleted\ array},
q{Attempt\ to\ delete\ disallowed\ key\ \'.+?\'\ from\ a\ restricted\ hash},
q{Attempt\ to\ delete\ readonly\ key\ \'.+?\'\ from\ a\ restricted\ hash},
q{Attempt\ to\ free\ non\-arena\ SV\:\ 0x.+?},
q{Attempt\ to\ free\ nonexistent\ shared\ string},
q{Attempt\ to\ free\ nonexistent\ shared\ string\ \'.+?\'.+?},
q{Attempt\ to\ free\ temp\ prematurely},
q{Attempt\ to\ free\ temp\ prematurely\:\ SV\ 0x.+?},
q{Attempt\ to\ free\ unreferenced\ glob\ pointers},
q{Attempt\ to\ free\ unreferenced\ scalar},
q{Attempt\ to\ free\ unreferenced\ scalar\:\ SV\ 0x.+?},
q{Attempt\ to\ join\ self},
q{Attempt\ to\ pack\ pointer\ to\ temporary\ value},
q{Attempt\ to\ reload\ .+?\ aborted\.},
q{Attempt\ to\ set\ length\ of\ freed\ array},
q{Attempt\ to\ use\ reference\ as\ lvalue\ in\ substr},
q{Attribute\ \"locked\"\ is\ deprecated},
q{Attribute\ \"unique\"\ is\ deprecated},
q{BEGIN\ failed\-\-compilation\ aborted},
q{BEGIN\ not\ safe\ after\ errors\-\-compilation\ aborted},
q{B\<\-P\>\ not\ allowed\ for\ setuid\/setgid\ script},
q{Bad\ arg\ length\ for\ .+?\,\ is\ .+?\,\ should\ be\ .+?},
q{Bad\ evalled\ substitution\ pattern},
q{Bad\ filehandle\:\ .+?},
q{Bad\ free\(\)\ ignored},
q{Bad\ hash},
q{Bad\ index\ while\ coercing\ array\ into\ hash},
q{Bad\ name\ after\ .+?},
q{Bad\ name\ after\ .+?\:\:},
q{Bad\ plugin\ affecting\ keyword\ \'.+?\'},
q{Bad\ realloc\(\)\ ignored},
q{Bad\ symbol\ for\ array},
q{Bad\ symbol\ for\ dirhandle},
q{Bad\ symbol\ for\ filehandle},
q{Bad\ symbol\ for\ hash},
q{Badly\ placed\ \(\)\'s},
q{Bareword\ \".+?\"\ not\ allowed\ while\ \"strict\ subs\"\ in\ use},
q{Bareword\ \".+?\"\ refers\ to\ nonexistent\ package},
q{Bareword\ found\ in\ conditional},
q{Binary\ number\ \>\ 0b11111111111111111111111111111111\ non\-portable},
q{Bit\ vector\ size\ \>\ 32\ non\-portable},
q{Bizarre\ SvTYPE\ \[.+?\]},
q{Bizarre\ copy\ of\ .+?},
q{Bizarre\ copy\ of\ .+?\ in\ .+?},
q{Buffer\ overflow\ in\ prime_env_iter\:\ .+?},
q{CORE\:\:.+?\ is\ not\ a\ keyword},
q{C\<\-T\>\ and\ C\<\-B\>\ not\ implemented\ on\ filehandles},
q{C\<\-p\>\ destination\:\ .+?},
q{Callback\ called\ exit},
q{Can\ only\ compress\ unsigned\ integers\ in\ pack},
q{Can\'t\ .+?\ .+?\-endian\ .+?s\ on\ this\ platform},
q{Can\'t\ \"break\"\ in\ a\ loop\ topicalizer},
q{Can\'t\ \"break\"\ outside\ a\ given\ block},
q{Can\'t\ \"continue\"\ outside\ a\ when\ block},
q{Can\'t\ \"default\"\ outside\ a\ topicalizer},
q{Can\'t\ \"goto\"\ into\ the\ middle\ of\ a\ foreach\ loop},
q{Can\'t\ \"goto\"\ out\ of\ a\ pseudo\ block},
q{Can\'t\ \"last\"\ outside\ a\ loop\ block},
q{Can\'t\ \"next\"\ outside\ a\ loop\ block},
q{Can\'t\ \"redo\"\ outside\ a\ loop\ block},
q{Can\'t\ \"when\"\ outside\ a\ topicalizer},
q{Can\'t\ bless\ non\-reference\ value},
q{Can\'t\ break\ at\ that\ line},
q{Can\'t\ call\ method\ \".+?\"\ in\ empty\ package\ \".+?\"},
q{Can\'t\ call\ method\ \".+?\"\ on\ an\ undefined\ value},
q{Can\'t\ call\ method\ \".+?\"\ on\ unblessed\ reference},
q{Can\'t\ call\ method\ \".+?\"\ without\ a\ package\ or\ object\ reference},
q{Can\'t\ chdir\ to\ .+?},
q{Can\'t\ check\ filesystem\ of\ script\ \".+?\"\ for\ nosuid},
q{Can\'t\ coerce\ .+?\ to\ .+?\ in\ .+?},
q{Can\'t\ coerce\ .+?\ to\ integer\ in\ .+?},
q{Can\'t\ coerce\ .+?\ to\ number\ in\ .+?},
q{Can\'t\ coerce\ .+?\ to\ string\ in\ .+?},
q{Can\'t\ coerce\ array\ into\ hash},
q{Can\'t\ create\ pipe\ mailbox},
q{Can\'t\ declare\ .+?\ in\ \".+?\"},
q{Can\'t\ declare\ class\ for\ non\-scalar\ .+?\ in\ \".+?\"},
q{Can\'t\ do\ \{n\,m\}\ with\ n\ \>\ m},
q{Can\'t\ do\ \{n\,m\}\ with\ n\ \>\ m\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Can\'t\ do\ \{n\,m\}\ with\ n\ \>\ m\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Can\'t\ do\ inplace\ edit\ on\ .+?\:\ .+?},
q{Can\'t\ do\ inplace\ edit\ without\ backup},
q{Can\'t\ do\ inplace\ edit\:\ .+?\ is\ not\ a\ regular\ file},
q{Can\'t\ do\ inplace\ edit\:\ .+?\ would\ not\ be\ unique},
q{Can\'t\ do\ setegid\!},
q{Can\'t\ do\ seteuid\!},
q{Can\'t\ do\ setuid},
q{Can\'t\ do\ waitpid\ with\ flags},
q{Can\'t\ emulate\ \-.+?\ on\ \#\!\ line},
q{Can\'t\ exec\ .+?},
q{Can\'t\ exec\ \".+?\"\:\ .+?},
q{Can\'t\ execute\ .+?},
q{Can\'t\ find\ .+?\ character\ property\ \".+?\"},
q{Can\'t\ find\ .+?\ on\ PATH},
q{Can\'t\ find\ .+?\ on\ PATH\,\ \'\.\'\ not\ in\ PATH},
q{Can\'t\ find\ .+?\ property\ definition\ .+?},
q{Can\'t\ find\ .+?\ property\ definition\ .+?\ },
q{Can\'t\ find\ Unicode\ property\ definition\ \".+?\"},
q{Can\'t\ find\ an\ opnumber\ for\ \".+?\"},
q{Can\'t\ find\ label\ .+?},
q{Can\'t\ find\ string\ terminator\ .+?\ anywhere\ before\ EOF},
q{Can\'t\ fork},
q{Can\'t\ fork\,\ trying\ again\ in\ 5\ seconds},
q{Can\'t\ fork\:\ .+?},
q{Can\'t\ get\ SYSGEN\ parameter\ value\ for\ MAXBUF},
q{Can\'t\ get\ filespec\ \-\ stale\ stat\ buffer\?},
q{Can\'t\ get\ pipe\ mailbox\ device\ name},
q{Can\'t\ goto\ subroutine\ from\ a\ sort\ sub\ \(or\ similar\ callback\)},
q{Can\'t\ goto\ subroutine\ from\ an\ eval\-.+?},
q{Can\'t\ goto\ subroutine\ from\ an\ eval\-string},
q{Can\'t\ goto\ subroutine\ outside\ a\ subroutine},
q{Can\'t\ ignore\ signal\ CHLD\,\ forcing\ to\ default},
q{Can\'t\ kill\ a\ non\-numeric\ process\ ID},
q{Can\'t\ linearize\ anonymous\ symbol\ table},
q{Can\'t\ load\ \'.+?\'\ for\ module\ .+?},
q{Can\'t\ localize\ lexical\ variable\ .+?},
q{Can\'t\ localize\ pseudo\-hash\ element},
q{Can\'t\ localize\ through\ a\ reference},
q{Can\'t\ locate\ .+?},
q{Can\'t\ locate\ PerlIO.+?},
q{Can\'t\ locate\ auto\/.+?\.al\ in\ \@INC},
q{Can\'t\ locate\ loadable\ object\ for\ module\ .+?\ in\ \@INC},
q{Can\'t\ locate\ object\ method\ \".+?\"\ via\ package\ \".+?\"},
q{Can\'t\ locate\ package\ .+?\ for\ \@.+?\:\:ISA},
q{Can\'t\ locate\ package\ .+?\ for\ the\ parents\ of\ .+?},
q{Can\'t\ make\ list\ assignment\ to\ \%ENV\ on\ this\ system},
q{Can\'t\ make\ list\ assignment\ to\ \\\%ENV\ on\ this\ system},
q{Can\'t\ make\ loaded\ symbols\ global\ on\ this\ platform\ while\ loading\ .+?},
q{Can\'t\ modify\ .+?\ in\ .+?},
q{Can\'t\ modify\ non\-lvalue\ subroutine\ call},
q{Can\'t\ modify\ nonexistent\ substring},
q{Can\'t\ msgrcv\ to\ read\-only\ var},
q{Can\'t\ open\ .+?},
q{Can\'t\ open\ .+?\:\ .+?},
q{Can\'t\ open\ a\ reference},
q{Can\'t\ open\ bidirectional\ pipe},
q{Can\'t\ open\ error\ file\ .+?\ as\ stderr},
q{Can\'t\ open\ input\ file\ .+?\ as\ stdin},
q{Can\'t\ open\ output\ file\ .+?\ as\ stdout},
q{Can\'t\ open\ output\ pipe\ \(name\:\ .+?\)},
q{Can\'t\ open\ perl\ script.+?},
q{Can\'t\ open\ perl\ script.+?\:\ .+?},
q{Can\'t\ open\ perl\ script\ \".+?\"\:\ .+?},
q{Can\'t\ read\ CRTL\ environ},
q{Can\'t\ redefine\ active\ sort\ subroutine\ .+?},
q{Can\'t\ remove\ .+?\:\ .+?\,\ skipping\ file},
q{Can\'t\ remove\ .+?\:\ .+?\,\ skipping\ file\ },
q{Can\'t\ rename\ .+?\ to\ .+?\:\ .+?\,\ skipping\ file},
q{Can\'t\ reopen\ input\ pipe\ \(name\:\ .+?\)\ in\ binary\ mode},
q{Can\'t\ reset\ \%ENV\ on\ this\ system},
q{Can\'t\ resolve\ method\ \".+?\"\ overloading\ \".+?\"\ in\ package\ \".+?\"},
q{Can\'t\ resolve\ method\ \`.+?\'\ overloading\ \`.+?\'\ in\ package\ \`.+?\'},
q{Can\'t\ reswap\ uid\ and\ euid},
q{Can\'t\ return\ .+?\ from\ lvalue\ subroutine},
q{Can\'t\ return\ .+?\ to\ lvalue\ scalar\ context},
q{Can\'t\ return\ outside\ a\ subroutine},
q{Can\'t\ stat\ script\ \".+?\"},
q{Can\'t\ swap\ uid\ and\ euid},
q{Can\'t\ take\ log\ of\ \%g},
q{Can\'t\ take\ sqrt\ of\ \%g},
q{Can\'t\ undef\ active\ subroutine},
q{Can\'t\ unshift},
q{Can\'t\ upgrade\ .+?\ \(.+?\)\ to\ .+?},
q{Can\'t\ upgrade\ that\ kind\ of\ scalar},
q{Can\'t\ upgrade\ to\ undef},
q{Can\'t\ use\ .+?\ for\ loop\ variable},
q{Can\'t\ use\ .+?\ ref\ as\ .+?\ ref},
q{Can\'t\ use\ \"my\ .+?\"\ in\ sort\ comparison},
q{Can\'t\ use\ \"when\"\ outside\ a\ topicalizer},
q{Can\'t\ use\ \%\!\ because\ Errno\.pm\ is\ not\ available},
q{Can\'t\ use\ \%\%\!\ because\ Errno\.pm\ is\ not\ available},
q{Can\'t\ use\ \'.+?\'\ after\ \-mname},
q{Can\'t\ use\ \'.+?\'\ in\ a\ group\ with\ different\ byte\-order\ in\ .+?},
q{Can\'t\ use\ \\.+?\ to\ mean\ \$.+?\ in\ expression},
q{Can\'t\ use\ an\ undefined\ value\ as\ .+?\ reference},
q{Can\'t\ use\ anonymous\ symbol\ table\ for\ method\ lookup},
q{Can\'t\ use\ bareword\ \(\".+?\"\)\ as\ .+?\ ref\ while\ \"strict\ refs\"\ in\ use},
q{Can\'t\ use\ both\ \'\<\'\ and\ \'\>\'\ after\ type\ \'.+?\'\ in\ .+?},
q{Can\'t\ use\ global\ .+?\ in\ \".+?\"},
q{Can\'t\ use\ global\ .+?\ in\ \"my\"},
q{Can\'t\ use\ string\ \(\".+?\"\)\ as\ .+?\ ref\ while\ \"strict\ refs\"\ in\ use},
q{Can\'t\ use\ subscript\ on\ .+?},
q{Can\'t\ weaken\ a\ nonreference},
q{Can\'t\ x\=\ to\ read\-only\ value},
q{Cannot\ compress\ integer\ in\ pack},
q{Cannot\ compress\ negative\ numbers\ in\ pack},
q{Cannot\ convert\ a\ reference\ to\ .+?\ to\ typeglob},
q{Cannot\ copy\ to\ .+?},
q{Cannot\ copy\ to\ .+?\ in\ .+?},
q{Cannot\ find\ encoding\ \".+?\"},
q{Cannot\ set\ tied\ \@DB\:\:args},
q{Cannot\ tie\ unreifiable\ array},
q{Character\ class\ \[\:.+?\:\]\ unknown},
q{Character\ class\ syntax\ \[.+?\]\ belongs\ inside\ character\ classes},
q{Character\ class\ syntax\ \[\.\ \.\]\ is\ reserved\ for\ future\ extensions},
q{Character\ class\ syntax\ \[\=\ \=\]\ is\ reserved\ for\ future\ extensions},
q{Character\ following\ \"\\c\"\ must\ be\ ASCII},
q{Character\ in\ \"C\"\ format\ wrapped},
q{Character\ in\ \"C\"\ format\ wrapped\ in\ pack},
q{Character\ in\ \"c\"\ format\ wrapped},
q{Character\ in\ \"c\"\ format\ wrapped\ in\ pack},
q{Character\ in\ \'.+?\'\ format\ wrapped\ in\ unpack},
q{Character\ in\ \'C\'\ format\ wrapped\ in\ pack},
q{Character\ in\ \'W\'\ format\ wrapped\ in\ pack},
q{Character\ in\ \'c\'\ format\ wrapped\ in\ pack},
q{Character\(s\)\ in\ \'.+?\'\ format\ wrapped\ in\ pack},
q{Character\(s\)\ in\ \'.+?\'\ format\ wrapped\ in\ unpack},
q{Cloning\ substitution\ context\ is\ unimplemented},
q{Close\ on\ unopened\ file\ \<.+?\>},
q{Closure\ prototype\ called},
q{Code\ missing\ after\ \'\/\'},
q{Code\ point\ 0x.+?\ is\ not\ Unicode\,\ all\ \\p\{\}\ matches\ fail\;\ all\ \\P\{\}\ matches\ },
q{Code\ point\ 0x.+?\ is\ not\ Unicode\,\ all\ \\p\{\}\ matches\ fail\;\ all\ \\P\{\}\ matches\ succeed},
q{Code\ point\ 0x.+?\ is\ not\ Unicode\,\ may\ not\ be\ portable},
q{Code\ point\ 0x.+?\ is\ not\ Unicode\,\ no\ properties\ match\ it\;\ all\ inverse\ properties\ do},
q{Compilation\ failed\ in\ require},
q{Complex\ regular\ subexpression\ recursion\ limit\ \(.+?\)\ exceeded},
q{Constant\ is\ not\ .+?\ reference},
q{Constant\ subroutine\ .+?\ redefined},
q{Constant\ subroutine\ .+?\ undefined},
q{Constant\(.+?\).+?\:\ .+?},
q{Constant\(.+?\).+?\:\ .+?\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Constant\(.+?\)\ unknown},
q{Constant\(.+?\)\:\ Call\ to\ \&\{\$\^H\{.+?\}\}\ did\ not\ return\ a\ defined\ value},
q{Constant\(.+?\)\:\ \$\^H\{.+?\}\ is\ not\ defined},
q{Copy\ method\ did\ not\ return\ a\ reference},
q{Corrupt\ malloc\ ptr\ 0x.+?\ at\ 0x.+?},
q{Corrupted\ regexp\ opcode\ .+?\ \>\ .+?},
q{Count\ after\ length\/code\ in\ unpack},
q{DESTROY\ created\ new\ reference\ to\ dead\ object\ \'.+?\'},
q{Deep\ recursion\ on\ anonymous\ subroutine},
q{Deep\ recursion\ on\ subroutine\ \".+?\"},
q{Delimiter\ for\ here\ document\ is\ too\ long},
q{Deprecated\ character\ in\ \\N\{\.\.\.\}\;\ marked\ by\ \<\-\-\ HERE\ \ in\ \\N\{.+?\<\-\-\ HERE\ .+?},
q{Deprecated\ character\(s\)\ in\ \\\\N\{\.\.\.\}\ starting\ at\ \'.+?\'},
q{Deprecated\ use\ of\ my\(\)\ in\ false\ conditional},
q{Did\ not\ produce\ a\ valid\ header},
q{Died},
q{Document\ contains\ no\ data},
q{Don\'t\ know\ how\ to\ handle\ magic\ of\ type\ \'.+?\'},
q{Duplicate\ free\(\)\ ignored},
q{Duplicate\ modifier\ \'.+?\'\ after\ \'.+?\'\ in\ .+?},
q{EVAL\ without\ pos\ change\ exceeded\ limit\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ },
q{EVAL\ without\ pos\ change\ exceeded\ limit\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Empty\ .+?},
q{Empty\ \\.+?\{\}\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Error\ converting\ file\ specification\ .+?},
q{Escape\ literal\ pattern\ white\ space\ under\ \/x},
q{Eval\-group\ in\ insecure\ regular\ expression},
q{Eval\-group\ not\ allowed\ at\ runtime\,\ use\ re\ \'eval\'\ in\ regex\ m\/.+?\/},
q{Eval\-group\ not\ allowed\,\ use\ re\ \'eval\'\ in\ regex\ m\/.+?\/},
q{Excessively\ long\ \<\>\ operator},
q{Execution\ of\ .+?\ aborted\ due\ to\ compilation\ errors},
q{Execution\ of\ .+?\ aborted\ due\ to\ compilation\ errors\.},
q{Exiting\ eval\ via\ .+?},
q{Exiting\ format\ via\ .+?},
q{Exiting\ pseudo\-block\ via\ .+?},
q{Exiting\ subroutine\ via\ .+?},
q{Exiting\ substitution\ via\ .+?},
q{Expecting\ close\ bracket\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Experimental\ \".+?\"\ subs\ not\ enabled},
q{Explicit\ blessing\ to\ \'\'\ \(assuming\ package\ main\)},
q{FETCHSIZE\ returned\ a\ negative\ value},
q{False\ \[\]\ range\ \".+?\"\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Fatal\ VMS\ error\ \(status\=.+?\)\ at\ .+?\,\ line\ .+?},
q{Fatal\ VMS\ error\ at\ .+?\,\ line\ .+?},
q{Field\ too\ wide\ in\ \'u\'\ format\ in\ pack},
q{Filehandle\ .+?\ never\ opened},
q{Filehandle\ .+?\ opened\ only\ for\ input},
q{Filehandle\ .+?\ opened\ only\ for\ output},
q{Filehandle\ .+?\ reopened\ as\ .+?\ only\ for\ input},
q{Filehandle\ STDIN\ reopened\ as\ .+?\ only\ for\ output},
q{Final\ \$\ should\ be\ \\\$\ or\ \$name},
q{Final\ \@\ should\ be\ \\\@\ or\ \@name},
q{Format\ .+?\ redefined},
q{Format\ not\ terminated},
q{Found\ \=\ in\ conditional\,\ should\ be\ \=\=},
q{Glob\ not\ terminated},
q{Global\ symbol\ \".+?\"\ requires\ explicit\ package\ name},
q{Got\ an\ error\ from\ DosAllocMem},
q{Goto\ undefined\ subroutine.+?},
q{Group\ name\ must\ start\ with\ a\ non\-digit\ word\ character\ in\ regex\;\ marked\ by\ },
q{Had\ to\ create\ .+?\ unexpectedly},
q{Hash\ \%.+?\ missing\ the\ \%\ in\ argument\ .+?\ of\ .+?\(\)},
q{Having\ no\ space\ between\ pattern\ and\ following\ word\ is\ deprecated},
q{Hexadecimal\ number\ \>\ 0xffffffff\ non\-portable},
q{IO\ layers\ \(like\ \".+?\"\)\ unavailable},
q{IO\ layers\ \(like\ \'.+?\'\)\ unavailable},
q{IO\:\:Socket\:\:atmark\ not\ implemented\ on\ this\ architecture},
q{Identifier\ too\ long},
q{Ignoring\ .+?\ in\ character\ class\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Ignoring\ zero\ length\ \\N\{\}\ in\ character\ class},
q{Ignoring\ zero\ length\ \\N\{\}\ in\ character\ class\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Ill\-formed\ CRTL\ environ\ value\ \".+?\"},
q{Ill\-formed\ message\ in\ prime_env_iter\:\ \|.+?\|},
q{Illegal\ binary\ digit\ .+?},
q{Illegal\ binary\ digit\ .+?\ ignored},
q{Illegal\ character\ .+?\ \(carriage\ return\)},
q{Illegal\ character\ \\\%o\ \(carriage\ return\)},
q{Illegal\ character\ after\ \'_\'\ in\ prototype\ for\ .+?\ \:\ .+?},
q{Illegal\ character\ in\ prototype\ for\ .+?\ \:\ .+?},
q{Illegal\ declaration\ of\ anonymous\ subroutine},
q{Illegal\ declaration\ of\ subroutine\ .+?},
q{Illegal\ division\ by\ zero},
q{Illegal\ hexadecimal\ digit\ .+?\ ignored},
q{Illegal\ modulus\ zero},
q{Illegal\ number\ of\ bits\ in\ vec},
q{Illegal\ octal\ digit\ .+?},
q{Illegal\ octal\ digit\ .+?\ ignored},
q{Illegal\ pattern\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Illegal\ switch\ in\ PERL5OPT\:\ .+?},
q{Illegal\ switch\ in\ PERL5OPT\:\ \-.+?},
q{In\ EBCDIC\ the\ v\-string\ components\ cannot\ exceed\ 2147483647},
q{In\ \'\(\*VERB\.\.\.\)\'\,\ splitting\ the\ initial\ \'\(\*\'\ is\ deprecated\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{In\ \'\(\?\.\.\.\)\'\,\ splitting\ the\ initial\ \'\(\?\'\ is\ deprecated\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{In\ string\,\ \@.+?\ now\ must\ be\ written\ as\ \\\@.+?},
q{Incomplete\ expression\ within\ \'\(\?\[\ \]\)\'\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Inconsistent\ hierarchy\ during\ C3\ merge\ of\ class\ \'.+?\'\:\ merging\ failed\ on\ },
q{Inconsistent\ hierarchy\ during\ C3\ merge\ of\ class\ \'.+?\'\:\ merging\ failed\ on\ parent\ \'.+?\'},
q{Infinite\ recursion\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Initialization\ of\ state\ variables\ in\ list\ context\ currently\ forbidden},
q{Insecure\ \$ENV\{.+?\}\ while\ running\ .+?},
q{Insecure\ dependency\ in\ .+?},
q{Insecure\ directory\ in\ .+?},
q{Insecure\ user\-defined\ property\ .+?},
q{Integer\ overflow\ in\ .+?\ number},
q{Integer\ overflow\ in\ format\ string\ for\ .+?},
q{Integer\ overflow\ in\ srand},
q{Integer\ overflow\ in\ version},
q{Integer\ overflow\ in\ version\ .+?},
q{Internal\ disaster\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Internal\ disaster\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Internal\ inconsistency\ in\ tracking\ vforks},
q{Internal\ urp\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Internal\ urp\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Invalid\ .+?\ attribute\:\ .+?},
q{Invalid\ .+?\ attributes\:\ .+?},
q{Invalid\ \[\]\ range\ \".+?\"\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Invalid\ \[\]\ range\ \".+?\"\ in\ transliteration\ operator},
q{Invalid\ \[\]\ range\ \"\%\*\.\*s\"\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Invalid\ character\ in\ \\N\{\.\.\.\}\;\ marked\ by\ \<\-\-\ HERE\ in\ \\N\{.+?\}},
q{Invalid\ character\ in\ charnames\ alias\ definition\;\ marked\ by\ \<\-\-\ HERE\ in\ \'.+?},
q{Invalid\ conversion\ in\ .+?\:\ \".+?\"},
q{Invalid\ escape\ in\ the\ specified\ encoding\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ },
q{Invalid\ escape\ in\ the\ specified\ encoding\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Invalid\ hexadecimal\ number\ in\ \\N\{U\+\.\.\.\}},
q{Invalid\ hexadecimal\ number\ in\ \\N\{U\+\.\.\.\}\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ },
q{Invalid\ hexadecimal\ number\ in\ \\\\N\{U\+\.\.\.\}},
q{Invalid\ module\ name\ .+?\ with\ \-.+?\ option\:\ contains\ single\ \'\:\'},
q{Invalid\ mro\ name\:\ \'.+?\'},
q{Invalid\ negative\ number\ \(.+?\)\ in\ chr},
q{Invalid\ range\ \".+?\"\ in\ transliteration\ operator},
q{Invalid\ separator\ character\ .+?\ in\ PerlIO\ layer\ specification\ .+?},
q{Invalid\ separator\ character\ .+?\ in\ attribute\ list},
q{Invalid\ strict\ version\ format\ \(.+?\)},
q{Invalid\ type\ \'.+?\'\ in\ .+?},
q{Invalid\ type\ in\ pack\:\ \'.+?\'},
q{Invalid\ type\ in\ unpack\:\ \'.+?\'},
q{Invalid\ version\ format\ \(.+?\)},
q{Invalid\ version\ format\ \(multiple\ underscores\)},
q{Invalid\ version\ format\ \(underscores\ before\ decimal\)},
q{Invalid\ version\ object},
q{Junk\ on\ end\ of\ regexp\ in\ regex\ m\/.+?\/},
q{Label\ not\ found\ for\ \"last\ .+?\"},
q{Label\ not\ found\ for\ \"next\ .+?\"},
q{Label\ not\ found\ for\ \"redo\ .+?\"},
q{Lexing\ code\ attempted\ to\ stuff\ non\-Latin\-1\ character\ into\ Latin\-1\ input},
q{Lexing\ code\ internal\ error\ \(.+?\)},
q{List\ form\ of\ piped\ open\ not\ implemented},
q{Lookbehind\ longer\ than\ .+?\ not\ implemented\ at\ \{\#\}\ mark\ in\ regex\ .+?},
q{Lookbehind\ longer\ than\ .+?\ not\ implemented\ before\ \<\<\ HERE\ .+?},
q{Lookbehind\ longer\ than\ .+?\ not\ implemented\ in\ regex\ m\/.+?\/},
q{Lookbehind\ longer\ than\ .+?\ not\ implemented\ in\ regex\;},
q{Lookbehind\ longer\ than\ .+?\ not\ implemented\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Lost\ precision\ when\ .+?\ \%f\ by\ 1},
q{Lvalue\ subs\ returning\ .+?\ not\ implemented\ yet},
q{Malformed\ PERLLIB_PREFIX},
q{Malformed\ UTF\-16\ surrogate},
q{Malformed\ UTF\-8\ character\ \(.+?\)},
q{Malformed\ UTF\-8\ character\ immediately\ after\ \'.+?\'},
q{Malformed\ UTF\-8\ returned\ by\ \\N},
q{Malformed\ UTF\-8\ returned\ by\ \\N\{.+?\}\ immediately\ after\ \'.+?\'},
q{Malformed\ UTF\-8\ string\ in\ \'.+?\'\ format\ in\ unpack},
q{Malformed\ UTF\-8\ string\ in\ pack},
q{Malformed\ UTF\-8\ string\ in\ unpack},
q{Malformed\ integer\ in\ \[\]\ in\ \ pack},
q{Malformed\ integer\ in\ \[\]\ in\ pack},
q{Malformed\ integer\ in\ \[\]\ in\ unpack},
q{Malformed\ prototype\ for\ .+?\:\ .+?},
q{Maximal\ count\ of\ pending\ signals\ \(.+?\)\ exceeded},
q{Method\ .+?\ not\ permitted},
q{Method\ for\ operation\ .+?\ not\ found\ in\ package\ .+?\ during\ blessing},
q{Might\ be\ a\ runaway\ multi\-line\ .+?\ string\ starting\ on\ line\ .+?},
q{Misplaced\ _\ in\ number},
q{Missing\ .+?brace.+?\ on\ \\N\{\}},
q{Missing\ \$\ on\ loop\ variable},
q{Missing\ argument\ in\ .+?},
q{Missing\ argument\ to\ \-.+?},
q{Missing\ braces\ on\ \\N\{\}},
q{Missing\ braces\ on\ \\N\{\}\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Missing\ braces\ on\ \\o\{\}},
q{Missing\ comma\ after\ first\ argument\ to\ .+?\ function},
q{Missing\ command\ in\ piped\ open},
q{Missing\ control\ char\ name\ in\ \\c},
q{Missing\ name\ in\ \".+?\ sub\"},
q{Missing\ name\ in\ \"my\ sub\"},
q{Missing\ right\ brace\ on\ .+?},
q{Missing\ right\ brace\ on\ \\.+?\{\}\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Missing\ right\ brace\ on\ \\N\{\}\ or\ unescaped\ left\ brace\ after\ \\N},
q{Missing\ right\ brace\ on\ \\\\N\{\}\ or\ unescaped\ left\ brace\ after\ \\\\N},
q{Missing\ right\ curly\ or\ square\ bracket},
q{Modification\ of\ a\ read\-only\ value\ attempted},
q{Modification\ of\ non\-creatable\ array\ value\ attempted\,\ .+?},
q{Modification\ of\ non\-creatable\ array\ value\ attempted\,\ subscript\ .+?},
q{Modification\ of\ non\-creatable\ hash\ value\ attempted\,\ .+?},
q{Modification\ of\ non\-creatable\ hash\ value\ attempted\,\ subscript\ \".+?\"},
q{Module\ name\ must\ be\ constant},
q{Module\ name\ required\ with\ \-.+?\ option},
q{More\ than\ one\ argument\ to\ \'.+?\'\ open},
q{More\ than\ one\ argument\ to\ open},
q{Multidimensional\ syntax\ .+?\ not\ supported},
q{NULL\ OP\ IN\ RUN},
q{NULL\ regexp\ argument},
q{NULL\ regexp\ parameter},
q{Name\ \".+?\:\:.+?\"\ used\ only\ once\:\ possible\ typo},
q{Need\ exactly\ 3\ octal\ digits\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Negative\ \'\/\'\ count\ in\ unpack},
q{Negative\ length},
q{Negative\ offset\ to\ vec\ in\ lvalue\ context},
q{Nested\ quantifiers\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Nested\ quantifiers\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Newline\ in\ left\-justified\ string\ for\ .+?},
q{No\ .+?\ allowed\ while\ running\ setuid},
q{No\ .+?\ specified\ for\ \-.+?},
q{No\ B\<\-e\>\ allowed\ in\ setuid\ scripts},
q{No\ DB\:\:DB\ routine\ defined},
q{No\ DB\:\:sub\ routine\ defined},
q{No\ DBsub\ routine},
q{No\ Perl\ script\ found\ in\ input},
q{No\ \#\!\ line},
q{No\ code\ specified\ for\ \-.+?},
q{No\ comma\ allowed\ after\ .+?},
q{No\ command\ into\ which\ to\ pipe\ on\ command\ line},
q{No\ dbm\ on\ this\ machine},
q{No\ directory\ specified\ for\ \-I},
q{No\ error\ file\ after\ 2\>\ or\ 2\>\>\ on\ command\ line},
q{No\ group\ ending\ character\ \'.+?\'\ found\ in\ template},
q{No\ input\ file\ after\ \<\ on\ command\ line},
q{No\ next\:\:method\ \'.+?\'\ found\ for\ .+?},
q{No\ output\ file\ after\ \>\ on\ command\ line},
q{No\ output\ file\ after\ \>\ or\ \>\>\ on\ command\ line},
q{No\ package\ name\ allowed\ for\ variable\ .+?\ in\ \"our\"},
q{No\ setregid\ available},
q{No\ setreuid\ available},
q{No\ space\ allowed\ after\ \-.+?},
q{No\ such\ class\ .+?},
q{No\ such\ class\ field\ \".+?\"\ in\ variable\ .+?\ of\ type\ .+?},
q{No\ such\ hook\:\ .+?},
q{No\ such\ pipe\ open},
q{No\ such\ pseudo\-hash\ field\ \".+?\"},
q{No\ such\ pseudo\-hash\ field\ \".+?\"\ in\ variable\ .+?\ of\ type\ .+?},
q{No\ such\ signal\:\ SIG.+?},
q{Non\-hex\ character\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Non\-octal\ character\ \'.+?\'\.\ \ Resolved\ as\ \".+?\"},
q{Non\-octal\ character\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Non\-string\ passed\ as\ bitmask},
q{Not\ a\ CODE\ reference},
q{Not\ a\ GLOB\ reference},
q{Not\ a\ HASH\ reference},
q{Not\ a\ SCALAR\ reference},
q{Not\ a\ format\ reference},
q{Not\ a\ perl\ script},
q{Not\ a\ subroutine\ reference},
q{Not\ a\ subroutine\ reference\ in\ overload\ table},
q{Not\ an\ ARRAY\ reference},
q{Not\ an\ unblessed\ ARRAY\ reference},
q{Not\ enough\ arguments\ for\ .+?},
q{Not\ enough\ format\ arguments},
q{Null\ filename\ used},
q{Null\ picture\ in\ formline},
q{Null\ realloc},
q{Number\ too\ long},
q{Number\ with\ no\ digits},
q{Octal\ number\ \>\ 037777777777\ non\-portable},
q{Octal\ number\ in\ vector\ unsupported},
q{Odd\ number\ of\ arguments\ for\ overload\:\:constant},
q{Odd\ number\ of\ elements\ in\ anonymous\ hash},
q{Odd\ number\ of\ elements\ in\ hash\ assignment},
q{Offset\ outside\ string},
q{Opening\ dirhandle\ .+?\ also\ as\ a\ file},
q{Opening\ filehandle\ .+?\ also\ as\ a\ directory},
q{Operand\ with\ no\ preceding\ operator\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Operation\ \".+?\"\ returns\ its\ argument\ for\ UTF\-16\ surrogate\ U\+.+?},
q{Operation\ \".+?\"\ returns\ its\ argument\ for\ non\-Unicode\ code\ point\ 0x.+?},
q{Operation\ \".+?\"\:\ no\ method\ found\,\ .+?},
q{Operation\ \`.+?\'\:\ no\ method\ found\,\ .+?},
q{Operator\ or\ semicolon\ missing\ before\ .+?},
q{Out\ of\ memory\ during\ .+?\ extend},
q{Out\ of\ memory\ during\ \"large\"\ request\ for\ .+?},
q{Out\ of\ memory\ during\ request\ for\ .+?},
q{Out\ of\ memory\ during\ ridiculously\ large\ request},
q{Out\ of\ memory\ for\ yacc\ stack},
q{Out\ of\ memory\!},
q{Overloaded\ dereference\ did\ not\ return\ a\ reference},
q{Overloaded\ qr\ did\ not\ return\ a\ REGEXP},
q{PERL_SH_DIR\ too\ long},
q{PERL_SIGNALS\ illegal\:\ \".+?\"},
q{POSIX\ \ syntax\ \[\.\ \.\]\ is\ reserved\ for\ future\ extensions},
q{POSIX\ class\ \[\:.+?\:\]\ unknown},
q{POSIX\ class\ \[\:.+?\:\]\ unknown\ in\ regex\;},
q{POSIX\ class\ \[\:.+?\:\]\ unknown\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{POSIX\ getpgrp\ can\'t\ take\ an\ argument},
q{POSIX\ syntax\ \[.+?\ .+?\]\ belongs\ inside\ character\ classes\ in\ regex\;\ marked\ by\ },
q{POSIX\ syntax\ \[.+?\]\ belongs\ inside\ character\ classes},
q{POSIX\ syntax\ \[.+?\]\ belongs\ inside\ character\ classes\ in\ regex\;},
q{POSIX\ syntax\ \[.+?\]\ belongs\ inside\ character\ classes\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{POSIX\ syntax\ \[\.\ \.\]\ is\ reserved\ for\ future\ extensions\ in\ regex\;},
q{POSIX\ syntax\ \[\.\ \.\]\ is\ reserved\ for\ future\ extensions\ in\ regex\;\ marked\ by\ },
q{POSIX\ syntax\ \[\.\ \.\]\ is\ reserved\ for\ future\ extensions\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{POSIX\ syntax\ \[\=\ \=\]\ is\ reserved\ for\ future\ extensions},
q{POSIX\ syntax\ \[\=\ \=\]\ is\ reserved\ for\ future\ extensions\ in\ regex\;},
q{POSIX\ syntax\ \[\=\ \=\]\ is\ reserved\ for\ future\ extensions\ in\ regex\;\ marked\ by\ },
q{POSIX\ syntax\ \[\=\ \=\]\ is\ reserved\ for\ future\ extensions\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{P\ must\ have\ an\ explicit\ size},
q{Parentheses\ missing\ around\ \".+?\"\ list},
q{Parsing\ code\ internal\ error\ \(.+?\)},
q{Passing\ malformed\ UTF\-8\ to\ \".+?\"\ is\ deprecated},
q{Pattern\ subroutine\ nesting\ without\ pos\ change\ exceeded\ limit\ in\ regex\;\ },
q{Pattern\ subroutine\ nesting\ without\ pos\ change\ exceeded\ limit\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Perl\ .+?\ required\ \(did\ you\ mean\ .+?\?\)\-\-this\ is\ only\ .+?\,\ stopped},
q{Perl\ .+?\ required\-\-this\ is\ only\ version\ .+?\,\ stopped},
q{Perl\ \%3\.3f\ required\-\-this\ is\ only\ version\ .+?\,\ stopped},
q{Perl\ folding\ rules\ are\ not\ up\-to\-date\ for\ 0x.+?\;\ please\ use\ the\ perlbug\ },
q{Perl\ folding\ rules\ are\ not\ up\-to\-date\ for\ 0x.+?\;\ please\ use\ the\ perlbug\ utility\ to\ report},
q{Perl_my_.+?\(\)\ not\ available},
q{Perl_pmflag\(\)\ is\ deprecated\,\ and\ will\ be\ removed\ from\ the\ XS\ API},
q{Perls\ since\ .+?\ too\ modern\-\-this\ is\ .+?\,\ stopped},
q{Permission\ denied},
q{Possible\ Y2K\ bug\:\ .+?},
q{Possible\ attempt\ to\ put\ comments\ in\ qw\(\)\ list},
q{Possible\ attempt\ to\ separate\ words\ with\ commas},
q{Possible\ memory\ corruption\:\ .+?\ overflowed\ 3rd\ argument},
q{Possible\ precedence\ problem\ on\ bitwise\ .+?\ operator},
q{Possible\ unintended\ interpolation\ of\ .+?\ in\ string},
q{Possible\ unintended\ interpolation\ of\ \$\\\ in\ regex},
q{Precedence\ problem\:\ open\ .+?\ should\ be\ open\(.+?\)},
q{Premature\ end\ of\ script\ headers},
q{Process\ terminated\ by\ SIG.+?},
q{Property\ \'.+?\'\ is\ unknown\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Prototype\ after\ \'.+?\'\ for\ .+?\ \:\ .+?},
q{Prototype\ mismatch\:\ .+?\ vs\ .+?},
q{Prototype\ not\ terminated},
q{Pseudo\-hashes\ are\ deprecated},
q{Quantifier\ \{n\,m\}\ with\ n\ \>\ m\ can\'t\ match\ in\ regex},
q{Quantifier\ \{n\,m\}\ with\ n\ \>\ m\ can\'t\ match\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Quantifier\ follows\ nothing\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Quantifier\ follows\ nothing\ in\ regex\;},
q{Quantifier\ follows\ nothing\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Quantifier\ in\ \{\,\}\ bigger\ than\ .+?\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Quantifier\ in\ \{\,\}\ bigger\ than\ .+?\ in\ regex\;},
q{Quantifier\ in\ \{\,\}\ bigger\ than\ .+?\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Quantifier\ unexpected\ on\ zero\-length\ expression\ before\ \<\<\ HERE\ .+?},
q{Quantifier\ unexpected\ on\ zero\-length\ expression\ in\ regex\;\ marked\ by\ \<\-\-\ },
q{Quantifier\ unexpected\ on\ zero\-length\ expression\;},
q{Quantifier\ unexpected\ on\ zero\-length\ expression\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Range\ iterator\ outside\ integer\ range},
q{Reallocation\ too\ large\:\ .+?},
q{Recompile\ perl\ with\ B\<\-D\>DEBUGGING\ to\ use\ B\<\-D\>\ switch},
q{Recursive\ call\ to\ Perl_load_module\ in\ PerlIO_find_layer},
q{Recursive\ inheritance\ detected\ in\ package\ \'.+?\'},
q{Recursive\ inheritance\ detected\ while\ looking\ for\ method\ .+?},
q{Recursive\ inheritance\ detected\ while\ looking\ for\ method\ \'.+?\'\ in\ package\ \'.+?\'},
q{Reference\ found\ where\ even\-sized\ list\ expected},
q{Reference\ is\ already\ weak},
q{Reference\ miscount\ in\ sv_replace\(\)},
q{Reference\ to\ invalid\ group\ 0},
q{Reference\ to\ invalid\ group\ 0\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Reference\ to\ nonexistent\ group\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Reference\ to\ nonexistent\ group\ in\ regex\;},
q{Reference\ to\ nonexistent\ group\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Reference\ to\ nonexistent\ named\ group\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Reference\ to\ nonexistent\ or\ unclosed\ group\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ },
q{Reference\ to\ nonexistent\ or\ unclosed\ group\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Regexp\ modifier\ \".+?\"\ may\ not\ appear\ after\ the\ \"\-\"},
q{Regexp\ modifier\ \".+?\"\ may\ not\ appear\ after\ the\ \"\-\"\ in\ regex\;\ marked\ by\ \<\-\-\ },
q{Regexp\ modifier\ \"\/.+?\"\ may\ appear\ a\ maximum\ of\ twice},
q{Regexp\ modifier\ \"\/.+?\"\ may\ not\ appear\ twice},
q{Regexp\ modifiers\ \"\/.+?\"\ and\ \"\/.+?\"\ are\ mutually\ exclusive},
q{Regexp\ out\ of\ space},
q{Regexp\ out\ of\ space\ in\ regex\ m\/.+?\/},
q{Repeat\ count\ in\ pack\ overflows},
q{Repeat\ count\ in\ unpack\ overflows},
q{Repeated\ format\ line\ will\ never\ terminate\ \(\~\~\ and\ \@\#\ incompatible\)},
q{Replacement\ list\ is\ longer\ than\ search\ list},
q{Reversed\ .+?\=\ operator},
q{Runaway\ format},
q{SIG.+?\ handler\ \".+?\"\ not\ defined},
q{Scalar\ value\ \@.+?\[.+?\]\ better\ written\ as\ \$.+?\[.+?\]},
q{Scalar\ value\ \@.+?\{.+?\}\ better\ written\ as\ \$.+?\{.+?\}},
q{Scalars\ leaked\:\ .+?},
q{Script\ is\ not\ setuid\/setgid\ in\ suidperl},
q{Search\ pattern\ not\ terminated},
q{Search\ pattern\ not\ terminated\ or\ ternary\ operator\ parsed\ as\ search\ pattern},
q{Self\-ties\ of\ arrays\ and\ hashes\ are\ not\ supported},
q{Semicolon\ seems\ to\ be\ missing},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ implemented},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ implemented\ before\ \<\<\ HERE\ mark\ in\ .+?},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ implemented\ in\ regex\;},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ implemented\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ recognized},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ recognized\ before\ \<\<\ HERE\ mark\ in\ .+?},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ recognized\ in\ regex\;},
q{Sequence\ \(\?.+?\.\.\.\)\ not\ recognized\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?\ incomplete},
q{Sequence\ \(\?\ incomplete\ before\ \<\<\ HERE\ mark\ in\ regex\ m\/.+?\/},
q{Sequence\ \(\?\ incomplete\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?\#\.\.\.\ not\ terminated},
q{Sequence\ \(\?\#\.\.\.\ not\ terminated\ in\ regex\ m\/.+?\/},
q{Sequence\ \(\?\#\.\.\.\ not\ terminated\ in\ regex\;},
q{Sequence\ \(\?\#\.\.\.\ not\ terminated\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?\{\.\.\.\}\)\ not\ terminated\ or\ not\ \{\}\-balanced\ in\ .+?},
q{Sequence\ \(\?\{\.\.\.\}\)\ not\ terminated\ or\ not\ \{\}\-balanced\ in\ regex\;},
q{Sequence\ \(\?\{\.\.\.\}\)\ not\ terminated\ or\ not\ \{\}\-balanced\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \(\?\{\.\.\.\}\)\ not\ terminated\ with\ \'\)\'},
q{Sequence\ \\.+?\.\.\.\ not\ terminated\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Sequence\ \\\\.+?\.\.\.\ not\ terminated\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Server\ error},
q{Setuid\ script\ not\ plain\ file},
q{Setuid\/gid\ script\ is\ writable\ by\ world},
q{Slab\ leaked\ from\ cv\ \%p},
q{Smart\ matching\ a\ non\-overloaded\ object\ breaks\ encapsulation},
q{Smartmatch\ is\ experimental},
q{Sort\ subroutine\ didn\'t\ return\ a\ numeric\ value},
q{Sort\ subroutine\ didn\'t\ return\ single\ value},
q{Source\ filters\ apply\ only\ to\ byte\ streams},
q{Split\ loop},
q{Stat\ on\ unopened\ file\ \<.+?\>},
q{Statement\ unlikely\ to\ be\ reached},
q{Strange\ \*\+\?\{\}\ on\ zero\-length\ expression},
q{Strings\ with\ code\ points\ over\ 0xFF\ may\ not\ be\ mapped\ into\ in\-memory\ file\ handles},
q{Stub\ found\ while\ resolving\ method\ \".+?\"\ overloading\ \".+?\"},
q{Stub\ found\ while\ resolving\ method\ \".+?\"\ overloading\ \".+?\"\ in\ package\ \".+?\"},
q{Stub\ found\ while\ resolving\ method\ \`.+?\'\ overloading\ .+?},
q{Stub\ found\ while\ resolving\ method\ \`.+?\'\ overloading\ \`.+?\'\ in\ package\ \`.+?\'},
q{Subroutine\ .+?\ redefined},
q{Subroutine\ \"\&.+?\"\ is\ not\ available},
q{Substitution\ loop},
q{Substitution\ pattern\ not\ terminated},
q{Substitution\ replacement\ not\ terminated},
q{Switch\ \(\?\(condition\)\.\.\.\ contains\ too\ many\ branches\ before\ \<\<\ HE.+?},
q{Switch\ \(\?\(condition\)\.\.\.\ contains\ too\ many\ branches\ in\ regex\;},
q{Switch\ \(\?\(condition\)\.\.\.\ contains\ too\ many\ branches\ in\ regex\;\ marked\ by\ },
q{Switch\ \(\?\(condition\)\.\.\.\ contains\ too\ many\ branches\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Switch\ condition\ not\ recognized\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Switch\ condition\ not\ recognized\ in\ regex\;},
q{Switch\ condition\ not\ recognized\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Syntax\ error\ in\ \(\?\[\.\.\.\]\)\ in\ regex\ m\/.+?\/},
q{System\ V\ .+?\ is\ not\ implemented\ on\ this\ machine},
q{Target\ of\ goto\ is\ too\ deeply\ nested},
q{Test\ on\ unopened\ file\ \<.+?\>},
q{That\ use\ of\ \$\[\ is\ unsupported},
q{The\ .+?\ feature\ is\ experimental},
q{The\ .+?\ function\ is\ unimplemented},
q{The\ \'unique\'\ attribute\ may\ only\ be\ applied\ to\ \'our\'\ variables},
q{The\ crypt\(\)\ function\ is\ unimplemented\ due\ to\ excessive\ paranoia},
q{The\ crypt\(\)\ function\ is\ unimplemented\ due\ to\ excessive\ paranoia\.},
q{The\ lexical_subs\ feature\ is\ experimental},
q{The\ regex_sets\ feature\ is\ experimental},
q{The\ stat\ preceding\ .+?\ wasn\'t\ an\ lstat},
q{The\ stat\ preceding\ C\<\-l\ _\>\ wasn\'t\ an\ lstat},
q{This\ Perl\ can\'t\ reset\ CRTL\ environ\ elements\ \(.+?\)},
q{This\ Perl\ can\'t\ set\ CRTL\ environ\ elements\ \(.+?\=.+?\)},
q{This\ Perl\ has\ not\ been\ built\ with\ support\ for\ randomized\ hash\ key\ traversal\ but\ something\ called\ Perl_hv_rand_set\(\)\.},
q{Tied\ variable\ freed\ while\ still\ in\ use},
q{To.+?\:\ illegal\ mapping\ \'.+?\'},
q{Too\ deeply\ nested\ \(\)\-groups},
q{Too\ few\ args\ to\ syscall},
q{Too\ late\ for\ \"B\<\-T\>\"\ option},
q{Too\ late\ for\ \"\-.+?\"\ option},
q{Too\ late\ to\ run\ .+?\ block},
q{Too\ many\ \(\'s},
q{Too\ many\ \)\'s},
q{Too\ many\ args\ to\ syscall},
q{Too\ many\ arguments\ for\ .+?},
q{Trailing\ \\\ in\ regex\ m\/.+?\/},
q{Trailing\ white\-space\ in\ a\ charnames\ alias\ definition\ is\ deprecated},
q{Transliteration\ pattern\ not\ terminated},
q{Transliteration\ replacement\ not\ terminated},
q{Type\ of\ arg\ .+?\ to\ .+?\ must\ be\ .+?\ \(not\ .+?\)},
q{Type\ of\ arg\ .+?\ to\ \&CORE\:\:.+?\ must\ be\ .+?},
q{Type\ of\ argument\ to\ .+?\ must\ be\ unblessed\ hashref\ or\ arrayref},
q{UTF\-16\ surrogate\ .+?},
q{UTF\-16\ surrogate\ U\+.+?},
q{Unable\ to\ create\ sub\ named\ \".+?\"},
q{Unbalanced\ context\:\ .+?\ more\ PUSHes\ than\ POPs},
q{Unbalanced\ saves\:\ .+?\ more\ saves\ than\ restores},
q{Unbalanced\ scopes\:\ .+?\ more\ ENTERs\ than\ LEAVEs},
q{Unbalanced\ string\ table\ refcount\:\ \(.+?\)\ for\ \".+?\"},
q{Unbalanced\ tmps\:\ .+?\ more\ allocs\ than\ frees},
q{Undefined\ format\ \".+?\"\ called},
q{Undefined\ sort\ subroutine\ \".+?\"\ called},
q{Undefined\ subroutine\ \&.+?\ called},
q{Undefined\ subroutine\ called},
q{Undefined\ subroutine\ in\ sort},
q{Undefined\ top\ format\ \".+?\"\ called},
q{Undefined\ value\ assigned\ to\ typeglob},
q{Unexpected\ \'\(\'\ with\ no\ preceding\ operator\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unexpected\ \'\)\'\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unexpected\ binary\ operator\ \'.+?\'\ with\ no\ preceding\ operand\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unexpected\ character\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unexpected\ constant\ lvalue\ entersub\ entry\ via\ type\/targ\ .+?\:.+?},
q{Unicode\ character\ .+?\ is\ illegal},
q{Unicode\ non\-character\ .+?\ is\ illegal\ for\ interchange},
q{Unicode\ non\-character\ U\+.+?\ is\ illegal\ for\ open\ interchange},
q{Unicode\ surrogate\ U\+.+?\ is\ illegal\ in\ UTF\-8},
q{Unknown\ BYTEORDER},
q{Unknown\ PerlIO\ layer\ \".+?\"},
q{Unknown\ Unicode\ option\ letter\ \'.+?\'},
q{Unknown\ Unicode\ option\ value\ .+?},
q{Unknown\ \"re\"\ subpragma\ \'.+?\'\ \(known\ ones\ are\:\ .+?\)},
q{Unknown\ charname\ \'.+?\'},
q{Unknown\ error},
q{Unknown\ open\(\)\ mode\ \'.+?\'},
q{Unknown\ process\ .+?\ sent\ message\ to\ prime_env_iter\:\ .+?},
q{Unknown\ regex\ modifier\ \".+?\"},
q{Unknown\ switch\ condition\ \(\?\(.+?\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unknown\ switch\ condition\ \(\?\(\%\.2s\ before\ \<\<\ HERE\ in\ regex\ m\/.+?\/},
q{Unknown\ switch\ condition\ \(\?\(\%\.2s\ in\ regex\;},
q{Unknown\ switch\ condition\ \(\?\(\%\.2s\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unknown\ verb\ pattern\ \'.+?\'\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unknown\ warnings\ category\ \'.+?\'},
q{Unmatched\ \'.+?\'\ in\ POSIX\ class\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unmatched\ \'\[\'\ in\ POSIX\ class\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unmatched\ \(\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unmatched\ \)\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unmatched\ \[\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unmatched\ right\ .+?\ bracket},
q{Unquoted\ string\ \".+?\"\ may\ clash\ with\ future\ reserved\ word},
q{Unrecognized\ character\ .+?},
q{Unrecognized\ character\ .+?\ in\ column\ .+?},
q{Unrecognized\ character\ .+?\;\ marked\ by\ \<\-\-\ HERE\ after\ .+?\ near\ column\ .+?},
q{Unrecognized\ escape\ \\.+?\ in\ character\ class\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unrecognized\ escape\ \\.+?\ in\ character\ class\ passed\ through\ in\ regex\;\ },
q{Unrecognized\ escape\ \\.+?\ in\ character\ class\ passed\ through\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unrecognized\ escape\ \\.+?\ passed\ through},
q{Unrecognized\ escape\ \\.+?\ passed\ through\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unrecognized\ escape\ \\\\.+?\ in\ character\ class\ passed\ through\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unrecognized\ escape\ \\\\.+?\ passed\ through},
q{Unrecognized\ escape\ \\\\.+?\ passed\ through\ before\ \<\<\ HERE\ in\ m\/.+?\/},
q{Unrecognized\ escape\ \\\\.+?\ passed\ through\ in\ regex\;},
q{Unrecognized\ escape\ \\\\.+?\ passed\ through\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unrecognized\ signal\ name\ \".+?\"},
q{Unrecognized\ switch\:\ \-.+?\ \ \(\-h\ will\ show\ valid\ options\)},
q{Unsuccessful\ .+?\ on\ filename\ containing\ newline},
q{Unsupported\ directory\ function\ \".+?\"\ called},
q{Unsupported\ function\ .+?},
q{Unsupported\ function\ fork},
q{Unsupported\ script\ encoding},
q{Unsupported\ script\ encoding\ .+?},
q{Unsupported\ socket\ function\ \".+?\"\ called},
q{Unterminated\ \<\>\ operator},
q{Unterminated\ \\g\{\.\.\.\}\ pattern\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unterminated\ attribute\ list},
q{Unterminated\ attribute\ parameter\ in\ attribute\ list},
q{Unterminated\ compressed\ integer},
q{Unterminated\ delimiter\ for\ here\ document},
q{Unterminated\ verb\ pattern\ argument\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Unterminated\ verb\ pattern\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Usage\:\ POSIX\:\:.+?\(.+?\)},
q{Usage\:\ Win32\:\:.+?\(.+?\)},
q{Use\ \\\\x\{\.\.\.\}\ for\ more\ than\ two\ hex\ characters\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Use\ of\ .+?\ in\ printf\ format\ not\ supported},
q{Use\ of\ .+?\ is\ deprecated},
q{Use\ of\ .+?\ on\ a\ handle\ without\ \*\ is\ deprecated},
q{Use\ of\ \"goto\"\ to\ jump\ into\ a\ construct\ is\ deprecated},
q{Use\ of\ \"package\"\ with\ no\ arguments\ is\ deprecated},
q{Use\ of\ \$\#\ is\ deprecated},
q{Use\ of\ \$\*\ is\ deprecated},
q{Use\ of\ \*glob\{FILEHANDLE\}\ is\ deprecated},
q{Use\ of\ \-l\ on\ filehandle\ .+?},
q{Use\ of\ \/c\ modifier\ is\ meaningless\ in\ s\/\/\/},
q{Use\ of\ \/c\ modifier\ is\ meaningless\ without\ \/g},
q{Use\ of\ \/g\ modifier\ is\ meaningless\ in\ split},
q{Use\ of\ \:\=\ for\ an\ empty\ attribute\ list\ is\ deprecated},
q{Use\ of\ \:\=\ for\ an\ empty\ attribute\ list\ is\ not\ allowed},
q{Use\ of\ \?PATTERN\?\ without\ explicit\ operator\ is\ deprecated},
q{Use\ of\ assignment\ to\ \$\[\ is\ deprecated},
q{Use\ of\ bare\ \<\<\ to\ mean\ \<\<\"\"\ is\ deprecated},
q{Use\ of\ chdir\(\'\'\)\ or\ chdir\(undef\)\ as\ chdir\(\)\ deprecated},
q{Use\ of\ comma\-less\ variable\ list\ is\ deprecated},
q{Use\ of\ each\(\)\ on\ hash\ after\ insertion\ without\ resetting\ hash\ iterator\ results\ in\ undefined\ behavior},
q{Use\ of\ freed\ value\ in\ iteration},
q{Use\ of\ implicit\ split\ to\ \@_\ is\ deprecated},
q{Use\ of\ inherited\ AUTOLOAD\ for\ non\-method\ .+?\(\)\ is\ deprecated},
q{Use\ of\ my\ \$_\ is\ experimental},
q{Use\ of\ octal\ value\ above\ 377\ is\ deprecated},
q{Use\ of\ qw\(\.\.\.\)\ as\ parentheses\ is\ deprecated},
q{Use\ of\ reference\ \".+?\"\ as\ array\ index},
q{Use\ of\ reserved\ word\ \".+?\"\ is\ deprecated},
q{Use\ of\ state\ \$_\ is\ experimental},
q{Use\ of\ tainted\ arguments\ in\ .+?\ is\ deprecated},
q{Use\ of\ uninitialized\ value.+?},
q{Useless\ \(.+?.+?\)\ \-\ .+?use\ \/.+?\ modifier\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Useless\ \(.+?c\)\ \-\ .+?use\ \/gc\ modifier\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Useless\ \(\?.+?\)\ \-\ use\ \/.+?\ modifier\ in\ regex\;},
q{Useless\ \(\?.+?\)\ \-\ use\ \/.+?\ modifier\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Useless\ \(\?\-.+?\)\ \-\ don\'t\ use\ \/.+?\ modifier\ in\ regex\;},
q{Useless\ \(\?\-.+?\)\ \-\ don\'t\ use\ \/.+?\ modifier\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ },
q{Useless\ \(\?\-.+?\)\ \-\ don\'t\ use\ \/.+?\ modifier\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Useless\ assignment\ to\ a\ temporary},
q{Useless\ localization\ of\ .+?},
q{Useless\ use\ of\ .+?\ in\ void\ context},
q{Useless\ use\ of\ .+?\ with\ no\ values},
q{Useless\ use\ of\ \"re\"\ pragma},
q{Useless\ use\ of\ \'\\\'\;\ doesn\'t\ escape\ metacharacter\ \'.+?\'},
q{Useless\ use\ of\ \(\?\-p\)\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Useless\ use\ of\ \/d\ modifier\ in\ transliteration\ operator},
q{Useless\ use\ of\ \\E},
q{Useless\ use\ of\ sort\ in\ scalar\ context},
q{User\-defined\ case\-mapping\ \'.+?\'\ is\ deprecated},
q{Using\ \!\~\ with\ .+?\ doesn\'t\ make\ sense},
q{Using\ a\ hash\ as\ a\ reference\ is\ deprecated},
q{Using\ an\ array\ as\ a\ reference\ is\ deprecated},
q{Using\ just\ the\ first\ character\ returned\ by\ \\N\{\}\ in\ character\ class},
q{Using\ just\ the\ first\ character\ returned\ by\ \\N\{\}\ in\ character\ class\ in\ },
q{Using\ just\ the\ first\ characters\ returned\ by\ \\N\{\}},
q{Value\ of\ .+?\ can\ be\ \"0\"\;\ test\ with\ defined\(\)},
q{Value\ of\ CLI\ symbol\ \".+?\"\ too\ long},
q{Variable\ \".+?\"\ is\ not\ available},
q{Variable\ \".+?\"\ is\ not\ imported.+?},
q{Variable\ \".+?\"\ may\ be\ unavailable},
q{Variable\ \".+?\"\ will\ not\ stay\ shared},
q{Variable\ length\ lookbehind\ not\ implemented\ before\ \<\<\ HERE\ in\ .+?},
q{Variable\ length\ lookbehind\ not\ implemented\ in\ m\/.+?\/},
q{Variable\ length\ lookbehind\ not\ implemented\ in\ regex\ m\/.+?\/},
q{Variable\ length\ lookbehind\ not\ implemented\ in\ regex\;},
q{Variable\ length\ lookbehind\ not\ implemented\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{Variable\ syntax},
q{Verb\ pattern\ \'.+?\'\ has\ a\ mandatory\ argument\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ },
q{Verb\ pattern\ \'.+?\'\ has\ a\ mandatory\ argument\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/\ },
q{Verb\ pattern\ \'.+?\'\ may\ not\ have\ an\ argument\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ },
q{Verb\ pattern\ \'.+?\'\ may\ not\ have\ an\ argument\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/\ },
q{Version\ number\ must\ be\ a\ constant\ number},
q{Version\ string\ \'.+?\'\ contains\ invalid\ data\;\ ignoring\:\ \'.+?\'},
q{Warning\:\ Use\ of\ \".+?\"\ without\ parentheses\ is\ ambiguous},
q{Warning\:\ something\'s\ wrong},
q{Warning\:\ unable\ to\ close\ filehandle\ .+?\ properly},
q{Wide\ character\ in\ .+?},
q{Within\ \[\]\-length\ \'.+?\'\ not\ allowed},
q{X\ outside\ of\ string},
q{Xsub\ \".+?\"\ called\ in\ sort},
q{Xsub\ called\ in\ sort},
q{YOU\ HAVEN\'T\ DISABLED\ SET\-ID\ SCRIPTS\ IN\ THE\ KERNEL\ YET\!},
q{You\ can\'t\ use\ C\<\-l\>\ on\ a\ filehandle},
q{You\ need\ to\ quote\ \".+?\"},
q{Your\ random\ numbers\ are\ not\ that\ random},
q{Z\<\>500\ Server\ error},
q{\!\=\~\ should\ be\ \!\~},
q{\".+?\"\ may\ clash\ with\ future\ reserved\ word},
q{\".+?\"\ subroutine\ \&.+?\ masks\ earlier\ declaration\ in\ same\ .+?},
q{\".+?\"\ variable\ .+?\ can\'t\ be\ in\ a\ package},
q{\".+?\"\ variable\ .+?\ masks\ earlier\ declaration\ in\ same\ .+?},
q{\"\-T\"\ is\ on\ the\ \#\!\ line\,\ it\ must\ also\ be\ used\ on\ the\ command\ line},
q{\"\\B\{\"\ is\ deprecated\;\ use\ \"\\B\\\{\"\ instead},
q{\"\\B\{\"\ is\ deprecated\;\ use\ \"\\B\\\{\"\ or\ \"\\B\[\{\]\"\ instead\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{\"\\b\{\"\ is\ deprecated\;\ use\ \"\\b\\\{\"\ instead},
q{\"\\b\{\"\ is\ deprecated\;\ use\ \"\\b\\\{\"\ or\ \"\\b\[\{\]\"\ instead\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{\"\\c.+?\"\ is\ more\ clearly\ written\ simply\ as\ \".+?\"},
#q{\"\\c\{\"\ is\ deprecated\ and\ is\ more\ clearly\ written\ as\ \"\;\"}, # seriously this is nonsense
q{\"my\ .+?\"\ used\ in\ sort\ comparison},
q{\"my\ sub\"\ not\ yet\ implemented},
q{\"my\"\ variable\ .+?\ can\'t\ be\ in\ a\ package},
q{\"no\"\ not\ allowed\ in\ expression},
q{\"our\"\ variable\ .+?\ redeclared},
q{\"state\ .+?\"\ used\ in\ sort\ comparison},
q{\"state\"\ variable\ .+?\ can\'t\ be\ in\ a\ package},
q{\"use\"\ not\ allowed\ in\ expression},
q{\$\#\ is\ no\ longer\ supported},
q{\$\*\ is\ no\ longer\ supported},
q{\$\[\ used\ in\ .+?\ \(did\ you\ mean\ \$\]\ \?\)},
q{\%ENV\ is\ aliased\ to\ .+?},
q{\%\ may\ not\ be\ used\ in\ pack},
q{\%\ may\ only\ be\ used\ in\ unpack},
q{\&CORE\:\:.+?\ cannot\ be\ called\ directly},
q{\'.+?\'\ allowed\ only\ after\ types\ .+?},
q{\'.+?\'\ is\ not\ a\ code\ reference},
q{\'.+?\'\ is\ not\ an\ overloadable\ type},
q{\'.+?\'\ resolved\ to\ \'\\o\{.+?\}.+?\'},
q{\'.+?\'\ trapped\ by\ operation\ mask},
q{\'P\'\ must\ have\ an\ explicit\ size\ in\ unpack},
q{\'X\'\ outside\ of\ string},
q{\'\!\'\ allowed\ only\ after\ types\ .+?},
q{\'\%\'\ may\ not\ be\ used\ in\ pack},
q{\'\.\'\ outside\ of\ string\ in\ pack},
q{\'\/\'\ does\ not\ take\ a\ repeat\ count},
q{\'\/\'\ must\ be\ followed\ by\ \'a\*\'\,\ \'A\*\'\ or\ \'Z\*\'},
q{\'\/\'\ must\ follow\ a\ numeric\ type\ in\ unpack},
q{\'\@\'\ outside\ of\ string\ in\ unpack},
q{\'\@\'\ outside\ of\ string\ with\ malformed\ UTF\-8\ in\ unpack},
q{\'\|\'\ and\ \'\<\'\ may\ not\ both\ be\ specified\ on\ command\ line},
q{\'\|\'\ and\ \'\>\'\ may\ not\ both\ be\ specified\ on\ command\ line},
q{\'x\'\ outside\ of\ string\ in\ unpack},
q{\(Did\ you\ mean\ \"local\"\ instead\ of\ \"our\"\?\)},
q{\(Did\ you\ mean\ \$\ or\ \@\ instead\ of\ \%\?\)},
q{\(Did\ you\ mean\ \&.+?\ instead\?\)},
q{\(Do\ you\ need\ to\ predeclare\ .+?\?\)},
q{\(Missing\ operator\ before\ .+?\?\)},
q{\(Missing\ semicolon\ on\ previous\ line\?\)},
q{\(\)\-group\ starts\ with\ a\ count},
q{\(\?\(DEFINE\)\.\.\.\.\)\ does\ not\ allow\ branches\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ },
q{\(\?\(DEFINE\)\.\.\.\.\)\ does\ not\ allow\ branches\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{\(\?\[\.\.\.\]\)\ not\ valid\ in\ locale\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{\(in\ cleanup\)\ .+?},
q{\(perhaps\ you\ forgot\ to\ load\ \".+?\"\?\)},
q{\-.+?\ on\ unopened\ filehandle\ .+?},
q{\-i\ used\ with\ no\ filenames\ on\ the\ command\ line\,\ reading\ from\ STDIN},
q{\/.+?\/\ should\ probably\ be\ written\ as\ \".+?\"},
q{\/.+?\/\:\ Unrecognized\ escape\ \\\\.+?\ in\ character\ class\ passed\ through},
q{\/.+?\/\:\ Unrecognized\ escape\ \\\\.+?\ passed\ through},
q{\/\ cannot\ take\ a\ count},
q{\/\ must\ be\ followed\ by\ a\*\,\ A\*\ or\ Z\*},
q{\/\ must\ be\ followed\ by\ a\,\ A\ or\ Z},
q{\/\ must\ follow\ a\ numeric\ type},
q{\<\>\ should\ be\ quotes},
q{\?\+\*\ follows\ nothing\ in\ regexp},
q{\@\ outside\ of\ string},
q{\\1\ better\ written\ as\ \$1},
q{\\N\ in\ a\ character\ class\ must\ be\ a\ named\ character\:\ \\N\{\.\.\.\}},
q{\\N\ in\ a\ character\ class\ must\ be\ a\ named\ character\:\ \\N\{\.\.\.\}\ in\ regex\;\ },
q{\\N\{NAME\}\ must\ be\ resolved\ by\ the\ lexer},
q{\\N\{NAME\}\ must\ be\ resolved\ by\ the\ lexer\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{\\\\N\ in\ a\ character\ class\ must\ be\ a\ named\ character\:\ \\\\N\{\.\.\.\}},
q{\\\\N\{NAME\}\ must\ be\ resolved\ by\ the\ lexer},
q{\\p\{\}\ uses\ Unicode\ rules\,\ not\ locale\ rules},
q{\`.+?\'\ is\ not\ a\ code\ reference},
q{\`.+?\'\ is\ not\ an\ overloadable\ type},
q{accept\(\)\ on\ closed\ socket\ .+?},
q{assertion\ botched\:\ .+?},
q{av_reify\ called\ on\ tied\ array},
q{bind\(\)\ on\ closed\ socket\ .+?},
q{binmode\(\)\ on\ closed\ filehandle\ .+?},
q{chmod\(\)\ mode\ argument\ is\ missing\ initial\ 0},
q{close\(\)\ on\ unopened\ filehandle\ .+?},
q{closedir\(\)\ attempted\ on\ invalid\ dirhandle\ .+?},
q{cond_broadcast\(\)\ called\ on\ unlocked\ variable},
q{cond_signal\(\)\ called\ on\ unlocked\ variable},
q{connect\(\)\ on\ closed\ socket\ .+?},
q{constant\(.+?\)\:\ .+?},
q{corrupted\ regexp\ pointers},
q{corrupted\ regexp\ program},
q{defined\(\%hash\)\ is\ deprecated},
q{defined\(\@array\)\ is\ deprecated},
q{do_study\:\ out\ of\ memory},
q{dump\ is\ not\ supported},
q{dump\(\)\ better\ written\ as\ CORE\:\:dump\(\)},
q{elseif\ should\ be\ elsif},
q{entering\ effective\ .+?\ failed},
q{exec\?\ I\'m\ not\ \*that\*\ kind\ of\ operating\ system},
q{false\ \[\]\ range\ \".+?\"\ in\ regexp},
q{fcntl\ is\ not\ implemented},
q{flock\(\)\ on\ closed\ filehandle\ .+?},
q{gdbm\ store\ returned\ .+?\,\ errno\ .+?\,\ key\ \".+?\"},
q{get.+?name\(\)\ on\ closed\ socket\ .+?},
q{gethostent\ not\ implemented},
q{getpwnam\ returned\ invalid\ UIC\ \%\#o\ for\ user\ \".+?\"},
q{getsockopt\(\)\ on\ closed\ socket\ .+?},
q{given\ is\ experimental},
q{glob\ failed\ \(.+?\)},
q{gmtime\(\%\.0f\)\ too\ large},
q{gmtime\(\%\.0f\)\ too\ small},
q{gmtime\(\%f\)\ too\ large},
q{gmtime\(\%f\)\ too\ small},
q{goto\ must\ have\ label},
q{internal\ disaster\ in\ regexp},
q{internal\ urp\ in\ regexp\ at\ \/.+?\/},
q{invalid\ \[\]\ range\ \".+?\"\ in\ regexp},
q{invalid\ option\ \-D.+?\,\ use\ \-D\'\'\ to\ see\ choices},
q{ioctl\ is\ not\ implemented},
q{ioctl\(\)\ on\ unopened\ .+?},
q{junk\ on\ end\ of\ regexp},
q{leaving\ effective\ .+?\ failed},
q{length\(\)\ used\ on\ .+?},
q{length\/code\ after\ end\ of\ string\ in\ unpack},
q{listen\(\)\ on\ closed\ socket\ .+?},
q{localtime\(\%\.0f\)\ too\ large},
q{localtime\(\%\.0f\)\ too\ small},
q{localtime\(\%f\)\ too\ large},
q{localtime\(\%f\)\ too\ small},
q{lstat\(\)\ on\ filehandle.+?},
q{lstat\(\)\ on\ filehandle\ .+?},
q{lvalue\ attribute\ .+?\ already\-defined\ subroutine},
q{lvalue\ attribute\ ignored\ after\ the\ subroutine\ has\ been\ defined},
q{msg.+?\ not\ implemented},
q{nested\ \*\?\+\ in\ regexp},
q{next\:\:method\/next\:\:can\/maybe\:\:next\:\:method\ cannot\ find\ enclosing\ method},
q{no\ UTC\ offset\ information\;\ assuming\ local\ time\ is\ UTC},
q{oops\:\ oopsAV},
q{oops\:\ oopsHV},
q{overload\ arg\ \'.+?\'\ is\ invalid},
q{pack\/unpack\ repeat\ count\ overflow},
q{page\ overflow},
q{panic\:\ .+?},
q{panic\:\ Devel\:\:DProf\ inconsistent\ subroutine\ return},
q{panic\:\ INTERPCASEMOD},
q{panic\:\ INTERPCASEMOD\,\ .+?},
q{panic\:\ INTERPCONCAT},
q{panic\:\ INTERPCONCAT\,\ .+?},
q{panic\:\ Sequence\ \(\?\{\.\.\.\}\)\:\ no\ code\ block\ found},
q{panic\:\ array\ extend},
q{panic\:\ attempt\ to\ call\ .+?\ in\ .+?},
q{panic\:\ child\ pseudo\-process\ was\ never\ scheduled},
q{panic\:\ ck_grep},
q{panic\:\ ck_grep\,\ type\=.+?},
q{panic\:\ ck_split},
q{panic\:\ ck_split\,\ type\=.+?},
q{panic\:\ corrupt\ saved\ stack\ index},
q{panic\:\ corrupt\ saved\ stack\ index\ \%ld},
q{panic\:\ del_backref},
q{panic\:\ die\ .+?},
q{panic\:\ do_match},
q{panic\:\ do_split},
q{panic\:\ do_subst},
q{panic\:\ do_trans},
q{panic\:\ do_trans_.+?},
q{panic\:\ fold_constants\ JMPENV_PUSH\ returned\ .+?},
q{panic\:\ frexp},
q{panic\:\ goto},
q{panic\:\ goto\,\ type\=.+?\,\ ix\=\%ld},
q{panic\:\ gp_free\ failed\ to\ free\ glob\ pointer},
q{panic\:\ hfreeentries\ failed\ to\ free\ hash},
q{panic\:\ kid\ popen\ errno\ read},
q{panic\:\ last},
q{panic\:\ last\,\ type\=.+?},
q{panic\:\ leave_scope\ clearsv},
q{panic\:\ leave_scope\ inconsistency},
q{panic\:\ leave_scope\ inconsistency\ .+?},
q{panic\:\ list\ extend},
q{panic\:\ magic_killbackrefs},
q{panic\:\ malloc},
q{panic\:\ malloc\,\ .+?},
q{panic\:\ mapstart},
q{panic\:\ memory\ wrap},
q{panic\:\ null\ array},
q{panic\:\ pad_alloc},
q{panic\:\ pad_alloc\,\ \%p\!\=\%p},
q{panic\:\ pad_free\ curpad},
q{panic\:\ pad_free\ curpad\,\ \%p\!\=\%p},
q{panic\:\ pad_free\ po},
q{panic\:\ pad_reset\ curpad},
q{panic\:\ pad_reset\ curpad\,\ \%p\!\=\%p},
q{panic\:\ pad_sv\ po},
q{panic\:\ pad_swipe\ curpad},
q{panic\:\ pad_swipe\ curpad\,\ \%p\!\=\%p},
q{panic\:\ pad_swipe\ po},
q{panic\:\ pp_iter},
q{panic\:\ pp_iter\,\ type\=.+?},
q{panic\:\ pp_match},
q{panic\:\ pp_match.+?},
q{panic\:\ pp_split},
q{panic\:\ pp_split\,\ pm\=\%p\,\ s\=\%p},
q{panic\:\ realloc},
q{panic\:\ realloc\,\ .+?},
q{panic\:\ reference\ miscount\ on\ nsv\ in\ sv_replace\(\)\ \(.+?\ \!\=\ 1\)},
q{panic\:\ restartop},
q{panic\:\ restartop\ in\ .+?},
q{panic\:\ return},
q{panic\:\ return\,\ type\=.+?},
q{panic\:\ scan_num},
q{panic\:\ scan_num\,\ .+?},
q{panic\:\ string\ extend},
q{panic\:\ strxfrm\(\)\ gets\ absurd\ \-\ a\ \=\>\ .+?\,\ ab\ \=\>\ .+?},
q{panic\:\ sv_chop\ .+?},
q{panic\:\ sv_insert},
q{panic\:\ sv_insert\,\ midend\=\%p\,\ bigend\=\%p},
q{panic\:\ top_env},
q{panic\:\ unimplemented\ op\ .+?\ \(\#.+?\)\ called},
q{panic\:\ utf16_to_utf8\:\ odd\ bytelen},
q{panic\:\ utf16_to_utf8_reversed\:\ odd\ bytelen},
q{panic\:\ yylex},
q{panic\:\ yylex\,\ .+?},
q{perl\:\ warning\:\ Non\ hex\ character\ in\ \'\$ENV\{PERL_HASH_SEED\}\'\,\ seed\ only\ partially\ set},
q{perl\:\ warning\:\ Setting\ locale\ failed\.},
q{perl\:\ warning\:\ strange\ setting\ in\ \'\$ENV\{PERL_PERTURB_KEYS\}\'\:\ \'.+?\'},
q{perlio\:\ argument\ list\ not\ closed\ for\ layer\ \".+?\"},
q{perlio\:\ invalid\ separator\ character\ .+?\ in\ layer\ specification\ list\ .+?},
q{perlio\:\ unknown\ layer\ \".+?\"},
q{pid\ .+?\ not\ a\ child},
q{pragma\ \"attrs\"\ is\ deprecated\,\ use\ \"sub\ NAME\ \:\ ATTRS\"\ instead},
q{print\(\)\ on\ closed\ filehandle\ .+?},
q{printf\(\)\ on\ closed\ filehandle\ .+?},
q{read\(\)\ on\ closed\ filehandle\ .+?},
q{read\(\)\ on\ unopened\ filehandle\ .+?},
q{readdir\(\)\ attempted\ on\ invalid\ dirhandle\ .+?},
q{readline\(\)\ on\ closed\ filehandle\ .+?},
q{realloc\(\)\ of\ freed\ memory\ ignored},
q{refcnt\:\ fd\ .+?.+?},
q{refcnt_dec\:\ fd\ .+?.+?},
q{refcnt_inc\:\ fd\ .+?.+?},
q{regexp\ \*\+\ operand\ could\ be\ empty},
q{regexp\ memory\ corruption},
q{regexp\ out\ of\ space},
q{rewinddir\(\)\ attempted\ on\ invalid\ dirhandle\ .+?},
q{seekdir\(\)\ attempted\ on\ invalid\ dirhandle\ .+?},
q{select\ not\ implemented},
q{sem.+?\ not\ implemented},
q{semi\-panic\:\ attempt\ to\ dup\ freed\ string},
q{send\(\)\ on\ closed\ socket\ .+?},
q{setegid\(\)\ not\ implemented},
q{seteuid\(\)\ not\ implemented},
q{setpgrp\ can\'t\ take\ arguments},
q{setrgid\(\)\ not\ implemented},
q{setruid\(\)\ not\ implemented},
q{setsockopt\(\)\ on\ closed\ socket\ .+?},
q{shm.+?\ not\ implemented},
q{shutdown\(\)\ on\ closed\ socket\ .+?},
q{sleep\(.+?\)\ too\ large},
q{sort\ is\ now\ a\ reserved\ word},
q{splice\(\)\ offset\ past\ end\ of\ array},
q{stat\(\)\ on\ unopened\ filehandle\ .+?},
q{substr\ outside\ of\ string},
q{suidperl\ is\ no\ longer\ needed\ since\ .+?},
q{sv_upgrade\ from\ type\ .+?\ down\ to\ type\ .+?},
q{switching\ effective\ .+?\ is\ not\ implemented},
q{syntax\ error},
q{syntax\ error\ at\ line\ .+?\:\ \'.+?\'\ unexpected},
q{syntax\ error\ at\ line\ .+?\:\ \`.+?\'\ unexpected},
q{syntax\ error\ in\ file\ .+?\ at\ line\ .+?\,\ next\ 2\ tokens\ \".+?\"},
q{sysread\(\)\ on\ closed\ filehandle\ .+?},
q{sysread\(\)\ on\ unopened\ filehandle\ .+?},
q{syswrite\(\)\ on\ closed\ filehandle\ .+?},
q{tell\(\)\ on\ unopened\ file},
q{tell\(\)\ on\ unopened\ filehandle},
q{telldir\(\)\ attempted\ on\ invalid\ dirhandle\ .+?},
q{thread\ failed\ to\ start\:\ .+?},
q{times\ not\ implemented},
q{trailing\ \\\ in\ regexp},
q{truncate\ not\ implemented},
q{umask\ not\ implemented},
q{umask\:\ argument\ is\ missing\ initial\ 0},
q{unexec\ of\ .+?\ into\ .+?\ failed\!},
q{unmatched\ \(\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{unmatched\ \(\ in\ regexp\ before\ \<\<\ HERE\ mark\ in\ regex\ m\/.+?\/},
q{unmatched\ \(\)\ in\ regexp},
q{unmatched\ \[\ before\ \<\<\ HERE\ mark\ in\ regex\ m\/.+?\/},
q{unmatched\ \[\ in\ regex\;\ marked\ by\ \<\-\-\ HERE\ in\ m\/.+?\/},
q{unmatched\ \[\]\ in\ regexp},
q{untie\ attempted\ while\ .+?\ inner\ references\ still\ exist},
q{v\-string\ in\ use\/require\ is\ non\-portable},
q{vector\ argument\ not\ supported\ with\ alpha\ versions},
q{when\ is\ experimental},
q{write\(\)\ on\ closed\ filehandle\ .+?},
q{x\ outside\ of\ string},
];

my $ra = Regexp::Assemble->new;
$ra->add($_) for @$lines;

$re = $ra->re;

}

sub is_warning {
  my $string = shift || return;
  return $string =~ $re;
}

sub not_warning {
  my $string = shift || return 1;
  return $string !~ $re;
}

'Danger! Danger! High Voltage!';

__END__

=pod

=head1 NAME

String::Perl::Warnings - Determine if a string looks like a perl warning

=head1 VERSION

version 1.10

=head1 SYNOPSIS

  use String::Perl::Warnings qw(is_warning);

  while( <> ) {
    chomp;
    next unless is_warning($_);
    # Looks like a warning
  }

  while( <> ) {
    chomp;
    next if not_warning($_);
    # Looks like a warning
  }

=head1 DESCRIPTION

String::Perl::Warnings can be used to determine if a string of arbitary text appears to look
like a warning generated by perl.

It includes all warnings for every stable perl release from C<5.6.0> to C<5.12.0>.

=head1 FUNCTIONS

=over

=item C<is_warning>

Takes an arbitary string of text and returns a true value if the string looks like a perl warning,
a false value otherwise.

=item C<not_warning>

Takes an arbitary string of text and returns a true value if the string does not look like a perl
warning and a false value otherwise.

=back

=head1 SEE ALSO

L<http://p3rl.org/perldiag>

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Chris Williams.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
