use strict;
use warnings;

package Spice::Multiline;
use Role::Tiny;
use String::Util 'trim';

around save_record => sub {
    my ( $orig, $self, $line ) = @_;
    chomp $line;
    $line = trim($line);
    return $orig->( $self, $line ) if $line !~ /^[+]/;
    $line =~ s/^[+]\s*//;
    $orig->( $self, $self->pop_record . ' ' . $line );
};

package SpiceParser;
use Role::Tiny::With;
use parent 'TextFileParser';

with 'Spice::Multiline';

package main;
use Test::More;
use Test::Exception;

my $sp = new SpiceParser;

lives_ok { $sp->read('t/example.sp'); } 'Works fine';
is( $sp->lines_parsed, 4, 'Parses 4 lines' );
is( $sp->last_record, 'Minst net1 net2 net3 net4 nmos l=0.09u w=0.13u' );

done_testing;
