package inc::M::Bootstrap;
# $Id: Bootstrap.pm,v 1.4 2007/05/19 13:02:47 ask Exp $
# $Source: /opt/CVS/Modwheel/inc/M/Bootstrap.pm,v $
# $Author: ask $
# $HeadURL$
# $Revision: 1.4 $
# $Date: 2007/05/19 13:02:47 $
use strict;
use warnings;
use Carp;
use File::Spec;
use File::Spec::Functions qw( splitpath catfile );
use English qw( -no_match_vars );
use Data::Dumper;
use inc::M::InstallerBuilder;
our $builder = 'Build.PL';
our $VERSION = 1.0;

# Default installation prefix.
my $DEFAULT_PREFIX;
if ($OSNAME eq 'MSWin32') {
    $DEFAULT_PREFIX = File::Spec->catdir('Program Files', 'Modwheel');
}
else {
    $DEFAULT_PREFIX = File::Spec->catdir('opt', 'modwheel');
}

# Name of the class to generate.
my $OUTCLASS    = 'Modwheel::Install::Everything';

# Use catdir to make paths for sql-files for databases.
# catdir is portable to other OS's than unix.
my $mysql_path  = File::Spec->catdir('sql', 'MySQL');
my $sqlite_path = File::Spec->catdir('sql', 'SQLite');

#========================================================================
# %STRAP: List of installer-modules to generate.
#
# Key: Class-name
#   in  => Directory (from cwd) to copy files from.
#          (files won't be copied now, but they will be self-contained
#          into the module generated).
#   out => Directory (relative to prefix) to write files to,
#         when the generated module's write_files method is run.
#========================================================================
my %STRAP = (
    'Modwheel::Install::Localized' => {
        in      => 'Localized',
        out     => 'Localized',
    },
    'Modwheel::Install::Templates' => {
        in      => 'Templates',
        out     => 'Templates',
    },
    'Modwheel::Install::sql::MySQL' => {
        in      => $mysql_path,
        out     => $mysql_path,
    },
    'Modwheel::Install::sql::SQLite' => {
        in      => $sqlite_path,
        out     => $sqlite_path,
    },
    'Modwheel::Install::doc'         => {
        in      => 'doc',
        out     => 'doc',
    },
    'Modwheel::Install::bin'         => {
        in      => 'bin',
        out     => 'bin',
        type    => 'bin',
    },
    'Modwheel::Install::skel::Config' => {
        in      => 'skel/config',
        out     => 'config',
    },
    'Modwheel::Install::skel::Repository' => {
        in      => 'skel/Repository',
        out     => 'Repository',
        type    => 'rep',
    },
);

sub default_prefix {
    my ($self) = @_;
    return File::Spec->rel2abs($DEFAULT_PREFIX, q{/});
}

sub write_buildconfig {
    my ($self, $config_class, $config_data) = @_;
    return if $ENV{TEST_COVERAGE};
    my $file_path = inc::M::InstallerBuilder::class_to_class_path($config_class);
    my $dump      = Data::Dumper->new([$config_data], ['config_data'])->Dump( );
    
    my $package = <<"ENDMODULE" 
        # This file is generated by Modwheel's $builder. DO NOT EDIT BY HAND!
        package $config_class;

        my $dump;

        sub get_value {
            my (\$class, \$key) = \@_;
            return if not exists \$config_data->{\$key};
            return               \$config_data->{\$key};
        }

        1;
=pod

=head1 NAME

Modwheel::BuildConfig Access to build-time configuration.

=head1 SYNOPSIS

    use Modwheel::BuildConfig;
    my \$prefix = Modwheel::BuildConfig->get_value('prefix');

=head1 DESCRIPTION

This module gives access to variables that are stored when Modwheel is built using
Makefile.PL or Build.PL

=head1 SUBROUTINES/METHODS

=head2 CLASS METHODS

=head2 C<Modwheel::BuildConfig-E<gt>get_value(\$key)>

Get the value of a build-time configuration variable.

=head1 AUTHOR

Ask Solem, C<< ask\@0x61736b.net >>.

=head1 LICENSE AND COPYRIGHT

Copyright (c), 2007 Ask Solem C<< ask\@0x61736b.net >>.

All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE
SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE
STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE
SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND
PERFORMANCE OF THE SOFTWARE IS WITH YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE,
YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY
COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE
SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE SOFTWARE (INCLUDING BUT NOT LIMITED TO
LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR
THIRD PARTIES OR A FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER
SOFTWARE), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

ENDMODULE
    ;

    $package =~ s/^\t\t//xmsg;
    inc::M::InstallerBuilder::writefile($file_path, $package);

    return;
}


#------------------------------------------------------------------------
# ->strap_it( )
#
# Create Installer classes for all components out of the %STRAP hash.
# Also create the main installer: Modwheel::Install::Everything.
#
# Modwheel/Install/Everything.pm is the module used by 'modstrap install'
# to install Modwheel run-time files.
#------------------------------------------------------------------------
sub strap_it {
    my ($self) = @_;
    return if $ENV{TEST_COVERAGE};

    my @everything;
    while (my ($class, $arg_ref) = each %STRAP) {
        push @everything,
            inc::M::InstallerBuilder->create($arg_ref->{in}, $arg_ref->{out}, $class, $arg_ref->{type});
    }

    my $out;
    $out .= <<"END"
# This file is generated by Modwheel's $builder. DO NOT EDIT BY HAND!
package $OUTCLASS;
use strict;

__PACKAGE__->main( ) if not caller && caller ne 'PAR';

END
;

    # Use all generated modules..
    for my $class (@everything) {
        $out .= "use $class;\n";
    }

    # Create the subroutines...
    $out .= <<'END'

sub install {
    my ($opt_force) = @_;
END
;
    for my $class (@everything) {
        $out .= "\t$class->write_files( \$opt_force );\n";
    }
    $out .= <<"END"
}

sub install_force {
    install(1);
}

sub main {
    install( );
    exit 0;
}

1;

END
;


    my $class_final = inc::M::InstallerBuilder::class_to_class_path($OUTCLASS);
    inc::M::InstallerBuilder::writefile($class_final, $out);
    print {*STDERR} "* Created installation main $OUTCLASS -> $class_final\n";

    return;
}

1;
__END__
