#include "clar_libgit2.h"
#include "refs.h"

static git_repository *repo;
static git_reference *branch;

void test_refs_branches_lookup__initialize(void)
{
	cl_git_pass(git_repository_open(&repo, cl_fixture("testrepo.git")));

	branch = NULL;
}

void test_refs_branches_lookup__cleanup(void)
{
	git_reference_free(branch);

	git_repository_free(repo);
}

void test_refs_branches_lookup__can_retrieve_a_local_branch(void)
{
	cl_git_pass(git_branch_lookup(&branch, repo, "br2", GIT_BRANCH_LOCAL));
}

void test_refs_branches_lookup__can_retrieve_a_remote_tracking_branch(void)
{
	cl_git_pass(git_branch_lookup(&branch, repo, "test/master", GIT_BRANCH_REMOTE));
}

void test_refs_branches_lookup__trying_to_retrieve_an_unknown_branch_returns_ENOTFOUND(void)
{
	cl_assert_equal_i(GIT_ENOTFOUND, git_branch_lookup(&branch, repo, "where/are/you", GIT_BRANCH_LOCAL));
	cl_assert_equal_i(GIT_ENOTFOUND, git_branch_lookup(&branch, repo, "over/here", GIT_BRANCH_REMOTE));
}
