/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 53 "parse.y"

#include "sqliteInt.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 46 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 252
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 65
#define sqlite3ParserTOKENTYPE Token
typedef union {
  int yyinit;
  sqlite3ParserTOKENTYPE yy0;
  Expr* yy72;
  TriggerStep* yy145;
  ExprList* yy148;
  SrcList* yy185;
  int yy194;
  Select* yy243;
  IdList* yy254;
  struct TrigEvent yy332;
  struct LimitVal yy354;
  struct LikeOp yy392;
  struct {int value; int mask;} yy497;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 616
#define YYNRULE 323
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   304,   49,  484,   34,  140,  142,  468,  440,   56,   56,
 /*    10 */    56,   56,  168,   20,   20,   20,   20,   44,   44,   57,
 /*    20 */    57,   57,   54,  217,  940,  179,  407,    2,  315,  447,
 /*    30 */   453,   45,   20,   20,   20,   20,   44,   44,   57,   57,
 /*    40 */    57,   54,  217,  205,  414,  415,  440,   55,   19,  317,
 /*    50 */   457,  458,  454,  454,   22,   22,   56,   56,   56,   56,
 /*    60 */   429,   20,   20,   20,   20,   44,   44,   57,   57,   57,
 /*    70 */    54,  217,  304,  399,  315,  440,  491,  437,   50,   20,
 /*    80 */    20,   20,   20,   44,   44,   57,   57,   57,   54,  217,
 /*    90 */   527,  414,  415,  307,   57,   57,   57,   54,  217,  222,
 /*   100 */   116,  447,  453,  162,  507,   36,  132,  296,  400,  298,
 /*   110 */   325,  161,  417,  418,  440,  414,  415,  563,  248,   55,
 /*   120 */    19,  317,  457,  458,  454,  454,   22,   22,   56,   56,
 /*   130 */    56,   56,  240,   20,   20,   20,   20,   44,   44,   57,
 /*   140 */    57,   57,   54,  217,  304,  222,  135,  416,  512,  469,
 /*   150 */   215,  143,  132,  296,  400,  298,  325,  161,  306,  417,
 /*   160 */   418,  223,  599,  248,  248,  414,  415,  343,   18,  597,
 /*   170 */   598,  491,  329,  447,  453,  219,   44,   44,   57,   57,
 /*   180 */    57,   54,  217,  417,  418,  300,  181,  473,  471,  547,
 /*   190 */   211,   55,   19,  317,  457,  458,  454,  454,   22,   22,
 /*   200 */    56,   56,   56,   56,   28,   20,   20,   20,   20,   44,
 /*   210 */    44,   57,   57,   57,   54,  217,  304,  514,  431,  546,
 /*   220 */   356,  442,  460,  460,   66,  414,  415,  543,  414,  415,
 /*   230 */   555,  530,  381,  417,  418,  171,  381,  554,  373,  380,
 /*   240 */   385,   49,  192,   34,  140,  447,  453,  362,  333,  390,
 /*   250 */   486,  362,  444,  444,  444,  203,  436,   83,  344,  487,
 /*   260 */   436,   83,  156,   55,   19,  317,  457,  458,  454,  454,
 /*   270 */    22,   22,   56,   56,   56,   56,  437,   20,   20,   20,
 /*   280 */    20,   44,   44,   57,   57,   57,   54,  217,  304,  437,
 /*   290 */   574,  355,  278,  417,  418,  596,  417,  418,  349,  358,
 /*   300 */   404,  411,  349,  384,  432,  381,  233,  342,  108,  364,
 /*   310 */   416,  596,  543,  548,  204,  595,  594,  447,  453,  492,
 /*   320 */   362,  246,  469,  215,  558,   64,  416,  455,  416,  436,
 /*   330 */    88,  595,  379,   23,  573,   55,   19,  317,  457,  458,
 /*   340 */   454,  454,   22,   22,   56,   56,   56,   56,  437,   20,
 /*   350 */    20,   20,   20,   44,   44,   57,   57,   57,   54,  217,
 /*   360 */   304,  171,  191,   31,  373,  380,  385,  548,    8,  339,
 /*   370 */   220,  180,  353,  491,  106,  390,  593,  230,  430,   64,
 /*   380 */   518,  519,  416,  402,  330,  297,  294,   54,  217,  447,
 /*   390 */   453,  162,  372,  230,  382,  232,  496,  516,  416,  397,
 /*   400 */     1,  117,  190,  557,  414,  415,  433,   55,   19,  317,
 /*   410 */   457,  458,  454,  454,   22,   22,   56,   56,   56,   56,
 /*   420 */     7,   20,   20,   20,   20,   44,   44,   57,   57,   57,
 /*   430 */    54,  217,  304,  171,  381,  505,  373,  380,  385,  232,
 /*   440 */   142,  381,  440,  135,  196,  381,  306,  390,  476,  362,
 /*   450 */   213,  324,   49,  461,   34,  140,  362,  164,  436,   69,
 /*   460 */   362,  447,  453,   38,  141,  436,   83,  573,  491,  436,
 /*   470 */    77,  568,  417,  418,  471,  348,  211,   53,  437,   55,
 /*   480 */    19,  317,  457,  458,  454,  454,   22,   22,   56,   56,
 /*   490 */    56,   56,   30,   20,   20,   20,   20,   44,   44,   57,
 /*   500 */    57,   57,   54,  217,  304,  381,  478,  383,  566,   39,
 /*   510 */   440,  332,  565,  270,  448,  449,  381,  330,  297,  294,
 /*   520 */   362,  269,  479,  381,  272,  474,  350,  659,  232,  436,
 /*   530 */   104,  362,  226,  447,  453,  451,  452,  480,  362,  520,
 /*   540 */   436,   68,  356,  522,  460,  460,  477,  436,   79,  521,
 /*   550 */   570,   55,   19,  317,  457,  458,  454,  454,   22,   22,
 /*   560 */    56,   56,   56,   56,  450,   20,   20,   20,   20,   44,
 /*   570 */    44,   57,   57,   57,   54,  217,  304,  381,  202,  381,
 /*   580 */   529,  326,  176,  381,  137,  381,  414,  415,  861,  207,
 /*   590 */   208,  209,  362,  313,  362,  508,  381,  535,  362,  416,
 /*   600 */   362,  436,  100,  436,   79,  447,  453,  436,   91,  436,
 /*   610 */    88,  362,  437,   58,  356,   35,  460,  460,  536,  600,
 /*   620 */   436,   67,  199,   55,   19,  317,  457,  458,  454,  454,
 /*   630 */    22,   22,   56,   56,   56,   56,  403,   20,   20,   20,
 /*   640 */    20,   44,   44,   57,   57,   57,   54,  217,  304,  312,
 /*   650 */   218,  381,  509,   60,  417,  418,  437,  381,  331,  571,
 /*   660 */   519,  337,  464,  465,  408,    2,  362,   16,  381,  183,
 /*   670 */   319,  356,  362,  460,  460,  436,   87,  447,  453,  548,
 /*   680 */   493,  436,   84,  362,  356,   65,  460,  460,  374,  440,
 /*   690 */   607,   64,  436,   82,  416,   55,   19,  317,  457,  458,
 /*   700 */   454,  454,   22,   22,   56,   56,   56,   56,  381,   20,
 /*   710 */    20,   20,   20,   44,   44,   57,   57,   57,   54,  217,
 /*   720 */   304,  381,  478,  362,  230,  126,  157,  381,   49,  251,
 /*   730 */    34,  140,  436,   75,  610,  301,  362,  335,  479,  321,
 /*   740 */   464,  465,  362,  111,  416,  436,   70,  110,  602,  447,
 /*   750 */   453,  436,   71,  480,  281,  368,  168,  440,  419,  420,
 /*   760 */   421,  616,  409,  406,  195,  316,  322,   55,   19,  317,
 /*   770 */   457,  458,  454,  454,   22,   22,   56,   56,   56,   56,
 /*   780 */   381,   20,   20,   20,   20,   44,   44,   57,   57,   57,
 /*   790 */    54,  217,  304,  381,  240,  362,  158,  496,  437,  381,
 /*   800 */   378,  381,  230,  523,  436,   92,  206,  139,  362,  416,
 /*   810 */   197,  139,  500,  236,  362,  416,  362,  436,   99,  309,
 /*   820 */   146,  447,  453,  436,   89,  436,   90,  416,  267,  527,
 /*   830 */   496,  614,  930,  494,  930,  526,  254,  389,  601,   55,
 /*   840 */    19,  317,  457,  458,  454,  454,   22,   22,   56,   56,
 /*   850 */    56,   56,  381,   20,   20,   20,   20,   44,   44,   57,
 /*   860 */    57,   57,   54,  217,  304,  381,  376,  362,  251,  224,
 /*   870 */   261,  381,  265,  381,  611,  311,  436,   86,  467,  467,
 /*   880 */   362,  416,  489,  416,  381,  608,  362,  396,  362,  436,
 /*   890 */    94,  500,  402,  447,  453,  436,   98,  436,   93,  362,
 /*   900 */   564,  354,  564,  237,  109,  308,  416,  416,  436,   17,
 /*   910 */    61,   55,   32,  317,  457,  458,  454,  454,   22,   22,
 /*   920 */    56,   56,   56,   56,  381,   20,   20,   20,   20,   44,
 /*   930 */    44,   57,   57,   57,   54,  217,  304,  381,  240,  362,
 /*   940 */   159,  251,  341,  381,  496,  289,  398,  277,  436,  131,
 /*   950 */   263,  273,  362,  416,  351,  381,  416,   25,  362,  227,
 /*   960 */   500,  436,  129,  409,  406,  447,  453,  436,   73,  435,
 /*   970 */   362,  614,  931,  434,  931,  416,  186,  481,  228,  436,
 /*   980 */    74,  214,  113,  258,   19,  317,  457,  458,  454,  454,
 /*   990 */    22,   22,   56,   56,   56,   56,  381,   20,   20,   20,
 /*  1000 */    20,   44,   44,   57,   57,   57,   54,  217,  304,  381,
 /*  1010 */   202,  362,  299,  251,  611,  381,  359,  238,  524,  525,
 /*  1020 */   436,  105,  174,  314,  362,  435,  250,  381,  416,  434,
 /*  1030 */   362,  381,  416,  436,  101,  232,   21,  447,  453,  436,
 /*  1040 */    81,  416,  362,  569,  437,  168,  362,  357,  198,  612,
 /*  1050 */   320,  436,  130,  182,  553,  436,   85,  317,  457,  458,
 /*  1060 */   454,  454,   22,   22,   56,   56,   56,   56,  403,   20,
 /*  1070 */    20,   20,   20,   44,   44,   57,   57,   57,   54,  217,
 /*  1080 */    37,  328,  437,    3,  381,  251,  381,  360,  415,  371,
 /*  1090 */   327,  613,  240,  194,   62,   37,  328,  365,    3,  362,
 /*  1100 */   416,  362,  360,  415,  416,  495,  240,  416,  436,   59,
 /*  1110 */   436,   95,  365,  381,   10,  361,  133,  381,  581,  381,
 /*  1120 */   416,  416,  318,  147,  291,  473,  392,  437,  362,  391,
 /*  1130 */   361,  416,  362,  416,  362,  241,  386,  436,   80,  416,
 /*  1140 */   473,  436,   78,  436,   76,   47,   41,  107,  381,  252,
 /*  1150 */   482,  381,  501,  292,   40,  395,  370,  534,  533,  442,
 /*  1160 */    47,   41,  506,  362,  605,  416,  362,  416,  416,   40,
 /*  1170 */   395,  370,  436,  128,  442,  436,   96,  232,  170,   37,
 /*  1180 */   328,    4,    3,  425,  592,  240,  360,  415,  381,  240,
 /*  1190 */   444,  444,  444,  445,  446,   13,  365,  175,  416,  416,
 /*  1200 */   416,  552,  658,  362,  416,  444,  444,  444,  445,  446,
 /*  1210 */    13,  212,  436,  102,  361,  381,  284,  295,  271,  166,
 /*  1220 */   245,  604,  247,  582,  473,  185,  274,  381,  583,  603,
 /*  1230 */   362,  499,  585,  560,   33,  240,  167,  416,  287,  436,
 /*  1240 */   127,  266,  362,  272,   47,   41,  416,  283,  401,  345,
 /*  1250 */   416,  436,   72,   40,  395,  370,  416,  221,  442,  153,
 /*  1260 */   381,  573,  240,  416,  362,  152,  413,   29,  165,  422,
 /*  1270 */    46,  414,  415,  436,    9,  362,   48,  416,  586,  393,
 /*  1280 */   155,  416,  443,  405,  436,   97,  293,   24,  531,  444,
 /*  1290 */   444,  444,  445,  446,   13,  338,  286,  416,  416,  290,
 /*  1300 */   282,  416,  410,  416,  426,  587,  280,  439,  115,  473,
 /*  1310 */   416,  347,  256,  294,  416,  416,  253,  305,  427,  416,
 /*  1320 */   606,  416,  232,  550,   42,  262,  234,  279,   26,  189,
 /*  1330 */   188,  416,  285,  416,  276,  416,  173,  334,  416,  514,
 /*  1340 */   416,  416,  416,  442,  609,  388,  303,   31,  340,  416,
 /*  1350 */   498,  590,  154,   52,  578,  577,   52,  154,  539,  462,
 /*  1360 */   168,   63,  394,  579,  168,  336,  302,  572,  136,  423,
 /*  1370 */   517,  160,  488,  528,  444,  444,  444,  323,  125,  103,
 /*  1380 */   346,  216,  542,  441,  148,  576,  485,  275,  544,  377,
 /*  1390 */   217,  541,  232,  540,  257,  428,  530,  239,  466,  551,
 /*  1400 */   200,  242,  387,  172,  366,  177,  561,  244,  187,   51,
 /*  1410 */   367,  562,   27,  424,  169,    6,   11,  363,  288,   43,
 /*  1420 */   134,  310,  575,  235,  184,  545,  150,   15,  580,  243,
 /*  1430 */   412,  145,  483,  229,  615,  456,  144,  497,  264,  463,
 /*  1440 */   114,  255,   14,  511,  163,  503,  268,  178,  510,  584,
 /*  1450 */   122,  138,  475,  588,  472,  567,  259,  225,  154,  231,
 /*  1460 */   121,  504,  123,  438,  112,  124,  120,  502,  459,  559,
 /*  1470 */    12,  149,  119,  591,  490,  369,  201,  260,  549,  556,
 /*  1480 */   513,  375,  210,  515,    5,  470,  532,  537,  193,  589,
 /*  1490 */   657,  118,  249,  151,  538,  352,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    19,  222,  223,  224,  225,   24,  233,   26,   75,   76,
 /*    10 */    77,   78,   25,   80,   81,   82,   83,   84,   85,   86,
 /*    20 */    87,   88,   89,   90,  142,  143,  144,  145,   19,   48,
 /*    30 */    49,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*    40 */    88,   89,   90,  160,   26,   27,   26,   66,   67,   68,
 /*    50 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*    60 */    23,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*    70 */    89,   90,   19,   19,   19,   94,   25,  194,   25,   80,
 /*    80 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*    90 */   103,   26,   27,  155,   86,   87,   88,   89,   90,   90,
 /*   100 */    22,   48,   49,   49,   86,   52,   97,   98,   99,  100,
 /*   110 */   101,  102,   94,   95,   94,   26,   27,   57,  109,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   130 */    77,   78,  150,   80,   81,   82,   83,   84,   85,   86,
 /*   140 */    87,   88,   89,   90,   19,   90,   95,  165,   23,   84,
 /*   150 */    85,   96,   97,   98,   99,  100,  101,  102,  104,   94,
 /*   160 */    95,  197,   97,  109,  109,   26,   27,  229,  204,  104,
 /*   170 */   105,  120,  234,   48,   49,  193,   84,   85,   86,   87,
 /*   180 */    88,   89,   90,   94,   95,  163,  219,   64,  166,  167,
 /*   190 */   168,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   200 */    75,   76,   77,   78,   22,   80,   81,   82,   83,   84,
 /*   210 */    85,   86,   87,   88,   89,   90,   19,   94,  172,  173,
 /*   220 */   112,   98,  114,  115,   22,   26,   27,  181,   26,   27,
 /*   230 */   181,  182,  150,   94,   95,   96,  150,  188,   99,  100,
 /*   240 */   101,  222,  160,  224,  225,   48,   49,  165,   19,  110,
 /*   250 */    31,  165,  129,  130,  131,  160,  174,  175,   18,   40,
 /*   260 */   174,  175,   25,   66,   67,   68,   69,   70,   71,   72,
 /*   270 */    73,   74,   75,   76,   77,   78,  194,   80,   81,   82,
 /*   280 */    83,   84,   85,   86,   87,   88,   89,   90,   19,  194,
 /*   290 */    11,   19,   23,   94,   95,  150,   94,   95,  216,   27,
 /*   300 */   146,  147,  216,  221,  173,  150,  152,  221,  154,   42,
 /*   310 */   165,  150,  181,  150,  160,  170,  171,   48,   49,  120,
 /*   320 */   165,  158,   84,   85,  161,  162,  165,   98,  165,  174,
 /*   330 */   175,  170,  171,  136,   55,   66,   67,   68,   69,   70,
 /*   340 */    71,   72,   73,   74,   75,   76,   77,   78,  194,   80,
 /*   350 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   360 */    19,   96,   25,  126,   99,  100,  101,  150,   22,  214,
 /*   370 */   215,   23,  218,   25,   22,  110,  231,  232,  161,  162,
 /*   380 */   190,  191,  165,  150,  105,  106,  107,   89,   90,   48,
 /*   390 */    49,   49,  231,  232,   18,  116,  166,  165,  165,  245,
 /*   400 */    22,  192,  185,  186,   26,   27,  174,   66,   67,   68,
 /*   410 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   420 */    74,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   430 */    89,   90,   19,   96,  150,  205,   99,  100,  101,  116,
 /*   440 */    24,  150,   26,   95,  160,  150,  104,  110,   23,  165,
 /*   450 */   217,  128,  222,   23,  224,  225,  165,  156,  174,  175,
 /*   460 */   165,   48,   49,   50,   25,  174,  175,   55,  120,  174,
 /*   470 */   175,   21,   94,   95,  166,  167,  168,  136,  194,   66,
 /*   480 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   490 */    77,   78,  135,   80,   81,   82,   83,   84,   85,   86,
 /*   500 */    87,   88,   89,   90,   19,  150,   12,  216,   29,   24,
 /*   510 */    94,   61,   33,   98,   48,   49,  150,  105,  106,  107,
 /*   520 */   165,  226,   28,  150,  109,   23,   47,  118,  116,  174,
 /*   530 */   175,  165,  227,   48,   49,   69,   70,   43,  165,   45,
 /*   540 */   174,  175,  112,  176,  114,  115,   23,  174,  175,   55,
 /*   550 */   100,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   560 */    75,   76,   77,   78,   98,   80,   81,   82,   83,   84,
 /*   570 */    85,   86,   87,   88,   89,   90,   19,  150,  160,  150,
 /*   580 */    23,  104,   23,  150,  150,  150,   26,   27,  138,  105,
 /*   590 */   106,  107,  165,  220,  165,   23,  150,   35,  165,  165,
 /*   600 */   165,  174,  175,  174,  175,   48,   49,  174,  175,  174,
 /*   610 */   175,  165,  194,  135,  112,  137,  114,  115,   56,   23,
 /*   620 */   174,  175,  160,   66,   67,   68,   69,   70,   71,   72,
 /*   630 */    73,   74,   75,   76,   77,   78,  218,   80,   81,   82,
 /*   640 */    83,   84,   85,   86,   87,   88,   89,   90,   19,  220,
 /*   650 */   215,  150,   23,  235,   94,   95,  194,  150,  240,  190,
 /*   660 */   191,  169,  170,  171,  144,  145,  165,   22,  150,   24,
 /*   670 */   108,  112,  165,  114,  115,  174,  175,   48,   49,  150,
 /*   680 */   120,  174,  175,  165,  112,   22,  114,  115,   50,   26,
 /*   690 */   161,  162,  174,  175,  165,   66,   67,   68,   69,   70,
 /*   700 */    71,   72,   73,   74,   75,   76,   77,   78,  150,   80,
 /*   710 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   720 */    19,  150,   12,  165,  232,   24,    6,  150,  222,  150,
 /*   730 */   224,  225,  174,  175,  248,  249,  165,  149,   28,  169,
 /*   740 */   170,  171,  165,  104,  165,  174,  175,   22,  242,   48,
 /*   750 */    49,  174,  175,   43,   23,   45,   25,   94,    7,    8,
 /*   760 */     9,    0,    1,    2,  160,   46,  187,   66,   67,   68,
 /*   770 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   780 */   150,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   790 */    89,   90,   19,  150,  150,  165,  118,  166,  194,  150,
 /*   800 */   150,  150,  232,  184,  174,  175,  206,  207,  165,  165,
 /*   810 */   206,  207,  150,   23,  165,  165,  165,  174,  175,  246,
 /*   820 */   247,   48,   49,  174,  175,  174,  175,  165,   16,  103,
 /*   830 */   166,   22,   23,  120,   25,  178,  205,  193,   23,   66,
 /*   840 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   850 */    77,   78,  150,   80,   81,   82,   83,   84,   85,   86,
 /*   860 */    87,   88,   89,   90,   19,  150,  150,  165,  150,  205,
 /*   870 */    58,  150,   60,  150,   65,  213,  174,  175,  129,  130,
 /*   880 */   165,  165,   25,  165,  150,   37,  165,  243,  165,  174,
 /*   890 */   175,  150,  150,   48,   49,  174,  175,  174,  175,  165,
 /*   900 */   105,  106,  107,   16,   22,  187,  165,  165,  174,  175,
 /*   910 */   244,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   920 */    75,   76,   77,   78,  150,   80,   81,   82,   83,   84,
 /*   930 */    85,   86,   87,   88,   89,   90,   19,  150,  150,  165,
 /*   940 */   118,  150,   86,  150,  166,   58,   19,   60,  174,  175,
 /*   950 */   138,  176,  165,  165,  213,  150,  165,   25,  165,  217,
 /*   960 */   150,  174,  175,    1,    2,   48,   49,  174,  175,  113,
 /*   970 */   165,   22,   23,  117,   25,  165,  119,   23,  187,  174,
 /*   980 */   175,  193,   22,  205,   67,   68,   69,   70,   71,   72,
 /*   990 */    73,   74,   75,   76,   77,   78,  150,   80,   81,   82,
 /*  1000 */    83,   84,   85,   86,   87,   88,   89,   90,   19,  150,
 /*  1010 */   160,  165,  179,  150,   65,  150,   97,  150,    7,    8,
 /*  1020 */   174,  175,  156,  213,  165,  113,  150,  150,  165,  117,
 /*  1030 */   165,  150,  165,  174,  175,  116,   22,   48,   49,  174,
 /*  1040 */   175,  165,  165,   23,  194,   25,  165,  128,  160,   23,
 /*  1050 */   187,  174,  175,   24,  176,  174,  175,   68,   69,   70,
 /*  1060 */    71,   72,   73,   74,   75,   76,   77,   78,  218,   80,
 /*  1070 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  1080 */    19,   20,  194,   22,  150,  150,  150,   26,   27,  150,
 /*  1090 */   240,   65,  150,  160,   16,   19,   20,   36,   22,  165,
 /*  1100 */   165,  165,   26,   27,  165,  150,  150,  165,  174,  175,
 /*  1110 */   174,  175,   36,  150,   34,   54,  150,  150,  150,  150,
 /*  1120 */   165,  165,  187,  118,  150,   64,   63,  194,  165,   50,
 /*  1130 */    54,  165,  165,  165,  165,  193,  157,  174,  175,  165,
 /*  1140 */    64,  174,  175,  174,  175,   84,   85,   22,  150,  193,
 /*  1150 */   150,  150,  150,  150,   93,   94,   95,   97,   98,   98,
 /*  1160 */    84,   85,   86,  165,  157,  165,  165,  165,  165,   93,
 /*  1170 */    94,   95,  174,  175,   98,  174,  175,  116,   15,   19,
 /*  1180 */    20,   34,   22,  150,  150,  150,   26,   27,  150,  150,
 /*  1190 */   129,  130,  131,  132,  133,  134,   36,  102,  165,  165,
 /*  1200 */   165,  176,  118,  165,  165,  129,  130,  131,  132,  133,
 /*  1210 */   134,    5,  174,  175,   54,  150,   10,   11,   12,   13,
 /*  1220 */    14,  157,  150,   17,   64,   22,  140,  150,  193,   39,
 /*  1230 */   165,  150,  193,   20,  241,  150,   30,  165,   32,  174,
 /*  1240 */   175,  150,  165,  109,   84,   85,  165,   41,  150,  150,
 /*  1250 */   165,  174,  175,   93,   94,   95,  165,   50,   98,   53,
 /*  1260 */   150,   55,  150,  165,  165,   59,  150,   22,   62,  149,
 /*  1270 */    74,   26,   27,  174,  175,  165,   74,  165,  193,  122,
 /*  1280 */   127,  165,  150,  150,  174,  175,  150,  125,  150,  129,
 /*  1290 */   130,  131,  132,  133,  134,  150,  202,  165,  165,  150,
 /*  1300 */   150,  165,    1,  165,  150,  193,  150,  203,  108,   64,
 /*  1310 */   165,  105,  106,  107,  165,  165,  150,  111,  150,  165,
 /*  1320 */   150,  165,  116,  150,  241,  150,  150,  150,  124,   84,
 /*  1330 */    85,  165,  201,  165,  150,  165,  156,    3,  165,   94,
 /*  1340 */   165,  165,  165,   98,   23,  139,   25,  126,  157,  165,
 /*  1350 */    23,   23,   25,   25,   23,   23,   25,   25,   23,   23,
 /*  1360 */    25,   25,   23,  199,   25,  157,  179,  189,   66,  149,
 /*  1370 */   176,  189,  177,  176,  129,  130,  131,  250,  180,  164,
 /*  1380 */   228,  180,  177,  166,  247,  199,  177,  177,  166,  178,
 /*  1390 */    90,  166,  116,  177,  209,  153,  182,  198,  233,  176,
 /*  1400 */   157,  209,  123,  156,   44,  157,  157,  238,  196,  104,
 /*  1410 */   121,  239,  135,   13,  151,   25,   22,  159,  200,   22,
 /*  1420 */    38,  157,    1,  199,   22,  184,  119,    5,    1,  210,
 /*  1430 */   149,   16,  157,   90,    4,   98,  121,  211,   15,   23,
 /*  1440 */    22,  210,   25,   23,  104,  211,  138,  219,   23,   20,
 /*  1450 */   189,  118,   11,  199,   23,   51,  210,  230,   25,  230,
 /*  1460 */   119,  211,  108,  194,   51,  127,  192,   27,  113,  157,
 /*  1470 */    22,   34,  192,  128,  208,  191,  236,  195,  186,  186,
 /*  1480 */   174,  237,   22,  174,  196,  166,  183,  183,   22,  199,
 /*  1490 */   118,  192,  148,  151,  183,  209,
};
#define YY_SHIFT_USE_DFLT (-68)
#define YY_SHIFT_MAX 406
static const short yy_shift_ofst[] = {
 /*     0 */   962, 1061, 1206, 1061, 1160, 1160,  139,   65,   65,  -19,
 /*    10 */  1160, 1160, 1160, 1160, 1160,  412,   89,  413, 1076, 1160,
 /*    20 */  1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160,
 /*    30 */  1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160,
 /*    40 */  1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160,
 /*    50 */  1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160, 1160,  -48,
 /*    60 */   279,   89,   89,  238,   20,  238, 1276,   53,  269,  629,
 /*    70 */   125,  197,  341,  485,  557,  701,  773,  773,  773,  773,
 /*    80 */   773,  773,  773,  773,  773,  773,  773,  773,  773,  773,
 /*    90 */   845,  773,  773,  773,  773,  773,  917,  989,  989,  -67,
 /*   100 */   -67,   -1,   -1,   55,   92,    8,   89,   89,  450,   89,
 /*   110 */    89,   89,   89,   89,   89,   89,   89,   89,   89,   89,
 /*   120 */    89,   89,   89,   89,   89,   54,   20,  298, 1300,  -68,
 /*   130 */   -68,  -68, 1245,    9,  494,  199,  494,  560,   18,  202,
 /*   140 */   378,   89,   89,   89,   89,   89,  809,   89,  949,   89,
 /*   150 */    89,   89,   89,   89,   89,   89,   89,   89,   89,   89,
 /*   160 */    89,   89,   89,   89,   89,   89,   89,   89,   89,   89,
 /*   170 */    89,   89,   89,   89,   89,   89,  416,  416,  919,  761,
 /*   180 */   416,  323, 1276, 1276, 1276,  -68,  -68,  -68,  123,  123,
 /*   190 */   337,  265,  430,  710,  502,  559,  572,  348,  108,  108,
 /*   200 */   479,  795,  108,  108,  108,  108,   51,  562,  562,  562,
 /*   210 */   856,  663,  751,  237,  272,  749,  342,   20,  219,  272,
 /*   220 */   219,  219,   20,  857,  272,  219,  478,  237,  -13,   20,
 /*   230 */   749,  219,  912,  645, 1005, 1279,  477,  376, 1005, 1221,
 /*   240 */  1005, 1360, 1305, 1289, 1277, 1400, 1390, 1005,  719,  720,
 /*   250 */  1005, 1343,   78, 1343, 1305, 1289, 1302, 1221, 1305, 1289,
 /*   260 */  1276,  240, 1005,  240, 1400,  240,   78,  240,  376,  357,
 /*   270 */   477,  720,  719,  726,  848,  477,  960,  376,  477, 1005,
 /*   280 */  1005,  477, 1005, 1190,  720, 1157, 1162, 1190, 1204,  376,
 /*   290 */  1005, 1005, 1221,  960, 1302,  720,  477, 1302,  477,  -68,
 /*   300 */   -68,  -68,  -68,  -68,  466,  812,  484,  887,  731, 1321,
 /*   310 */   346, 1327, 1328, 1331, 1332,  415, 1011,  229, 1020, 1060,
 /*   320 */  1335, 1336, 1339, 1026, 1394, 1397, 1382, 1421, 1402, 1422,
 /*   330 */  1307, 1427, 1415, 1337, 1430, 1423, 1315, 1416, 1418, 1417,
 /*   340 */  1340, 1420, 1425, 1308, 1429, 1333, 1441, 1341, 1431,  932,
 /*   350 */  1404, 1433, 1354, 1338, 1413, 1440, 1355, 1448, 1437, 1345,
 /*   360 */  1460, 1466, 1372,   37,   60,  182,  267,  352,  425,  439,
 /*   370 */   409,  523,  596,  638,  725,  639,  678,  790,  713,  815,
 /*   380 */   882,  822,  927,  932,  954, 1014, 1029, 1080, 1078, 1063,
 /*   390 */  1079, 1125, 1163, 1147, 1095, 1084, 1086, 1203, 1213, 1134,
 /*   400 */  1207, 1196, 1202, 1153, 1301, 1200, 1334,
};
#define YY_REDUCE_USE_DFLT (-228)
#define YY_REDUCE_MAX 303
static const short yy_reduce_ofst[] = {
 /*     0 */  -118,   82,  154,  284,  155,   86,  217,  145,  161,  230,
 /*    10 */   291,  373,  429,  295,  435,  418,  163,  506, 1099, 1110,
 /*    20 */   355,  366,  427,  433,  446,  501,  507,  518,  558,  571,
 /*    30 */   577,  630,  643,  649,  651,  702,  715,  721,  723,  734,
 /*    40 */   774,  787,  793,  805,  846,  859,  865,  877,  881,  934,
 /*    50 */   936,  963,  967,  969,  998, 1001, 1038, 1065, 1077, -221,
 /*    60 */   850,  529,  644,  492,   22,  570,  604,   19,   19,   19,
 /*    70 */    19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
 /*    80 */    19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
 /*    90 */    19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
 /*   100 */    19,   19,   19,   46,   19,   19,  662,  579,  -62,  718,
 /*   110 */   791,  942,  741,  863,  935,  742,  810, 1035, 1039, 1085,
 /*   120 */  1112,  -18,  788,  233,  956,   49,  308,   19,   19,   19,
 /*   130 */    19,   19,  232,  131,  190,  434,  469,  650,  716,  867,
 /*   140 */   876,  939,  955,  966,  968,  974,  486, 1000,  486, 1002,
 /*   150 */  1003, 1033, 1034, 1072, 1081, 1091, 1098, 1116, 1132,  716,
 /*   160 */  1133, 1136, 1138, 1145, 1149, 1150, 1154, 1156, 1166, 1168,
 /*   170 */  1170, 1173, 1175, 1176, 1177, 1184,  631,  664, -117,  520,
 /*   180 */   778,   95,  462,  888,  933,  573,  600,  -36, 1309, 1306,
 /*   190 */  1293, 1292, 1282, 1284, 1282, 1282, 1282, 1266, 1282, 1282,
 /*   200 */  1240, 1244, 1282, 1282, 1282, 1282, 1266, 1303, 1304, 1311,
 /*   210 */  1288, 1319, 1344, 1290, 1286, -227, 1214, 1217, 1209, 1185,
 /*   220 */  1195, 1210, 1222, 1199, 1192, 1205, 1152, 1186, 1211, 1225,
 /*   230 */  1165, 1216, 1212, 1242, 1243, 1218, 1223, 1247, 1248, 1224,
 /*   240 */  1249, 1169, 1219, 1226, 1172, 1263, 1258, 1264, 1241, 1281,
 /*   250 */  1275, 1227, 1228, 1229, 1231, 1234, 1261, 1254, 1246, 1250,
 /*   260 */  1269, 1274, 1312, 1280, 1342, 1299,  -33,  209,  301,  305,
 /*   270 */   367,  588,  619,  657,  666,  775,  833,  866,  878,  979,
 /*   280 */  1007, 1025, 1064,  993, 1120, 1094, 1104, 1083, 1131, 1180,
 /*   290 */  1191, 1208, 1164, 1187, 1178, 1220, 1194, 1182, 1197, 1198,
 /*   300 */  1215, 1127, 1201, 1137,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   621,  856,  939,  939,  939,  856,  939,  885,  885,  744,
 /*    10 */   939,  939,  939,  854,  939,  939,  939,  914,  939,  939,
 /*    20 */   939,  939,  939,  939,  939,  939,  939,  939,  939,  939,
 /*    30 */   939,  939,  939,  939,  939,  939,  939,  939,  939,  939,
 /*    40 */   939,  939,  939,  939,  939,  939,  939,  939,  939,  939,
 /*    50 */   939,  939,  939,  939,  939,  939,  939,  939,  939,  828,
 /*    60 */   939,  939,  939,  885,  660,  885,  748,  779,  939,  939,
 /*    70 */   939,  939,  939,  939,  939,  939,  849,  853,  793,  794,
 /*    80 */   759,  786,  898,  858,  777,  787,  851,  857,  770,  913,
 /*    90 */   939,  850,  784,  915,  780,  781,  816,  815,  834,  840,
 /*   100 */   818,  827,  817,  652,  819,  820,  939,  939,  647,  939,
 /*   110 */   939,  939,  939,  939,  939,  939,  939,  939,  939,  939,
 /*   120 */   939,  939,  939,  939,  939,  713,  939,  821,  822,  836,
 /*   130 */   837,  835,  939,  939,  939,  939,  939,  939,  939,  939,
 /*   140 */   939,  939,  939,  939,  939,  939,  939,  939,  939,  939,
 /*   150 */   939,  939,  869,  939,  939,  939,  939,  627,  939,  939,
 /*   160 */   939,  939,  939,  939,  939,  918,  939,  920,  939,  939,
 /*   170 */   939,  939,  939,  939,  939,  939,  744,  744,  939,  621,
 /*   180 */   744,  939,  939,  939,  939,  932,  748,  738,  939,  939,
 /*   190 */   704,  939,  939,  939,  939,  939,  939,  939,  649,  725,
 /*   200 */   891,  939,  905,  903,  727,  789,  746,  939,  939,  939,
 /*   210 */   736,  662,  629,  783,  761,  939,  683,  939,  773,  761,
 /*   220 */   773,  773,  939,  745,  761,  773,  852,  783,  686,  939,
 /*   230 */   939,  773,  736,  939,  752,  774,  715,  644,  752,  783,
 /*   240 */   752,  895,  760,  765,  897,  637,  703,  752,  700,  626,
 /*   250 */   752,  866,  795,  866,  760,  765,  717,  783,  760,  765,
 /*   260 */   939,  724,  752,  724,  637,  724,  795,  724,  644,  939,
 /*   270 */   715,  626,  700,  686,  925,  715,  862,  644,  715,  752,
 /*   280 */   752,  715,  752,  917,  626,  766,  778,  917,  776,  644,
 /*   290 */   752,  752,  783,  862,  717,  626,  715,  717,  715,  688,
 /*   300 */   670,  937,  688,  932,  939,  939,  939,  939,  939,  939,
 /*   310 */   871,  939,  939,  939,  939,  939,  939,  939,  939,  939,
 /*   320 */   939,  939,  939,  939,  939,  939,  939,  939,  939,  939,
 /*   330 */   939,  939,  939,  939,  939,  635,  939,  939,  939,  767,
 /*   340 */   939,  939,  939,  939,  939,  939,  939,  939,  939,  855,
 /*   350 */   939,  894,  939,  939,  893,  939,  730,  939,  939,  939,
 /*   360 */   654,  939,  802,  939,  939,  939,  939,  939,  939,  939,
 /*   370 */   803,  939,  939,  939,  939,  939,  804,  939,  939,  939,
 /*   380 */   939,  939,  939,  775,  939,  939,  939,  939,  939,  924,
 /*   390 */   939,  939,  939,  939,  939,  807,  939,  927,  939,  939,
 /*   400 */   939,  939,  939,  939,  939,  939,  622,  618,  617,  619,
 /*   410 */   620,  624,  625,  628,  654,  655,  657,  658,  659,  630,
 /*   420 */   631,  632,  633,  634,  636,  640,  638,  639,  641,  648,
 /*   430 */   650,  669,  671,  673,  734,  735,  799,  728,  729,  733,
 /*   440 */   656,  810,  801,  805,  806,  808,  809,  823,  824,  826,
 /*   450 */   832,  839,  842,  825,  830,  831,  833,  838,  841,  731,
 /*   460 */   732,  845,  663,  664,  667,  668,  881,  883,  882,  884,
 /*   470 */   666,  665,  811,  814,  847,  848,  906,  907,  908,  909,
 /*   480 */   910,  843,  753,  846,  829,  768,  771,  772,  769,  737,
 /*   490 */   747,  755,  756,  757,  758,  742,  743,  749,  764,  797,
 /*   500 */   798,  762,  763,  750,  751,  739,  740,  741,  844,  800,
 /*   510 */   812,  813,  674,  675,  807,  676,  677,  678,  716,  719,
 /*   520 */   720,  721,  679,  698,  701,  702,  680,  687,  681,  682,
 /*   530 */   689,  690,  691,  694,  695,  696,  697,  692,  693,  863,
 /*   540 */   864,  867,  865,  684,  685,  699,  672,  661,  653,  705,
 /*   550 */   708,  709,  710,  711,  712,  714,  706,  707,  651,  642,
 /*   560 */   645,  754,  887,  896,  892,  888,  889,  890,  646,  859,
 /*   570 */   860,  718,  791,  792,  886,  899,  901,  796,  902,  904,
 /*   580 */   900,  929,  643,  722,  723,  726,  868,  911,  782,  785,
 /*   590 */   788,  790,  870,  872,  874,  876,  877,  878,  879,  880,
 /*   600 */   873,  875,  912,  916,  919,  921,  922,  923,  926,  928,
 /*   610 */   933,  934,  935,  938,  936,  623,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      QUERY => ID */
   26,  /*       PLAN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
   26,  /*   ROLLBACK => ID */
   26,  /*  SAVEPOINT => ID */
   26,  /*    RELEASE => ID */
    0,  /*         TO => nothing */
    0,  /*      TABLE => nothing */
    0,  /*     CREATE => nothing */
   26,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
    0,  /*    INDEXED => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*    ANALYZE => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*         BY => ID */
   26,  /*    CASCADE => ID */
   26,  /*       CAST => ID */
   26,  /*   COLUMNKW => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*    LIKE_KW => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
   26,  /*    VIRTUAL => ID */
   26,  /*    REINDEX => ID */
   26,  /*     RENAME => ID */
   26,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        ADD => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "SAVEPOINT",     "RELEASE",       "TO",          
  "TABLE",         "CREATE",        "IF",            "NOT",         
  "EXISTS",        "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "INDEXED",     
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "BY",            "CASCADE",     
  "CAST",          "COLUMNKW",      "CONFLICT",      "DATABASE",    
  "DESC",          "DETACH",        "EACH",          "FAIL",        
  "FOR",           "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE_KW",       "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "TRIGGER",       "VACUUM",      
  "VIEW",          "VIRTUAL",       "REINDEX",       "RENAME",      
  "CTIME_KW",      "ANY",           "OR",            "AND",         
  "IS",            "BETWEEN",       "IN",            "ISNULL",      
  "NOTNULL",       "NE",            "EQ",            "GT",          
  "LE",            "LT",            "GE",            "ESCAPE",      
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "COLLATE",       "UMINUS",      
  "UPLUS",         "BITNOT",        "STRING",        "JOIN_KW",     
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "AUTOINCR",    
  "ON",            "DELETE",        "UPDATE",        "INSERT",      
  "SET",           "DEFERRABLE",    "FOREIGN",       "DROP",        
  "UNION",         "ALL",           "EXCEPT",        "INTERSECT",   
  "SELECT",        "DISTINCT",      "DOT",           "FROM",        
  "JOIN",          "USING",         "ORDER",         "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "ADD",           "error",         "input",         "cmdlist",     
  "ecmd",          "explain",       "cmdx",          "cmd",         
  "transtype",     "trans_opt",     "nm",            "savepoint_opt",
  "create_table",  "create_table_args",  "createkw",      "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "indexed_opt",   "on_opt",        "using_opt",   
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "nexprlist",     "setlist",       "insert_cmd",    "inscollist_opt",
  "itemlist",      "exprlist",      "likeop",        "escape",      
  "between_op",    "in_op",         "case_operand",  "case_exprlist",
  "case_else",     "uniqueflag",    "collate",       "nmnum",       
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "savepoint_opt ::= SAVEPOINT",
 /*  21 */ "savepoint_opt ::=",
 /*  22 */ "cmd ::= SAVEPOINT nm",
 /*  23 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  24 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  25 */ "cmd ::= create_table create_table_args",
 /*  26 */ "create_table ::= createkw temp TABLE ifnotexists nm dbnm",
 /*  27 */ "createkw ::= CREATE",
 /*  28 */ "ifnotexists ::=",
 /*  29 */ "ifnotexists ::= IF NOT EXISTS",
 /*  30 */ "temp ::= TEMP",
 /*  31 */ "temp ::=",
 /*  32 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  33 */ "create_table_args ::= AS select",
 /*  34 */ "columnlist ::= columnlist COMMA column",
 /*  35 */ "columnlist ::= column",
 /*  36 */ "column ::= columnid type carglist",
 /*  37 */ "columnid ::= nm",
 /*  38 */ "id ::= ID",
 /*  39 */ "id ::= INDEXED",
 /*  40 */ "ids ::= ID|STRING",
 /*  41 */ "nm ::= id",
 /*  42 */ "nm ::= STRING",
 /*  43 */ "nm ::= JOIN_KW",
 /*  44 */ "type ::=",
 /*  45 */ "type ::= typetoken",
 /*  46 */ "typetoken ::= typename",
 /*  47 */ "typetoken ::= typename LP signed RP",
 /*  48 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  49 */ "typename ::= ids",
 /*  50 */ "typename ::= typename ids",
 /*  51 */ "signed ::= plus_num",
 /*  52 */ "signed ::= minus_num",
 /*  53 */ "carglist ::= carglist carg",
 /*  54 */ "carglist ::=",
 /*  55 */ "carg ::= CONSTRAINT nm ccons",
 /*  56 */ "carg ::= ccons",
 /*  57 */ "ccons ::= DEFAULT term",
 /*  58 */ "ccons ::= DEFAULT LP expr RP",
 /*  59 */ "ccons ::= DEFAULT PLUS term",
 /*  60 */ "ccons ::= DEFAULT MINUS term",
 /*  61 */ "ccons ::= DEFAULT id",
 /*  62 */ "ccons ::= NULL onconf",
 /*  63 */ "ccons ::= NOT NULL onconf",
 /*  64 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  65 */ "ccons ::= UNIQUE onconf",
 /*  66 */ "ccons ::= CHECK LP expr RP",
 /*  67 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  68 */ "ccons ::= defer_subclause",
 /*  69 */ "ccons ::= COLLATE ids",
 /*  70 */ "autoinc ::=",
 /*  71 */ "autoinc ::= AUTOINCR",
 /*  72 */ "refargs ::=",
 /*  73 */ "refargs ::= refargs refarg",
 /*  74 */ "refarg ::= MATCH nm",
 /*  75 */ "refarg ::= ON DELETE refact",
 /*  76 */ "refarg ::= ON UPDATE refact",
 /*  77 */ "refarg ::= ON INSERT refact",
 /*  78 */ "refact ::= SET NULL",
 /*  79 */ "refact ::= SET DEFAULT",
 /*  80 */ "refact ::= CASCADE",
 /*  81 */ "refact ::= RESTRICT",
 /*  82 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  83 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  84 */ "init_deferred_pred_opt ::=",
 /*  85 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  86 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  87 */ "conslist_opt ::=",
 /*  88 */ "conslist_opt ::= COMMA conslist",
 /*  89 */ "conslist ::= conslist COMMA tcons",
 /*  90 */ "conslist ::= conslist tcons",
 /*  91 */ "conslist ::= tcons",
 /*  92 */ "tcons ::= CONSTRAINT nm",
 /*  93 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  94 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  95 */ "tcons ::= CHECK LP expr RP onconf",
 /*  96 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  97 */ "defer_subclause_opt ::=",
 /*  98 */ "defer_subclause_opt ::= defer_subclause",
 /*  99 */ "onconf ::=",
 /* 100 */ "onconf ::= ON CONFLICT resolvetype",
 /* 101 */ "orconf ::=",
 /* 102 */ "orconf ::= OR resolvetype",
 /* 103 */ "resolvetype ::= raisetype",
 /* 104 */ "resolvetype ::= IGNORE",
 /* 105 */ "resolvetype ::= REPLACE",
 /* 106 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 107 */ "ifexists ::= IF EXISTS",
 /* 108 */ "ifexists ::=",
 /* 109 */ "cmd ::= createkw temp VIEW ifnotexists nm dbnm AS select",
 /* 110 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 111 */ "cmd ::= select",
 /* 112 */ "select ::= oneselect",
 /* 113 */ "select ::= select multiselect_op oneselect",
 /* 114 */ "multiselect_op ::= UNION",
 /* 115 */ "multiselect_op ::= UNION ALL",
 /* 116 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 117 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 118 */ "distinct ::= DISTINCT",
 /* 119 */ "distinct ::= ALL",
 /* 120 */ "distinct ::=",
 /* 121 */ "sclp ::= selcollist COMMA",
 /* 122 */ "sclp ::=",
 /* 123 */ "selcollist ::= sclp expr as",
 /* 124 */ "selcollist ::= sclp STAR",
 /* 125 */ "selcollist ::= sclp nm DOT STAR",
 /* 126 */ "as ::= AS nm",
 /* 127 */ "as ::= ids",
 /* 128 */ "as ::=",
 /* 129 */ "from ::=",
 /* 130 */ "from ::= FROM seltablist",
 /* 131 */ "stl_prefix ::= seltablist joinop",
 /* 132 */ "stl_prefix ::=",
 /* 133 */ "seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt",
 /* 134 */ "seltablist ::= stl_prefix LP select RP as on_opt using_opt",
 /* 135 */ "seltablist ::= stl_prefix LP seltablist RP as on_opt using_opt",
 /* 136 */ "dbnm ::=",
 /* 137 */ "dbnm ::= DOT nm",
 /* 138 */ "fullname ::= nm dbnm",
 /* 139 */ "joinop ::= COMMA|JOIN",
 /* 140 */ "joinop ::= JOIN_KW JOIN",
 /* 141 */ "joinop ::= JOIN_KW nm JOIN",
 /* 142 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 143 */ "on_opt ::= ON expr",
 /* 144 */ "on_opt ::=",
 /* 145 */ "indexed_opt ::=",
 /* 146 */ "indexed_opt ::= INDEXED BY nm",
 /* 147 */ "indexed_opt ::= NOT INDEXED",
 /* 148 */ "using_opt ::= USING LP inscollist RP",
 /* 149 */ "using_opt ::=",
 /* 150 */ "orderby_opt ::=",
 /* 151 */ "orderby_opt ::= ORDER BY sortlist",
 /* 152 */ "sortlist ::= sortlist COMMA sortitem sortorder",
 /* 153 */ "sortlist ::= sortitem sortorder",
 /* 154 */ "sortitem ::= expr",
 /* 155 */ "sortorder ::= ASC",
 /* 156 */ "sortorder ::= DESC",
 /* 157 */ "sortorder ::=",
 /* 158 */ "groupby_opt ::=",
 /* 159 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 160 */ "having_opt ::=",
 /* 161 */ "having_opt ::= HAVING expr",
 /* 162 */ "limit_opt ::=",
 /* 163 */ "limit_opt ::= LIMIT expr",
 /* 164 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 165 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 166 */ "cmd ::= DELETE FROM fullname indexed_opt where_opt",
 /* 167 */ "where_opt ::=",
 /* 168 */ "where_opt ::= WHERE expr",
 /* 169 */ "cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt",
 /* 170 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 171 */ "setlist ::= nm EQ expr",
 /* 172 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 173 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 174 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 175 */ "insert_cmd ::= INSERT orconf",
 /* 176 */ "insert_cmd ::= REPLACE",
 /* 177 */ "itemlist ::= itemlist COMMA expr",
 /* 178 */ "itemlist ::= expr",
 /* 179 */ "inscollist_opt ::=",
 /* 180 */ "inscollist_opt ::= LP inscollist RP",
 /* 181 */ "inscollist ::= inscollist COMMA nm",
 /* 182 */ "inscollist ::= nm",
 /* 183 */ "expr ::= term",
 /* 184 */ "expr ::= LP expr RP",
 /* 185 */ "term ::= NULL",
 /* 186 */ "expr ::= id",
 /* 187 */ "expr ::= JOIN_KW",
 /* 188 */ "expr ::= nm DOT nm",
 /* 189 */ "expr ::= nm DOT nm DOT nm",
 /* 190 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 191 */ "term ::= STRING",
 /* 192 */ "expr ::= REGISTER",
 /* 193 */ "expr ::= VARIABLE",
 /* 194 */ "expr ::= expr COLLATE ids",
 /* 195 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 196 */ "expr ::= ID LP distinct exprlist RP",
 /* 197 */ "expr ::= ID LP STAR RP",
 /* 198 */ "term ::= CTIME_KW",
 /* 199 */ "expr ::= expr AND expr",
 /* 200 */ "expr ::= expr OR expr",
 /* 201 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 202 */ "expr ::= expr EQ|NE expr",
 /* 203 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 204 */ "expr ::= expr PLUS|MINUS expr",
 /* 205 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "likeop ::= LIKE_KW",
 /* 208 */ "likeop ::= NOT LIKE_KW",
 /* 209 */ "likeop ::= MATCH",
 /* 210 */ "likeop ::= NOT MATCH",
 /* 211 */ "escape ::= ESCAPE expr",
 /* 212 */ "escape ::=",
 /* 213 */ "expr ::= expr likeop expr escape",
 /* 214 */ "expr ::= expr ISNULL|NOTNULL",
 /* 215 */ "expr ::= expr IS NULL",
 /* 216 */ "expr ::= expr NOT NULL",
 /* 217 */ "expr ::= expr IS NOT NULL",
 /* 218 */ "expr ::= NOT expr",
 /* 219 */ "expr ::= BITNOT expr",
 /* 220 */ "expr ::= MINUS expr",
 /* 221 */ "expr ::= PLUS expr",
 /* 222 */ "between_op ::= BETWEEN",
 /* 223 */ "between_op ::= NOT BETWEEN",
 /* 224 */ "expr ::= expr between_op expr AND expr",
 /* 225 */ "in_op ::= IN",
 /* 226 */ "in_op ::= NOT IN",
 /* 227 */ "expr ::= expr in_op LP exprlist RP",
 /* 228 */ "expr ::= LP select RP",
 /* 229 */ "expr ::= expr in_op LP select RP",
 /* 230 */ "expr ::= expr in_op nm dbnm",
 /* 231 */ "expr ::= EXISTS LP select RP",
 /* 232 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 233 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 234 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 235 */ "case_else ::= ELSE expr",
 /* 236 */ "case_else ::=",
 /* 237 */ "case_operand ::= expr",
 /* 238 */ "case_operand ::=",
 /* 239 */ "exprlist ::= nexprlist",
 /* 240 */ "exprlist ::=",
 /* 241 */ "nexprlist ::= nexprlist COMMA expr",
 /* 242 */ "nexprlist ::= expr",
 /* 243 */ "cmd ::= createkw uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 244 */ "uniqueflag ::= UNIQUE",
 /* 245 */ "uniqueflag ::=",
 /* 246 */ "idxlist_opt ::=",
 /* 247 */ "idxlist_opt ::= LP idxlist RP",
 /* 248 */ "idxlist ::= idxlist COMMA nm collate sortorder",
 /* 249 */ "idxlist ::= nm collate sortorder",
 /* 250 */ "collate ::=",
 /* 251 */ "collate ::= COLLATE ids",
 /* 252 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 253 */ "cmd ::= VACUUM",
 /* 254 */ "cmd ::= VACUUM nm",
 /* 255 */ "cmd ::= PRAGMA nm dbnm",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 257 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 258 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 259 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 260 */ "nmnum ::= plus_num",
 /* 261 */ "nmnum ::= nm",
 /* 262 */ "nmnum ::= ON",
 /* 263 */ "nmnum ::= DELETE",
 /* 264 */ "nmnum ::= DEFAULT",
 /* 265 */ "plus_num ::= plus_opt number",
 /* 266 */ "minus_num ::= MINUS number",
 /* 267 */ "number ::= INTEGER|FLOAT",
 /* 268 */ "plus_opt ::= PLUS",
 /* 269 */ "plus_opt ::=",
 /* 270 */ "cmd ::= createkw trigger_decl BEGIN trigger_cmd_list END",
 /* 271 */ "trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 272 */ "trigger_time ::= BEFORE",
 /* 273 */ "trigger_time ::= AFTER",
 /* 274 */ "trigger_time ::= INSTEAD OF",
 /* 275 */ "trigger_time ::=",
 /* 276 */ "trigger_event ::= DELETE|INSERT",
 /* 277 */ "trigger_event ::= UPDATE",
 /* 278 */ "trigger_event ::= UPDATE OF inscollist",
 /* 279 */ "foreach_clause ::=",
 /* 280 */ "foreach_clause ::= FOR EACH ROW",
 /* 281 */ "when_clause ::=",
 /* 282 */ "when_clause ::= WHEN expr",
 /* 283 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 284 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 285 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 286 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 287 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 288 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 289 */ "trigger_cmd ::= select",
 /* 290 */ "expr ::= RAISE LP IGNORE RP",
 /* 291 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 292 */ "raisetype ::= ROLLBACK",
 /* 293 */ "raisetype ::= ABORT",
 /* 294 */ "raisetype ::= FAIL",
 /* 295 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 296 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 297 */ "cmd ::= DETACH database_kw_opt expr",
 /* 298 */ "key_opt ::=",
 /* 299 */ "key_opt ::= KEY expr",
 /* 300 */ "database_kw_opt ::= DATABASE",
 /* 301 */ "database_kw_opt ::=",
 /* 302 */ "cmd ::= REINDEX",
 /* 303 */ "cmd ::= REINDEX nm dbnm",
 /* 304 */ "cmd ::= ANALYZE",
 /* 305 */ "cmd ::= ANALYZE nm dbnm",
 /* 306 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 307 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 308 */ "add_column_fullname ::= fullname",
 /* 309 */ "kwcolumn_opt ::=",
 /* 310 */ "kwcolumn_opt ::= COLUMNKW",
 /* 311 */ "cmd ::= create_vtab",
 /* 312 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 313 */ "create_vtab ::= createkw VIRTUAL TABLE nm dbnm USING nm",
 /* 314 */ "vtabarglist ::= vtabarg",
 /* 315 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 316 */ "vtabarg ::=",
 /* 317 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 318 */ "vtabargtoken ::= ANY",
 /* 319 */ "vtabargtoken ::= lp anylist RP",
 /* 320 */ "lp ::= LP",
 /* 321 */ "anylist ::=",
 /* 322 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3ParserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 160: /* select */
    case 194: /* oneselect */
{
#line 389 "parse.y"
sqlite3SelectDelete(pParse->db, (yypminor->yy243));
#line 1339 "parse.c"
}
      break;
    case 174: /* term */
    case 175: /* expr */
    case 199: /* where_opt */
    case 201: /* having_opt */
    case 210: /* on_opt */
    case 215: /* sortitem */
    case 223: /* escape */
    case 226: /* case_operand */
    case 228: /* case_else */
    case 239: /* when_clause */
    case 242: /* key_opt */
{
#line 700 "parse.y"
sqlite3ExprDelete(pParse->db, (yypminor->yy72));
#line 1356 "parse.c"
}
      break;
    case 179: /* idxlist_opt */
    case 187: /* idxlist */
    case 197: /* selcollist */
    case 200: /* groupby_opt */
    case 202: /* orderby_opt */
    case 204: /* sclp */
    case 214: /* sortlist */
    case 216: /* nexprlist */
    case 217: /* setlist */
    case 220: /* itemlist */
    case 221: /* exprlist */
    case 227: /* case_exprlist */
{
#line 962 "parse.y"
sqlite3ExprListDelete(pParse->db, (yypminor->yy148));
#line 1374 "parse.c"
}
      break;
    case 193: /* fullname */
    case 198: /* from */
    case 206: /* seltablist */
    case 207: /* stl_prefix */
{
#line 518 "parse.y"
sqlite3SrcListDelete(pParse->db, (yypminor->yy185));
#line 1384 "parse.c"
}
      break;
    case 211: /* using_opt */
    case 213: /* inscollist */
    case 219: /* inscollist_opt */
{
#line 550 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy254));
#line 1393 "parse.c"
}
      break;
    case 235: /* trigger_cmd_list */
    case 240: /* trigger_cmd */
{
#line 1069 "parse.y"
sqlite3DeleteTriggerStep(pParse->db, (yypminor->yy145));
#line 1401 "parse.c"
}
      break;
    case 237: /* trigger_event */
{
#line 1055 "parse.y"
sqlite3IdListDelete(pParse->db, (yypminor->yy332).b);
#line 1408 "parse.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3ParserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_MAX ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_MAX );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3ParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 40 "parse.y"

  UNUSED_PARAMETER(yypMinor); /* Silence some compiler warnings */
  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1586 "parse.c"
   sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 142, 1 },
  { 143, 2 },
  { 143, 1 },
  { 144, 1 },
  { 144, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 146, 1 },
  { 147, 3 },
  { 149, 0 },
  { 149, 1 },
  { 149, 2 },
  { 148, 0 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 147, 2 },
  { 147, 2 },
  { 147, 2 },
  { 151, 1 },
  { 151, 0 },
  { 147, 2 },
  { 147, 3 },
  { 147, 5 },
  { 147, 2 },
  { 152, 6 },
  { 154, 1 },
  { 156, 0 },
  { 156, 3 },
  { 155, 1 },
  { 155, 0 },
  { 153, 4 },
  { 153, 2 },
  { 158, 3 },
  { 158, 1 },
  { 161, 3 },
  { 162, 1 },
  { 165, 1 },
  { 165, 1 },
  { 166, 1 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 163, 0 },
  { 163, 1 },
  { 167, 1 },
  { 167, 4 },
  { 167, 6 },
  { 168, 1 },
  { 168, 2 },
  { 169, 1 },
  { 169, 1 },
  { 164, 2 },
  { 164, 0 },
  { 172, 3 },
  { 172, 1 },
  { 173, 2 },
  { 173, 4 },
  { 173, 3 },
  { 173, 3 },
  { 173, 2 },
  { 173, 2 },
  { 173, 3 },
  { 173, 5 },
  { 173, 2 },
  { 173, 4 },
  { 173, 4 },
  { 173, 1 },
  { 173, 2 },
  { 178, 0 },
  { 178, 1 },
  { 180, 0 },
  { 180, 2 },
  { 182, 2 },
  { 182, 3 },
  { 182, 3 },
  { 182, 3 },
  { 183, 2 },
  { 183, 2 },
  { 183, 1 },
  { 183, 1 },
  { 181, 3 },
  { 181, 2 },
  { 184, 0 },
  { 184, 2 },
  { 184, 2 },
  { 159, 0 },
  { 159, 2 },
  { 185, 3 },
  { 185, 2 },
  { 185, 1 },
  { 186, 2 },
  { 186, 7 },
  { 186, 5 },
  { 186, 5 },
  { 186, 10 },
  { 188, 0 },
  { 188, 1 },
  { 176, 0 },
  { 176, 3 },
  { 189, 0 },
  { 189, 2 },
  { 190, 1 },
  { 190, 1 },
  { 190, 1 },
  { 147, 4 },
  { 192, 2 },
  { 192, 0 },
  { 147, 8 },
  { 147, 4 },
  { 147, 1 },
  { 160, 1 },
  { 160, 3 },
  { 195, 1 },
  { 195, 2 },
  { 195, 1 },
  { 194, 9 },
  { 196, 1 },
  { 196, 1 },
  { 196, 0 },
  { 204, 2 },
  { 204, 0 },
  { 197, 3 },
  { 197, 2 },
  { 197, 4 },
  { 205, 2 },
  { 205, 1 },
  { 205, 0 },
  { 198, 0 },
  { 198, 2 },
  { 207, 2 },
  { 207, 0 },
  { 206, 7 },
  { 206, 7 },
  { 206, 7 },
  { 157, 0 },
  { 157, 2 },
  { 193, 2 },
  { 208, 1 },
  { 208, 2 },
  { 208, 3 },
  { 208, 4 },
  { 210, 2 },
  { 210, 0 },
  { 209, 0 },
  { 209, 3 },
  { 209, 2 },
  { 211, 4 },
  { 211, 0 },
  { 202, 0 },
  { 202, 3 },
  { 214, 4 },
  { 214, 2 },
  { 215, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 0 },
  { 200, 0 },
  { 200, 3 },
  { 201, 0 },
  { 201, 2 },
  { 203, 0 },
  { 203, 2 },
  { 203, 4 },
  { 203, 4 },
  { 147, 5 },
  { 199, 0 },
  { 199, 2 },
  { 147, 7 },
  { 217, 5 },
  { 217, 3 },
  { 147, 8 },
  { 147, 5 },
  { 147, 6 },
  { 218, 2 },
  { 218, 1 },
  { 220, 3 },
  { 220, 1 },
  { 219, 0 },
  { 219, 3 },
  { 213, 3 },
  { 213, 1 },
  { 175, 1 },
  { 175, 3 },
  { 174, 1 },
  { 175, 1 },
  { 175, 1 },
  { 175, 3 },
  { 175, 5 },
  { 174, 1 },
  { 174, 1 },
  { 175, 1 },
  { 175, 1 },
  { 175, 3 },
  { 175, 6 },
  { 175, 5 },
  { 175, 4 },
  { 174, 1 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 175, 3 },
  { 222, 1 },
  { 222, 2 },
  { 222, 1 },
  { 222, 2 },
  { 223, 2 },
  { 223, 0 },
  { 175, 4 },
  { 175, 2 },
  { 175, 3 },
  { 175, 3 },
  { 175, 4 },
  { 175, 2 },
  { 175, 2 },
  { 175, 2 },
  { 175, 2 },
  { 224, 1 },
  { 224, 2 },
  { 175, 5 },
  { 225, 1 },
  { 225, 2 },
  { 175, 5 },
  { 175, 3 },
  { 175, 5 },
  { 175, 4 },
  { 175, 4 },
  { 175, 5 },
  { 227, 5 },
  { 227, 4 },
  { 228, 2 },
  { 228, 0 },
  { 226, 1 },
  { 226, 0 },
  { 221, 1 },
  { 221, 0 },
  { 216, 3 },
  { 216, 1 },
  { 147, 11 },
  { 229, 1 },
  { 229, 0 },
  { 179, 0 },
  { 179, 3 },
  { 187, 5 },
  { 187, 3 },
  { 230, 0 },
  { 230, 2 },
  { 147, 4 },
  { 147, 1 },
  { 147, 2 },
  { 147, 3 },
  { 147, 5 },
  { 147, 6 },
  { 147, 5 },
  { 147, 6 },
  { 231, 1 },
  { 231, 1 },
  { 231, 1 },
  { 231, 1 },
  { 231, 1 },
  { 170, 2 },
  { 171, 2 },
  { 233, 1 },
  { 232, 1 },
  { 232, 0 },
  { 147, 5 },
  { 234, 11 },
  { 236, 1 },
  { 236, 1 },
  { 236, 2 },
  { 236, 0 },
  { 237, 1 },
  { 237, 1 },
  { 237, 3 },
  { 238, 0 },
  { 238, 3 },
  { 239, 0 },
  { 239, 2 },
  { 235, 3 },
  { 235, 2 },
  { 240, 6 },
  { 240, 8 },
  { 240, 5 },
  { 240, 4 },
  { 240, 1 },
  { 175, 4 },
  { 175, 6 },
  { 191, 1 },
  { 191, 1 },
  { 191, 1 },
  { 147, 4 },
  { 147, 6 },
  { 147, 3 },
  { 242, 0 },
  { 242, 2 },
  { 241, 1 },
  { 241, 0 },
  { 147, 1 },
  { 147, 3 },
  { 147, 1 },
  { 147, 3 },
  { 147, 6 },
  { 147, 6 },
  { 243, 1 },
  { 244, 0 },
  { 244, 1 },
  { 147, 1 },
  { 147, 4 },
  { 245, 7 },
  { 246, 1 },
  { 246, 3 },
  { 247, 0 },
  { 247, 2 },
  { 248, 1 },
  { 248, 3 },
  { 249, 1 },
  { 250, 0 },
  { 250, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* input ::= cmdlist */
      case 1: /* cmdlist ::= cmdlist ecmd */
      case 2: /* cmdlist ::= ecmd */
      case 3: /* ecmd ::= SEMI */
      case 4: /* ecmd ::= explain cmdx SEMI */
      case 10: /* trans_opt ::= */
      case 11: /* trans_opt ::= TRANSACTION */
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 20: /* savepoint_opt ::= SAVEPOINT */
      case 21: /* savepoint_opt ::= */
      case 25: /* cmd ::= create_table create_table_args */
      case 34: /* columnlist ::= columnlist COMMA column */
      case 35: /* columnlist ::= column */
      case 44: /* type ::= */
      case 51: /* signed ::= plus_num */
      case 52: /* signed ::= minus_num */
      case 53: /* carglist ::= carglist carg */
      case 54: /* carglist ::= */
      case 55: /* carg ::= CONSTRAINT nm ccons */
      case 56: /* carg ::= ccons */
      case 62: /* ccons ::= NULL onconf */
      case 89: /* conslist ::= conslist COMMA tcons */
      case 90: /* conslist ::= conslist tcons */
      case 91: /* conslist ::= tcons */
      case 92: /* tcons ::= CONSTRAINT nm */
      case 268: /* plus_opt ::= PLUS */
      case 269: /* plus_opt ::= */
      case 279: /* foreach_clause ::= */
      case 280: /* foreach_clause ::= FOR EACH ROW */
      case 300: /* database_kw_opt ::= DATABASE */
      case 301: /* database_kw_opt ::= */
      case 309: /* kwcolumn_opt ::= */
      case 310: /* kwcolumn_opt ::= COLUMNKW */
      case 314: /* vtabarglist ::= vtabarg */
      case 315: /* vtabarglist ::= vtabarglist COMMA vtabarg */
      case 317: /* vtabarg ::= vtabarg vtabargtoken */
      case 321: /* anylist ::= */
#line 93 "parse.y"
{
}
#line 2060 "parse.c"
        break;
      case 5: /* explain ::= */
#line 98 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 2065 "parse.c"
        break;
      case 6: /* explain ::= EXPLAIN */
#line 100 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 2070 "parse.c"
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
#line 101 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 2075 "parse.c"
        break;
      case 8: /* cmdx ::= cmd */
#line 103 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 2080 "parse.c"
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
#line 108 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy194);}
#line 2085 "parse.c"
        break;
      case 13: /* transtype ::= */
#line 113 "parse.y"
{yygotominor.yy194 = TK_DEFERRED;}
#line 2090 "parse.c"
        break;
      case 14: /* transtype ::= DEFERRED */
      case 15: /* transtype ::= IMMEDIATE */
      case 16: /* transtype ::= EXCLUSIVE */
      case 114: /* multiselect_op ::= UNION */
      case 116: /* multiselect_op ::= EXCEPT|INTERSECT */
#line 114 "parse.y"
{yygotominor.yy194 = yymsp[0].major;}
#line 2099 "parse.c"
        break;
      case 17: /* cmd ::= COMMIT trans_opt */
      case 18: /* cmd ::= END trans_opt */
#line 117 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 2105 "parse.c"
        break;
      case 19: /* cmd ::= ROLLBACK trans_opt */
#line 119 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 2110 "parse.c"
        break;
      case 22: /* cmd ::= SAVEPOINT nm */
#line 123 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_BEGIN, &yymsp[0].minor.yy0);
}
#line 2117 "parse.c"
        break;
      case 23: /* cmd ::= RELEASE savepoint_opt nm */
#line 126 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_RELEASE, &yymsp[0].minor.yy0);
}
#line 2124 "parse.c"
        break;
      case 24: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
#line 129 "parse.y"
{
  sqlite3Savepoint(pParse, SAVEPOINT_ROLLBACK, &yymsp[0].minor.yy0);
}
#line 2131 "parse.c"
        break;
      case 26: /* create_table ::= createkw temp TABLE ifnotexists nm dbnm */
#line 136 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,yymsp[-4].minor.yy194,0,0,yymsp[-2].minor.yy194);
}
#line 2138 "parse.c"
        break;
      case 27: /* createkw ::= CREATE */
#line 139 "parse.y"
{
  pParse->db->lookaside.bEnabled = 0;
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2146 "parse.c"
        break;
      case 28: /* ifnotexists ::= */
      case 31: /* temp ::= */
      case 70: /* autoinc ::= */
      case 84: /* init_deferred_pred_opt ::= */
      case 86: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
      case 97: /* defer_subclause_opt ::= */
      case 108: /* ifexists ::= */
      case 119: /* distinct ::= ALL */
      case 120: /* distinct ::= */
      case 222: /* between_op ::= BETWEEN */
      case 225: /* in_op ::= IN */
#line 144 "parse.y"
{yygotominor.yy194 = 0;}
#line 2161 "parse.c"
        break;
      case 29: /* ifnotexists ::= IF NOT EXISTS */
      case 30: /* temp ::= TEMP */
      case 71: /* autoinc ::= AUTOINCR */
      case 85: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
      case 107: /* ifexists ::= IF EXISTS */
      case 118: /* distinct ::= DISTINCT */
      case 223: /* between_op ::= NOT BETWEEN */
      case 226: /* in_op ::= NOT IN */
#line 145 "parse.y"
{yygotominor.yy194 = 1;}
#line 2173 "parse.c"
        break;
      case 32: /* create_table_args ::= LP columnlist conslist_opt RP */
#line 151 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0);
}
#line 2180 "parse.c"
        break;
      case 33: /* create_table_args ::= AS select */
#line 154 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy243);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy243);
}
#line 2188 "parse.c"
        break;
      case 36: /* column ::= columnid type carglist */
#line 166 "parse.y"
{
  yygotominor.yy0.z = yymsp[-2].minor.yy0.z;
  yygotominor.yy0.n = (int)(pParse->sLastToken.z-yymsp[-2].minor.yy0.z) + pParse->sLastToken.n;
}
#line 2196 "parse.c"
        break;
      case 37: /* columnid ::= nm */
#line 170 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy0);
  yygotominor.yy0 = yymsp[0].minor.yy0;
}
#line 2204 "parse.c"
        break;
      case 38: /* id ::= ID */
      case 39: /* id ::= INDEXED */
      case 40: /* ids ::= ID|STRING */
      case 41: /* nm ::= id */
      case 42: /* nm ::= STRING */
      case 43: /* nm ::= JOIN_KW */
      case 46: /* typetoken ::= typename */
      case 49: /* typename ::= ids */
      case 126: /* as ::= AS nm */
      case 127: /* as ::= ids */
      case 137: /* dbnm ::= DOT nm */
      case 146: /* indexed_opt ::= INDEXED BY nm */
      case 251: /* collate ::= COLLATE ids */
      case 260: /* nmnum ::= plus_num */
      case 261: /* nmnum ::= nm */
      case 262: /* nmnum ::= ON */
      case 263: /* nmnum ::= DELETE */
      case 264: /* nmnum ::= DEFAULT */
      case 265: /* plus_num ::= plus_opt number */
      case 266: /* minus_num ::= MINUS number */
      case 267: /* number ::= INTEGER|FLOAT */
#line 180 "parse.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2229 "parse.c"
        break;
      case 45: /* type ::= typetoken */
#line 242 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy0);}
#line 2234 "parse.c"
        break;
      case 47: /* typetoken ::= typename LP signed RP */
#line 244 "parse.y"
{
  yygotominor.yy0.z = yymsp[-3].minor.yy0.z;
  yygotominor.yy0.n = (int)(&yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy0.z);
}
#line 2242 "parse.c"
        break;
      case 48: /* typetoken ::= typename LP signed COMMA signed RP */
#line 248 "parse.y"
{
  yygotominor.yy0.z = yymsp[-5].minor.yy0.z;
  yygotominor.yy0.n = (int)(&yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy0.z);
}
#line 2250 "parse.c"
        break;
      case 50: /* typename ::= typename ids */
#line 254 "parse.y"
{yygotominor.yy0.z=yymsp[-1].minor.yy0.z; yygotominor.yy0.n=yymsp[0].minor.yy0.n+(int)(yymsp[0].minor.yy0.z-yymsp[-1].minor.yy0.z);}
#line 2255 "parse.c"
        break;
      case 57: /* ccons ::= DEFAULT term */
      case 59: /* ccons ::= DEFAULT PLUS term */
#line 265 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy72);}
#line 2261 "parse.c"
        break;
      case 58: /* ccons ::= DEFAULT LP expr RP */
#line 266 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy72);}
#line 2266 "parse.c"
        break;
      case 60: /* ccons ::= DEFAULT MINUS term */
#line 268 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy72, 0, 0);
  sqlite3ExprSpan(p,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy72->span);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2275 "parse.c"
        break;
      case 61: /* ccons ::= DEFAULT id */
#line 273 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_STRING, 0, 0, &yymsp[0].minor.yy0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2283 "parse.c"
        break;
      case 63: /* ccons ::= NOT NULL onconf */
#line 282 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy194);}
#line 2288 "parse.c"
        break;
      case 64: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
#line 284 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy194,yymsp[0].minor.yy194,yymsp[-2].minor.yy194);}
#line 2293 "parse.c"
        break;
      case 65: /* ccons ::= UNIQUE onconf */
#line 285 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy194,0,0,0,0);}
#line 2298 "parse.c"
        break;
      case 66: /* ccons ::= CHECK LP expr RP */
#line 286 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy72);}
#line 2303 "parse.c"
        break;
      case 67: /* ccons ::= REFERENCES nm idxlist_opt refargs */
#line 288 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy0,yymsp[-1].minor.yy148,yymsp[0].minor.yy194);}
#line 2308 "parse.c"
        break;
      case 68: /* ccons ::= defer_subclause */
#line 289 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy194);}
#line 2313 "parse.c"
        break;
      case 69: /* ccons ::= COLLATE ids */
#line 290 "parse.y"
{sqlite3AddCollateType(pParse, &yymsp[0].minor.yy0);}
#line 2318 "parse.c"
        break;
      case 72: /* refargs ::= */
#line 303 "parse.y"
{ yygotominor.yy194 = OE_Restrict * 0x010101; }
#line 2323 "parse.c"
        break;
      case 73: /* refargs ::= refargs refarg */
#line 304 "parse.y"
{ yygotominor.yy194 = (yymsp[-1].minor.yy194 & ~yymsp[0].minor.yy497.mask) | yymsp[0].minor.yy497.value; }
#line 2328 "parse.c"
        break;
      case 74: /* refarg ::= MATCH nm */
#line 306 "parse.y"
{ yygotominor.yy497.value = 0;     yygotominor.yy497.mask = 0x000000; }
#line 2333 "parse.c"
        break;
      case 75: /* refarg ::= ON DELETE refact */
#line 307 "parse.y"
{ yygotominor.yy497.value = yymsp[0].minor.yy194;     yygotominor.yy497.mask = 0x0000ff; }
#line 2338 "parse.c"
        break;
      case 76: /* refarg ::= ON UPDATE refact */
#line 308 "parse.y"
{ yygotominor.yy497.value = yymsp[0].minor.yy194<<8;  yygotominor.yy497.mask = 0x00ff00; }
#line 2343 "parse.c"
        break;
      case 77: /* refarg ::= ON INSERT refact */
#line 309 "parse.y"
{ yygotominor.yy497.value = yymsp[0].minor.yy194<<16; yygotominor.yy497.mask = 0xff0000; }
#line 2348 "parse.c"
        break;
      case 78: /* refact ::= SET NULL */
#line 311 "parse.y"
{ yygotominor.yy194 = OE_SetNull; }
#line 2353 "parse.c"
        break;
      case 79: /* refact ::= SET DEFAULT */
#line 312 "parse.y"
{ yygotominor.yy194 = OE_SetDflt; }
#line 2358 "parse.c"
        break;
      case 80: /* refact ::= CASCADE */
#line 313 "parse.y"
{ yygotominor.yy194 = OE_Cascade; }
#line 2363 "parse.c"
        break;
      case 81: /* refact ::= RESTRICT */
#line 314 "parse.y"
{ yygotominor.yy194 = OE_Restrict; }
#line 2368 "parse.c"
        break;
      case 82: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
      case 83: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
      case 98: /* defer_subclause_opt ::= defer_subclause */
      case 100: /* onconf ::= ON CONFLICT resolvetype */
      case 102: /* orconf ::= OR resolvetype */
      case 103: /* resolvetype ::= raisetype */
      case 175: /* insert_cmd ::= INSERT orconf */
#line 316 "parse.y"
{yygotominor.yy194 = yymsp[0].minor.yy194;}
#line 2379 "parse.c"
        break;
      case 87: /* conslist_opt ::= */
#line 326 "parse.y"
{yygotominor.yy0.n = 0; yygotominor.yy0.z = 0;}
#line 2384 "parse.c"
        break;
      case 88: /* conslist_opt ::= COMMA conslist */
#line 327 "parse.y"
{yygotominor.yy0 = yymsp[-1].minor.yy0;}
#line 2389 "parse.c"
        break;
      case 93: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
#line 333 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy148,yymsp[0].minor.yy194,yymsp[-2].minor.yy194,0);}
#line 2394 "parse.c"
        break;
      case 94: /* tcons ::= UNIQUE LP idxlist RP onconf */
#line 335 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy148,yymsp[0].minor.yy194,0,0,0,0);}
#line 2399 "parse.c"
        break;
      case 95: /* tcons ::= CHECK LP expr RP onconf */
#line 336 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy72);}
#line 2404 "parse.c"
        break;
      case 96: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
#line 338 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy148, &yymsp[-3].minor.yy0, yymsp[-2].minor.yy148, yymsp[-1].minor.yy194);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy194);
}
#line 2412 "parse.c"
        break;
      case 99: /* onconf ::= */
      case 101: /* orconf ::= */
#line 352 "parse.y"
{yygotominor.yy194 = OE_Default;}
#line 2418 "parse.c"
        break;
      case 104: /* resolvetype ::= IGNORE */
#line 357 "parse.y"
{yygotominor.yy194 = OE_Ignore;}
#line 2423 "parse.c"
        break;
      case 105: /* resolvetype ::= REPLACE */
      case 176: /* insert_cmd ::= REPLACE */
#line 358 "parse.y"
{yygotominor.yy194 = OE_Replace;}
#line 2429 "parse.c"
        break;
      case 106: /* cmd ::= DROP TABLE ifexists fullname */
#line 362 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy185, 0, yymsp[-1].minor.yy194);
}
#line 2436 "parse.c"
        break;
      case 109: /* cmd ::= createkw temp VIEW ifnotexists nm dbnm AS select */
#line 372 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-7].minor.yy0, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, yymsp[0].minor.yy243, yymsp[-6].minor.yy194, yymsp[-4].minor.yy194);
}
#line 2443 "parse.c"
        break;
      case 110: /* cmd ::= DROP VIEW ifexists fullname */
#line 375 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy185, 1, yymsp[-1].minor.yy194);
}
#line 2450 "parse.c"
        break;
      case 111: /* cmd ::= select */
#line 382 "parse.y"
{
  SelectDest dest = {SRT_Output, 0, 0, 0, 0};
  sqlite3Select(pParse, yymsp[0].minor.yy243, &dest);
  sqlite3SelectDelete(pParse->db, yymsp[0].minor.yy243);
}
#line 2459 "parse.c"
        break;
      case 112: /* select ::= oneselect */
#line 393 "parse.y"
{yygotominor.yy243 = yymsp[0].minor.yy243;}
#line 2464 "parse.c"
        break;
      case 113: /* select ::= select multiselect_op oneselect */
#line 395 "parse.y"
{
  if( yymsp[0].minor.yy243 ){
    yymsp[0].minor.yy243->op = (u8)yymsp[-1].minor.yy194;
    yymsp[0].minor.yy243->pPrior = yymsp[-2].minor.yy243;
  }else{
    sqlite3SelectDelete(pParse->db, yymsp[-2].minor.yy243);
  }
  yygotominor.yy243 = yymsp[0].minor.yy243;
}
#line 2477 "parse.c"
        break;
      case 115: /* multiselect_op ::= UNION ALL */
#line 406 "parse.y"
{yygotominor.yy194 = TK_ALL;}
#line 2482 "parse.c"
        break;
      case 117: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 410 "parse.y"
{
  yygotominor.yy243 = sqlite3SelectNew(pParse,yymsp[-6].minor.yy148,yymsp[-5].minor.yy185,yymsp[-4].minor.yy72,yymsp[-3].minor.yy148,yymsp[-2].minor.yy72,yymsp[-1].minor.yy148,yymsp[-7].minor.yy194,yymsp[0].minor.yy354.pLimit,yymsp[0].minor.yy354.pOffset);
}
#line 2489 "parse.c"
        break;
      case 121: /* sclp ::= selcollist COMMA */
      case 247: /* idxlist_opt ::= LP idxlist RP */
#line 431 "parse.y"
{yygotominor.yy148 = yymsp[-1].minor.yy148;}
#line 2495 "parse.c"
        break;
      case 122: /* sclp ::= */
      case 150: /* orderby_opt ::= */
      case 158: /* groupby_opt ::= */
      case 240: /* exprlist ::= */
      case 246: /* idxlist_opt ::= */
#line 432 "parse.y"
{yygotominor.yy148 = 0;}
#line 2504 "parse.c"
        break;
      case 123: /* selcollist ::= sclp expr as */
#line 433 "parse.y"
{
   yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy148,yymsp[-1].minor.yy72,yymsp[0].minor.yy0.n?&yymsp[0].minor.yy0:0);
}
#line 2511 "parse.c"
        break;
      case 124: /* selcollist ::= sclp STAR */
#line 436 "parse.y"
{
  Expr *p = sqlite3PExpr(pParse, TK_ALL, 0, 0, 0);
  yygotominor.yy148 = sqlite3ExprListAppend(pParse, yymsp[-1].minor.yy148, p, 0);
}
#line 2519 "parse.c"
        break;
      case 125: /* selcollist ::= sclp nm DOT STAR */
#line 440 "parse.y"
{
  Expr *pRight = sqlite3PExpr(pParse, TK_ALL, 0, 0, &yymsp[0].minor.yy0);
  Expr *pLeft = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *pDot = sqlite3PExpr(pParse, TK_DOT, pLeft, pRight, 0);
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy148, pDot, 0);
}
#line 2529 "parse.c"
        break;
      case 128: /* as ::= */
#line 453 "parse.y"
{yygotominor.yy0.n = 0;}
#line 2534 "parse.c"
        break;
      case 129: /* from ::= */
#line 465 "parse.y"
{yygotominor.yy185 = sqlite3DbMallocZero(pParse->db, sizeof(*yygotominor.yy185));}
#line 2539 "parse.c"
        break;
      case 130: /* from ::= FROM seltablist */
#line 466 "parse.y"
{
  yygotominor.yy185 = yymsp[0].minor.yy185;
  sqlite3SrcListShiftJoinType(yygotominor.yy185);
}
#line 2547 "parse.c"
        break;
      case 131: /* stl_prefix ::= seltablist joinop */
#line 474 "parse.y"
{
   yygotominor.yy185 = yymsp[-1].minor.yy185;
   if( yygotominor.yy185 && yygotominor.yy185->nSrc>0 ) yygotominor.yy185->a[yygotominor.yy185->nSrc-1].jointype = (u8)yymsp[0].minor.yy194;
}
#line 2555 "parse.c"
        break;
      case 132: /* stl_prefix ::= */
#line 478 "parse.y"
{yygotominor.yy185 = 0;}
#line 2560 "parse.c"
        break;
      case 133: /* seltablist ::= stl_prefix nm dbnm as indexed_opt on_opt using_opt */
#line 479 "parse.y"
{
  yygotominor.yy185 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy185,&yymsp[-5].minor.yy0,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,0,yymsp[-1].minor.yy72,yymsp[0].minor.yy254);
  sqlite3SrcListIndexedBy(pParse, yygotominor.yy185, &yymsp[-2].minor.yy0);
}
#line 2568 "parse.c"
        break;
      case 134: /* seltablist ::= stl_prefix LP select RP as on_opt using_opt */
#line 485 "parse.y"
{
    yygotominor.yy185 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy185,0,0,&yymsp[-2].minor.yy0,yymsp[-4].minor.yy243,yymsp[-1].minor.yy72,yymsp[0].minor.yy254);
  }
#line 2575 "parse.c"
        break;
      case 135: /* seltablist ::= stl_prefix LP seltablist RP as on_opt using_opt */
#line 489 "parse.y"
{
    if( yymsp[-6].minor.yy185==0 && yymsp[-2].minor.yy0.n==0 && yymsp[-1].minor.yy72==0 && yymsp[0].minor.yy254==0 ){
      yygotominor.yy185 = yymsp[-4].minor.yy185;
    }else{
      Select *pSubquery;
      sqlite3SrcListShiftJoinType(yymsp[-4].minor.yy185);
      pSubquery = sqlite3SelectNew(pParse,0,yymsp[-4].minor.yy185,0,0,0,0,0,0,0);
      yygotominor.yy185 = sqlite3SrcListAppendFromTerm(pParse,yymsp[-6].minor.yy185,0,0,&yymsp[-2].minor.yy0,pSubquery,yymsp[-1].minor.yy72,yymsp[0].minor.yy254);
    }
  }
#line 2589 "parse.c"
        break;
      case 136: /* dbnm ::= */
      case 145: /* indexed_opt ::= */
#line 514 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=0;}
#line 2595 "parse.c"
        break;
      case 138: /* fullname ::= nm dbnm */
#line 519 "parse.y"
{yygotominor.yy185 = sqlite3SrcListAppend(pParse->db,0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);}
#line 2600 "parse.c"
        break;
      case 139: /* joinop ::= COMMA|JOIN */
#line 523 "parse.y"
{ yygotominor.yy194 = JT_INNER; }
#line 2605 "parse.c"
        break;
      case 140: /* joinop ::= JOIN_KW JOIN */
#line 524 "parse.y"
{ yygotominor.yy194 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2610 "parse.c"
        break;
      case 141: /* joinop ::= JOIN_KW nm JOIN */
#line 525 "parse.y"
{ yygotominor.yy194 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0,0); }
#line 2615 "parse.c"
        break;
      case 142: /* joinop ::= JOIN_KW nm nm JOIN */
#line 527 "parse.y"
{ yygotominor.yy194 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy0); }
#line 2620 "parse.c"
        break;
      case 143: /* on_opt ::= ON expr */
      case 154: /* sortitem ::= expr */
      case 161: /* having_opt ::= HAVING expr */
      case 168: /* where_opt ::= WHERE expr */
      case 183: /* expr ::= term */
      case 211: /* escape ::= ESCAPE expr */
      case 235: /* case_else ::= ELSE expr */
      case 237: /* case_operand ::= expr */
#line 531 "parse.y"
{yygotominor.yy72 = yymsp[0].minor.yy72;}
#line 2632 "parse.c"
        break;
      case 144: /* on_opt ::= */
      case 160: /* having_opt ::= */
      case 167: /* where_opt ::= */
      case 212: /* escape ::= */
      case 236: /* case_else ::= */
      case 238: /* case_operand ::= */
#line 532 "parse.y"
{yygotominor.yy72 = 0;}
#line 2642 "parse.c"
        break;
      case 147: /* indexed_opt ::= NOT INDEXED */
#line 547 "parse.y"
{yygotominor.yy0.z=0; yygotominor.yy0.n=1;}
#line 2647 "parse.c"
        break;
      case 148: /* using_opt ::= USING LP inscollist RP */
      case 180: /* inscollist_opt ::= LP inscollist RP */
#line 551 "parse.y"
{yygotominor.yy254 = yymsp[-1].minor.yy254;}
#line 2653 "parse.c"
        break;
      case 149: /* using_opt ::= */
      case 179: /* inscollist_opt ::= */
#line 552 "parse.y"
{yygotominor.yy254 = 0;}
#line 2659 "parse.c"
        break;
      case 151: /* orderby_opt ::= ORDER BY sortlist */
      case 159: /* groupby_opt ::= GROUP BY nexprlist */
      case 239: /* exprlist ::= nexprlist */
#line 563 "parse.y"
{yygotominor.yy148 = yymsp[0].minor.yy148;}
#line 2666 "parse.c"
        break;
      case 152: /* sortlist ::= sortlist COMMA sortitem sortorder */
#line 564 "parse.y"
{
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-3].minor.yy148,yymsp[-1].minor.yy72,0);
  if( yygotominor.yy148 ) yygotominor.yy148->a[yygotominor.yy148->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy194;
}
#line 2674 "parse.c"
        break;
      case 153: /* sortlist ::= sortitem sortorder */
#line 568 "parse.y"
{
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,0,yymsp[-1].minor.yy72,0);
  if( yygotominor.yy148 && yygotominor.yy148->a ) yygotominor.yy148->a[0].sortOrder = (u8)yymsp[0].minor.yy194;
}
#line 2682 "parse.c"
        break;
      case 155: /* sortorder ::= ASC */
      case 157: /* sortorder ::= */
#line 576 "parse.y"
{yygotominor.yy194 = SQLITE_SO_ASC;}
#line 2688 "parse.c"
        break;
      case 156: /* sortorder ::= DESC */
#line 577 "parse.y"
{yygotominor.yy194 = SQLITE_SO_DESC;}
#line 2693 "parse.c"
        break;
      case 162: /* limit_opt ::= */
#line 603 "parse.y"
{yygotominor.yy354.pLimit = 0; yygotominor.yy354.pOffset = 0;}
#line 2698 "parse.c"
        break;
      case 163: /* limit_opt ::= LIMIT expr */
#line 604 "parse.y"
{yygotominor.yy354.pLimit = yymsp[0].minor.yy72; yygotominor.yy354.pOffset = 0;}
#line 2703 "parse.c"
        break;
      case 164: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 606 "parse.y"
{yygotominor.yy354.pLimit = yymsp[-2].minor.yy72; yygotominor.yy354.pOffset = yymsp[0].minor.yy72;}
#line 2708 "parse.c"
        break;
      case 165: /* limit_opt ::= LIMIT expr COMMA expr */
#line 608 "parse.y"
{yygotominor.yy354.pOffset = yymsp[-2].minor.yy72; yygotominor.yy354.pLimit = yymsp[0].minor.yy72;}
#line 2713 "parse.c"
        break;
      case 166: /* cmd ::= DELETE FROM fullname indexed_opt where_opt */
#line 621 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-2].minor.yy185, &yymsp[-1].minor.yy0);
  sqlite3DeleteFrom(pParse,yymsp[-2].minor.yy185,yymsp[0].minor.yy72);
}
#line 2721 "parse.c"
        break;
      case 169: /* cmd ::= UPDATE orconf fullname indexed_opt SET setlist where_opt */
#line 644 "parse.y"
{
  sqlite3SrcListIndexedBy(pParse, yymsp[-4].minor.yy185, &yymsp[-3].minor.yy0);
  sqlite3ExprListCheckLength(pParse,yymsp[-1].minor.yy148,"set list"); 
  sqlite3Update(pParse,yymsp[-4].minor.yy185,yymsp[-1].minor.yy148,yymsp[0].minor.yy72,yymsp[-5].minor.yy194);
}
#line 2730 "parse.c"
        break;
      case 170: /* setlist ::= setlist COMMA nm EQ expr */
#line 655 "parse.y"
{yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy148,yymsp[0].minor.yy72,&yymsp[-2].minor.yy0);}
#line 2735 "parse.c"
        break;
      case 171: /* setlist ::= nm EQ expr */
#line 657 "parse.y"
{yygotominor.yy148 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy72,&yymsp[-2].minor.yy0);}
#line 2740 "parse.c"
        break;
      case 172: /* cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP */
#line 663 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy185, yymsp[-1].minor.yy148, 0, yymsp[-4].minor.yy254, yymsp[-7].minor.yy194);}
#line 2745 "parse.c"
        break;
      case 173: /* cmd ::= insert_cmd INTO fullname inscollist_opt select */
#line 665 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy185, 0, yymsp[0].minor.yy243, yymsp[-1].minor.yy254, yymsp[-4].minor.yy194);}
#line 2750 "parse.c"
        break;
      case 174: /* cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
#line 667 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy185, 0, 0, yymsp[-2].minor.yy254, yymsp[-5].minor.yy194);}
#line 2755 "parse.c"
        break;
      case 177: /* itemlist ::= itemlist COMMA expr */
      case 241: /* nexprlist ::= nexprlist COMMA expr */
#line 678 "parse.y"
{yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-2].minor.yy148,yymsp[0].minor.yy72,0);}
#line 2761 "parse.c"
        break;
      case 178: /* itemlist ::= expr */
      case 242: /* nexprlist ::= expr */
#line 680 "parse.y"
{yygotominor.yy148 = sqlite3ExprListAppend(pParse,0,yymsp[0].minor.yy72,0);}
#line 2767 "parse.c"
        break;
      case 181: /* inscollist ::= inscollist COMMA nm */
#line 690 "parse.y"
{yygotominor.yy254 = sqlite3IdListAppend(pParse->db,yymsp[-2].minor.yy254,&yymsp[0].minor.yy0);}
#line 2772 "parse.c"
        break;
      case 182: /* inscollist ::= nm */
#line 692 "parse.y"
{yygotominor.yy254 = sqlite3IdListAppend(pParse->db,0,&yymsp[0].minor.yy0);}
#line 2777 "parse.c"
        break;
      case 184: /* expr ::= LP expr RP */
#line 703 "parse.y"
{yygotominor.yy72 = yymsp[-1].minor.yy72; sqlite3ExprSpan(yygotominor.yy72,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2782 "parse.c"
        break;
      case 185: /* term ::= NULL */
      case 190: /* term ::= INTEGER|FLOAT|BLOB */
      case 191: /* term ::= STRING */
#line 704 "parse.y"
{yygotominor.yy72 = sqlite3PExpr(pParse, yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2789 "parse.c"
        break;
      case 186: /* expr ::= id */
      case 187: /* expr ::= JOIN_KW */
#line 705 "parse.y"
{yygotominor.yy72 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2795 "parse.c"
        break;
      case 188: /* expr ::= nm DOT nm */
#line 707 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_DOT, temp1, temp2, 0);
}
#line 2804 "parse.c"
        break;
      case 189: /* expr ::= nm DOT nm DOT nm */
#line 712 "parse.y"
{
  Expr *temp1 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-4].minor.yy0);
  Expr *temp2 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[-2].minor.yy0);
  Expr *temp3 = sqlite3PExpr(pParse, TK_ID, 0, 0, &yymsp[0].minor.yy0);
  Expr *temp4 = sqlite3PExpr(pParse, TK_DOT, temp2, temp3, 0);
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_DOT, temp1, temp4, 0);
}
#line 2815 "parse.c"
        break;
      case 192: /* expr ::= REGISTER */
#line 721 "parse.y"
{yygotominor.yy72 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2820 "parse.c"
        break;
      case 193: /* expr ::= VARIABLE */
#line 722 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy72 = sqlite3PExpr(pParse, TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2829 "parse.c"
        break;
      case 194: /* expr ::= expr COLLATE ids */
#line 727 "parse.y"
{
  yygotominor.yy72 = sqlite3ExprSetColl(pParse, yymsp[-2].minor.yy72, &yymsp[0].minor.yy0);
}
#line 2836 "parse.c"
        break;
      case 195: /* expr ::= CAST LP expr AS typetoken RP */
#line 731 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_CAST, yymsp[-3].minor.yy72, 0, &yymsp[-1].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2844 "parse.c"
        break;
      case 196: /* expr ::= ID LP distinct exprlist RP */
#line 736 "parse.y"
{
  if( yymsp[-1].minor.yy148 && yymsp[-1].minor.yy148->nExpr>SQLITE_MAX_FUNCTION_ARG ){
    sqlite3ErrorMsg(pParse, "too many arguments on function %T", &yymsp[-4].minor.yy0);
  }
  yygotominor.yy72 = sqlite3ExprFunction(pParse, yymsp[-1].minor.yy148, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy194 && yygotominor.yy72 ){
    yygotominor.yy72->flags |= EP_Distinct;
  }
}
#line 2858 "parse.c"
        break;
      case 197: /* expr ::= ID LP STAR RP */
#line 746 "parse.y"
{
  yygotominor.yy72 = sqlite3ExprFunction(pParse, 0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2866 "parse.c"
        break;
      case 198: /* term ::= CTIME_KW */
#line 750 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy72 = sqlite3ExprFunction(pParse, 0,&yymsp[0].minor.yy0);
  if( yygotominor.yy72 ){
    yygotominor.yy72->op = TK_CONST_FUNC;  
    yygotominor.yy72->span = yymsp[0].minor.yy0;
  }
}
#line 2879 "parse.c"
        break;
      case 199: /* expr ::= expr AND expr */
      case 200: /* expr ::= expr OR expr */
      case 201: /* expr ::= expr LT|GT|GE|LE expr */
      case 202: /* expr ::= expr EQ|NE expr */
      case 203: /* expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */
      case 204: /* expr ::= expr PLUS|MINUS expr */
      case 205: /* expr ::= expr STAR|SLASH|REM expr */
      case 206: /* expr ::= expr CONCAT expr */
#line 759 "parse.y"
{yygotominor.yy72 = sqlite3PExpr(pParse,yymsp[-1].major,yymsp[-2].minor.yy72,yymsp[0].minor.yy72,0);}
#line 2891 "parse.c"
        break;
      case 207: /* likeop ::= LIKE_KW */
      case 209: /* likeop ::= MATCH */
#line 771 "parse.y"
{yygotominor.yy392.eOperator = yymsp[0].minor.yy0; yygotominor.yy392.not = 0;}
#line 2897 "parse.c"
        break;
      case 208: /* likeop ::= NOT LIKE_KW */
      case 210: /* likeop ::= NOT MATCH */
#line 772 "parse.y"
{yygotominor.yy392.eOperator = yymsp[0].minor.yy0; yygotominor.yy392.not = 1;}
#line 2903 "parse.c"
        break;
      case 213: /* expr ::= expr likeop expr escape */
#line 779 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(pParse,0, yymsp[-1].minor.yy72, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[-3].minor.yy72, 0);
  if( yymsp[0].minor.yy72 ){
    pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy72, 0);
  }
  yygotominor.yy72 = sqlite3ExprFunction(pParse, pList, &yymsp[-2].minor.yy392.eOperator);
  if( yymsp[-2].minor.yy392.not ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72, &yymsp[-3].minor.yy72->span, &yymsp[-1].minor.yy72->span);
  if( yygotominor.yy72 ) yygotominor.yy72->flags |= EP_InfixFunc;
}
#line 2919 "parse.c"
        break;
      case 214: /* expr ::= expr ISNULL|NOTNULL */
#line 792 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, yymsp[0].major, yymsp[-1].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-1].minor.yy72->span,&yymsp[0].minor.yy0);
}
#line 2927 "parse.c"
        break;
      case 215: /* expr ::= expr IS NULL */
#line 796 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_ISNULL, yymsp[-2].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-2].minor.yy72->span,&yymsp[0].minor.yy0);
}
#line 2935 "parse.c"
        break;
      case 216: /* expr ::= expr NOT NULL */
#line 800 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-2].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-2].minor.yy72->span,&yymsp[0].minor.yy0);
}
#line 2943 "parse.c"
        break;
      case 217: /* expr ::= expr IS NOT NULL */
#line 804 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOTNULL, yymsp[-3].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-3].minor.yy72->span,&yymsp[0].minor.yy0);
}
#line 2951 "parse.c"
        break;
      case 218: /* expr ::= NOT expr */
      case 219: /* expr ::= BITNOT expr */
#line 808 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, yymsp[-1].major, yymsp[0].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy72->span);
}
#line 2960 "parse.c"
        break;
      case 220: /* expr ::= MINUS expr */
#line 816 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_UMINUS, yymsp[0].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy72->span);
}
#line 2968 "parse.c"
        break;
      case 221: /* expr ::= PLUS expr */
#line 820 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_UPLUS, yymsp[0].minor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy72->span);
}
#line 2976 "parse.c"
        break;
      case 224: /* expr ::= expr between_op expr AND expr */
#line 827 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy72, 0);
  pList = sqlite3ExprListAppend(pParse,pList, yymsp[0].minor.yy72, 0);
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_BETWEEN, yymsp[-4].minor.yy72, 0, 0);
  if( yygotominor.yy72 ){
    yygotominor.yy72->x.pList = pList;
  }else{
    sqlite3ExprListDelete(pParse->db, pList);
  } 
  if( yymsp[-3].minor.yy194 ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
  sqlite3ExprSpan(yygotominor.yy72,&yymsp[-4].minor.yy72->span,&yymsp[0].minor.yy72->span);
}
#line 2992 "parse.c"
        break;
      case 227: /* expr ::= expr in_op LP exprlist RP */
#line 843 "parse.y"
{
    yygotominor.yy72 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy72, 0, 0);
    if( yygotominor.yy72 ){
      yygotominor.yy72->x.pList = yymsp[-1].minor.yy148;
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3ExprListDelete(pParse->db, yymsp[-1].minor.yy148);
    }
    if( yymsp[-3].minor.yy194 ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
    sqlite3ExprSpan(yygotominor.yy72,&yymsp[-4].minor.yy72->span,&yymsp[0].minor.yy0);
  }
#line 3007 "parse.c"
        break;
      case 228: /* expr ::= LP select RP */
#line 854 "parse.y"
{
    yygotominor.yy72 = sqlite3PExpr(pParse, TK_SELECT, 0, 0, 0);
    if( yygotominor.yy72 ){
      yygotominor.yy72->x.pSelect = yymsp[-1].minor.yy243;
      ExprSetProperty(yygotominor.yy72, EP_xIsSelect);
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy243);
    }
    sqlite3ExprSpan(yygotominor.yy72,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 3022 "parse.c"
        break;
      case 229: /* expr ::= expr in_op LP select RP */
#line 865 "parse.y"
{
    yygotominor.yy72 = sqlite3PExpr(pParse, TK_IN, yymsp[-4].minor.yy72, 0, 0);
    if( yygotominor.yy72 ){
      yygotominor.yy72->x.pSelect = yymsp[-1].minor.yy243;
      ExprSetProperty(yygotominor.yy72, EP_xIsSelect);
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy243);
    }
    if( yymsp[-3].minor.yy194 ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
    sqlite3ExprSpan(yygotominor.yy72,&yymsp[-4].minor.yy72->span,&yymsp[0].minor.yy0);
  }
#line 3038 "parse.c"
        break;
      case 230: /* expr ::= expr in_op nm dbnm */
#line 877 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(pParse->db, 0,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0);
    yygotominor.yy72 = sqlite3PExpr(pParse, TK_IN, yymsp[-3].minor.yy72, 0, 0);
    if( yygotominor.yy72 ){
      yygotominor.yy72->x.pSelect = sqlite3SelectNew(pParse, 0,pSrc,0,0,0,0,0,0,0);
      ExprSetProperty(yygotominor.yy72, EP_xIsSelect);
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3SrcListDelete(pParse->db, pSrc);
    }
    if( yymsp[-2].minor.yy194 ) yygotominor.yy72 = sqlite3PExpr(pParse, TK_NOT, yygotominor.yy72, 0, 0);
    sqlite3ExprSpan(yygotominor.yy72,&yymsp[-3].minor.yy72->span,yymsp[0].minor.yy0.z?&yymsp[0].minor.yy0:&yymsp[-1].minor.yy0);
  }
#line 3055 "parse.c"
        break;
      case 231: /* expr ::= EXISTS LP select RP */
#line 890 "parse.y"
{
    Expr *p = yygotominor.yy72 = sqlite3PExpr(pParse, TK_EXISTS, 0, 0, 0);
    if( p ){
      p->x.pSelect = yymsp[-1].minor.yy243;
      ExprSetProperty(yygotominor.yy72, EP_xIsSelect);
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
      sqlite3ExprSetHeight(pParse, yygotominor.yy72);
    }else{
      sqlite3SelectDelete(pParse->db, yymsp[-1].minor.yy243);
    }
  }
#line 3070 "parse.c"
        break;
      case 232: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 904 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_CASE, yymsp[-3].minor.yy72, yymsp[-1].minor.yy72, 0);
  if( yygotominor.yy72 ){
    yygotominor.yy72->x.pList = yymsp[-2].minor.yy148;
    sqlite3ExprSetHeight(pParse, yygotominor.yy72);
  }else{
    sqlite3ExprListDelete(pParse->db, yymsp[-2].minor.yy148);
  }
  sqlite3ExprSpan(yygotominor.yy72, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3084 "parse.c"
        break;
      case 233: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 916 "parse.y"
{
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy148, yymsp[-2].minor.yy72, 0);
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yygotominor.yy148, yymsp[0].minor.yy72, 0);
}
#line 3092 "parse.c"
        break;
      case 234: /* case_exprlist ::= WHEN expr THEN expr */
#line 920 "parse.y"
{
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,0, yymsp[-2].minor.yy72, 0);
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yygotominor.yy148, yymsp[0].minor.yy72, 0);
}
#line 3100 "parse.c"
        break;
      case 243: /* cmd ::= createkw uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP */
#line 949 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy0, &yymsp[-5].minor.yy0, 
                     sqlite3SrcListAppend(pParse->db,0,&yymsp[-3].minor.yy0,0), yymsp[-1].minor.yy148, yymsp[-9].minor.yy194,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy194);
}
#line 3109 "parse.c"
        break;
      case 244: /* uniqueflag ::= UNIQUE */
      case 293: /* raisetype ::= ABORT */
#line 956 "parse.y"
{yygotominor.yy194 = OE_Abort;}
#line 3115 "parse.c"
        break;
      case 245: /* uniqueflag ::= */
#line 957 "parse.y"
{yygotominor.yy194 = OE_None;}
#line 3120 "parse.c"
        break;
      case 248: /* idxlist ::= idxlist COMMA nm collate sortorder */
#line 966 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,yymsp[-4].minor.yy148, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy148, "index");
  if( yygotominor.yy148 ) yygotominor.yy148->a[yygotominor.yy148->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy194;
}
#line 3134 "parse.c"
        break;
      case 249: /* idxlist ::= nm collate sortorder */
#line 976 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy0.n>0 ){
    p = sqlite3PExpr(pParse, TK_COLUMN, 0, 0, 0);
    sqlite3ExprSetColl(pParse, p, &yymsp[-1].minor.yy0);
  }
  yygotominor.yy148 = sqlite3ExprListAppend(pParse,0, p, &yymsp[-2].minor.yy0);
  sqlite3ExprListCheckLength(pParse, yygotominor.yy148, "index");
  if( yygotominor.yy148 ) yygotominor.yy148->a[yygotominor.yy148->nExpr-1].sortOrder = (u8)yymsp[0].minor.yy194;
}
#line 3148 "parse.c"
        break;
      case 250: /* collate ::= */
#line 988 "parse.y"
{yygotominor.yy0.z = 0; yygotominor.yy0.n = 0;}
#line 3153 "parse.c"
        break;
      case 252: /* cmd ::= DROP INDEX ifexists fullname */
#line 994 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy185, yymsp[-1].minor.yy194);}
#line 3158 "parse.c"
        break;
      case 253: /* cmd ::= VACUUM */
      case 254: /* cmd ::= VACUUM nm */
#line 1000 "parse.y"
{sqlite3Vacuum(pParse);}
#line 3164 "parse.c"
        break;
      case 255: /* cmd ::= PRAGMA nm dbnm */
#line 1009 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy0,0,0);}
#line 3169 "parse.c"
        break;
      case 256: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
#line 1010 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,0);}
#line 3174 "parse.c"
        break;
      case 257: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
#line 1011 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,0);}
#line 3179 "parse.c"
        break;
      case 258: /* cmd ::= PRAGMA nm dbnm EQ minus_num */
#line 1013 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0,1);}
#line 3184 "parse.c"
        break;
      case 259: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */
#line 1015 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy0,&yymsp[-3].minor.yy0,&yymsp[-1].minor.yy0,1);}
#line 3189 "parse.c"
        break;
      case 270: /* cmd ::= createkw trigger_decl BEGIN trigger_cmd_list END */
#line 1034 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy0.z;
  all.n = (int)(yymsp[0].minor.yy0.z - yymsp[-3].minor.yy0.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy145, &all);
}
#line 3199 "parse.c"
        break;
      case 271: /* trigger_decl ::= temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause */
#line 1043 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy0, &yymsp[-6].minor.yy0, yymsp[-5].minor.yy194, yymsp[-4].minor.yy332.a, yymsp[-4].minor.yy332.b, yymsp[-2].minor.yy185, yymsp[0].minor.yy72, yymsp[-10].minor.yy194, yymsp[-8].minor.yy194);
  yygotominor.yy0 = (yymsp[-6].minor.yy0.n==0?yymsp[-7].minor.yy0:yymsp[-6].minor.yy0);
}
#line 3207 "parse.c"
        break;
      case 272: /* trigger_time ::= BEFORE */
      case 275: /* trigger_time ::= */
#line 1049 "parse.y"
{ yygotominor.yy194 = TK_BEFORE; }
#line 3213 "parse.c"
        break;
      case 273: /* trigger_time ::= AFTER */
#line 1050 "parse.y"
{ yygotominor.yy194 = TK_AFTER;  }
#line 3218 "parse.c"
        break;
      case 274: /* trigger_time ::= INSTEAD OF */
#line 1051 "parse.y"
{ yygotominor.yy194 = TK_INSTEAD;}
#line 3223 "parse.c"
        break;
      case 276: /* trigger_event ::= DELETE|INSERT */
      case 277: /* trigger_event ::= UPDATE */
#line 1056 "parse.y"
{yygotominor.yy332.a = yymsp[0].major; yygotominor.yy332.b = 0;}
#line 3229 "parse.c"
        break;
      case 278: /* trigger_event ::= UPDATE OF inscollist */
#line 1058 "parse.y"
{yygotominor.yy332.a = TK_UPDATE; yygotominor.yy332.b = yymsp[0].minor.yy254;}
#line 3234 "parse.c"
        break;
      case 281: /* when_clause ::= */
      case 298: /* key_opt ::= */
#line 1065 "parse.y"
{ yygotominor.yy72 = 0; }
#line 3240 "parse.c"
        break;
      case 282: /* when_clause ::= WHEN expr */
      case 299: /* key_opt ::= KEY expr */
#line 1066 "parse.y"
{ yygotominor.yy72 = yymsp[0].minor.yy72; }
#line 3246 "parse.c"
        break;
      case 283: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
#line 1070 "parse.y"
{
/*
  if( yymsp[-2].minor.yy145 ){
    yymsp[-2].minor.yy145->pLast->pNext = yymsp[-1].minor.yy145;
  }else{
    yymsp[-2].minor.yy145 = yymsp[-1].minor.yy145;
  }
*/
  assert( yymsp[-2].minor.yy145!=0 );
  yymsp[-2].minor.yy145->pLast->pNext = yymsp[-1].minor.yy145;
  yymsp[-2].minor.yy145->pLast = yymsp[-1].minor.yy145;
  yygotominor.yy145 = yymsp[-2].minor.yy145;
}
#line 3263 "parse.c"
        break;
      case 284: /* trigger_cmd_list ::= trigger_cmd SEMI */
#line 1083 "parse.y"
{ 
  /* if( yymsp[-1].minor.yy145 ) */
  assert( yymsp[-1].minor.yy145!=0 );
  yymsp[-1].minor.yy145->pLast = yymsp[-1].minor.yy145;
  yygotominor.yy145 = yymsp[-1].minor.yy145;
}
#line 3273 "parse.c"
        break;
      case 285: /* trigger_cmd ::= UPDATE orconf nm SET setlist where_opt */
#line 1094 "parse.y"
{ yygotominor.yy145 = sqlite3TriggerUpdateStep(pParse->db, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy148, yymsp[0].minor.yy72, yymsp[-4].minor.yy194); }
#line 3278 "parse.c"
        break;
      case 286: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP */
#line 1099 "parse.y"
{yygotominor.yy145 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-5].minor.yy0, yymsp[-4].minor.yy254, yymsp[-1].minor.yy148, 0, yymsp[-7].minor.yy194);}
#line 3283 "parse.c"
        break;
      case 287: /* trigger_cmd ::= insert_cmd INTO nm inscollist_opt select */
#line 1102 "parse.y"
{yygotominor.yy145 = sqlite3TriggerInsertStep(pParse->db, &yymsp[-2].minor.yy0, yymsp[-1].minor.yy254, 0, yymsp[0].minor.yy243, yymsp[-4].minor.yy194);}
#line 3288 "parse.c"
        break;
      case 288: /* trigger_cmd ::= DELETE FROM nm where_opt */
#line 1106 "parse.y"
{yygotominor.yy145 = sqlite3TriggerDeleteStep(pParse->db, &yymsp[-1].minor.yy0, yymsp[0].minor.yy72);}
#line 3293 "parse.c"
        break;
      case 289: /* trigger_cmd ::= select */
#line 1109 "parse.y"
{yygotominor.yy145 = sqlite3TriggerSelectStep(pParse->db, yymsp[0].minor.yy243); }
#line 3298 "parse.c"
        break;
      case 290: /* expr ::= RAISE LP IGNORE RP */
#line 1112 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy72 ){
    yygotominor.yy72->affinity = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy72, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3309 "parse.c"
        break;
      case 291: /* expr ::= RAISE LP raisetype COMMA nm RP */
#line 1119 "parse.y"
{
  yygotominor.yy72 = sqlite3PExpr(pParse, TK_RAISE, 0, 0, &yymsp[-1].minor.yy0); 
  if( yygotominor.yy72 ) {
    yygotominor.yy72->affinity = (char)yymsp[-3].minor.yy194;
    sqlite3ExprSpan(yygotominor.yy72, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3320 "parse.c"
        break;
      case 292: /* raisetype ::= ROLLBACK */
#line 1129 "parse.y"
{yygotominor.yy194 = OE_Rollback;}
#line 3325 "parse.c"
        break;
      case 294: /* raisetype ::= FAIL */
#line 1131 "parse.y"
{yygotominor.yy194 = OE_Fail;}
#line 3330 "parse.c"
        break;
      case 295: /* cmd ::= DROP TRIGGER ifexists fullname */
#line 1136 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy185,yymsp[-1].minor.yy194);
}
#line 3337 "parse.c"
        break;
      case 296: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
#line 1143 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy72, yymsp[-1].minor.yy72, yymsp[0].minor.yy72);
}
#line 3344 "parse.c"
        break;
      case 297: /* cmd ::= DETACH database_kw_opt expr */
#line 1146 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy72);
}
#line 3351 "parse.c"
        break;
      case 302: /* cmd ::= REINDEX */
#line 1161 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3356 "parse.c"
        break;
      case 303: /* cmd ::= REINDEX nm dbnm */
#line 1162 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3361 "parse.c"
        break;
      case 304: /* cmd ::= ANALYZE */
#line 1167 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3366 "parse.c"
        break;
      case 305: /* cmd ::= ANALYZE nm dbnm */
#line 1168 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0);}
#line 3371 "parse.c"
        break;
      case 306: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
#line 1173 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy185,&yymsp[0].minor.yy0);
}
#line 3378 "parse.c"
        break;
      case 307: /* cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column */
#line 1176 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy0);
}
#line 3385 "parse.c"
        break;
      case 308: /* add_column_fullname ::= fullname */
#line 1179 "parse.y"
{
  pParse->db->lookaside.bEnabled = 0;
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy185);
}
#line 3393 "parse.c"
        break;
      case 311: /* cmd ::= create_vtab */
#line 1189 "parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3398 "parse.c"
        break;
      case 312: /* cmd ::= create_vtab LP vtabarglist RP */
#line 1190 "parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3403 "parse.c"
        break;
      case 313: /* create_vtab ::= createkw VIRTUAL TABLE nm dbnm USING nm */
#line 1191 "parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy0, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3410 "parse.c"
        break;
      case 316: /* vtabarg ::= */
#line 1196 "parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3415 "parse.c"
        break;
      case 318: /* vtabargtoken ::= ANY */
      case 319: /* vtabargtoken ::= lp anylist RP */
      case 320: /* lp ::= LP */
      case 322: /* anylist ::= anylist ANY */
#line 1198 "parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3423 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  UNUSED_PARAMETER(yymajor);  /* Silence some compiler warnings */
  assert( TOKEN.z[0] );  /* The tokenizer always gives us a token */
  sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
  pParse->parseError = 1;
#line 3487 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
