use strict;
use warnings;
use Config;
use ExtUtils::MakeMaker;

# buffering will ruin your day!
select STDERR; $|=1;
select STDOUT; $|=1;

# prereqs
my $EX_version   = 0;      # Exporter
my $DL_version   = 0;      # DynaLoader
my $EUMM_version = '6.64'; # ExtUtils::MakeMaker
my $TM_version   = 0;      # Test::More

my $UUID_version = get_uuidpm_version();

# Authority poisons everybody who takes
# authority on himself.
#                     -- Vladimir Lenin
my $no_mymeta = ($UUID_version =~ /_/) ? 1 : 0;

my $is_win = $Config{archname} =~ /win32/i;

WriteMakefile1(
    'NAME'             => 'UUID',
    'AUTHOR'           => 'Rick Myers <jrm@cpan.org>',
    'VERSION_FROM'     => 'UUID.pm',
    'ABSTRACT_FROM'    => 'UUID.pm',
    'LICENSE'          => 'artistic_2',
    'MIN_PERL_VERSION' => '5.005',
    'LIBS'             => '',
    'NO_MYMETA'        => $no_mymeta,
    'INC'              => '-Iulib -Iulib/uuid',
    'CCFLAGS'          => $Config{ccflags} . ( $is_win ? '' : ' -Wno-compound-token-split-by-macro' ),
    'OBJECT'           => '$(O_FILES)',
    'LDFROM'           => join( ' ', qw{
        ulib/uuid/clear.o ulib/uuid/compare.o ulib/uuid/copy.o
        ulib/uuid/gen_uuid.o ulib/uuid/isnull.o ulib/uuid/pack.o
        ulib/uuid/parse.o ulib/uuid/unpack.o ulib/uuid/unparse.o
        ulib/uuid/uuid_time.o UUID.o
    }),
    'C' => [qw{
        ulib/uuid/clear.c ulib/uuid/compare.c ulib/uuid/copy.c
        ulib/uuid/gen_uuid.c ulib/uuid/isnull.c ulib/uuid/pack.c
        ulib/uuid/parse.c ulib/uuid/unpack.c ulib/uuid/unparse.c
        ulib/uuid/uuid_time.c UUID.c
    }],
    'H' => [qw{
        ulib/EUMM.h ulib/config.h ulib/dirpaths.h ulib/uuid/uuid.h
        ulib/uuid/uuid_types.h
    }],
    'PREREQ_PM'          => {
        'DynaLoader' => $DL_version,
        'Exporter'   => $EX_version,
        'strict'     => 0,
        'vars'       => 0,
        'warnings'   => 0,
    },
    'CONFIGURE_REQUIRES' => {
        'Config'              => 0,
        'Devel::CheckLib'     => 0,
        'ExtUtils::MakeMaker' => $EUMM_version,
        'Text::Patch'         => 0,
        'strict'              => 0,
        'warnings'            => 0,
    },
    'BUILD_REQUIRES' => {
        'ExtUtils::MakeMaker' => $EUMM_version,
        'strict'              => 0,
        'warnings'            => 0,
    },
    'TEST_REQUIRES' => {
        'CPAN::Meta'         => 0,
        'DynaLoader'         => $DL_version,
        'Exporter'           => $EX_version,
        'ExtUtils::Manifest' => 0,
        'Test::More'         => $TM_version,
        'lib'                => 0,
        'strict'             => 0,
        'vars'               => 0,
        'warnings'           => 0,
    },
    'META_MERGE' => {
        'dynamic_config' => 0,
        'provides' => {
            'UUID' => {
                'file'    => 'UUID.pm',
                'version' => $UUID_version,
            },
        },
    },
    'realclean' => {
        'FILES' => join( ' ', sort qw{
            LICENSE_new
            META_new.json
            META_new.yml
            README_new
            README_new.bak
            gen_uuid.c.new
            gen_uuid.c.patched
            pack.c.patched
            perl.core
            perl.exe.stackdump
            uuid.h.new
            ulib
            unpack.c.patched
            usrcP
            uuidP.h.patched
            uuid_time.c.patched
            uuid_types.h.in.patched
        }),
    },
);

exit 0;

sub WriteMakefile1 {  #Written by Alexandr Ciornii, version 0.21. Added by eumm-upgrade.
    my %params=@_;
    my $eumm_version=$ExtUtils::MakeMaker::VERSION;
    $eumm_version=eval $eumm_version;
    die "EXTRA_META is deprecated" if exists $params{EXTRA_META};
    die "LICENSE not specified" if not exists $params{LICENSE};
    if ($params{BUILD_REQUIRES} and $eumm_version < 6.5503) {
        #EUMM 6.5502 has problems with BUILD_REQUIRES
        $params{PREREQ_PM}={ %{$params{PREREQ_PM} || {}} , %{$params{BUILD_REQUIRES}} };
        delete $params{BUILD_REQUIRES};
    }
    delete $params{TEST_REQUIRES} if $eumm_version < 6.64;
    delete $params{CONFIGURE_REQUIRES} if $eumm_version < 6.52;
    delete $params{MIN_PERL_VERSION} if $eumm_version < 6.48;
    delete $params{META_MERGE} if $eumm_version < 6.46;
    delete $params{META_ADD} if $eumm_version < 6.46;
    delete $params{LICENSE} if $eumm_version < 6.31;
    delete $params{NO_MYMETA} if $eumm_version < 6.58;
    delete $params{AUTHOR} if $] < 5.005;
    delete $params{ABSTRACT_FROM} if $] < 5.005;
    delete $params{BINARY_LOCATION} if $] < 5.005;

    WriteMakefile(%params);
}

sub get_uuidpm_version {
    open my $fh, '<', 'UUID.pm' or die "open: UUID.pm: $!";
    while (<$fh>) {
        # $VERSION = '0.30_02';
        return $1
            if /^\$VERSION = '([\d\.\_]+)';$/;
    }
    return undef;
}


package MY;


#
# some of the commented stuff below is just too dangerous
# to fool with just to satisfy ocd.
#


##
## stop rebuilding manifypods.
## hold manifypods until later.
##
#sub manifypods {
#    my $t = shift->SUPER::manifypods(@_);
#    return $t if $t =~ /NOOP/;
#    # dont manifypods every.single.time.
#    $t =~ s{\\$}{\\\n\t\$(INST_MAN3DIR)/UUID.\$(MAN3EXT)\n\n\$(INST_MAN3DIR)/UUID.\$(MAN3EXT): \\}ms;
#    # delay manifypods until after lib build
#    $t =~ s{UUID\.pm$}{UUID.pm \$(INST_DYNAMIC)}ms;
#    $t;
#}


#
# add distlicense and distreadme prereqs.
## silence manicopy step during config.
#
sub distdir {
    my $t = shift->SUPER::distdir(@_);
    $t =~ s{^(distdir :).*$}{$1 create_distdir license metafile readme distlicense distmeta distreadme}m;
    #$t =~ s{PERLRUN}{NOECHO) \$(PERLRUN};
    $t;
}


#
# remove metafile comments in manifest.
# make metafiles authoritative to cpan.
#
sub distmeta {
    my $t = <<'EOS';
distmeta : create_distdir license metafile readme
	$(NOECHO) $(ECHO) Adding META.json to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No META.json' unless -f 'META.json';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'META.json' => '' }) }" \
	  -e "    or die \"Could not add META.json to MANIFEST: $$ @\"" --
	$(NOECHO) $(ECHO) Adding META.yml to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No META.yml' unless -f 'META.yml';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'META.yml' => '' }) }" \
	  -e "    or die \"Could not add META.yml to MANIFEST: $$ @\"" --
EOS
    $t;
}


#
# re-order meta generation
#
sub metafile {
    my $t = shift->SUPER::metafile_target(@_);
    $t =~ s{^(metafile :.*)$} {$1 meta_json meta_yml}m;
    $t =~ s{^(\s+.+Generating META.yml.*)$}  {\nmeta_yml :\n$1}m;
    $t =~ s{^(\s+.+Generating META.json.*)$} {\nmeta_json :\n$1}m;
    $t;
}


#
# add UUID_DISTTEST flag to 'make disttest'
#
sub dist_test {
    my $t = shift->SUPER::dist_test(@_);
    $t =~ s{ test }{ test UUID_DISTTEST=1 };
    $t;
}


#
# make TEST_VERBOSE=1 when AUTOMATED_TESTING=1
#
sub test {
    my $t = shift->SUPER::test(@_);
    if ( $ENV{AUTOMATED_TESTING}
        or $ENV{NONINTERACTIVE_TESTING}
        or $ENV{PERL_CPAN_REPORTER_CONFIG}
    ) {
        $t =~ s{TEST_VERBOSE=0}{TEST_VERBOSE=1}msg;
    }
    $t;
}


#
# silence "cp_nonempty" bootstrap.
# silence chmod bootstrap.
# remove implicit rules and make our own!
# (some seem to use the implicits first?)
#
sub xs_c { '' }
sub xs_o { '' }
sub dynamic_bs {
    my $t = shift->SUPER::dynamic_bs(@_);
    # delay Mkbootstrap() until after patch
    $t =~ s{^(\S+\s*:\s+.+$)} {$1 \$(pl2_patch)}m;
    $t;
}
sub perldepend {
    my $t = shift->SUPER::perldepend(@_);
    # make UUID.c depend on UUID.xs
    $t =~ s{$} { UUID.xs}s;
    # run xsubpp
    $t .= "\t". '$(XSUBPPRUN) $(XSPROTOARG) $(XSUBPPARGS) $(XSUBPP_EXTRA_ARGS) UUID.xs > UUID.xsc'. "\n";
    $t .= "\t". '$(MV) UUID.xsc UUID.c';
    $t;
}


#
# our variables
#
sub post_constants {
    my $t = shift->SUPER::post_constants(@_);
    $t .= <<'EOPC';
pl0               = usrc
pl1               = usrcP
pl2               = ulib
pl1_exists        = $(pl1)$(DFSEP).exists
pl2_exists        = $(pl2)$(DFSEP).exists
pl1_patch         = $(pl1)$(DFSEP).patch
pl2_patch         = $(pl2)$(DFSEP).patch
pl2_EUMM_h        = $(pl2)$(DFSEP)EUMM.h
pl1_uuid          = $(pl1)$(DFSEP)uuid
pl2_uuid          = $(pl2)$(DFSEP)uuid
pl0_config_h      = $(pl0)$(DFSEP)config.h
pl1_config_h      = $(pl1)$(DFSEP)config.h
pl2_config_h      = $(pl2)$(DFSEP)config.h
pl0_dirpaths_h    = $(pl0)$(DFSEP)dirpaths.h
pl1_dirpaths_h    = $(pl1)$(DFSEP)dirpaths.h
pl2_dirpaths_h    = $(pl2)$(DFSEP)dirpaths.h
pl0_clear_c       = $(pl0)$(DFSEP)uuid$(DFSEP)clear.c
pl1_clear_c       = $(pl1)$(DFSEP)uuid$(DFSEP)clear.c
pl2_clear_c       = $(pl2)$(DFSEP)uuid$(DFSEP)clear.c
pl0_compare_c     = $(pl0)$(DFSEP)uuid$(DFSEP)compare.c
pl1_compare_c     = $(pl1)$(DFSEP)uuid$(DFSEP)compare.c
pl2_compare_c     = $(pl2)$(DFSEP)uuid$(DFSEP)compare.c
pl0_copy_c        = $(pl0)$(DFSEP)uuid$(DFSEP)copy.c
pl1_copy_c        = $(pl1)$(DFSEP)uuid$(DFSEP)copy.c
pl2_copy_c        = $(pl2)$(DFSEP)uuid$(DFSEP)copy.c
pl0_gen_uuid_c    = $(pl0)$(DFSEP)uuid$(DFSEP)gen_uuid.c
pl1_gen_uuid_c    = $(pl1)$(DFSEP)uuid$(DFSEP)gen_uuid.c
pl2_gen_uuid_c    = $(pl2)$(DFSEP)uuid$(DFSEP)gen_uuid.c
pl0_gen_uuid_nt_c = $(pl0)$(DFSEP)uuid$(DFSEP)gen_uuid_nt.c
pl1_gen_uuid_nt_c = $(pl1)$(DFSEP)uuid$(DFSEP)gen_uuid_nt.c
pl2_gen_uuid_nt_c = $(pl2)$(DFSEP)uuid$(DFSEP)gen_uuid_nt.c
pl0_isnull_c      = $(pl0)$(DFSEP)uuid$(DFSEP)isnull.c
pl1_isnull_c      = $(pl1)$(DFSEP)uuid$(DFSEP)isnull.c
pl2_isnull_c      = $(pl2)$(DFSEP)uuid$(DFSEP)isnull.c
pl0_pack_c        = $(pl0)$(DFSEP)uuid$(DFSEP)pack.c
pl1_pack_c        = $(pl1)$(DFSEP)uuid$(DFSEP)pack.c
pl2_pack_c        = $(pl2)$(DFSEP)uuid$(DFSEP)pack.c
pl0_parse_c       = $(pl0)$(DFSEP)uuid$(DFSEP)parse.c
pl1_parse_c       = $(pl1)$(DFSEP)uuid$(DFSEP)parse.c
pl2_parse_c       = $(pl2)$(DFSEP)uuid$(DFSEP)parse.c
pl0_tst_uuid_c    = $(pl0)$(DFSEP)uuid$(DFSEP)tst_uuid.c
pl1_tst_uuid_c    = $(pl1)$(DFSEP)uuid$(DFSEP)tst_uuid.c
pl2_tst_uuid_c    = $(pl2)$(DFSEP)uuid$(DFSEP)tst_uuid.c
pl0_unpack_c      = $(pl0)$(DFSEP)uuid$(DFSEP)unpack.c
pl1_unpack_c      = $(pl1)$(DFSEP)uuid$(DFSEP)unpack.c
pl2_unpack_c      = $(pl2)$(DFSEP)uuid$(DFSEP)unpack.c
pl0_unparse_c     = $(pl0)$(DFSEP)uuid$(DFSEP)unparse.c
pl1_unparse_c     = $(pl1)$(DFSEP)uuid$(DFSEP)unparse.c
pl2_unparse_c     = $(pl2)$(DFSEP)uuid$(DFSEP)unparse.c
pl0_uuidP_h       = $(pl0)$(DFSEP)uuid$(DFSEP)uuidP.h
pl1_uuidP_h       = $(pl1)$(DFSEP)uuid$(DFSEP)uuidP.h
pl2_uuidP_h       = $(pl2)$(DFSEP)uuid$(DFSEP)uuidP.h
pl0_uuid_h        = $(pl0)$(DFSEP)uuid$(DFSEP)uuid.h
pl1_uuid_h        = $(pl1)$(DFSEP)uuid$(DFSEP)uuid.h
pl2_uuid_h        = $(pl2)$(DFSEP)uuid$(DFSEP)uuid.h
pl0_uuidd_h       = $(pl0)$(DFSEP)uuid$(DFSEP)uuidd.h
pl1_uuidd_h       = $(pl1)$(DFSEP)uuid$(DFSEP)uuidd.h
pl2_uuidd_h       = $(pl2)$(DFSEP)uuid$(DFSEP)uuidd.h
pl0_uuid_time_c   = $(pl0)$(DFSEP)uuid$(DFSEP)uuid_time.c
pl1_uuid_time_c   = $(pl1)$(DFSEP)uuid$(DFSEP)uuid_time.c
pl2_uuid_time_c   = $(pl2)$(DFSEP)uuid$(DFSEP)uuid_time.c
pl0_uuid_types_h  = $(pl0)$(DFSEP)uuid$(DFSEP)uuid_types.h
pl1_uuid_types_h  = $(pl1)$(DFSEP)uuid$(DFSEP)uuid_types.h
pl2_uuid_types_h  = $(pl2)$(DFSEP)uuid$(DFSEP)uuid_types.h
ubin_configure_pl = ubin$(DFSEP)configure.pl
ubin_subst_pl     = ubin$(DFSEP)subst.pl

patch_genuuidc = ubin$(DFSEP)patch_genuuidc.pl $(pl1_gen_uuid_c) >

patch_src_genuuidc     = ubin$(DFSEP)patch_src_genuuidc.pl     $(pl0_gen_uuid_c)      >
patch_src_packc        = ubin$(DFSEP)patch_src_packc.pl        $(pl0_pack_c)          >
patch_src_unpackc      = ubin$(DFSEP)patch_src_unpackc.pl      $(pl0_unpack_c)        >
patch_src_uuidPh       = ubin$(DFSEP)patch_src_uuidPh.pl       $(pl0_uuidP_h)         >
patch_src_uuidtimec    = ubin$(DFSEP)patch_src_uuidtimec.pl    $(pl0_uuid_time_c)     >
patch_src_uuidtypeshin = ubin$(DFSEP)patch_src_uuidtypeshin.pl $(pl0_uuid_types_h).in >

patch_configh     = $(ubin_subst_pl) $(pl1_config_h).in   >
patch_dirpathsh   = $(ubin_subst_pl) $(pl1_dirpaths_h).in >
patch_eummh       = -l $(ubin_configure_pl)
patch_uuidh       = ubin$(DFSEP)patch_uuidh.pl $(pl2_uuid_h).new >
patch_uuidhin     = $(ubin_subst_pl) $(pl1_uuid_h).in     >
patch_uuidtypesh1 = $(ubin_subst_pl) $(pl1_uuid_types_h).in >
patch_uuidtypesh2 = -i.bak -pe "s!typedef signed char!typedef char!s"
EOPC
    $t;
}


#
# add distlicense and distreadme targets.
# add autoconf generated targets.
# add explicit object rules.
#
sub postamble {
    return <<'EOP';
# Software::License requires perl-5.12.0
license: create_distdir
	$(NOECHO) $(ECHO) Generating LICENSE
	$(NOECHO) $(RM_F) LICENSE_new
	$(NOECHO) $(ABSPERLRUN) -M5.12.0 -MSoftware::License::Artistic_2_0 \
	  -e 'print Software::License::Artistic_2_0->new({holder => "Rick Myers", year => sprintf("2014-%04d", 1900+(localtime(time))[5])})->fulltext' \
	  > LICENSE_new
	$(NOECHO) $(MV) LICENSE_new $(DISTVNAME)$(DFSEP)LICENSE

distlicense: create_distdir license
	$(NOECHO) $(ECHO) Adding LICENSE to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No LICENSE' unless -f 'LICENSE';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'LICENSE' => '' }) }" \
	  -e "    or die \"Could not add LICENSE to MANIFEST: $$ @\"" --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e "print sort <>" MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)$(DFSEP)MANIFEST_new $(DISTVNAME)$(DFSEP)MANIFEST

readme: create_distdir
	$(NOECHO) $(ECHO) Generating README
	$(NOECHO) $(RM_F) README_new
	$(NOECHO) pod2text UUID.pm README_new
	$(NOECHO) $(ABSPERLRUN) -i.bak -pe's{\*(\S+)\*}{\1}g' README_new
	$(NOECHO) $(RM_F) README_new.bak
	$(NOECHO) $(MV) README_new $(DISTVNAME)$(DFSEP)README

distreadme: create_distdir readme
	$(NOECHO) $(ECHO) Adding README to MANIFEST
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -MExtUtils::Manifest=maniadd \
	  -e "die 'No README' unless -f 'README';" \
	  -e "die 'No MANIFEST' unless -f 'MANIFEST';" \
	  -e "eval { maniadd({ 'README' => '' }) }" \
	  -e "    or die \"Could not add README to MANIFEST: $$ @\"" --
	$(NOECHO) cd $(DISTVNAME) && $(ABSPERLRUN) -e "print sort <>" MANIFEST > MANIFEST_new
	$(NOECHO) $(MV) $(DISTVNAME)$(DFSEP)MANIFEST_new $(DISTVNAME)$(DFSEP)MANIFEST


#
# the usrP dir is a patched copy of usrc tree.
# sources here are either copied from usrc or
# are locally patched to modify types.
#
$(pl1_exists): $(FIRST_MAKEFILE)
	$(NOECHO) $(ECHO) Patching source tree
	$(NOECHO) $(MKPATH) $(pl1_uuid)
	$(NOECHO) $(TOUCH)  $(pl1_exists)

$(pl1_config_h).in: $(pl1_exists) $(pl0_config_h).in
	$(NOECHO) $(RM_F) $(pl1_config_h).in     $(pl1_config_h).in.new
	$(NOECHO) $(CP)   $(pl0_config_h).in     $(pl1_config_h).in.new
	$(NOECHO) $(MV)   $(pl1_config_h).in.new $(pl1_config_h).in

$(pl1_clear_c): $(pl1_exists) $(pl0_clear_c)
	$(NOECHO) $(RM_F) $(pl1_clear_c)     $(pl1_clear_c).new
	$(NOECHO) $(CP)   $(pl0_clear_c)     $(pl1_clear_c).new
	$(NOECHO) $(MV)   $(pl1_clear_c).new $(pl1_clear_c)

$(pl1_compare_c): $(pl1_exists) $(pl0_compare_c)
	$(NOECHO) $(RM_F) $(pl1_compare_c)     $(pl1_compare_c).new
	$(NOECHO) $(CP)   $(pl0_compare_c)     $(pl1_compare_c).new
	$(NOECHO) $(MV)   $(pl1_compare_c).new $(pl1_compare_c)

$(pl1_copy_c): $(pl1_exists) $(pl0_copy_c)
	$(NOECHO) $(RM_F) $(pl1_copy_c)     $(pl1_copy_c).new
	$(NOECHO) $(CP)   $(pl0_copy_c)     $(pl1_copy_c).new
	$(NOECHO) $(MV)   $(pl1_copy_c).new $(pl1_copy_c)

$(pl1_dirpaths_h).in: $(pl1_exists) $(pl0_dirpaths_h).in
	$(NOECHO) $(RM_F) $(pl1_dirpaths_h).in     $(pl1_dirpaths_h).in.new
	$(NOECHO) $(CP)   $(pl0_dirpaths_h).in     $(pl1_dirpaths_h).in.new
	$(NOECHO) $(MV)   $(pl1_dirpaths_h).in.new $(pl1_dirpaths_h).in

$(pl1_gen_uuid_c): $(pl1_exists) $(pl0_gen_uuid_c)
	$(NOECHO) $(RM_F) $(pl1_gen_uuid_c)     $(pl1_gen_uuid_c).new
	$(NOECHO) $(PERL) $(patch_src_genuuidc) $(pl1_gen_uuid_c).new
	$(NOECHO) $(MV)   $(pl1_gen_uuid_c).new $(pl1_gen_uuid_c)

$(pl1_gen_uuid_nt_c): $(pl1_exists) $(pl0_gen_uuid_nt_c)
	$(NOECHO) $(RM_F) $(pl1_gen_uuid_nt_c)     $(pl1_gen_uuid_nt_c).new
	$(NOECHO) $(CP)   $(pl0_gen_uuid_nt_c)     $(pl1_gen_uuid_nt_c).new
	$(NOECHO) $(MV)   $(pl1_gen_uuid_nt_c).new $(pl1_gen_uuid_nt_c)

$(pl1_isnull_c): $(pl1_exists) $(pl0_isnull_c)
	$(NOECHO) $(RM_F) $(pl1_isnull_c)     $(pl1_isnull_c).new
	$(NOECHO) $(CP)   $(pl0_isnull_c)     $(pl1_isnull_c).new
	$(NOECHO) $(MV)   $(pl1_isnull_c).new $(pl1_isnull_c)

$(pl1_pack_c): $(pl1_exists) $(pl0_pack_c)
	$(NOECHO) $(RM_F) $(pl1_pack_c)      $(pl1_pack_c).new
	$(NOECHO) $(PERL) $(patch_src_packc) $(pl1_pack_c).new
	$(NOECHO) $(MV)   $(pl1_pack_c).new  $(pl1_pack_c)

$(pl1_parse_c): $(pl1_exists) $(pl0_parse_c)
	$(NOECHO) $(RM_F) $(pl1_parse_c)     $(pl1_parse_c).new
	$(NOECHO) $(CP)   $(pl0_parse_c)     $(pl1_parse_c).new
	$(NOECHO) $(MV)   $(pl1_parse_c).new $(pl1_parse_c)

$(pl1_tst_uuid_c): $(pl1_exists) $(pl0_tst_uuid_c)
	$(NOECHO) $(RM_F) $(pl1_tst_uuid_c)     $(pl1_tst_uuid_c).new
	$(NOECHO) $(CP)   $(pl0_tst_uuid_c)     $(pl1_tst_uuid_c).new
	$(NOECHO) $(MV)   $(pl1_tst_uuid_c).new $(pl1_tst_uuid_c)

$(pl1_unpack_c): $(pl1_exists) $(pl0_unpack_c)
	$(NOECHO) $(RM_F) $(pl1_unpack_c)      $(pl1_unpack_c).new
	$(NOECHO) $(PERL) $(patch_src_unpackc) $(pl1_unpack_c).new
	$(NOECHO) $(MV)   $(pl1_unpack_c).new  $(pl1_unpack_c)

$(pl1_unparse_c): $(pl1_exists) $(pl0_unparse_c)
	$(NOECHO) $(RM_F) $(pl1_unparse_c)     $(pl1_unparse_c).new
	$(NOECHO) $(CP)   $(pl0_unparse_c)     $(pl1_unparse_c).new
	$(NOECHO) $(MV)   $(pl1_unparse_c).new $(pl1_unparse_c)

$(pl1_uuid_h).in: $(pl1_exists) $(pl0_uuid_h).in
	$(NOECHO) $(RM_F) $(pl1_uuid_h).in     $(pl1_uuid_h).in.new
	$(NOECHO) $(CP)   $(pl0_uuid_h).in     $(pl1_uuid_h).in.new
	$(NOECHO) $(MV)   $(pl1_uuid_h).in.new $(pl1_uuid_h).in

$(pl1_uuidP_h): $(pl1_exists) $(pl0_uuidP_h)
	$(NOECHO) $(RM_F) $(pl1_uuidP_h)      $(pl1_uuidP_h).new
	$(NOECHO) $(PERL) $(patch_src_uuidPh) $(pl1_uuidP_h).new
	$(NOECHO) $(MV)   $(pl1_uuidP_h).new  $(pl1_uuidP_h)

$(pl1_uuid_time_c): $(pl1_exists) $(pl0_uuid_time_c)
	$(NOECHO) $(RM_F) $(pl1_uuid_time_c)     $(pl1_uuid_time_c).new
	$(NOECHO) $(PERL) $(patch_src_uuidtimec) $(pl1_uuid_time_c).new
	$(NOECHO) $(MV)   $(pl1_uuid_time_c).new $(pl1_uuid_time_c)

$(pl1_uuid_types_h).in: $(pl1_exists) $(pl0_uuid_types_h).in
	$(NOECHO) $(RM_F) $(pl1_uuid_types_h).in     $(pl1_uuid_types_h).in.new
	$(NOECHO) $(PERL) $(patch_src_uuidtypeshin)  $(pl1_uuid_types_h).in.new
	$(NOECHO) $(MV)   $(pl1_uuid_types_h).in.new $(pl1_uuid_types_h).in

$(pl1_uuidd_h): $(pl1_exists) $(pl0_uuidd_h)
	$(NOECHO) $(RM_F) $(pl1_uuidd_h)     $(pl1_uuidd_h).new
	$(NOECHO) $(CP)   $(pl0_uuidd_h)     $(pl1_uuidd_h).new
	$(NOECHO) $(MV)   $(pl1_uuidd_h).new $(pl1_uuidd_h)

$(pl1_patch):              \
	$(pl1_config_h_in)     \
	$(pl1_dirpaths_h_in)   \
	$(pl1_clear_c)         \
	$(pl1_compare_c)       \
	$(pl1_copy_c)          \
	$(pl1_gen_uuid_c)      \
	$(pl1_gen_uuid_nt_c)   \
	$(pl1_isnull_c)        \
	$(pl1_pack_c)          \
	$(pl1_parse_c)         \
	$(pl1_tst_uuid_c)      \
	$(pl1_unpack_c)        \
	$(pl1_unparse_c)       \
	$(pl1_uuid_h_in)       \
	$(pl1_uuidP_h)         \
	$(pl1_uuid_time_c)     \
	$(pl1_uuid_types_h_in) \
	$(pl1_uuidd_h)
	$(NOECHO) $(TOUCH) $(pl1_patch)


#
# the ulib dir is the final build tree.
# sources here are copied from usrcP or
# modified by configure.
#
$(pl2_exists): $(pl1_patch) $(ubin_configure_pl) $(ubin_subst_pl)
	$(NOECHO) $(MKPATH) $(pl2_uuid)
	$(NOECHO) $(TOUCH)  $(pl2_exists)

$(pl2_EUMM_h): $(pl2_exists) $(ubin_configure_pl)
	$(NOECHO) $(ECHO) Generating EUMM.h
	$(NOECHO) $(RM_F) $(pl2_EUMM_h)     $(pl2_EUMM_h).new
	$(NOECHO) $(PERL) $(patch_eummh)    $(pl2_EUMM_h).new
	$(NOECHO) $(MV)   $(pl2_EUMM_h).new $(pl2_EUMM_h)

$(pl2_clear_c): $(pl2_exists) $(pl1_clear_c)
	$(NOECHO) $(RM_F) $(pl2_clear_c)     $(pl2_clear_c).new
	$(NOECHO) $(CP)   $(pl1_clear_c)     $(pl2_clear_c).new
	$(NOECHO) $(MV)   $(pl2_clear_c).new $(pl2_clear_c)

$(pl2_compare_c): $(pl2_exists) $(pl1_compare_c)
	$(NOECHO) $(RM_F) $(pl2_compare_c)     $(pl2_compare_c).new
	$(NOECHO) $(CP)   $(pl1_compare_c)     $(pl2_compare_c).new
	$(NOECHO) $(MV)   $(pl2_compare_c).new $(pl2_compare_c)

$(pl2_config_h): $(pl2_exists) $(pl1_config_h).in
	$(NOECHO) $(ECHO) Generating config.h
	$(NOECHO) $(RM_F) $(pl2_config_h)     $(pl2_config_h).new
	$(NOECHO) $(PERL) $(patch_configh)    $(pl2_config_h).new
	$(NOECHO) $(ECHO) "#include <EUMM.h>" >> $(pl2_config_h).new
	$(NOECHO) $(MV)   $(pl2_config_h).new $(pl2_config_h)

$(pl2_copy_c): $(pl2_exists) $(pl1_copy_c)
	$(NOECHO) $(RM_F) $(pl2_copy_c)     $(pl2_copy_c).new
	$(NOECHO) $(CP)   $(pl1_copy_c)     $(pl2_copy_c).new
	$(NOECHO) $(MV)   $(pl2_copy_c).new $(pl2_copy_c)

$(pl2_dirpaths_h): $(pl2_exists) $(pl1_dirpaths_h).in
	$(NOECHO) $(ECHO) Generating dirpaths.h
	$(NOECHO) $(RM_F) $(pl2_dirpaths_h)     $(pl2_dirpaths_h).new
	$(NOECHO) $(PERL) $(patch_dirpathsh)    $(pl2_dirpaths_h).new
	$(NOECHO) $(MV)   $(pl2_dirpaths_h).new $(pl2_dirpaths_h)

$(pl2_gen_uuid_c): $(pl2_exists) $(pl1_gen_uuid_c)
	$(NOECHO) $(RM_F) $(pl2_gen_uuid_c)     $(pl2_gen_uuid_c).new
	$(NOECHO) $(PERL) $(patch_genuuidc)     $(pl2_gen_uuid_c).new
	$(NOECHO) $(MV)   $(pl2_gen_uuid_c).new $(pl2_gen_uuid_c)

$(pl2_gen_uuid_nt_c): $(pl2_exists) $(pl1_gen_uuid_nt_c)
	$(NOECHO) $(RM_F) $(pl2_gen_uuid_nt_c)     $(pl2_gen_uuid_nt_c).new
	$(NOECHO) $(CP)   $(pl1_gen_uuid_nt_c)     $(pl2_gen_uuid_nt_c).new
	$(NOECHO) $(MV)   $(pl2_gen_uuid_nt_c).new $(pl2_gen_uuid_nt_c)

$(pl2_isnull_c): $(pl2_exists) $(pl1_isnull_c)
	$(NOECHO) $(RM_F) $(pl2_isnull_c)     $(pl2_isnull_c).new
	$(NOECHO) $(CP)   $(pl1_isnull_c)     $(pl2_isnull_c).new
	$(NOECHO) $(MV)   $(pl2_isnull_c).new $(pl2_isnull_c)

$(pl2_pack_c): $(pl2_exists) $(pl1_pack_c)
	$(NOECHO) $(RM_F) $(pl2_pack_c)     $(pl2_pack_c).new
	$(NOECHO) $(CP)   $(pl1_pack_c)     $(pl2_pack_c).new
	$(NOECHO) $(MV)   $(pl2_pack_c).new $(pl2_pack_c)

$(pl2_parse_c): $(pl2_exists) $(pl1_parse_c)
	$(NOECHO) $(RM_F) $(pl2_parse_c)     $(pl2_parse_c).new
	$(NOECHO) $(CP)   $(pl1_parse_c)     $(pl2_parse_c).new
	$(NOECHO) $(MV)   $(pl2_parse_c).new $(pl2_parse_c)

$(pl2_tst_uuid_c): $(pl2_exists) $(pl1_tst_uuid_c)
	$(NOECHO) $(RM_F) $(pl2_tst_uuid_c)     $(pl2_tst_uuid_c).new
	$(NOECHO) $(CP)   $(pl1_tst_uuid_c)     $(pl2_tst_uuid_c).new
	$(NOECHO) $(MV)   $(pl2_tst_uuid_c).new $(pl2_tst_uuid_c)

$(pl2_unpack_c): $(pl2_exists) $(pl1_unpack_c)
	$(NOECHO) $(RM_F) $(pl2_unpack_c)     $(pl2_unpack_c).new
	$(NOECHO) $(CP)   $(pl1_unpack_c)     $(pl2_unpack_c).new
	$(NOECHO) $(MV)   $(pl2_unpack_c).new $(pl2_unpack_c)

$(pl2_unparse_c): $(pl2_exists) $(pl1_unparse_c)
	$(NOECHO) $(RM_F) $(pl2_unparse_c)     $(pl2_unparse_c).new
	$(NOECHO) $(CP)   $(pl1_unparse_c)     $(pl2_unparse_c).new
	$(NOECHO) $(MV)   $(pl2_unparse_c).new $(pl2_unparse_c)

$(pl2_uuid_h): $(pl2_exists) $(pl1_uuid_h).in
	$(NOECHO) $(ECHO) Generating uuid.h
	$(NOECHO) $(RM_F) $(pl2_uuid_h)       $(pl2_uuid_h).new   $(pl2_uuid_h).newer
	$(NOECHO) $(PERL) $(patch_uuidhin)    $(pl2_uuid_h).new
	$(NOECHO) $(PERL) $(patch_uuidh)      $(pl2_uuid_h).newer
	$(NOECHO) $(MV)   $(pl2_uuid_h).newer $(pl2_uuid_h)

$(pl2_uuid_time_c): $(pl2_exists) $(pl1_uuid_time_c)
	$(NOECHO) $(RM_F) $(pl2_uuid_time_c)     $(pl2_uuid_time_c).new
	$(NOECHO) $(CP)   $(pl1_uuid_time_c)     $(pl2_uuid_time_c).new
	$(NOECHO) $(MV)   $(pl2_uuid_time_c).new $(pl2_uuid_time_c)

$(pl2_uuid_types_h): $(pl2_exists) $(pl1_uuid_types_h).in
	$(NOECHO) $(ECHO) Generating uuid_types.h
	$(NOECHO) $(RM_F) $(pl2_uuid_types_h) $(pl2_uuid_types_h).new
	$(NOECHO) $(PERL) $(patch_uuidtypesh1) $(pl2_uuid_types_h).new
	$(NOECHO) $(PERL) $(patch_uuidtypesh2) $(pl2_uuid_types_h).new
	$(NOECHO) $(RM_F) $(pl2_uuid_types_h).new.bak
	$(NOECHO) $(MV)   $(pl2_uuid_types_h).new $(pl2_uuid_types_h)

$(pl2_uuidd_h): $(pl2_exists) $(pl1_uuidd_h)
	$(NOECHO) $(RM_F) $(pl2_uuidd_h)     $(pl2_uuidd_h).new
	$(NOECHO) $(CP)   $(pl1_uuidd_h)     $(pl2_uuidd_h).new
	$(NOECHO) $(MV)   $(pl2_uuidd_h).new $(pl2_uuidd_h)

$(pl2_uuidP_h): $(pl2_exists) $(pl1_uuidP_h)
	$(NOECHO) $(RM_F) $(pl2_uuidP_h)      $(pl2_uuidP_h).new
	$(NOECHO) $(CP)   $(pl1_uuidP_h)      $(pl2_uuidP_h).new
	$(NOECHO) $(MV)   $(pl2_uuidP_h).new  $(pl2_uuidP_h)

$(pl2_patch):            \
	$(pl2_EUMM_h)        \
	$(pl2_config_h)      \
	$(pl2_dirpaths_h)    \
	$(pl2_clear_c)       \
	$(pl2_compare_c)     \
	$(pl2_copy_c)        \
	$(pl2_gen_uuid_c)    \
	$(pl2_gen_uuid_nt_c) \
	$(pl2_isnull_c)      \
	$(pl2_pack_c)        \
	$(pl2_parse_c)       \
	$(pl2_tst_uuid_c)    \
	$(pl2_unpack_c)      \
	$(pl2_unparse_c)     \
	$(pl2_uuid_h)        \
	$(pl2_uuidP_h)       \
	$(pl2_uuid_time_c)   \
	$(pl2_uuid_types_h)  \
	$(pl2_uuidd_h)
	$(NOECHO) $(TOUCH) $(pl2_patch)


config :: $(H_FILES)
	$(NOECHO) $(NOOP)


#
# some versions of make dont support $<
#
UUID.o : $(XSUBPPDEPS) UUID.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o UUID.o UUID.c

ulib/uuid/clear.o : $(XSUBPPDEPS) usrcP/uuid/clear.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)clear.o     usrcP$(DFSEP)uuid$(DFSEP)clear.c

ulib/uuid/compare.o : $(XSUBPPDEPS) usrcP/uuid/compare.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)compare.o   usrcP$(DFSEP)uuid$(DFSEP)compare.c

ulib/uuid/copy.o : $(XSUBPPDEPS) usrcP/uuid/copy.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)copy.o      usrcP$(DFSEP)uuid$(DFSEP)copy.c

ulib/uuid/gen_uuid.o : $(XSUBPPDEPS) $(pl2_patch) $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)gen_uuid.o  ulib$(DFSEP)uuid$(DFSEP)gen_uuid.c

ulib/uuid/isnull.o : $(XSUBPPDEPS) usrcP/uuid/isnull.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)isnull.o    usrcP$(DFSEP)uuid$(DFSEP)isnull.c

ulib/uuid/pack.o : $(XSUBPPDEPS) usrcP/uuid/pack.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)pack.o      usrcP$(DFSEP)uuid$(DFSEP)pack.c

ulib/uuid/parse.o : $(XSUBPPDEPS) usrcP/uuid/parse.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)parse.o     usrcP$(DFSEP)uuid$(DFSEP)parse.c

ulib/uuid/unpack.o : $(XSUBPPDEPS) usrcP/uuid/unpack.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)unpack.o    usrcP$(DFSEP)uuid$(DFSEP)unpack.c

ulib/uuid/unparse.o : $(XSUBPPDEPS) usrcP/uuid/unparse.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)unparse.o   usrcP$(DFSEP)uuid$(DFSEP)unparse.c

ulib/uuid/uuid_time.o : $(XSUBPPDEPS) usrcP/uuid/uuid_time.c $(pl2_patch)
	$(CCCMD) -Iulib $(CCCDLFLAGS) "-I$(PERL_INC)" $(PASTHRU_DEFINE) $(DEFINE) -o ulib$(DFSEP)uuid$(DFSEP)uuid_time.o usrcP$(DFSEP)uuid$(DFSEP)uuid_time.c

EOP
}
