use strict;
use warnings;
use Test::More tests => 68;
use Digest::Groestl qw(groestl_256 groestl_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Groestl->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            groestl_256_hex($data), $digest,
            "groestl_256_hex: $len bits of $msg"
        );
        ok(
            groestl_256($data) eq pack('H*', $digest),
            "groestl_256: $len bits of $msg"
        );
    }

    my $md = Digest::Groestl->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|6C462DC6861C19DBC6FA818F3DA84BCCF6EAB703DB10A9781EEC6633EA9E8B7B
00|FF4FECF12C037275C4A97BE12F1FB5999FEA209DAC269F2819370D7A566B2DDE
C0|FF637B906F01D1503CFCDF465DCB786F701975C9A6F505B6F70902FFE161CF0C
C0|3A2BE9BAD838EA1E1F18E6F98E1B7DA3794D53DD451083BDD6CAA28F090D3795
80|8AD8C0D96178C2DBDE3002B1C14B72BF588848285A50B02484EC617E3765238D
48|468039DA9B357E5B2D0B2491DCA369C66D9996D5B65738EBD0E2EB40E71CFDB3
50|52C7A2CA42AF7546728D2032A7FC886FD4FE7E0766DF95DBE871E02564434A38
98|7A6BDA8E141E1DD8C822476FB8732D8A709F17F7A6EF33F123261629B1CCEB94
CC|610625E17D75D344764B6F021E0CD925BD5F047DAC74C069C7DD15C73A1C159C
9800|22992CEE2C56A53547F3F9F967AF8F55CFACC20B4D55FEC52724F6EA1C7ED04E
9D40|25A580538B81178C649C8ADFB89632FEC961E1009AD80618873919558D943E81
AA80|13C6AC2955FBCD6F0584E6A40CFDB8203FCFABFB3F3CAED2107401DE7004288B
9830|18AAD434BABC830EA60FECBEA21A29EA4F037C72C8C957A12C33F13F5DD98833
5030|9131B4D115CBC6746129A6EBF142F22F9EDA92AF0687EF8DD49BFC71484A182C
4D24|2ADD3944749E05108AB44F6EA7847D9E9F1953651BD7934E9C13CB9ABD3FDAF1
CBDE|EFC24B781A5A2EF1D51681326D6ED60E9830D50FAA015F2725096FCF8BD7EDA6
41FB|043FB145881D77F78BCF7E2033EB46F1642E76F55A1A2310608DE11168CEF741
4FF400|9EB5EFDD6409DEBEE1DF4726EB0EE83A88E45AC4D3BA23D1F873205C59E077E2
FD0440|468229CA64C56B2A6FEF2800ADF0315C28436190CD0E0AF17596035E9C67109A
424D00|357D8C0BEF1EC1724E0046BC1FEE594DE05B2FDBF9A925495BD311ED0536DB4E
3FDEE0|09BE0E47E1B329E58C3873CFF52F7989B1FA8ABA9DB1D1B5FB0F97E255A72A58
335768|12E31D0B5BC9A2E69332F625AD44A4F44218355D3AC281D63C2855627A3DCE24
051E7C|4366649A870B9251AD9BC219509E8727AEE68C0002404437FFA43C1F977E1C84
717F8C|3AB9E655B209D6CD87643AC965F73DB9609A5978E6826739AED24DA1F7F21735
1F877C|3B20460C536655ED697DE8F76E1C9D946E5CDDCD3B84299B5B9A8E5C305E866A
EB35CF80|6F90D711C6ABA46833417B0D87A6698DE228CE00167D7F64E7C714908F681C6A
B406C480|B7140B65B3861244ABF1D332DB2C0A84EF5008AC9F37733A66B34AECFB655478
CEE88040|A40DEB1301F65A7BCF6A9AFEAB856F299FA6F04513EBB3B843A62DA269373174
C584DB70|38E755D8B0F2353067BE8B27DBFFB8B36FCB1AD2F6C146BFFE6B290F7F1949F9
53587BC8|40CDFC3007FC9128F971818C59A011A8FCDCBA03A70B19A1231F42B0379ECEED
69A305B0|2B497456F3C469E13633A87F99F5052EDF83EDF1C2B47F6503D7682F8957379F
C9375ECE|BC7A1D8C95CF21427BF7495FB2A8F0D140A216D754AEC8B0A548AB6593CF6C42
C1ECFDFC|C10B190A3168DFFA8AF33952C1F350B5856B735F47B605425B410FC0468BA7C1
8D73E8A280|8F1D143EF3573F1A14A291105FF41A241CE5B43F45C764F9369E538A4F8A3991
06F2522080|CCB1DF3C372BDE68B3A25803FFA7A903D6BE255C23170D64392EF5E091F26C06
3EF6C36F20|BAD6BA72C79D05974D4272B0EFB27A7EE707B6A5281ED3DAD5D54D91A3476AD6
0127A1D340|46EE5A61624583242A9A56ED975A10DE134E6B0034A682CDFC72353C2C03A18E
6A6AB6C210|7AE1CB6585CBFB1017609035C3CCFB275C63C37FF8F14417CF5F0FA8F88037B4
AF3175E160|490EB5D291E82A643BA89EF48B34E964CA5726C5BDF4FA3602C51D32E7A1F5BE
B66609ED86|2549D419DB09517F10ED6CEA6A9235A326629F0AD25CF28A875F14F8415EF5F8
21F134AC57|6FA22A1A04D73BD4B487B63F54CD817009D065A4E98159A2184D0147E02BDAF5
3DC2AADFFC80|D5FA00B0E602BE639657DF258DF66F41889249E89D9F4C90B0B042163114D6BF
9202736D2240|26C6DCFB9CC3D924CD565126F157532A6209C10B773EC33C8B3BE35836672A30
F219BD629820|DD307E38D0A1D9587A4BA6408FE8648C9AB87AAA4CE27E00066E62E65C0BA1C3
F3511EE2C4B0|231386171741350BE205F9317B9275A21B482C1D1E7F7A45C1DA820830D0AED7
3ECAB6BF7720|30DB62F87564098BF1E154D8EDE0476FC3258DEDF5DE5BD40278669CDDD5B634
CD62F688F498|B3D74FB6B4C927845F5EC273FC62F0851D8F2980B968084EA45ED02B24155B27
C2CBAA33A9F8|2FE5482B6914768D30900CDCC6A8BF3FF4A3C6181BC64AA33B48DA43354D1E0D
C6F50BB74E29|579887368EC73253254E1E2DBE2D89F4894FF979DC0B4BC6F10BD676873B87A0
79F1B4CCC62A00|BC32024682878422DCADE8E51A2C22335200E3EB7B4BF12BEAFEE99277D6C5B2
