/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.tilecodec;

import com.sun.media.jai.tilecodec.JaiI18N;
import com.sun.media.jai.tilecodec.TileCodecUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderImpl;
import javax.media.jai.util.ImagingListener;

public class GZIPTileDecoder
extends TileDecoderImpl {
    public GZIPTileDecoder(InputStream inputStream, TileCodecParameterList tileCodecParameterList) {
        super("gzip", inputStream, tileCodecParameterList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Raster decode() throws IOException {
        Raster raster;
        ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream(this.inputStream));
        try {
            try {
                Object object = objectInputStream.readObject();
                raster = TileCodecUtils.deserializeRaster(object);
                Object var6_6 = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
                imagingListener.errorOccurred(JaiI18N.getString("ClassNotFound"), classNotFoundException, this, false);
                Raster raster2 = null;
                Object var6_7 = null;
                objectInputStream.close();
                return raster2;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        return raster;
    }

    public Raster decode(Point point) throws IOException {
        return this.decode();
    }
}

