/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibMosaicOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.operator.MosaicType;

public class MlibMosaicRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        int n;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        Vector<Object> vector = parameterBlock.getSources();
        SampleModel sampleModel = null;
        if (vector.size() > 0) {
            sampleModel = ((RenderedImage)vector.get(0)).getSampleModel();
        } else if (imageLayout != null && imageLayout.isValid(256)) {
            sampleModel = imageLayout.getSampleModel(null);
        }
        if (sampleModel != null && ((n = sampleModel.getDataType()) == 4 || n == 5)) {
            return null;
        }
        return new MlibMosaicOpImage(vector, imageLayout, renderingHints, (MosaicType)parameterBlock.getObjectParameter(0), (PlanarImage[])parameterBlock.getObjectParameter(1), (ROI[])parameterBlock.getObjectParameter(2), (double[][])parameterBlock.getObjectParameter(3), (double[])parameterBlock.getObjectParameter(4));
    }
}

