use inc::Module::Install;

name     'IO-Stream-Proxy-SOCKSv4';
all_from 'lib/IO/Stream/Proxy/SOCKSv4.pm';
author   'Alex Efros <powerman-asdf@ya.ru>';
license  'perl';

requires 'version';
requires 'IO::Stream';

test_requires 'Test::More';
test_requires 'Test::Exception';

my $online = prompt 'Run tests which require internet connection', 'n';
$online = lc $online eq 'y' ? 'y' : 'n';
my ($host, $port, $user, $pass);
if ($online eq 'y') {
    $host = prompt 'Please enter SOCKSv4 proxy host', q{};
    $port = prompt 'Please enter SOCKSv4 proxy port', '1080';
}
open my $f, '>', 't/config.pm' or die "open: $!";
printf {$f} "use constant CFG_ONLINE => '%s';\n", $online;
printf {$f} "use constant CFG_HOST   => '%s';\n", $host;
printf {$f} "use constant CFG_PORT   => '%s';\n", $port;
printf {$f} '1;';
close $f or die "close: $!";

WriteAll;
