# Generated by default/object.tt
package Paws::Rekognition::SegmentTypeInfo;
  use Moose;
  has ModelVersion => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Rekognition::SegmentTypeInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Rekognition::SegmentTypeInfo object:

  $service_obj->Method(Att1 => { ModelVersion => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Rekognition::SegmentTypeInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ModelVersion

=head1 DESCRIPTION

Information about the type of a segment requested in a call to
StartSegmentDetection. An array of C<SegmentTypeInfo> objects is
returned by the response from GetSegmentDetection.

=head1 ATTRIBUTES


=head2 ModelVersion => Str

The version of the model used to detect segments.


=head2 Type => Str

The type of a segment (technical cue or shot detection).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Rekognition>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

