# Generated by default/object.tt
package Paws::ES::PackageSource;
  use Moose;
  has S3BucketName => (is => 'ro', isa => 'Str');
  has S3Key => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::PackageSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::PackageSource object:

  $service_obj->Method(Att1 => { S3BucketName => $value, ..., S3Key => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::PackageSource object:

  $result = $service_obj->Method(...);
  $result->Att1->S3BucketName

=head1 DESCRIPTION

The S3 location for importing the package specified as C<S3BucketName>
and C<S3Key>

=head1 ATTRIBUTES


=head2 S3BucketName => Str

Name of the bucket containing the package.


=head2 S3Key => Str

Key (file name) of the package.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

