/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public final class InnerStateConcurrent
implements IEntityImage {
    private final IEntityImage im;
    public static final double THICKNESS_BORDER = 1.5;
    private static final int DASH = 8;

    public InnerStateConcurrent(IEntityImage iEntityImage) {
        this.im = iEntityImage;
    }

    public void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        uGraphic.apply(new UStroke(8.0, 10.0, 1.5)).draw(uRectangle);
        this.im.drawU(uGraphic);
    }

    public HtmlColor getBackcolor() {
        return null;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.im.calculateDimension(stringBounder);
        return dimension2D;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }

    public boolean isHidden() {
        return this.im.isHidden();
    }
}

