# Generated by default/object.tt
package Paws::CodeBuild::BuildGroup;
  use Moose;
  has CurrentBuildSummary => (is => 'ro', isa => 'Paws::CodeBuild::BuildSummary', request_name => 'currentBuildSummary', traits => ['NameInRequest']);
  has DependsOn => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'dependsOn', traits => ['NameInRequest']);
  has Identifier => (is => 'ro', isa => 'Str', request_name => 'identifier', traits => ['NameInRequest']);
  has IgnoreFailure => (is => 'ro', isa => 'Bool', request_name => 'ignoreFailure', traits => ['NameInRequest']);
  has PriorBuildSummaryList => (is => 'ro', isa => 'ArrayRef[Paws::CodeBuild::BuildSummary]', request_name => 'priorBuildSummaryList', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::BuildGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::BuildGroup object:

  $service_obj->Method(Att1 => { CurrentBuildSummary => $value, ..., PriorBuildSummaryList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::BuildGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->CurrentBuildSummary

=head1 DESCRIPTION

Contains information about a batch build build group. Build groups are
used to combine builds that can run in parallel, while still being able
to set dependencies on other build groups.

=head1 ATTRIBUTES


=head2 CurrentBuildSummary => L<Paws::CodeBuild::BuildSummary>

A C<BuildSummary> object that contains a summary of the current build
group.


=head2 DependsOn => ArrayRef[Str|Undef]

An array of strings that contain the identifiers of the build groups
that this build group depends on.


=head2 Identifier => Str

Contains the identifier of the build group.


=head2 IgnoreFailure => Bool

Specifies if failures in this build group can be ignored.


=head2 PriorBuildSummaryList => ArrayRef[L<Paws::CodeBuild::BuildSummary>]

An array of C<BuildSummary> objects that contain summaries of previous
build groups.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

