/*
 * dmnt.c - Ultrix mount support functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dmnt.c,v 1.2 98/02/13 12:47:01 abe Exp $";
#endif


#include "lsof.h"
#undef	KERNEL
#include <sys/fs_types.h>


/*
 * readmnt() - read mount table
 */

int
readmnt()
{
	char *dn = (char *)NULL;
	int err = 0;
	struct fs_data f;
	char *ln;
	struct mounts *mtp;
	int n;
	int procfs = 0;
	int rv;
	struct stat sb;
	int st = 0;
/*
 * Read mount table entries.
 */
	while((rv = getmountent(&st,  &f, 1)) == 1) {

	/*
	 * Interpolate a possible symbolic directory link.
	 */
	    if (dn)
		(void) free((FREE_P *)dn);
	    if (!(dn = (char *)malloc((MALLOC_S)strlen(f.fd_path)+1))) {
		err = 1;
		break;
	    }
	    (void) strcpy(dn, f.fd_path);
	    if (!(ln = Readlink(dn))) {
		if (!Fwarn) {
		    (void) fprintf(stderr,
			"      Output information may be incomplete.\n");
		    }
		    err = 2;
		    continue;
		}
	    if (ln != dn) {
		(void) free((FREE_P *)dn);
		dn = ln;
	    }
	/*
	 * Stat() the directory.
	 */
	    if (statsafely(dn, &sb)) {
		if (!Fwarn) {
		    (void) fprintf(stderr,
			"%s: WARNING: can't stat() %s file system %s\n",
			Pn, gt_names[f.fd_fstype], dn);
		    (void) fprintf(stderr,
			"      Output information may be incomplete.\n");
		}
		err = 2;
		(void) bzero((char *)&sb, sizeof(sb));
		sb.st_dev = f.fd_dev;
		sb.st_mode = S_IFDIR | 0777;
		if (!Fwarn) {
		    (void) fprintf(stderr,
			"      assuming \"dev=%x\" from mount table\n",
			sb.st_dev);
		}
	    }
	/*
	 * Allocate and fill a local mount structure.
	 */
	    if (!(mtp = (struct mounts *)malloc(sizeof(struct mounts)))) {
		err = 1;
		break;
	    }
	    mtp->dir = dn;
	    dn = (char *)NULL;
	    mtp->next = Mtab;
	    mtp->dev = sb.st_dev;
	    mtp->rdev = sb.st_rdev;
	    mtp->inode = sb.st_ino;
	    mtp->mode = sb.st_mode;
	/*
	 * Interpolate a possible file system (mounted-on) device name link.
	 */
	    if (!(dn = (char *)malloc((MALLOC_S) strlen(f.fd_devname) + 1))) {
		err = 1;
		break;
	    }
	    (void) strcpy(dn, f.fd_devname);
	    mtp->fsname = dn;
	    ln = Readlink(dn);
	    dn = (char *)NULL;
	/*
	 * Stat() the file system (mounted-on) name and add file system
	 * information to the local mount table entry.
	 */
	    if (!ln || statsafely(ln, &sb))
		sb.st_mode = 0;
	    mtp->fsnmres = ln;
	    mtp->fs_mode = sb.st_mode;
	    Mtab = mtp;
	}
	if (rv == -1)
	    err = 3;
/*
 * Clean up and handle errors.
 */
	if (dn)
	    (void) free((FREE_P *)dn);
	switch(err) {
	case 1:
	    (void) fprintf(stderr, "%s: no space for mount at %s (%s)\n",
		Pn, f.fd_path, f.fd_devname);
	    return(0);
	case 2:
	    return(1);
	case 3:
	    (void) fprintf(stderr, "%s: getmountent: %s\n",
		Pn, strerror(errno));
	    Exit(1);
	}
	return(1);
}
