/*
 * dnode2.c - Sun node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */


/*
 * Copyright 1997 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode2.c,v 1.5 97/10/24 07:55:47 abe Exp $";
#endif


#include "lsof.h"

#if	defined(HASVXFS)

# if	defined(HASVXFS_FS_H) && !defined(HASVXFS_VX_INODE)
#undef	fs_bsize
#include <sys/fs/vx_fs.h>
# endif	/* defined(HASVXFS_FS_H) && !defined(HASVXFS_VX_INODE) */

# if	defined(HASVXFS_SOL_H)
#include <sys/fs/vx_sol.h>
# endif	/* HASVXFS_SOL_H */

#include <sys/fs/vx_inode.h>


/*
 * read_vxnode() - read Veritas file system inode information
 */

int
read_vxnode(va, v, vfs, dev, ino, sz)
	caddr_t va;			/* containing vnode's address */
	struct vnode *v;		/* containing vnode */
	struct l_vfs *vfs;		/* local vfs structure */
	dev_t *dev;			/* device number receiver */
	unsigned long *ino;		/* inode number receiver */
	unsigned long *sz;		/* size receiver */
{

# if	defined(HASVXFS_VX_INODE)
	struct vx_inode vx;
# else	/* !defined(HASVXFS_VX_INODE) */
	struct inode vx;
# endif	/* defined(HASVXFS_VX_INODE) */

/*
 * Read vnode's vx_inode.
 */
	if (!v->v_data || kread((KA_T)v->v_data, (char *)&vx, sizeof(vx))) {
	    (void) sprintf(Namech, "node at %#lx: can't read vx_inode: %#lx",
		(unsigned long)va, (unsigned long)v->v_data);
	    return(1);
	}
/*
 * Return device number, inode number, and size.
 */
	if (v->v_type == VCHR || v->v_type == VBLK)
	    *dev = (dev_t)v->v_rdev;
	else if (vfs && vfs->fsname)
	    *dev = (dev_t)vfs->dev;
	else
	    *dev = (dev_t)vx.i_dev;
	*ino = (unsigned long)vx.i_number;
	*sz = (unsigned long)vx.i_size;
	return(0);
}
#endif	/* defined(HASVXFS) */
