/*
 * dlsof.h - PTX header file for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.8 98/02/13 12:44:05 abe Exp $
 */


#if	!defined(PTX_LSOF_H)
#define	PTX_LSOF_H	1

#include <dirent.h>

# if	PTXV>=420
#define	_INKERNEL	1
# endif	/* PTXV>=420 */

# if	PTXV>=430
#define	_VIEW_OPAQUE_TYPE	1
# endif	/* PTXV>=430 */

#include <fcntl.h>

# if	PTXV>=420
#undef	_INKERNEL
# endif	/* PTXV>=420 */

#include <mntent.h>
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <nlist.h>
#include <sys/flock.h>
#include <sys/time.h>
#include <sys/vm.h>

# if	PTXV>=400
#include <sys/cred.h>
#include <sys/vm_as.h>
# else	/* PTXV<400 */
#include <sys/swap.h>
# endif	/* PTXV>=400 */

#include <sys/vnode.h>
#include <sys/procstats.h>
#include <sys/proc.h>
#include <sys/session.h>
#include <sys/socket.h>
#undef	AF_OSINET
#include <sys/snode.h>
#include <sys/sysmacros.h>
#include <sys/swap.h>
#include <sys/un.h>
#include <sys/var.h>
#include <sys/vfs.h>
#include <sys/ufsmount.h>
#include <netinet/in.h>

# if	PTXV<400
#define	u_char	RPC_u_char
#define	u_short	RPC_u_short
#define	u_long	RPC_u_long
# endif	/* PTXV<400 */

#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>

# if	PTXV>=400
#include <rpc/rpc_soc.h>
# endif	/* PXV>=400 */

# if	PTXV<400
#undef	RPC_u_char
#undef	RPC_u_short
#undef	RPC_u_long
# endif	/* PTXV<400 */

# if	defined(HAS_NFS)
#include <nfs/nfs.h>
#include <nfs/nfs_clnt.h>

#  if	PTXV<400
#include <nfs/rnode.h>
#  else	/* PTXV>=400 */
#include "/usr/conf/uts/nfs/rnode.h"
#  endif	/* PTXV<400 */
# endif	/* defined(HAS_NFS) */

# if	PTXV<400
#define _INKERNEL
# endif	/* PTXV<400 */

#include <sys/fifonode.h>
#include <sys/file.h>

# if	PTXV>=400
#define	_INKERNEL	1
#define	INKERNEL	1
#include <sys/namenode.h>
#undef	_INKERNEL
#undef	INKERNEL
# endif	/* PTXV>=400 */

#include <sys/stream.h>
#include <sys/tihdr.h>
#include <sys/tiuser.h>

# if	PTXV>=421
#include <sys/unpcb.h>
# endif	/* PTXV>=421 */

# if	PTXV>=413
#include <sys/domain.h>
#include <sys/protosw.h>
#  if	PTXV>=430
#define	_INKERNEL	1
#  else	/* PTXV<430 */
#define	INKERNEL	1
#  endif	/* PTXV>=430 */
#include <sys/sockmod.h>
#  if	PTXV>=430
#undef	_INKERNEL
#  else	/* PTXV<430 */
#undef	INKERNEL
#  endif	/* PTXV>=430 */
# else	/* PTXV<413 */
#include <sys/sockmod.h>
# endif	/* PTXV>=413 */

#include <sys/socketvar.h>
#include <sys/user.h>

# if	PTXV<400
#undef _INKERNEL
# endif	/* PTXV<400 */

# if	PTXV>=413
#include <netinet/ip.h>
# endif	/* PTXV>=413 */

#include <netinet/in_pcb.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>


#define	COMP_P		const void
#define QSORT_P		void

#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define MALLOC_P	void
#define FREE_P		MALLOC_P
#define MALLOC_S	size_t
#define	MOUNTED		MNTTABNAME

# if	defined(HASNCACHE)
#define	NC_SIZE		128	/* should come from a header file */
# endif	/* defined(HASNCACHE) */

#define N_UNIX		"/unix"
#define	READLEN_T	size_t
#define STRNCPY_L	size_t
#define SWAP		"/dev/swap"

# if	PTXV>=400
#define	SZOFFTYPE	unsigned long long
				/* type for size and offset */
#define	SZOFFPSPEC	"ll"	/* SZOFFTYPE printf specification modifier */
# endif	/* PTXV>=400 */

#define	U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

struct clone {
	int dx;				/* index of device entry in Devtp[] */
	struct clone *next;		/* forward link */
};
extern struct clone *Clone;

extern int CloneMajor;			/* clone major device number */
extern int HaveCloneMajor;		/* CloneMajor status */
extern int Kd;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	dev_t dev;			/* device */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */

# if	defined(HASFSINO)
	ino_t fs_ino;			/* file system inode number */
# endif	/* defined(HASFSINO) */

	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        char *dir;              	/* directory (mounted on) */
	char *fsname;           	/* file system
					 * (symbolic links unresolved) */
	char *fsnmres;           	/* file system
					 * (symbolic links resolved) */
        dev_t dev;              	/* directory st_dev */
	dev_t rdev;			/* directory st_rdev */
	ino_t inode;			/* directory st_ino */
	mode_t mode;			/* directory st_mode */
	mode_t fs_mode;			/* file system st_mode */
        struct mounts *next;    	/* forward link */
};

#define	X_NCACHE	"ncache"
#define	X_NCSIZE	"ncsize"
#define	NL_NAME		n_name

extern int Notkmem;

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	mode_t mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

# if	PTXV<400
extern int Swap;
# endif	/* PTXV<400 */


/*
 * Definition for rdev.c
 */

#define	DIRTYPE	dirent


/*
 * Definition for cvfs.c
 */

#define	CVFS_DEVSAVE 	1


/*
 * Definitions for rnch.c
 */

# if     defined(HASNCACHE) && !defined(HASVXFSDNLC)
#include <sys/dnlc.h>
# endif  /* defined(HASNCACHE) && !defined(HASVXFSDNLC) */

# if	PTXV>=442
#define	NCACHE_DP	nc_dp
#define	NCACHE_NAME	nc_name
#define	NCACHE_NAMLEN	nc_namelen
#define	NCACHE_VP	nc_vp
# endif	/* PTXV>=442 */

#endif	/* PTX_LSOF_H */
