/*
 * ddev.c - PTX device support functions for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: ddev.c,v 1.2 97/04/15 10:42:48 abe Exp Locker: abe $";
#endif


#include "lsof.h"


/*
 * findclones() - find clone devices and build a list of them
 */

void
findclones()
{
	struct clone *c;
	int i;

	if ( ! HaveCloneMajor)
		return;
	readdev(0);
	for (i = 0; i < Ndev; i++) {
	    if (major(Devtp[i].rdev) == CloneMajor) {
		if (!(c = (struct clone *)malloc(sizeof(struct clone)))) {
		    (void) fprintf(stderr,
			"%s: no space for clone device: %s\n",
			Pn, Devtp[i].name);
		    Exit(1);
		}
		c->dx = i;
		c->next = Clone;
		Clone = c;
	    }
	}
}


/*
 * printchdevname() - print character device name
 */

int
printchdevname(rdev, f)
	dev_t *rdev;			/* device */
	int f;				/* 1 = follow with '\n' */
{
	struct clone *c;
	struct l_dev *dp;
/*
 * Seach device table for match.
 */

#if	defined(HASDCACHE)

printchdevname_again:

#endif	/* defined(HASDCACHE) */

	if ((dp = lkupdev(rdev, 1, 0))) {
	    if (f)
		(void) puts(dp->name);
	    else
		(void) fputs(dp->name, stdout);
	    return(1);
	}
/*
 * Search for clone.
 */
	if (Clone) {
	    for (c = Clone; c; c = c->next) {
		if (major(*rdev) == minor(Devtp[c->dx].rdev)) {

#if	defined(HASDCACHE)
		    if (DCunsafe && !Devtp[c->dx].v && !vfy_dev(&Devtp[c->dx]))
			goto printchdevname_again;
#endif	/* defined(HASDCACHE) */

		    if (f)
			(void) puts(Devtp[c->dx].name);
		     else
			(void) fputs(Devtp[c->dx].name, stdout);
		    return(1);
		}
	    }
	}

#if	defined(HASDCACHE)
/*
 * If the device cache is "unsafe" and we haven't found any match, reload
 * the device cache.
 */
	if (DCunsafe) {
	    (void) rereaddev();
	    goto printchdevname_again;
	}
#endif	/* defined(HASDCACHE) */

	return(0);
}
