/*
 * dlsof.h - SGI IRIX header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.12 98/02/13 12:43:34 abe Exp $
 */


#if	!defined(IRIX_LSOF_H)
#define	IRIX_LSOF_H	1

#if	(defined(IRIX32BITS) && IRIXV>=50300) || IRIXV>=60200
/*
 * Defining _KERNEL and above while including <sys/types.h> sometimes
 * changes the size of some types, thus affecting the stat(2) buffer
 * structure.  Switching from [l]stat to [l]stat64 is sometimes the cure.
 */

#define	lstat	lstat64
#define	stat	stat64
#endif	/* (defined(IRIX32BITS) && IRIXV>=50300) || IRIXV>=60200 */

#include <rpc/types.h>
#include <malloc.h>
#include <mntent.h>
#include <signal.h>
#include <string.h>
#include <nlist.h>
#include <unistd.h>

# if	IRIXV>=50101
#define	L_SET	SEEK_SET
#include <stddef.h>
# endif	/* IRIXV>=50101 */

#include <netinet/in.h>
#include <sys/conf.h>
#include <sys/dir.h>
#define	_KERNEL	1
#include <sys/file.h>
#undef	_KERNEL
#include <sys/fcntl.h>
#include <sys/flock.h>
#include <sys/immu.h>
#include <sys/sysmacros.h>
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>

# if	IRIXV<50101
#include <sys/inode.h>
# else	/* IRIXV>=50101 */
/*
 * Some of the following header files are found in the private subdirectories
 * irix5hdr and irix6hdr.   The files were left out of IRIX distributions.
 * The Configure script enters an -I<sub_directory> C flags option in the
 * Makefile, appropriate to the IRIX version.
 */
#define	_KERNEL	1
#  if	IRIXV<50200
#include <sys/fs/inode.h>
#  else	/* IRIXV>=50200 */
#   if	IRIXV>=60400
#include <ksys/behavior.h>
#include <sys/cred.h>
#   endif	/* IRIXV>=60400 */
#include <sys/fs/efs_inode.h>
#  endif	/* IRIXV<50200 */
#undef	_KERNEL

# if	defined(HASCACHEFS)
/*
 * Temporarily redefine some function names whose conflicting prototypes appear
 * for applications in <unistd.h> and for the kernel, when _KERNEL is defined,
 * in <sys/systm.h>.  (<cachefs_fs.h> #includes <sys/systm.h>.)
 */
#define	atoi		LSOF_atoi
#define	exit		LSOF_exit
#define	fork		LSOF_fork
#define	printf		LSOF_printf
#define	signal		LSOF_signal
#define	sleep		LSOF_sleep
#define	sprintf		LSOF_sprintf
#define	vsprintf	LSOF_vsprintf
#define	_KERNEL	1
#include <cachefs/cachefs_fs.h>
#undef	_KERNEL
#undef	atoi
#undef	exit
#undef	fork
#undef	printf
#undef	signal
#undef	sleep
#undef	sprintf
#undef	vsprintf
# endif	/* defined(HASCACHEFS) */

#include <fifofs/fifonode.h>
#include <specfs/snode.h>

#include <pipefs/pipenode.h>
#include <sys/fstyp.h>
#include <sys/fsid.h>
#include <sys/major.h>
#include <sys/sat.h>
#include <sys/strsubr.h>
#include <sys/vfs.h>
#include <sys/vnode.h>
# endif	/* IRIXV<50101 */

#include <sys/major.h>

# if	defined(MFREE)
#undef	MFREE
# endif	/* defined(MFREE) */

#include <sys/mbuf.h>

# if	defined(MFREE)
#undef	MFREE
# endif	/* defined(MFREE) */

#include <sys/mount.h>

# if	IRIXV<60400
#include <sys/proc.h>
# endif	/* IRIXV<60400 */

#include <sys/stream.h>
#include <sys/syssgi.h>
#include <sys/sysmp.h>
#include <sys/un.h>
#include <sys/unpcb.h>

# if	IRIXV<60000 || defined(IRIX32BITS)
#include <sys/user.h>
# else	/* IRIXV>=60000  && !defined(IRIX32BITS) */
#include <sys/sbd.h>
#undef	NWIREDENTRIES
# endif	/* IRIXV<60000 || defined(IRIX32BITS) */

# if	IRIXV>=60400
#include <sys/fs/fdt.h>
# endif	/* IRIXV>=60400 */

#include <sys/region.h>
#include <sys/var.h>
#include <sys/fs/nfs.h>

# if	IRIXV==50300 && defined(HAS53NFSROLLUP)
/*
 * If this IRIX 5.3 system has the NFS kernel rollup patch (1477) installed,
 * <sys/fs/rnode.h> will probably not have been updated to match the rnode
 * struct the patched kernel uses.  Aliasing scoff_t to off_t effects that
 * update.  Note: the alias is erased after rnode.h has been included to allow
 * other possible uses of the scoff_t typdef to get the definition originally
 * made via <sgidefs.h> and <sys/types.h>.
 */

#define	scoff_t	off64_t
# endif	/* IRIXV==50300 && defined(HAS53NFSROLLUP) */

#include <sys/fs/rnode.h>
#define	r_snfsattr	r_nfsattr

# if	IRIXV==50300 && defined(HAS53NFSROLLUP)
#undef	scoff_t
# endif	/* IRIXV==50300 && defined(HAS53NFSROLLUP) */

#include <sys/domain.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <net/route.h>
#include <net/raw_cb.h>

# if	IRIXV>=60200
#include <netinet/in_systm.h>
#include <netinet/ip.h>
# endif	/* IRIXV>=60200 */

#include <netinet/in_pcb.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>

# if	defined(HASPROCFS)
#undef	VTOP
#undef	PTOV

#  if	IRIXV>=60400
#undef	BHVTOP
#undef	PTOBHV
#  endif	/* IRIXV>=60400 */

#include <procfs/prdata.h>
#define	PR_ROOTINO	2
# endif	/* defined(HASPROCFS) */

/*
 * Private XFS definitions
 */

# if	IRIXV==50300 || IRIXV>=60200
#  if	IRIXV==50300

/*
 * Private xfs_inode structure for IRIX 5.3
 *
 * This definition is forced upon lsof because SGI doesn't distribute the
 * full set of XFS header files.
 */

struct xfs_inode {
	int d1[9];
	dev_t i_dev;			/* device */

#   if	defined(IRIX32BITS)
	int d2;
	unsigned long i_ino;		/* node number */
#   else	/* !defined(IRIX32BITS) */
	__uint64_t i_ino;		/* node number */
#   endif	/* defined(IRIX32BITS) */

	int d3[116];
	struct ondisk {

#   if	defined(IRIX32BITS)
		int d4;
		unsigned long di_size;	/* size */
#   else	/* !defined(IRIX32BITS) */ 
		__uint64_t di_size;	/* size */
#   endif	/* defined(IRIX32BITS) */

	} i_d;
};

#  else /* IRIXV!=50300 */
#   if	IRIXV<60300
#    if	defined(HASXFSROLLUP)

/*
 * IRIX >= 6.2 and < 6.3 with XFS rollup patch
 */

#     if	defined(IRIX32BITS)
/*
 * 32 bit IRIX >= 6.2 and < 6.3 with XFS rollup patch
 */
#define	LSOF_XFS_SKIP_1		25
#define	LSOF_XFS_SKIP_2		1
#define	LSOF_XFS_SKIP_3		49
#     else	/* !defined(IRIX32BITS) */
/*
 * 64 bit IRIX >= 6.2 and < 6.3 with XFS rollup patch
 */
#define	LSOF_XFS_SKIP_1		36
#define	LSOF_XFS_SKIP_2		2
#define	LSOF_XFS_SKIP_3		63
#     endif	/* defined(IRIX32BITS) */

#    else	/* !defined(HASXFSROLLUP) */

#     if	defined(IRIX32BITS)
/*
 * IRIX >= 6.2 and < 6.3, 32 bits, and has no XFS rollup patch
 */

#define	LSOF_XFS_SKIP_1		23
#define	LSOF_XFS_SKIP_2		1
#define	LSOF_XFS_SKIP_3		49

#     else	/* !defined(IRIX32BITS) */

/*
 * IRIX >= 6.2 and < 6.3, 64 bits, and has no XFS rollup patch
 */

#define	LSOF_XFS_SKIP_1		32
#define	LSOF_XFS_SKIP_2		2
#define	LSOF_XFS_SKIP_3		63

#     endif	/* defined(IRIX32BITS) */
#    endif	/* defined(HASXFSROLLUP) */
#   else	/* IRIXV>=60300 */
#    if	IRIXV<60400

/*
 * IRIX >= 6.3 and < 6.4
 */

#define	LSOF_XFS_SKIP_1		25
#define	LSOF_XFS_SKIP_2		1
#define	LSOF_XFS_SKIP_3		49

#    else	/* IRIXV>=60400 */

/*
 * IRIX >= 6.4
 */

#define	LSOF_XFS_SKIP_1		42
#define	LSOF_XFS_SKIP_2		2

#     if	defined(HASXFSROLLUP)
#define	LSOF_XFS_SKIP_3		63
#     else	/* !defined(HASXFSROLLUP) */
#define	LSOF_XFS_SKIP_3		59
#     endif	/* defined(HASXFSROLLUP) */

#    endif	/* IRIXV<60400 */
#   endif	/* IRIXV<60300 */



/*
 * Private xfs_inode structure for IRIX 6.2 and above
 *
 * This definition is forced upon lsof because SGI doesn't distribute the
 * full set of XFS header files.
 */

struct xfs_inode {
	int d1[LSOF_XFS_SKIP_1];
	unsigned long i_ino;		/* node number */
	int d2[LSOF_XFS_SKIP_2];
	dev_t i_dev;			/* device */
	int d3[LSOF_XFS_SKIP_3];
	struct ondisk {
		unsigned long di_size;	/* size */
	} i_d;
};
#  endif /* IRIXV==50300 */
# endif	/* IRIXV==50300 || IRIXV>=60200 */

#define	COMP_P		const void
#define DEVINCR		1024	/* device table malloc() increment */
#define	FSNAMEL		4
#define	KA_T		long
#define	KMEM		"/dev/kmem"
#define N_UNIX		"/unix"
#define MALLOC_P	void

# if	defined(MNTTAB)
#undef	MNTTAB
# endif	/* defined(MNTTAB) */

#define	MNTTAB		MOUNTED
#define FREE_P		MALLOC_P
#define MALLOC_S	size_t
#define	PROCSIZE	sizeof(struct proc)
#define QSORT_P		void
#define	READLEN_T	unsigned
#define STRNCPY_L	size_t
#define	STRNML		32

# if	IRIXV>=50300
#define	SZOFFTYPE	unsigned long long
				/* type for size and offset */
#define	SZOFFPSPEC	"ll"	/* SZOFFTYPE printf specification modifier */
# endif	/* IRIXV>=50300 */

#define U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

struct clone {
	int dx;			/* index of device entry in Devtp[] */
	struct clone *next;	/* forward link */
};
extern struct clone *Clone;


# if	IRIXV>=50101 && IRIXV<60200
extern char *Cwd;
# endif	/* IRIXV>=50101 && IRIXV<60200 */

# if	IRIXV>=50101
extern char **Fsinfo;
extern int Fsinfomax;
# else	/* IRIXV<50101 */
extern struct fsinfo *Fsinfo;
# endif	/* IRIXV>=50101 */

extern int Kd;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */

# if	defined(HASFSINO)
	ino_t fs_ino;			/* file system inode number */
# endif	/* defined(HASFSINO) */

	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        char *dir;              	/* directory (mounted on) */
	char *fsname;           	/* file system
					 * (symbolic links unresolved) */
	char *fsnmres;           	/* file system
					 * (symbolic links resolved) */
        dev_t dev;              	/* directory st_dev */
	dev_t rdev;			/* directory st_rdev */
	ino_t inode;			/* directory st_ino */
	mode_t mode;			/* directory st_mode */
	mode_t fs_mode;			/* file system st_mode */
        struct mounts *next;    	/* forward link */

# if	defined(HASFSTYPE)
	char *fstype;			/* st_fstype */
# endif	/* defined(HASFSTYPE) */

};

extern short Nfstyp;

#define	X_NCACHE	"ncache"
#define	X_NCSIZE	"ncsize"
#define	NL_NAME		n_name

# if	IRIXV>=50101 && IRIXV<60200
extern char *Rtd;
# endif	/* IRIXV>=50101 && IRIXV<60200 */

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	mode_t mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

# if	IRIXV>=50101
/*
 * This #include and accompanying #undef's is placed last, lest the
 * #undef's disturb something else.  The #undef's prevent symbol
 * conflicts between <setjmp.h> and <sys/pcb.h>.
 */

#undef	JB_S0
#undef	JB_S1
#undef	JB_S2
#undef	JB_S3
#undef	JB_S4
#undef	JB_S5
#undef	JB_S6
#undef	JB_S7
#undef	JB_SP
#undef	JB_FP
#undef	JB_PC
#undef	NJBREGS
# endif	/* IRIXV>=50101 */

#include <setjmp.h>


/*
 * Definitions for dvch.c
 */

#define	DCACHE_CLONE	rw_clone_sect	/* clone function for read_dcache */
#define	DCACHE_CLR	clr_sect	/* function to clear clone and
					 * pseudo caches when reading the
					 * device cache file fails */


/*
 * Definitions for rnch.c
 */

# if     defined(HASNCACHE)
#include <sys/dnlc.h>
#define NCACHE_NODEID   vp_cap		/* node ID in NCACHE */
#define	NCACHE_NXT	lru_next	/* link to next cache entry */
#define NCACHE_PARID    dp_cap		/* parent node ID in NCACHE */
# endif  /* defined(HASNCACHE) */

#endif	/* IRIX_LSOF_H	*/
