#!../../bin/wish -f
# --------------------------------------------------------------------------
# Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
#
# You can use and distribute this software under the terms of the license
# version 1 you should have received along with this software.
# If not or if you want additional information, write to
# Forschungszentrum Informatik, "OBST", Haid-und-Neu-Strasse 10-14,
# D-76131 Karlsruhe, Germany.
# --------------------------------------------------------------------------
# Program: mtaTool_tk
# Tcl version: 6.7 (Tcl/Tk/XF)
# Tk version: 3.2
# XF version: 2.2
#

# module inclusion
global env
global xfLoadPath
global xfLoadInfo
set xfLoadInfo 0
if {[info exists env(XF_LOAD_PATH)]} {
  if {[string first $env(XF_LOAD_PATH) .:/usr/local/lib/] == -1} {
    set xfLoadPath $env(XF_LOAD_PATH):.:/usr/local/lib/
  } {
    set xfLoadPath .:/usr/local/lib/
  }
} {
  set xfLoadPath .:/usr/local/lib/
}



# procedure to show window ShowWindow.vpbox
proc ShowWindow.vpbox { args} {
# xf ignore me 7

  # build widget .vpbox
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .vpbox"
  } {
    catch "destroy .vpbox"
  }
  toplevel .vpbox    -relief {raised}

  # Window manager configurations
  global tkVersion
  wm positionfrom .vpbox ""
  wm sizefrom .vpbox ""
  wm geometry .vpbox 188x120
  wm maxsize .vpbox 1000 900
  wm minsize .vpbox 10 10
  wm title .vpbox {ViewParameter}


  # build widget .vpbox.frame8
  frame .vpbox.frame8

  # build widget .vpbox.frame8.frame12
  frame .vpbox.frame8.frame12    -borderwidth {2}

  # build widget .vpbox.frame8.frame12.radiobutton14
  radiobutton .vpbox.frame8.frame12.radiobutton14     -anchor {w}    -padx {2}    -text {methods}    -value {METHODS}    -variable {mta::_elemKind}    -width {11}

  # build widget .vpbox.frame8.frame12.radiobutton15
  radiobutton .vpbox.frame8.frame12.radiobutton15     -anchor {w}    -padx {2}    -text {components}    -value {COMPONENTS}    -variable {mta::_elemKind}    -width {11}

  # build widget .vpbox.frame8.frame12.radiobutton16
  radiobutton .vpbox.frame8.frame12.radiobutton16     -anchor {w}    -padx {2}    -text {base classes}    -value {BASE_CLASSES}    -variable {mta::_elemKind}    -width {11}

  # pack widget .vpbox.frame8.frame12
  pack append .vpbox.frame8.frame12     .vpbox.frame8.frame12.radiobutton14 {top frame center padx 8 pady 8}     .vpbox.frame8.frame12.radiobutton15 {top frame center}     .vpbox.frame8.frame12.radiobutton16 {top frame center} 

  # build widget .vpbox.frame8.frame13
  frame .vpbox.frame8.frame13    -borderwidth {2}

  # build widget .vpbox.frame8.frame13.radiobutton17
  radiobutton .vpbox.frame8.frame13.radiobutton17     -anchor {w}    -padx {2}    -text {local}    -value {LOCAL}    -variable {mta::_elemScope}    -width {5}

  # build widget .vpbox.frame8.frame13.radiobutton18
  radiobutton .vpbox.frame8.frame13.radiobutton18     -anchor {w}    -padx {2}    -text {all}    -value {ALL}    -variable {mta::_elemScope}    -width {5}

  # pack widget .vpbox.frame8.frame13
  pack append .vpbox.frame8.frame13     .vpbox.frame8.frame13.radiobutton17 {top frame center padx 8 pady 8}     .vpbox.frame8.frame13.radiobutton18 {top frame center} 

  # pack widget .vpbox.frame8
  pack append .vpbox.frame8     .vpbox.frame8.frame12 {left frame center expand fill}     .vpbox.frame8.frame13 {right frame center expand fill} 

  # build widget .vpbox.frame9
  frame .vpbox.frame9    -geometry {30x46}

  # build widget .vpbox.frame9.button11
  button .vpbox.frame9.button11    -command {DestroyWindow[SymbolicName mta::ViewParamBox]}    -text {Close}    -width {9}

  # pack widget .vpbox.frame9
  pack append .vpbox.frame9     .vpbox.frame9.button11 {bottom frame center pady 20} 

  # pack widget .vpbox
  pack append .vpbox     .vpbox.frame8 {top frame center expand fill}     .vpbox.frame9 {bottom frame center fillx} 

  if {"[info procs XFEdit]" != ""} {
    XFEditSetShowWindows
    XFMiscBindWidgetTree .vpbox
  }
}

proc DestroyWindow.vpbox {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .vpbox]" != ""} {
      global xfShowWindow.vpbox
      set xfShowWindow.vpbox 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .vpbox; XFEditSetShowWindows"
    }
  } {
    catch "destroy .vpbox"
    update
  }
}


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  global tkVersion
  wm positionfrom . ""
  wm sizefrom . ""
  wm geometry . 512x444
  wm maxsize . 1152 900
  wm minsize . 0 0
  wm title . {mtaTool_tk.tcl}


  # build widget .frame0
  frame .frame0 \
    -borderwidth {1} \
    -relief {raised}

  # build widget .frame0.menubutton3
  menubutton .frame0.menubutton3 \
    -borderwidth {1} \
    -menu {.frame0.menubutton3.m} \
    -relief {raised} \
    -text {Objects}

  # build widget .frame0.menubutton3.m
  menu .frame0.menubutton3.m
  .frame0.menubutton3.m add command \
    -command {ShowWindow.vpbox} \
    -label {View Parameter}
  .frame0.menubutton3.m add command \
    -command {destroy .} \
    -label {Quit}

  # build widget .frame0.menubutton4
  menubutton .frame0.menubutton4 \
    -borderwidth {1} \
    -menu {.frame0.menubutton4.m} \
    -relief {raised} \
    -text {Help}

  # build widget .frame0.menubutton4.m
  menu .frame0.menubutton4.m
  .frame0.menubutton4.m add command \
    -command {infobox::displayInfo about} \
    -label {About ...}

  # pack widget .frame0
  pack append .frame0 \
    .frame0.menubutton3 {left frame center filly} \
    .frame0.menubutton4 {right frame center filly}

  # build widget .frame1
  frame .frame1

  # build widget .frame1.frame
  frame .frame1.frame \
    -borderwidth {1}

  # build widget .frame1.frame.scrollbar2
  scrollbar .frame1.frame.scrollbar2 \
    -command {.frame1.frame.listbox1 yview} \
    -width {10}

  # build widget .frame1.frame.scrollbar3
  scrollbar .frame1.frame.scrollbar3 \
    -command {.frame1.frame.listbox1 xview} \
    -orient {horizontal} \
    -width {10}

  # build widget .frame1.frame.listbox1
  listbox .frame1.frame.listbox1 \
    -borderwidth {1} \
    -exportselection {0} \
    -geometry {15x2} \
    -relief {raised} \
    -xscrollcommand {.frame1.frame.scrollbar3 set} \
    -yscrollcommand {.frame1.frame.scrollbar2 set}
  # bindings
  bind .frame1.frame.listbox1 <Any-Button-1> {mta::select_cb %W Elem %y}

  # pack widget .frame1.frame
  pack append .frame1.frame \
    .frame1.frame.scrollbar2 {left frame center filly} \
    .frame1.frame.listbox1 {top frame center expand fill} \
    .frame1.frame.scrollbar3 {bottom frame center fillx}

  # build widget .frame1.frame5
  frame .frame1.frame5

  # build widget .frame1.frame5.frame
  frame .frame1.frame5.frame \
    -borderwidth {1}

  # build widget .frame1.frame5.frame.scrollbar2
  scrollbar .frame1.frame5.frame.scrollbar2 \
    -command {.frame1.frame5.frame.listbox1 yview} \
    -width {10}

  # build widget .frame1.frame5.frame.scrollbar3
  scrollbar .frame1.frame5.frame.scrollbar3 \
    -command {.frame1.frame5.frame.listbox1 xview} \
    -orient {horizontal} \
    -width {10}

  # build widget .frame1.frame5.frame.listbox1
  listbox .frame1.frame5.frame.listbox1 \
    -borderwidth {1} \
    -exportselection {0} \
    -geometry {10x2} \
    -relief {raised} \
    -xscrollcommand {.frame1.frame5.frame.scrollbar3 set} \
    -yscrollcommand {.frame1.frame5.frame.scrollbar2 set}
  # bindings
  bind .frame1.frame5.frame.listbox1 <Any-Button-1> {mta::select_cb %W Schema %y}

  # pack widget .frame1.frame5.frame
  pack append .frame1.frame5.frame \
    .frame1.frame5.frame.scrollbar2 {left frame center filly} \
    .frame1.frame5.frame.listbox1 {top frame center expand fill} \
    .frame1.frame5.frame.scrollbar3 {bottom frame center fillx}

  # build widget .frame1.frame5.frame6
  frame .frame1.frame5.frame6 \
    -borderwidth {1}

  # build widget .frame1.frame5.frame6.scrollbar2
  scrollbar .frame1.frame5.frame6.scrollbar2 \
    -command {.frame1.frame5.frame6.listbox1 yview} \
    -width {10}

  # build widget .frame1.frame5.frame6.scrollbar3
  scrollbar .frame1.frame5.frame6.scrollbar3 \
    -command {.frame1.frame5.frame6.listbox1 xview} \
    -orient {horizontal} \
    -width {10}

  # build widget .frame1.frame5.frame6.listbox1
  listbox .frame1.frame5.frame6.listbox1 \
    -borderwidth {1} \
    -exportselection {0} \
    -geometry {20x2} \
    -relief {raised} \
    -xscrollcommand {.frame1.frame5.frame6.scrollbar3 set} \
    -yscrollcommand {.frame1.frame5.frame6.scrollbar2 set}
  # bindings
  bind .frame1.frame5.frame6.listbox1 <Any-Button-1> {mta::select_cb %W Type %y}

  # pack widget .frame1.frame5.frame6
  pack append .frame1.frame5.frame6 \
    .frame1.frame5.frame6.scrollbar2 {left frame center filly} \
    .frame1.frame5.frame6.listbox1 {top frame center expand fill} \
    .frame1.frame5.frame6.scrollbar3 {bottom frame center fillx}

  # pack widget .frame1.frame5
  pack append .frame1.frame5 \
    .frame1.frame5.frame {left frame center expand fill} \
    .frame1.frame5.frame6 {right frame center expand fill}

  # pack widget .frame1
  pack append .frame1 \
    .frame1.frame5 {left frame center expand fill} \
    .frame1.frame {right frame center expand fill}

  # build widget .frame2
  frame .frame2

  # build widget .frame2.frame
  frame .frame2.frame \
    -borderwidth {1} \
    -relief {raised}

  # build widget .frame2.frame.scrollbar1
  scrollbar .frame2.frame.scrollbar1 \
    -command {.frame2.frame.text2 yview} \
    -width {10}

  # build widget .frame2.frame.text2
  text .frame2.frame.text2 \
    -borderwidth {1} \
    -height {5} \
    -padx {2} \
    -pady {2} \
    -relief {raised} \
    -state {disabled} \
    -yscrollcommand {.frame2.frame.scrollbar1 set}

  # pack widget .frame2.frame
  pack append .frame2.frame \
    .frame2.frame.scrollbar1 {left frame center filly} \
    .frame2.frame.text2 {top frame center fill}

  # pack widget .frame2
  pack append .frame2 \
    .frame2.frame {top frame center fillx}

  # pack widget .
  pack append . \
    .frame0 {top frame center fillx} \
    .frame1 {top frame center expand fill} \
    .frame2 {top frame center fillx}


  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# User defined procedures


# ---------
proc mta::select_cb { listbox kind ypos} {
#
# in:  widget path of listbox where selection occurred,
#      kind of listbox (Schema, Type, Elem),
#      y position of selection event
# out: --
#
# Callback handler to select an entry in one of the three listboxes of the
# meta schema browser. If a select operation might take some time, the mouse
# cursor changes temporarily.
#
if {$kind != "Elem"} then {
   $listbox configure -cursor box_spiral
   update
}
mta::select$kind [$listbox nearest $ypos]

$listbox configure -cursor {}
}


# Internal procedures



# module load procedure
proc XFLocalIncludeModule {{moduleName ""}} {
  global env
  global xfLoadInfo
  global xfLoadPath
  global xfStatus

  foreach p [split $xfLoadPath :] {
    if {[file exists "$p/$moduleName"]} {
      if {![file readable "$p/$moduleName"]} {
        puts stderr "Cannot read $p/$moduleName (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName..."
      }
      source "$p/$moduleName"
      return 1
    }
    # first see if we have a load command
    if {[info exists env(XF_VERSION_SHOW)]} {
      set xfCommand $env(XF_VERSION_SHOW)
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "$xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    }
    # are we able to load versions from wish ?
    if {[catch "afbind $p/$moduleName" aso]} {
      # try to use xf version load command
      global xfVersion
      if {[info exists xfVersion(showDefault)]} {
        set xfCommand $xfVersion(showDefault)
      } {
	# our last hope
        set xfCommand "vcat -q $p/$moduleName"
      }
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "$xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    } {
      # yes we can load versions directly
      if {[catch "$aso open r" inFile]} {
        puts stderr "Cannot open $p/[$aso attr af_bound] (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/[$aso attr af_bound]..."
      }
      if {[catch "read \{$inFile\}" contents]} {
        puts stderr "Cannot read $p/[$aso attr af_bound] (permission denied)"
        close $inFile
        continue
      }
      close $inFile
      eval $contents
      return 1
    }
  }
  puts stderr "Cannot load module $moduleName -- check your xf load path"
  puts stderr "Specify a xf load path with the environment variable:"
  puts stderr "  XF_LOAD_PATH (e.g \"export XF_LOAD_PATH=.\")"
  catch "destroy ."
  catch "exit 0"
}



# end source
proc EndSrc {} {
# --------------------------------------------------------------------------
# Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
#
# You can use and distribute this software under the terms of the license
# version 1 you should have received along with this software.
# If not or if you want additional information, write to
# Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
# D-76131 Karlsruhe, Germany.
# --------------------------------------------------------------------------

#
# environment:
#  - OBST*
#
# global variables:
#  - mta::schemaDir [quasi-const]
#	Handle of OBST schema directory (type Directory<sos_Schema_module>).
#  - mta::currentTypeTbl
#	Handle type table of currently selected schema (type sos_Type_table).
#  - mta::currentType
#	Handle currently from $mta::currentTypeTbl selected type (subtype of
#	sos_Type & sos_Type_descr).
#  - mta::elemKind
#	Enumeration denoting which kind of type elements (of a class type) are
#	to be displayed.
#	Valid values are: METHODS, COMPONENTS, BASE_CLASSES.
#	The variable value is copied from mta::_elemKind when a type gets
#	selected and remains stable until the next selection takes place.
#  - mta::elemScope
#	Enumeration denoting the range of type elements (of a class type) to
#	be displayed.
#	   LOCAL - local definitions, or direct base classes.
#	   ALL	 - local and inherited definitions, or all base classes.
#	The variable value is copied from mta::_elemScope when a type gets
#	selected and remains stable until the next selection takes place.
#  - mta::_elemKind
#	Enumeration of the same meaning as mta::elemKind.
#	Associated to a group of radiobuttons in the `View Parameter' dialog.
#  - mta::_elemScope
#	Enumeration of the same meaning as mta::elemScope.
#	Associated to a group of radiobuttons in the `View Parameter' dialog.
#
   # block incomming send requests
   rename send ""

   tclOBST bind
   tclOBST customize copy_Cstrings false

   global mta::_elemKind mta::_elemScope
   set mta::_elemKind  METHODS
   set mta::_elemScope ALL

   mta::showSchemaDir
}

XFLocalIncludeModule infobox_tk.tcl
XFLocalIncludeModule mtaTool_obst.tcl
XFLocalIncludeModule xfstuff.tcl


# initialize global variables
proc InitGlobals {} {
  global {dir::containerPath}
  set {dir::containerPath} {dd}
  global {dir::objectPath}
  set {dir::objectPath} {/}
  global {infobox::aboutText}
  set {infobox::aboutText} {
                  Meta Schema Tool

`Meta Schema Tool' is a simple tool which lets you
browse the OBST meta database in a hierarchical
fashion.

Three abstraction levels are supported:
 - schema
 - type
 - type details

These three abstraction levels are mirrored by three
list which display from left to right:
 - all currently known schemata
 - all types (except for generic classes) in the
   selected schema
 - details concerning the currently selected type

There is furthermore a text field at the bottom which
holds additional information about the current
selection:
 - The size of an external type.
 - The type named by a typedef.
 - The sequence number of an enumeration literal.
 - The types subsumed by an union type.
 - Method signatures for a class type.

Selections are performed by clicking on the respective
list entry. The lists to the right as well as the text
field will then be redisplayed.

The display of a class type can be further tailored
after activating 'View Parameter' from the 'Objects'
menu.
It is possible to either select methods, components,
or base classes, as well as to restrict the display
to just the local details, respectively to just the
direct base classes.

In case of components, the method signatures of the
accessor methods will be displayed in the text box.
A missing accessor method means that the respective
component is defined in a base class and that this
accessor method is a private one.}
  global {mta::_elemKind}
  set {mta::_elemKind} {METHODS}
  global {mta::_elemScope}
  set {mta::_elemScope} {ALL}
  global {mta::currentElem}
  set {mta::currentElem} {}
  global {mta::currentType}
  set {mta::currentType} {obstBHADD@MBLGMCE@@@NI@EHCMC@AF@@@@@}
  global {mta::currentTypeTbl}
  set {mta::currentTypeTbl} {obstBHADD@MBHHEA@@@@NI@EHCMC@KD@@@@@}
  global {mta::elemKind}
  set {mta::elemKind} {METHODS}
  global {mta::elemScope}
  set {mta::elemScope} {ALL}
  global {mta::schemaDir}
  set {mta::schemaDir} {obstBHADD@MB@@HK@@@@E@AJJHH@@@D@@@@@}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(infobox_tk.tcl)} {0}
  set {autoLoadList(mtaTool_obst.tcl)} {0}
  set {autoLoadList(mtaTool_tk.tcl)} {0}
  set {autoLoadList(xfstuff.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(infobox_tk.tcl)} { infobox::displayInfo infobox::displayText .infobox}
  set {moduleList(mtaTool_obst.tcl)} { mta::selectSchema mta::selectType mta::selectElem mta::showSchemaDir mta::showEnumType mta::showExternType mta::showClassType mta::showTypedefType mta::showUnionType mta::method_signature mta::method_name mta::name}
  set {moduleList(mtaTool_tk.tcl)} {}
  set {moduleList(xfstuff.tcl)} { Alias GetSelection MenuPopupAdd MenuPopupMotion MenuPopupPost MenuPopupRelease NoFunction SN SymbolicName Unalias}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(dir::CopyCntBox)} {.top0}
  set {symbolicName(dir::ObjPathEntry)} {.top0.frame.frame3.entry5}
  set {symbolicName(dir::ObjectBox)} {.frame2.frame.listbox1}
  set {symbolicName(infobox::root)} {.infobox}
  set {symbolicName(infobox::text)} {.infobox.frame.text2}
  set {symbolicName(mta::ElemListBox)} {.frame1.frame.listbox1}
  set {symbolicName(mta::SchemaListBox)} {.frame1.frame5.frame.listbox1}
  set {symbolicName(mta::TextBox)} {.frame2.frame.text2}
  set {symbolicName(mta::TypeListBox)} {.frame1.frame5.frame6.listbox1}
  set {symbolicName(mta::ViewParamBox)} {.vpbox}
  set {symbolicName(root)} {.}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {. .vpbox}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

global xfShowWindow.infobox
set xfShowWindow.infobox 0

global xfShowWindow.vpbox
set xfShowWindow.vpbox 0

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# end source
EndSrc

# eof
#

