/* =================================================================== */
/*       CLASS - IMPLEMENTATION                                    === */
/* =================================================================== */
/*                                                                     */
/* CLASS-NAME: add_Relship                    Class_Id: REL            */
/*                                                                     */
/* IMPLEMENTATION ISSUES:                                              */
/*                                                                     */
/* =================================================================== */
#define RELATIONSHIP_CONCEPT 1

/* =================================================================== */
/* Substitution of C-symbols :                                         */
#include "predef.h"

/* =================================================================== */
/* Trace switches:                                                     */
#include "trc_add.h"

/* =================================================================== */
// Export File of this concept
#include "Relationship_obst.h"


// ---- Methods of this Class ---- //

add_Role_Set add_Relship::roles()
   //
   // PURPOSE:
   // returns a set of the contained Roles.
   // the returned set is only a copy (snapshot) of the roles contained in
   // this Relationship. The set is a buffer which will be overwritten
   // by the next execution of this method. Therefore the set
   // should be copied by the invoking method in case the
   // retrieved information should be preserved.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Relship::roles()"); TT(rel_H, T_ENTER);
  static add_Role_Set copy_of_role_set = add_Role_Set::create(TEMP_CONTAINER);
  static add_Role one_role = add_Role::create(TEMP_CONTAINER);
  static add_Role another_role = add_Role::create(TEMP_CONTAINER);

  add_Role_Set role_set = self.get_roles(); 
  if(role_set != NO_OBJECT) {
    TT(rel_H, TI( role_set.card()));
    copy_of_role_set.assign(role_set);
  }
  else
    {
      copy_of_role_set.clear();
      one_role.set_role_name(self.get_role1());
      one_role.set_related_object(self.get_obj1());
      copy_of_role_set.insert(one_role);
      another_role.set_role_name(self.get_role2());
      another_role.set_related_object(self.get_obj2());
      copy_of_role_set.insert(another_role);
    }

  TT(rel_H, T_LEAVE; TI(copy_of_role_set.card())); return (copy_of_role_set);
}


sos_Cstring add_Relship::role_name_of (add_Related_Object r)
   //
   // PURPOSE:
   // returns the role name of r in this relationship.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Relship::role_name_of (add_Related_Object r)"); TT(rel_H, T_ENTER);
  static sos_Cstring copy_of_role_name = new char [REL_MAX_NAME_LENGTH];

  sos_Cstring tmp_string;

  add_Role_Set role_set = self.get_roles();  
  if (role_set != NO_OBJECT) {
    agg_iterate( role_set, add_Role role ) 
      {
	if (role.get_related_object().identical(r)) {
	  tmp_string = role.get_role_name().make_Cstring();
	  break;
	}		
      }
    agg_iterate_end ( role_set, role );
  }
  else
    if (self.get_obj1() == r)
      tmp_string = self.get_role1().make_Cstring();
    else
      if (self.get_obj2() == r)
	tmp_string = self.get_role2().make_Cstring();
      
  strcpy(copy_of_role_name, tmp_string);
  delete tmp_string;

  TT(rel_H, T_LEAVE;  TS(copy_of_role_name)); return (copy_of_role_name);
}


Void add_Relship::change_role (sos_Cstring role_name, 
			       add_Related_Object new_object)
   //
   // PURPOSE:
   // Replaces the add_Related_Object of role a by s.
   // notifies the related objects by
   // add_Related_Object::note_lost_relship(this)
   // add_Related_Object::note_new_relship(this) and
   // add_Related_Object::note_changed_partners(this) respectively.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC("add_Relship::change_role (sos_Cstring role_name, add_Related_Object new_object)"); TT(rel_H, T_ENTER);

  sos_Cstring tmp_string;
  sos_Bool found = FALSE;

  add_Role_Set role_set = self.get_roles();  
  if (role_set != NO_OBJECT) {
    agg_iterate( role_set, add_Role role )
      {
	tmp_string = role.get_role_name().make_Cstring();
	if (streql(role_name, tmp_string) AND 
	    NOT role.get_related_object().identical(new_object))
	  {
	    role.get_related_object().get_relships().remove(self);
	    role.get_related_object().note_lost_relship(self);
	    role.set_related_object(new_object);
	    new_object.get_relships().insert(self);
	    new_object.note_new_relship(self);
	    found = TRUE;
	  }	
      }
    agg_iterate_end ( role_set, role );
    
    if(found)
      {
	agg_iterate( role_set, add_Role role )
	  {
	    tmp_string = role.get_role_name().make_Cstring();
	    if (NOT streql(role_name, tmp_string))
	      role.get_related_object().note_changed_partners(self);
	  }
	agg_iterate_end ( role_set, role );
	TT(rel_H, TXT("role changed"));
	self.clear_error();
      }
    else
      {
	self.flag_error(REL_NOT_FOUND, self.error_message(REL_NOT_FOUND));
      }
  }
  else {
    sos_Cstring role1 = self.get_role1().make_Cstring();
    if (streql(role1, role_name)) {
      self.get_obj1().get_relships().remove(self);
      self.set_obj1(new_object);
      new_object.get_relships().insert(self);
      // notifications:
      self.get_obj1().note_lost_relship(self);
      new_object.note_new_relship(self);
      self.get_obj2().note_changed_partners(self);
    }
    else {
      sos_Cstring role2 = self.get_role1().make_Cstring();
      if (streql(role2, role_name))
	{
	  self.get_obj2().get_relships().remove(self);
	  self.set_obj2(new_object);
	  new_object.get_relships().insert(self);
	  // notifications:
	  self.get_obj2().note_lost_relship(self);
	  new_object.note_new_relship(self);
	  self.get_obj1().note_changed_partners(self);
	}
      delete role2;
    }
    delete role1;
  }
  TT(rel_H, T_LEAVE); return;
}

sos_Bool add_Relship::ready_for_assignment(add_Source_of_Error source)
        // returns FALSE. A Relship can not be assigned !
{ 
  T_PROC("add_Relship::ready_for_assignment(...) // returns FALSE."); TT(rel_H, T_ENTER);
  TT(rel_H, T_LEAVE); return (FALSE);
}


sos_Cstring add_Relship::error_message(int err_value)
   //
   // PURPOSE:
   // returns the error message belonging to the error value.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
   sos_Cstring retvalue;

   T_PROC("add_Relship::error_message(int err_value)"); TT(rel_H, T_ENTER);

   switch (err_value)
   {
        case REL_NOT_FOUND:
          retvalue = " wrong role name. \n";
          break;
	default:
          retvalue = self.add_Source_of_Error::error_message(err_value);
   }

   TT(rel_H, T_LEAVE); return(retvalue);
}


Void add_Relship::local_initialize(add_Relship this_one)
   //
   // PURPOSE:
   // initialises the components of this Relship
   // and notifies the concerned objects.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   //     none
{
  T_PROC 
    ("add_Relship::local_initialize(add_Relship this_one)");
  TT(rel_H, T_ENTER);

  add_Role_Set create_parameter = this_one.get_roles();  
  if (create_parameter != NO_OBJECT) {
    add_Role_Set role_set = add_Role_Set::create(this_one.container());
    this_one.set_roles(role_set);  
    agg_iterate(create_parameter, add_Role role)
      {
	add_Related_Object obj = role.get_related_object();
	obj.get_relships().insert(this_one);
	add_Role private_role = add_Role::create(this_one.container());
	private_role.set_related_object(obj);
	private_role.set_role_name(sos_String::clone(role.get_role_name(), 
						     this_one.container()));
	role_set.insert(private_role);
      }
    agg_iterate_end (create_parameter, role);

    agg_iterate(create_parameter, add_Role role)
      role.get_related_object().note_new_relship(this_one);
    agg_iterate_end (create_parameter, role);
  }
  else
    {
      this_one.set_role1(sos_String::clone(this_one.get_role1(), this_one.container()));
      this_one.set_role2(sos_String::clone(this_one.get_role2(), this_one.container()));
      add_Related_Object obj1 = this_one.get_obj1();
      add_Related_Object obj2 = this_one.get_obj2();
      obj1.get_relships().insert(this_one);
      obj2.get_relships().insert(this_one);
      
      obj1.note_new_relship(this_one);
      obj2.note_new_relship(this_one);
    }
/*
    {
      add_Related_Object obj1 = this_one.get_obj1();
      add_Related_Object obj2 = this_one.get_obj2();

      add_Role private_role1 = add_Role::create(cnt);
      private_role1.set_related_object(obj1);
      obj1.get_relships().insert(new_relship);
      private_role1.set_role_name(sos_String::clone(this_one.get_role1(), cnt));
      role_set.insert(private_role1);
      
      add_Role private_role2 = add_Role::create(cnt);
      private_role2.set_related_object(obj2);
      obj2.get_relships().insert(new_relship);
      private_role2.set_role_name(sos_String::clone(this_one.get_role2(), cnt));
      role_set.insert(private_role2);
      
      obj1.note_new_relship(new_relship);
      obj2.note_new_relship(new_relship);
    }
*/
  TT(rel_H, T_LEAVE); return;
} 

/*
Void add_Relship::make_binary_relship(sos_String role1, add_Related_Object obj1,
				      sos_String role2, add_Related_Object obj2)
   //
   // PURPOSE:
   // makes this object a binary Relationship
   // and notifies the concerned objects.
   // PRECONDITION:                                           
   // this object is created by 
   // add_Relship::create(cnt, add_Role_Set::make(NO_OBJECT));
   //                                                         
{
  T_PROC ("add_Relship::create(cnt, role1, obj1, role2, obj2)");
  TT(rel_H, T_ENTER);

  add_Relship new_relship = add_Relship::create(cnt, add_Role_Set::make(NO_OBJECT));
  add_Role_Set role_set   = new_relship.set_roles(role_set);  

  TT(rel_H, T_LEAVE); return;
} 
*/

Void add_Relship::total_assign(add_Relship this_one, sos_Object )
   //
   // PURPOSE:
   //     does nothing
   //                                                         
   // PRECONDITION:                                           
   //                                                         
   // POSTCONDITION, ERRORS:                                  
{
  T_PROC("add_Relship::total_assign(...) // DOES NOTHING"); TT(rel_H, T_ENTER);

  cerr << "assignment of relationships is not permitted\n";
  
  TT(rel_H, T_LEAVE); return;
} 


Void add_Relship::local_finalize(add_Relship this_one)
   //
   // PURPOSE:
   //     removes the reference in the name space
   //     which points to this object.
   //                                                         
   // PRECONDITION:                                           
   //                                                         
   // POSTCONDITION, ERRORS:                                  
{
  T_PROC("add_Relship::local_finalize(this_one)"); TT(rel_H, T_ENTER);

  add_Role_Set role_set = this_one.get_roles();  
  if (role_set != NO_OBJECT) {
    agg_iterate( role_set, add_Role role )
      {
	role.get_related_object().get_relships().remove(this_one);
	role.get_related_object().note_lost_relship(this_one);
	role.destroy();
      }
    agg_iterate_end ( role_set, role );
    role_set.destroy();
  }
  else {
    this_one.get_obj1().get_relships().remove(this_one);
    this_one.get_obj2().get_relships().remove(this_one);
    this_one.get_obj1().note_lost_relship(this_one);
    this_one.get_obj2().note_lost_relship(this_one);
    this_one.get_role1().destroy();
    this_one.get_role2().destroy();
  }

  TT(rel_H, T_LEAVE); return;
} 


