/* =================================================================== */
/*       CLASS - IMPLEMENTATION                                    === */
/* =================================================================== */
/*                                                                     */
/* CLASS-NAME: add_File_Store                     Class_Id: FSTORE     */
/*                                                                     */
/* IMPLEMENTATION ISSUES:                                              */
/* ::store()
  if (access(unix_pathname, R_OK) == -1)    // necessary ????
  struct stat buf;
  int stat_result = stat(unix_pathname, &buf);  
*/
/*                                                                     */
/* =================================================================== */
#define CONTENTS_CONCEPT 1

#include <sys/file.h>   
/* =================================================================== */
/* Substitution of C-symbols :                                         */
#include "predef.h"
#include <sys/fcntlcom.h>
#include <sys/types.h>
#include <sys/stat.h>

/* =================================================================== */
/* Trace switches:                                        */
#include "trc_add.h"

#include <Transaction_ext.h>

/* =================================================================== */
// Export File of this concept
#include "Contents_obst.h"

#include <sys/param.h>

#include <addd_proto.h>

add_Contents_Id returned_contents_id = add_Contents_Id::create(TEMP_CONTAINER);
add_Contents    returned_contents = add_Contents::create(TEMP_CONTAINER);


// ---- Public Methods of this Class ---- //

sos_Cstring add_File_Store::description()
   //
   // PURPOSE:                                                
   // returns a description of this object.
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
{
  T_PROC ("add_File_Store::description()"); TT(file_H, T_ENTER);

  sos_Cstring retvalue;

  sos_Cstring tmp1 = strnew("", "directory: \n");
  sos_Cstring tmp2 = self.get_unix_directory().make_Cstring();
  sos_Cstring tmp3 = strnew(tmp1, tmp2);
  sos_Cstring tmp4 = strnew(tmp3, "counter: \n");
  char tmp5[4];
  sprintf(tmp5, "%d", self.get_counter());
  sos_Cstring tmp6 = strnew(tmp4, tmp5);

  delete tmp1;
  delete tmp2;
  delete tmp3;
  delete tmp4;
  retvalue = tmp6;
  
  TT(file_H, T_LEAVE); return (retvalue);
}


// ---- Protected Methods of this Class ---- //


add_Contents_Id add_File_Store::store(add_Contents c,
                                    int storage_mode,
                                    add_Contents_Id nearby)
   //
   // PURPOSE:                                                
   // copies the file denoted by the unix pathname c
   // into the private directory and returnes the new generated pathname
   // of this copy.
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
   // FSTORE_NO_VALID_CONTENTS in case a file with pathname c does not
   // exist or is not readable.
{
  T_PROC ("add_File_Store::store(add_Contents c, int storage_mode, add_Contents_Id nearby ");
  TT(file_H, T_ENTER);

  char command [ADDD_MAX_COMMAND_LINE];
  sos_Cstring unix_pathname = c.make_Cstring();
//  sprintf(command, "test -r %s", unix_pathname);
//  TT(file_H, TS( command));
//  int retvalue = add_system_Cstring(command);
//  TT(file_H, TI( retvalue));
//  if (retvalue != 0)

  TT(file_H, 
     if (access(unix_pathname, R_OK) == -1) {
       self.flag_error(FSTORE_NO_VALID_CONTENTS, 
		       self.error_message(FSTORE_NO_VALID_CONTENTS));
       returned_contents_id.assign_Cstring("_");    
       T_LEAVE; return (returned_contents_id);
     }
     );

  // generates new file_name in private directory
  // and copies the new contents into this file.
  sos_Cstring directory = self.get_unix_directory().make_Cstring();
  int counter = self.get_counter() + 1;
  self.set_counter(counter);
  
  struct stat buf;
  int stat_result = stat(unix_pathname, &buf);
  if(S_ISDIR(buf.st_mode)) {
    char copy [400];
    strcpy (copy, unix_pathname);
    int length_minus_one = strlen(copy)-1;
    char* copy_tail = copy+length_minus_one;
    for (int i=0;i<length_minus_one;i++) {
      if (*copy_tail == '/') {
	break;
      }
      copy_tail--;
    }
    char* dir_name = copy_tail+1;

    sprintf(command, "rm -f %s/%d; cd %s/..; tar xf %s/%d.d %s; chmod a-w %s/%d", 
	    directory, counter, 
	    unix_pathname, 
	    directory, counter, dir_name, 
	    directory, counter);
    TT(file_H, TS( command));
    int retvalue = add_system_Cstring(command);
    TT(file_H, TI( retvalue));
    if (retvalue != 0) {
       self.flag_error(FSTORE_NO_VALID_CONTENTS, 
		       self.error_message(FSTORE_NO_VALID_CONTENTS));
       returned_contents_id.assign_Cstring("_");    
       TT(file_H, T_LEAVE); return (returned_contents_id);
     }
    returned_contents_id.assign_Cstring(form("%d.d", counter));
  }
  else {
    sprintf(command, "rm -f %s/%d; cp -p %s %s/%d; chmod a-w %s/%d", 
	    directory, counter, unix_pathname, directory, counter, directory, counter);
    TT(file_H, TS( command));
    int retvalue = add_system_Cstring(command);
    TT(file_H, TI( retvalue));
    if (retvalue != 0) {
       self.flag_error(FSTORE_NO_VALID_CONTENTS, 
		       self.error_message(FSTORE_NO_VALID_CONTENTS));
       returned_contents_id.assign_Cstring("_");    
       TT(file_H, T_LEAVE); return (returned_contents_id);
     }
    sprintf(command, "%d", counter);
    returned_contents_id.assign_Cstring(command);
  }
  delete directory;
  delete unix_pathname;
  TT(file_H, T_LEAVE; TS( command));return (returned_contents_id);
}


add_Contents add_File_Store::retrieve (add_Contents_Id id, int access_mode)
   //
   // PURPOSE:                                                
   // returns a copy the file denoted by id.
   // 
   // PRECONDITION:                                           
   // 
   // POSTCONDITION, ERRORS:                                  
   // FSTORE_NO_VALID_CONTENTS in case a file with pathname 
   // self.get_unix_directory()/id does not exist or is not readable.
{
  T_PROC("add_File_Store::retrieve (add_Contents_Id id, int access_mode)"); TT(file_H, T_ENTER);

  char command [ADDD_MAX_COMMAND_LINE];
  sos_Cstring name = id.make_Cstring();
  sos_Cstring directory = self.get_unix_directory().make_Cstring();
  TT(file_H, 
     sprintf(command, "%s/%s", directory, name);
     if (access(command, R_OK) == -1)
     self.flag_error(FSTORE_NO_VALID_CONTENTS, self.error_message(FSTORE_NO_VALID_CONTENTS));
     );

  // generates a file_name in /tmp
  // and copies the contents into this file.
  // create log file
  char buf[MAXPATHLEN];
  static int unique = 0;
  strcpy(buf, form("/tmp/ADD_%d_out_XXXXXX", unique++));
  char* checked_out_file = mktemp(buf);
  returned_contents.assign_Cstring(checked_out_file);

  int retvalue;
  if(name[strlen(name)-1] == 'd') {
      sprintf(command, "tar -xf %s/%s %s", directory, name, checked_out_file);    
  }
  else {
    if (access_mode == SO_ACCESS_READ)
      sprintf(command, "ln -s %s/%s %s;", 
	      directory, name, checked_out_file, checked_out_file);
    else
      sprintf(command, "cp -p %s/%s %s; chmod a+w %s", 
	      directory, name, checked_out_file, 
	      checked_out_file);
  }    
  TT(file_H, TS( command));
  retvalue = add_system_Cstring(command);
  TT(file_H, TI( retvalue));
  delete directory;
  delete name;
  if (retvalue != 0)
     { TT(file_H, T_LEAVE); return (CO_NO_CONTENTS); }
  else
     { TT(file_H, T_LEAVE); return (returned_contents); }
}


Void add_File_Store::remove(add_Contents_Id id)
   //
   // PURPOSE:                                                
   // removes the denoted contents.
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
   // FSTORE_NO_VALID_CONTENTS in case a file with this pathname does not
   // exist or can not be removed.
{
  T_PROC ("add_File_Store::remove(add_Contents_Id to_be_removed)"); TT(file_H, T_ENTER);

  char command [ADDD_MAX_COMMAND_LINE];

  sos_Cstring name = id.make_Cstring();
  sos_Cstring directory = self.get_unix_directory().make_Cstring();
  sprintf(command, "rm -f %s/%s", directory, name);
//  sprintf(command, "rm -f %s/%s.tar", directory, name);
  TT(file_H, TS( command));
  int retvalue = add_system_Cstring(command);
  TT(file_H, TI( retvalue));
  if (retvalue != 0)
    self.flag_error(FSTORE_NO_VALID_CONTENTS, 
		    self.error_message(FSTORE_NO_VALID_CONTENTS));
  
  delete directory;
  delete name;

  TT(file_H, T_LEAVE); return;
}


add_Contents_Id add_File_Store::copy_of(add_Contents_Id id)
   //
   // PURPOSE:                                                
   // copies the file denoted by id, stores this copy
   // into the private directory and returnes the new generated id
   // of this copy.
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
   // FSTORE_NO_VALID_CONTENTS in case a file with pathname c does not
   // exist or is not readable.
{
  T_PROC ("add_File_Store::copy_of(add_Contents_Id id)"); TT(file_H, T_ENTER);
  char command [ADDD_MAX_COMMAND_LINE];

  sos_Cstring name = id.make_Cstring();
  sos_Cstring directory = self.get_unix_directory().make_Cstring();
  TT(file_H, 
     sprintf(command, "%s/%s", directory, name);
     //  sprintf(command, "%s/%s.tar", directory, name);
     if (access(command, R_OK) == -1)
     self.flag_error(FSTORE_NO_VALID_CONTENTS, 
		     self.error_message(FSTORE_NO_VALID_CONTENTS));
     );

  // generates new file_name in private directory
  // and copies the contents into this file.
  int counter = self.get_counter() + 1;
  self.set_counter(counter);
  if (name[strlen(name)-1] == 'd')
    sprintf(command, "cp -p %s/%s %s/%d.d", directory, name, directory, counter);
  else
    sprintf(command, "cp -p %s/%s %s/%d", directory, name, directory, counter);
//  sprintf(command, "tar xf %s/%s.tar", directory, name);
  TT(file_H, TS( command));
  int retvalue = add_system_Cstring(command);
  TT(file_H, TI( retvalue));
/*  sprintf(command, "mv %s/%s %s/%d", directory, name, directory, counter);
  TT(file_H, TS( command));
  retvalue = add_system_Cstring(command);
  TT(file_H, TI( retvalue));
*/
  if (retvalue != 0)
    self.flag_error(ERR_INCONSISTENT, self.error_message(ERR_INCONSISTENT));
/*  sprintf(command, "tar cf %s/%d.tar %s/%d", directory, counter, 
	  directory, counter);
  TT(file_H, TS( command));
  retvalue = add_system_Cstring(command);
  TT(file_H, TI( retvalue));
*/  
  delete directory;
  delete name;

  sprintf(command, "%d", counter);
  returned_contents_id.assign_Cstring(command);

  TT(file_H, T_LEAVE; TS( command)); return (returned_contents_id);
}


Void add_File_Store::local_initialize (add_File_Store this_one)
   //
   // PURPOSE:                                                
   // stores the contents.
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
   // none
{
  T_PROC ("add_File_Store::local_initialize (add_File_Store this_one)"); TT(file_H, T_ENTER);

  sos_String create_parameter = this_one.get_unix_directory();
  sos_String dir = sos_String::create(this_one.container());
  this_one.set_unix_directory(dir);
  dir.assign(create_parameter);

  sos_Cstring directory = dir.make_Cstring();
  TT(file_H, TS( directory));

  sos_Cstring rm = strnew("rm -rf ", directory);
  TT(file_H, TS( rm));
  int retvalue = add_system_Cstring(rm);
  TT(file_H, TI( retvalue));
  sos_Cstring mkdir = strnew("mkdir ", directory);
  TT(file_H, TS( mkdir));
  retvalue = add_system_Cstring(mkdir);
  TT(file_H, TI( retvalue));

  if (retvalue != 0)
    this_one.flag_error(ERR_INCONSISTENT, 
			this_one.error_message(ERR_INCONSISTENT));
  
  delete directory;
  delete rm;
  delete mkdir;

  TT(file_H, T_LEAVE); return;
}


Void add_File_Store::local_finalize(add_File_Store this_one)
   //
   // PURPOSE: 
   // removes this directory
   //                                                         
   // PRECONDITION:                                           
   //
   // POSTCONDITION, ERRORS:                                  
   // 		none
   //     
{
  T_PROC("add_File_Store::local_finalize(add_File_Store this_one)"); TT(file_H, T_ENTER);

  sos_Cstring directory = this_one.get_unix_directory().make_Cstring();
  TT(file_H, TS( directory));

  sos_Cstring rm = strnew("rm -rf ", directory);
  int retvalue = add_system_Cstring(rm);
  TT(file_H, TI( retvalue));

  this_one.get_unix_directory().destroy();

  TT(file_H, T_LEAVE); return;
}

      
Void add_File_Store::local_assign(add_File_Store destination, sos_Object source_obj)
   //
   // PURPOSE:                                                
   // copies all files
   //                             // not jet implemented. //
   // PRECONDITION:                      
   //
   // POSTCONDITION, ERRORS:                                  
   // 		none
   //     
{
  T_PROC("add_File_Store::local_assign(add_File_Store destination, sos_Object source_obj)"); TT(file_H, T_ENTER);

  add_File_Store source = add_File_Store::make(source_obj);

// not jet implemented.

  TT(file_H, T_LEAVE); return;
}


sos_Cstring add_File_Store::error_message(int err_value)
   //
   // PURPOSE:
   // returns the error message belonging to the error value.
   //                                                         
   // PRECONDITION:                                           
   //     none
   //                                                         
   // POSTCONDITION, ERRORS:                                  
   // If no message is found this method returns
   // "!! unexpected error: err_value"
{
   sos_Cstring retvalue;

   T_PROC(" add_File_Store::error_message(int err_value)"); 
   TT(file_H, T_ENTER; TI( err_value));

   switch (err_value)
   {
        case FSTORE_NO_VALID_CONTENTS:
          retvalue = " file store: file not accessable !!\n";
          break;
	default:
          retvalue = self.add_Source_of_Error::error_message(err_value);
   }

   TT(file_H, T_LEAVE); return(retvalue);
}     
  
