/* =================================================================== */
/*       CLASS - IMPLEMENTATION                                    === */
/* =================================================================== */
/*                                                                     */
/* CLASS-NAME: add_Container_Object               Class_Id: CO         */
/*                                                                     */
/* IMPLEMENTATION ISSUES:                                              */
/*                                                                     */
/* =================================================================== */
#define CONTENTS_CONCEPT 1
   
/* =================================================================== */
/* Substitution of C-symbols :                                         */
#include "predef.h"

/* =================================================================== */
/* Trace switches:                                                     */
#include "trc_add.h"

/* =================================================================== */
// Export File of this concept
#include "Contents_obst.h"

const add_Container_Object CO_NO_CO = add_Container_Object::make(NO_OBJECT);
const int CO_NO_MODE = 0;

// ---- Public Methods of this Class ---- //


add_Contents add_Container_Object::open (int access_mode)
   //
   // PURPOSE:                                                
   // returns the contents of this object.
   // 
   // PRECONDITION:                                           
   // 
   // POSTCONDITION, ERRORS:                                  
{
  T_PROC ("add_Container_Object::open(int access_mode)"); TT(cont_H, T_ENTER);

  add_Contents copy_of_contents;
  add_Contents_Id contents_id = self.get_contents_ref();
  if (NOT contents_id.identical(CO_NO_CONTENTS_ID))
    {
      copy_of_contents = 
	self.store().retrieve(contents_id, access_mode);
      if (NOT self.store().method_successfull())
	self.flag_error(self.store().error_state(),
			self.store().latest_error_message());
    }
  else
    copy_of_contents = CO_NO_CONTENTS;

  TT(cont_H, T_LEAVE); return (copy_of_contents);
}


Void add_Container_Object::close (add_Contents c, int storage_mode, 
				  add_Container_Object neighbour)
   //
   // PURPOSE:                                                
   // stores the contents into this object next to neighbour.
   // 
   // PRECONDITION:                                           
   // 
   // POSTCONDITION, ERRORS:                                  
{
  T_PROC ("add_Container_Object::close (add_Contents c, int storage_mode, add_Container_Object neighbour = CO_NO_CO)"); TT(cont_H, T_ENTER);

  add_Contents_Id old_contents = self.get_contents_ref();
  
  if(c == CO_NO_CONTENTS)
    {
      self.set_contents_ref(CO_NO_CONTENTS_ID);
      self.set_neighbour(CO_NO_CO);
      self.set_storage_mode(CO_NO_MODE);
    }
  else
    {
      add_Contents_Id nearby;
      add_Container_Object new_neighb;
      if (neighbour == CO_NO_CO)
	  {
	      add_Container_Object my_neighb = self.get_neighbour(); 
	      if (my_neighb == CO_NO_CO)
		  {
		      nearby = CO_NO_CONTENTS_ID;
		      new_neighb = CO_NO_CO;
		  }
	      else
		  {
		      nearby = my_neighb.get_contents_ref();
		      new_neighb = my_neighb;
		  }
	  }
      else
	  {
	      nearby = neighbour.get_contents_ref();
	      new_neighb = neighbour;
	  }

      // store the new contents 
      add_Store tmp_store = self.store();
      add_Contents_Id tmp_cid = 
	  tmp_store.store( c, storage_mode, nearby);
      self.set_contents_ref(add_Contents_Id::clone(tmp_cid, self.container()));
      
      if (NOT self.store().method_successfull())
	{  
	  self.set_contents_ref(old_contents);
	  self.flag_error(self.store().error_state(),
			  self.store().latest_error_message());
	}
      else
	{
	  if (NOT old_contents.identical(CO_NO_CONTENTS_ID))
	    self.store().remove(old_contents);
	  self.set_neighbour(new_neighb);
	  self.set_storage_mode(storage_mode);
	}
    }

  TT(cont_H, T_LEAVE); return;
}

sos_Cstring add_Container_Object::checkout(sos_Cstring location, int access_mode)
   //
   // PURPOSE:                                                
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
{
  T_PROC ("add_Container_Object::checkout(sos_Cstring location, int access_mode)");
  TT(cont_H, T_ENTER);

  sos_Cstring result = "";

  // ---- Buffer used to pass values to the application ---- //
  static char returned_file_name[400];

  add_Contents tmp_sos_string = self.open(access_mode);
  if (self.method_successfull() && (tmp_sos_string != NO_OBJECT)) {
    sos_Cstring tmp_file = tmp_sos_string.make_Cstring();
    strcpy(returned_file_name, tmp_file);
    result = returned_file_name;
    delete tmp_file;
  }

  TT(cont_H, T_LEAVE);
  return result;
}

sos_Bool add_Container_Object::store_isa(sos_Type t)
{ 
  add_Store my_store = self.store();
  if (my_store == NO_OBJECT)
    return FALSE;
  else
    return my_store.isa(t);
}

sos_Cstring add_Container_Object::description()
   //
   // PURPOSE:                                                
   // returns a description of this object.
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
{
  T_PROC ("add_Container_Object::description()"); TT(cont_H, T_ENTER);

  sos_Cstring retvalue;

  if(FALSE) //  (self.get_contents_ref() != CO_NO_CONTENTS_ID))
    {
      sos_Cstring tmp1 = self.store().description();
      sos_Cstring tmp2 = strnew(tmp1, "  store: \n");
      sos_Cstring tmp3 = strnew(tmp2, tmp1);

      sos_Cstring tmp4 = strnew(tmp3, "  contents_ref: \n");
      sos_Cstring tmp5 = self.get_contents_ref().make_Cstring();
      sos_Cstring tmp6 = strnew(tmp4, tmp5);

      delete tmp1;
      delete tmp2;
      delete tmp3;
      delete tmp4;
      delete tmp5;
      retvalue = tmp6;
    }
  else
    retvalue = strnew("","");

  TT(cont_H, T_LEAVE); return (retvalue);
}


add_Store add_Container_Object::store()
   //
   // PURPOSE:                                                
   // returns the store where the contents of this object is stored.
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
   // none
{
  T_PROC ("add_Container_Object::store()"); TT(cont_H, T_ENTER);

  TT(cont_H, T_LEAVE); return (add_Store::make(NO_OBJECT));
}


Void add_Container_Object::local_initialize (add_Container_Object this_one)
   //
   // PURPOSE:                                                
   // stores the contents.
   // 
   // PRECONDITION:       
   // 
   // POSTCONDITION, ERRORS: 
   // none
{
  T_PROC ("add_Container_Object::local_initialize (add_Container_Object t)"); TT(cont_H, T_ENTER);

  add_Contents contents;
  add_Contents create_parameter = this_one.get_create_parameter();
  if(create_parameter==NO_OBJECT)
      contents = CO_NO_CONTENTS;
  else {
      contents = add_Contents::create(this_one.container());
      this_one.set_create_parameter(contents);
      contents.assign(create_parameter);
  }
  if (contents.identical(CO_NO_CONTENTS))
    {
      this_one.set_contents_ref(CO_NO_CONTENTS_ID);
      this_one.set_neighbour(CO_NO_CO);
      this_one.set_storage_mode(CO_NO_MODE);
    }
  else
    {
      add_Contents_Id cont_ref_of_neighb;
      if (this_one.get_neighbour() == CO_NO_CO)
	  cont_ref_of_neighb = CO_NO_CONTENTS_ID;
      else
	  cont_ref_of_neighb = this_one.get_neighbour().get_contents_ref();

      add_Contents_Id new_id = this_one.store().store(contents, 
				   this_one.get_storage_mode(),
			           cont_ref_of_neighb );
      if (NOT this_one.store().method_successfull())
	{
	  this_one.set_contents_ref(CO_NO_CONTENTS_ID);
	  this_one.flag_error(ERR_INCONSISTENT, 
			      this_one.error_message(ERR_INCONSISTENT));
	}
      else
	  this_one.set_contents_ref(
		  add_Contents_Id::clone(new_id, this_one.container()));
  }

  TT(cont_H, T_LEAVE); return;
}


Void add_Container_Object::local_finalize(add_Container_Object this_one)
   //
   // PURPOSE: 
   // destroys this object and its contents.
   //                                                         
   // PRECONDITION:                                           
   //
   // POSTCONDITION, ERRORS:                                  
   // 		none
   //     
{
  T_PROC("add_Container_Object::local_finalize(add_Container_Object this_one)"); TT(cont_H, T_ENTER);

  add_Contents_Id contents_id = this_one.get_contents_ref();
  if (NOT contents_id.identical(CO_NO_CONTENTS_ID))
    {
      this_one.store().remove(contents_id);
      contents_id.destroy();

      if (NOT this_one.store().method_successfull())
	this_one.flag_error(this_one.store().error_state(),
			    this_one.store().latest_error_message());
    }
  if (this_one.get_create_parameter() != NO_OBJECT)
      this_one.get_create_parameter().destroy();
  TT(cont_H, T_LEAVE); return;
}

      
Void add_Container_Object::local_assign(add_Container_Object destination, 
					sos_Object source_obj)
   //
   // PURPOSE:                                                
   // assigns a copy of the contents.
   //                                                         
   // PRECONDITION:                      
   //
   // POSTCONDITION, ERRORS:                                  
   // 		none
   //     
{
  T_PROC("add_Container_Object::local_assign(add_Container_Object source, sos_Object dest)"); TT(cont_H, T_ENTER);

  add_Container_Object source = add_Container_Object::make(source_obj);

  add_Contents_Id contents_id = source.get_contents_ref();
  if (NOT contents_id.identical(CO_NO_CONTENTS_ID))
    {
      add_Contents_Id d_id = destination.get_contents_ref();
      if(d_id.identical(CO_NO_CONTENTS_ID))
	  {
	      d_id = add_Contents_Id::create(TEMP_CONTAINER);
	      destination.set_contents_ref(d_id);
	  }
      d_id.assign(source.store().copy_of(source.get_contents_ref()));
      destination.set_neighbour(source.get_neighbour());
    }
  else
    {
      contents_id = destination.get_contents_ref();
      if (NOT contents_id.identical(CO_NO_CONTENTS_ID))
	{	
	  contents_id.destroy();
	  destination.set_contents_ref(CO_NO_CONTENTS_ID);
	}
    }

  TT(cont_H, T_LEAVE); return;
}

//----- add_Store ------------------------------------------------------

add_Contents_Id add_Store::store (add_Contents c, 
				    int storage_mode,
				    add_Contents_Id nearby)
{add_Contents_Id x; return x;}

add_Contents add_Store::retrieve (add_Contents_Id id, int access_mode)
		// retrieves a contents by its id.
{add_Contents x; return x;}

Void add_Store::remove (add_Contents_Id id)
{return;}

add_Contents_Id add_Store::copy_of (add_Contents_Id id)
		// returns an id of the new created copy.
{add_Contents_Id x; return x;}
