# --------------------------------------------------------------------------
# Copyright 1994 by Forschungszentrum Informatik (FZI)
#
# You can use and distribute this software under the terms of the license
# version 1 you should have received along with this software.
# If not or if you want additional information, write to
# Forschungszentrum Informatik, "OBST Projekt", Haid-und-Neu-Strasse 10-14,
# D-76131 Karlsruhe, Germany.
# --------------------------------------------------------------------------
###############################################################################
# Module :	main
# Authors:	Rainer Neumann, Bernhard Schiefer, Christian Popp
# Date   :	Mai 9, 1994
###############################################################################
# Description
# 
###############################################################################

proc build_up_name {namedtype} {
  set ergebniss ""
  if {[OBST has_type $namedtype sos_Class_type]} {
    if {[mcall $namedtype is_generic_class] == "TRUE"} {
      set gen_list [mcall $namedtype get_formal_gen_params]
      set name [[mcall $namedtype get_name] make_Cstring]
      set length  [agg card $gen_list]
      set index 1
      agg loop $gen_list {
	set ergebniss "$ergebniss [[[agg current] get_name] make_Cstring]"
        if { $index < $length } {set ergebniss "$ergebniss,"}
        if { $index == 1 } {set ergebniss [crange $ergebniss 1 end]}
        incr index
        }
      set ergebniss "$name <$ergebniss>"
      } elseif {[mcall $namedtype is_instantiation] == "TRUE"} {
      set gen_list [mcall $namedtype get_actual_gen_params]
      set gen_class [mcall $namedtype get_generic_class]
      set name [[mcall $gen_class get_name] make_Cstring]
      set length  [agg card $gen_list]
      set index 1
      agg loop $gen_list {
        set ergebniss "$ergebniss [build_up_name [agg current]]"
        if { $index < $length } {set ergebniss "$ergebniss,"}
        if { $index == 1 } {set ergebniss [crange $ergebniss 1 end]}
        incr index
        }
      set ergebniss "$name <$ergebniss>"
      } else {
         set ergebniss "[[mcall $namedtype get_name] make_Cstring]"
      }
    } elseif {[OBST has_type $namedtype sos_Generic_instantiation]} {
      set gen_list [mcall $namedtype get_act_gen_params]
      set gen_class [mcall $namedtype get_gen_class]
      set name [[mcall $gen_class get_name] make_Cstring]
      set length  [agg card $gen_list]
      set index 1
      agg loop $gen_list {
        set ergebniss "$ergebniss [build_up_name [agg current]]"
        if { $index < $length } {set ergebniss "$ergebniss,"}
        if { $index == 1 } {set ergebniss [crange $ergebniss 1 end]}
        incr index
      }
      set ergebniss "$name <$ergebniss>"
    } else {
     set ergebniss "[[mcall $namedtype get_name] make_Cstring]"
  }
return $ergebniss
}


proc handle_error { return_val_ref method { error_text "Error:" } } {
  upvar $return_val_ref return_val

  if { [catch "mcall $method" return_val] } {
     showmessage "$error_text $return_val"
     return 1
  }
  return 0
}

proc handle_name_error { name } {
  if {$name == ""} {
    showmessage "ERROR : You must specify a correct name"
    return 1
  } else {
    return 0
  }
}

proc handle_type_error { return_val_ref return_type_ref \
			 typename } {
  upvar $return_val_ref return_val
  upvar $return_type_ref return_type
  if {$typename == ""} {
    showmessage "ERROR : You must specify a type"
    return 1
  }
  set type [OBST tmpstr $typename]
  if { [catch {set return_type [mcall sos_Schema_module::type_from_name $type]} return_val] } {
     showmessage "ERROR: $return_val"
     $type destroy
     return 1
  }
  $type destroy
  if {$return_type == [OBST const NO_OBJECT]} {
    showmessage "ERROR: Unknown type : $typename"
    return 1
  } else {
  return 0
  }
}


proc convert_2_sos_Expr {to_convert} {
# wandelt einen tcl-string in ein sos_Expr um, sos_Int_expr oder 
# sos_Identifier.
# Leerstring ergibt NO_OBJECT

  if {$to_convert == ""} {
     set expr [OBST const NO_OBJECT]
  } else {
# fehlerabfrage ob to_convert integer oder expression ist
    if {[catch {expr {$to_convert + 0}}]} {
      set expr [mcall sos_Identifier::create [OBST const TEMP_CONTAINER] [OBST tmpstr $to_convert] ]
    } else {
      set expr [mcall sos_Int_expr::create [OBST const TEMP_CONTAINER] $to_convert]
    }
  }
  return $expr
}


puts stdout "Starting USE * The OBST Support Environment for Schema Evolution * ..."

if { [catch {set env(OBSTCONTAINER)}] } {
  puts stdout "Sorry, there is no OBST Containerdirectory"
  destroy .
  exit
}

if { ! [file exists $env(OBSTCONTAINER)/.OBST_Browser] } {
  puts stdout "creating resource directory $env(OBSTCONTAINER)/.OBST_Browser"
  mkdir $env(OBSTCONTAINER)/.OBST_Browser
} else {
  if { ! [file isdirectory $env(OBSTCONTAINER)/.OBST_Browser] } {
    error "Cannot create the resource directory $env(OBSTCONTAINER)/.OBST_Browser"
  }
}

global OBST_code_path ; set OBST_code_path $env(USE_CODE_PATH)
global OBST_brd_path ; set OBST_brd_path "$env(OBSTCONTAINER)/.OBST_Browser"

  source $env(OK_KNL_PATH)/ObjectKernel.tcl
  source $env(OK_KNL_PATH)/arrows.tcl

  ok_include Kernel/Snapshot.ok

if { [file exists  $env(USE_SNAPSHOT_PATH)/USE_compiled.ok$env(OKS_COMPRESS_SUFFIX)] } {
  ok_include USE/OBST_Classeditorcolors.ok 
  ok_include USE/OBST_Nodecolors.ok
  ok_include USE/OBST_Importmodecolors.ok
  oks_load_snapshot $env(USE_SNAPSHOT_PATH)/USE_compiled.ok
} else {
  set ok_syntax 1.00 
  set OBST_edited 0

  set DoubleClickTime 500
  set tmp_CV_mouseAction ""
  set tmp_CV_mousePosX 0
  set tmp_CV_mousePosY 0
  set tmp_CV_inTime 0

  set ok_objectcheck 0

  ok_include Kernel/Tools.ok

  ok_include USE/OBST_BrowserClasses.ok

  ok_variable \    OBST_edited \
    DoubleClickTime \
    tmp_CV_mouseAction \
    tmp_CV_mousePosX \
    tmp_CV_mousePosY \
    tmp_CV_inTime

  # create "quick"-file
puts stdout "creating quick startup for USE ..."
oks_create_snapshot  $env(USE_SNAPSHOT_PATH)/USE_compiled.ok
}

ok_short_ids

tclOBST bind
tclOBST customize copy_Cstrings false

bind Entry <Return> {;}

# Interpreter Kommunikation abschalten
# bei Auslieferung mit rein nehmen !!!!
rename send "" 

set browser NULL
set helpview [HelpWidget::create]

proc exit_USE {} {
  ThreeButtonBox Exit "How do you want to exit ?" "   Save and Exit   " " Quit without save " "      Cancel     " "shutdown_commit" "shutdown_leave" ""
}

proc shutdown_leave {} {
    sleep 1
  destroy .
  exit
}

proc shutdown_commit {} {
  global browser
  if { $browser != "NULL" } {
    $browser commit 0
    $browser destroy
  }
  set filename "~/.OBST-Schemabrowser.Defaults"
  set f [open $filename w]
  showmessage "storing options ..."
  writeGlobalVars $f
  showmessage "... done"
  showmessage "storing window positions ..."
  writeWindowPositions $f
  showmessage "... done"
  showmessage "storing color-table ..."
  writeColorTable $f
  showmessage "... done"
  close $f
  sleep 1
  destroy .
  exit
}

proc open_views_browser {} {
  showmessage "not yet implemented"
}

proc open_schema_browser {} {
  global browser helpview
  if { $browser == "NULL" } {
    set browser [OBST_Schemabrowser::create {} $helpview] 
  }   
  $browser show
}

proc edit_options {} {
  global DoubleClickTime OBST_code_path 
  global tmpDCT tmpCODE
  set tmpDCT $DoubleClickTime
  set tmpCODE $OBST_code_path

  toplevel .tl
  wm title .tl {Options}
  wm protocol .tl WM_DELETE_WINDOW "destroy .tl"
  label .tl.lb -text {Configure options ...} -height 2
  pack append .tl .tl.lb {top fillx}
  frame .tl.ef
  pack append .tl .tl.ef {top fill}
  frame .tl.ef.l
  pack append .tl.ef .tl.ef.l {left filly}
  label .tl.ef.l.lb1 -text "Double-Click-Interval"
  label .tl.ef.l.lb2 -text "Code generation path  "
  pack append .tl.ef.l \
	.tl.ef.l.lb1 {top padx 10 pady 5} \
	.tl.ef.l.lb2 {top padx 10 pady 5} 
  frame .tl.ef.e
  pack append .tl.ef .tl.ef.e {left filly}

  entry .tl.ef.e.en1 -text tmpDCT -relief flat -width 5

  frame .tl.ef.e.en2
  entry .tl.ef.e.en2.entry -text tmpCODE -relief sunken -width 40 \
      -scroll ".tl.ef.e.en2.scroll set"
  scrollbar .tl.ef.e.en2.scroll -relief sunken \
      -orient horiz -command ".tl.ef.e.en2.entry view" -width 10
  pack append .tl.ef.e.en2 \
      .tl.ef.e.en2.entry {top} \
      .tl.ef.e.en2.scroll {top fillx}

  pack append .tl.ef.e \
	.tl.ef.e.en1 {top pady 5 padx 10} \
	.tl.ef.e.en2 {top pady 5 padx 10}

  frame .tl.bf
  pack append .tl .tl.bf {bottom fillx}
  button .tl.bf.b_ok     -text {   ok   } -command {edit_options_ok} -width 10 -relief raised
  button .tl.bf.b_cancel -text { cancel } -command {destroy .tl} -width 10 \
   -relief raised
  pack append .tl.bf \
	.tl.bf.b_ok     {left  expand padx 20 pady 20} \
	.tl.bf.b_cancel {right expand padx 20 pady 20}
  grab .tl
  update idletasks
}

proc edit_options_ok {} {
  global DoubleClickTime OBST_code_path
  global tmpDCT tmpCODE
  set DoubleClickTime $tmpDCT
  if {(![file exists $tmpCODE]) || (![file isdirectory $tmpCODE])} {
    showmessage "directory $tmpCODE does not exist"
    return}
  set OBST_code_path $tmpCODE
  destroy .tl
}

proc show_help {} {
  global helpview env
  $helpview showHelp $env(USE_HELP_PATH)/Main.hf
}

proc show_info {} {
  toplevel .tl_infobox
  # Window manager configurations
  global tkVersion
  wm positionfrom .tl_infobox user
  wm sizefrom .tl_infobox program
  wm geometry .tl_infobox 352x287+405+267
  wm maxsize .tl_infobox 352 287
  wm minsize .tl_infobox 352 287
  wm title .tl_infobox {Information}
  wm protocol .tl_infobox WM_DELETE_WINDOW hide_info
  # build widget .tl_infobox.canvas5
  canvas .tl_infobox.canvas5 \
    -height {207}\
    -insertofftime {600}\
    -relief {raised}\
    -width {295}
  # build widget .tl_infobox.frame2
  frame .tl_infobox.frame2 \
    -borderwidth {2}\
    -relief {raised}
  # build widget .tl_infobox.frame2.button3
  button .tl_infobox.frame2.button3 \
    -command {hide_info}\
    -text {Ok}
  # pack widget .tl_infobox.frame2
  pack append .tl_infobox.frame2 \
    .tl_infobox.frame2.button3 {top frame center fillx} 
  # pack widget .tl_infobox
  pack append .tl_infobox \
    .tl_infobox.canvas5 {top frame center expand fill} \
    .tl_infobox.frame2 {bottom frame center fillx} 
  # build canvas items .tl_infobox.canvas5
  set xfTmpTag [.tl_infobox.canvas5 create text 165 50]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -font {-adobe-helvetica-bold-o-normal--34-240-100-100-p-182-iso8859-1}\
    -text {OBST}
  set xfTmpTag [.tl_infobox.canvas5 create text 165 90]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -font {-adobe-times-bold-i-normal--34-240-100-100-p-170-iso8859-1}\
    -text {Schemabrowser}
  set xfTmpTag [.tl_infobox.canvas5 create text 165 135]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -font {-adobe-times-bold-i-normal--25-180-100-100-p-128-iso8859-1}\
    -text {Version 1.2}

  set xfTmpTag [.tl_infobox.canvas5 create text 50 180]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -anchor w\
    -font {-adobe-courier-bold-r-normal--14-100-100-100-m-90-iso8859-1}\
    -text {authors:}
  set xfTmpTag [.tl_infobox.canvas5 create text 170 180]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -anchor w\
    -font {-adobe-courier-bold-r-normal--14-100-100-100-m-90-iso8859-1}\
    -text {Rainer Neumann}
  set xfTmpTag [.tl_infobox.canvas5 create text 170 200]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -anchor w\
    -font {-adobe-courier-bold-r-normal--14-100-100-100-m-90-iso8859-1}\
    -text {Christian Popp}

  set xfTmpTag [.tl_infobox.canvas5 create text 170 220]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -anchor w\
    -font {-adobe-courier-bold-r-normal--14-100-100-100-m-90-iso8859-1}\
    -text {Bernhard Schiefer}

  set xfTmpTag [.tl_infobox.canvas5 create text 50 240]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -anchor w\
    -font {-adobe-courier-bold-r-normal--14-100-100-100-m-90-iso8859-1}\
    -text {email:}
  set xfTmpTag [.tl_infobox.canvas5 create text 170 240]
  .tl_infobox.canvas5 itemconfigure $xfTmpTag\
    -anchor w\
    -font {-adobe-courier-bold-r-normal--14-100-100-100-m-90-iso8859-1}\
    -text {obst@fzi.de}
}

proc hide_info {} {
  if { [info command .tl_infobox] != "" } {
    destroy .tl_infobox
  }
}

proc writeColorTable { f } { 
  global OBST_Nodecolors OBST_Classeditorcolors  OBST_Classeditorfonts \
	 OBST_Importmodecolors
  foreach mode { color monochrome } {
    foreach class { Schema Classtype GenericClasstype GenericInst Typedeftype \
		  Uniontype Enumtype Externtype Externclass } {
      foreach state { normal modified selected sel_mod } {
        puts $f "$mode $class $state $OBST_Nodecolors($mode,OBST_${class}node,$state)"
      }
    }
  }
  foreach colortype { fixed normal light1 light2 high redef inher } {
     puts $f "Classeditorcolor $colortype $OBST_Classeditorcolors(color,$colortype)"
  }
  foreach fonttype { normal high } {
     puts $f "Classeditorfont $fonttype $OBST_Classeditorfonts($fonttype)"
  }

# --- erst mit modifiziertem Helpviewer wichtig !!
#  foreach Importmode { sos_IMP_NONE sos_IMP_TYPE sos_IMP_GENERIC sos_IMP_SUPERCLASS } {
#     puts $f "Importcolormode $Importmode $OBST_Importmodecolors($Importmode)"
#  }

}

proc readColorTable { f } {
  global OBST_Nodecolors OBST_Classeditorcolors OBST_Classeditorfonts \
	 OBST_Importmodecolors
  foreach mode { color monochrome } {
    foreach class { Schema Classtype GenericClasstype GenericInst Typedeftype \
		  Uniontype Enumtype Externtype Externclass } {
      foreach state { normal modified selected sel_mod } {
        set OBST_Nodecolors($mode,OBST_${class}node,$state) [lindex [gets $f] 3]
      }
    }
  }
  foreach colortype { fixed normal light1 light2 high redef inher } {
    set OBST_Classeditorcolors(color,$colortype) [lindex [gets $f] 2]
    set OBST_Classeditorcolors(monochrome,$colortype) black
  }
  foreach fonttype { normal high } {
    set OBST_Classeditorfonts($fonttype) [lindex [gets $f] 2]
  }

# --- erst mit modifiziertem Helpviewer wichtig !!
#  foreach Importmode { sos_IMP_NONE sos_IMP_TYPE sos_IMP_GENERIC sos_IMP_SUPERCLASS } {
#    set OBST_Importmodecolors($Importmode) [lindex [gets $f] 2]
#  }

}

proc writeGlobalVars { f } {
  global DoubleClickTime OBST_code_path
  puts $f "DoubleClickTime    $DoubleClickTime"
  puts $f "OBST_code_path     $OBST_code_path"
} 

proc readGlobalVars { f } {
  global DoubleClickTime OBST_code_path
  set DoubleClickTime    [lindex [gets $f] 1]
  set OBST_code_path     [lindex [gets $f] 1]
}

proc writeWindowPositions { f } {
  puts $f "main_window:  [wm geometry .]"
  puts $f "message_Box: [wm geometry .omb]"
}

proc readWindowPositions { f } {
  wm geometry .    [lindex [gets $f] 1]
  wm geometry .omb [lindex [gets $f] 1]
}

proc initmessagebox {} {
  global OBST_msg_str

  set OBST_msg_str ""

  toplevel .omb
  frame .omb.frame
  listbox .omb.frame.list -relief flat -yscroll ".omb.frame.vscroll set"
  scrollbar .omb.frame.vscroll -command ".omb.frame.list yview"\
		 -relief raised -orient vertic
 
  .omb.frame.list insert end $OBST_msg_str

  pack append .omb \
      .omb.frame {top fill}
  pack append .omb.frame .omb.frame.vscroll {right filly} \
      .omb.frame.list {top fill}

  wm title      .omb Messages
  wm sizefrom   .omb user
  wm minsize    .omb 100 100
  wm maxsize    .omb 1100 200
  wm geometry   .omb 400x100-0-0
  wm protocol .omb WM_DELETE_WINDOW "destroy .omb"
}

proc showmessage { msg } {
    .omb.frame.list insert end "$msg"
    .omb.frame.list yview [expr [.omb.frame.list size]-5]  
  update idletasks
}

proc initialize {} {
  global OBST_Colormode
  initmessagebox
  set OBST_Colormode [tk colormodel . ]
  set filename "~/.OBST-Schemabrowser.Defaults"
  if { [file exists $filename] } {
    set f [open $filename r]
    readGlobalVars $f
    readWindowPositions $f
    readColorTable $f
    close $f
  }
  set filename "~/.USE"
  if { ![file exists $filename] } {
    set f [open $filename w]
    close $f
    set user [exec whoami]
    set host [exec uname -a]
    set date [exec date]
    set msg "
 The OBST-Team is interested in the usage of OBST and USE by their
 clients, i.e. we are interested in things like \"How many clients?\" or
 \"Which platforms?\".  Therefore, we have integrated this small
 registration procedure into USE.  The registration will only appear
 for the first time a user is starting USE.
  
 Please send us an e-mail for registration by pressing the button
 \"Send notification\". You can find the contents of the automatically
 generated mail at the bottom of this window. A copy of this mail will
 be send to you.

 We emphasize that there are NO OBLIGATIONS ON YOU AFTER
 REGISTRATION. We are just interested in the number of users of our
 system. If you cannot accept this harmless procedure, please press
 the \"Cancel\" button. USE will work without notification, but this
 would confuse our statistics.

 Thanks a lot,

 The OBST Team

 -----------  Automatic Mail:   -----------

 USE-1.0
 user          = $user
 platform    = $host
 date          = $date"

    [TwoButtonDialog::create "" "Notification" $msg " Send notification " "       Cancel      " generate_mail ""] show
  }
}

proc generate_mail {} {
  system {(echo 'USE-1.0'; echo -n 'user        = '; whoami; echo -n 'platform    = '; uname -a; echo -n 'date        = '; date) | mail -s 'new USE user' obst@fzi.de "`whoami`"}
}

wm title        . " USE OBST "
wm geometry     . 300x36+440+350
wm positionfrom . user
wm sizefrom     . user
wm maxsize      . 350 36
wm minsize      . 300 36

button .b_exit -height 2 -text {  EXIT  }  -command { exit_USE }
button .b_schemas	 -text { SCHEMAS } -command { open_schema_browser }
button .b_views		 -text { VIEWS }   -command { open_views_browser }
button .b_optn		 -text { OPTIONS } -command { edit_options }
button .b_help		 -text {  HELP  }  -command { show_help }
button .b_info		 -text {  INFO  }  -command { show_info }
pack append . \
  .b_exit	{ left filly } \
  .b_schemas	{ left filly } \
  .b_views	{ left filly } \
  .b_optn	{ left filly } \
  .b_help	{ left filly } \
  .b_info	{ left filly } 

  set USE_hidden {}

 bind . <Map> {
     foreach w $USE_hidden {
        if {[winfo exists $w]} {
	   if {[wm state $w] != "normal"} {
	      set pf [wm positionfrom $w]
	      wm positionfrom $w user
	      wm deiconify $w
	      wm positionfrom $w $pf}}}}
 bind . <Unmap> {
     set USE_hidden {}
     foreach w [winfo children .] {
	if {[winfo class $w] == "Toplevel" && [wm state $w] == "normal"} {
	   lappend USE_hidden $w
	   wm withdraw $w}}}


show_info
after 5000 hide_info

initialize
