/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#define OBST_IMP_STRINGOP
#define OBST_IMP_MALLOC
#include "obst_stdinc.h"

#include "obst_progstd.h"
#include "obst.h"
#include "smg.h"
#include "stf_err.h"
#include "trc_stf.h"
#include "stf_use.h"
#include "stf_yacc.h"

#define CATCH_SYSERRS	0


int main (int argc, char *argv[])
{  obst_init (argc, argv);

   T_INIT ("stf.out");

   sos_Bool do_compilation   = TRUE;
   sos_Bool gen_structurer   = TRUE;
   sos_Bool gen_flattener    = TRUE;
   sos_Bool store_persistent = FALSE;
   char     *grammar_name;
   int      exit_status = 1;

   for (int i=1; i<argc; i++)
   {  if (streql (argv[i], "-E"))
	 stf_echo_flag = 1;
      else if (streql (argv[i], "-NOSTR"))
	 gen_structurer = FALSE;
      else if (streql (argv[i], "-NOFLT"))
	 gen_flattener = FALSE;
      else if (streql (argv[i], "-P"))
         store_persistent = TRUE;
      else if (streql (argv[i], "-G"))
      {  do_compilation = FALSE;
	 i++;
	 grammar_name = argv[i];
      }
      else
	 break;
   }

   if (   (do_compilation     AND i != argc-1)
       OR (NOT do_compilation AND i != argc))
   {  err_raise (err_USE, err_STF_USAGE);
      return -1;
   }
#if CATCH_SYSERRS
   err_block
#endif
   {  stf_Grammar g;

      if (do_compilation)
      {  yyin = fopen (argv[argc-1], "r");
	 if (yyin == 0)
	 {  err_raise (err_USE, err_STF_NO_FILE, argv[argc-1]);
	    T_EXIT();
	    exit (1);
	 }

	 g = stf_compile (store_persistent);
         if (g != NO_OBJECT  AND  store_persistent)
	 {  sos_Object_Directory::set_wd_from_env();
	    sos_Directory wd = sos_Object_Directory::get_wd();
	    wd.container().open (WRITING, WAITING);
	    wd.insert (g.get_name(), g);
            wd.container().close ();
	 }
      }
      else
      {  sos_String gpath = sos_String::create (TEMP_CONTAINER, grammar_name);
	 if (grammar_name[0] == '/')
	 {  g = stf_Grammar::make (sos_Object_Directory::lookup (gpath));
	    if (g == NO_OBJECT)
	       err_raise (err_USE, err_STF_NO_GRAMMAR, grammar_name);
	 }
	 else
	 {  sos_Object_Directory::set_wd_from_env();
	    sos_Directory wd = sos_Object_Directory::get_wd();
	    g = stf_Grammar::make (wd [gpath]);
	    if (g == NO_OBJECT)
	       err_raise (err_USE, err_STF_NO_GRAMMAR, grammar_name);
	 }
      }

      if (g != NO_OBJECT)
      {  if (gen_structurer)
	    g.gen_structurer();
	 if (gen_flattener)
	    g.gen_flattener();
	 exit_status = 0;
      }
   }
#if CATCH_SYSERRS
   err_exception
      err_raise (err_USE, err_last_raised (), "stf");
   err_block_end
#endif

   T_EXIT();
   return exit_status;
}
