 /* --------------------------------------------------------------------------
  * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
  *
  * You can use and distribute this software under the terms of the license
  * version 1 you should have received along with this software.
  * If not or if you want additional information, write to
  * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
  * D-76131 Karlsruhe, Germany.
  * --------------------------------------------------------------------------
  */
%{
extern "C" int yyreject();
extern "C" int yylook();
#ifndef FLEX_SCANNER
extern "C" int yyinput();
#ifdef HAVE_YYWRAP
extern "C" int yywrap();
#endif
#endif
extern "C" int yyless(int);
extern "C" int yyback(int*, int);
extern "C" void yyoutput (int);
extern "C" void yyunput (int);
extern "C" YYSTYPE yylval;
extern "C" void yyecho();

%}

letter		[a-zA-Z_]
digit		[0-9]
diglet		[a-zA-Z_0-9]
string		\"([^\n\"]|\\\")*\"
name		{letter}({diglet})*
white_space	[ \012\n\t]
any		.

lexical_pattern {no_white_space}

%START comment
%%

"/*"				{yyecho(); BEGIN comment;}
<comment>[^\n*]*\n		{yyecho();}
<comment>[^\n*]*"*/"		{yyecho(); BEGIN 0;}
<comment>[^\n*]*"*"		{yymore();}

"//"[^\n]*\n			{yyecho();}

"["				{yyecho(); return l_br_tok;}
"]"				{yyecho(); return r_br_tok;}
"{"				{yyecho(); return l_brc_tok;}
"}"				{yyecho(); return r_brc_tok;}
"("				{yyecho(); return l_par_tok;}
")"				{yyecho(); return r_par_tok;}
":"				{yyecho(); return colon_tok;}
","				{yyecho(); return comma_tok;}
"/"				{yyecho(); return div_tok;}
"*"				{yyecho(); return mult_tok;}
"+"				{yyecho(); return plus_tok;}
">>"				{yyecho(); return rshift_tok;}
";"				{yyecho(); return semicolon_tok;}

"class"				{yyecho(); return class_tok;}
"derive"			{yyecho(); return derive_tok;}
"error"				{yyecho(); return error_tok;}
"grammar"			{yyecho(); return grammar_tok;}
"lexical"			{yyecho(); return lexical_tok;}
"symbol"			{yyecho(); return symbol_tok;}
"with"				{yyecho(); return with_tok;}

{name}				{yyecho();
				 yylval.String =
				    smg_String ((char*)yytext).make_String (cnt);
			 	 return stf_Name_tok;}
{string}			{yyecho();
				 foldCstring ((char*)yytext);
				 yylval.String =
				    smg_String ((char*)yytext).make_String (cnt);
			 	 return stf_String_tok;}
{white_space}			{yyecho();}
{any}				{yyecho();
				 stf_error (err_USE, err_STF_LEXICAL_ERROR);}
