/* --------------------------------------------------------------------------
 * Copyright 1992-1993 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
#define OBST_IMP_STREAM
#include "obst_stdinc.h"

#include "obst.h"
#include "dir_obst.h"

sos_Cstring  names[] = { "stf_grammars", "stf_sample" };
const int    nsize   = sizeof(names) / sizeof(sos_Cstring);

main (int argc, char *argv[])
{  obst_init (argc, argv);

   if (ROOT_CONTAINER.open(WRITING,TESTING) != OPENED)
   {  cerr << "*** cannot open ROOT_CONTAINER for writing\n";
      return 1;
   }
   sos_Directory rootdir = sos_Directory::root();
   sos_String	 dirname = sos_String::create(TEMP_CONTAINER);

   for (int i = 0;  i < nsize;  ++ i)
   {  dirname.assign_Cstring (names[i]);
      
      if (rootdir.is_key(dirname))
         cout << "entry \"/" << names[i] << "\" does already exist\n";
      else
      {  sos_Directory new_dir = sos_Directory::create(ROOT_CONTAINER,dirname); 
	 rootdir.insert(dirname,new_dir);
	 cout << "inserted new sos_Directory \"/" << names[i] << "\"\n";
      }
   }
   ROOT_CONTAINER.close();

   return 0;
}
