%{
/* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * version 1 you should have received along with this software.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 *
 * The license covers the source file scp.l and those parts of scp.l that are
 * copied into a file generated from scp.l.
 * --------------------------------------------------------------------------
 */
extern "C"
{
#ifndef FLEX_SCANNER 
#  ifdef HAVE_YYWRAP 
int yywrap();
#  endif
#endif
   int yyreject();
   int yyless(int);
   int yyback(int*, int);
   int yyinput();
   static int yylook(); 
   void yyoutput (int);
   void yyunput (int);
   void yyecho();
   extern YYSTYPE yylval;
}

#define RETURN yylval.c = obst_strdup (yytext); return
%}

letter		([a-zA-Z_])
digit		([0-9])
diglet		([a-zA-Z_0-9])

line_comment	("//"[^\n]*)
comment_start	("/*")
comment_line	([^\n*]*\n)
comment_end	([^\n*]*"*/")
comment_part	([^\n*]*"*")
preproc_line	([^\n]*\\)$
preproc_end	([^\n]*[^\\])$
preproc_start	^#

string		(\"([^\n\"]|\\\")*\")
char		('([^\n']*|"\'")')
name		({letter}{diglet}*)
number		({digit}{diglet}*)

white_space	([ 	\n\t\r]+)
any		.

%START comment
%START preproc
%%

{comment_start}			{yymore(); BEGIN comment;}
<comment>{comment_end}		{BEGIN 0; RETURN white_space_tok;}
<comment>{comment_end}		{RETURN white_space_tok;}
<comment>{comment_part}		{yymore();}
<comment>{comment_line}		{RETURN white_space_tok;}

{line_comment}			{RETURN white_space_tok;}

^#				{yymore(); BEGIN preproc;}
<preproc>{preproc_line}		{RETURN white_space_tok;}
<preproc>{preproc_end}		{BEGIN 0; RETURN white_space_tok;}

{string}			{RETURN string_tok;}
{char}				{RETURN char_tok;}
{number}			{RETURN number_tok;}

{white_space}			{RETURN white_space_tok;}
"{"				{RETURN l_brc_tok;}
"}"				{RETURN r_brc_tok;}
"::"				{RETURN double_colon_tok;}
";"				{RETURN semi_colon_tok;}
"("				{RETURN l_par_tok;}
")"				{RETURN r_par_tok;}
"["				{RETURN l_br_tok;}
"]"				{RETURN r_br_tok;}
"."				{RETURN dot_tok;}
","				{RETURN comma_tok;}
"="				{RETURN equal_tok;}
"<"				{RETURN operator_string_tok;}
">"				{RETURN operator_string_tok;}
">>"				{RETURN operator_string_tok;}
"<<"				{RETURN operator_string_tok;}
"&"				{RETURN operator_string_tok;}
"&="				{RETURN operator_string_tok;}
"&&"				{RETURN operator_string_tok;}
"|"				{RETURN operator_string_tok;}
"|="				{RETURN operator_string_tok;}
"^"				{RETURN operator_string_tok;}
"^="				{RETURN operator_string_tok;}
"=="				{RETURN operator_string_tok;}
"!"				{RETURN operator_string_tok;}
">="				{RETURN operator_string_tok;}
"<="				{RETURN operator_string_tok;}
"-"				{RETURN operator_string_tok;}
"-="				{RETURN operator_string_tok;}
"!="				{RETURN operator_string_tok;}
"||"				{RETURN operator_string_tok;}
"%"				{RETURN operator_string_tok;}
"%="				{RETURN operator_string_tok;}
"+"				{RETURN operator_string_tok;}
"+="				{RETURN operator_string_tok;}
">>="				{RETURN operator_string_tok;}
"<<="				{RETURN operator_string_tok;}
"/"				{RETURN operator_string_tok;}
"/="				{RETURN operator_string_tok;}
"*"				{RETURN operator_string_tok;}
"*="				{RETURN operator_string_tok;}

"operator"			{RETURN operator_tok;}
"self"				{RETURN self_tok;}

{name}				{RETURN name_tok;}

{any}				{RETURN special_tok;}
