#line 1 "./src/prot/prot_history.C"
 /* --------------------------------------------------------------------------
 * Copyright 1992-1994 by Forschungszentrum Informatik (FZI)
 *
 * You can use and distribute this software under the terms of the license
 * you should have received along with this program.
 * If not or if you want additional information, write to
 * Forschungszentrum Informatik, "STONE", Haid-und-Neu-Strasse 10-14,
 * D-76131 Karlsruhe, Germany.
 * --------------------------------------------------------------------------
 */
/* OBST LIBRARY MODULE */
// **************************************************************************
// Module prot                   13-Aug-1993	       Bernhard Schiefer (bs)
// **************************************************************************
// implements methods of all classes declared in schema "prot"
// **************************************************************************

#include "obst_progstd.h"
#include "obst.h"
#include "smg.h"
#include "trc_prot.h"

#include "dir_obst.h"
// dir_obst.h must be included instead of dir_use.h, since scp "optimizes"
// the call to sos_Object_Directory::root to _sos_Object_Directory::root.

#include "prot_obst.h"
#include "mta_obst.h"

// -------------------------------------------------------------------------
// Auxiliary Functions
// -------------------------------------------------------------------------

LOCAL sos_Container_set open_cnts;

EXPORT sos_Container_set& prot_open_cnts()
{
   return open_cnts;
}

// -------------------------------------------------------------------------
// sos_ModifHistory
// -------------------------------------------------------------------------
// *************************************************************************
sos_ModifHistory _sos_ModifHistory::modif_history ()
// *************************************************************************
// leaves the status of the ROOT_CONTAINER unchanged
{  
   T_PROC("sos_ModifHistory::modif_history");
   TT(prot_H, T_ENTER);

   static sos_String rootname, entryname;
   static sos_Bool   need_init = TRUE;

   if (need_init)
   {
      rootname  = _sos_String::create (TEMP_CONTAINER, "sos_protocol");
      entryname = _sos_String::create (TEMP_CONTAINER, "sos_ModifHistory");
      need_init = FALSE;
   }

   sos_Container_status root_status = ROOT_CONTAINER.status();
   sos_Bool write_open = sos_Bool(root_status == WRITEABLE);
   sos_Bool read_open  = sos_Bool((root_status == WRITEABLE) OR
                                  (root_status == READABLE));

   if (NOT read_open) ROOT_CONTAINER.open (READING, WAITING);
 
   sos_Directory root_dir  = _sos_Object_Directory::root();
   sos_Directory modif_dir = sos_Object_Directory::make(root_dir[rootname]);
   if (INVALID(modif_dir))
   {
      sos_Container cnt = sos_Container::create();
      modif_dir = sos_Object_Directory::create(cnt, rootname);  
      cnt.close();
     
      if (NOT write_open) ROOT_CONTAINER.access (WRITING, WAITING);
      root_dir.insert (rootname, modif_dir);
      if (NOT write_open) ROOT_CONTAINER.access (READING, WAITING);
   }
       
   sos_ModifHistory  history  = sos_ModifHistory::make (modif_dir[entryname]);
 
   if (INVALID(history))
   {
      sos_Container cnt = modif_dir.container();
      cnt.open(WRITING, WAITING);
      history = sos_ModifHistory::create (cnt);
     
      modif_dir.insert (entryname, history);
      cnt.close();
   }

   if (NOT read_open) ROOT_CONTAINER.close();

   TT(prot_H, T_LEAVE);
   return history;
}

// *************************************************************************
void _sos_ModifHistory::local_initialize (OBST_PARDECL(sos_ModifHistory) mh)
// *************************************************************************
{
   T_PROC("sos_ModifHistory::local_initialize");
   TT(prot_M, T_ENTER);

   sos_Container cnt = mh.container();

   mh.set_history(sos_Schema_module_sos_SchemaHistory_Mapping::create(cnt));
   mh.set_garbage(sos_Version_sos_Object_List_Mapping::create(cnt));
   mh.set_not_gen_prot(sos_Schema_module_Set::create(cnt));
   mh.set_version(0);
   mh.set_active(FALSE);

   TT(prot_M, T_LEAVE);
}

// *************************************************************************
void _sos_ModifHistory::end_work ()
// *************************************************************************
{
   T_PROC("sos_ModifHistory::end_work");
   TT(prot_H, T_ENTER);

   sos_Container_set &cs = prot_open_cnts();
   sos_Container     cnt;
   
   cnt_iterate (cs, cnt);
   {
       cnt.close();
   } cnt_iterate_end (cs, cnt);

   cs.clear();

   TT(prot_H, T_LEAVE);
}

// *************************************************************************
void _sos_ModifHistory::trash (OBST_PARDECL(sos_Object) obj)
// *************************************************************************
{
   T_PROC("sos_ModifHistory::trash");
   TT(prot_M, T_ENTER);

   static sos_ModifHistory mh = _sos_ModifHistory::modif_history();

   sos_Container     obj_cnt = obj.container();
   sos_Type	     obj_tp  = obj.type();
   sos_Schema_module sm	     = _sos_Schema_module::retrieve(obj_cnt);
   if (mh.get_not_gen_prot().is_element(sm))
   {
      // For sos_Schema_module objects also destroy the container
      obj.destroy();
      if (obj_tp == sos_Schema_module_type)
	 obj_cnt.destroy();
   }
   else
   {
      sos_Version   ver   = mh.act_version();
      sos_Container m_cnt = mh.container();
      m_cnt.open(WRITING,WAITING);

      sos_Object_List list = mh.get_garbage()[ver];
      list.append(obj);
      m_cnt.close();
   }

   TT(prot_M, T_LEAVE);
}

// *************************************************************************
sos_Bool _sos_ModifHistory::trash_destroy (sos_Version ver)
// *************************************************************************
{
   T_PROC("sos_ModifHistory::trash_destroy");
   TT(prot_H, T_ENTER);

   TT(prot_H, T_LEAVE);
   return TRUE;
}

// *************************************************************************
void _sos_ModifHistory::set_gen_prot(OBST_PARDECL(sos_Schema_module) sc, sos_Bool prot_on)
// *************************************************************************
{
   T_PROC("sos_ModifHistory::set_gen_prot");
   TT(prot_H, T_ENTER);

   static sos_ModifHistory mh = _sos_ModifHistory::modif_history();

   sos_Container m_cnt = mh.container();
   m_cnt.open(WRITING,WAITING);

   if (prot_on)
      mh.get_not_gen_prot().remove(sc);
   else
      mh.get_not_gen_prot().insert(sc);

   m_cnt.close();

   TT(prot_H, T_LEAVE);
}

// *************************************************************************
sos_Version _sos_ModifHistory::act_version (const sos_Typed_id&_OBSThis)
// *************************************************************************
const{
   T_PROC("sos_ModifHistory::act_version");
   TT(prot_M, T_ENTER);

   sos_Version     ver;
   sos_Object_List trash_list;
   sos_Container   m_cnt;

   ver = get_version(_OBSThis);

   if (!get_active(_OBSThis))       
   { 
      m_cnt = _OBSThis.container();
      m_cnt.open(WRITING,WAITING);

      ver++;
      set_version(_OBSThis,ver);
      set_active(_OBSThis,TRUE); 

      trash_list = sos_Object_List::create(_OBSThis.container());
      get_garbage(_OBSThis).insert(ver, trash_list);

      m_cnt.close();
   }
   
   TT(prot_M, T_LEAVE);
   return ver;
} 

// *************************************************************************
void _sos_ModifHistory::end_version (const sos_Typed_id&_OBSThis)
// *************************************************************************
const{
   T_PROC("sos_ModifHistory::end_version");
   TT(prot_H, T_ENTER);

   sos_Container m_cnt = _OBSThis.container();

   m_cnt.open(WRITING, WAITING);
   set_active(_OBSThis,FALSE);       
   m_cnt.close();

   TT(prot_H, T_LEAVE);
}


// -------------------------------------------------------------------------
// sos_SchemaHistory
// -------------------------------------------------------------------------
// *************************************************************************
void _sos_SchemaHistory::local_initialize (OBST_PARDECL(sos_SchemaHistory) sh)
// *************************************************************************
{
   T_PROC("sos_SchemaHistory::local_initialize");
   TT(prot_M, T_ENTER);

   sos_Container cnt = sh.container();
 
   sh.set_schema_modifs(sos_Version_sos_SchemaModif_Mapping::create(cnt, TRUE));
   sh.set_class_modifs (sos_Class_type_sos_VCM_List_Mapping::create(cnt, TRUE));

   TT(prot_M, T_LEAVE);
}

// *************************************************************************
void _sos_SchemaHistory::local_finalize (OBST_PARDECL(sos_SchemaHistory) sh)
// *************************************************************************
{
   T_PROC("sos_SchemaHistory::local_finalize");
   TT(prot_M, T_ENTER);

   sos_ModifHistory mh    = _sos_ModifHistory::modif_history();
   sos_Container    m_cnt = mh.container(); 

   sos_Schema_module_sos_SchemaHistory_Mapping sh_map;
   sos_Schema_module  sc;
   sos_SchemaHistory  shist;
   sos_Schema_module  finsc = sos_Schema_module::make(NO_OBJECT);
 
   sos_Version_sos_SchemaModif_Mapping sm_map;
   sos_Version                         ver;
   sos_SchemaModif                     sm;

   sos_Class_type_sos_VCM_List_Mapping cm_map;
   sos_Class_type 		       ct;
   sos_VCM_List 		       cm_list;


   // remove SchemaHistory from ModifHistory
   sh_map = mh.get_history();
  
   agg_iterate_association(sh_map, sc, shist)
   {
      if (shist == sh)
      {  finsc = sc;
         break;
      }
   }agg_iterate_association_end(sh_map, sc, shist);

   if (VALID(finsc))
   { 
      m_cnt.open(WRITING, WAITING);
      sh_map.remove(finsc);
      m_cnt.close();
   }

   // remove SchemaModifs
   sm_map = sh.get_schema_modifs();
   
   agg_iterate_association(sm_map, ver, sm)
   {
      sm.destroy();
   }agg_iterate_association_end(sm_map, ver, sm);

   sm_map.destroy();


   // remove ClassModif_Mapping
   cm_map = sh.get_class_modifs();
  
   agg_iterate_association(cm_map, ct, cm_list)
   {
     cm_list.destroy();
   } agg_iterate_association_end(cm_map, ct, cm_list);

   cm_map.destroy();

   TT(prot_M, T_LEAVE);
}
